;
;   1541EMU, the Commodore 1541 disk drive emulator
;   Copyright (C) 2001-2002 Ville Muikkula
;   Copyright (C) Karsten Scheibler
;
;  This file was formerly part of ec64, the Commodore 64 emulator for Linux.
;  Written by
;   Karsten Scheibler <karsten.scheibler@bigfoot.de>
;  Modifications by
;   Ville Muikkula <1541@surfeu.fi>
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License version 2 as
;   published by the Free Software Foundation.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;****************************************************************************
;****************************************************************************
;*
;* defines.i
;*
;****************************************************************************
;****************************************************************************





%ifndef DEFINES_I
%define DEFINES_I




;****************************************************************************
;****************************************************************************
;*
;* PART 1: global settings
;*
;****************************************************************************
;****************************************************************************


PIC1            EQU  020h
PIC2            EQU  0A0h
KEYB_PORT       EQU  60h
NONSPECIFIC_EOI EQU  20h


%assign C1541_CLOCK             1000000  ;Hz
%assign DISC_CHANGE_DELAY 100000

%assign NULL		0
%assign NOT8		0ffh
%assign NOT16		0ffffh
%assign NOT32		0ffffffffh




;****************************************************************************
;****************************************************************************
;*
;* PART 2.1: module settings
;*
;****************************************************************************
;****************************************************************************





;%define CORE_ENABLE_BP

;%define C64MEMORY_ASSERTION
;%define C64MEMORY_ASSERTION_STACK

;%define CPU65XX_DISABLE_ILLEGAL_OPCODES
;%define CPU65XX_USE_RESET_ADDRESS			01000h
;%define CPU65XX_ENABLE_BP

;%define VIC6569_DISABLE_SELECTIVE_DECODING
%define VIC6569_DISABLE_LINEWISE_DECODING
%define VIC6569_ASSERTION
%define VIC6569_ASSERTION_CHANGE_LOG_WRITE
%define VIC6569_ASSERTION_CHANGE_LOG_OVERFLOW
%define VIC6569_ASSERTION_DECODE_LINE_COUNTER

;%define C1541MEMORY_ASSERTION
;%define C1541MEMORY_ASSERTION_STACK
;%define C1541MEMORY_ASSERTION_KERNEL





;****************************************************************************
;****************************************************************************
;*
;* PART 2.2: process the global settings
;*
;****************************************************************************
;****************************************************************************





%ifdef EC64_ENABLE_BP_SUPPORT
%define CORE_ENABLE_BP
%define CPU65XX_ENABLE_BP
%else
%undef CORE_ENABLE_BP
%undef CPU65XX_ENABLE_BP
%endif

%endif
