;
;   1541EMU, the Commodore 1541 disk drive emulator
;   Copyright (C) 2001-2002 Ville Muikkula
;   Copyright (C) Karsten Scheibler
;
;  This file was formerly part of ec64, the Commodore 64 emulator for Linux.
;  Written by
;   Karsten Scheibler <karsten.scheibler@bigfoot.de>
;  Modifications by
;   Ville Muikkula <1541@surfeu.fi>
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License version 2 as
;   published by the Free Software Foundation.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;****************************************************************************
;****************************************************************************
;*
;* disc.i
;*
;****************************************************************************
;****************************************************************************





%ifndef DISC_I
%define DISC_I

%include "defines.i"
%include "macros.i"
%include "ec64types.i"
%include "core/disc.i"

;****************************************************************************
;* Exported Symbols *********************************************************
;****************************************************************************
%ifdef DISC_N
global disc_initialize
global disc_exit
global disc_instance_initialize
global disc_instance_exit
global disc_reset_hard
global disc_reset_soft
global disc_signal_data
global disc_signal_rw
global disc_signal_byte_ready
global disc_signal_head
global disc_signal_speed
global disc_load_gcr
global disc_cycle
%else
extern disc_initialize
extern disc_exit
extern disc_instance_initialize
extern disc_instance_exit
extern disc_reset_hard
extern disc_reset_soft
extern disc_signal_data
extern disc_signal_rw
extern disc_signal_byte_ready
extern disc_signal_head
extern disc_signal_speed
extern disc_load_gcr
extern disc_cycle
%endif

%assign DISC_LAST_TRACK		84
%assign NUM_MAX_BYTES_TRACK 7928
%assign DISC_GCR_IMAGE_SIZE	(DISC_LAST_TRACK) * NUM_MAX_BYTES_TRACK


;****************************************************************************
;* Module Data **************************************************************
;****************************************************************************
				struc	tdisc
				alignb	4
d__disc_modulid:		resd	1
d__disc_state:			resd	1
d__disc_cycles_per_track:	resd	1
d__disc_bytes_per_track:	resd	1
b__disc_cycles_per_byte:        resb    1
d__disc_cycle_counter:		resd	1
d__disc_track_offset:		resd	1
ad__disc_speed_table:		resd	4
ab__disc_density_table:         resd    4
b__disc_track:			resb	1
b__disc_data_byte:		resb	1
b__disc_last_byte:		resb	1
b__disc_head_position:		resb	1
;ab__disc_gcr_image:		resb	DISC_GCR_IMAGE_SIZE
				endstruc



;****************************************************************************
;* assign's & defines's *****************************************************
;****************************************************************************
%define DISC_MODULID		esi + tdisc__c1541 + d__disc_modulid
%define DISC_STATE		esi + tdisc__c1541 + d__disc_state
%define DISC_CYCLES_PER_TRACK	esi + tdisc__c1541 + d__disc_cycles_per_track
%define DISC_BYTES_PER_TRACK	esi + tdisc__c1541 + d__disc_bytes_per_track
%define DISC_CYCLES_PER_BYTE    esi + tdisc__c1541 + b__disc_cycles_per_byte
%define DISC_CYCLE_COUNTER	esi + tdisc__c1541 + d__disc_cycle_counter
%define DISC_TRACK_OFFSET	esi + tdisc__c1541 + d__disc_track_offset
%define DISC_SPEED_TABLE	esi + tdisc__c1541 + ad__disc_speed_table
%define DISC_DENSITY_TABLE      esi + tdisc__c1541 + ab__disc_density_table
%define DISC_TRACK		esi + tdisc__c1541 + b__disc_track
%define DISC_DATA_BYTE		esi + tdisc__c1541 + b__disc_data_byte
%define DISC_LAST_BYTE		esi + tdisc__c1541 + b__disc_last_byte
%define DISC_HEAD_POSITION	esi + tdisc__c1541 + b__disc_head_position
%define DISC_GCR_IMAGE		esi + tdisc__c1541 + ab__disc_gcr_image



;****************************************************************************
;* Macro's ******************************************************************
;****************************************************************************
%macro DISC_CALL_INITIALIZE 0
			call	disc_initialize
%endmacro



%macro DISC_CALL_INSTANCE_INITIALIZE 1
			call	disc_instance_initialize
			mov	dword eax, %1
			mov	dword [DISC_MODULID], eax
%endmacro



%macro DISC_CALL_RESET_HARD 0
			call	disc_reset_hard
%endmacro



%macro DISC_CALL_RESET_SOFT 0
			call	disc_reset_soft
%endmacro



%macro DISC_CALL_CYCLE 0
			mov	dword eax, [DISC_CYCLE_COUNTER]
                        cmp     byte al, [DISC_CYCLES_PER_BYTE]
                        jb      %%skip_cycle
                        mov     byte [DISC_CYCLE_COUNTER], 0
                        call    disc_cycle
%%skip_cycle:           inc     byte [DISC_CYCLE_COUNTER]

;			mov	dword eax, [DISC_CYCLE_COUNTER]
;			cmp	dword eax, [DISC_CYCLES_PER_TRACK]
;			jb	%%skip_cycle
;			sub	dword eax, [DISC_CYCLES_PER_TRACK]
;			push	dword eax
;			call	disc_cycle
;			pop	dword eax
;%%skip_cycle:		add	dword eax, [DISC_BYTES_PER_TRACK]
;			mov	dword [DISC_CYCLE_COUNTER], eax
%endmacro



%endif
;********************************************* karsten.scheibler@bigfoot.de *

