;
;   1541EMU, the Commodore 1541 disk drive emulator
;   Copyright (C) 2001-2002 Ville Muikkula
;   Copyright (C) Karsten Scheibler
;
;  This file was formerly part of ec64, the Commodore 64 emulator for Linux.
;  Written by
;   Karsten Scheibler <karsten.scheibler@bigfoot.de>
;  Modifications by
;   Ville Muikkula <1541@surfeu.fi>
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License version 2 as
;   published by the Free Software Foundation.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;****************************************************************************
;****************************************************************************
;*
;* disc.n
;*
;****************************************************************************
;****************************************************************************



;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;TODO:
;* allow SYNC's also on non byte aligned positions
;* read rubbish, if the read speed differs from the write speed
;* include the mechanic characteristics of the step- and drivemotor
;  [delaycounter]
;* read rubbish if drivemotor is turned off
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


%define DISC_N
%include "main.i"
%include "disc.i"
%include "link.i"
%include "c1541lnk.i"
%include "core.i"
%include "drive.i"

;****************************************************************************
;* assign's & defines's *****************************************************
;****************************************************************************
%define MODULID                 DISC_MODULID
%define STATE                   DISC_STATE
%define CYCLES_PER_TRACK        DISC_CYCLES_PER_TRACK
%define BYTES_PER_TRACK         DISC_BYTES_PER_TRACK
%define CYCLES_PER_BYTE         DISC_CYCLES_PER_BYTE
%define CYCLE_COUNTER           DISC_CYCLE_COUNTER
%define TRACK_OFFSET            DISC_TRACK_OFFSET
%define SPEED_TABLE             DISC_SPEED_TABLE
%define DENSITY_TABLE           DISC_DENSITY_TABLE
%define LOAD_D64                DISC_LOAD_D64
%define TRACK                   DISC_TRACK
%define DATA_BYTE               DISC_DATA_BYTE
%define LAST_BYTE               DISC_LAST_BYTE
%define HEAD_POSITION           DISC_HEAD_POSITION
%define GCR_IMAGE               DISC_GCR_IMAGE

%assign DATA_RW_MODE            001h
%assign NO_BYTE_READY           002h
%assign SYNC_FOUND              004h


;****************************************************************************
;* disc_initialize **********************************************************
;****************************************************************************
section .text
disc_initialize:
                        ret



;****************************************************************************
;* disc_exit ****************************************************************
;****************************************************************************
section .text
disc_exit:
                        ret



;****************************************************************************
;* disc_instance_initialize *************************************************
;****************************************************************************
section .text
disc_instance_initialize:
                        INSTANCE_INITIALIZE  tdisc_size



;****************************************************************************
;* disc_instance_exit *******************************************************
;****************************************************************************
section .text
disc_instance_exit:
                        ret



;****************************************************************************
;* disc_reset_hard **********************************************************
;****************************************************************************
section .text
disc_reset_hard:
                        jmp     disc_reset_soft



;****************************************************************************
;* disc_reset_soft **********************************************************
;****************************************************************************
section .text
disc_reset_soft:
                        push    dword eax
                        push    dword ebx
                        push    dword ecx
                        mov     dword eax, C1541_CLOCK / 5      ;300rpm / 60 seconds = 5
                        mov     dword ebx, DISC_GCR_SPEED0_BYTES
                        mov     dword ecx, DISC_GCR_SPEED1_BYTES
                        mov     dword [CYCLES_PER_TRACK], eax
                        mov     dword [SPEED_TABLE], ebx
                        mov     dword [BYTES_PER_TRACK], ebx
                        mov     dword [SPEED_TABLE + 4], ecx
                        xor     dword eax, eax
                        mov     dword ebx, DISC_GCR_SPEED2_BYTES
                        mov     dword ecx, DISC_GCR_SPEED3_BYTES
                        mov     dword [SPEED_TABLE + 8], ebx
                        mov     dword [SPEED_TABLE + 12], ecx
                        mov     dword [STATE], eax
                        mov     dword [CYCLE_COUNTER], eax
                        mov     dword [TRACK_OFFSET], eax
                        mov     byte  [TRACK], al
                        mov     byte  [DATA_BYTE], al
                        mov     byte  [LAST_BYTE], al
                        mov     byte  [DENSITY_TABLE], 26
                        mov     byte  [DENSITY_TABLE+1], 28
                        mov     byte  [DENSITY_TABLE+2], 30
                        mov     byte  [DENSITY_TABLE+3], 32
                        mov     byte  [CYCLES_PER_BYTE], 26
                        pop     dword ecx
                        pop     dword ebx
                        pop     dword eax
                        ret



;****************************************************************************
;* disc_signal_data *********************************************************
;****************************************************************************
section .text
disc_signal_data:
                        mov     byte  [DATA_BYTE], al
                        ret



;****************************************************************************
;* disc_signal_rw ***********************************************************
;****************************************************************************
section .text
disc_signal_rw:
                        test    byte  al, 001h
                        jnz     .read
.write:                 or      dword [STATE], DATA_RW_MODE
                        ret
.read:                  and     dword [STATE], (NOT32 - DATA_RW_MODE)
                        ret



;****************************************************************************
;* disc_signal_byte_ready ***************************************************
;****************************************************************************
section .text
disc_signal_byte_ready:
                        test    byte  al, 001h
                        jz      .disable
.enable:                and     dword [STATE], (NOT32 - NO_BYTE_READY)
                        ret
.disable:               or      dword [STATE], NO_BYTE_READY
                        ret



;****************************************************************************
;* disc_signal_head *********************************************************
;****************************************************************************
section .text
disc_signal_head:
                        push    dword eax
                        and     byte  al, 3
                        mov     byte  ah, [HEAD_POSITION]
                        inc     byte  ah
                        and     byte  ah, 3
.compare_1:             cmp     byte  al, ah
                        jne     .compare_2
                        mov     byte  ah, [TRACK]
                        cmp     byte  ah, DISC_LAST_TRACK
                        je      .end
                        inc     byte  ah
                        mov     byte  [TRACK], ah
                        jmp     .end
.compare_2:             sub     byte  ah, 2
                        and     byte  ah, 3
                        cmp     byte  al, ah
                        jne     .end
                        mov     byte  ah, [TRACK]
                        cmp     byte  ah, 0
                        je      .end
                        dec     byte  ah
                        mov     byte  [TRACK], ah
.end:                   mov     byte  [HEAD_POSITION], al
                        pop     dword eax
                        ret



;****************************************************************************
;* disc_signal_speed ********************************************************
;****************************************************************************
section .text
disc_signal_speed:
                        push    dword eax
                        and     dword eax, 3
                        push    dword eax
                        mov     dword eax, [SPEED_TABLE + 4 * eax]
                        mov     dword [BYTES_PER_TRACK], eax
                        pop     dword eax
                        mov     byte al, [DENSITY_TABLE + eax]
                        mov     byte [CYCLES_PER_BYTE], al
                        pop     dword eax
                        ret





;****************************************************************************
;* disc_cycle ***************************************************************
;****************************************************************************
section .text
disc_cycle:
                        mov     dword eax, [STATE]
                        test    dword eax, (NO_BYTE_READY | SYNC_FOUND)
                        jnz     .no_byte_ready
                        call    cpu65xx_signal_set_overflow
.no_byte_ready:         xor     dword ebx, ebx
                        mov     dword ecx, [TRACK_OFFSET]
                        inc     dword ecx

                        push dword eax
                        push dword edx
                        movzx dword eax, byte [TRACK]
                        mov dword edx, NUM_MAX_BYTES_TRACK
                        mul dword edx
                        mov dword ebx, eax
                        pop dword edx
                        pop dword eax
                        cmp     dword ecx, [BYTES_PER_TRACK]
                        jb      .no_clear
                        xor     dword ecx, ecx
.no_clear:              add     dword ebx, ecx
                        mov     dword [TRACK_OFFSET], ecx
                        test    dword eax, DATA_RW_MODE
                        jz      .read
.write:                 and     dword eax, (NOT32 - SYNC_FOUND)
                        mov     dword [STATE], eax
                        test byte [_Global_Read_Only_Access], 1
                        jnz .wps_active
                        test byte [_Write_Protect_Sense], 1
                        jnz .wps_active
                        test byte [_Door_Open], 1
                        jnz .door_open
                        mov     byte  al, [DATA_BYTE]
                        mov     byte  [LAST_BYTE], al
                        push dword edx
                        mov dword edx, [_CURRENT_GCR_IMAGE]
                        mov     byte  [edx + ebx], al
                        pop dword edx

                        movzx   dword eax, byte [_disk_number]
                        mul byte [_disk_image_t_size]
                        add dword eax, _diskette
                        or      dword [eax], 1  ; GCR_dirty
.door_open:
.wps_active:
                        mov     byte  al, 1
                        call    c1541link_disc_sync
                        ret
.read:                  and     dword eax, (NOT32 - SYNC_FOUND)
                        mov     byte  cl, 1
                        test    byte [_Door_Open], 1
                        jz      .door_closed
                        mov     byte  bl, 0
                        jmp     .read_1
.door_closed:           push dword edx
                        mov dword edx, [_CURRENT_GCR_IMAGE]
                        mov     byte  bl, [edx + ebx]
                        pop dword edx
                        cmp     byte  bl, 0ffh
                        jne     .read_1
                        cmp     byte  [LAST_BYTE], 0ffh
                        jne     .read_1
                        or      dword eax, SYNC_FOUND
                        xor     byte  cl, cl
.read_1:                mov     dword [STATE], eax
                        mov     byte  al, [LAST_BYTE]
                        mov     byte  [LAST_BYTE], bl
                        call    c1541link_disc_data
                        mov     byte  al, cl
                        call    c1541link_disc_sync
                        ret
