/*
    1541EMU, the Commodore 1541 disk drive emulator
    Copyright (C) 2001-2002 Ville Muikkula
    Copyright (C) 1998-2000 Andreas Boose
 *
 * diskimage.h - Common low-level disk image access.
 *
 * This file was formerly part of VICE, the Versatile Commodore Emulator.
 * Written by
 *  Andreas Boose <boose@linux.rz.fh-hannover.de>
 * Modifications by
 *  Ville Muikkula <1541@surfeu.fi>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#ifndef _DISKIMAGE_H
#define _DISKIMAGE_H

#include <stdio.h>
#include <limits.h>
#include "types.h"

#define GCR_OFFSET(track, sector)  ((track - 1) * NUM_MAX_BYTES_TRACK \
                                    + sector * NUM_BYTES_SECTOR_GCR)

#define D64_FILE_SIZE_35  174848        /* D64 image, 35 tracks */
#define D64_FILE_SIZE_35E 175531        /* D64 image, 35 tracks with errors */
#define D64_FILE_SIZE_40  196608        /* D64 image, 40 tracks */
#define D64_FILE_SIZE_40E 197376        /* D64 image, 40 tracks with errors */

#define DISK_IMAGE_TYPE_G64 100
#define DISK_IMAGE_TYPE_D64 1541

#define BAM_TRACK_1541 18
#define NAME_1541     144       /* offset of the disk name in the BAM block */
#define ID_1541       162       /* offset of the disk id in the BAM block */


struct gcr_s;

typedef struct disk_image_s {
    unsigned int GCR_dirty;
    unsigned int read_only;
    struct gcr_s *gcr;
    FILE *fd;
    char *name;
    unsigned int type;
    unsigned int tracks;
    BYTE *error_info;
} disk_image_t;

extern int disk_image_open(disk_image_t *image);
extern int disk_image_close(disk_image_t *image);
extern int disk_image_create(const char *name,
                             const char *diskname,
                             const char *diskid,
                             unsigned int type);

extern int disk_image_read_sector(disk_image_t *image, BYTE *buf,
                                  unsigned int track, unsigned int sector);
extern int disk_image_write_sector(disk_image_t *image, BYTE *buf,
                                   unsigned int track, unsigned int sector);
extern int disk_image_check_sector(unsigned int format, unsigned int track,
                                   unsigned int sector);
extern int disk_image_sector_per_track(unsigned int format, unsigned int track);

extern int disk_image_read_gcr_image(disk_image_t *image);
extern int disk_image_write_track(disk_image_t *image, unsigned int track,
                                  int gcr_track_size,
                                  BYTE *gcr_speed_zone,
                                  BYTE *gcr_track_start_ptr);
extern unsigned int disk_image_speed_map_1541(unsigned int track);
#endif

