/*
    1541EMU, the Commodore 1541 disk drive emulator
    Copyright (C) 2001-2002 Ville Muikkula
    Copyright (C) 1998-2000 Andreas Boose
    Copyright (C) 1996-1999 Ettore Perazzoli
    Copyright (C) 1997-2000 Daniel Sladic
 *
 * drive.h - Hardware-level Commodore disk drive emulation.
 *
 * This file was formerly part of VICE, the Versatile Commodore Emulator.
 * Written by
 *  Andreas Boose <boose@linux.rz.fh-hannover.de>
 *  Daniel Sladic <sladic@eecg.toronto.edu>
 *  Ettore Perazzoli <ettore@comm2000.it>
 * Modifications by
 *  Ville Muikkula <1541@surfeu.fi>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
*/

#ifndef _DRIVE_H
#define _DRIVE_H

#include "types.h"
#include "main.h"

/*
 * Disk Drive Specs
 * For customized disks, the values must fit beteen the NUM_ and MAX_
 * limits. Do not change the NUM_ values, as they define the standard
 * disk geometry.
 */

#define NUM_TRACKS_1541        35
#define NUM_BLOCKS_1541        683      /* 664 free */
#define EXT_TRACKS_1541        40
#define EXT_BLOCKS_1541        768
#define MAX_TRACKS_1541        42
#define MAX_BLOCKS_1541        802
#define DIR_TRACK_1541         18
#define DIR_SECTOR_1541        1

#define DRIVE_ROM1541_SIZE          0x4000

#define DRIVE_ROM1540_MD5SUM       "87e849da3c87549848550fe4dd4d1aae"
#define DRIVE_ROM1541_R1_MD5SUM    "29c8952140550858d8108cda2d2ec985"
#define DRIVE_ROM1541_R2_MD5SUM    "78817a09891dc49cb451a70ae18b71a5"
#define DRIVE_ROM1541_R3_MD5SUM    "916bb933b21b9e8f4411d15727ec5d20"
#define DRIVE_ROM1541_R5_MD5SUM    "a0ce8439d1b8dcf2e1430461f7233a72"
#define DRIVE_ROM1541C_R1_MD5SUM   "a304cb0eb0354ba21751925dfb6dec11"
#define DRIVE_ROM1541C_R2_MD5SUM   "1e597a06d8b510fcd2a9ab077e930b41"
#define DRIVE_ROM1541_II_MD5SUM    "ada295382a1f2df772a7e5c5c6f34215"

#define DRIVE_ROMJIFFYDOS50_MD5SUM "1b1e985ea5325a1f46eb7fd9681707bf"
#define DRIVE_ROMJIFFYDOS50R_MD5SUM "f90a95894f8a7d37115bf1e9e0541f7c"

/* Drive type.  */
#define DRIVE_TYPE_1541   1541

/* Number of bytes in one raw sector.  */
#define NUM_BYTES_SECTOR_GCR 360

/* ------------------------------------------------------------------------- */

extern disk_image_t diskette[MAX_DISKS];

/* RAM/ROM.  */
extern BYTE drive_rom1541[];

extern int drive_init(void);
extern int drive_attach_image(struct disk_image_s *image);
extern int drive_detach_image(struct disk_image_s *image);
extern void drive_gcr_data_writeback(disk_image_t *image);

#endif

