/*
    1541EMU, the Commodore 1541 disk drive emulator
    Copyright (C) 2001-2002 Ville Muikkula
    Copyright (C) 1998-2000 Andreas Boose
    Copyright (C) 1997-2000 Daniel Sladic
 *
 * grc.h - GCR handling.
 *
 * This file was formerly part of VICE, the Versatile Commodore Emulator.
 * Written by
 *  Andreas Boose <boose@linux.rz.fh-hannover.de>
 *  Daniel Sladic <sladic@eecg.toronto.edu>
 * Modifications by
 *  Ville Muikkula <1541@surfeu.fi>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#ifndef _GCR_H
#define _GCR_H

#define BYTE unsigned char

/* Number of bytes in one raw track.  */
#define NUM_MAX_BYTES_TRACK 7928

/* Number of tracks we emulate.  */
#define MAX_GCR_TRACKS 84

typedef struct gcr_s {
    /* Raw GCR image of the disk.  */
    BYTE data[MAX_GCR_TRACKS * NUM_MAX_BYTES_TRACK];

    /* Speed zone image of the disk.  */
    BYTE speed_zone[MAX_GCR_TRACKS * NUM_MAX_BYTES_TRACK];

    /* Size of the GCR data of each track.  */
    unsigned int track_size[MAX_GCR_TRACKS];

} gcr_t;

extern void gcr_convert_4bytes_to_GCR(BYTE *buffer, BYTE *ptr);
extern void gcr_convert_GCR_to_4bytes(BYTE *buffer, BYTE *ptr);
extern void gcr_convert_sector_to_GCR(BYTE *buffer, BYTE *ptr,
                                      unsigned int track, unsigned int sector,
                                      BYTE diskID1, BYTE diskID2,
                                      BYTE error_code);
extern void gcr_convert_GCR_to_sector(BYTE *buffer, BYTE *ptr,
                                      BYTE *GCR_track_start_ptr,
                                      unsigned int GCR_current_track_size);

extern BYTE *gcr_find_sector_header(unsigned int track, unsigned int sector,
                                    BYTE *gcr_track_start_ptr,
                                    unsigned int gcr_current_track_size);
extern BYTE *gcr_find_sector_data(BYTE *offset,
                                  BYTE *gcr_track_start_ptr,
                                  unsigned int gcr_current_track_size);
extern int gcr_read_sector(BYTE *gcr_track_start_ptr,
                           unsigned int gcr_current_track_size, BYTE *readdata,
                           unsigned int track, unsigned int sector);
extern int gcr_write_sector(BYTE *gcr_track_start_ptr,
                            unsigned int gcr_current_track_size,
                            BYTE *writedata,
                            unsigned int track, unsigned int sector);

extern gcr_t *gcr_create_image(void);
extern void gcr_destroy_image(gcr_t *gcr);
#endif

