#include <go32.h>
#include <dos.h>
#include <sys/farptr.h>
#include "main.h"
#include "intserv.h"
#include "timing.h"

int Detect_LPT_IRQ(unsigned char *IRQ,
                   unsigned char *trigger_type,
                   unsigned char *active_edge)
{
        __dpmi_version_ret dpmi_info;
        unsigned long i, j;
        unsigned char old_IMR_PIC1;
        unsigned char old_IMR_PIC2;
        _go32_dpmi_seginfo OldISR[16], NewISR;
        __dpmi_paddr old_LPT_vector;
        unsigned char PIC_mask;
        
        __dpmi_get_version(&dpmi_info);
        
        disable();
        for (i=3; i<8; i++)
        {
                _go32_dpmi_get_protected_mode_interrupt_vector(
                        dpmi_info.master_pic+i, &OldISR[i]);
                        
                NewISR.pm_offset = ISR_addresses[i];
                NewISR.pm_selector = _go32_my_cs();
                _go32_dpmi_chain_protected_mode_interrupt_vector(
                        dpmi_info.master_pic+i,&NewISR);
        }
        for (i=9; i<13; i++)
        {
                _go32_dpmi_get_protected_mode_interrupt_vector(
                        dpmi_info.slave_pic+i-8, &OldISR[i]);
                        
                NewISR.pm_offset = ISR_addresses[i];
                NewISR.pm_selector = _go32_my_cs();
                _go32_dpmi_chain_protected_mode_interrupt_vector(
                        dpmi_info.slave_pic+i-8,&NewISR);
        }
        for (i=14; i<16; i++)
        {
                _go32_dpmi_get_protected_mode_interrupt_vector(
                        dpmi_info.slave_pic+i-8, &OldISR[i]);
                        
                NewISR.pm_offset = ISR_addresses[i];
                NewISR.pm_selector = _go32_my_cs();
                _go32_dpmi_chain_protected_mode_interrupt_vector(
                        dpmi_info.slave_pic+i-8,&NewISR);
        }

        inportb(LPT_IO+1);
        outportb(LPT_IO+2, inportb(LPT_IO+2) | Enable_IRQ);
        old_IMR_PIC1 = inportb(PIC1+1);
        old_IMR_PIC2 = inportb(PIC2+1);
        outportb(PIC1+1, 0);
        outportb(PIC2+1, 0);
        enable();

        for (i=0; i<10; i++)
        {
                outportb(LPT_IO+2, inportb(LPT_IO+2) ^ 2);
                for (j=0; j<5; j++) inportb(LPT_IO); // delay
                outportb(LPT_IO+2, inportb(LPT_IO+2) ^ 2);
                for (j=0; j<5; j++) inportb(LPT_IO); // delay
                for (j=0; j<16; j++)
                        if (num_IRQ[j]!=i+1) ok_IRQ[j]=0;
        }
        disable();
        outportb(PIC1+1, old_IMR_PIC1);
        outportb(PIC2+1, old_IMR_PIC2);

        for (i=3; i<8; i++)
                _go32_dpmi_set_protected_mode_interrupt_vector(
                        dpmi_info.master_pic+i,&OldISR[i]);
                        
        for (i=9; i<13; i++)
                _go32_dpmi_set_protected_mode_interrupt_vector(
                        dpmi_info.slave_pic+i-8,&OldISR[i]);
                        
        for (i=14; i<16; i++)
                _go32_dpmi_set_protected_mode_interrupt_vector(
                        dpmi_info.slave_pic+i-8,&OldISR[i]);

        j=0;
        for (i=0; i<16; i++)
        {
                if (ok_IRQ[i]==1)
                {
                        *IRQ=i;
                        j++;
                }
        }

        if (j==1)
        {
                if (*IRQ <= 7)
                        install_ISR(dpmi_info.master_pic+*IRQ,
                            (void *)Check_Trigger_Type_ISR, &old_LPT_vector);

                else
                        install_ISR(dpmi_info.slave_pic+*IRQ-8,
                            (void *)Check_Trigger_Type_ISR, &old_LPT_vector);

                PIC_mask = 1;
                if (*IRQ <= 7)
                {
                        PIC_mask = PIC_mask << *IRQ;
                        outportb(PIC1+1, ~PIC_mask);
                }
                else
                {
                        PIC_mask = PIC_mask << (*IRQ-8);
                        outportb(PIC1+1, ~4);
                        outportb(PIC2+1, ~PIC_mask);
                }

                enable();
                *trigger_type = 0;
                outportb(LPT_IO+2, inportb(LPT_IO+2) ^ 2);
                inportb(LPT_IO+2); // delay
                outportb(LPT_IO+2, inportb(LPT_IO+2) ^ 2);
                while (trigtype>1);
                *trigger_type = trigtype;
                *active_edge = actedge;
                disable();
                if (*IRQ <= 7)
                         remove_ISR(dpmi_info.master_pic+*IRQ,
                             &old_LPT_vector);
                else
                         remove_ISR(dpmi_info.slave_pic+*IRQ-8,
                             &old_LPT_vector);

                outportb(PIC1+1, old_IMR_PIC1);
                outportb(PIC2+1, old_IMR_PIC2);
        }

        outportb(LPT_IO+2, inportb(LPT_IO+2) & ~Enable_IRQ);
        enable();
        if (j!=1) return 0;
        else return 1;
}


int Detect_Cable(unsigned short *io, unsigned char *type)
{
        int i = 0;
        int io_addr;
        unsigned char data;
        int detected = 0;
        
        do
        {
                io_addr = _farpeekw(_dos_ds, 0x00408+(i<<1));
                if (io_addr>0)
                {
                        data = inportb(io_addr+1) & 64;
                        outportb(io_addr+2, (inportb(io_addr+2)^2));
                        if ((inportb(io_addr+1) & 64) ^ data) detected = 1;
                }
                i++;
        } while (!detected && i<3);

        if (detected)
        {
                outportb(io_addr+2, 4);      // set pin 16 to '1' state
                data = inportb(io_addr+1);   // if pin 12 is now in '1' state,
                if (data & 32)

                        *type = 0;           // cable type is 0,
                else
                        *type = 1;           // otherwise cable type is 1
                *io = io_addr;
        }
        return detected;
}


unsigned int Detect_CPU_Speed(void)
{
        unsigned char old_IMR_PIC1;
        unsigned char TIM_INT;
        __dpmi_version_ret dpmi_info;
        __dpmi_paddr old_timer_vector;

        measurement_ready = 0;

        old_IMR_PIC1 = inportb(PIC1+1);
        outportb(PIC1+1, ~(1<<TIM_IRQ));       // disable all but timer IRQ
        __dpmi_get_version(&dpmi_info);
        TIM_INT = dpmi_info.master_pic+TIM_IRQ;
        stage = (unsigned int) first;
        disable();
        install_ISR(TIM_INT, (void *)timer_ISR, &old_timer_vector);
        old_offset = old_timer_vector.offset32;
        old_sel = old_timer_vector.selector;
        enable();
        do {} while (measurement_ready!=1);

        outportb(PIC1+1, old_IMR_PIC1);
        remove_ISR(TIM_INT, &old_timer_vector);

        return (unsigned int) (tsc_stop-tsc_start)/TIMER_INT_PERIOD;
}

