;
;   1541EMU, the Commodore 1541 disk drive emulator
;   Copyright (C) 2001-2002 Ville Muikkula
;
;  Written by
;   Ville Muikkula <1541@surfeu.fi>
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License version 2 as
;   published by the Free Software Foundation.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

%define INTSERV_N
%include "intserv.i"
%include "defines.i"
%include "c1541lnk.i"
%include "core.i"
%include "main.i"

%macro intserv 1
        push dword eax
        push dword edx
        inc dword [_num_IRQ+4*%1]
        mov word dx, [_LPT_IO]
        inc word dx
        in al, dx
        mov byte al, NONSPECIFIC_EOI
        mov byte dl, %1
        cmp byte dl, 7
        jbe %%noslave
        out PIC2, al
%%noslave:
        out PIC1, al
        pop dword edx
        pop dword eax
        ret
%endmacro


section .text
_ISRs:

_IRQ3_ISR: intserv 3
_IRQ4_ISR: intserv 4
_IRQ5_ISR: intserv 5
_IRQ6_ISR: intserv 6
_IRQ7_ISR: intserv 7
_IRQ9_ISR: intserv 9
_IRQ10_ISR: intserv 10
_IRQ11_ISR: intserv 11
_IRQ12_ISR: intserv 12
_IRQ14_ISR: intserv 14
_IRQ15_ISR: intserv 15

_ISR_addresses:
dd 0
dd 0
dd 0
dd _IRQ3_ISR
dd _IRQ4_ISR
dd _IRQ5_ISR
dd _IRQ6_ISR
dd _IRQ7_ISR
dd 0
dd _IRQ9_ISR
dd _IRQ10_ISR
dd _IRQ11_ISR
dd _IRQ12_ISR
dd 0
dd _IRQ14_ISR
dd _IRQ15_ISR

_num_IRQ: times 16 dd 0
_ok_IRQ:  db 0, 0, 0, 1, 1, 1, 1, 1,
          db 0, 1, 1, 1, 1, 0, 1, 1

_Check_Trigger_Type_ISR:
                pushad
;                mov byte [_trigtype], 0
                mov byte al, NONSPECIFIC_EOI
                cmp byte [_LPT_IRQ], 7
                jbe .noslave
                out PIC2, al
.noslave:       out PIC1, al

                cmp byte [_LPT_IRQ], 7
                ja .highIRQ
                mov byte al, 0Ah
                out PIC1, al
                in al, PIC1
                movzx word bx, byte [_LPT_IRQ]
                bt word ax, bx
                jnc .edge
                mov byte [_trigtype], 1
                jmp .ack
.highIRQ:       mov byte al, 0Ah
                out PIC2, al
                in al, PIC2
                movzx word bx, byte [_LPT_IRQ]
                sub word bx, 8
                bt word ax, bx
                jnc .edge
                mov byte [_trigtype], 1

.ack            mov word dx, [_LPT_IO]
                inc word dx
                in al, dx
                mov byte al, NONSPECIFIC_EOI
                cmp byte [_LPT_IRQ], 7
                jbe .noslav
                out PIC2, al
.noslav:        out PIC1, al
                jmp .exit

.edge:          mov byte [_trigtype], 0
.exit
                mov word dx, [_LPT_IO]
                inc word dx
                in al, dx
                bt word ax, 6
                setc al
                mov byte [_actedge], al

                popad
                sti
                iret

_trigtype: db 2
_actedge: db 2


;****************************************************************************
;* _LPT_ISR *****************************************************************
;****************************************************************************

_LPT_ISR:
                pushad
                mov dword esi, tc1541__1
                mov dword edi, (tc1541__1 + tvia6522__c1541_1)

                mov byte al, [_Polarity]
                xor byte al, [_LPT_IRQ_Active_Edge]
                xor byte al, [_Cable_Type]
.type1          call via6522_signal_ca1
                xor byte al, 1
                call via6522_signal_ca1

                cmp byte [_LPT_IRQ_Level_Triggered], 1
                jne .noack
                mov word dx, [_LPT_IO]
                inc word dx
                in al, dx
.noack:
                mov byte al, NONSPECIFIC_EOI
                cmp byte [_LPT_IRQ], 7
                jbe .noslave
                out PIC2, al
.noslave:
                out PIC1, al
                popad
                sti
                iret



;****************************************************************************
;* _keyb_ISR ****************************************************************
;****************************************************************************

_keyb_ISR:
        push dword eax
        in al, KEYB_PORT
        test byte al, 80h
        jnz .break
        mov byte [_Key_Code], al
.break
        inc dword [_num_IRQ+4]
        mov byte al, NONSPECIFIC_EOI
        out PIC1, al
        pop dword eax
        sti
        iret

;****************************************************************************
;* _timer_ISR ***************************************************************
;****************************************************************************

_timer_ISR:
        jmp dword [_stage]

_first: mov dword [_stage], second
        jmp standard_handler

second: push dword edx
        push dword eax
        rdtsc
        mov dword [_tsc_start], eax
        mov dword [_tsc_start+4], edx
        mov dword [_stage], third
        pop dword eax
        pop dword edx
        jmp standard_handler

third:  push dword edx
        push dword eax
        rdtsc
        mov dword [_tsc_stop], eax
        mov dword [_tsc_stop+4], edx
        mov dword [_stage], standard_handler
        mov byte [_measurement_ready], 1
        pop dword eax
        pop dword edx
standard_handler:
        db 0eah         ; JMP
_old_offset dd 0
_old_sel    dw 0

_tsc_start: dd 0, 0
_tsc_stop:  dd 0, 0
_stage:     dd 0
_measurement_ready db 0

_ISRs_end:
