;
;   1541EMU, the Commodore 1541 disk drive emulator
;   Copyright (C) 2001-2002 Ville Muikkula
;   Copyright (C) Karsten Scheibler
;
;  This file was formerly part of ec64, the Commodore 64 emulator for Linux.
;  Written by
;   Karsten Scheibler <karsten.scheibler@bigfoot.de>
;  Modifications by
;   Ville Muikkula <1541@surfeu.fi>
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License version 2 as
;   published by the Free Software Foundation.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;****************************************************************************
;****************************************************************************
;*
;* link.n
;*
;****************************************************************************
;****************************************************************************


%define LINK_N
%include "link.i"
%include "core.i"
%include "c1541lnk.i"
%include "main.i"
%include "timing.i"


;****************************************************************************
;* link_nothing *************************************************************
;****************************************************************************
section .text
link_nothing:
                        ret


;****************************************************************************
;* link_status **************************************************************
;****************************************************************************
section .text
link_status:
                        push    dword esi
                        mov     dword esi, tc1541__1
                        call    vc1541link_status
                        pop     dword esi
                        ret



;****************************************************************************
;* serial_bus ***************************************************************
;****************************************************************************
section .text
link_serial_bus:
                        push    dword edi
                        push    dword ebx
                        push    dword ecx
                        push    dword edx
                        mov     dword edi, (tc1541__1 + tvia6522__c1541_1)
                        mov dword ecx, 0
                        setc cl
                        jecxz .read0

                        mov     byte  al, [C1541LINK_SERIAL_BUS]
                        and     byte  al, SERIAL_OUTPUT_BITS
                        shr     byte  al, 1
                        mov     byte  bl, [_Polarity]
                        shl     byte  bl, 1
                        or      byte  al, bl
                        test    byte [_Cable_Type], 1
                        jnz     .simplified_cable
                        xor     byte  al, 8
.simplified_cable       xor     byte al, 13h
                        push    dword eax

.read0:                 call _core_get_c1541_cycles
                        mov dword ebx, edx
                        mul dword [_CPU_MHz]
                        add dword eax, [_TSC_value]
                        adc dword edx, [_TSC_value+4]
                        mov dword [wait_value], eax
                        mov dword [wait_value+4], edx
                        mov dword eax, ebx
                        mul dword [_CPU_MHz]
                        add dword [wait_value+4], eax
                        jecxz .read1

                        mov dword eax, [_IO_tuning]
                        mov dword edx, eax
                        sar dword edx, 1Fh
                        add dword [wait_value], eax
                        adc dword [wait_value+4], edx
.read1
.wait0                  rdtsc
                        cmp dword [wait_value+4], edx
                        jb .cont0
                        cmp dword [wait_value], eax
                        ja .wait0
.cont0                  mov word dx, [_LPT_IO]
                        inc word dx
                        jecxz .read2

                        pop dword eax
                        inc word dx
                        out dx, al
                        jmp .finish

.read2:                 in      al, dx
                        mov     byte  bl, al
                        and     byte  bl, 040h
                        shl     byte  bl, 1

                        mov     byte dl, [_Polarity]
                        xor     byte dl, [_Cable_Type]
                        jz      .no_atn_inv
                        xor     byte bl, 80h
.no_atn_inv
                        test    byte [_Cable_Type], 1
                        jz      .no_clkdata_inv
                        xor     byte al, 40
.no_clkdata_inv
                        shr     byte al, 3
                        and     byte al, 5
                        or      byte al, SERIAL_OUTPUT_BITS
                        or      byte al, bl
                        mov     byte bl, [_Device_Number]
                        and     byte bl, 3
                        shl     byte bl, 5
                        or      byte al, bl
                        call    via6522_signal_pb

.finish                 pop     dword edx
                        pop     dword ecx
                        pop     dword ebx
                        pop     dword edi
                        ret

wait_value:             dd      0, 0

