/*
    1541EMU, the Commodore 1541 disk drive emulator
    Copyright (C) 2001-2002 Ville Muikkula <1541@surfeu.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <dpmi.h>

#define MAX_DISKS 10
#define PIC1 0x20
#define PIC2 0xA0
#define Enable_IRQ 0x10
#define TIM_IRQ 0
#define TIMER_INT_PERIOD 54925 // value is in microseconds


#ifndef MAIN_H
#define MAIN_H


#ifdef MAIN_C
#include <go32.h>
#include <dos.h>
#include <crt0.h>
#include <sys/farptr.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <sys/stat.h>
#include <limits.h>
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>
#include "hwdetect.h"
#include "core.h"
#include "timing.h"
#include "tuifs.h"
#include "tui.h"
#include "tui_back.h"
#include "port_ini.h"
#include "diskimg.h"
#include "attach.h"
#include "intserv.h"


int _crt0_startup_flags = _CRT0_FLAG_LOCK_MEMORY;

/*
char **__crt0_glob_function (char *arg)
{
        return 0;
}
*/
#define BCDtoBIN(bcd)  (((bcd & 0xF0) >> 4) * 10 + (bcd & 0xF))

#define NONSPECIFIC_EOI 0x20

#define KEY_IRQ 1
#define INI_FILE    "1541EMU.INI"

unsigned char disk_image_t_size;
__dpmi_paddr vector[16];

char filename[256] = "";

unsigned char disk_number;

unsigned short selector;

unsigned int ScreenAddr;
unsigned char Key_Code = 0;
unsigned char Device_Number;
unsigned char Global_Read_Only_Access;
unsigned int CPU_MHz;
unsigned short LPT_IO;
unsigned char LPT_IRQ;
unsigned char LPT_IRQ_Level_Triggered;
unsigned char LPT_IRQ_Active_Edge;
unsigned char Cable_Type;
unsigned char Polarity; /* The current state of polarity select pin */
unsigned char Write_Protect_Sense; /* 1 = protected */
unsigned char Door_Open = 1;
int IO_tuning;

char dir[256] = "";
char drive_rom_name[13];
unsigned long long temp;
#else
extern unsigned char Global_Read_Only_Access;
extern char dir[];
extern char drive_rom_name[];
extern unsigned int ScreenAddr;
extern unsigned short LPT_IO;
extern void install_ISR(int num, void *ISR, __dpmi_paddr *old_vector);
extern void remove_ISR(int num, __dpmi_paddr *old_vector);

#endif
#endif
