/* Compute MD5 checksum of files or strings according to the definition
   of MD5 in RFC 1321 from April 1992.
   Copyright (C) 1995-1999 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* Written by Ulrich Drepper <drepper@gnu.ai.mit.edu>.  */

#include <stdio.h>
#include <sys/types.h>
#include "md5.h"
#include "system.h"
#include "tui.h"

/* An interface to md5_stream.  Operate on FILENAME and put the result in
   *MD5_RESULT. Return non-zero upon failure, zero to indicate success. */

int
md5_file (const char *filename, int binary, unsigned char *md5_result)
{
        FILE *fp;
        int err;

        fp = fopen (filename, "rb");
        if (fp == NULL)
	{
                tui_error("Could not open file %s.", filename);
                return 1;
	}

        err = md5_stream (fp, md5_result);
        if (err)
        {
                tui_error("Error while processing file %s.", filename);
                fclose (fp);
                return 1;
        }

        if (fclose (fp) == EOF)
        {
                tui_error("Could not close file %s.", filename);
                return 1;
        }

        return 0;
}


