;
;   1541EMU, the Commodore 1541 disk drive emulator
;   Copyright (C) 2001-2002 Ville Muikkula
;   Copyright (C) Karsten Scheibler
;
;  This file was formerly part of ec64, the Commodore 64 emulator for Linux.
;  Written by
;   Karsten Scheibler <karsten.scheibler@bigfoot.de>
;  Modifications by
;   Ville Muikkula <1541@surfeu.fi>
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License version 2 as
;   published by the Free Software Foundation.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

%ifndef PRINT_INC
%define PRINT_INC

%include "defines.i"
%include "string.i"

;****************************************************************************
;* Exported Symbols *********************************************************
;****************************************************************************
%ifdef PRINT_NASM
global print_text
global print_string
%else
extern print_text
extern print_string
%endif


;****************************************************************************
;* assign's & define's ******************************************************
;****************************************************************************
%assign PRINT_MAX_STRING_LENGTH		01000h


;****************************************************************************
;* Macro's ******************************************************************
;****************************************************************************
%macro PRINT_TEXT 1-*
%define PRINT_POINTER	%1
			push	dword eax
%if %0 > 1
			push	dword ebp
			mov	dword ebp, esp
%rep %0-1
%rotate 1
%ifidn %1, ebp
%error "PRINT_TEXT: can't use ebp as Parameter"
%endif
			push	dword %1
%endrep
%endif
			mov	dword eax, PRINT_POINTER
%if %0 > 1
			call	print_string
			mov	dword esp, ebp
			pop	dword ebp
%else
			call	print_text
%endif
			pop	dword eax
%undef PRINT_POINTER
%endmacro

%endif

