;
;   1541EMU, the Commodore 1541 disk drive emulator
;   Copyright (C) 2001-2002 Ville Muikkula
;   Copyright (C) Karsten Scheibler
;
;  This file was formerly part of ec64, the Commodore 64 emulator for Linux.
;  Written by
;   Karsten Scheibler <karsten.scheibler@bigfoot.de>
;  Modifications by
;   Ville Muikkula <1541@surfeu.fi>
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License version 2 as
;   published by the Free Software Foundation.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

%define PRINT_NASM
%include "print.i"
%include "string.i"

;****************************************************************************
;* print_string *************************************************************
;****************************************************************************
section .text
print_string:
                push    dword ebx
                push    dword ecx
                push    dword edx
                mov     dword ecx, PRINT_MAX_STRING_LENGTH
                sub     dword esp, ecx
                mov     dword ebx, esp
                call string_parse
                dec     dword eax
                mov     dword ecx, ebx
                mov     dword edx, eax
;                SYS_WRITE  STDOUT

                mov byte ah, 2
.loop:          mov byte dl, [ebx]
                cmp byte dl, '$'
                je .endofstring
                int 21h
                inc dword ebx
                jmp .loop
.endofstring:
                add dword esp, PRINT_MAX_STRING_LENGTH
                pop dword edx
                pop dword ecx
                pop dword ebx
                ret

