;
;   1541EMU, the Commodore 1541 disk drive emulator
;   Copyright (C) 2001-2002 Ville Muikkula
;   Copyright (C) Karsten Scheibler
;
;  This file was formerly part of ec64, the Commodore 64 emulator for Linux.
;  Written by
;   Karsten Scheibler <karsten.scheibler@bigfoot.de>
;  Modifications by
;   Ville Muikkula <1541@surfeu.fi>
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License version 2 as
;   published by the Free Software Foundation.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

%define STATUS_NASM
%include "status.i"
%include "string.i"
%include "main.i"

;****************************************************************************
;* status_initialize ********************************************************
;****************************************************************************
section .text
status_initialize:
                        ret


;****************************************************************************
;* status_vc1541_motor ******************************************************
;****************************************************************************
;* eax=>  Modul ID
;* bl==>  on/off
;****************************************************************************
section .text
status_vc1541_motor:
                        push fs
                        push    dword eax
                        push    dword ebx
                        push    dword ecx
                        or      byte  bl, bl
                        mov     byte  cl, ' '
                        jz      .off
                        mov     byte  cl, ''
.off:                   mov dword eax, [_ScreenAddr]
                        add dword eax, MOTOR_SCREEN_OFFSET
                        mov fs, [_selector]
                        mov [fs:eax], cl
                        pop     dword ecx
                        pop     dword ebx
                        pop     dword eax
                        pop fs
                        ret


;****************************************************************************
;* status_vc1541_led ********************************************************
;****************************************************************************
;* eax=>  Modul ID
;* bl==>  on/off
;****************************************************************************
section .text
status_vc1541_led:
                        push fs
                        push    dword eax
                        push    dword ebx
                        push    dword ecx
                        or      byte  bl, bl
                        mov     byte  cl, ' '
                        jz      .off
                        mov     byte  cl, ''
.off:                   mov dword eax, [_ScreenAddr]
                        add dword eax, LED_SCREEN_OFFSET
                        mov fs, [_selector]
                        mov [fs:eax], cl
                        pop     dword ecx
                        pop     dword ebx
                        pop     dword eax
                        pop fs
                        ret


;****************************************************************************
;* status_vc1541_track ******************************************************
;****************************************************************************
;* eax=>  Modul ID
;* bl==>  track number
;****************************************************************************
section .text
status_vc1541_track:
                        push fs
                        push dword eax
                        push dword ebx
                        push dword ecx
                        add byte bl, 2
                        shr byte bl, 1
                        mov byte al, '0'
                        jnc .nohalf
                        mov byte al, '5'
.nohalf:                mov dword ecx, [_ScreenAddr]
                        add dword ecx, TRACK_SCREEN_OFFSET
                        mov fs, [_selector]
                        mov byte [fs:ecx+6], al
                        movzx word ax, byte bl
                        mov byte bl, 10
                        div byte bl
                        add word ax, 03030h
                        cmp byte al, 030h
                        jne .over10
                        mov byte al, ' '
.over10:                mov byte [fs:ecx], al
                        mov byte [fs:ecx+2], ah
                        pop dword ecx
                        pop dword ebx
                        pop dword eax
                        pop fs
                        ret


;****************************************************************************

section .text
status_vc1541_disk:
                        push fs
                        mov dword eax, [_ScreenAddr]
                        add dword eax, DISK_SCREEN_OFFSET
                        inc dword eax
                        movzx dword ebx, byte [_disk_number]
                        shl dword ebx, 7
                        add dword eax, ebx
                        movzx dword ebx, byte [_disk_number]
                        shl dword ebx, 5
                        add dword eax, ebx
                        mov fs, [_selector]
                        ror byte [fs:eax], 4
                        pop fs
                        ret

;****************************************************************************

section .text
status_vc1541_IO_tuning:
                        push fs
                        push eax
                        push ebx
                        push ecx
                        push edx

                        mov dword ebx, IO_tuning_string
                        mov dword ecx, 11
.clean_string           mov dword [ebx], ' '
                        inc dword ebx
                        loop .clean_string

                        mov dword eax, [_IO_tuning]
                        mov dword ebx, IO_tuning_string
                        call string_dec32

                        mov dword edx, IO_tuning_string
                        mov dword ecx, 11
                        mov dword ebx, [_ScreenAddr]
                        add dword ebx, TUNING_SCREEN_OFFSET
                        mov fs, [_selector]
.output_string          mov byte al, [edx]
                        mov [fs:ebx], al
                        inc dword edx
                        add dword ebx, 2
                        loop .output_string

                        pop edx
                        pop ecx
                        pop ebx
                        pop eax
                        pop fs
                        ret

section .data
IO_tuning_string:
times 11 db 0

