;
;   1541EMU, the Commodore 1541 disk drive emulator
;   Copyright (C) 2001-2002 Ville Muikkula
;   Copyright (C) Karsten Scheibler
;
;  This file was formerly part of ec64, the Commodore 64 emulator for Linux.
;  Written by
;   Karsten Scheibler <karsten.scheibler@bigfoot.de>
;  Modifications by
;   Ville Muikkula <1541@surfeu.fi>
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License version 2 as
;   published by the Free Software Foundation.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

%ifndef STRING_INC
%define STRING_INC

%include "defines.i"

;****************************************************************************
;* Exported Symbols *********************************************************
;****************************************************************************
%ifdef STRING_NASM
global string_parse
global string_dec32
%else
extern string_parse
extern string_dec32
%endif


;****************************************************************************
;* assign's & defines's *****************************************************
;****************************************************************************
%assign STRING_FIRST_TOKEN	080h
%assign STRING_LAST_TOKEN	090h

%assign STRING_INSERT_STR	080h
%assign STRING_INSERT_HEX8	081h
%assign STRING_INSERT_HEX16	082h
%assign STRING_INSERT_HEX32	083h
%assign STRING_INSERT_HEX64	084h
%assign STRING_INSERT_DEC8	085h
%assign STRING_INSERT_DEC16	086h
%assign STRING_INSERT_DEC32	087h
%assign STRING_INSERT_DEC64	088h
%assign STRING_INSERT_BIN8	089h
%assign STRING_INSERT_BIN16	08ah
%assign STRING_INSERT_BIN32	08bh
%assign STRING_INSERT_BIN64	08ch
%assign STRING_INSERT_FLAG8	08dh
%assign STRING_INSERT_FLAG16	08eh
%assign STRING_INSERT_FLAG32	08fh
%assign STRING_INSERT_FLAG64	090h

%endif

