;
;   1541EMU, the Commodore 1541 disk drive emulator
;   Copyright (C) 2001-2002 Ville Muikkula
;   Copyright (C) Karsten Scheibler
;
;  This file was formerly part of ec64, the Commodore 64 emulator for Linux.
;  Written by
;   Karsten Scheibler <karsten.scheibler@bigfoot.de>
;  Modifications by
;   Ville Muikkula <1541@surfeu.fi>
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License version 2 as
;   published by the Free Software Foundation.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

%define STRING_NASM
%include "string.i"

section .text
ab__hex:                db      "0123456789abcdef"

;****************************************************************************
;* string_parse *************************************************************
;****************************************************************************
;* eax=> source string
;* ebx=> destination string
;* ecx=> maximal length of destination string
;* <=eax destination string length
;****************************************************************************
section .text
string_parse:
                        push    dword ebx
                        push    dword ecx
                        push    dword edx
                        push    dword esi
                        push    dword ebp
                        or      dword ecx, ecx
                        jz      .exit
                        dec     dword ecx
                        jz      .end
                        mov     dword esi, eax
.get_byte:              mov     byte  al, [esi]
                        inc     dword esi
                        or      byte  al, al
                        jz      .end
                        cmp     byte  al, STRING_FIRST_TOKEN
                        jb      .copy_byte
                        cmp     byte  al, STRING_LAST_TOKEN
                        ja      .skip_token
                        sub     byte  al, STRING_FIRST_TOKEN
                        and     dword eax, NOT8
                        jmp     dword [.ad__insert_functions + 4 * eax]
.skip_token:            mov     byte  al, '%'
.copy_byte:             mov     byte  [ebx], al
                        inc     dword ebx
                        dec     dword ecx
                        jnz     .get_byte
.end:                   xor     byte  al, al
                        mov     byte  [ebx], al
                        inc     dword ebx
.exit:                  pop     dword ebp
                        pop     dword esi
                        pop     dword edx
                        mov     dword eax, ebx
                        pop     dword ecx
                        pop     dword ebx
                        sub     dword eax, ebx
                        ret
.ad__insert_functions:  dd      insert_string
                        dd      insert_hex8
                        dd      insert_hex16
                        dd      insert_hex32
                        dd      insert_hex64
                        dd      insert_dec8
                        dd      insert_dec16
                        dd      insert_dec32
                        dd      insert_dec64
                        dd      insert_bin8
                        dd      insert_bin16
                        dd      insert_bin32
                        dd      insert_bin64
                        dd      insert_flag8
                        dd      insert_flag16
                        dd      insert_flag32
                        dd      insert_flag64

                        ;---------------
                        ;insert a string
                        ;---------------

insert_string:          sub     dword ebp, 4
                        push    dword esi
                        mov     dword esi, [ebp]
.copy_byte:             mov     byte  al, [esi]
                        inc     dword esi
                        or      byte  al, al
                        jz      .return
                        mov     byte  [ebx], al
                        inc     dword ebx
                        dec     dword ecx
                        jnz     .copy_byte
                        pop     dword esi
                        jmp     string_parse.end
.return:                pop     dword esi
                        jmp     string_parse.get_byte

                        ;-------------------------
                        ;insert a 8 bit hex number
                        ;-------------------------

insert_hex8:            sub     dword ebp, 4
                        mov     dword eax, [ebp]
                        sub     dword ecx, 2
                        jb      near  string_parse.end
                        call    string_hex8
                        add     dword ebx, 2
                        jmp     string_parse.get_byte

                        ;--------------------------
                        ;insert a 16 bit hex number
                        ;--------------------------

insert_hex16:           sub     dword ebp, 4
                        mov     dword eax, [ebp]
                        sub     dword ecx, 4
                        jb      near  string_parse.end
                        call    string_hex16
                        add     dword ebx, 4
                        jmp     string_parse.get_byte

                        ;--------------------------
                        ;insert a 32 bit hex number
                        ;--------------------------

insert_hex32:           sub     dword ebp, 4
                        mov     dword eax, [ebp]
                        sub     dword ecx, 8
                        jb      near  string_parse.end
                        call    string_hex32
                        add     dword ebx, 8
                        jmp     string_parse.get_byte

                        ;--------------------------
                        ;insert a 64 bit hex number
                        ;--------------------------

insert_hex64:           mov     dword eax, [ebp - 8]
                        mov     dword edx, [ebp - 4]
                        sub     dword ebp, 8
                        sub     dword ecx, 16
                        jb      near  string_parse.end
                        call    string_hex64
                        add     dword ebx, 16
                        jmp     string_parse.get_byte

insert_dec8:
                        jmp     string_parse.get_byte
insert_dec16:
                        jmp     string_parse.get_byte
insert_dec32:           sub     dword ebp, 4
                        mov     dword eax, [ebp]
                        cmp     dword ecx, 10
                        jb      near  string_parse.end
                        call    string_dec32
                        add     dword ebx, eax
                        sub     dword ecx, eax
                        jmp     string_parse.get_byte
insert_dec64:
                        jmp     string_parse.get_byte

insert_bin8:
                        jmp     string_parse.get_byte
insert_bin16:
                        jmp     string_parse.get_byte
insert_bin32:
                        jmp     string_parse.get_byte
insert_bin64:
                        jmp     string_parse.get_byte

insert_flag8:           sub     dword ebp, 4
                        mov     dword eax, [ebp]
                        sub     dword ecx, 8
                        jb      near  string_parse.end
                        call    string_flag8
                        add     dword ebx, 8
                        jmp     string_parse.get_byte
insert_flag16:
                        jmp     string_parse.get_byte
insert_flag32:          sub     dword ebp, 4
                        mov     dword eax, [ebp]
                        sub     dword ecx, 32
                        jb      near  string_parse.end
                        call    string_flag32
                        add     dword ebx, 32
                        jmp     string_parse.get_byte
insert_flag64:
                        jmp     string_parse.get_byte



;****************************************************************************
;* string_hex8 **************************************************************
;****************************************************************************
;* eax=> number
;* ebx=> Pointer were to place the hex number
;****************************************************************************
section .text
string_hex8:
                        push    dword eax
                        push    dword ebx
                        push    dword ecx
                        push    dword edx
                        push    dword esi
                        mov     dword edx, eax
                        mov     byte  cl, 002h
                        shl     dword edx, 24
.decode:                rol     dword edx, 4
                        mov     dword esi, edx
                        and     dword esi, 00fh
                        mov     byte  al, [ab__hex + esi]
                        mov     byte  [ebx], al
                        inc     dword ebx
                        dec     byte  cl
                        jnz     .decode
                        pop     dword esi
                        pop     dword edx
                        pop     dword ecx
                        pop     dword ebx
                        pop     dword eax
                        ret



;****************************************************************************
;* string_hex16 *************************************************************
;****************************************************************************
;* eax=> number
;* ebx=> Pointer were to place the hex number
;****************************************************************************
section .text
string_hex16:
                        push    dword eax
                        push    dword ebx
                        push    dword ecx
                        push    dword edx
                        push    dword esi
                        mov     dword edx, eax
                        mov     byte  cl, 004h
                        shl     dword edx, 16
.decode:                rol     dword edx, 4
                        mov     dword esi, edx
                        and     dword esi, 00fh
                        mov     byte  al, [ab__hex + esi]
                        mov     byte  [ebx], al
                        inc     dword ebx
                        dec     byte  cl
                        jnz     .decode
                        pop     dword esi
                        pop     dword edx
                        pop     dword ecx
                        pop     dword ebx
                        pop     dword eax
                        ret



;****************************************************************************
;* string_hex32 *************************************************************
;****************************************************************************
;* eax=> number
;* ebx=> Pointer were to place the hex number
;****************************************************************************
section .text
string_hex32:
                        push    dword eax
                        push    dword ebx
                        push    dword ecx
                        push    dword edx
                        push    dword esi
                        mov     dword edx, eax
                        mov     byte  cl, 008h
.decode:                rol     dword edx, 4
                        mov     dword esi, edx
                        and     dword esi, 00fh
                        mov     byte  al, [ab__hex + esi]
                        mov     byte  [ebx], al
                        inc     dword ebx
                        dec     byte  cl
                        jnz     .decode
                        pop     dword esi
                        pop     dword edx
                        pop     dword ecx
                        pop     dword ebx
                        pop     dword eax
                        ret



;****************************************************************************
;* string_hex64 *************************************************************
;****************************************************************************
;* eax=> Low 32 Bits of the Number
;* ebx=> Pointer were to place the hex number
;* edx=> High 32 Bits of the Number
;****************************************************************************
section .text
string_hex64:
                        push    dword eax
                        push    dword ebx
                        push    dword ecx
                        push    dword edx
                        push    dword esi
                        mov     byte  cl, 008h
                        push    dword eax
.decode_hi:             rol     dword edx, 4
                        mov     dword esi, edx
                        and     dword esi, 00fh
                        mov     byte  al, [ab__hex + esi]
                        mov     byte  [ebx], al
                        inc     dword ebx
                        dec     byte  cl
                        jnz     .decode_hi
                        pop     dword edx
                        mov     byte  cl, 008h
.decode_lo:             rol     dword edx, 4
                        mov     dword esi, edx
                        and     dword esi, 00fh
                        mov     byte  al, [ab__hex + esi]
                        mov     byte  [ebx], al
                        inc     dword ebx
                        dec     byte  cl
                        jnz     .decode_lo
                        pop     dword esi
                        pop     dword edx
                        pop     dword ecx
                        pop     dword ebx
                        pop     dword eax
                        ret



;****************************************************************************
;* string_dec32 *************************************************************
;****************************************************************************
;* eax=> number
;* ebx=> Pointer were to place the decimal number
;* <=eax destination string length
;****************************************************************************
section .text
string_dec32:
                        push    dword ebx
                        push    dword ecx
                        push    dword edx
                        push    dword esi
                        push    dword edi

         bt    dword eax, 31
         jnc   .positive
         neg   dword eax
         mov   byte [ebx], '-'
         inc   dword ebx
.positive
                        mov     dword ecx, 1000000000
                        mov     dword esi, 10
                        mov     dword edi, esi
.decode:        xor     dword edx, edx
                        div     dword ecx
                        dec     dword edi
                        jz    .decode_1
                        or    byte  al, al
                        jz    .decode_2
                        xor     dword edi, edi
.decode_1:              add   byte  al, '0'
                        inc     dword edi
                        mov     byte  [ebx], al
                        inc     dword ebx
.decode_2:              push  dword edx
                        mov     dword eax, ecx
                        xor     dword edx, edx
                        div     dword esi
                        mov     dword ecx, eax
                        pop     dword eax
                        or    dword ecx, ecx
                        jnz     .decode
                        mov     dword eax, ebx
                        pop     dword edi
                        pop     dword esi
                        pop     dword edx
                        pop     dword ecx
                        pop     dword ebx
                        sub     dword eax, ebx
                        ret



;****************************************************************************
;* string_bin ***************************************************************
;****************************************************************************
section .text
string_bin:
                        ret



;****************************************************************************
;* string_flag8 *************************************************************
;****************************************************************************
section .text
string_flag8:
                        push    dword eax
                        push    dword ebx
                        push    dword ecx
                        push    dword edx
                        mov     dword edx, eax
                        mov     byte  cl, 008h
                        shl     dword edx, 24
.decode:                rol     dword edx, 1
                        mov     byte  al, '.'
                        jnc     .decode_1
                        mov     byte  al, '*'
.decode_1:              mov     byte  [ebx], al
                        inc     dword ebx
                        dec     byte  cl
                        jnz     .decode
                        pop     dword edx
                        pop     dword ecx
                        pop     dword ebx
                        pop     dword eax
                        ret



;****************************************************************************
;* string_flag32 ************************************************************
;****************************************************************************
section .text
string_flag32:
                        push    dword eax
                        push    dword ebx
                        push    dword ecx
                        push    dword edx
                        mov     dword edx, eax
                        mov     byte  cl, 020h
.decode:                rol     dword edx, 1
                        mov     byte  al, '.'
                        jnc     .decode_1
                        mov     byte  al, '*'
.decode_1:              mov     byte  [ebx], al
                        inc     dword ebx
                        dec     byte  cl
                        jnz     .decode
                        pop     dword edx
                        pop     dword ecx
                        pop     dword ebx
                        pop     dword eax
                        ret

