/*
    1541EMU cable test utility
    Copyright (C) 2001-2002 Ville Muikkula <1541@surfeu.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <go32.h>
#include <stdio.h>
#include <conio.h>
#include <pc.h>
#include <sys/farptr.h>

#define BIOS_LPT_DATA 0x00408
#define INITIAL_OUTPUT 0x0B


void ShowScreen(void)
{
        clrscr();
        printf("1541EMU cable test utility\n");
        printf("                              +/- Change LPT port\n");
        printf("                              1-4 Toggle output pin state\n");
        printf("    LPT  (    )               ESC Exit to DOS\n\n\n");

        printf("  OUTPUTS\n");
        printf("    ( )  DB25 pin  1, Strobe, (DATA OUT, PB1)\n\n");
        printf("    ( )  DB25 pin 14, Autofeed, ATN Polarity selection\n\n");
        printf("    ( )  DB25 pin 16, Init, (CLK OUT, PB3)\n\n");
        printf("    ( )  DB25 pin 17, Select, (ATNA, PB4)\n\n\n");

        printf("  INPUTS\n");
        printf("    ( )  DB25 pin 15, Error, (DATA IN, PB0)\n\n");
        printf("    ( )  DB25 pin 12, Paper End, (CLK IN, PB2)\n\n");
        printf("    ( )  DB25 pin 10, Acknowledge, (ATN IN, PB7)\n\n");
}


void Output(int address, int data)
{
        int i;
        int mask = 1;

        outp(address+2, data);
        data ^= INITIAL_OUTPUT;
        for (i=8; i<15; i+=2, mask<<=1)
        {
                gotoxy(6,i);
                putch((data & mask) ? 'X' : ' ');
        }
}


void Input(int address)
{
        int i;
        int mask = 8;
        int data;

        data = inp(address+1);
        for (i=18; i<23; i+=2, mask<<=1)
        {
                gotoxy(6,i);
                if (mask==16) mask<<=1;
                putch((data & mask) ? 'X' : ' ');
        }
}


int ChangeLPT(char direction)
{
        static int port = 1;
        int address;

        do
        {
                if (direction=='+')
                {
                        port++;
                        if (port==4) port=1;
                }
                else if (direction=='-')
                {
                        port--;
                        if (port==0) port=3;
                }
                address=(int)_farpeekw(_dos_ds, BIOS_LPT_DATA+((port-1)<<1));
        } while (address==0);

        gotoxy(8,4);
        putch('0'+port);
        gotoxy(11,4);
        printf("%04X\n", address);

        return address;
}


int main(void)
{
        int Out = INITIAL_OUTPUT;
        int Exit = 0;
        int LPT_IO;

        if (_farpeekw(_dos_ds, BIOS_LPT_DATA)!=0)
        {
                ShowScreen();
                LPT_IO = ChangeLPT(' ');

                do
                {
                        Output(LPT_IO, Out);
                        Input(LPT_IO);
                        if (kbhit()) switch(getch())
                        {
                                case '+':
                                        LPT_IO=ChangeLPT('+');
                                        Out=INITIAL_OUTPUT;
                                        break;

                                case '-':
                                        LPT_IO=ChangeLPT('-');
                                        Out=INITIAL_OUTPUT;
                                        break;

                                case '1':
                                        Out^=1;
                                        break;

                                case '2':
                                        Out^=2;
                                        break;

                                case '3':
                                        Out^=4;
                                        break;

                                case '4':
                                        Out^=8;
                                        break;

                                case 27:
                                        Exit = 1;
                                        break;
                        }
                } while (!Exit);
        }
        else
                printf("\nCould not detect any LPT ports!");
        printf("\n");
        return 0;
}
