;
;   1541EMU, the Commodore 1541 disk drive emulator
;   Copyright (C) 2001-2002 Ville Muikkula
;
;  Written by
;   Ville Muikkula <1541@surfeu.fi>
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License version 2 as
;   published by the Free Software Foundation.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

%define TIMING_N
%include "timing.i"
%include "main.i"

section .data
                        align 4
_TSC_value:             dd      0, 0
limited_TSC:            dd      0, 0
temp:                   dd      0, 0

section .text
_detect_IO_delay:
                 push dword ecx
                 mov dword ecx, 1024
                 cli
                 rdtsc
                 mov dword [temp], eax
                 mov dword [temp+4], edx
                 mov word dx, [_LPT_IO]
.loop:           times 64 in al, dx
                 loop .loop

                 rdtsc
                 sti
                 sub dword eax, [temp]
                 sbb dword edx, [temp+4]
                 pop dword ecx
                 ret

_init_timing:
        rdtsc
        mov dword [_TSC_value], eax
        mov dword [_TSC_value+4], edx
        mov dword ebx, [_CPU_MHz]
        shl dword ebx, 4
        sub dword eax, ebx
        sbb dword edx, 0
        mov dword [limited_TSC], eax
        mov dword [limited_TSC+4], edx
        ret

limit_speed:
.wait   rdtsc
        cmp dword [limited_TSC+4], edx
        jb .cont
        cmp dword [limited_TSC], eax
        ja .wait
.cont   mov dword eax, [_CPU_MHz]
        add dword [limited_TSC], eax
        adc dword [limited_TSC+4], 0
        ret


section .text
_CheckRDTSC:
        push dword ecx
        push dword edx
        cli
        pushfd
        pop dword eax
        mov dword ecx, eax
        xor dword eax, 200000h
        push dword eax
        popfd
        pushfd
        pop dword eax
        sti
        cmp dword eax, ecx
        mov dword eax, 0
        je .fail

        mov dword eax, 1
        cpuid
        test dword edx, 16
        mov dword eax, 0
        jz .fail

        inc dword eax
.fail   pop dword edx
        pop dword ecx
        ret
