/*
 * utils.h - Miscellaneous utility functions.
 *
 * Written by
 *  Ettore Perazzoli <ettore@comm2000.it>
 *  Andreas Boose <boose@linux.rz.fh-hannover.de>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#ifndef _UTILS_H
#define _UTILS_H

//#include "vice.h"

#include <stdarg.h>
#include <stdio.h>

#include "types.h"

#define FSDEV_DIR_SEP_CHR      '/'
#define FSDEV_EXT_SEP_CHR      '.'

extern char *stralloc(const char *str);
extern void *xmalloc(size_t s);
extern void *xcalloc(size_t nmemb, size_t size);
extern void *xrealloc(void *p, size_t s);
extern char *xmsprintf(const char *fmt, ...);
extern char *xmvsprintf(const char *fmt, va_list args);
extern char *concat(const char *s1, ...);
extern char *util_bufcat(char *buf, int *buf_size, size_t *max_buf_size,
                         const char *src, int src_size);
extern void util_remove_spaces(char *s);
extern void util_add_extension(char **name, const char *extension);
extern char *util_get_current_dir(void);

extern size_t util_file_length(FILE *fd);
extern int util_load_file(const char *name, void *dest, size_t size);
extern int util_save_file(const char *name, const void *src, int size);
extern int util_remove_file(const char *name);

extern int util_get_line(char *buf, int bufsize, FILE *f);

extern int util_string_to_long(const char *str, const char **endptr, int base,
                               long *result);
extern char *util_subst(const char *s, const char *string,
                        const char *replacement);
extern int util_check_null_string(const char *string);

extern int read_dword(FILE *fd, DWORD *buf, size_t num);
extern int write_dword(FILE *fd, DWORD *buf, size_t num);

extern void util_dword_to_le_buf(BYTE *buf, DWORD data);

extern int util_file_exists_p(const char *name);

extern char *util_find_prev_line(const char *text, const char *pos);
extern char *util_find_next_line(const char *pos);

#if !defined HAVE_ATEXIT
int atexit(void (*function)(void));
#endif

#if !defined HAVE_STRERROR
char *strerror(int errnum);
#endif

#if !defined HAVE_STRCASECMP
int strcasecmp(const char *s1, const char *s2);
#endif

#endif /* UTILS_H */

