;
;   1541EMU, the Commodore 1541 disk drive emulator
;   Copyright (C) 2001-2002 Ville Muikkula
;   Copyright (C) Karsten Scheibler
;
;  This file was formerly part of ec64, the Commodore 64 emulator for Linux.
;  Written by
;   Karsten Scheibler <karsten.scheibler@bigfoot.de>
;  Modifications by
;   Ville Muikkula <1541@surfeu.fi>
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License version 2 as
;   published by the Free Software Foundation.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;****************************************************************************
;****************************************************************************
;*
;* via6522.i
;*
;****************************************************************************
;****************************************************************************





%ifndef VIA6522_I
%define VIA6522_I

%include "defines.i"
%include "macros.i"
%include "ec64types.i"

;****************************************************************************
;* Exported Symbols *********************************************************
;****************************************************************************
%ifdef VIA6522_N
global via6522_initialize
global via6522_exit
global via6522_instance_initialize
global via6522_instance_exit
global via6522_reset_hard
global via6522_reset_soft
global via6522_signal_pb
global via6522_signal_pa
global via6522_signal_cb1
global via6522_signal_cb2
global via6522_signal_ca1
global via6522_signal_ca2
global via6522_read
global via6522_write
%else
extern via6522_initialize
extern via6522_exit
extern via6522_instance_initialize
extern via6522_instance_exit
extern via6522_reset_hard
extern via6522_reset_soft
extern via6522_signal_pb
extern via6522_signal_pa
extern via6522_signal_cb1
extern via6522_signal_cb2
extern via6522_signal_ca1
extern via6522_signal_ca2
extern via6522_read
extern via6522_write
%endif



;****************************************************************************
;* Module Data **************************************************************
;****************************************************************************
				struc	tvia6522
				alignb	4
d__via6522_modulid:		resd	1
d__via6522_state:		resd	1
p__via6522_link_irq:		resd	1
p__via6522_link_pb:		resd	1
p__via6522_link_cb2:		resd	1
p__via6522_link_pa:		resd	1
p__via6522_link_ca1:		resd	1
p__via6522_link_ca2:		resd	1
d__via6522_counter_offset:	resd	1
q__via6522_timestamp_t1:	resd	2
d__via6522_counter_t1:		resd	1
q__via6522_timestamp_t2:	resd	2
d__via6522_counter_t2:		resd	1
b__via6522_latch_pb:		resb	1
b__via6522_signal_pb:		resb	1
b__via6522_latch_pa:		resb	1
b__via6522_signal_pa:		resb	1
b__via6522_latch_t2_lo:		resb	1
b__via6522_irq_mask:		resb	1
ab__via6522_registers:		resb	16
				endstruc



;****************************************************************************
;* assign's & defines's *****************************************************
;****************************************************************************
%assign VIA6522_PB	000h
%assign VIA6522_PA	001h
%assign VIA6522_DDRB	002h
%assign VIA6522_DDRA	003h
%assign VIA6522_T1C_LO	004h
%assign VIA6522_T1C_HI	005h
%assign VIA6522_T1L_LO	006h
%assign VIA6522_T1L_HI	007h
%assign VIA6522_T2C_LO	008h
%assign VIA6522_T2C_HI	009h
%assign VIA6522_SR	00ah
%assign VIA6522_ACR	00bh
%assign VIA6522_PCR	00ch
%assign VIA6522_IFR	00dh
%assign VIA6522_IER	00eh
%assign VIA6522_PA_NH	00fh	;PA no handshake

%define VIA6522_MODULID		edi + d__via6522_modulid
%define VIA6522_STATE		edi + d__via6522_state
%define VIA6522_LINK_IRQ	edi + p__via6522_link_irq
%define VIA6522_LINK_PB		edi + p__via6522_link_pb
%define VIA6522_LINK_CB2	edi + p__via6522_link_cb2
%define VIA6522_LINK_PA		edi + p__via6522_link_pa
%define VIA6522_LINK_CA1        edi + p__via6522_link_ca1
%define VIA6522_LINK_CA2	edi + p__via6522_link_ca2
%define VIA6522_COUNTER_OFFSET	edi + d__via6522_counter_offset
%define VIA6522_TIMESTAMP_T1	edi + q__via6522_timestamp_t1
%define VIA6522_COUNTER_T1	edi + d__via6522_counter_t1
%define VIA6522_TIMESTAMP_T2	edi + q__via6522_timestamp_t2
%define VIA6522_COUNTER_T2	edi + d__via6522_counter_t2
%define VIA6522_LATCH_PB	edi + b__via6522_latch_pb
%define VIA6522_SIGNAL_PB	edi + b__via6522_signal_pb
%define VIA6522_LATCH_PA	edi + b__via6522_latch_pa
%define VIA6522_SIGNAL_PA	edi + b__via6522_signal_pa
%define VIA6522_LATCH_T2_LO	edi + b__via6522_latch_t2_lo
%define VIA6522_IRQ_MASK	edi + b__via6522_irq_mask
%define VIA6522_REGISTERS	edi + ab__via6522_registers

%assign VIA6522_T1_STOPPED	000000001h
%assign VIA6522_T2_STOPPED	000000002h
%assign VIA6522_STATE_CB1	000000004h
%assign VIA6522_STATE_CA1	000000008h



;****************************************************************************
;* Macro's ******************************************************************
;****************************************************************************
%macro VIA6522_CALL_INITIALIZE 0
			call	via6522_initialize
%endmacro



%macro VIA6522_CALL_INSTANCE_INITIALIZE 9
			lea	dword edi, [esi + %1]
			call	via6522_instance_initialize
			mov	dword eax, %2
			mov	dword ebx, %3
			mov	dword ecx, %4
			mov	dword [VIA6522_MODULID], eax
			mov	dword [VIA6522_COUNTER_OFFSET], ebx
			mov	dword [VIA6522_LINK_IRQ], ecx
			mov	dword eax, %5
			mov	dword ebx, %6
			mov	dword ecx, %7
			mov	dword edx, %8
			mov	dword [VIA6522_LINK_PB], eax
			mov	dword [VIA6522_LINK_CB2], ebx
			mov	dword [VIA6522_LINK_PA], ecx
			mov	dword [VIA6522_LINK_CA2], edx
                        mov     dword eax, %9
                        mov     dword [VIA6522_LINK_CA1], eax
%endmacro



%macro VIA6522_CALL_RESET_HARD 1
			lea	dword edi, [esi + %1]
			call	via6522_reset_hard
%endmacro



%macro VIA6522_CALL_RESET_SOFT 1
			lea	dword edi, [esi + %1]
			call	via6522_reset_soft
%endmacro



%macro VIA6522_CALL_READ 1
			lea	dword edi, [esi + %1]
			call	via6522_read
%endmacro



%macro VIA6522_CALL_WRITE 1
			lea	dword edi, [esi + %1]
			call	via6522_write
%endmacro



%endif
;********************************************* karsten.scheibler@bigfoot.de *

