Welcome to the FastLynx On-line Reference Guide.  Much of the material in
this guide is already included in FastLynx's excellent context-sensitive
help facility.	If you want to jump right in and start using the program
now, feel free to do so.  This guide is provided for the following reasons:

    1) It organizes the material in the help screens into a single place so
    that you can browse through it in its entirety should you feel inclined.

    2) Since this guide is in an ASCII text file (guide.fx), you can
    print it using the DOS "print" command if you so desire.

    3) Some additional material not found in the help screens is included
    for those who want a more in-depth understanding of FastLynx operation.

--------------------------------- Contents ---------------------------------

This guide is organized into sections in the following order:

  * What's new in FastLynx 2.0
  * Choosing between parallel, serial, or Netware IPX
  * Troubleshooting communication problems
  * Split-screen mode
  * Form mode
  * Command mode
  * Slave mode
  * Configuration
  * Upload
  * Key functionality list
  * Hidden, system and read-only files

------------------------ What's new in FastLynx 2.0 ------------------------

FastLynx 2.0 has several new features to help you get your files transferred
faster than ever.

FastLynx 2.0 is completely compatible with Windows 3.0 and Windows 3.1. 
You can run FastLynx in a Windows DOS box and transfer files without
problems.  We have even provided a Windows virtual device driver (VxD) so
that your transfer speeds when running in Windows 386 Enhanced Mode will
approach or even exceed the speeds you get when running under DOS.

Another exciting new feature in FastLynx 2.0 is Netware IPX support.  This
feature allows you to run FastLynx on two systems connected to a Novell
network and transfer files directly between the local hard disks of the two
systems.

Parallel transfers now utilize a new type of parallel cable and a new
technique which boosts parallel transfer speeds by approximately 50% as
compared to FastLynx 1.1.  FastLynx 2.0 can still use the old cable, but to
get the speed improvement you need to use the new cable.

Serial 7-wire transfer speeds have also been boosted by several percentage
points.

In addition, on-the-fly data compression can boost transfer speeds up to
two times or more depending on the type of file and the speed of the CPUs
involved.

With FastLynx 2.0 you get a completely new device driver which allows you
to access remote drives and printers as if they were on the local system. 
Compared to the EBOX device driver included in FastLynx 1.1, this new
device driver offers several advantages:

    1)  Serial and parallel support, drive and printer redirection are
        integrated into a single device driver.

    2)  Serial transfers can utilize the FastLynx 7-wire serial cable to
        achieve speeds up to 210K baud or higher, depending on the CPU
        speeds of the computers involved.  (EBOX was limited to 3-wire
        transfers at 115K baud).

    3)  Parallel transfers can utilize the new FastLynx parallel cable to
        transfer approximately 50% faster than EBOX.

    4)  The new device drivers work well under Window 3.x, and also utilize
        the FastLynx VxD in 386 Enhanced Mode to get the fastest possible
        speed.

    5)  To keep its memory footprint small, the device driver does not
        normally use on-the-fly compression.  However, when running under
        Windows 386 Enhanced Mode, the driver uses compression routines in
        the VxD to boost transfer speeds even higher.

FastLynx can now take advantage of EGA or VGA monitors by displaying
43 or 50 lines on the screen.  To take advantage of this, you must
use the following command at the DOS prompt:

                        mode con lines=43

                                or

                        mode con lines=50

---------- Choosing between parallel, serial, or Netware IPX -------------

                             Netware IPX

If the machines you want to transfer between are already hooked up to a
Novell network, you will probably want to use our new Netware IPX support
to get your files transferred.  On most types of network hardware, you will
get much faster transfer speeds using this method (versus serial or
parallel), plus you will not have to hook up an additional cable.

  			         Speed

The main difference between parallel and serial mode is speed.	Parallel
runs 25% to 4 times faster than serial mode, depending on the speed of the
computer.  You will see less improvement if you are running on standard
PC-type machines than if you are running on faster 80286 or 80386 based
machines.

			      Cable length

If you are planning to do transfers over cables greater than 15 feet long,
you may want to use serial transfer mode.  Parallel transfers under these
conditions sometimes get more transmission errors, and sometimes even fail
to communicate entirely.  7-wire serial cables have a similar problem with
length.  You may have to transfer in 3-wire mode if the 7-wire cable
is unshielded or excessively long.

There are specially shielded cables available in lengths up to 100 feet that
will work at full speed for both the parallel and the 7-wire serial
communications.  Contact Rupp Corporation at (602)224-0897 for details.

				 Port usage

In choosing between serial and parallel, you should consider what ports are
most readily available on the machines you will be using.  For instance, if
you only have one parallel port and do a lot of printing with it, you may
want to choose serial transfer.  On the other hand, if you only have one
serial port and you have a mouse hooked up to it, using the parallel port
for data transfer might be easier.

Additional serial or parallel cables may be purchased as a separate item
from Rupp Corporation for $39.95.  

------------------ Troubleshooting communication problems ------------------

If you are having trouble getting your machines to communicate properly via
a serial or parallel connection, you should make sure that:

    1.	Both computers and their parallel/serial ports are 100% IBM
	compatible.
    2.	"fx" is running on both machines.
    3.	The cable is connected correctly.  If you are doing serial transfer,
	connect the two serial ports (male 9 or 25 pin) with the FastLynx
	cable (or a compatible cable).	If you are doing parallel transfer,
	connect the two parallel ports (female 25 pin) with FastLynx's
	special parallel cable.  Sometimes machines have other ports that
	look like serial or parallel ports but are really not, so make
	sure you are connected to the right type of port.  By default,
	FastLynx automatically determines which port to use.  If you
	have specifically selected a port instead of using auto-port
	select, make sure your cables are connected accordingly.
	(If you configured FastLynx to use COM1, make sure cable is not
	connected to COM2.)
    4.	Each serial device in your machine should be set to a different base
	address.  For instance, don't have 2 serial ports set to COM1.
    5.	The machines are not in Local Copy mode.
    6.	The machine to be the slave is NOT in any of the following:
		Split-Screen with LOCAL COPY on
		Viewing the On-Line Reference Guide
		Upload
		Viewing a help screen
		Configuration
                Diagnostics
                Benchmark

			    Hardware limitations

    A small number of computers have serial port hardware limitations that
    prevent them from using the top baud rate.	One such machine is the IBM
    PS/2 Model 80 (and Model 70), which can only run at 38400 baud.
    Usually FastLynx's auto-baud will detect this and run successfully at
    the lower baud rate.  You may have to set the maximum baud rate manually,
    however.  See the configuration section for more information on how to
    do this.

    In order for FastLynx to get the tremendous speeds that it does, it
    disables interrupts for a while.  Some computers do not operate
    correctly if interrupts are disabled for too long.	If your computer has
    this limitation, then you should try running FastLynx in "safe serial"
    mode.  If the problem persists, try lowering the maximum block size to
    "medium" or "small".  Note that this particular problem applies only to
    serial port transmissions.  See the section on configuration to find out
    how to set the "safe serial" mode or the maximum block size.

----------------------------- Split-screen mode ----------------------------

The split-screen mode is a beginner's interface which is popular with
all types of users because of its ease of use.	It shows you a directory
listing from each machine and allows you to move around with the arrow keys
and "point-and-shoot".

The left side of the screen will contain a listing of files on the local
machine, the right a listing of files on the remote machine.  You can mark
files you want to transfer using the F5 key and then transfer those files to
the other system by pressing the F3 key.  If you only want to send
one file, you can position the inverse bar over the file and press F3
without marking it first.  If no files are marked, the file under the
inverse bar is considered to be marked.  It is not considered marked if
other files have been explicitly marked.

You can also use split-screen mode to transfer files between two
directories on the same computer.  To enter this "Local Copy" mode, simply
press Alt-L while in split-screen mode.  Press Alt-L again when you wish to
establish communications with the remote computer again.  You may also
switch between Local Copy and Remote mode by using an option described
below in the F9 split-screen options section.  If you switch modes using
the F9 options, the mode change will be remembered next time you start the
program.  Switching using the Alt-L key is a temporary change which is not
remembered next time you start the program.  When you are in Local Copy
mode, all of the same activities and options are available, they just
operate on 2 local directories instead of 1 local directory and 1 remote
directory.

Note that files marked on the local listing will be copied to the remote
system, whereas files marked on the remote listing will be copied to the
local system.

You can use the Shift-F5 key to do a wildcard mark.  FastLynx will prompt
you to enter a wildcard specification, and any files matching that
specification will be marked.

Similarly, you can use Shift-F7 to do a wildcard unmark.  FastLynx will
prompt you to enter a wildcard specification, and any files matching that
specification will be unmarked.

You can use the F7 key to cancel all marks on any file or directory.

The F4 key allows you to create a new directory from split-screen mode.

To move to a different directory, position the inverse bar over the
directory you want to go to and press the Enter key, or use the F2 key to
enter a new drive and directory.  To switch the active directory listing,
use the Tab key, or the left/right arrow keys.

The split-screen mode contains some extra functions that help you to
maintain the files on your disk. You can delete, rename, or view a file
without having to leave the split-screen mode.	If you want to delete or
rename several files, you can mark them using the F5 key and then use the
Del or F6 key to perform the desired operation.  The Local Copy mode is
useful for copying files between drives or directories on the same computer.
(See description of Local Copy above.)

The delete function allows you to delete subordinate directories and files.
If you press the Del key when you are on an empty directory, it will delete
it.  If the directory has files or subdirectories in it, FastLynx will tell
you how many subordinate files and directories there are, and then prompt
you to see if you want to delete them all.  You may choose to go ahead and
delete them all or abort the operation.

If you want to get quickly to one of the other modes, you can use Alt-F to
get to Form mode or Alt-C to get to Command mode.

The first entry in the directory listings is "*".  This is not actually part
of the directory, but means "all files in the directory".  So if you
transfer this item, it will transfer all files in the current directory.  If
you mark this item, you will notice that all files in the directory are
marked also.

Files in the directory listing are sorted according to the specification
in the split-screen options menu.  As shipped, this setting sorts files
alphabetically.  You can change this setting so that the directory is sorted
by date, size, extension, or not sorted at all.  If you want to find a
particular file, you can also do so by typing the name of the file, and the
inverse bar will move to the first file that matches the characters you have
typed.	If no match is found, the program will beep.

There are several options that you can use to customize the split-screen
mode.  These options can be called up by pressing the F9 key.  The first
group of options are automatically saved whenever you change them, and
remain in effect the next time you run the program.  These options are:

			       Date comparison

    You can choose to always copy files (default), or to have FastLynx
    compare the source and target file dates, transferring only files that
    are newer.

				 Directories

    There are three options for copying subdirectories.  The option to
    transfer subdirectories, creating new ones as needed, is like the "/S"
    option of command mode, or of the DOS "backup" or "xcopy" commands.  The
    option to not transfer subdirectories is similar to DOS "backup" or
    "xcopy" without the "/S".  The third options (like "/R" of command mode)
    is unique to FastLynx.  It allows you to transfer only subdirectories
    that already exist on the target computer.	Use of this option allows
    you to maintain a directory structure on one machine that is a subset of
    the directory structure on the other machine.  The default is to not
    transfer subdirectories.

				   Sort by

    This option allows you to choose the order in which files and
    directories will be displayed.  The different methods of sorting are:
	name	    - sort by the name and then extension
	extension   - sort by the extension and then name
	size	    - sort by size of the file
	date	    - sort by date and then time of modification

    For each of these sorting options, you can sort forward or backward.
    For instance, you can sort by size with the smallest file first or
    the largest file first.  Directory names are sorted separately, and are
    displayed before the file names.  There is also an option not to sort,
    which shows files and directories in the order they occur on the disk.


				 Prompt Mode

    This option allows you to select a level of prompting.  By default,
    FastLynx comes configured to prompt before overwriting a file. There are
    four levels to select from:

	Do not prompt before transfers -- This level does no prompting at
	all.

	Prompt before subdirectories -- This level prompts you before
	sending a subdirectory.  You can choose how to be prompted (if at
	all) for files in the subdirectory or choose to skip the
	subdirectory all together.

	Prompt before overwriting files -- This level prompts before
	sending subdirectories (as above) and also causes FastLynx to
	prompt before a file is overwritten.  At transfer time you can
	choose whether or not to send the file.  The filename and the dates
	of the files on both machines will be displayed with the prompt.
	This is the default prompt mode for Split-Screen.

	Prompt before each transfer -- This prompt level also prompts
	before sending subdirectories (as above) and also causes FastLynx
	to prompt before any file is transferred (whether it exists on the
	receiving system or not).  With this prompt level you can decide
	on a file by file basis whether to transfer the file or not.

				Local/Remote

    By default, FastLynx comes configured to transfer files between two
    computers connected by a serial or parallel cable.	This is the
    "Remote Copy" setting for this option.  You can, however, switch
    FastLynx into a "Local Copy" mode which allows you to copy files
    between two different directories (or drives) on the local system.
    The Alt-L hotkey is provided as a quicker way to switch between
    these two modes.

The rest of the split-screen options are temporary settings that remain in
effect only while you are running the program.	The next time you run the
program they will default back to their original settings.
These options are:

				Fake It Mode

    This option allows you to tell FastLynx to "fake" a transfer and report
    what files would have been sent (without actually sending them).

				Exclude list

    Any files or directories that you specify in this list will NOT be
    shown in the directory listing, although they may exist on the machine.
    Wildcards are accepted.  IMPORTANT NOTE:  you must specify only the
    root portion of the files or directories that you want to exclude.
    Leading drive letter or path name prefixes are not allowed and will
    cause the exclude to fail if entered.
	Valid names: data *.doc
	Invalid names: c:\data c:\data\*.doc \data\subdir


				 Cutoff date

    This option allows you to send only files modified after a specified
    date.  If you want to send files regardless of modification time, leave
    the cutoff date set to its default value of January 1, 1980, 12:00 am.
    Any files before the date cutoff will NOT be shown in the directory
    listing, although they may exist on the machine.


--------------------------------- Form mode --------------------------------

The form mode is an intermediate interface which allows you to create, edit
and execute customized command sequences called "forms".  This powerful mode
enables you to build your own list of frequently used transfer commands and
call them up quickly whenever you need them.  This can save you a lot of
time because you can quickly call up any form you have used before and
execute it again.

On the left of the screen is a list of forms that have already been created.
On the right side of the screen is a display indicating the contents of the
form that the inverse bar is currently on.  As you use the up and down
arrows to move through the list of forms, the currently highlighted one will
be displayed at the right.  You can modify an existing form by pressing the
Enter key.  You can add forms to the list using the Ins (or F2) key, and
delete forms from the list using the Del key.  You can execute forms with
the F3 key.

The forms are shown alphabetically.  If you want to find a particular form,
you can also do so by typing the name, and the inverse bar will move to the
first form that matches the characters you have typed.	If no match is
found, the program will beep.

When executing or deleting multiple forms, you can mark the forms you want
and then execute or delete them all at once.  You can do this using the '+'
and '-' keys, which mark and unmark items, or you can use the F5 key, which
toggles the marked state for the current item.

Once you have selected a form to edit, your arrow keys will move you through
the fields containing the form information.  Modifying or creating a form is
simply a matter of filling in information in these fields.  Use the up and
down arrow keys to highlight the field you want to change, and then press
the Enter key to edit the field.  You should see a cursor appear in the
field after it has been selected.  Use the up arrow, down arrow, or Enter
keys to move out of a field that you have edited and save the changes.	To
get out of a selected field and cancel any changes to the field, use the Esc
key.  After you have edited all desired fields, use the Esc key to get out
of the form, and then select the "Save and Exit" option if you want to save
the changes you made.  Note that pressing Esc while a field is selected
exits you from that field.  Pressing Esc when no field is selected exits you
from the entire form.

Form mode has an F9 option key which allows you to change one temporary
setting.  This option is Fake it Mode.	If you select fake file transfers,
FastLynx will "fake" the form transfer and report what files would have been
sent without actually sending them.  Note that this option does not effect
the split-screen or command mode transfers.

If you want to get quickly to one of the other modes, you can use Alt-S to
get to Split-Screen mode or Alt-C to get to Command mode.

There are several transfer fields that you can use to customize the forms.
These options are:

				Local/Remote

    Choose whether to transfer files between the local and remote computer
    or copy between directories on the local system (Local Copy).  This
    selection affects the next 3 fields.
    If you select Remote, the next 3 fields will be:
		Send/Receive
		Local Drive
		Remote Drive
    If you select Local, the next 3 fields will be:
		(Send/Receive) - not applicable
		Source
		Destination

			 Send/Receive (Remote Copy)

    Choose to have the files sent to or received from the remote (other)
    machine.  If you have picked Local Copy mode for this form, this field
    is not applicable, because files will always be copied from the Source
    drive to the Destination drive.

			  Local drive (Remote Copy)

    Specify a drive and/or directory name which will be used as the default
    local drive and directory for file names which do not specify a drive or
    directory.	If not specified, FastLynx will use the current drive and
    directory on the local system.  Does not affect file names that contain
    a complete path name.

			 Remote drive (Remote Copy)

    Specify a drive and/or directory name which will be used as the default
    remote drive and directory for file names which do not specify a drive
    or directory.  If not specified, FastLynx will use the current drive and
    directory on the remote system.  This field does not affect file names
    that contain a complete path name.

			     Source (Local Copy)

    Specify a drive and/or directory name which will be used as the default
    sending drive and directory for file names which do not specify a drive
    or directory.  If not specified, FastLynx will use the current drive and
    directory on the local system.  Does not affect file names that contain
    a complete path name.

			  Destination (Local Copy)

    Specify a drive and/or directory name which will be used as the
    destination drive and directory for files to be copied.  You must
    specify a destination for the Local Copy transfer to be successful.

				 Select list

    This is a list of files to be transferred.	Any combination of drive,
    directory, and file name (including wildcards) is accepted.  Specifying
    a directory name selects all files in the directory.

				Exclude list

    Any files or directories that you specify in this list will NOT be
    transferred.  Wildcards are accepted.  IMPORTANT NOTE:  you must
    specify only the root portion of the files or directories that you want
    to exclude.  Leading drive letter or path name prefixes are not allowed
    and will cause the exclude to fail if entered.
	Valid names: data *.doc
	Invalid names: c:\data c:\data\*.doc \data\subdir


				 Directories

    There are three options for copying subdirectories.  The option to
    transfer subdirectories, creating new ones as needed, is like the "/S"
    option of command mode, or of the DOS "backup" or "xcopy" commands.  The
    option to not transfer subdirectories is similar to DOS "backup" or
    "xcopy" without the "/S".  The third options (like "/R" of command mode)
    is unique to FastLynx.  It allows you to transfer only subdirectories
    that already exist on the target computer.	Use of this option allows
    you to maintain a directory structure on one machine that is a subset of
    the directory structure on the other machine.

				 Prompt Mode

    The prompt level for a form can be selected on a form by form basis.
    The available prompt mode levels are the same as for split-screen mode.

			       Date comparison

    You can choose to copy all selected files or to have FastLynx
    compare the source and target file dates, transferring only files that
    are newer.

				 Cutoff Date

    This option allows you to send only files modified after a specified
    date.  If you want to send files regardless of modification time, leave
    the cutoff date set to its default value of January 1, 1980, 12:00 am.
    Any files before the date cutoff will not be transferred.

In addition to transfer options, each form has a place for comments (so you
can remember what the form is supposed to do) and also keeps track of the
last time that you ran the form (run date and time).

You can run FastLynx forms directly from DOS, so you can set up batch files
to do routine transfers.  Simply remember to precede the form name with
"fx".  Example:  to run form "partback" from DOS, at the DOS
prompt type "fx partback".

If FastLynx cannot find the "fx.cmd" form file, it will create one in the
directory that the FastLynx program is in.  The file is no longer included
on the release diskette, but is created (if not found) by FastLynx with
three default forms.

NOTE:  If you are a previous Fastwire II user, you may want to use the forms
you had created previously.  To do this, locate fw2.cmd on your disk and
issue the DOS command:	"rename fw2.cmd fx.cmd".  This will allow you to use
your old forms instead of having to re-create them.

------------------------------- Command mode -------------------------------

This mode is an advanced command-driven interface which allows you to type
in commands directly.  You can use build-in FastLynx commands to send or
receive files.	You can also execute forms created in form mode, or execute
DOS commands or programs.

The following built-in commands are recognized by FastLynx:
	xm	(sends files to remote computer)
	rq	(requests files from remote computer)
	do	(executes DOS commands and programs on remote computer)
	exit	(causes remote FastLynx to exit back to DOS)

"xm" and "rq" have identical syntax.  The only difference is that "xm" sends
files to the remote computer and "rq" receives files from the remote
computer.  The syntax is as follows:

	[xm or rq] [options ...] <file specifications>

		      Command mode file specifications

    Multiple file and directory names may be included in the same command.
    A file name may include a drive and/or directory name and may also
    include wildcards.	If a directory name is specified, all files in
    that directory are transferred.  If the directory name does not exist on
    the receiving system it will be created, but subdirectories will only be
    transferred if /S is specified.  If a filename is specified, only files
    matching that name are transferred.

			    Command mode options

    /C	Do not create files which do not already exist on target system.
    /D	Transfer files whose date is same or later than specified date:
	/D:mm-dd-yy[,hh:mm]
    /E	Exclude specified files or directories (wildcards OK, path names
	and drive letters not OK):
	/E:filename1,filename2,dirname1[,...]
    /F	Force file transfer even if source date is same or older than
	target.
    /L	Specify default drive and/or directory for local system.  If
	receiving, directory will be created if necessary.
	/L:pathname
    /N	Fake transfer and report what would have been transferred.
    /O	Specify default drive and/or directory for remote (other) system.
	If sending, directory will be created if necessary.
	/O:pathname
    /Pn Prompt mode:  n = 1 prompt before subdirectories, n = 2 prompt
	before overwriting, n = 3 prompt before transferring.  If n is
	not specified (but the /P is), n defaults to 3.
    /R	Transfer files in subdirectories, but DO NOT create new directories.
    /S	Transfer files in subdirectories, creating subdirectories as needed.
    /T	Specify second drive and/or directory for a local copy.
	(Use with /L)
	/T:pathname
    /W	Allow read-only files to be overwritten.

    These options can also be specified with '-' instead of '/'.  For
    instance, "-S" means the same as "/S".

The "do" command will send whatever command you type after "do" to the
remote machine, and execute it just as if you had typed it at the DOS
prompt.  For instance, "do cd \" would change the remote system to the root
directory.

The "exit" command is like a built-in form name which causes the remote
FastLynx program to exit.

Examples:
    rq *.* /p2
	Requests all files in from the current directory on the remote
	system, but prompts before overwriting.

    xm /S /F /Ecommand.com,config.sys,autoexec.bat c:\
	Does the same transfer as form "fullback".

    do cd \data
	Executes the command "cd \data" on the remote computer as if it
	had been typed at the DOS prompt on the other computer.

    exit
	Will cause the FastLynx running on the remote computer to exit
	back to DOS.

If the command you type is not recognized as one of the above built-in
FastLynx commands, but matches the name of a form you have created (in
form mode), the form will be executed. Any other command will be passed
on to DOS.  When the DOS command is done, control will return to FastLynx.

Any command that can be run from command mode can also be executed directly
from DOS, so you can set up batch files to do routine transfers.  Simply
remember to precede the command with "fx".

If you want to get quickly to one of the other modes, you can use Alt-S to
get to Split-Screen mode or Alt-F to get to Form mode.

-------------------------------- Slave mode --------------------------------

While the two computers are connected, one will be the master and one will
be the slave, even though they will both be running "fx".  The master
computer is the one that is in Split-Screen, Form, or Command mode and
issues the transfer commands.  The other computer will display "SLAVE MODE"
at the top of the screen.  This means that it is the slave and just does
what the other computer tells it to do.

There are several keys available from Slave mode.

Esc will cause you to return to the main FastLynx menu.

Pressing Alt-S will make that computer master and then go to Split-Screen
mode.

Pressing Alt-F will make that computer master and then go to Form mode.

Pressing Alt-C will make that computer master and then go to Command mode.

If you type a key other than these pre-defined ones, the computer will
become master and go back to the previous mode it was in (Main menu, Split
screen, Form or Command).  The key you typed will be swallowed, and the
program will wait for the next input.  The exception to this is if you were
previously in Command mode and started typing alpha-numeric keys.  This will
cause you to be put back into Command mode, but instead of ignoring the key
typed, it will be passed along and treated as if you had typed the key from
the command line.

The ability to switch the master-slave roles allows you to initiate
transfers from either computer if you wish, but remember that you can send
files either way from the same computer.  See the sections on Split-screen,
Form or Command mode for more information on transferring files.

There are a few places in the FastLynx program that will not go into slave
mode, and could therefore cause the computers to fail to communicate.  If
you have FastLynx running on both computers and are not able to communicate,
make sure that the computer you want to be the slave is NOT in any of these
places:
	Split-Screen with LOCAL COPY on
	Viewing the On-Line Reference Guide
	Upload
	Viewing a help screen
	Configuration
        Diagnostics
        Benchmark

------------------------------ Configuration -------------------------------

The configuration option allows you to change FastLynx's default settings.
The configuration menu can be reached from the main menu, or with F10 from
any of the three modes.

Once you are inside the configuration option, arrow keys will move you
through the fields containing the default information.	Use the up and down
arrow keys to highlight the field you want to change, and then press the
Enter key to edit the field.  You should see a cursor appear in the field
after it has been selected.  Use the up arrow, down arrow, or Enter keys to
move out of a field that you have edited and save the changes.	To get out
of a selected field and cancel any changes to the field, use the Esc key.
After you have edited all desired fields, use the Esc key to get out, and
then select the "Save and Exit" option if you want to save the changes you
made.  Note that pressing Esc while a field is selected exits you from that
field.	Pressing Esc when no field is selected exits you from the entire
configuration menu.

When you save the changes to the configuration, they are automatically
remembered for the next time you call up the program.  When the
configuration is saved, it updates "fx.exe" on the same machine.  It does
NOT update the program on the machine you are communicating with.  To do
this, you must run FastLynx on the other machine and change the
configuration there.

If FastLynx is unable to update the program, it will give you an error
message and then continue with normal execution.  Usually the only reason
for this type of problem is if there is a disk error or if you have removed
the disk containing "fx.exe".  If this error occurs, the configuration
options will still remain in effect for FastLynx until you exit the program,
but they will not be saved permanently.

IMPORTANT NOTE:  FastLynx supports parallel, serial and IPX transfer. 
There is no configuration option to tell FastLynx whether to operate
in parallel or serial or IPX transfer mode.  FastLynx will figure
that out automatically after you have plugged in the appropriate
cable.  FastLynx will first check for a parallel or serial
connection, and then for an IPX connection.  You can tell FastLynx
which ports it can and cannot use, however.  See the port list
configuration for details.


The following options are available in the configuration screen:

			   Port List Configuration

    In most cases you will want to leave the port list set to LPT*,COM*,IPX.
    This tells FastLynx to automatically select which port to use.
    FastLynx does this by looking to see what ports you have in your
    system and then experimentally determining which port is connected to
    a system running another FastLynx program.	There are two cases where
    you may want to supply information in the port list field.

    The first case is if you have an active device such as an on-line
    printer or a mouse connected to one of your serial ports.  In this
    case you should tell FastLynx which ports it can use so that it does
    not send test characters to the on-line device.  To tell FastLynx
    which ports it can use, simply enter the port's name (such as "COM1"
    or "LPT2") in the port list.  Multiple port names can be entered
    separated by commas.  Entering a '*' instead of a port number tells
    FastLynx to try all ports of that type.

    Example:  "COM1,COM3,LPT*" tells FastLynx to try serial ports COM1 and
    COM3, all parallel ports, but not COM2.

    Another case where you will want to enter information in the port list
    is if you are using a port with a base address other than the
    standard BIOS addresses.  This situation normally occurs when you
    have three or more serial ports in the machine.  To tell FastLynx to
    use non-standard serial port address, enter a 'C' followed by the
    base address (in hexadecimal) of the port.	FastLynx ignores port
    addresses that are not divisible by eight or fall outside of the
    range 200H-8000H (this check can be overridden by entering an '!'
    after the port address).

    Non-standard parallel ports can be entered by typing an 'L' followed
    by the port address (in hexadecimal).  Similar range checking and
    divisibility rules apply.

    Suppose you add two serial ports to a machine that already has two
    standard serial ports and that the two new port addresses are 300 and
    30A.  If you want FastLynx to automatically select between any of the
    four ports, you would enter "COM*,C300,C30A!" in the port list (30A
    would normally be ignored by FastLynx, but is accepted because of the
    '!').

    FastLynx will look for a Netware IPX connection if you have "IPX" in
    the port list, and if no serial or parallel connection is found.
    You will be presented with a list of available IPX connections to select
    from.  To appear on the list, the work station must be running
    FastLynx and have "IPX" in the port list.  FastLynx will search for 
    the environment variable FX_NAME and display whatever it is set to in 
    the IPX list, along with the user name (if logged on). If you do not 
    want your machine to be available for a Netware IPX connection, 
    remove "IPX" from the port list.

                             Serial Transfer Mode

    FastLynx has two options for Serial Transfer Mode:

                1)  Allow fast transfer method
                2)  Force safe transfer method

    Unless you are having problems transferring serially, leave this 
    selection at the default setting of "Allow fast transfer method".
    This setting will enable serial transfers to go as fast as possible 
    but will still drop down to a slower, safer method when necessary.  
    If you are having problems such as the machine locking up when you
    attempt to transfer serially, use the setting "Force safe transfer 
    method".

    FastLynx will show that it is operating in safe mode by displaying 
    an 's' before the baud rate (COM1:s115200+).  The following display 
    means that FastLynx is sending in safe mode, but receiving in fast
    mode:   COM1:s115200/115200.

                               Data Compression        

    FastLynx provides on-the-fly data compression to boost transfer speeds.
    The three configuration options for compression are:

                1)  Never use compression
                2)  AUTO
                3)  Always use compression

    The default is AUTO, which lets FastLynx determine when to use
    compression and when not to.  If you know in advance whether using
    compression is going to help or hurt you on a particular set of files,
    you can gain a slight speed advantage by changing this setting to 
    "Always use compression" or "Never use compression" as appropriate.

			Error Checking Configuration

    FastLynx has two basic methods of detecting errors:  checksum or
    CRC.  The CRC method is much better at detecting transmission errors.
    The checksum method, though not nearly as good at detecting errors
    as a CRC, is generally considered adequate for a direct line
    connection (since error rates are so low).	It is also much faster.
    Several of our competitors offer only this method (or some variant
    thereof).

    If both systems are configured to use checksum, FastLynx will use this
    method initially, but if any errors are detected, it will drop back
    to the CRC method.  If FastLynx is using checksum, it will display
    an exclamation point after the connection status (LPT1:Turbo+!). 
    If the exclamation point is not displayed, FastLynx is using CRC.

    The "Use CRC only" mode is the safest possible way to transfer your files.
    The default "Allow Checksum" mode is recommended for users who want more 
    speed and rarely experience transmission errors.	

The following configuration settings are advanced options.  Most users
will never need to modify these settings.  If you experience excessive
transmission errors or other problems, you might try adjusting the appropriate
advanced options to fix the problem.

	                     Maximum Serial Baud   

    The Maximum Serial Baud option applies only to serial port
    transfers.  The possible baud rates range from 115200 to 9600.
    This option sets the maximum baud rate that FastLynx will try to
    connect at.  FastLynx will always experimentally determine what the
    fastest possible baud rate is when two machines are connected.  
    Since this is usually 115200, the Maximum Serial Baud should usually be
    left at 115200.  If FastLynx detects a problem with the highest baud
    rate, it will drop down until it finds one that will work.

    Because FastLynx automatically selects the appropriate baud rate
    in most cases, this setting generally will not need to be modified.
    However, if the serial port chip on a machine cannot operate at the
    highest baud rate, you may want to set the Maximum baud to the highest
    baud the machine is capable of.  When a connection is made to another
    computer, the LOWEST Maximum Serial Baud of the two machines will
    be made the maximum for the connection. 
    
                      Serial Accelerated (7-wire) Mode

    With this option enabled (the default), FastLynx will automatically 
    take advantage of a 7-wire serial cable to transfer data at higher
    speeds.  It will always operate in standard mode when it detects
    a 3-wire cable.  When FastLynx is using serial accelerated mode,
    it will display a plus sign (+) after the baud rate.  For example,
    if the connection line shows:     

                        COM1:115200+

    this means that FastLynx is taking advantage of a 7-wire cable.

    So far we have not found a situation where it has been necessary to 
    disable accelerated mode.  We provide the disable option simply as
    a safety valve in case you encounter a marginal situation where
    FastLynx inappropriately tries to operate in accelerated mode.

                      Parallel Accelerated (8-bit) Mode

    With this option enabled (the default), FastLynx will automatically 
    take advantage of the new FastLynx parallel cable to transfer data
    at a higher speed.  It will always operate in standard mode when
    it detects the older FastLynx parallel cable.  When FastLynx is 
    using parallel accelerated mode, it will display a plus sign (+)
    after the connection status.  For example, if the connection line
    shows:

                LPT1:Turbo+

    this means that FastLynx is taking advantage of a new parallel cable.

    So far we have not found a situation where it has been necessary to 
    disable accelerated mode.  We provide the disable option simply as
    a safety valve in case you encounter a marginal situation where
    FastLynx inappropriately tries to operate in accelerated mode.

			     Maximum Block Size      

    This option controls the maximum size that will be used for individual 
    data blocks during transfers.  Using the "large" option is generally 
    the best since it gives you the fastest transfer speed.  The "medium"
    and "small" options use progressively smaller block sizes.  Most
    systems can handle the larger block sizes without any problems,
    but some cannot.  If you experience excessive transmission errors
    or any other problems, try using a smaller block size setting.

---------------------------------- Upload ----------------------------------

The upload option is designed to allow you to transfer FastLynx to another
system which does not already have FastLynx on it.  This unique capability
is particularly useful when you encounter a need to transfer files and do
not have a FastLynx disk (of the right size) with you.

The Upload option can be selected from the Main Menu or from SPLIT SCREEN
mode when the remote system is not connected.

1)  First make sure the FastLynx serial cable is connected between the two
    computers.	If you are using your own cable, it must be a 7-wire cable
    compatible with the FastLynx cable.  You may use COM1 or COM2 on either
    machine, but not COM3 or COM4 (although regular FastLynx transfers can
    use COM3 and COM4).

2)  Please indicate which serial port (COM1 or COM2) the remote computer is
    using.  FastLynx can automatically determine which local serial port
    you are using, but cannot tell which port you selected on the remote
    machine.

3)  If you selected COM1 for the remote machine, type the following DOS
    command on the remote system:

	  mode com1:2400,n,8,1,p	 (and press the Enter key)

    If you selected COM2 for the remote machine, type the following DOS
    command on the remote system:

	  mode com2:2400,n,8,1,p	 (and press the Enter key)

    You should see one of the following responses from DOS:

	  COM1:2400,N,8,1    or   COM2:2400,N,8,1

    The intent of this step is to initialize the serial port to 2400 baud, no
    parity, 8 data bits, and 1 stop bit.

    If you saw a "Bad command" error message from DOS, you will need to
    find a DOS diskette that has the DOS "mode" command on it and try again.

4)  If you selected COM1 for the remote system, type the following DOS
    command on the remote system:

	  ctty com1			 (and press the Enter key)

    If you selected COM2 for the remote system, type the following DOS
    command on the remote system:

	  ctty com2			 (and press the Enter key)

You should see a "Loading bootstrap ..." message shortly after typing the
above command--this means that communication has been established and
the upload is in progress.

Note:  If the upload process does not complete successfully, it will be
necessary for you to re-boot (reset) the remote machine.

The following FastLynx files will be transferred into the currently
selected drive and directory.  If there is enough disk space available
FastLynx will transfer the following files:

    FX.EXE	(the FastLynx program file)
    FX.HLP	(the FastLynx help file)
    GUIDE.FX	(the FastLynx on-line guide)

Note that the upload process does not transfer the device driver files.
You can use FastLynx itself to transfer those files.  The on-line guide
will be transferred if it is found, otherwise just the program and help
files will be sent.

There are several reasons why the upload can fail.  If you are having
problems please check the following list:

    1)	Insure serial cable is FastLynx compatible and securely connected.
    2)	Insure the remote serial port you specified is really the one to
	which the cable is connected.
    3)	Insure that the "mode" and "ctty" commands were typed exactly as
	specified.
    4)	If the upload fails consistently, try it again without the ",p" at
	the end of the "mode" command.

If the upload feature fails, try loading FastLynx onto the remote system
using floppy disks or whatever other methods are available to you.  There
are a few situations where FastLynx itself can transfer files even though
the upload process does not work.

-------------------------- Key functionality list --------------------------

The following is a definition of all keys used by FastLynx:

Press:		When you want:
--------------	------------------------------------------------------------
F1		General help information
F2 or Ins	To changes drives and/or subdirectories while in SPLIT
		SCREEN MODE
		Create a new form in FORM MODE
F3		To transfer files(s) or execute form(s)
F4		To Create a directory while in SPLIT SCREEN MODE
F5		To mark or unmark the file(s) to be transferred while in
		SPLIT SCREEN MODE or form(s) to be executed in FORM MODE
		(toggles current state)
Shift-F5	To mark files using wildcards in SPLIT SCREEN MODE
F6		To Rename a file in SPLIT SCREEN MODE
F7		To unmark all files in SPLIT SCREEN MODE or all forms
		in FORM MODE
Shift-F7	To unmark files using wildcards in SPLIT SCREEN MODE
F8		To View a file while in SPLIT SCREEN MODE
F9		To call up the options screen in SPLIT SCREEN or FORM MODE
F10		To enter the CONFIGURATION menu to change default settings
Esc		To return to previous menu or exit program
Ctrl-Break	To return to previous menu or exit program
Ins		To add a new form in FORM MODE
Del		To delete a file or directory in SPLIT SCREEN MODE
		To delete a form in FORM MODE
Tab		To move cursor between local/remote drive listings in the
		SPLIT SCREEN MODE
Left/Rt arrows	To move cursor between local/remote drive listings in the
		SPLIT SCREEN MODE
'+'             To select the file(s) to be transferred while in SPLIT
		SCREEN MODE or form(s) to be executed in FORM MODE
'-'             To unselect the file(s) to be transferred while in SPLIT
		SCREEN MODE or form(s) to be executed in FORM MODE
Enter		To change to directory or re-read directory in SPLIT SCREEN
		MODE.  Select an item to be edited or modified in FORM MODE
		and configuration menu
PgUp, PgDn	To move the cursor up/down a page at a time
Home		To move the cursor to top of list
End		To move the cursor to bottom of list
Alt-C		To go to COMMAND MODE from SPLIT SCREEN MODE or FORM MODE
		or SLAVE MODE
Alt-S		To go to SPLIT SCREEN MODE from COMMAND MODE or FORM MODE
		or SLAVE MODE
Alt-F		To go to FORM MODE from SPLIT SCREEN MODE or COMMAND MODE
		or SLAVE MODE
Alt-L		To switch between Local Copy and Remote Copy in SPLIT SCREEN
		MODE
Alt-M		To toggle monochrome/color output from MAIN MENU
		To go to MAIN MENU from SLAVE MODE

-------------------- Read-only, hidden and system files --------------------

FastLynx can transfer files and directories that are read-only,
hidden or system.  Because these are special files, FastLynx handles
them a bit differently than normal files and directories.  A
read-only, hidden or system file will only be transferred if it
doesn't exist on the target machine.  This is to prevent unwanted
over-writing or moving of this type of files.  This behavior can be
partially overridden in Command Mode with the /W switch.  If
the /W switch is present, Read-Only files will be overwritten even if
they exist on the receiving system.

FastLynx will also delete system, hidden and read-only
files and directories, but will ask for additional verification to make
sure you really want the file or directory deleted.
