{ REVERSE.PAS : Filter to reverse line order in text stream

  Title   : REVERSE
  Version : 1.1
  Date    : Dec 01,1996
  Author  : J.R. Ferguson
  Language: Borland Pascal v7.0
  Usage   : Refer procedure Help
  Download: Author's Internet site www.xs4all.nl/~ferguson
            To compile this sourcefile you will need units from the Pascal
            library JRFPAS that can be found on the same Internet site.
  E-mail  : j.r.ferguson@iname.com
}

{$V-}
{$R+}

{$UNDEF OUTBUFHEAP}   { UNDEF to work around a BP 7.0 bug resulting in
                        erroneous file output }

program REVERSE;


uses DefLib, ArgLib, StpLib, ChrLib, Objects;


const
  MAXFNM    = 79;     { Max filespec length (integrated environment) }
  DFLMSG    = 'CON';  { Default message output destination }
  DFLKEEP   = 1;      { Default number of lines to keep together }
  INPBUFSIZ = 4096;   { Input buffer size in bytes }
  OUTBUFSIZ = 4096;   { Output buffer size in bytes }

  { Error codes and messages: }
  ERROK     = 0;
  ERRARG    = 1;
  ERRFNF    = 2;
  ERRCRE    = 3;
  ERRREA    = 4;
  ERRWRI    = 5;
  ERRMEM    = 6;
  ERRIDX    = 7;
  ERROVF    = 8;
  ERRBUF    = 9;

  ERRMSG    : array[ERRFNF..ERRBUF] of StpTyp =
 ('File not found',
  'File creation error',
  'Read error',
  'Write error',
  'Out of memory',
  'Line buffer index out of range: index = ',
  'Line buffer overflow: index = ',
  'Line buffer error, code = '
 );

type
  InpBufTyp = array[1..INPBUFSIZ] of char; InpBufPtr = ^InpBufTyp;
  OutBufTyp = array[1..OUTBUFSIZ] of char; OutBufPtr = ^OutBufTyp;

  P_LineBuf = ^T_LineBuf;
  T_LineBuf = Object(TCollection)
   procedure  FreeItem(V_Item: Pointer); virtual;
   procedure  Error(V_Code, V_Info: integer); virtual;
  end;

var
  ErrCod    : integer;
  ErrNum    : integer;
  ErrInf    : integer;
  InpFnm,
  OutFnm    : StpTyp;
  Msg,
  Inp,
  Out       : Text;
  InpBuf    : InpBufPtr;
{$IFDEF OUTBUFHEAP}
  OutBuf    : OutBufPtr;
{$ELSE}
  OutBuf    : OutBufTyp;
{$ENDIF}
  LineBuf   : P_LineBuf;
  InpOpn,
  OutOpn    : boolean;
  OptHlp    : boolean;
  OptKeep   : integer;


{--- T_LineBuf ---}


procedure  T_LineBuf.FreeItem(V_Item: Pointer);
begin if V_Item <> nil then StpFree(StpPtr(V_Item)); end;

procedure  T_LineBuf.Error(V_Code, V_Info: integer);
begin case V_Code of
  coIndexError: begin ErrCod:= ERRIDX; ErrInf:= V_Info; end;
  coOverflow  : begin ErrCod:= ERROVF; ErrInf:= V_Info; end;
  else          begin ErrCod:= ERRBUF; ErrNum:= V_Code; ErrInf:= V_Info; end;
end; end;


{--- General routines ---}


procedure Help;
  procedure wi(i: integer);  begin write  (Msg,i) end;
  procedure wr(s: StpTyp );  begin write  (Msg,s) end;
  procedure wl(s: StpTyp );  begin writeln(Msg,s) end;
begin
wl('REVERSE v1.1 - Reverse line order in text stream');
wl('Usage  : REVERSE [<in] [>out] [/option[...] [...]]');
wr('Options: Ln  Keep groups of n lines together (n=1..');
  wi(maxint);
  wr(', default ');
  wi(DFLKEEP);
  wl(')');
wl('         H   Send this help text to (redirected) output.');
wl('Remarks: All lines must fit in memory together.');
end;

function HeapErrHandler(V_Size: Word): integer; far;
{ causes New and GetMem to return nil on memory overflow }
begin HeapErrHandler:= 1; end;



{--- Command line parsing ---}


function ReadNumOpt(var arg: StpTyp; var n: integer): boolean;
const Ord0 = ord('0');
var   ok: boolean; c: char;
begin
  ok:= false; n:= 0;
  c:= StpcGet(arg);
  while IsDigit(c) do begin
    n:= 10*n + (ord(c) - Ord0);
    c:= StpcGet(arg);
  end;
  ReadNumOpt:= (c=#0) and (n>0);
end;


procedure ReadOpt(var arg: StpTyp);
var nextopt: boolean;
begin
  StpDel(arg,1,1);
  repeat
    if StpEmpty(arg) or (StpcRet(arg,1) = '/') then ErrCod:= ERRARG
    else begin
      nextopt:= false;
      while (ErrCod=ERROK) and not nextopt and not StpEmpty(arg) do
      case StpcGet(arg) of
        'L': if not ReadNumOpt(arg,OptKeep) then ErrCod:= ErrArg;
        'H': OptHlp:= true;
        '/': nextopt:= true;
        else ErrCod:= ERRARG;
      end;
    end;
  until (ErrCod <> ERROK) or not nextopt;
end;


procedure ReadArgs;
var i   : ArgInd;
    arg : StpTyp;
begin
  GetArgs; i:= 0;
  while (ErrCod = ERROK) and (i < ArgC) do begin
    Inc(i); StpCpy(arg,ArgV[i]); StpUpp(arg);
    case StpcRet(arg,1) of
      '/' : ReadOpt(arg);
      '<' : StpSub(InpFnm,arg,2,MAXFNM); {simulate MS-DOS in Integrated Env}
      '>' : StpSub(OutFnm,arg,2,MAXFNM); {simulate MS-DOS in Integrated Env}
      else  ErrCod:= ERRARG;
    end;
  end;
  if OptHlp then if ErrCod = ERROK then ErrCod:= ERRARG else OptHlp:= false; 
end;



{--- Low-level I/O ---}


procedure OpenMsg;
begin
  if OptHlp then Assign(Msg,OutFnm) else Assign(Msg,DFLMSG);
  rewrite(Msg);
end;


procedure CloseMsg;
begin Close(Msg) end;


procedure OpenInp;
begin
  Assign(Inp,InpFnm); new(InpBuf);
  if InpBuf = nil then ErrCod:= ERRMEM
  else begin
    SetTextBuf(Inp,InpBuf^);
    {$I-} reset(Inp); {$I+}
    if IOresult <> 0 then ErrCod:= ERRFNF else InpOpn:= true;
  end;
end;


procedure CloseInp;
begin
  if InpBuf <> nil then dispose(InpBuf);
  {$I-} Close(Inp); {$I+}
  if IOresult = 0 then InpOpn:= false;
end;


procedure ReadInp(var line: StpTyp);
begin
  {$I-} readln(Inp,line); {$I+}
  if IOresult <> 0 then ErrCod:= ERRREA;
end;


procedure OpenOut;
begin
  Assign(Out,OutFnm);
{$IFDEF OUTBUFHEAP}
  new(OutBuf);
  if OutBuf = nil then ErrCod:= ERRMEM
  else begin
    SetTextBuf(Out,OutBuf^);
{$ELSE}
    SetTextBuf(Out,OutBuf);
{$ENDIF}
    {$I-} rewrite(Out); {$I+}
    if IOresult <> 0 then ErrCod:= ERRCRE else OutOpn:= true;
{$IFDEF OUTBUFHEAP}
  end;
{$ENDIF}
end;


procedure CloseOut;
begin
{$IFDEF OUTBUFHEAP}
  if OutBuf <> nil then dispose(OutBuf);
{$ENDIF}
  {$I-} Close(Out); {$I+}
  if IOresult = 0 then OutOpn:= false else begin
    if ErrCod = ERROK then ErrCod:= ERRWRI;
  end
end;


procedure WriteOut(line: StpTyp);
begin
  {$I-} writeln(Out,line); {$I+}
  if IOresult <> 0 then ErrCod:= ERRWRI;
end;


{--- Main line ---}


procedure MainProcess;
var line: StpTyp; p: StpPtr; i: integer;
begin
  while (ErrCod = ERROK) and not eof(Inp) do begin
    ReadInp(line);
    if ErrCod = ERROK then begin
      p:= StpAlloc(line);
      if p=nil then ErrCod:= ERRMEM
      else LineBuf^.Insert(p);
    end;
  end;
  while (ErrCod = ErrOK) and (LineBuf^.Count mod OptKeep <> 0) do begin
    p:= StpAlloc('');
    if p=nil then ErrCod:= ERRMEM
    else LineBuf^.Insert(p);
  end;
  while (ErrCod = ERROK) and (LineBuf^.Count > 0) do begin
    i:= LineBuf^.Count - OptKeep; if i < 0 then i:= 0;
    while (ErrCod = ERROK) and (i < LineBuf^.Count) do begin
      WriteOut(StpPtr(LineBuf^.At(i))^);
      if ErrCod = ERROK then LineBuf^.AtFree(i);
    end;
  end;
end;


procedure MainInit;
begin
  HeapError:= @HeapErrHandler;
  ErrCod:= ERROK; ErrNum:= 0; ErrInf:= 0;
  StpCreate(InpFnm); InpOpn:= false;
  StpCreate(OutFnm); OutOpn:= false;
  LineBuf := nil;
  OptHlp  := false;
  OptKeep := DFLKEEP;
  ReadArgs;
  if ErrCod = ERROK then OpenInp;
  if ErrCod = ERROK then OpenOut;
  if ErrCod = ERROK then begin
    New(LineBuf,Init(100,100));
    if LineBuf = nil then ErrCod:= ERRMEM;
  end;
end;


procedure MainTerm;
begin
  if InpOpn then CloseInp;
  if OutOpn then CloseOut;
  if ErrCod <> ERROK then begin
    OpenMsg;
    if (ErrCod=ERRARG) then Help
    else begin
      write(Msg,'REVERSE: ',ERRMSG[ErrCod]);
      case ErrCod of
        ERRIDX,
        ERROVF: writeln(Msg,ErrInf);
        ERRBUF: writeln(Msg,ErrNum,' info = ',ErrInf);
        else writeln(Msg);
      end;
    end;
    CloseMsg;
  end;
  if LineBuf <> nil then Dispose(LineBuf,Done);
end;


begin { Main program }
  MainInit;
  if ErrCod = ERROK then MainProcess;
  MainTerm;
end.
