#include "modern.h"
#ifdef MODERN
#	include <string.h>
#else
	int  strlen();
#endif
#define ERROR (-1)
#define FALSE 0
#define TRUE  1

#ifdef MSDOS
static int fnmatch __ARGS__((char*, char*, int));

static int fnmatch(p, s, l)
register char *p; /* pattern */
register char *s; /* name to compare */
{
   register c1, c2;

   for (; *p && l; ++p, ++s, l--) {
      if (*p == '*') {
         while (*++p == '*');
         while (l) if (fnmatch(p, s++, l--)) return TRUE;
         break;
      }
      if (*p == '?') continue;

      if ((c1 = *p) >= 'a' && c1 <= 'z') c1 -= 'z'-'Z';
      else if (c1 == '\\') c1 = '/';

      if ((c2 = *s) >= 'a' && c2 <= 'z') c2 -= 'z'-'Z';
      else if (c2 == '\\') c2 = '/';

      if (c1 != c2) return FALSE;
   }
   return !(*p || l);
}

int fmatch(p, s)
register char *p; /* pattern */
register char *s; /* name to compare */
{
   register i, j;

   if (fnmatch(p, s, (i=strlen(s)))) return TRUE;
   if (!i) return FALSE;

   j = i;
   do {
      if (s[--j] == '.') goto dot;
   } while (j && s[j]!='\\' && s[j]!='/' && s[j]!=':');

   /* No dot in the file name */
   s[i] = '.'; /* Overwrite '\0' */
   j = fnmatch(p, s, i+1);
   s[i] = '\0';
   return j;
dot:
   if (/* file name contains extension? */ i-j > 1 ||
      !j || s[j-1]=='\\' || s[j-1]=='/' || s[j-1]==':' || s[j-1]=='.')
      return FALSE;
   return fnmatch(p, s, i-1);
}
#else
int fmatch(p, s)  /* UNIX and others */
register char *p; /* pattern */
register char *s; /* string to compare */
{
   for (; *p && *s; ++p, ++s) {
      if (*p == '*') {
         while (*++p == '*') ;
         while (*s) if (fmatch(p, s++)) return TRUE;
         break;
      } else if (*p != '?') {
         if (*s != *p) return FALSE;
      }
   }
   return !(*p || *s);
}
#endif

int mismatch __ARGS__((char*, char*, int));

int mismatch(p, s, l)
register char *p, *s; int l;
{
   for (; *p && l; ++p, ++s, l--) {
      if (*p == '*') {
         while (*++p == '*');
         while (l) if (!mismatch(p, s++, l--)) return FALSE;
         break;
      } else if (*p != '?') {
         if (*s != *p) return ERROR;
      }
   }
   return *p || l;
}
