/*
 * Copyright (C) 1998 Wolfgang Moser aka Womo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Test parallel ports, if they are X1541-able
 * initial work and loopback-plug definition by Nicolas Welte
 */

#include "x1541.h"

   // return values:
   // -1     - detection is not possible, something blocks a port line
   //  0     - this is NO X1541-able port
   //  1...2 - number of detected loopback lines
   //          optimum is 2
int X1541able(int port){
	unsigned char i,o,c,bo,bi,lines;

   resetLPT(port);               // All Outputs to HIGH (external level)
   delay(1);                     // (take notice of the inversion)
   if((inportb(port+2)&0x0f)!=0x04) return -1;
   outportb(port+2,0x0B);        // All Outputs to LOW (external level)
   if((inportb(port+2)&0x0f)!=0x0B) return -1;

   lines=0;
	for(o=0x04;o>0;o>>=1){			// Set one of the output bits to low
		for(i=0x08;i>o;i>>=1){		// Select one of the output bits for input
      	bo=bi=0x04;
         for(c=0;c<8;c++){
            bi^=o;
            bi^=i;				// invert input bit (Low/High)

         	if(c&2){				// i->o instead of o->i
	            bo^=o;			// invert output bit for reading, too (Low/High)
            	}
            else{
					bo^=i;
               }
				delay(1);
				outportb(port+2,bo);
				delay(1);
				if((inportb(port+2)&0x0f)!=bi){
               					// input doesn't follow output
               break;
               }
            }
         if(c>=8){				// all tests were successful
            lines++;
            }
			resetLPT(port);		// All Outputs to HIGH (external level)
      	}
   	}
   return lines;
   }
