/*
 * Copyright (C) 1998 Wolfgang Moser aka Womo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Test parallel ports, if they are X1541-able
 * initial work and loopback-plug definition by Nicolas Welte
 */


#ifndef __X1541_H__
#define __X1541_H__

#include <dos.h>
#include "lptdetct.h"

   // return values:
   // -1     - detection is not possible, something blocks a port line
   //  0     - this is NO X1541-able port
   //  1...4 - number of detected loopback lines
   //          optimum is 4 (2 lines shorted, both directions are working)
int  X1541able (int port);
void resetLPT     (int port);

inline void resetLPT(int port){
   outportb(port+2,0x04);        // All Outputs to HIGH (external level)
   }

#endif
