/*
 * Copyright (C) 1998 Wolfgang Moser aka Womo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Test parallel ports, if they are X1541-able
 * initial work and loopback-plug definition by Nicolas Welte
 */

#include <stdio.h>
#include <conio.h>
#include "lptdetct.h"
#include "x1541.h"

// .______________ X1541
// | .____________ XE1541
// | |  ._________ XH1541
// | |  | ._______ XP1541
// | |  | | ._____ no parallel
// | |  | | |  .__ extra parallel port
// | |  | | |  |  .______ category
// | |  | | |  |  | .____ cable
// | |  | | |  |  | |
const int Matrix[][6]={
	6,3, 1,2,0, 12,   // costs          maximum search (plus extra used ports)
//	6,0, 1,2,0,  3,   // compatibleness maximum search (to X1541)
	0,1, 4,8,0,  2,   // compatibleness maximum search (to different computers)
	2,0, 4,8,0,  1    // performance    maximum search
	};

void prport(int port){
	const char *modes[6]={"N/A","SPP","PS/2","EPP","ECP","EPPc"};

	printf("at 0x%03X, %s", port, modes[LPTmode(port)]);
	}

int main(int argc, char** argv){
	int stdad[3]={0x3bc, 0x378, 0x278};
	int padrs[7]={0,0,0,0,0,0,0};
	int X, port, DataBIDI[7], ControlBIDI[7], noLoop, analyze;
	int i, j, k, l, m, p;
	lptMode mode;

		//      ._________ category
		//      |  .______ value, cable1, port1, cable2, port2
		//      |  |
	int result[3][5];

	printf("Parallelport X1541 compatibility Test, version 0.10, (C) 1999 "
			 "- Wolfgang Moser\n                        idea, initial works "
			 "and documentation - Nicolas Welte\n              a contributio"
			 "n to the Star Commander written by - Joe Forster/STA\n        "
			 "      and other X1541 based transfer solutions.\n\n");

	noLoop=0;
	analyze=0;
	if(argc!=1){
		analyze=-1;
		if(argc==2 && (argv[1][0]=='/' || argv[1][0]=='-')){
			switch(argv[1][1]){
				case 'a':   // loopback plug, do conection proposions
				case 'A':
					analyze=1;
					break;
				case 'x':   // no loopback plug, assuming X1541-able ports
				case 'X':
					analyze=1;
					noLoop=5;
					break;
				case 'e':   // no loopback plug, assuming X1541-unable ports
				case 'E':
					analyze=1;
					noLoop=1;
				}
			}
		if(analyze!=1 || argv[1][2]!='\0'){
				// Lets give'm some help
			printf("\nX1541TST [/A | /X | /E]\n\n"
					 "/A - let the program make some connection proposions (with loopback plug)\n"
			       "/X - same as /A without loopback, assumes X1541-able for SPP and PS/2 ports\n"
			       "/E - same as /A without loopback, assumes X1541-unable for SPP and PS/2 ports\n\n");
			return 0;
			}
		}
	printf("\nPrechecking port addresses ...\n\n");

	p=0;
	for(i=1;i<5;i++){
		port=BIOSlpt2port(i);
		if(!port) break;
		padrs[p++]=port;
		printf("LPT%1d ",i);
		prport(port);
		putchar('\n');
		mode=LPTmode(port);
		if(mode>lptN_A && mode<=lptEPPc){
				// switch ECP-Ports to Bytemode
			if(mode==lptECP) outportb(padrs[i]+0x402,0x35);
			resetLPT(padrs[i]);
			}
		for(j=0;j<3;j++) if(stdad[j]==port) stdad[j]=0;
		}

	j=0;
	for(i=0;i<3;i++){
		if(stdad[i] && LPTmode(stdad[i])!=lptN_A){
			padrs[p++]=stdad[i];
			if(!j){
				j=1;
				printf("\nFound unrecognized ports!!!\n\n");
				}
			printf("Port ");
			prport(stdad[i]);
			putchar('\n');
			if(mode>lptN_A && mode<=lptEPPc){
					// switch ECP-Ports to Bytemode
				if(mode==lptECP) outportb(padrs[i]+0x402,0x35);
				resetLPT(padrs[i]);
				}
			}
		}

	if(noLoop){
		printf("\n\nrescanning ports\n\n");
		}
	else{
		printf("\n\nPlease connect the loopback plug(s) now."
				 "\n\nPress any key when you are ready...\n\n\n");
		getch();
		}

	for(i=0;i<p;i++){
		DataBIDI[i]   =-1;
		ControlBIDI[i]=-1;
			// get LPT-Mode
		mode=LPTmode(padrs[i]);
		if(mode>lptN_A && mode<=lptEPPc){
			if(mode>=lptSPP && mode<=lptPS2 && noLoop) X=noLoop-1;
			else X=X1541able(padrs[i]);

			DataBIDI[i]   =(mode==lptSPP)?0:1;
			ControlBIDI[i]=(X>0)?1:0;

			printf("\nPort address: 0x%03X - ", padrs[i]);
         if(X>0){
				printf("Congratulations, this port is X1541-compatible!\n"
				       "                      (%d detected connections)\n",X);
				}
         else{
         	if(!X) printf("Sorry, this port is NOT X1541-compatible!\n");
            else printf("detection not possible, something blocks a line\n");
            }


			printf("                      ");
			if(DataBIDI[i]){
				printf("You can additionally connect the parallel"
				       " XP1541/XP1571\n                      or "
						 "the hybrid XH1541/XH1571 cable to achieve"
						 " more speed.\n");
            }
			else{
				printf("You can additionally connect the hybrid "
				       "XH1541/XH1571\n                      cab"
						 "le to achieve more speed.\n");
            }
			}
		if(ControlBIDI[i]>=0) X++;
		}

	if(analyze){
	   if(X){   // if any ports found
		   printf("\n\nHere are some possible cable solutions depending "
				    "on your system:\n\nThe simplest solution       : ");
		   for(i=X=0;i<p;i++) if(ControlBIDI[i]==1) X++;
		   if(X) printf("X1541 ---> ");
		   else  printf("XE1541 --> ");
		   for(i=j=0;i<p;i++) if(ControlBIDI[i]==(X?1:0)) j++;

		   for(i=k=0;i<p;i++){
			   if(ControlBIDI[i]==(X?1:0)){
				   if(k++){
					   if(k<j) printf(", ");
					   else    printf(" or ");
					   }
				   printf("0x%03X",padrs[i]);
				   }
			   }
		   printf(".\n");


			   // calculate cheapest, compatibles and fastest
		   for(i=0;i<3;i++) for(j=0;j<5;j++) result[i][j]=0;

		   for(i=0;i<2;i++){             // X1541 and XE1541
			   for(j=p-1;j>=0;j--){       // all ports
				   for(k=2;k<5;k++){       // XH1541, XP1541 and "no parallel"
					   for(l=p-1;l>=0;l--){   // all ports

							   // XE1541 and XH1541 on the same port
						   if(!(i==1 && k==2 && j==l)                &&
							   // one of the ports is inaccesible
							   !(DataBIDI[j]==-1 || DataBIDI[l]==-1)  &&
							   // X1541 couldn't be connected
							   !(ControlBIDI[j]==0 && i==0)           &&
							   // XP1541 couldn't be connected
							   !(DataBIDI[l]==0 && k==3)                 ){

								   // calculate categories
							   for(m=0;m<3;m++){
								   X=Matrix[m][i]+Matrix[m][k]+((j==l)?Matrix[m][5]:0);
								   if(X>result[m][0]){
									   result[m][0]=X;
									   result[m][1]=i;
									   result[m][2]=j;
									   result[m][3]=k;
									   result[m][4]=l;
									   }
								   }
							   }
						   }
					   }
				   }
			   }

		   for(m=0;m<3;m++){
			   switch(m){
				   case 0:
					   printf("The cheapest solution       : ");
					   break;
				   case 1:
					   printf("The most compatible solution: ");
					   break;
				   case 2:
					   printf("The fastest solution        : ");
				   }
			   switch(result[m][1]){
				   case 0:
					   printf("X1541 -");
					   break;
				   case 1:
					   printf("XE1541 ");
					   break;
				   default:
					   printf("Error%d ",result[m][1]);
				   }
			   printf("--> 0x%03X, ",padrs[result[m][2]]);
			   switch(result[m][3]){
				   case 2:
					   printf("XH15x1 ");
					   break;
				   case 3:
					   printf("XP15x1 ");
					   break;
				   case 4:
					   printf("no parallel cable");
					   break;
				   default:
					   printf("Error%d ",result[m][3]);
				   }
			   if(result[m][3]!=4){
				   printf("--> 0x%03X",padrs[result[m][4]]);
				   if(result[m][2]==result[m][4]) printf(" combined");
				   }
			   printf(".\n");
			   }
		   }
	   else printf("\nSorry, couldn't find any ports\n");
   	}

	return 0;
	}
