(*
 * Copyright (C) 1998-2004 Wolfgang Moser
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *)

(*
 * XCDetect, a Commodore/IBM-PC transfercable autodetection utility,
 * designed for the users of The Star Commander and other transfer
 * utilities using the X-cables:
 *         X1541, XE1541, XM1541, XA1541, XP1541 and XH1541.
 *
 * Wolfgang Moser <cbm (at) d81 (dot) de>
 *   http://d81.de
 *
 *
 * Basic implementations by Joe Forster/STA <http://sta.c64.org>
 *   His util, The Star Commander is the state of the art utility
 *   for transferring files between modern IBM PCs and floppies
 *   of the Commodore world.
 *
 *   Check out the Star Commander home page at:
 *         http://sta.c64.org/sc.html
 *
 *
 * To learn more about the transfer cables used by The Star Commander
 * and this util, check the X1541 cable page at:
 *
 *   http://sta.c64.org/x1541.html
 *)

program XcableAutodetection;


uses swbase, version;
var
   Debug : Boolean;
   pMax    : Word;
   pAddr   : Array [0..7] of Word;
   cable   : Array [0..7] of Byte;
const
   stdAddr : Array [0..2] of Word      =($3BC, $378, $278);
   pModes  : Array [0..4] of string[4] =('N/A','SPP','PS/2','EPP','ECP');

function MemoryRead(MemAddr : Word) : Byte;
var
   ret     : Byte;
begin
   OpenCBMChannel($6F, 'M-R' + Chr(Lo(MemAddr)) + Chr(Hi(MemAddr)) + #$01);

   if Status=0 then asm
      call Talk;
      mov al, $6F;
      call TalkSec;
      call Receive;
      mov ret, al;
      end;
   MemoryRead:=ret;
   end;

procedure parScan;
var
   pCable,
   last,
   Result  : Byte;
   i,
   piaBase : Word;
   ErrInf  : string;
begin
   if Debug then PrintStr('Scanning drive ' + DecStr(CBMDevNum,2) +
                          ' at 0x' + HexaStr(LPTAddr,3) +
                          ' for parallel cables.' + #13#10);

   repeat begin
      pCable:=0;
      piaBase:=$4001;
      OpenCBMChannel($6F, 'M-W' + #$00 + #$05 + #$01 + #$55);
      if Status<>0 then break;
      Result:=MemoryRead($4500); if Status<>0 then break;

      if Debug then PrintStr('  - checking memory address mirroring: 0x0000 to 0x2000 ');

      if Result=$55 then begin
         OpenCBMChannel($6F, 'M-W' + #$00 + #$05 + #$01 + #$AA);
         if Status<>0 then break;
         Result:=MemoryRead($4500); if Status<>0 then break;
         if Result=$AA then begin
					{ $0000 to $2000 mirrored at $4000 }
					{ ==> no CIA }
            piaBase:=$1801;
            end;
         end;

      if piaBase=$1801 then begin
         if Debug then PrintStr('mirrored at 0x4000' + #13#10 +
                                '  - checking for VIA presence (timer 2 running?): ');
         piaBase:=0;
         for i:=0 to 15 do begin
            Result:=MemoryRead($1808); if Status<>0 then break;
            if (i>0) and (Result<>last) then begin
               piaBase:=$1801;
               break;
               end;
            last:=Result;
            end;
         if Status<>0 then break;
         end
      else begin
         if Debug then PrintStr('not mirrored at 0x4000' + #13#10 +
                                '  - checking for CIA presence (DDR A available?): ');

         OpenCBMChannel($6F, 'M-W' + #$02 + #$40 + #$01 + #$55);
         if Status<>0 then break;
         Result:=MemoryRead($4002); if Status<>0 then break;
         if Result<>$55 then piaBase:=0
         else begin
            OpenCBMChannel($6F, 'M-W' + #$02 + #$40 + #$01 + #$AA);
            if Status<>0 then break;
            Result:=MemoryRead($4002); if Status<>0 then break;
            if Result<>$AA then piaBase:=0;
            end;
         OpenCBMChannel($6F, 'M-W' + #$02 + #$40 + #$01 + #$00);
         if Status<>0 then break;
         end;
      if piaBase=0 then begin
         if Debug then PrintStr('is not present' + #13#10);
         break;
         end
      else if Debug then PrintStr('is present' + #13#10);

      {now we know, that there's a PIA}
      pCable:=0;

      OpenCBMChannel($6F, 'M-W' + Chr(Lo(piaBase+2)) + Chr(Hi(piaBase+2)) + #$01 + #$00);
      if Status<>0 then break;
      if Debug then PrintStr('  - testing all LPT ports for parallel cables:' + #13#10);
      for i:=0 to pMax-1 do begin
         ParLPTAddr:=pAddr[i];
         ParallelCable:=pcParallel;
         InitLPTPorts;


         asm mov dx, ParLPTAddr; add dx, 2; in al, dx; mov Result, al; end;
         ParallelOutput;
         asm mov al, $AA; mov dx, ParLPTAddr; out dx, al; end;
         Result:=MemoryRead(piaBase); if Status<>0 then break;
         if Result=$AA then begin
            asm mov al, $55; mov dx, ParLPTAddr; out dx, al; end;
            Result:=MemoryRead(piaBase); if Status<>0 then break;
            if Result=$55 then begin
               if Debug then PrintStr('    - port address 0x' +
                                      HexaStr(ParLPTAddr,3) +
                                      ' is connected in any way' +
                                      #13#10);
               pCable:=0;
               ParallelInput;

               OpenCBMChannel($6F, 'M-W' + Chr(Lo(piaBase+2)) + Chr(Hi(piaBase+2)) + #$01 + #$FF);
               if Status<>0 then break;
               OpenCBMChannel($6F, 'M-W' + Chr(Lo(piaBase)) + Chr(Hi(piaBase)) + #$01 + #$AA);
               if Status<>0 then break;
               asm
                  mov ax,10*1193;  { wait 10 milliseconds }
                  call Delay;      { instead of crt's Delay(10); }
                  end;

               if Debug then PrintStr('  - testing port address 0x' +
                                      HexaStr(ParLPTAddr,3) +
                                      ' for XP15' + Chr($34+3*Ord(piaBase<>$1801)) + '1 at PIA 0x' +
                                      HexaStr(PIABase,4) + ': ');
               asm mov dx, ParLPTAddr; in al, dx; mov Result, al; end;

               if Result=$AA then begin
                  OpenCBMChannel($6F, 'M-W' + Chr(Lo(piaBase)) + Chr(Hi(piaBase)) + #$01 + #$55);
                  if Status<>0 then break;
                  asm
                     mov ax,10*1193;  { wait 10 milliseconds }
                     call Delay;      { instead of crt's Delay(10); }
                     end;

                  asm mov dx, ParLPTAddr; in al, dx; mov Result, al; end;
                  if Result=$55 then begin
                     pCable:=1;
                     if Debug then PrintStr('cable detected' + #13#10);
(* break after finding the first connected port, instead of searching all the others *)
                     break;
                     end;
                  end;
               if Debug then PrintStr('cable not detected' + #13#10 +
                                      '  - testing port address 0x' +
                                      HexaStr(ParLPTAddr,3) +
                                      ' for XH15' + Chr($34+3*Ord(piaBase<>$1801)) + '1 at PIA 0x' +
                                      HexaStr(PIABase,4) + ': ');

               OpenCBMChannel($6F, 'M-W' + Chr(Lo(piaBase)) + Chr(Hi(piaBase)) + #$01 + #$AA);
               if Status<>0 then break;
               asm
                  mov ax,10*1193;  { wait 10 milliseconds }
                  call Delay;      { instead of crt's Delay(10); }
                  end;
               asm mov dx, ParLPTAddr; inc dx; in al, dx; mov Result, al; end;
               if (Result and $F0)=$20 then begin
                  OpenCBMChannel($6F, 'M-W' + Chr(Lo(piaBase)) + Chr(Hi(piaBase)) + #$01 + #$05);
                  if Status<>0 then break;
                  asm
                     mov ax,10*1193;  { wait 10 milliseconds }
                     call Delay;      { instead of crt's Delay(10); }
                     end;

                  asm mov dx, ParLPTAddr; inc dx; in al, dx; mov Result, al; end;
                  if (Result and $F0)=$D0 then pCable:=2;
                  end;
               if Debug and (pCable=2) then PrintStr('cable detected' + #13#10)
               else PrintStr('cable not detected' + #13#10);
               break;
               end;
            end;
         OpenCBMChannel($6F, 'M-W' + Chr(Lo(piaBase+2)) + Chr(Hi(piaBase+2)) + #$01 + #$00);
         if Status<>0 then break;
         OpenCBMChannel($6F, 'M-W' + Chr(Lo(piaBase)) + Chr(Hi(piaBase)) + #$01 + #$FF);
         if Status<>0 then break;
         if Debug then PrintStr('    - port address 0x' +
                                HexaStr(ParLPTAddr,3) +
                                ' is not connected' + #13#10);
         end;
      OpenCBMChannel($6F, 'M-W' + Chr(Lo(piaBase+2)) + Chr(Hi(piaBase+2)) + #$01 + #$00);
      if Status<>0 then break;


      PrintStr(DecStr(CBMDevNum,2) + ': ');
      case SerialCable of
        scNormal    : PrintStr('X1541 ');
        scExtended  : PrintStr('XE1541');
        scMultitask : PrintStr('XM1541');
        scActive    : PrintStr('XA1541');
        end;

      PrintStr('  0x' + HexaStr(LPTAddr,3) + '     ');
      if pCable in [1..2] then begin
         case pCable of
            1: PrintStr('XP15' + Chr($34+3*Ord(piaBase<>$1801)) + '1');
            2: PrintStr('XH15' + Chr($34+3*Ord(piaBase<>$1801)) + '1');
            end;
         PrintStr('  0x' + HexaStr(ParLPTAddr,3) +
                  ' (PIA 0x' + HexaStr(piaBase,4) + ')' + #13#10);
         end
      else if piaBase=0 then PrintStr('no parallel cable (no PIA found)' + #13#10)
      else PrintStr('no parallel cable (PIA 0x' + HexaStr(piaBase,4) + ')' + #13#10);

      end until True;
	if Status<>0 then begin
      ReadCBMError(ErrInf,False);
      PrintStr('Device ' + DecStr(CBMDevNum,2) + ' Error "' + ErrInf + '"' + #13#10);
      end;
   end;


var
   sw      : Boolean;
   i,j,
   port    : Word;
   lptM    : Byte;

begin begin
   Debug:=ParamCount>=1;

   PrintStr('PC-CBM transfercable autodetection design study, (C) ' +
               Author + #13#10 +
            '      uses basic routines of The Star Commander, ' +
               '(C) 1994-2004 - Joe Forster' + #13#10#13#10 +
            'Version: ' + VersionInfo +
            '  --  Debug messages mode (-d) switched to ');
   if Debug then PrintStr('on')
   else          PrintStr('off');

   PrintStr('.' + #13#10#13#10 +
            'Prechecking port addresses ...' + #13#10#13#10);

   pMax:=0;

   for i:=1 to 4 do begin
      port:=MemW[$0040:i shl 1 + 6];
      if port<=2 then break;
      (*
        Inc(port,2);                        { port + 2 = X1541 base port (Control port) }
      *)
      pAddr[pMax]:=port;
      Inc(pMax);
      PrintStr('LPT' + Chr(i+$30) + ' at 0x' + HexaStr(port,3) +
              ', ' + pModes[GetLPTMode(port)] + #13#10);
      for j:=0 to 2 do if stdAddr[j]=port then stdAddr[j]:=0;
      end;

   sw:=True;
   for i:=0 to 2 do begin
      port:=StdAddr[i];
      if (port<>0) and (GetLPTMode(port)<>pmNone) then begin
         pAddr[pMax]:=port;
         Inc(pMax);
         if sw then begin
            sw:=False;
            PrintStr(#13#10 + 'Found unrecognized ports!!!' + #13#10#13#10);
            end;
         PrintStr('Port  at 0x' + HexaStr(port,3) +
                 ', ' + pModes[GetLPTMode(port)] + #13#10);
         end;
      end;

   { ChkDevSpeed:=3;  { _fast_ CheckDevice, originally: ChkDevSpeed:=20000 }
   ChkDevSpeed:=300;
   ComputeDelay;
   ParallelCable:=pcNone;

	{XA1541 predection: check for inversion on ATN, preinitialize ports}
   for i:=0 to pMax-1 do begin
   	LPTAddr:=pAddr[i];
   	SerialCable:=scActive;
		InitTransfer;
      ResetLPTPort;

		sw:=False;
		asm
			call AtnHi;
			call ReadLine;
			test ah, sbAtnNormal;
			jne @1;

			call AtnLo;
			call ReadLine;
			test ah, sbAtnNormal;
			je @1;

			call AtnHi;
			call ReadLine;
			test ah, sbAtnNormal;
			jne @1;
			
			mov sw, 1;
		@1:
			end;

		if sw then begin
			if Debug then PrintStr('Preinitialised port 0x' + HexaStr(LPTAddr, 3) +
                                ' for XA1541 (signal inversion detected on ATN)' + #13#10);
			cable[i]:=scActive;
			end
		else begin
	   	SerialCable:=scNormal;
			InitTransfer;
	      ResetLPTPort;
			end;
		end;
   if Debug then PrintStr('Let bus devices calm down after possible bus resets' + #13#10);
   for i:=1 to 100 do begin
		asm
			mov ax,11930;    { wait 10 milliseconds }
			call Delay;      { instead of crt's Delay(10); }
			end;
		end;

   PrintStr(#13#10 + 'Searching for cables (DelayOffset:' + DecStr(CopyDelayValue,3) + ')...' + #13#10 +
           '(can only be found, if IEC devices are connected and switched on)' + #13#10#13#10);

   for i:=0 to pMax-1 do begin
      LPTAddr:=pAddr[i];

		if cable[i]=scActive then SerialCable:=scActive
		else SerialCable:=scNormal;
      cable[i]:=scNone;

		repeat

			if Debug then begin
				PrintStr('Testing for cable: ');
        		case SerialCable of
	            scNormal    : PrintStr('X1541' + #13#10);
	            scExtended  : PrintStr('XE1541' + #13#10);
	            scMultitask : PrintStr('XM1541' + #13#10);
	            scActive    : PrintStr('XA1541' + #13#10);
					end;
            end;

         InitTransfer;
         ResetLPTPort;

         if CheckDevice then begin
            cable[i]:=SerialCable;
            break;
            end;
         Inc(SerialCable, 1);
         until SerialCable>scMultitask;

      if Debug and (cable[i]=scNone) then
        PrintStr('no cable connected to port address 0x' + HexaStr(LPTAddr,3) + #13#10);
      if cable[i]<>scNone then begin
        case cable[i] of
          scNormal    : PrintStr('X1541   ');
          scExtended  : PrintStr('XE1541  ');
          scMultitask : PrintStr('XM1541  ');
          scActive    : PrintStr('XA1541  ');
          end;
        PrintStr(' connected to port address 0x' + HexaStr(LPTAddr,3) + #13#10);
        end;
      end;

   PrintStr(#13#10 + 'Searching for IEC floppy devices ...' + #13#10);
   for i:=0 to pMax-1 do if cable[i]<>scNone then begin
      LPTAddr:=pAddr[i];
      SerialCable:=cable[i];
      InitTransfer;
      ResetLPTPort;

      PrintStr(#13#10 + 'Floppy devices connected to port 0x' + HexaStr(LPTAddr,3) + ':');
	  sw:=True;
      for j:=8 to 11 do begin
         CBMDevNum:=j;
         asm
            mov Status, 0;
            mov More, False;
            mov EOI, False;
            call Listen;

            mov al, $6F
            call ListenSec;
            end;
         if Status=0 then begin
            PrintStr(' ' + DecStr(j,1));
				sw:=False;
            end
         else if Debug then PrintStr(' ' + DecStr(j,1) + '<NC:0x' + HexaStr(Status,2) + '>');
         asm
            mov ax,1193;     { wait 1 millisecond }
            call Delay;      { instead of crt's Delay(1); }
            end;
         UnListen;
         end;
		if sw then cable[i]:=scNone;
      end;

   PrintStr(#13#10#13#10 + 'Searching for parallel cables on all floppy devices ...' + #13#10#13#10);
   for i:=0 to pMax-1 do if cable[i]<>scNone then begin
      LPTAddr:=pAddr[i];
      SerialCable:=cable[i];
      InitTransfer;
      ResetLPTPort;

      for j:=8 to 11 do begin
         CBMDevNum:=j;
         asm
            mov Status, 0;
            mov More, False;
            mov EOI, False;
            call Listen;

            mov al, $6F
            call ListenSec;
            end;
         sw:=Status=0;
         asm
            mov ax,1193;     { wait 1 millisecond }
            call Delay;      { instead of crt's Delay(1); }
            end;
         UnListen;
         if sw then parScan;
         ParallelCable:=pcNone;
         end;
      end;
   end;
end.