;Ŀ
;                 Joe Forster/STA                 
;                                                 
;                      EOL.ASM                    
;                                                 
;                Change End-of-Line               
;

CSeg		segment
		assume	cs:CSeg, ds:CSeg, ss:CSeg
		org	0100h

BufferSize	equ	64512
ProgramSize	equ	6144
LongFileNameMax	equ	255

LongSearchRec	struc
lsAttr		dd	?
lsCreateDate	dd	?, ?
lsAccessDate	dd	?, ?
lsModifyDate	dd	?, ?
lsSizeHi	dd	?
lsSize		dd	?
lsReserved	db	8 dup (?)
lsName		db	260 dup (?)
lsShortName	db	14 dup (?)
LongSearchRec	ends

Main:		mov	ax, ds:[0006h]
		cmp	ax, ProgramSize
		jbe	@14
		mov	bx, ProgramSize / 16
		mov	ah, 4Ah
		int	21h
		mov	sp, ProgramSize
		xor	ax, ax
		push	ax
@14:		mov	di, Offset DataStart
		mov	cx, DataEnd - DataStart
		xor	al, al
		cld
		rep	stosb
		mov	dx, Offset Hello
		mov	ah, 9
		int	21h
		mov	bl, 2
		mov	di, Offset SearchPar
		mov	cx, LongFileNameMax
		call	ParamStr
		cmp	bh, 2
		jae	@01
		mov	dx, Offset Usage
		mov	ah, 9
		int	21h
		xor	al, al
		jmp	@03
@01:		mov	bl, 1
		xor	di, di
		call	ParamStr
		call	UpCase
		cmp	al, 'D'
		je	@15
		cmp	al, 'U'
		je	@15
		mov	dx, Offset InvalidCommand
		jmp	@11
@15:		mov	Command, al
		mov	si, Offset SearchPar
		mov	di, Offset ReadPath
		xor	bx, bx
		xor	bp, bp
		call	FSplit
		mov	si, Offset SearchPar
		mov	di, Offset ReadName
		mov	cx, LongFileNameMax
		stc
		call	StrCopy
		mov	dx, Offset SearchPar
		mov	cx, 21h
		call	FindFirst
		jnc	@06
		mov	dx, Offset SearchPar
		clc
		call	PrintStr
		mov	dx, Offset NotFound
		jmp	@11
@06:		mov	si, Offset ReadPath
		mov	di, Offset ReadName
		mov	cx, LongFileNameMax
		clc
		call	StrCopy
		mov	si, FileNameOffs
		stc
		call	StrCopy
		mov	si, Offset ReadPath
		mov	di, Offset WriteName
		mov	cx, LongFileNameMax
		clc
		call	StrCopy
		mov	si, Offset TempName
		stc
		call	StrCopy
		mov	dx, Offset ReadName
		xor	al, al
		call	OpenFile
		jnc	@07
		jmp	@04
@07:		mov	si, ax
		mov	bx, si
		mov	ax, 5700h
		int	21h
		mov	Time, cx
		mov	Date, dx
		mov	dx, Offset WriteName
		mov	ax, 1
		mov	cx, 0022h
		call	OpenFile
		jnc	@08
		jmp	@09
@08:		mov	di, ax
		mov	bx, BufferSize / 16
		mov	ah, 48h
		int	21h
		jnc	@10
@02:		mov	dx, Offset NoMemory
		jmp	@11
@10:		mov	Buffer1, ax
		mov	bx, BufferSize / 16
		mov	ah, 48h
		int	21h
		jc	@02
		mov	Buffer2, ax
		mov	dx, Offset Converting
		mov	ah, 9
		int	21h
		mov	dx, Offset ReadName
		stc
		call	PrintStr
		xor	ax, ax
		mov	PreviousByte, al
		mov	EndOfFile, al
		mov	BufferLength1, ax
		mov	BufferPoint1, ax
		mov	BufferLength2, ax
		call	ReadByte
		cmp	Command, 'D'
		jne	@12
@18:		cmp	al, 10
		jne	@05
		cmp	PreviousByte, 13
		je	@05
		mov	al, 13
		call	WriteByte
		mov	al, 10
@05:		mov	PreviousByte, al
		call	WriteByte
		call	ReadByte
		mov	ah, EndOfFile
		or	ah, ah
		je	@18
		jmp	@16
@12:		cmp	al, 10
		je	@17
		cmp	PreviousByte, 13
		jne	@17
		push	ax
		mov	al, 13
		call	WriteByte
		pop	ax
@17:		mov	PreviousByte, al
		cmp	al, 13
		je	@13
		call	WriteByte
@13:		call	ReadByte
		mov	ah, EndOfFile
		or	ah, ah
		je	@12
@16:		call	BlockWrite
		push	es
		mov	es, Buffer1
		mov	ah, 49h
		int	21h
		mov	es, Buffer2
		mov	ah, 49h
		int	21h
		pop	es
		mov	bx, di
		mov	ax, 5701h
		mov	cx, Time
		mov	dx, Date
		int	21h
		call	CloseFile
@09:		pushf
		mov	bx, si
		call	CloseFile
		popf
		jc	@04
		call	RenameTemp
@04:		call	FindNext
		jc	@20
		jmp	@06
@11:		mov	ah, 9
		int	21h
		mov	al, 1
		jmp	@19
@20:		call	FindClose
		call	NormalAttr
@03:		xor	al, al
@19:		mov	ah, 4Ch
		int	21h

FindFirst:	xor	ch, ch
		push	si
		mov	si, 1
		push	ds
		pop	es
		push	di
		mov	di, Offset LFNSearchRec
		mov	ax, 714Eh
		stc
		int	21h
		pop	di
		pop	si
		jnc	@02_FindFirst
		cmp	ax, 7100h
		stc
		jne	@01_FindFirst
		mov	ah, 4Eh
		int	21h
		mov	FileAttrOffs, 0095h
		mov	FileNameOffs, 009Eh
		jmp	@01_FindFirst
@02_FindFirst:	mov	LFNSearchHandle, ax
		mov	FileAttrOffs, Offset LFNSearchRec.lsAttr
		mov	FileNameOffs, Offset LFNSearchRec.lsName
@01_FindFirst:	retn

FindNext:	push	cx
		push	bx
		mov	bx, LFNSearchHandle
		push	si
		mov	si, 1
		push	ds
		pop	es
		push	di
		mov	di, Offset LFNSearchRec
		mov	ax, 714Fh
		stc
		int	21h
		pop	di
		pop	si
		pop	bx
		jnc	@01_FindNext
		cmp	ax, 7100h
		stc
		jne	@01_FindNext
		mov	ah, 4Fh
		int	21h
@01_FindNext:	pop	cx
		retn

FindClose:	push	bx
		mov	bx, LFNSearchHandle
		mov	ax, 71A1h
		int	21h
		pop	bx
		retn

OpenFile:	push	bx
		push	si
		mov	ah, 40h
		mov	si, 0001h
		or	al, al
		je	@01_OpenFile
		mov	ah, 20h
		cmp	al, 2
		je	@01_OpenFile
		mov	si, 0012h
@01_OpenFile:	mov	bl, al
		xor	bh, bh
		xchg	si, dx
		xor	di, di
		mov	ax, 716Ch
		stc
		int	21h
		jnc	@02_OpenFile
		cmp	ax, 7100h
		je	@03_OpenFile
		cmp	ax, 5
		stc
		jne	@02_OpenFile
		and	bl, 0Fh
		stc
		mov	ax, 716Ch
		int	21h
		jmp	@02_OpenFile
@03_OpenFile:	mov	dx, si
		mov	al, bl
		mov	ah, 3Ch
		cmp	al, 1
		je	@04_OpenFile
		mov	ah, 3Dh
		xor	cx, cx
@04_OpenFile:	push	ax
		int	21h
		pop	bx
		jnc	@02_OpenFile
		cmp	ax, 5
		stc
		jne	@02_OpenFile
		mov	ax, bx
		and	al, 0Fh
		int	21h
@02_OpenFile:	pop	si
		pop	bx
		retn

CloseFile:	mov	ah, 3Eh
		int	21h
		retn

DeleteFile:	push	si
		xor	si, si
		mov	ax, 7141h
		stc
		int	21h
		pop	si
		jnc	@01_DeleteFile
		cmp	ax, 7100h
		stc
		jne	@01_DeleteFile
		mov	ah, 41h
		int	21h
@01_DeleteFile:	retn

RenameFile:	mov	ax, 7156h
		stc
		int	21h
		jnc	@01_RenameFile
		cmp	ax, 7100h
		stc
		jne	@01_RenameFile
		mov	ah, 56h
		int	21h
@01_RenameFile:	retn

RenameTemp:	mov	dx, Offset ReadName
		call	DeleteFile
		jc	@01_RenameTemp
		mov	dx, Offset WriteName
		mov	di, Offset ReadName
		call	RenameFile
@01_RenameTemp:	retn

FileAttr:	push	bx
		mov	bl, al
		mov	ax, 7143h
		stc
		int	21h
		pop	bx
		jnc	@01_FileAttr
		cmp	ax, 7100h
		stc
		jne	@01_FileAttr
		mov	ah, 43h
		int	21h
@01_FileAttr:	retn

NormalAttr:	mov	dx, Offset SearchPar
		mov	cx, 23h
		call	FindFirst
		jc	@01_NormalAttr
@02_NormalAttr:	mov	si, FileAttrOffs
		mov	cl, byte ptr [si]
		test	cl, 2
		je	@03_NormalAttr
		and	cl, 0FDh
		xor	ch, ch
		push	cx
		mov	si, Offset ReadPath
		mov	di, Offset WriteName
		push	di
		mov	cx, LongFileNameMax
		clc
		call	StrCopy
		mov	si, FileNameOffs
		stc
		call	StrCopy
		pop	dx
		pop	cx
		mov	al, 1
		call	FileAttr
@03_NormalAttr:	call	FindNext
		jnc	@02_NormalAttr
		call	FindClose
@01_NormalAttr:	retn

FSplit:		push	dx
		mov	dx, si
		call	StrLen
		add	si, ax
		dec	si
		xor	cx, cx
		std
@04_FSplit:	cmp	si, dx
		jb	@01_FSplit
		lodsb
		cmp	al, '.'
		jne	@02_FSplit
		or	cx, cx
		jne	@02_FSplit
		mov	cx, si
		inc	cx
@02_FSplit:	cmp	al, '\'
		je	@03_FSplit
		cmp	al, ':'
		jne	@04_FSplit
@03_FSplit:	inc	si
@01_FSplit:	inc	si
		or	cx, cx
		jne	@05_FSplit
		mov	cx, dx
		xchg	si, dx
		call	StrLen
		xchg	si, dx
		add	cx, ax
@05_FSplit:	xchg	si, dx
		sub	cx, dx
		sub	dx, si
		push	cx
		mov	cx, LongFileNameMax
		stc
		call	StrPartCopy
		mov	di, bx
		pop	dx
		mov	cx, LongFileNameMax
		stc
		call	StrPartCopy
		pop	di
		mov	cx, LongFileNameMax
		stc
		call	StrCopy
		retn

StrCopy:	mov	dx, cx
StrPartCopy:	cld
		pushf
		or	di, di
		jne	@04_StrCopy
		popf
		retn
@04_StrCopy:	or	cx, cx
		je	@01_StrCopy
@02_StrCopy:	or	dx, dx
		je	@01_StrCopy
		lodsb
		or	al, al
		je	@01_StrCopy
		stosb
		dec	dx
		loop	@02_StrCopy
@01_StrCopy:	xor	al, al
		popf
		jnc	@03_StrCopy
		stosb
@03_StrCopy:	retn

StrLen:		cld
		push	si
		xor	ah, ah
@02_StrLen:	lodsb
		or	al, al
		je	@01_StrLen
		inc	ah
		or	ah, ah
		jne	@02_StrLen
@01_StrLen:	pop	si
		mov	al, ah
		xor	ah, ah
		retn

PrintStr:	push	si
		push	bx
		push	cx
		pushf
		mov	si, dx
		mov	bx, 1
		call	StrLen
		or	ax, ax
		je	@01_PrintStr
		mov	cx, ax
		mov	ah, 40h
		int	21h
@01_PrintStr:	popf
		jnc	@02_PrintStr
		mov	dx, Offset LineFeed
		mov	cx, 2
		mov	ah, 40h
		int	21h
@02_PrintStr:	pop	cx
		pop	bx
		pop	si
		retn

ReadByte:	push	es
		push	bx
		push	cx
		push	dx
		mov	al, 26
		mov	ah, EndOfFile
		or	ah, ah
		jne	@02_ReadByte
		mov	es, Buffer1
		mov	ax, BufferPoint1
		cmp	ax, BufferLength1
		jne	@01_ReadByte
		mov	bx, si
		mov	cx, BufferSize
		xor	dx, dx
		push	ds
		mov	ds, cs:Buffer1
		mov	ah, 3Fh
		int	21h
		pop	ds
		mov	BufferPoint1, 0
		mov	BufferLength1, ax
		or	ax, ax
		jne	@01_ReadByte
		mov	EndOfFile, 1
		xor	al, al
		jmp	@02_ReadByte
@01_ReadByte:	mov	bx, BufferPoint1
		mov	al, es:[bx]
		inc	BufferPoint1
@02_ReadByte:	pop	dx
		pop	cx
		pop	bx
		pop	es
		retn

WriteByte:	push	es
		push	bx
		mov	es, Buffer2
		mov	bx, BufferLength2
		mov	es:[bx], al
		inc	bx
		mov	BufferLength2, bx
		cmp	bx, BufferSize
		jb	@01_WriteByte
		call	BlockWrite
		mov	BufferLength2, 0
@01_WriteByte:	pop	bx
		pop	es
		retn

BlockWrite:	push	cx
		push	dx
		mov	cx, BufferLength2
		or	cx, cx
		je	@01_BlockWrite
		mov	bx, di
		xor	dx, dx
		push	ds
		mov	ds, cs:Buffer2
		mov	ah, 40h
		int	21h
		pop	ds
@01_BlockWrite:	pop	dx
		pop	cx
		retn

ParamStr:	mov	si, 0081h
		xor	bh, bh
		xor	ah, ah
@01_ParamStr:	lodsb
		cmp	al, 13
		je	@02_ParamStr
		cmp	al, ' '
		je	@01_ParamStr
		cmp	al, 9
		je	@01_ParamStr
		inc	bh
		cmp	bl, bh
		je	@03_ParamStr
@04_ParamStr:	cmp	al, 13
		je	@02_ParamStr
		cmp	al, '"'
		jne	@07_ParamStr
		xor	ah, 1
		jmp	@08_ParamStr
@07_ParamStr:	or	ah, ah
		jne	@08_ParamStr
		cmp	al, ' '
		je	@01_ParamStr
		cmp	al, 9
		je	@01_ParamStr
@08_ParamStr:	lodsb
		jmp	@04_ParamStr
@03_ParamStr:	or	di, di
		je	@05_ParamStr
@06_ParamStr:	cmp	al, 13
		je	@02_ParamStr
		cmp	al, '"'
		jne	@09_ParamStr
		xor	ah, 1
		jmp	@10_ParamStr
@09_ParamStr:	or	ah, ah
		jne	@11_ParamStr
		cmp	al, ' '
		je	@02_ParamStr
		cmp	al, 9
		je	@02_ParamStr
@11_ParamStr:	stosb
@10_ParamStr:	lodsb
		loop	@06_ParamStr
@02_ParamStr:	xor	al, al
		stosb
@05_ParamStr:	retn

UpCase:		cmp	al, 'a'
		jb	@01_UpCase
		cmp	al, 'z'
		ja	@01_UpCase
		sub	al, 'a' - 'A'
@01_UpCase:	retn

Hello		db	'Change End-of-Line by Joe Forster/STA', 13, 10, 13, 10, '$'
Usage		db	'This program changes the end-of-line marks in a text file.', 13, 10, 13, 10
		db	'Unix to DOS :  EOL D <filename>', 13, 10
		db	'DOS to Unix :  EOL U <filename>', 13, 10, '$'
InvalidCommand	db	'Invalid command', 13, 10, '$'
NotFound	db	' not found', 13, 10, '$'
NoMemory	db	'Out of memory', 13, 10, '$'
Converting	db	'Converting $'
LineFeed	db	13, 10
TempName	db	'$$TEMP$$.TMP', 0

DataStart:

LFNSearchRec		LongSearchRec <?>
LFNSearchHandle	dw	?
FileNameOffs	dw	?
FileAttrOffs	dw	?
Time		dw	?
Date		dw	?
PreviousByte	db	?
Command		db	?
EndOfFile	db	?
BufferLength1	dw	?
BufferPoint1	dw	?
BufferLength2	dw	?
Buffer1		dw	?
Buffer2		dw	?
SearchPar	db	LongFileNameMax + 1 dup (?)
ReadName	db	LongFileNameMax + 1 dup (?)
WriteName	db	LongFileNameMax + 1 dup (?)
ReadPath	db	LongFileNameMax + 1 dup (?)

DataEnd:

CSeg		ends

		end	Main
