{
Ŀ
                 Joe Forster/STA                 
                                                 
                    EXTVIV.PAS                   
                                                 
          Electronic Arts VIV extractor          

}

uses
  DOS;

const
  fmReadOnly    = 0;
  fmWriteOnly   = 1;
  fmReadWrite   = 2;
  ArcEntryMaxLen= 256;
  TBufferSize   = $FE00;
  VIVSign       = $34474942;
  VIVVer        = $0000000A;

type
  ExtFile       = record
    Orig        : file;
    LongName    : string;
  end;
  PExtFile      = ^ExtFile;
  TBuffer       = array [0..TBufferSize - 1] of Byte;
  PBuffer       = ^TBuffer;
  VIVDirEntry   = record
    DataPos,
    DataLen     : Longint;
    FileName    : string;
  end;

var
  Quit          : Boolean;
  Index         : Word;
  IOError       : Integer;
  ArcSign,
  ArcVer,
  ArcPos,
  BinSize,
  ArcDirPos,
  ArcNameDirLen,
  ArcTime,
  TotalSize     : Longint;
  ArcName,
  EntryName,
  BinName,
  BinPath,
  DirName       : string;
  ArcFile,
  BinFile       : ExtFile;
  ArcEntry      : VIVDirEntry;

function ASCIIZtoStr(const Str; MaxLen: Word): string; assembler;
asm
    les di, Str;
    mov si, di;
    mov cx, MaxLen;
    xor al, al;
    cld;
    repne scasb;
    pushf;
    mov cx, di;
    sub cx, si;
    popf;
    jne @1
    dec cx;
@1: push ds;
    push es;
    pop ds;
    les di, @Result;
    mov al, cl;
    stosb;
    jcxz @2;
    rep movsb;
@2: pop ds;
end;

procedure ExecLFN; assembler;
asm
    mov ah, $71;
    stc;
    int $21;
    jc @1;
    cmp ax, $7100;
    stc;
    je @1;
    clc;
@1:
end;

function InitLongNames: Boolean; assembler;
var
  S,
  T             : string;
asm
    push ds;
    push ss;
    pop ds;
    push ss;
    pop es;
    lea si, S;
    mov byte ptr [si], 0;
    lea di, T;
    xor cl, cl;
    mov ch, $80;
    mov al, $60;
    call ExecLFN;
    mov bx, ax;
    pop ds;
    mov al, True;
    jnc @1;
    cmp bx, $7100;
    jne @1;
    mov al, False;
@1:
end;

function LongParamStr(Index: Byte): string; assembler;
asm
    push ds;
    mov dl, Index;
    or dl, dl;
    je @12;
    xor dh, dh;
    mov ax, PrefixSeg;
    mov ds, ax;
    mov di, $0080;
    mov cl, [di];
    xor ch, ch;
    inc di;
    xor bx, bx;
    xor ah, ah;
@1: jcxz @3;
@2: mov al, [di];
    cmp al, '"';
    jne @7;
    xor ah, 1;
    inc di;
    dec cx;
    jmp @3;
@7: cmp al, ' ';
    ja @3;
    inc di;
    loop @2;
@3: mov si, di;
    jcxz @5;
@4: mov al, [di];
    cmp al, '"';
    jne @8;
    xor ah, 1;
@8: cmp al, ' ';
    ja @9;
    or ah, ah;
    je @5;
@9: inc di;
    loop @4;
@5: mov ax, di;
    sub ax, si;
    je @6;
    inc bx;
    dec dx;
    jnz @1;
@6: les di, @Result;
    mov bx, di;
    inc di;
    xor dl, dl;
    mov cx, ax;
    jcxz @12;
@11:lodsb;
    cmp al, '"';
    je @10;
    stosb;
    inc dl;
@10:loop @11;
@12:mov es:[bx], dl;
    pop ds;
end;

function LongOpenFile(Name: string; var F: ExtFile; Mode: Byte): Integer;
var
  B             : Byte;
  W             : Word;
  I             : Integer;
begin
  F.LongName := Name;
  B := 0;
  case Mode of
    fmReadOnly: B := $40;
    fmReadWrite, fmWriteOnly: B := $20;
  end;
  FileMode := Mode or B;
  asm
    mov W, 0;
    push ds;
    mov al, FileMode;
    xor ah, ah;
    push ax;
    push ss;
    pop ds;
    lea si, Name;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    xor di, di;
    mov dx, $01;
    mov bl, al;
    and bl, $0F;
    cmp bl, fmWriteOnly;
    jne @1;
    mov dx, $11;
@1: mov bl, al;
    mov al, $6C;
    xor cx, cx;
    call ExecLFN;
    pop bx;
    jnc @2;
    cmp ax, 5;
    jne @4;
    and bl, $0F;
    mov al, $6C;
    xor cx, cx;
    call ExecLFN;
    jnc @2;
@4: pop ds;
    mov W, ax;
    xor ax, ax;
    jmp @3;
@2: pop ds;
    les di, F;
    mov es:[di].ExtFile.Orig.FileRec.Mode, fmInOut;
    mov es:[di].ExtFile.Orig.FileRec.RecSize, 1;
@3: mov es:[di].ExtFile.Orig.FileRec.Handle, ax;
  end;
  LongOpenFile := W;
end;

procedure LongMkDir(Name: string);
begin
  asm
    push ds;
    push ss
    pop ds;
    lea si, Name;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    mov dx, si;
    mov al, $39;
    call ExecLFN;
    jc @1;
    xor ax, ax;
@1: pop ds;
    mov InOutRes, ax;
  end;
end;

function RightPos(C: Char; const S: string): Byte; assembler;
asm
    les di, S;
    mov al, es:[di];
    mov cl, al;
    xor ch, ch;
    jcxz @1;
    add di, cx;
    mov al, C;
    std;
    repne scasb;
    jne @1;
    inc cx;
@1: mov ax, cx;
end;

function AddToPath(const P, S: string; C: Char): string;
var
  T             : string;
begin
  if P = '' then
  begin
    AddToPath := S;
  end
  else
  begin
    T := P;
    if not (T[Length(T)] in [C, ':']) then T := T + C;
    AddToPath := T + S;
  end;
end;

function CutPath(const S: string; C: Char): string;
var
  B             : Word;
begin
  B := RightPos(C, S);
  if (B = 0) and (Length(S) >= 2) and (S[2] = ':') then B := 2;
  CutPath := Copy(S, B + 1, 255);
end;

function GetPath(const S: string; C: Char): string;
var
  B             : Word;
  T             : string;
begin
  B := RightPos(C, S);
  if (B = 0) and (Length(S) >= 2) and (S[2] = ':') then B := 2;
  if (B >= 2) and (S[B] = C) and (S[B - 1] <> ':') then Dec(B);
  T := Copy(S, 1, B);
  GetPath := T;
end;

procedure ExtBlockRead(var F: ExtFile; var Buf; Count: Word);
begin
  BlockRead(F.Orig, Buf, Count);
end;

procedure ExtBlockWrite(var F: ExtFile; var Buf; Count: Word);
begin
  BlockWrite(F.Orig, Buf, Count);
end;

procedure ExtClose(var F: ExtFile);
begin
  Close(F.Orig);
end;

function ExtFileSize(var F: ExtFile): Longint;
begin
  ExtFileSize := FileSize(F.Orig);
end;

function ExtFilePos(var F: ExtFile): Longint;
begin
  ExtFilePos := FilePos(F.Orig);
end;

procedure ExtSeek(var F: ExtFile; Pos: Longint);
begin
  Seek(F.Orig, Pos);
end;

procedure ExtGetFTime(var F: ExtFile; var Time: Longint);
begin
  GetFTime(F.Orig, Time);
end;

procedure ExtSetFTime(var F: ExtFile; Time: Longint);
begin
  SetFTime(F.Orig, Time);
end;

function ReadLongintRev(var F: ExtFile): Longint;
var
  L             : Longint;
begin
  ExtBlockRead(F, L, SizeOf(Longint));
  asm
    mov ax, word ptr L[0];
    mov dx, word ptr L[2];
    xchg al, dh;
    xchg ah, dl;
    mov word ptr L[0], ax;
    mov word ptr L[2], dx;
  end;
  ReadLongintRev := L;
end;

procedure CopyPart(var FromFile, ToFile: ExtFile; L: Longint);
var
  N             : Longint;
  P             : PBuffer;
begin
  if L > 0 then
  begin
    P := New(PBuffer);
    while L > 0 do
    begin
      if L > TBufferSize then N := TBufferSize else N := L;
      Dec(L, N);
      ExtBlockRead(FromFile, P^, N);
      ExtBlockWrite(ToFile, P^, N);
    end;
    Dispose(P);
  end;
end;

begin
  WriteLn('Electronic Arts VIV extractor by Joe Forster/STA');
  WriteLn;
  if ParamCount < 1 then
  begin
    WriteLn('This program extracts Electronic Arts VIV archives.');
    WriteLn;
    WriteLn('Extract: EXTVIV <archive> [<destination-dir>]');
  end
  else
  begin
    if InitLongNames then
    begin
      ArcName := LongParamStr(1);
      BinPath := LongParamStr(2);
      if LongOpenFile(ArcName, ArcFile, fmReadOnly) = 0 then
      begin
        WriteLn('Processing archive: ', ArcName, '...');
        WriteLn;
        ExtBlockRead(ArcFile, ArcSign, SizeOf(Longint));
        TotalSize := ReadLongintRev(ArcFile);
        ArcVer := ReadLongintRev(ArcFile);
        if (ArcSign = VIVSign) and (ArcVer = VIVVer) then
        begin
          ExtGetFTime(ArcFile, ArcTime);
          ArcNameDirLen := ReadLongintRev(ArcFile);
          ArcDirPos := ExtFilePos(ArcFile);
          Dec(ArcNameDirLen, ArcDirPos);
          while True do
          begin
            ExtSeek(ArcFile, ArcDirPos);
            ArcEntry.DataPos := ReadLongintRev(ArcFile);
            ArcEntry.DataLen := ReadLongintRev(ArcFile);
            ExtBlockRead(ArcFile, ArcEntry.FileName, ArcEntryMaxLen);
            if ArcEntry.DataPos = 0 then Break;
            EntryName := ASCIIZtoStr(ArcEntry.FileName[0], ArcEntryMaxLen);
            ArcPos := ArcEntry.DataPos;
            BinSize := ArcEntry.DataLen;
            WriteLn('Extracting ', EntryName);
            BinName[0] := Chr(Length(EntryName));
            for Index := 1 to Length(BinName) do if EntryName[Index] = '/' then BinName[Index] := '\' else
              BinName[Index] := EntryName[Index];
            Quit := False;
            repeat
              IOError := LongOpenFile(AddToPath(BinPath, BinName, '\'), BinFile, fmWriteOnly);
              if IOError = 3 then
              begin
                DirName := BinName;
                repeat
                  DirName := GetPath(DirName, '\');
                  LongMkDir(AddToPath(BinPath, DirName, '\'));
                  IOError := IOResult;
                until (IOError = 0) or (DirName = '');
              end
              else
              begin
                Quit := True;
              end;
            until Quit;
            if IOError = 0 then
            begin
              ExtSeek(ArcFile, ArcPos);
              CopyPart(ArcFile, BinFile, BinSize);
              ExtSetFTime(BinFile, ArcTime);
              ExtClose(BinFile);
            end;
            InOutRes := 0;
            Inc(ArcDirPos, (2 * SizeOf(Longint)) + Length(EntryName) + 1);
          end;
        end
        else
        begin
          WriteLn('Unknown archive type');
        end;
      end
      else
      begin
        WriteLn('Cannot open archive');
      end;
    end
    else
    begin
      WriteLn('Long filenames are not available');
    end;
  end;
end.
