{
Ŀ
                 Joe Forster/STA                 
                                                 
                   F64CHECK.PAS                  
                                                 
                     F64Check                    

}

program F64Check;

{$A+,B-,D+,E-,F+,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384, 0, 655360}

uses
  DOS;

const
  HeaderSign= $07;
  DiskSize1541= 683;
  DiskSize1541Ext= 768;
  chDirSep= '\';
  TrackNumber: array [False..True] of Byte = (35, 40);
  HexaNum       : string[16] = '0123456789ABCDEF';
  PETtoASCLower : array [0..255] of Byte = (
    $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00,
    $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00,
    $20, $21, $22, $23, $24, $25, $26, $27, $28, $29, $2A, $2B, $2C, $2D, $2E, $2F,
    $30, $31, $32, $33, $34, $35, $36, $37, $38, $39, $3A, $3B, $3C, $3D, $3E, $3F,
    $40, $61, $62, $63, $64, $65, $66, $67, $68, $69, $6A, $6B, $6C, $6D, $6E, $6F,
    $70, $71, $72, $73, $74, $75, $76, $77, $78, $79, $7A, $5B, $00, $5D, $00, $00,
    $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00,
    $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00,
    $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00,
    $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00,
    $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00,
    $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00,
    $00, $41, $42, $43, $44, $45, $46, $47, $48, $49, $4A, $4B, $4C, $4D, $4E, $4F,
    $50, $51, $52, $53, $54, $55, $56, $57, $58, $59, $5A, $00, $00, $00, $00, $00,
    $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00,
    $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00);

var
  DiskOpen,
  DiskExtended,
  DiskErrorInfo,
  FCOPYExtended: Boolean;
  Track,
  Sector,
  Checksum,
  Errors: Byte;
  FilesProcessed,
  Index: Word;
  DiskSize,
  FCOPYSize: Longint;
  HeaderID,
  BAMID: string[2];
  DiskName,
  FCOPYName: string;
  DiskFile,
  FCOPYFile: file;
  DiskBlock: array [0..255] of Byte;
  FCOPYBlock: array [0..2] of Byte;
  ErrorNum: array [#0..#255] of Longint;
  MismatchNum: array [0..1] of Longint;

function SectorNum(T: Byte): Byte;
begin
  case T of
    1..17: SectorNum := 21;
    18..24: SectorNum := 19;
    25..30: SectorNum := 18;
    31..42: SectorNum := 17;
  end;
end;

function DiskPos(T, S: Byte): Longint;
var
  I: Integer;
  P: Longint;
begin
  P := 0;
  for I := 1 to T - 1 do Inc(P, SectorNum(I));
  Inc(P, S);
  DiskPos := P;
end;

function LeadingZero(L: Longint; N: Word): string;
var
  I: Word;
  S: string;
begin
  Str(L:N, S);
  I := 1;
  while (I <= Length(S)) and (S[I] = ' ') do
  begin
    S[I] := '0';
    Inc(I);
  end;
  LeadingZero := S;
end;

function AddToPath(const P, S: string; C: Char): string;
var
  T: string;
  W: Word;
begin
  if P = '' then
  begin
    AddToPath := S;
  end
  else
  begin
    T := P;
    if Length(T) + Length(S) > 253 then T[0] := Chr(253 - Length(S));
    W := Length(T);
    if T[W] = '"' then Dec(W);
    if not (T[W] in [C, ':']) then T := T + C;
    AddToPath := T + S;
  end;
end;

function HexaStr(D: Longint; L: Byte): string;
var
  I             : Byte;
  S             : string;
begin
  S := '';
  for I := L - 1 downto 0 do S := S + HexaNum[(D shr (I * 4) and $0F) + 1];
  HexaStr := S;
end;

function ConvertPETSCIItoASCII(const PETSCII: string): string;
var
  B: Byte;
  W: Word;
  S: string;
  T: string[4];
begin
  W := 1;
  S := '';
  while W <= Length(PETSCII) do
  begin
    B := PETtoASCLower[Ord(PETSCII[W])];
    if B = 0 then T := '\$' + HexaStr(Ord(PETSCII[W]), 2) else T := Chr(B);
    S := S + T;
    Inc(W);
  end;
  COnvertPETSCIItoASCII := S;
end;

procedure ProcessFiles(Path: string);
var
  Entry: SearchRec;
begin
  FindFirst(AddToPath(Path, '*.F64', chDirSep), AnyFile, Entry);
  while DOSError = 0 do
  begin
    if Entry.Attr and Directory = 0 then
    begin
      FCOPYName := AddToPath(Path, Entry.Name, chDirSep);
      Assign(FCOPYFile, FCOPYName);
      Reset(FCOPYFile, 1);
      if IOResult = 0 then
      begin
        Inc(FilesProcessed);
        DiskName := AddToPath(Path, Copy(Entry.Name, 1, Length(Entry.Name) - 3) + 'D64', chDirSep);
        Assign(DiskFile, DiskName);
        Reset(DiskFile, 1);
        DiskOpen := (IOResult = 0);
        FCOPYSize := FileSize(FCOPYFile) - 2;
        FCOPYExtended := (FCOPYSize = (DiskSize1541Ext * 3));
        if (FCOPYSize = (DiskSize1541 * 3)) or FCOPYExtended then
        begin
          HeaderID[0] := #2;
          BlockRead(FCOPYFile, HeaderID[1], 2);
          Track := 1;
          Sector := 0;
          if DiskOpen then
          begin
            DiskSize := FileSize(DiskFile);
            DiskExtended := (DiskSize = (DiskSize1541Ext shl 8)) or (DiskSize = DiskSize1541Ext * 257);
            DiskErrorInfo := (DiskSize = (DiskSize1541 * 257)) or (DiskSize = DiskSize1541Ext * 257);
            if not ((DiskSize = (DiskSize1541 shl 8)) or DiskExtended or DiskErrorInfo) then
            begin
              WriteLn(DiskName, ':INVALID FILESIZE');
              Close(DiskFile);
              DiskOpen := False;
            end;
            if DiskOpen then
            begin
              if DiskExtended <> FCOPYExtended then
              begin
                WriteLn(DiskName, ':', TrackNumber[DiskExtended], '/', TrackNumber[FCOPYExtended],
                  ' TRACK NUMBER MISMATCH');
                Close(DiskFile);
                DiskOpen := False;
              end;
            end;
            if DiskOpen and DiskErrorInfo then
              WriteLn(DiskName, ':ERROR INFO PRESENT');
            if DiskOpen then
            begin
              Seek(DiskFile, DiskPos(18, 0) shl 8);
              BlockRead(DiskFile, DiskBlock, 256);
              Seek(DiskFile, 0);
              BAMID[0] := #2;
              Move(DiskBlock[$A2], BAMID[1], 2);
              if HeaderID <> BAMID then
                WriteLn(DiskName, ':"', ConvertPETSCIItoASCII(HeaderID), '"/"', ConvertPETSCIItoASCII(BAMID),
                  '" HEADER/BAM ID MISMATCH');
            end;
          end;
          FCOPYSize := FCOPYSize div 3;
          while FCOPYSize > 0 do
          begin
            BlockRead(FCOPYFile, FCOPYBlock, 3);
            Errors := 0;
            Inc(ErrorNum[Chr(FCOPYBlock[0])]);
            case Chr(FCOPYBlock[0]) of
              '-', '+': ;
              '?', 'H', 'S', 'I', 'C', 'L', 'F', 'P':
              begin
                Inc(Errors);
                WriteLn(FCOPYName, ':', LeadingZero(Track, 2), ';', LeadingZero(Sector, 2),
                  ':"', Chr(FCOPYBlock[0]), '" error');
              end;
            else
              Inc(Errors);
              WriteLn(FCOPYName, ':', LeadingZero(Track, 2), ';', LeadingZero(Sector, 2),
                ':"', ConvertPETSCIItoASCII(Chr(FCOPYBlock[0])), '" INVALID ERROR');
            end;
            if FCOPYBlock[1] <> HeaderSign then
            begin
              Inc(Errors);
              Inc(MismatchNum[0]);
              WriteLn(FCOPYName, ':', LeadingZero(Track, 2), ';', LeadingZero(Sector, 2),
                ':', LeadingZero(FCOPYBlock[1], 3), '/', LeadingZero(HeaderSign, 3),  ' block sign');
            end;
            if DiskOpen then
            begin
              BlockRead(DiskFile, DiskBlock, 256);
              Checksum := 0;
              for Index := 0 to 255 do Checksum := Checksum xor DiskBlock[Index];
              if FCOPYBlock[2] <> Checksum then
              begin
                Inc(Errors);
                Inc(MismatchNum[1]);
                WriteLn(FCOPYName, ':', LeadingZero(Track, 2), ';', LeadingZero(Sector, 2),
                  ':', LeadingZero(FCOPYBlock[2], 3), '/', LeadingZero(Checksum, 3), ' checksum');
              end;
            end;
            if Errors > 1 then
            begin
              WriteLn(FCOPYName, ':', LeadingZero(Track, 2), ';', LeadingZero(Sector, 2),
                ':MULTIPLE ERRORS');
            end;
            Dec(FCOPYSize);
            Inc(Sector);
            if Sector >= SectorNum(Track) then
            begin
              Inc(Track);
              Sector := 0;
            end;
          end;
        end
        else
        begin
          WriteLn(FCOPYName, ':INVALID FILESIZE');
        end;
        Close(FCOPYFile);
        if DiskOpen then Close(DiskFile);
      end;
    end;
    FindNext(Entry);
  end;
  FindFirst(AddToPath(Path, '*.*', chDirSep), AnyFile, Entry);
  while DOSError = 0 do
  begin
    if (Entry.Attr and Directory <> 0) and (Entry.Name <> '.') and (Entry.Name <> '..') then
      ProcessFiles(AddToPath(Path, Entry.Name, chDirSep));
    FindNext(Entry);
  end;
end;

begin
  WriteLn('F64Check 0.10 beta by Joe Forster/STA (2003-01-05)');
  WriteLn;
  ProcessFiles('');
  if FilesProcessed = 0 then
  begin
    WriteLn('No files found!');
  end
  else
  begin
    WriteLn;
    WriteLn('Number of processed files: ', FilesProcessed);
    WriteLn('Number of bad sectors per status code:');
    WriteLn('  "?": ', ErrorNum['?']);
    WriteLn('  "H": ', ErrorNum['H']);
    WriteLn('  "S": ', ErrorNum['S']);
    WriteLn('  "I": ', ErrorNum['I']);
    WriteLn('  "C": ', ErrorNum['C']);
    WriteLn('  "L": ', ErrorNum['L']);
    WriteLn('  "F": ', ErrorNum['F']);
    WriteLn('  "P": ', ErrorNum['P']);
    WriteLn('Number of sectors with invalid header signature byte: ', MismatchNum[0]);
    WriteLn('Number of sectors with wrong data block checksum:     ', MismatchNum[1]);
  end;
end.
