{
Ŀ
                 Joe Forster/STA                 
                                                 
                   FLATBFS.PAS                   
                                                 
               FlatOut BFS archiver              

}

{$M 32768, 65536, 65536}

uses
  DOS;

const
  fmReadOnly    = 0;
  fmWriteOnly   = 1;
  fmReadWrite   = 2;
  ArcEntryMaxLen= 256;
  TBufferSize   = $FE00;
  BFSSign       = $31736662;
  BFSVer        = $20040505;
  HexaNum       : string[16] = '0123456789ABCDEF';

type
  ExtFile       = record
    Orig        : file;
    LongName    : string;
  end;
  PExtFile      = ^ExtFile;
  TBuffer       = array [0..TBufferSize - 1] of Byte;
  PBuffer       = ^TBuffer;
  ExtSearchRec  = record
    Orig        : SearchRec;
    HandleUsed  : Boolean;
    LongHandle  : Word;
    LongName    : string;
  end;
  LongSearchRec = record
    Attr        : Longint;
    Dummy1      : array [1..16] of Byte;
    Time        : Longint;
    Dummy2      : array [1..8] of Byte;
    Size        : Longint;
    Dummy3      : array [1..8] of Byte;
    LongName    : array [1..260] of Byte;
    ShortName   : array [1..14] of Byte;
  end;
  BFSDirEntry   = record
    Attrib,
    DataPos,
    DataUncompSize,
    DataSize,
    Reserved  : Longint;
    NameLen   : Word;
  end;

var
  AddFileAttr,
  Delete,
  Update,
  List,
  Quit          : Boolean;
  Command       : Char;
  ArcEntryLen,
  Index,
  FileNum       : Word;
  IOError       : Integer;
  Dummy,
  ArcSign,
  ArcVer,
  ArcPos,
  NewArcPos,
  BinSize,
  ArcDirSize,
  ArcDirPos,
  ArcDirLen,
  ArcTime,
  HashTableLen,
  TotalSize     : Longint;
  ArcCompSign   : string[12];
  ArcName,
  EntryName,
  EntryUncompSize,
  EntryAttr,
  BinName,
  BinPath,
  DirName,
  ListName,
  NameListName  : string;
  ArcFile,
  NewArcFile,
  BinFile,
  ListFile,
  NameListFile  : ExtFile;
  ArcEntry      : BFSDirEntry;

function HexaStr(D: Longint; L: Byte): string;
var
  I             : Byte;
  S             : string;
begin
  S := '';
  for I := L - 1 downto 0 do S := S + HexaNum[(D shr (I * 4) and $0F) + 1];
  HexaStr := S;
end;

function HexaEval(const S: string; var Code: Integer): Longint;
var
  I,
  X             : Byte;
  V             : Longint;
begin
  V := 0;
  I := 1;
  Code := 0;
  while (Code = 0) and (I <= Length(S)) do
  begin
    X := Pos(UpCase(S[I]), HexaNum);
    if X = 0 then Code := I else V := V shl 4 + X - 1;
    Inc(I);
  end;
  HexaEval := V;
end;

procedure ExecLFN; assembler;
asm
    mov ah, $71;
    stc;
    int $21;
    jc @1;
    cmp ax, $7100;
    stc;
    je @1;
    clc;
@1:
end;

function InitLongNames: Boolean; assembler;
var
  S,
  T             : string;
asm
    push ds;
    push ss;
    pop ds;
    push ss;
    pop es;
    lea si, S;
    mov byte ptr [si], 0;
    lea di, T;
    xor cl, cl;
    mov ch, $80;
    mov al, $60;
    call ExecLFN;
    mov bx, ax;
    pop ds;
    mov al, True;
    jnc @1;
    cmp bx, $7100;
    jne @1;
    mov al, False;
@1:
end;

function LongParamStr(Index: Byte): string; assembler;
asm
    push ds;
    mov dl, Index;
    or dl, dl;
    je @12;
    xor dh, dh;
    mov ax, PrefixSeg;
    mov ds, ax;
    mov di, $0080;
    mov cl, [di];
    xor ch, ch;
    inc di;
    xor bx, bx;
    xor ah, ah;
@1: jcxz @3;
@2: mov al, [di];
    cmp al, '"';
    jne @7;
    xor ah, 1;
    inc di;
    dec cx;
    jmp @3;
@7: cmp al, ' ';
    ja @3;
    inc di;
    loop @2;
@3: mov si, di;
    jcxz @5;
@4: mov al, [di];
    cmp al, '"';
    jne @8;
    xor ah, 1;
@8: cmp al, ' ';
    ja @9;
    or ah, ah;
    je @5;
@9: inc di;
    loop @4;
@5: mov ax, di;
    sub ax, si;
    je @6;
    inc bx;
    dec dx;
    jnz @1;
@6: les di, @Result;
    mov bx, di;
    inc di;
    xor dl, dl;
    mov cx, ax;
    jcxz @12;
@11:lodsb;
    cmp al, '"';
    je @10;
    stosb;
    inc dl;
@10:loop @11;
@12:mov es:[bx], dl;
    pop ds;
end;

function LongOpenFile(Name: string; var F: ExtFile; Mode: Byte): Integer;
var
  B             : Byte;
  W             : Word;
  I             : Integer;
begin
  F.LongName := Name;
  B := 0;
  case Mode of
    fmReadOnly: B := $40;
    fmReadWrite, fmWriteOnly: B := $20;
  end;
  FileMode := Mode or B;
  asm
    mov W, 0;
    push ds;
    mov al, FileMode;
    xor ah, ah;
    push ax;
    push ss;
    pop ds;
    lea si, Name;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    xor di, di;
    mov dx, $01;
    mov bl, al;
    and bl, $0F;
    cmp bl, fmWriteOnly;
    jne @1;
    mov dx, $11;
@1: mov bl, al;
    mov al, $6C;
    xor cx, cx;
    call ExecLFN;
    pop bx;
    jnc @2;
    cmp ax, 5;
    jne @4;
    and bl, $0F;
    mov al, $6C;
    xor cx, cx;
    call ExecLFN;
    jnc @2;
@4: pop ds;
    mov W, ax;
    xor ax, ax;
    jmp @3;
@2: pop ds;
    les di, F;
    mov es:[di].ExtFile.Orig.FileRec.Mode, fmInOut;
    mov es:[di].ExtFile.Orig.FileRec.RecSize, 1;
@3: mov es:[di].ExtFile.Orig.FileRec.Handle, ax;
  end;
  LongOpenFile := W;
end;

procedure LongMkDir(Name: string);
begin
  asm
    push ds;
    push ss
    pop ds;
    lea si, Name;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    mov dx, si;
    mov al, $39;
    call ExecLFN;
    jc @1;
    xor ax, ax;
@1: pop ds;
    mov InOutRes, ax;
  end;
end;

procedure LongErase(Name: string);
begin
  asm
    push ds;
    push ss;
    pop ds;
    lea si, Name;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    mov dx, si;
    xor si, si;
    mov al, $41;
    call ExecLFN;
    jc @1;
    xor ax, ax;
@1: pop ds;
    mov InOutRes, ax;
  end;
end;

procedure FixSearchResult(const E: LongSearchRec; var F: ExtSearchRec; B: Byte);
begin
  F.Orig.Attr := E.Attr;
  F.Orig.Time := E.Time;
  F.Orig.Size := E.Size;
  F.LongName[0] := Chr(B);
  Move(E.LongName, F.LongName[1], B);
end;

procedure LongFindFirst(Path: string; Attr: Byte; var F: ExtSearchRec);
var
  B             : Byte;
  W             : Word;
  E             : LongSearchRec;
begin
  asm
    mov DOSError, 0;
    push ds;
    push ss;
    pop ds;
    push ss;
    pop es;
    lea si, Path;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    lea di, E;
    mov dx, si;
    mov cl, Attr;
    xor ch, ch;
    mov si, 1;
    mov al, $4E;
    call ExecLFN;
    pop ds;
    jc @1;
    mov W, ax;
    xor al, al;
    add di, LongSearchRec.LongName;
    mov bx, di;
    mov cx, 255;
    cld;
    repne scasb;
    sub bx, di;
    neg bx;
    dec bx;
    mov byte ptr B, bl;
    jmp @2;
@1: mov DOSError, ax;
@2:
  end;
  if DOSError = 0 then
  begin
    F.HandleUsed := True;
    F.LongHandle := W;
  end;
  FixSearchResult(E, F, B);
end;

{Find next instance of a file in a directory
  Input : F: record to read data from and store result into}
procedure LongFindNext(var F: ExtSearchRec);
var
  B             : Byte;
  E             : LongSearchRec;
begin
  asm
    mov DOSError, 0;
    les di, F;
    mov bx, es:[di].ExtSearchRec.LongHandle;
    push ss;
    pop es;
    lea di, E;
    mov si, 1;
    mov al, $4F;
    call ExecLFN;
    jc @1;
    xor al, al;
    add di, LongSearchRec.LongName;
    mov bx, di;
    mov cx, 255;
    cld;
    repne scasb;
    sub bx, di;
    neg bx;
    dec bx;
    mov byte ptr B, bl;
    jmp @2;
@1: mov DOSError, ax;
@2:
  end;
  FixSearchResult(E, F, B);
end;

procedure LongFindClose(var F: ExtSearchRec); assembler;
asm
    les di, F;
    mov byte ptr es:[di].ExtSearchRec.HandleUsed, 0;
    mov bx, es:[di].ExtSearchRec.LongHandle;
    mov al, $A1;
    call ExecLFN;
end;

function RightPos(C: Char; const S: string): Byte; assembler;
asm
    les di, S;
    mov al, es:[di];
    mov cl, al;
    xor ch, ch;
    jcxz @1;
    add di, cx;
    mov al, C;
    std;
    repne scasb;
    jne @1;
    inc cx;
@1: mov ax, cx;
end;

function AddToPath(const P, S: string; C: Char): string;
var
  T             : string;
begin
  if P = '' then
  begin
    AddToPath := S;
  end
  else
  begin
    T := P;
    if not (T[Length(T)] in [C, ':']) then T := T + C;
    AddToPath := T + S;
  end;
end;

function CutPath(const S: string; C: Char): string;
var
  B             : Word;
begin
  B := RightPos(C, S);
  if (B = 0) and (Length(S) >= 2) and (S[2] = ':') then B := 2;
  CutPath := Copy(S, B + 1, 255);
end;

function GetPath(const S: string; C: Char): string;
var
  B             : Word;
  T             : string;
begin
  B := RightPos(C, S);
  if (B = 0) and (Length(S) >= 2) and (S[2] = ':') then B := 2;
  if (B >= 2) and (S[B] = C) and (S[B - 1] <> ':') then Dec(B);
  T := Copy(S, 1, B);
  GetPath := T;
end;

procedure ExtBlockRead(var F: ExtFile; var Buf; Count: Word);
begin
  BlockRead(F.Orig, Buf, Count);
end;

procedure ExtBlockWrite(var F: ExtFile; var Buf; Count: Word);
begin
  BlockWrite(F.Orig, Buf, Count);
end;

procedure ExtClose(var F: ExtFile);
begin
  Close(F.Orig);
end;

function ExtFileSize(var F: ExtFile): Longint;
begin
  ExtFileSize := FileSize(F.Orig);
end;

procedure ExtSeek(var F: ExtFile; Pos: Longint);
begin
  Seek(F.Orig, Pos);
end;

procedure ExtGetFTime(var F: ExtFile; var Time: Longint);
begin
  GetFTime(F.Orig, Time);
end;

procedure ExtSetFTime(var F: ExtFile; Time: Longint);
begin
  SetFTime(F.Orig, Time);
end;

procedure CopyPart(var FromFile, ToFile: ExtFile; L: Longint);
var
  N             : Longint;
  P             : PBuffer;
begin
  if L > 0 then
  begin
    P := New(PBuffer);
    while L > 0 do
    begin
      if L > TBufferSize then N := TBufferSize else N := L;
      Dec(L, N);
      ExtBlockRead(FromFile, P^, N);
      ExtBlockWrite(ToFile, P^, N);
    end;
    Dispose(P);
  end;
end;

procedure PrintTotal;
begin
  WriteLn;
  WriteLn('Processed ', FileNum, ' files, ', TotalSize, ' bytes');
end;

begin
  WriteLn('FlatOut BFS archiver by Joe Forster/STA');
  WriteLn;
  if ParamCount < 2 then
  begin
    WriteLn('This program deletes from, updates, lists and extracts FlatOut BFS archives.');
    WriteLn;
    WriteLn('Delete:  FLATBFS D <archive> [<source-dir>]');
    WriteLn('Update:  FLATBFS U <archive> [<source-dir>]');
    WriteLn('List:    FLATBFS L <archive>');
    WriteLn('Extract: FLATBFS X <archive> [<destination-dir>] [-|/A]');
  end
  else
  begin
    if InitLongNames then
    begin
      BinName := LongParamStr(1);
      ArcName := LongParamStr(2);
      BinPath := LongParamStr(3);
      Command := UpCase(BinName[1]);
      case Command of
        'D', 'L', 'U', 'X':
        begin
          Delete := (Command = 'D');
          Update := (Command = 'U') or Delete;
          List := (Command = 'L');
          AddFileAttr := not List;
          if BinPath[1] in ['-', '/'] then
          begin
            BinName := BinPath;
            BinPath := '';
          end
          else
          begin
            BinName := LongParamStr(4);
          end;
          if (BinName[1] in ['-', '/']) and (UpCase(BinName[2]) = 'A') then AddFileAttr := False;
          if LongOpenFile(ArcName, ArcFile, fmReadOnly) = 0 then
          begin
            WriteLn('Processing archive: ', ArcName, '...');
            WriteLn;
            ExtBlockRead(ArcFile, ArcSign, SizeOf(Longint));
            ExtBlockRead(ArcFile, ArcVer, SizeOf(Longint));
            ExtBlockRead(ArcFile, ArcDirSize, SizeOf(Longint));
            ExtBlockRead(ArcFile, ArcDirLen, SizeOf(Longint));
            if (ArcSign = BFSSign) and (ArcVer = BFSVer) then
            begin
              Quit := False;
              if Update then
              begin
                Quit := (LongOpenFile(ArcName + '_new', NewArcFile, fmWriteOnly) <> 0);
                if not Quit then
                begin
                  ExtBlockWrite(NewArcFile, ArcSign, SizeOf(Longint));
                  ExtBlockWrite(NewArcFile, ArcVer, SizeOf(Longint));
                  ExtBlockWrite(NewArcFile, ArcDirSize, SizeOf(Longint));
                  ExtBlockWrite(NewArcFile, ArcDirLen, SizeOf(Longint));
                  NewArcPos := (ArcDirSize + 3) and $FFFFFFFC;
                end;
              end;
              if not Quit then
              begin
                ArcDirPos := 16;
                ExtGetFTime(ArcFile, ArcTime);
                BinSize := ArcDirLen * SizeOf(Longint);
                Inc(ArcDirPos, BinSize);
                if Update then CopyPart(ArcFile, NewArcFile, BinSize) else ExtSeek(ArcFile, ArcDirPos);
                ExtBlockRead(ArcFile, HashTableLen, SizeOf(Longint));
                Inc(ArcDirPos, SizeOf(Longint));
                if Update then ExtBlockWrite(NewArcFile, HashTableLen, SizeOf(Longint));
                BinSize := HashTableLen * SizeOf(Longint);
                Inc(ArcDirPos, BinSize);
                if Update then
                begin
                  CopyPart(ArcFile, NewArcFile, BinSize);
                  BinSize := ArcDirSize + 1 - ArcDirPos;
                  CopyPart(ArcFile, NewArcFile, BinSize);
                  BinSize := 4 - (BinSize and $00000003);
                  if BinSize = 4 then BinSize := 0;
                  Dummy := 0;
                  ExtBlockWrite(NewArcFile, Dummy, BinSize);
                end
                else
                begin
                  ExtSeek(ArcFile, ArcDirPos);
                end;
                FileNum := 0;
                while ArcDirLen > 0 do
                begin
                  ExtSeek(ArcFile, ArcDirPos);
                  ExtBlockRead(ArcFile, ArcEntry, SizeOf(BFSDirEntry));
                  ExtBlockRead(ArcFile, EntryName[1], ArcEntry.NameLen);
                  EntryName[0] := Chr(ArcEntry.NameLen);
                  Index := Pos(#0, EntryName);
                  if Index > 0 then EntryName[0] := Chr(Index - 1);
                  if EntryName <> '' then
                  begin
                    if AddFileAttr and not Update then
                      EntryName := EntryName + '.' + HexaStr(ArcEntry.DataUncompSize, 8) +
                        '.' + HexaStr(ArcEntry.Attrib, 8) + '.' + HexaStr(ArcEntry.Reserved, 8);
                    ArcPos := ArcEntry.DataPos;
                    BinSize := ArcEntry.DataSize;
                    if List then
                    begin
                      WriteLn(EntryName);
                    end
                    else
                    begin
                      BinName[0] := Chr(Length(EntryName));
                      for Index := 1 to Length(BinName) do if EntryName[Index] = '/' then BinName[Index] := '\' else
                        BinName[Index] := EntryName[Index];
                      if Update then
                      begin
                        IOError := LongOpenFile(AddToPath(BinPath, BinName, '\'), BinFile, fmReadOnly);
                      end
                      else
                      begin
                        Quit := False;
                        repeat
                          IOError := LongOpenFile(AddToPath(BinPath, BinName, '\'), BinFile, fmWriteOnly);
                          if IOError = 3 then
                          begin
                            IOError := 0;
                            if BinPath <> '' then
                            begin
                              LongMkDir(BinPath);
                              IOError := IOResult;
                            end;
                            if IOError = 3 then
                            begin
                              Quit := True;
                            end
                            else
                            begin
                              DirName := BinName;
                              repeat
                                DirName := GetPath(DirName, '\');
                                LongMkDir(AddToPath(BinPath, DirName, '\'));
                                IOError := IOResult;
                              until (IOError = 0) or (DirName = '');
                            end;
                          end
                          else
                          begin
                            Quit := True;
                          end;
                        until Quit;
                      end;
                      if IOError = 0 then
                      begin
                        if Update then
                        begin
                          if Delete then
                          begin
                            WriteLn('Deleting ', EntryName);
                            BinSize := 0;
                            FillChar(EntryName[1], Length(EntryName), 0);
                            ArcEntry.DataPos := 0;
                            ArcEntry.Reserved := 0;
                          end
                          else
                          begin
                            WriteLn('Updating ', EntryName);
                            BinSize := ExtFileSize(BinFile);
                            ExtSeek(NewArcFile, NewArcPos);
                            CopyPart(BinFile, NewArcFile, BinSize);
                            ArcEntry.DataPos := NewArcPos;
                          end;
                          ExtClose(BinFile);
                          ArcEntry.Attrib := 4;
                          ArcEntry.DataSize := BinSize;
                          ArcEntry.DataUncompSize := BinSize;
                        end
                        else
                        begin
                          WriteLn('Extracting ', EntryName);
                          ExtSeek(ArcFile, ArcPos);
                          CopyPart(ArcFile, BinFile, BinSize);
                          ExtSetFTime(BinFile, ArcTime);
                          ExtClose(BinFile);
                        end;
                      end
                      else
                      begin
                        if Update then
                        begin
                          WriteLn('Copying ', EntryName);
                          BinSize := ArcEntry.DataSize;
                          ExtSeek(ArcFile, ArcEntry.DataPos);
                          ExtSeek(NewArcFile, NewArcPos);
                          CopyPart(ArcFile, NewArcFile, BinSize);
                          ArcEntry.DataPos := NewArcPos;
                        end;
                      end;
                      InOutRes := 0;
                      if Update then
                      begin
                        ExtSeek(NewArcFile, ArcDirPos);
                        ExtBlockWrite(NewArcFile, ArcEntry, SizeOf(BFSDirEntry));
                        ExtBlockWrite(NewArcFile, EntryName[1], Length(EntryName));
                        Inc(NewArcPos, BinSize);
                      end;
                    end;
                  end;
                  Inc(FileNum);
                  Inc(ArcDirPos, SizeOf(BFSDirEntry));
                  Inc(ArcDirPos, ArcEntry.NameLen);
                  Inc(TotalSize, BinSize);
                  Dec(ArcDirLen);
                end;
                PrintTotal;
                if Update then
                begin
                  ExtSetFTime(NewArcFile, ArcTime);
                  ExtClose(NewArcFile);
                end;
              end;
            end
            else
            begin
              WriteLn('Unknown archive type');
            end;
          end
          else
          begin
            WriteLn('Cannot open archive');
          end;
        end;
      else
        WriteLn('Invalid command');
      end;
    end
    else
    begin
      WriteLn('Long filenames are not available');
    end;
  end;
end.
