;Ŀ
;                 Joe Forster/STA                 
;                                                 
;                    PATCH.ASM                    
;                                                 
;                   File Patch                    
;

CSeg		segment
		assume	cs:CSeg, ds:CSeg, ss:CSeg
		org	0100h

BufferSize	equ	64512
ProgramSize	equ	4096

Main:		mov	ax, ds:[0006h]
		cmp	ax, ProgramSize
		jbe	@15
		mov	bx, ProgramSize / 16
		mov	ah, 4Ah
		int	21h
		mov	sp, ProgramSize
		xor	ax, ax
		push	ax
@15:		mov	di, Offset DataStart
		mov	cx, DataEnd - DataStart
		xor	al, al
		cld
		rep	stosb
		mov	dx, Offset Hello
		mov	ah, 9
		int	21h
		mov	bl, 1
		mov	di, Offset Par
		mov	cx, 79
		call	ParamStr
		or	bh, bh
		jne	@01
		mov	dx, Offset Usage
		mov	ah, 9
		int	21h
		xor	al, al
		jmp	@02
@01:		mov	bl, 2
		mov	di, Offset PatchName
		mov	cx, 79
		call	ParamStr
		cmp	bh, 2
		jae	@08
		mov	si, Offset DefPatchName
		mov	di, Offset PatchName
		stc
		call	StrCopy
@08:		mov	dx, Offset Par
		mov	ax, 3D02h
		int	21h
		jnc	@04
@05:		clc
		call	PrintStr
		mov	dx, Offset NotFound
		jmp	@03
@04:		mov	di, ax
		mov	dx, Offset PatchName
		mov	ax, 3D00h
		int	21h
		jc	@05
		mov	PatchFile, ax
		mov	bx, BufferSize / 16
		mov	ah, 48h
		int	21h
		jnc	@13
		mov	dx, Offset NoMemory
		jmp	@03
@13:		mov	Buffer, ax
		mov	bx, PatchFile
		mov	ax, 4202h
		xor	cx, cx
		xor	dx, dx
		int	21h
		sub	ax, 4
		sbb	dx, 0
		mov	PatchLen, ax
		or	dx, dx
		je	@07
		mov	dx, Offset PatchName
		jmp	@12
@07:		mov	ax, 4200h
		xor	cx, cx
		xor	dx, dx
		int	21h
		mov	cx, 4
		mov	dx, Offset OrigLen
		mov	ah, 3Fh
		int	21h
		mov	bx, di
		mov	ax, 4202h
		xor	cx, cx
		xor	dx, dx
		int	21h
		cmp	word ptr OrigLen[0], ax
		jne	@10
		cmp	word ptr OrigLen[2], dx
		je	@11
@10:		mov	dx, Offset Par
@12:		clc
		call	PrintStr
		mov	dx, Offset InvalidSize
		jmp	@03
@11:		mov	ax, 4200h
		xor	cx, cx
		xor	dx, dx
		int	21h
		mov	ax, 5700h
		int	21h
		mov	Time, cx
		mov	Date, dx
		mov	dx, Offset Patching
		mov	ah, 9
		int	21h
		mov	dx, Offset Par
		stc
		call	PrintStr
		mov	ax, Buffer
		mov	bx, PatchFile
		mov	cx, PatchLen
		call	BlockRead
		xor	bx, bx
@16:		cmp	bx, word ptr PatchLen[0]
		jae	@14
		push	ds
		mov	ds, cs:Buffer
		mov	dx, ds:[bx]
		mov	cx, ds:[bx][2]
		mov	si, ds:[bx][4]
		add	bx, 6
		push	bx
		push	bx
		mov	bx, di
		mov	ax, 4200h
		int	21h
		pop	dx
		mov	cx, si
		mov	ah, 40h
		int	21h
		pop	bx
		add	bx, si
		pop	ds
		jmp	@16
@14:		push	es
		mov	es, Buffer
		mov	ah, 49h
		int	21h
		pop	es
		mov	bx, di
		mov	ax, 5701h
		mov	cx, Time
		mov	dx, Date
		int	21h
		mov	ah, 3Eh
		int	21h
@06:		xor	al, al
		jmp	@02
@03:		mov	ah, 9
		int	21h
		mov	al, 1
		jmp	@09
@02:		xor	al, al
@09:		push	ax
		call	ClrLine
		pop	ax
		mov	ah, 4Ch
		int	21h

BlockRead:	push	ds
		push	dx
		mov	ds, ax
		xor	dx, dx
		mov	ah, 3Fh
		int	21h
		pop	dx
		pop	ds
		retn

ClrLine:	mov	dl, 13
		mov	ah, 2
		int	21h
		mov	cx, 79
		mov	dl, ' '
@01_ClrLine:	int	21h
		loop	@01_ClrLine
		mov	dl, 13
		mov	ah, 2
		int	21h
		retn

StrCopy:	mov	dx, cx
StrPartCopy:	cld
		pushf
		or	di, di
		jne	@04_StrCopy
		popf
		retn
@04_StrCopy:	or	cx, cx
		je	@01_StrCopy
@02_StrCopy:	or	dx, dx
		je	@01_StrCopy
		lodsb
		or	al, al
		je	@01_StrCopy
		stosb
		dec	dx
		loop	@02_StrCopy
@01_StrCopy:	xor	al, al
		popf
		jnc	@03_StrCopy
		stosb
@03_StrCopy:	retn

StrLen:		cld
		push	si
		xor	ah, ah
@02_StrLen:	lodsb
		or	al, al
		je	@01_StrLen
		inc	ah
		or	ah, ah
		jne	@02_StrLen
@01_StrLen:	pop	si
		mov	al, ah
		xor	ah, ah
		retn

PrintStr:	push	si
		push	bx
		push	cx
		pushf
		mov	si, dx
		mov	bx, 1
		call	StrLen
		or	ax, ax
		je	@01_PrintStr
		mov	cx, ax
		mov	ah, 40h
		int	21h
@01_PrintStr:	popf
		jnc	@02_PrintStr
		mov	dx, Offset LineFeed
		mov	cx, 2
		mov	ah, 40h
		int	21h
@02_PrintStr:	pop	cx
		pop	bx
		pop	si
		retn

ParamStr:	mov	si, 0081h
		xor	bh, bh
@01_ParamStr:	lodsb
		cmp	al, 13
		je	@02_ParamStr
		cmp	al, ' '
		je	@01_ParamStr
		cmp	al, 9
		je	@01_ParamStr
		inc	bh
		cmp	bl, bh
		je	@03_ParamStr
@04_ParamStr:	cmp	al, 13
		je	@02_ParamStr
		cmp	al, ' '
		je	@01_ParamStr
		cmp	al, 9
		je	@01_ParamStr
		lodsb
		jmp	@04_ParamStr
@03_ParamStr:	or	di, di
		je	@05_ParamStr
@06_ParamStr:	cmp	al, 13
		je	@02_ParamStr
		cmp	al, ' '
		je	@02_ParamStr
		cmp	al, 9
		je	@02_ParamStr
		call	UpCase
		stosb
		lodsb
		loop	@06_ParamStr
@02_ParamStr:	xor	al, al
		stosb
@05_ParamStr:	retn

UpCase:		cmp	al, 'a'
		jb	@01_UpCase
		cmp	al, 'z'
		ja	@01_UpCase
		sub	al, 'a' - 'A'
@01_UpCase:	retn

Hello		db	'File Patch by Joe Forster/STA', 13, 10, 13, 10, '$'
Usage		db	'This program changes files using the patches created by MAKPATCH.', 13, 10, 13, 10
		db	'Usage: PATCH <original-file> [<patch-file>]', 13, 10, '$'
NotFound	db	' not found', 13, 10, '$'
InvalidSize	db	' has an invalid size', 13, 10, '$'
NoMemory	db	'Out of memory', 13, 10, '$'
Patching	db	'Patching $'
LineFeed	db	13, 10
DefPatchName	db	'PATCH.DAT', 0

DataStart:

Time		dw	?
Date		dw	?
PatchFile	dw	?
OrigLen		dd	?
PatchLen	dw	?
Buffer		dw	?
Par		db	79 + 1 dup (?)
PatchName	db	79 + 1 dup (?)

DataEnd:

CSeg		ends

		end	Main
