{
Ŀ
                 Joe Forster/STA                 
                                                 
                     QPAK.PAS                    
                                                 
                Quake PAK archiver               

}

uses
  DOS;

const
  fmReadOnly    = 0;
  fmWriteOnly   = 1;
  fmReadWrite   = 2;
  ArcEntryMaxLen= 256;
  TBufferSize   = $FE00;
  QuakeSign     = $4B434150;
  SinSign       = $4B415053;

type
  ExtFile       = record
    Orig        : file;
    LongName    : string;
  end;
  PExtFile      = ^ExtFile;
  TBuffer       = array [0..TBufferSize - 1] of Byte;
  PBuffer       = ^TBuffer;
  ExtSearchRec  = record
    Orig        : SearchRec;
    HandleUsed  : Boolean;
    LongHandle  : Word;
    LongName    : string;
  end;
  LongSearchRec = record
    Attr        : Longint;
    Dummy1      : array [1..16] of Byte;
    Time        : Longint;
    Dummy2      : array [1..8] of Byte;
    Size        : Longint;
    Dummy3      : array [1..8] of Byte;
    LongName    : array [1..260] of Byte;
    ShortName   : array [1..14] of Byte;
  end;

var
  List,
  Quit          : Boolean;
  Command       : Char;
  ArcEntryLen,
  Index,
  FileNum       : Word;
  IOError       : Integer;
  Signature,
  ArcSign,
  ArcPos,
  BinSize,
  ArcDirPos,
  ArcDirLen,
  ArcTime,
  TotalSize     : Longint;
  ArcName,
  EntryName,
  BinName,
  BinPath,
  DirName,
  ListName      : string;
  ArcFile,
  BinFile,
  ListFile      : ExtFile;
  ArcEntry      : array [0..ArcEntryMaxLen - 1] of Byte;

function UpperCase(const S: string): string;
var
  I             : Integer;
  T             : string;
begin
  T[0] := Chr(Length(S));
  for I := 1 to Length(S) do T[I] := UpCase(S[I]);
  UpperCase := T;
end;

function ASCIIZtoStr(const Str): string; assembler;
asm
    les di, Str;
    mov si, di;
    mov cx, 255;
    xor al, al;
    cld;
    repne scasb;
    mov cx, di;
    sub cx, si;
    dec cx;
    push ds;
    push es;
    pop ds;
    les di, @Result;
    mov al, cl;
    stosb;
    rep movsb;
    pop ds;
end;

procedure ExecLFN; assembler;
asm
    mov ah, $71;
    stc;
    int $21;
    jc @1;
    cmp ax, $7100;
    stc;
    je @1;
    clc;
@1:
end;

function InitLongNames: Boolean; assembler;
var
  S,
  T             : string;
asm
    push ds;
    push ss;
    pop ds;
    push ss;
    pop es;
    lea si, S;
    mov byte ptr [si], 0;
    lea di, T;
    xor cl, cl;
    mov ch, $80;
    mov al, $60;
    call ExecLFN;
    mov bx, ax;
    pop ds;
    mov al, True;
    jnc @1;
    cmp bx, $7100;
    jne @1;
    mov al, False;
@1:
end;

function LongParamStr(Index: Byte): string; assembler;
asm
    push ds;
    mov dl, Index;
    or dl, dl;
    je @12;
    xor dh, dh;
    mov ax, PrefixSeg;
    mov ds, ax;
    mov di, $0080;
    mov cl, [di];
    xor ch, ch;
    inc di;
    xor bx, bx;
    xor ah, ah;
@1: jcxz @3;
@2: mov al, [di];
    cmp al, '"';
    jne @7;
    xor ah, 1;
    inc di;
    dec cx;
    jmp @3;
@7: cmp al, ' ';
    ja @3;
    inc di;
    loop @2;
@3: mov si, di;
    jcxz @5;
@4: mov al, [di];
    cmp al, '"';
    jne @8;
    xor ah, 1;
@8: cmp al, ' ';
    ja @9;
    or ah, ah;
    je @5;
@9: inc di;
    loop @4;
@5: mov ax, di;
    sub ax, si;
    je @6;
    inc bx;
    dec dx;
    jnz @1;
@6: les di, @Result;
    mov bx, di;
    inc di;
    xor dl, dl;
    mov cx, ax;
    jcxz @12;
@11:lodsb;
    cmp al, '"';
    je @10;
    stosb;
    inc dl;
@10:loop @11;
@12:mov es:[bx], dl;
    pop ds;
end;

function LongOpenFile(Name: string; var F: ExtFile; Mode: Byte): Integer;
var
  B             : Byte;
  W             : Word;
  I             : Integer;
begin
  F.LongName := Name;
  B := 0;
  case Mode of
    fmReadOnly: B := $40;
    fmReadWrite, fmWriteOnly: B := $20;
  end;
  FileMode := Mode or B;
  asm
    mov W, 0;
    push ds;
    mov al, FileMode;
    xor ah, ah;
    push ax;
    push ss;
    pop ds;
    lea si, Name;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    xor di, di;
    mov dx, $01;
    mov bl, al;
    and bl, $0F;
    cmp bl, fmWriteOnly;
    jne @1;
    mov dx, $11;
@1: mov bl, al;
    mov al, $6C;
    xor cx, cx;
    call ExecLFN;
    pop bx;
    jnc @2;
    cmp ax, 5;
    jne @4;
    and bl, $0F;
    mov al, $6C;
    xor cx, cx;
    call ExecLFN;
    jnc @2;
@4: pop ds;
    mov W, ax;
    xor ax, ax;
    jmp @3;
@2: pop ds;
    les di, F;
    mov es:[di].ExtFile.Orig.FileRec.Mode, fmInOut;
    mov es:[di].ExtFile.Orig.FileRec.RecSize, 1;
@3: mov es:[di].ExtFile.Orig.FileRec.Handle, ax;
  end;
  LongOpenFile := W;
end;

procedure LongMkDir(Name: string);
begin
  asm
    push ds;
    push ss
    pop ds;
    lea si, Name;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    mov dx, si;
    mov al, $39;
    call ExecLFN;
    jc @1;
    xor ax, ax;
@1: pop ds;
    mov InOutRes, ax;
  end;
end;

procedure LongErase(Name: string);
begin
  asm
    push ds;
    push ss;
    pop ds;
    lea si, Name;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    mov dx, si;
    xor si, si;
    mov al, $41;
    call ExecLFN;
    jc @1;
    xor ax, ax;
@1: pop ds;
    mov InOutRes, ax;
  end;
end;

procedure FixSearchResult(const E: LongSearchRec; var F: ExtSearchRec; B: Byte);
begin
  F.Orig.Attr := E.Attr;
  F.Orig.Time := E.Time;
  F.Orig.Size := E.Size;
  F.LongName[0] := Chr(B);
  Move(E.LongName, F.LongName[1], B);
end;

procedure LongFindFirst(Path: string; Attr: Byte; var F: ExtSearchRec);
var
  B             : Byte;
  W             : Word;
  E             : LongSearchRec;
begin
  asm
    mov DOSError, 0;
    push ds;
    push ss;
    pop ds;
    push ss;
    pop es;
    lea si, Path;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    lea di, E;
    mov dx, si;
    mov cl, Attr;
    xor ch, ch;
    mov si, 1;
    mov al, $4E;
    call ExecLFN;
    pop ds;
    jc @1;
    mov W, ax;
    xor al, al;
    add di, LongSearchRec.LongName;
    mov bx, di;
    mov cx, 255;
    cld;
    repne scasb;
    sub bx, di;
    neg bx;
    dec bx;
    mov byte ptr B, bl;
    jmp @2;
@1: mov DOSError, ax;
@2:
  end;
  if DOSError = 0 then
  begin
    F.HandleUsed := True;
    F.LongHandle := W;
  end;
  FixSearchResult(E, F, B);
end;

{Find next instance of a file in a directory
  Input : F: record to read data from and store result into}
procedure LongFindNext(var F: ExtSearchRec);
var
  B             : Byte;
  E             : LongSearchRec;
begin
  asm
    mov DOSError, 0;
    les di, F;
    mov bx, es:[di].ExtSearchRec.LongHandle;
    push ss;
    pop es;
    lea di, E;
    mov si, 1;
    mov al, $4F;
    call ExecLFN;
    jc @1;
    xor al, al;
    add di, LongSearchRec.LongName;
    mov bx, di;
    mov cx, 255;
    cld;
    repne scasb;
    sub bx, di;
    neg bx;
    dec bx;
    mov byte ptr B, bl;
    jmp @2;
@1: mov DOSError, ax;
@2:
  end;
  FixSearchResult(E, F, B);
end;

procedure LongFindClose(var F: ExtSearchRec); assembler;
asm
    les di, F;
    mov byte ptr es:[di].ExtSearchRec.HandleUsed, 0;
    mov bx, es:[di].ExtSearchRec.LongHandle;
    mov al, $A1;
    call ExecLFN;
end;

function RightPos(C: Char; const S: string): Byte; assembler;
asm
    les di, S;
    mov al, es:[di];
    mov cl, al;
    xor ch, ch;
    jcxz @1;
    add di, cx;
    mov al, C;
    std;
    repne scasb;
    jne @1;
    inc cx;
@1: mov ax, cx;
end;

function AddToPath(const P, S: string; C: Char): string;
var
  T             : string;
begin
  if P = '' then
  begin
    AddToPath := S;
  end
  else
  begin
    T := P;
    if not (T[Length(T)] in [C, ':']) then T := T + C;
    AddToPath := T + S;
  end;
end;

function CutPath(const S: string; C: Char): string;
var
  B             : Word;
begin
  B := RightPos(C, S);
  if (B = 0) and (Length(S) >= 2) and (S[2] = ':') then B := 2;
  CutPath := Copy(S, B + 1, 255);
end;

function GetPath(const S: string; C: Char): string;
var
  B             : Word;
  T             : string;
begin
  B := RightPos(C, S);
  if (B = 0) and (Length(S) >= 2) and (S[2] = ':') then B := 2;
  if (B >= 2) and (S[B] = C) and (S[B - 1] <> ':') then Dec(B);
  T := Copy(S, 1, B);
  GetPath := T;
end;

procedure ExtBlockRead(var F: ExtFile; var Buf; Count: Word);
begin
  BlockRead(F.Orig, Buf, Count);
end;

procedure ExtBlockWrite(var F: ExtFile; var Buf; Count: Word);
begin
  BlockWrite(F.Orig, Buf, Count);
end;

procedure ExtClose(var F: ExtFile);
begin
  Close(F.Orig);
end;

function ExtFileSize(var F: ExtFile): Longint;
begin
  ExtFileSize := FileSize(F.Orig);
end;

procedure ExtSeek(var F: ExtFile; Pos: Longint);
begin
  Seek(F.Orig, Pos);
end;

procedure ExtGetFTime(var F: ExtFile; var Time: Longint);
begin
  GetFTime(F.Orig, Time);
end;

procedure ExtSetFTime(var F: ExtFile; Time: Longint);
begin
  SetFTime(F.Orig, Time);
end;

procedure CopyPart(var FromFile, ToFile: ExtFile; L: Longint);
var
  N             : Longint;
  P             : PBuffer;
begin
  if L > 0 then
  begin
    P := New(PBuffer);
    while L > 0 do
    begin
      if L > TBufferSize then N := TBufferSize else N := L;
      Dec(L, N);
      ExtBlockRead(FromFile, P^, N);
      ExtBlockWrite(ToFile, P^, N);
    end;
    Dispose(P);
  end;
end;

procedure PrintTotal;
begin
  WriteLn;
  WriteLn('Processed ', FileNum, ' files, ', TotalSize, ' bytes');
end;

procedure WriteArcHeader;
begin
  ArcSign := Signature;
  ExtSeek(ArcFile, 0);
  ExtBlockWrite(ArcFile, ArcSign, 4);
  ExtBlockWrite(ArcFile, ArcDirPos, 4);
  ExtBlockWrite(ArcFile, ArcDirLen, 4);
  ArcPos := 12;
end;

procedure ProcessDir(Path, ArcPath: string);
var
  Entry         : ExtSearchRec;
begin
  LongFindFirst(AddToPath(Path, '*.*', '\'), AnyFile - Directory, Entry);
  if DOSError = 0 then
  begin
    repeat
      EntryName := AddToPath(ArcPath, Entry.LongName, '/');
      FillChar(ArcEntry, ArcEntryMaxLen, 0);
      Move(EntryName[1], ArcEntry[0], Length(EntryName));
      BinName := AddToPath(Path, Entry.LongName, '\');
      if LongOpenFile(BinName, BinFile, fmReadOnly) = 0 then
      begin
        WriteLn('Adding ', EntryName);
        BinSize := ExtFileSize(BinFile);
        Move(ArcPos, ArcEntry[ArcEntryLen - 8], 4);
        Move(BinSize, ArcEntry[ArcEntryLen - 4], 4);
        ExtBlockWrite(ListFile, ArcEntry, ArcEntryLen);
        CopyPart(BinFile, ArcFile, BinSize);
        ExtClose(BinFile);
        Inc(FileNum);
        Inc(ArcPos, BinSize);
        Inc(TotalSize, BinSize);
      end;
      LongFindNext(Entry);
    until DOSError <> 0;
    LongFindClose(Entry);
  end;
  LongFindFirst(AddToPath(Path, '*.*', '\'), AnyFile, Entry);
  if DOSError = 0 then
  begin
    repeat
      if (Entry.Orig.Attr and Directory > 0) and (Entry.LongName <> '.') and (Entry.LongName <> '..') then
        ProcessDir(AddToPath(Path, Entry.LongName, '\'), AddToPath(ArcPath, Entry.LongName, '/'));
      LongFindNext(Entry);
    until DOSError <> 0;
    LongFindClose(Entry);
  end;
end;

procedure GetArcEntryLen;
begin
  ArcEntryLen := 0;
  if ArcSign = QuakeSign then ArcEntryLen := $40;
  if ArcSign = SinSign then ArcEntryLen := $80;
  if ArcEntryLen = 0 then WriteLn('Unknown archive type');
end;

begin
  WriteLn('Quake PAK archiver by Joe Forster/STA');
  WriteLn;
  if ParamCount < 2 then
  begin
    WriteLn('This program creates, lists and extracts Quake-style PAK archives.');
    WriteLn;
    WriteLn('Add:     QPAK A <archive> <source-dir> [[-|/]QUAKE|SIN]');
    WriteLn('List:    QPAK L <archive>');
    WriteLn('Extract: QPAK X <archive> <destination-dir>');
  end
  else
  begin
    if InitLongNames then
    begin
      BinName := LongParamStr(1);
      ArcName := LongParamStr(2);
      BinPath := LongParamStr(3);
      Command := UpCase(BinName[1]);
      case Command of
        'A':
        begin
          Signature := QuakeSign;
          if ParamCount > 3 then
          begin
            BinName := UpperCase(ParamStr(4));
            if BinName[1] in ['-', '/'] then BinName := Copy(BinName, 2, 255);
            if BinName = 'QUAKE' then
            else if BinName = 'SIN' then
              Signature := SinSign
            else
              Signature := 0;
          end;
          ArcSign := Signature;
          GetArcEntryLen;
          if ArcEntryLen > 0 then
          begin
            ListName := ArcName + '.lst';
            if LongOpenFile(ArcName, ArcFile, fmWriteOnly) = 0 then
            begin
              if LongOpenFile(ListName, ListFile, fmWriteOnly) = 0 then
              begin
                WriteLn('Processing archive: ', ArcName, '...');
                WriteLn;
                WriteArcHeader;
                ProcessDir(BinPath, '');
                ExtClose(ListFile);
                if LongOpenFile(ListName, ListFile, fmReadOnly) = 0 then
                begin
                  ArcDirPos := ArcPos;
                  ArcDirLen := ExtFileSize(ListFile);
                  CopyPart(ListFile, ArcFile, ArcDirLen);
                  WriteArcHeader;
                  ExtClose(ListFile);
                end;
                LongErase(ListName);
              end;
              ExtClose(ArcFile);
              PrintTotal;
            end
            else
            begin
              WriteLn('Cannot create archive');
            end;
          end;
        end;
        'L', 'X':
        begin
          List := (Command = 'L');
          if LongOpenFile(ArcName, ArcFile, fmReadOnly) = 0 then
          begin
            WriteLn('Processing archive: ', ArcName, '...');
            WriteLn;
            ExtBlockRead(ArcFile, ArcSign, 4);
            GetArcEntryLen;
            if ArcEntryLen > 0 then
            begin
              ExtGetFTime(ArcFile, ArcTime);
              ExtBlockRead(ArcFile, ArcDirPos, 4);
              ExtBlockRead(ArcFile, ArcDirLen, 4);
              ExtSeek(ArcFile, ArcDirPos);
              FileNum := 0;
              while ArcDirLen > 0 do
              begin
                ExtSeek(ArcFile, ArcDirPos);
                ExtBlockRead(ArcFile, ArcEntry, ArcEntryLen);
                EntryName := ASCIIZtoStr(ArcEntry[0]);
                Move(ArcEntry[ArcEntryLen - 8], ArcPos, 4);
                Move(ArcEntry[ArcEntryLen - 4], BinSize, 4);
                if List then
                begin
                  WriteLn(EntryName);
                end
                else
                begin
                  WriteLn('Extracting ', EntryName);
                  BinName[0] := Chr(Length(EntryName));
                  for Index := 1 to Length(BinName) do if EntryName[Index] = '/' then BinName[Index] := '\' else
                    BinName[Index] := EntryName[Index];
                  Quit := False;
                  repeat
                    IOError := LongOpenFile(AddToPath(BinPath, BinName, '\'), BinFile, fmWriteOnly);
                    if IOError = 3 then
                    begin
                      DirName := BinName;
                      repeat
                        DirName := GetPath(DirName, '\');
                        LongMkDir(AddToPath(BinPath, DirName, '\'));
                        IOError := IOResult;
                      until (IOError = 0) or (DirName = '');
                    end
                    else
                    begin
                      Quit := True;
                    end;
                  until Quit;
                  if IOError = 0 then
                  begin
                    ExtSeek(ArcFile, ArcPos);
                    CopyPart(ArcFile, BinFile, BinSize);
                    ExtSetFTime(BinFile, ArcTime);
                    ExtClose(BinFile);
                  end;
                  InOutRes := 0;
                end;
                Inc(FileNum);
                Inc(ArcDirPos, ArcEntryLen);
                Inc(TotalSize, BinSize);
                if ArcDirLen > ArcEntryLen then Dec(ArcDirLen, ArcEntryLen) else ArcDirLen := 0;
              end;
              PrintTotal;
            end;
          end
          else
          begin
            WriteLn('Cannot open archive');
          end;
        end;
      else
        WriteLn('Invalid command');
      end;
    end
    else
    begin
      WriteLn('Long filenames are not available');
    end;
  end;
end.
