
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Turbo Vision Unit                               }
{                                                       }
{       Copyright (c) 1992 Borland International        }
{                                                       }
{*******************************************************}

unit App;

{$A+,B-,D+,E-,F+,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Dialogs, Drivers, Memory, Menus, Objects, Views;

const
{Application palettes}
  apBlackWhite  = 0;
  apColor       = 1;
  apLaptop      = 2;
  apMonochrome  = 3;
  apAuto        = 255;

const

{ TApplication palettes }

  CAppBlackWhite =
        #$07#$70#$0F#$7F#$0F#$07#$70#$70#$0F#$70#$70#$7F#$07#$0F#$70 +
    #$70#$07#$0F#$70#$0F#$07#$0F#$70#$0F#$70#$07#$07#$0F#$70#$0F#$07 +
    #$0F#$70#$0F#$70#$0F#$07#$0F#$00#$01;

  CAppColor =
        #$1B#$30#$1E#$3E#$1E#$07#$30#$30#$0F#$30#$3F#$3E#$0F#$0E#$30 +
    #$33#$70#$7E#$30#$0F#$3F#$3E#$0F#$70#$3F#$0F#$30#$3F#$0F#$3E#$4F +
    #$4E#$70#$0F#$30#$1E#$0B#$0F#$00#$01;

  CAppLaptop =
        #$07#$70#$0F#$70#$0F#$07#$70#$70#$0F#$70#$70#$70#$0F#$0F#$70 +
    #$70#$07#$0F#$70#$0F#$07#$0F#$70#$0F#$70#$07#$07#$0F#$70#$0F#$07 +
    #$0F#$70#$0F#$70#$0F#$07#$0F#$00#$00;

  CAppMonochrome =
        #$07#$70#$0F#$09#$0F#$07#$70#$70#$0F#$70#$70#$70#$0F#$0F#$70 +
    #$70#$07#$0F#$70#$0F#$07#$0F#$70#$0F#$70#$07#$07#$0F#$70#$09#$07 +
    #$0F#$70#$0F#$70#$0F#$07#$0F#$00#$00;

  CDefApplication: array[apBlackWhite..apMonoChrome] of TPalette =
    (CAppBlackWhite, CAppColor, CAppLaptop, CAppMonoChrome);

  CApplication: array[apBlackWhite..apMonoChrome] of TPalette =
    (CAppBlackWhite, CAppColor, CAppLaptop, CAppMonoChrome);

  CShadow     = PaletteLen;

type

{ TBackground object }

  PBackground = ^TBackground;
  TBackground = object(TView)
    constructor Init(var Bounds: TRect);
    procedure Draw; virtual;
  end;

{ TProgram object }

  PProgram = ^TProgram;
  TProgram = object(TGroup)
    constructor Init;
    destructor Done; virtual;
    procedure GetEvent(var Event: TEvent); virtual;
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Idle; virtual;
    procedure InitBackground; virtual;
    procedure InitMenuBar; virtual;
    procedure InitScreen; virtual;
    procedure InitKeyBar; virtual;
    procedure PutEvent(var Event: TEvent); virtual;
    procedure Run; virtual;
    procedure SetCharSet(Mode: Byte; On, Force: Boolean); virtual;
    procedure SetScreenMode(Mode: Word);
  end;

{ TApplication object }

  PApplication = ^TApplication;
  TApplication = object(TProgram)
    constructor Init;
    destructor Done; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
  end;

const

{ Public variables }

  Application: PApplication = nil;
  Background: PBackground = nil;
  KeyBar: PKeyBar = nil;
  MenuBar: PMenuView = nil;
  PriorityMenu: PDialog = nil;
  AppPalette: Integer = apColor;
  Monochrome: Boolean = False;

var
  SaverInUse: Boolean;
  ScreenCol, CharStartMode, CharSetMode: Byte;

implementation

uses DOS;

const

{ Private variables }

  Pending: TEvent = (What: evNothing);

{ TBackground }

constructor TBackground.Init(var Bounds: TRect);
begin
  TView.Init(Bounds);
  GrowMode := gfGrowHiX + gfGrowHiY;
end;

procedure TBackground.Draw;
var
  B: TDrawBuffer;
  I: Integer;
begin
  for I := 0 to Size.Y do
  begin
    Move(BackBuffer[I * 2 * ScreenWidth], B, 2 * ScreenWidth);
    WriteBuf(0, I, Size.X, 1, B);
  end;
end;

{ TProgram }

constructor TProgram.Init;
var
  R: TRect;
begin
  Application := @Self;
  InitScreen;
  R.Assign(0, 0, ScreenWidth, ScreenHeight);
  TGroup.Init(R);
  InitOperatingSystem;
  State := sfVisible + sfSelected + sfFocused + sfModal + sfExposed;
  Options := 0;
  Buffer := ScreenBuffer;
  InitBackground;
  InitMenuBar;
  InitKeyBar;
  if Background <> nil then Insert(Background);
  if BatchMode <> bmNone then
  begin
    MenuBar^.Hide;
    KeyBar^.Hide;
  end;
  if MenuBar <> nil then Insert(MenuBar);
  if KeyBar <> nil then
  begin
    KeyBar^.Update;
    Insert(KeyBar);
  end;
end;

destructor TProgram.Done;
begin
  if MenuBar <> nil then Dispose(MenuBar, Done);
  if KeyBar <> nil then Dispose(KeyBar, Done);
  if Background <> nil then Dispose(Background, Done);
  Application := nil;
  inherited Done;
end;

procedure TProgram.GetEvent(var Event: TEvent);
var
  R: TRect;

function ContainsMouse(P: PView): Boolean; far;
begin
  ContainsMouse := (P^.State and sfVisible <> 0) and
    P^.MouseInView(Event.Where);
end;

begin
  if Pending.What <> evNothing then
  begin
    Event := Pending;
    Pending.What := evNothing;
  end else
  begin
    GetMouseEvent(Event);
    if MouseWheelCount <> 0 then
    begin
      Event.What := evKeyDown;
      if (MouseWheelCount < 0) then
      begin
        Inc(MouseWheelCount);
        Event.KeyCode := kbUp;
      end
      else
      begin
        Dec(MouseWheelCount);
        Event.KeyCode := kbDown;
      end;
    end;
(* DEBUG
    if (Event.What and evMouse > 0) and (Event.Buttons and mbMiddleButton > 0) then
    begin
      MouseButtons := 0;
      Event.What := evKeyDown;
      Event.KeyCode := kbEnter;
    end;
   DEBUG *)
    if Event.What = evNothing then
    begin
      GetKeyEvent(Event);
      if Event.What = evNothing then Idle;
    end;
  end;
  if not SaverInUse and (PriorityMenu <> nil) and (Event.What and evKeyDown <> 0) then
    PriorityMenu^.HandleEvent(Event);
  if KeyBar <> nil then
    if (Event.What and evKeyDown <> 0) or
      (Event.What and evMouseDown <> 0) and
      (FirstThat(@ContainsMouse) = PView(KeyBar)) then
      KeyBar^.HandleEvent(Event);
end;

function TProgram.GetPalette: PPalette;
begin
  GetPalette := @CApplication[AppPalette];
end;

procedure TProgram.HandleEvent(var Event: TEvent);
begin
  TGroup.HandleEvent(Event);
  if Event.What = evCommand then
    if Event.Command = cmQuit then
    begin
      EndModal(cmQuit);
      ClearEvent(Event);
    end;
end;

procedure TProgram.Idle;
begin
  if KeyBar <> nil then KeyBar^.Update;
  if CommandSetChanged then
  begin
    Message(@Self, evBroadcast, cmCommandSetChanged);
    CommandSetChanged := False;
  end;
  GiveUpTimeSlice;
end;

procedure TProgram.InitBackground;
var
  R: TRect;
begin
  GetExtent(R);
  Background := New(PBackground, Init(R));
end;

procedure TProgram.InitMenuBar;
begin
  MenuBar := nil;
end;

procedure TProgram.InitScreen;
var
  C: Char;
begin
  AppPalette := ScreenCol;
  Laptop := (ScreenCol = apLaptop);
  if not Laptop and (Lo(ScreenMode) = smMono) then AppPalette := apMonochrome;
  Monochrome := (ScreenMode = smMono);
  C := GetPalette^[CShadow];
  if Ord(C) = shNone then
  begin
    ShadowSize.X := 0;
    ShadowSize.Y := 0;
  end
  else
  begin
    if ScreenWidth > ScreenHeight shl 1 then ShadowSize.X := 2
      else ShadowSize.X := 1;
    ShadowSize.Y := 1;
    if Ord(C) = shLowBrightness then
    begin
      ShadowANDAttr := DefShadowANDAttr;
      ShadowORAttr := DefShadowORAttr;
    end
    else
    begin
      ShadowANDAttr := 0;
      ShadowORAttr := DefShadowAttr;
    end;
  end;
  SetCharSet(CharStartMode, True, False);
end;

procedure TProgram.InitKeyBar;
begin
end;

procedure TProgram.PutEvent(var Event: TEvent);
begin
  Pending := Event;
end;

procedure TProgram.Run;
begin
  Execute;
end;

procedure TProgram.SetCharSet(Mode: Byte; On, Force: Boolean);
begin
  SetBlinkBright((Ord(GetPalette^[PaletteLen - 1]) > 0));
end;

procedure TProgram.SetScreenMode(Mode: Word);
var
  R: TRect;
begin
  MouseInit.X := MouseWhere.X shl 3;
  MouseInit.Y := MouseWhere.Y shl 3;
  HideMouse;
  SetVideoMode(Mode);
  DoneMemory;
  InitMemory;
  InitScreen;
  SetCharSet(CharStartMode, True, False);
  Buffer := ScreenBuffer;
  R.Assign(0, 0, ScreenWidth, ScreenHeight);
  ChangeBounds(R);
  InitMousePosition;
  MouseScreenMask := DefMouseScreenMask;
  MouseCursorMask := DefMouseCursorMask;
  ShowMouse;
end;

{ TApplication }

constructor TApplication.Init;
begin
  InitMemory;
  InitVideo;
  InitMousePosition;
  InitEvents;
  InitCtrlBreak;
  InitSysError;
  TProgram.Init;
  SetCharSet(CharStartMode, True, False);
end;

destructor TApplication.Done;
begin
  TProgram.Done;
  DoneSysError;
  DoneCtrlBreak;
  DoneEvents;
  DoneVideo;
  DoneMemory;
end;

procedure TApplication.HandleEvent(var Event: TEvent);
begin
  inherited HandleEvent(Event);
  case Event.What of
    evCommand: ClearEvent(Event);
  end;
end;

end.
