
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                   APPFUNC.PAS                   }
{                                                 }
{  The Star Commander application functions unit  }
{*************************************************}

unit AppFunc;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Views;

procedure SetCharSet(Mode: Byte; On, Force: Boolean; Palette: PPalette);
procedure InitMenuBar;
procedure InitKeyBar;

implementation

uses
  App, Drivers, Menus, Objects,
  Base2, Constant, Disked, LowLevel;

{Change the character set to IBM or C64
  Input : Mode: character set to change to
          On: when True, store code of specified character set
          Force: when True, force changing to the specified character set
          Palette: the color palette of the application}
procedure SetCharSet(Mode: Byte; On, Force: Boolean; Palette: PPalette);
var
  B             : Byte;
begin
  GetMouse(False);
  if On and (Mode >= csCBMLower) then
  begin
    if HiResScreen then
    begin
      if Force or (CharSetMode <= csIBMUpper) then
      begin
        asm
          push ds;
          push bp;
          mov ax, Seg0040;
          mov es, ax;
          mov dl, es:[$0085];
          cmp dl, 16;
          jne @4;
          mov bp, Offset(AltCharBuffer);
          mov ax, Seg(AltCharBuffer);
          jmp @5;
      @4: xor dh, dh;
          mov cx, dx;
          xor di, di;
      @1: mov ax, di;
          shl ax, 3;
          div dl;
          mov byte ptr TimeStr[di], al;
          inc di;
          loop @1;
          mov si, Offset(CharBuffer);
          push ds;
          pop es;
          mov ax, Seg(CharBuffer);
          mov ds, ax;
          xor ah, ah;
          mov al, dl;
          xor bh, bh;
          xor bp, bp;
          mov cx, $0100;
      @3: xor di, di;
      @2: mov bl, byte ptr es:TimeStr[di];
          mov dh, [si][bx];
          mov byte ptr es:GCRBuffer[di][bp], dh;
          inc di;
          cmp di, ax;
          jb @2;
          add si, 8;
          add bp, ax;
          loop @3;
          mov bp, Offset(GCRBuffer);
          mov ax, Seg(GCRBuffer);
      @5: mov es, ax;
          mov bh, dl;
          xor bl, bl;
          mov cx, $0100;
          xor dx, dx;
          mov ax, $1100;
          call VideoInt;
          pop bp;
          pop ds;
          cmp EightColFont, False;
          je @6;
          cli;
          mov dx, $03CC;
          in al, dx;
          and al, $F3;
          mov dx, $03C2;
          out dx, al;
          mov dx, $03C4;
          mov al, $01;
          out dx, al;
          inc dx;
          in al, dx;
          mov bh, al;
          or al, $01;
          out dx, al;
          mov dx, $03DA;
          in al, dx;
          mov dx, $03C0;
          mov al, $13;
          out dx, al;
          mov al, $00;
          out dx, al;
          mov al, $20;
          out dx, al;
          sti;
      @6:
        end;
        SetBlinkBright(True);
      end;
      CharSetMode := Mode;
    end
    else
    begin
      CharStartMode := CharStartMode and csLowerUpper;
    end;
  end
  else
  begin
    B := Ord(Palette^[PaletteLen - 1]);
    if CharSetMode > csIBMUpper then
    begin
      if EightColFont then
      begin
        SetVideoMode(ScreenMode);
      end
      else
      begin
        asm
          mov ax, $0040;
          mov es, ax;
          mov dl, es:[$0085];
          mov bh, 2;
          cmp dl, 14;
          je @1;
          mov bh, 3;
          cmp dl, 8;
          je @1;
          mov bh, 6;
          cmp dl, 16;
          jne @2;
      @1: push bp;
          push dx;
          push bx;
          mov ax, $1130;
          int $10;
          pop bx;
          cmp bh, 6;
          jne @3;
          push ds;
          push es;
          pop ds;
          pop es;
          push es;
          mov si, bp;
          mov di, Offset(GCRBuffer);
          mov cx, $1000;
          cld;
          rep movsw;
          pop ds;
      @4: push ds;
          pop es;
          mov bp, Offset(GCRBuffer);
      @3: pop dx;
          mov bh, dl;
          xor bl, bl;
          mov cx, $0100;
          xor dx, dx;
          mov ax, $1100;
          call VideoInt;
          pop bp;
      @2:
        end;
      end;
    end;
    SetBlinkBright(B > 0);
    if On then CharSetMode := Mode;
  end;
  SetMouse;
  FrameChars := DefFrameChars;
  MenuFrameChars := DefMenuFrameChars;
  if (CharSetMode >= csCBMLower) or (CodePage = CodePageUS) then
  begin
    DoubleFrameChars := DefDoubleFrameChars;
    CheckedChar := DefCheckedChar;
    DotChar := DefDotChar;
  end
  else
  begin
    DoubleFrameChars := AltDefDoubleFrameChars;
    CheckedChar := AltDefCheckedChar;
    DotChar := AltDefDotChar;
  end;
end;

{Initialize the menu bar}
procedure InitMenuBar;
var
  P,
  Q             : PMenuItem;
  R             : TRect;
begin
  Application^.GetExtent(R);
  R.B.Y := R.A.Y + 1;
  P := NewLine(
    NewItem('  '+ColorChar+'R'+ColorChar+'e-read', 'Ctrl-R ', kbCtrlR, cmLeftReread, hcReread,
    NewItem('  '+ColorChar+'C'+ColorChar+'olumn mode...', stEmpty, kbNoKey, cmLeftColumn, hcColumn,
    NewItem('  sort ord'+ColorChar+'E'+ColorChar+'r...', stEmpty, kbNoKey, cmLeftSort, hcSort,
    NewItem('  fi'+ColorChar+'L'+ColorChar+'ter...', stEmpty, kbNoKey, cmLeftFilter, hcFilter,
    NewItem('  mini s'+ColorChar+'T'+ColorChar+'atus...', stEmpty, kbNoKey, cmLeftStatus, hcStatus,
    NewItem('  '+ColorChar+'D'+ColorChar+'rive...', 'Alt-F1 ', kbAltF1, cmLeftChange, hcChangeDrive,
    nil)))))));
  P := NewItem('  re'+ColorChar+'V'+ColorChar+'erse', stEmpty, kbNoKey, cmLeftReverse, hcSortOrder, P);
  LeftSortMenu[5] := P;
  P := NewItem('  '+ColorChar+'U'+ColorChar+'nsorted', stEmpty, kbNoKey, cmLeftUnsort, hcSortOrder, P);
  LeftSortMenu[4] := P;
  P := NewItem('  '+ColorChar+'S'+ColorChar+'ize', stEmpty, kbNoKey, cmLeftSize, hcSortOrder, P);
  LeftSortMenu[3] := P;
  P := NewItem('  ti'+ColorChar+'M'+ColorChar+'e', stEmpty, kbNoKey, cmLeftTime, hcSortOrder, P);
  LeftSortMenu[2] := P;
  P := NewItem('  e'+ColorChar+'X'+ColorChar+'tension', stEmpty, kbNoKey, cmLeftExt, hcSortOrder, P);
  LeftSortMenu[1] := P;
  P := NewItem('  '+ColorChar+'N'+ColorChar+'ame', stEmpty, kbNoKey, cmLeftName, hcSortOrder, P);
  LeftSortMenu[0] := P;
  P := NewItem('  '+ColorChar+'O'+ColorChar+'n/Off', 'Ctrl-F1', kbCtrlF1, cmLeftOnOff, hcOnOff,
    NewLine(P));
  P := NewItem('  '+ColorChar+'Q'+ColorChar+'uick view', 'Ctrl-Q ', kbCtrlQ, cmLeftQView, hcQuickView, P);
  LeftModeMenu[4] := P;
  P := NewItem('  '+ColorChar+'I'+ColorChar+'nfo', stEmpty, kbNoKey, cmLeftInfo, hcInfo, P);
  LeftModeMenu[3] := P;
  P := NewItem('  '+ColorChar+'W'+ColorChar+'ide', stEmpty, kbNoKey, cmLeftLong, hcBriefFull, P);
  LeftModeMenu[2] := P;
  P := NewItem('  '+ColorChar+'F'+ColorChar+'ull', stEmpty, kbNoKey, cmLeftFull, hcBriefFull, P);
  LeftModeMenu[1] := P;
  P := NewItem('  '+ColorChar+'B'+ColorChar+'rief', stEmpty, kbNoKey, cmLeftBrief, hcBriefFull, P);
  LeftModeMenu[0] := P;
  Q := NewLine(
    NewItem('  '+ColorChar+'R'+ColorChar+'e-read', 'Ctrl-R ', kbCtrlR, cmRightReread, hcReread,
    NewItem('  '+ColorChar+'C'+ColorChar+'olumn mode...', stEmpty, kbNoKey, cmRightColumn, hcColumn,
    NewItem('  sort ord'+ColorChar+'E'+ColorChar+'r...', stEmpty, kbNoKey, cmRightSort, hcSort,
    NewItem('  fi'+ColorChar+'L'+ColorChar+'ter...', stEmpty, kbNoKey, cmRightFilter, hcFilter,
    NewItem('  mini s'+ColorChar+'T'+ColorChar+'atus...', stEmpty, kbNoKey, cmRightStatus, hcStatus,
    NewItem('  '+ColorChar+'D'+ColorChar+'rive...', 'Alt-F2 ', kbAltF2, cmRightChange, hcChangeDrive,
    nil)))))));
  Q := NewItem('  re'+ColorChar+'V'+ColorChar+'erse', stEmpty, kbNoKey, cmRightReverse, hcSortOrder, Q);
  RightSortMenu[5] := Q;
  Q := NewItem('  '+ColorChar+'U'+ColorChar+'nsorted', stEmpty, kbNoKey, cmRightUnsort, hcSortOrder, Q);
  RightSortMenu[4] := Q;
  Q := NewItem('  '+ColorChar+'S'+ColorChar+'ize', stEmpty, kbNoKey, cmRightSize, hcSortOrder, Q);
  RightSortMenu[3] := Q;
  Q := NewItem('  ti'+ColorChar+'M'+ColorChar+'e', stEmpty, kbNoKey, cmRightTime, hcSortOrder, Q);
  RightSortMenu[2] := Q;
  Q := NewItem('  e'+ColorChar+'X'+ColorChar+'tension', stEmpty, kbNoKey, cmRightExt, hcSortOrder, Q);
  RightSortMenu[1] := Q;
  Q := NewItem('  '+ColorChar+'N'+ColorChar+'ame', stEmpty, kbNoKey, cmRightName, hcSortOrder, Q);
  RightSortMenu[0] := Q;
  Q := NewItem('  '+ColorChar+'O'+ColorChar+'n/Off', 'Ctrl-F2', kbCtrlF2, cmRightOnOff, hcOnOff,
    NewLine(Q));
  Q := NewItem('  '+ColorChar+'Q'+ColorChar+'uick view', 'Ctrl-Q ', kbCtrlQ, cmRightQView, hcQuickView, Q);
  RightModeMenu[4] := Q;
  Q := NewItem('  '+ColorChar+'I'+ColorChar+'nfo', stEmpty, kbNoKey, cmRightInfo, hcInfo, Q);
  RightModeMenu[3] := Q;
  Q := NewItem('  '+ColorChar+'W'+ColorChar+'ide', stEmpty, kbNoKey, cmRightLong, hcBriefFull, Q);
  RightModeMenu[2] := Q;
  Q := NewItem('  '+ColorChar+'F'+ColorChar+'ull', stEmpty, kbNoKey, cmRightFull, hcBriefFull, Q);
  RightModeMenu[1] := Q;
  Q := NewItem('  '+ColorChar+'B'+ColorChar+'rief', stEmpty, kbNoKey, cmRightBrief, hcBriefFull, Q);
  RightModeMenu[0] := Q;
  MClock := NewItem('  c'+ColorChar+'L'+ColorChar+'ock', stEmpty, kbNoKey, cmClock, hcClock,
    NewLine(
    NewItem('  '+ColorChar+'S'+ColorChar+'ave setup', 'Shift-F9', kbShiftF9, cmSaveSetup, hcSaveSetup,
    nil)));
  MFullScreen := NewItem('  '+ColorChar+'F'+ColorChar+'ull screen', stEmpty, kbNoKey, cmFullScreen, hcFullScreen,
    MClock);
  MKeyBar := NewItem('  '+ColorChar+'K'+ColorChar+'ey bar', 'Ctrl-B  ', kbCtrlB, cmKeyBar, hcKeyBar,
    MFullScreen);
  MPathPrompt := NewItem('  '+ColorChar+'P'+ColorChar+'ath prompt', stEmpty, kbNoKey, cmPathPrompt, hcPathPrompt,
    MKeyBar);
  MAutoMenus := NewItem('  '+ColorChar+'A'+ColorChar+'uto menus', stEmpty, kbNoKey, cmAutoMenus, hcAutoMenus,
    MPathPrompt);
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('  '+ColorChar+'L'+ColorChar+'eft  ', hcLeftRight, NewMenu(P),
    NewSubMenu('  '+ColorChar+'F'+ColorChar+'iles  ', hcFiles, NewMenu(
      NewItem(' '+ColorChar+'H'+ColorChar+'elp', 'F1     ', kbNoKey, cmHelp, hcHelp,
      NewItem(' '+ColorChar+'U'+ColorChar+'ser menu', 'F2     ', kbF2, cmUserMenu, hcUserMenu,
      NewItem(' '+ColorChar+'V'+ColorChar+'iew', 'F3     ', kbF3, cmKViewFile, hcViewFile,
      NewItem(' '+ColorChar+'E'+ColorChar+'dit', 'F4     ', kbF4, cmKEditFile, hcEditFile,
      NewItem(' '+ColorChar+'C'+ColorChar+'opy', 'F5     ', kbF5, cmKCopyFile, hcCopyFile,
      NewItem(' '+ColorChar+'R'+ColorChar+'ename or move', 'F6     ', kbF6, cmKRenMovFile, hcRenMovFile,
      NewItem(' '+ColorChar+'M'+ColorChar+'ake directory', 'F7     ', kbF7, cmMakeDir, hcMakeDir,
      NewItem(' '+ColorChar+'D'+ColorChar+'elete', 'F8     ', kbF8, cmKDeleteFile, hcDeleteFile,
      NewLine(
      NewItem(' file '+ColorChar+'A'+ColorChar+'ttributes', 'Ctrl-F7', kbCtrlF7, cmFileAttrib, hcFileAttrib,
      NewItem(' '+ColorChar+'F'+ColorChar+'ile info', stEmpty, kbNoKey, cmFileInfo, hcFileInfo,
      NewItem(' '+ColorChar+'L'+ColorChar+'aunch emulator', stEmpty, kbNoKey, cmLaunchEmu, hcLaunchEmu,
      NewLine(
      NewItem(' select '+ColorChar+'G'+ColorChar+'roup', 'Gray + ', kbGrayPlus, cmSelectFile, hcSelectFile,
      NewItem(' u'+ColorChar+'N'+ColorChar+'select group', 'Gray - ', kbGrayMinus, cmUnselectFile, hcSelectFile,
      NewItem(' '+ColorChar+'I'+ColorChar+'nvert selection', 'Gray * ', kbGrayMul, cmInvertSel, hcSelectFile,
      NewItem(' re'+ColorChar+'S'+ColorChar+'tore selection', 'Ctrl-M ', kbCtrlM, cmRestoreSel, hcSelectFile,
      NewLine(
      NewItem(' '+ColorChar+'Q'+ColorChar+'uit', 'F10   ', kbNoKey, cmQuitProgram, hcQuitProgram,
      nil)))))))))))))))))))),
    NewSubMenu('  '+ColorChar+'C'+ColorChar+'ommands  ', hcCommands, NewMenu(
      NewItem(' make '+ColorChar+'D'+ColorChar+'isk image', 'Shift-F1', kbShiftF1, cmMakeDisk, hcMakeImage,
      NewItem(' make '+ColorChar+'T'+ColorChar+'ape image', 'Shift-F2', kbShiftF2, cmMakeTape, hcMakeImage,
      NewItem(' d'+ColorChar+'I'+ColorChar+'sk editor', ' Ctrl-F3 ', kbCtrlF3, cmDiskEdit, hcDiskEdit,
      NewItem(' volume '+ColorChar+'L'+ColorChar+'abel', ' Ctrl-F4 ', kbCtrlF4, cmVolumeLabel, hcVolumeLabel,
      NewItem(' '+ColorChar+'C'+ColorChar+'opy disk', 'Alt-F5  ', kbAltF5, cmCopyDisk, hcCopyDisk,
      NewItem(' c'+ColorChar+'O'+ColorChar+'mpress', 'Alt-F6  ', kbAltF6, cmCompress, hcCompress,
      NewItem(' '+ColorChar+'H'+ColorChar+'istory', 'Alt-F8  ', kbAltF8, cmHistory, hcHistory,
      NewItem(' '+ColorChar+'E'+ColorChar+'GA lines', 'Alt-F9  ', kbAltF9, cmEGALines, hcEGALines,
      NewItem(' '+ColorChar+'V'+ColorChar+'ideo mode', 'Alt-F10 ', kbAltF10, cmVideoMode, hcVideoMode,
      NewLine(
      NewItem(' '+ColorChar+'S'+ColorChar+'wap panels', 'Ctrl-U  ', kbCtrlU, cmSwapPanels, hcSwapPanels,
      NewItem(' '+ColorChar+'P'+ColorChar+'anels on/off', 'Ctrl-O  ', kbCtrlO, cmPanelsOnOff, hcPanelsOnOff,
      NewLine(
      NewItem(' '+ColorChar+'M'+ColorChar+'enu file edit', stEmpty, kbNoKey, cmMenuEdit, hcMenuEdit,
      nil))))))))))))))),
    NewSubMenu('  '+ColorChar+'O'+ColorChar+'ptions  ', hcOptions, NewMenu(
      NewItem('  '+ColorChar+'C'+ColorChar+'onfiguration...', 'Ctrl-F9 ', kbCtrlF9, cmMainConfig, hcMainConfig,
      NewItem('  '+ColorChar+'D'+ColorChar+'rive setup...', 'Ctrl-F10', kbCtrlF10, cmDriveConfig, hcDriveConfig,
      NewItem('  e'+ColorChar+'X'+ColorChar+'tension file edit...', stEmpty, kbNoKey, cmExtEdit, hcExtEdit,
      NewItem('  '+ColorChar+'V'+ColorChar+'iewers...', stEmpty, kbNoKey, cmViewerEdit, hcViewerEdit,
      NewItem('  '+ColorChar+'E'+ColorChar+'ditors...', stEmpty, kbNoKey, cmEditorEdit, hcEditorEdit,
      NewLine(
      NewItem('  '+ColorChar+'M'+ColorChar+'ini status...', stEmpty, kbNoKey, cmMiniStatus, hcMiniStatus,
      MAutoMenus)))))))),
    NewSubMenu('  '+ColorChar+'R'+ColorChar+'ight  ', hcLeftRight, NewMenu(Q),
      nil))))))));
  if not ShowMenu then MenuBar^.Hide;
end;

{Create status items for the link functions in the disk editor
  Input : Text: text to put into the items
          Hotkey: scan code for the last hotkey
          Command: command for the first item}
function CreateLinkStatus(const Text: string; Hotkey, Command: Word): PStatusItem;
var
  B             : Byte;
  P             : PStatusItem;
begin
  P := NewEmptyKey(NewEmptyKey(nil));
  for B := 7 downto 0 do
  begin
    P := NewStatusKey('>' + Text + Chr(Ord('1') + B), Hotkey, Command + B, P);
    Dec(Hotkey, $0100);
  end;
  CreateLinkStatus := P;
end;

{Initialize the function key bar}
procedure InitKeyBar;
var
  R             : TRect;
begin
  Application^.GetExtent(R);
  R.A.Y := R.B.Y - 1;
  KeyBar := New(PKeyBar, Init(R,
    NewStatusDef(hcNoContext, hcNoContext,
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      nil)))))))))),
    NewStatusDef(hcNoContext + 1, hcMainConfig2 - 1,
      NewStatusKey('Help', kbF1, cmHelp,
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewStatusKey('Quit', kbF10, cmCancel,
      nil)))))))))),
    NewStatusDef(hcMainConfig2, hcMainConfig2,
      NewStatusKey('Help', kbF1, cmHelp,
      NewStatusKey('Config', kbF2, cmCfgConfig,
      NewStatusKey('Other', kbF3, cmCfgOther,
      NewStatusKey('Image', kbF4, cmCfgImage,
      NewStatusKey('Xfer', kbF5, cmCfgTransfer,
      NewStatusKey('Drive', kbF6, cmCfgDrive,
      NewStatusKey('Colors', kbF7, cmCfgPalette,
      NewStatusKey('Reset', kbF8, cmCfgReset,
      NewStatusKey('Cntry', kbF9, cmCfgCountry,
      NewStatusKey('Exit', kbF10, cmCancel,
      nil)))))))))),
    NewStatusDef(hcDriveConfig2, hcDriveConfig2,
      NewStatusKey('Help', kbF1, cmHelp,
      NewStatusKey('New', kbF2, cmDrvCfgNew,
      NewStatusKey('Xfer', kbF3, cmDrvCfgTransfer,
      NewStatusKey('Drive', kbF4, cmDrvCfgDrive,
      NewStatusKey('Dupe', kbF5, cmDrvCfgDupe,
      NewStatusKey('Rename', kbF6, cmDrvCfgRename,
      NewStatusKey('Swap', kbF7, cmDrvCfgSwap,
      NewStatusKey('Delete', kbF8, cmDrvCfgDelete,
      NewStatusKey('Reset', kbF9, cmDrvCfgReset,
      NewStatusKey('Quit', kbF10, cmCancel,
      nil)))))))))),
    NewStatusDef(hcBlockEdit, hcBlockEdit,
      NewStatusKey('Help', kbF1, cmHelp,
      NewEmptyKey(
      NewStatusKey('Mark', kbF3, cmDMark,
      NewStatusKey('Unmark', kbF4, cmDUnmark,
      NewStatusKey('Copy', kbF5, cmDCopy,
      NewStatusKey('Paste', kbF6, cmDPaste,
      NewStatusKey('Swap', kbF7, cmDSwap,
      NewStatusKey('Delete', kbF8, cmDDelete,
      NewStatusKey('Follow', kbF9, cmDFollow,
      NewStatusKey('Quit', kbF10, cmCancel,
      nil)))))))))),
    NewStatusDef(hcMakeImage2, hcMakeImage2,
      NewStatusKey('Help', kbF1, cmHelp,
      NewStatusKey('1541', kbF2, cmDisk1541,
      NewStatusKey('1571', kbF3, cmDisk1571,
      NewStatusKey('1581', kbF4, cmDisk1581,
      NewStatusKey('1541XT', kbF5, cmDisk1541Ext,
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewStatusKey('Quit', kbF10, cmCancel,
      nil)))))))))),
    NewStatusDef(hcCopyDisk2, hcCopyDisk2,
      NewStatusKey('Help', kbF1, cmHelp,
      NewStatusKey('NoConv', kbF2, cmNoDiskConv,
      NewStatusKey('CBMDsk', kbF3, cmCBMDisk,
      NewStatusKey('DskImg', kbF4, cmDiskImage,
      NewStatusKey('GCRDsk', kbF5, cmGCRDiskImage,
      NewStatusKey('DskZip', kbF6, cmDiskZip,
      NewStatusKey('SixZip', kbF7, cmSixZip,
      NewEmptyKey(
      NewStatusKey('CpMode', kbF9, cmDiskCopyMode,
      NewStatusKey('Quit', kbF10, cmCancel,
      nil)))))))))),
    NewStatusDef(hcDiskEdit2, hcDiskEdit2,
      NewStatusKey('Help', kbF1, cmHelp,
      NewStatusKey('Write', kbF2, cmDWrite,
      NewStatusKey('Read', kbF3, cmDRead,
      NewStatusKey('Edit', kbF4, cmDEdit,
      NewStatusKey('>BAM', kbF5, cmDGotoBAM,
      NewStatusKey('>Dir', kbF6, cmDGotoDir,
      NewStatusKey('>First', kbF7, cmDGotoFirst,
      NewStatusKey('>Last', kbF8, cmDGotoLast,
      NewStatusKey('Menu', kbF9, cmDMenu,
      NewStatusKey('Quit', kbF10, cmCancel,
      nil)))))))))),
    NewStatusDef(hcDiskedShift, hcDiskedShift, CreateLinkStatus('File', kbShiftF8, cmDFile1),
    NewStatusDef(hcDiskedAlt, hcDiskedAlt, CreateLinkStatus('Info', kbAltF8, cmDInfo1),
    NewStatusDef(hcDiskEdit3, hcMapEdit,
      NewStatusKey('Help', kbF1, cmHelp,
      NewStatusKey('Save', kbF2, cmDSaveMap,
      NewStatusKey('View', kbF3, cmDViewMap,
      NewStatusKey('Edit', kbF4, cmDEditMap,
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewStatusKey('Delete', kbF8, cmDDeleteMap,
      NewEmptyKey(
      NewStatusKey('Quit', kbF10, cmCancel,
      nil)))))))))),
    NewStatusDef(hcCompress2, hcCompress2,
      NewStatusKey('Help', kbF1, cmHelp,
      NewStatusKey('NoComp', kbF2, cmNoFileComp,
      NewStatusKey('Lynx', kbF3, cmLynx,
      NewStatusKey('ZipCod', kbF4, cmFileZip,
      NewStatusKey('LHA', kbF5, cmLHA,
      NewStatusKey('Arkive', kbF6, cmArkive,
      NewStatusKey('TAR', kbF7, cmTAR,
      NewStatusKey('ZIP', kbF8, cmZIP,
      NewEmptyKey(
      NewStatusKey('Quit', kbF10, cmCancel,
      nil)))))))))),
    NewStatusDef(hcCfgPalette2, hcCfgPalette2,
      NewStatusKey('Help', kbF1, cmHelp,
      NewStatusKey('Save', kbF2, cmSavePal,
      NewStatusKey('Load', kbF3, cmLoadPal,
      NewEmptyKey(
      NewStatusKey('B&W', kbF5, cmBlackWhite,
      NewStatusKey('Color', kbF6, cmColor,
      NewStatusKey('Laptop', kbF7, cmLaptop,
      NewStatusKey('Reset', kbF8, cmResetPal,
      NewEmptyKey(
      NewStatusKey('Quit', kbF10, cmCancel,
      nil)))))))))),
    NewStatusDef(hcOnlyQuit, hcOnlyQuit,
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewEmptyKey(
      NewStatusKey('Quit', kbF10, cmCancel,
      nil)))))))))),
    NewStatusDef(hcNormal, hcNormal,
      NewStatusKey('Help', kbF1, cmHelp,
      NewStatusKey('Menu', kbF2, cmUserMenu,
      NewStatusKey('View', kbF3, cmViewFile,
      NewStatusKey('Edit', kbF4, cmEditFile,
      NewStatusKey('Copy', kbF5, cmCopyFile,
      NewStatusKey('RenMov', kbF6, cmRenMovFile,
      NewStatusKey('Mkdir', kbF7, cmMakeDir,
      NewStatusKey('Delete', kbF8, cmDeleteFile,
      NewStatusKey('PullDn', kbF9, cmPanelMenu,
      NewStatusKey('Quit', kbF10, cmQuitProgram,
      nil)))))))))),
    NewStatusDef(hcShift, hcShift,
      NewStatusKey('Mkdisk', kbShiftF1, cmMakeDisk,
      NewStatusKey('Mktape', kbShiftF2, cmMakeTape,
      NewStatusKey('View', kbShiftF3, cmSViewFile,
      NewStatusKey('Edit', kbShiftF4, cmSEditFile,
      NewStatusKey('Copy', kbShiftF5, cmSCopyFile,
      NewStatusKey('RenMov', kbShiftF6, cmSRenMovFile,
      NewStatusKey('Mkdir', kbShiftF7, cmMakeDir,
      NewStatusKey('Delete', kbShiftF8, cmSDeleteFile,
      NewStatusKey('SavSet', kbShiftF9, cmSaveSetup,
      NewStatusKey('PullDn', kbShiftF10, cmLastMenu,
      nil)))))))))),
    NewStatusDef(hcControl, hcControl,
      NewStatusKey('Left', kbCtrlF1, cmLeftOnOff,
      NewStatusKey('Right', kbCtrlF2, cmRightOnOff,
      NewStatusKey('Disked', kbCtrlF3, cmDiskEdit,
      NewStatusKey('Label', kbCtrlF4, cmVolumeLabel,
      NewStatusKey('Copy', kbCtrlF5, cmCCopyFile,
      NewStatusKey('RenMov', kbCtrlF6, cmCRenMovFile,
      NewStatusKey('Attrib', kbCtrlF7, cmFileAttrib,
      NewStatusKey('Delete', kbCtrlF8, cmCDeleteFile,
      NewStatusKey('Config', kbCtrlF9, cmMainConfig,
      NewStatusKey('DrvCfg', kbCtrlF10, cmDriveConfig,
      nil)))))))))),
    NewStatusDef(hcAlt, hcAlt,
      NewStatusKey('Left', kbAltF1, cmLeftChange,
      NewStatusKey('Right', kbAltF2, cmRightChange,
      NewStatusKey('View..', kbAltF3, cmIntViewFile,
      NewStatusKey('Edit..', kbAltF4, cmIntEditFile,
      NewStatusKey('Cpdisk', kbAltF5, cmCopyDisk,
      NewStatusKey('Comp', kbAltF6, cmCompress,
      NewEmptyKey(
      NewStatusKey('Histry', kbAltF8, cmHistory,
      NewStatusKey('EGA Ln', kbAltF9, cmEGALines,
      NewStatusKey('VidMod', kbAltF10, cmVideoMode,
      nil)))))))))),
    nil))))))))))))))))))));
  if not ShowKeyBar then KeyBar^.Hide;
  LastShiftState := MaxByte;
end;

end.
