
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                    ATTRIB.PAS                   }
{                                                 }
{     The Star Commander File attributes unit     }
{*************************************************}

unit Attrib;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

procedure FileAttrib(Z: Byte);

implementation

uses
  App, Dialogs, DOS, Drivers, Objects, Views,
  Base1, Base2, Constant, ExtFiles, LowLevel, MiscFunc, Panel1, Panel2, Script, Transfer, XferLo;

{Grab attributes from a checkbox array
  Input : Box: the checkbox array
  Output: the attributes, rearranged in DOS order}
function GetAttrib(Box: PCheckBoxes): Byte;
var
  A             : Byte;
begin
  Box^.GetData(A);
  GetAttrib := (A and ReadOnly) or (A shl 4 and Archive) or (A shr 1 and (Hidden + SysFile));
end;

{Find attributes in the batch command parameters
  Input : Name: one-character name of the attribute
          Attr: DOS attribute bit
          Plus: variable to contain bit, if attribute is to be set
          Minus: variable to contain bit, if attribute is to be cleared
          FirstPar: number of parameter to start search with}
procedure FindBatchAttrib(Name: Char; Attr: Byte; var Plus, Minus: Word; FirstPar: Byte);
var
  I             : Byte;
  C             : Char;
  S             : string;
begin
  I := FirstPar;
  S := BatchParamStr(I, True);
  while S <> '' do
  begin
    if LoCase(S[1]) = Name then
    begin
      C := #0;
      if Length(S) > 1 then C := S[2];
      case C of
        '+':
        begin
          Plus := Plus or Attr;
          Minus := Minus and not Attr;
        end;
        '-':
        begin
          Plus := Plus and not Attr;
          Minus := Minus or Attr;
        end;
      else
        Plus := Plus and not Attr;
        Minus := Minus and not Attr;
      end;
    end;
    Inc(I);
    S := BatchParamStr(I, True);
  end;
end;

{Find time stamps in the batch command parameters
  Input : Name: one-character name of the attribute
          A: the word to contain the year or hour
          B: the word to contain the month or minute
          C: the word to contain the day or second
          Date: when True, a date is being processed; otherwise a time
          Found: set to True when a time stamp was found; otherwise set to
                 False
          FirstPar: number of parameter to start search with}
procedure FindBatchTime(Name: Char; var A, B, C: Word; Date: Boolean; var Found: Boolean; FirstPar: Byte);
var
  I             : Byte;
  S             : string;
begin
  Found := False;
  I := FirstPar;
  S := BatchParamStr(I, True);
  while S <> '' do
  begin
    if LoCase(S[1]) = Name then
    begin
      S := Copy(S, 2, MaxStrLen);
      Found := (S <> '') and (MakeTime(S, A, B, C, Date));
    end;
    Inc(I);
    S := BatchParamStr(I, True);
  end;
end;

{Find file types in the batch command parameters
  Input : Name: one-character names of the file types
          Attr: variable to contain file type
          FirstPar: number of parameter to start search with}
procedure FindBatchFileType(Name: string; var Attr: Word; FirstPar: Byte);
var
  C,
  I             : Byte;
  S             : string;
begin
  Attr := 0;
  I := FirstPar;
  S := BatchParamStr(I, True);
  while S <> '' do
  begin
    C := LeftPos(S[1], Name);
    if (C > 0) then Attr := C;
    Inc(I);
    S := BatchParamStr(I, True);
  end;
end;

{'File attributes' in the 'Files' menu: change the attributes of the
  selected files
  Input : Z: file selection mode (file under the cursor bar, enter file name
             into dialog box, file name already given)}
procedure FileAttrib(Z: Byte);
var
  W,
  X,
  G,
  F,
  O             : Boolean;
  P             : Byte;
  N             : Char;
  A,
  B,
  C,
  V             : Word;
  I,
  Y             : Integer;
  L             : Longint;
  D,
  E             : PDialog;
  I1,
  I2            : PCheckBoxes;
  I3            : PRadioButtons;
  I4,
  I5            : PInputLine;
  H             : PSItem;
  V1            : PDateValid;
  V2            : PTimeValid;
  M             : string[1];
  S             : string;
  R             : TRect;
  T,
  U             : DateTime;

{Display progress indicator box
  Input : CBM: when True, the file is a Commodore file}
procedure DisplayProgressWin(CBM: Boolean);
var
  T             : string;
begin
  T := S;
  if CBM then T := MakeCBMName(T, Act^.GEOSFormat);
  ProgressWin(E, 'Setting attributes of', T, stEmpty, False, False);
end;

{Process attributes, recursively, in a directory structure}
procedure ProcessAttrib;
var
  D,
  Z             : Byte;
  C             : Word;
  E             : SearchRec;
begin
  while ContProcess and ContDirProcess do
  begin
    ContDirProcess := Act^.FindNextFile(False, False, False);
    if ContDirProcess then
    begin
      Z := Act^.CopyAttr;
      if Z and Directory = 0 then
      begin
        S := Act^.CopyFullName;
        V := (Z and not B) or A;
        DisplayProgressWin(False);
        SysErrorOccurred := False;
        I := 0;
        if W or X then
        begin
          if Z and ReadOnly > 0 then
          begin
            Z := Z and (not ReadOnly);
            LongSetFAttr(Act^.CopyFullName, Z);
          end;
          I := LongOpenFile(Act^.CopyFullName, ReadFile, fmReadWrite);
          if I = 0 then
          begin
            FileProcessed := True;
            ExtGetFTime(ReadFile, L);
            UnpackTime(L, U);
            if W then
            begin
              U.Year := T.Year;
              U.Month := T.Month;
              U.Day := T.Day;
            end;
            if X then
            begin
              U.Hour := T.Hour;
              U.Min := T.Min;
              U.Sec := T.Sec;
            end;
            PackTime(U, L);
            ExtSetFTime(ReadFile, L);
            ExtClose(ReadFile);
            I := IOResult;
          end;
        end;
        if V <> Z then
        begin
          LongSetFAttr(Act^.CopyFullName, V);
          I := IOResult;
        end;
      end
      else
      begin
        C := Act^.CopyEntry.LongHandle;
        E := Act^.CopyEntry.Orig;
        D := CopyFileMode;
        EnterDir(Act);
        ProcessAttrib;
        LeaveDir(Act);
        Act^.CopyEntry.LongHandle := C;
        Act^.CopyEntry.Orig := E;
        CopyFileMode := D;
      end;
      if I = 0 then
      begin
        FileProcessed := True;
      end
      else
      begin
        if not SysErrorOccurred then
          ContProcess := ErrorWin(stEmpty, 'Can''t set attributes of the file',
            Act^.CopyFullName, hcFileAttrib, sbNone);
      end;
      UnselectFile(Act, (I = 0));
    end;
    Act^.DrawPanel;
    ContProcess := ContProcess and not Escape;
  end;
end;

begin
  ChangeHelpCtx(hcFileAttrib);
  BoxTitle := 'Attributes';
  CopyFileMode := Z;
  if CopyFileMode = cfAutomatic then
  begin
    Act^.Prepare(SourceName, True, False, False);
    IncludeSubdirs := True;
    SetDirNameGiven;
  end;
  O := GetPanelModeAttrib(Act^.CopyMode, paFileAttribs);
  S := '';
  D := nil;
  if O and (CopyFileMode = cfSelected) then
  begin
    if Act^.CopyMode = pmDOS then
    begin
      if (Act^.SelNum = 0) and (Act^.Dir[Act^.Cur].Attr and Directory = 0) then
      begin
        S := '"' + LimitNameLen(Act^.GetNamePtr(Act^.Cur)^, (MaxNameLen - 2)) + '"';
        I := 29;
        if I < Length(S) + 2 then I := Length(S) + 2;
        MakeWinBounds(R, I, 8);
        D := New(PDialog, Init(R, BoxTitle, fxNormal, fyNormal, True));
        R.Assign((I - 26) shr 1 + 4, 2, 26, 1);
        D^.Insert(New(PStaticText, Init(R, 'Change file attributes for')));
        R.Assign((I - Length(S)) shr 1 + 4, 3, Length(S), 1);
        D^.Insert(New(PStaticText, Init(R, S)));
        V1 := New(PDateValid, Init);
        V2 := New(PTimeValid, Init);
        R.Assign((I - 26) shr 1 + 5, 4, 15, 4);
        I1 := New(PCheckBoxes, Init(R,
          NewSItem('Read only',
          NewSItem('Archive',
          NewSItem('Hidden',
          NewSItem('System',
        nil))))));
        A := Act^.Dir[Act^.Cur].Attr;
        V := (A and ReadOnly) or ((A and Archive) shr 4) or ((A and (Hidden + SysFile)) shl 1);
        I1^.SetData(V);
        D^.Insert(I1);
        R.Assign((I - 26) shr 1 + 21, 4, 10, 2);
        I4 := (New(PInputLine, Init(R, 10, 10, 'Date', drUp)));
        I4^.SetValidator(V1);
        D^.Insert(I4);
        R.Assign((I - 26) shr 1 + 21, 6, 10, 2);
        I5 := (New(PInputLine, Init(R, 10, 10, 'Time', drUp)));
        I5^.SetValidator(V2);
        L := Act^.Dir[Act^.Cur].Time;
        D^.Insert(I5);
        if L <> 0 then
        begin
          UnpackTime(L, T);
          S := CreateDate(T.Year, T.Month, T.Day, 1, True);
          I4^.SetData(S);
          A := T.Hour;
          MakeAMPM(A, M, False);
          S := LeadingSpace(A, 0) + TimeSep + LeadingZero(T.Min, 2) + TimeSep + LeadingZero(T.Sec, 2);
          if M <> '' then S := S + M;
          I5^.SetData(S);
        end;
      end
      else
      begin
        MakeWinBounds(R, 34, 8);
        D := New(PDialog, Init(R, BoxTitle, fxNormal, fyNormal, True));
        R.Assign(9, 2, 22, 1);
        D^.Insert(New(PStaticText, Init(R, 'Change file attributes')));
        V1 := New(PDateValid, Init);
        V2 := New(PTimeValid, Init);
        R.Assign(6, 3, 3, 1);
        D^.Insert(New(PColorText, Init(R, ColorChar+'Set')));
        R.Assign(11, 3, 5, 1);
        D^.Insert(New(PColorText, Init(R, ColorChar+'Clear')));
        R.Assign(6, 4, 3, 4);
        I1 := New(PCheckBoxes, Init(R,
          NewSItem(stEmpty,
          NewSItem(stEmpty,
          NewSItem(stEmpty,
          NewSItem(stEmpty,
        nil))))));
        D^.Insert(I1);
        R.Assign(11, 4, 16, 4);
        I2 := New(PCheckBoxes, Init(R,
          NewSItem('Read only',
          NewSItem('Archive',
          NewSItem('Hidden',
          NewSItem('System',
        nil))))));
        D^.Insert(I2);
        R.Assign(27, 4, 10, 2);
        I4 := (New(PInputLine, Init(R, 10, 10, 'Date', drUp)));
        I4^.SetValidator(V1);
        D^.Insert(I4);
        R.Assign(27, 6, 10, 2);
        I5 := (New(PInputLine, Init(R, 10, 10, 'Time', drUp)));
        I5^.SetValidator(V2);
        D^.Insert(I5);
      end;
    end
    else
    begin
      if Act^.SelNum = 0 then
      begin
        if (Act^.Max = 0) or ((Act^.CopyMode <> pmExt) and (Act^.Cur = 0)) then
        begin
          O := False;
        end
        else
        begin
          S := '"' + LimitNameLen(MakeCBMName(Act^.GetNamePtr(Act^.Cur)^, Act^.GEOSFormat), (MaxNameLen - 2)) + '"';
          I := 12;
          W := (Act^.CopyMode = pmTape);
          X := W or ((Act^.CopyMode = pmDisk) and (Act^.DiskType and dtTypeMask = dt1581));
          if X then Inc(I);
          MakeWinBounds(R, 28, I);
          D := New(PDialog, Init(R, BoxTitle, fxNormal, fyNormal, True));
          R.Assign(5, 2, 27, 1);
          D^.Insert(New(PStaticText, Init(R, 'Change file attributes for')));
          R.Assign((28 - Length(S)) shr 1 + 5, 3, CBMStrLen(S), 1);
          D^.Insert(New(PCBMText, Init(R, S)));
          R.Assign(8, 4, 21, 2);
          I1 := New(PCheckBoxes, Init(R,
            NewSItem('Write protected',
            NewSItem('Closed',
          nil))));
          A := Act^.Dir[Act^.Cur].Attr;
          V := A shr 6 and 3;
          I1^.SetData(V);
          D^.Insert(I1);
          H := nil;
          I := 6;
          if X then
          begin
            Inc(I);
            S := 'Frozen';
            if not W then S := 'Partition';
            H := NewSItem(S, nil);
          end;
          R.Assign(8, 6, 17, I);
          I3 := New(PRadioButtons, Init(R,
            NewSItem('Do not change',
            NewSItem('Deleted',
            NewSItem('Sequential',
            NewSItem('Program',
            NewSItem('User',
            NewSItem('Relative',
          H))))))));
          V := 0;
          I3^.SetData(V);
          D^.Insert(I3);
        end;
      end
      else
      begin
        MakeWinBounds(R, 30, 12);
        D := New(PDialog, Init(R, BoxTitle, fxNormal, fyNormal, True));
        R.Assign(8, 2, 22, 1);
        D^.Insert(New(PStaticText, Init(R, 'Change file attributes')));
        R.Assign(7, 3, 3, 1);
        D^.Insert(New(PColorText, Init(R, ColorChar+'Set')));
        R.Assign(12, 3, 5, 1);
        D^.Insert(New(PColorText, Init(R, ColorChar+'Clear')));
        R.Assign(7, 4, 3, 2);
        I1 := New(PCheckBoxes, Init(R,
          NewSItem(stEmpty,
          NewSItem(stEmpty,
        nil))));
        D^.Insert(I1);
        R.Assign(12, 4, 20, 2);
        I2 := New(PCheckBoxes, Init(R,
          NewSItem('Write protected',
          NewSItem('Closed',
        nil))));
        D^.Insert(I2);
        R.Assign(12, 6, 21, 6);
        I3 := New(PRadioButtons, Init(R,
          NewSItem('Do not change',
          NewSItem('Deleted',
          NewSItem('Sequential',
          NewSItem('Program',
          NewSItem('User',
          NewSItem('Relative',
        nil))))))));
        D^.Insert(I3);
      end;
    end;
  end;
  if O then
  begin
    C := cmOK;
    if CopyFileMode = cfSelected then
    begin
      Y := D^.Size.Y;
      R.Assign(3, Y - 4, D^.Size.X - 6, 1);
      D^.Insert(New(PSeparator, Init(R)));
      I := D^.Size.X shr 1;
      R.Assign(I - 10, Y - 3, 7, 1);
      D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'S'+ColorChar+'et ]', cmOK)));
      R.Assign(I, Y - 3, 10, 1);
      D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'C'+ColorChar+'ancel ]', cmCancel)));
      I1^.Select;
      ErrorDown := 8;
      C := Application^.ExecView(D, True, True);
      ErrorDown := 0;
    end;
    FileProcessed := False;
    ContProcess := True;
    ContDirProcess := True;
    CopyFileNum := 0;
    Act^.FirstFile := True;
    if C = cmOK then
    begin
      E := nil;
      if Act^.CopyMode = pmDOS then
      begin
        case CopyFileMode of
          cfSelected:
          begin
            I4^.GetData(S);
            S := UpperCase(S);
            W := (S <> '');
            if W then MakeTime(S, T.Year, T.Month, T.Day, True);
            I5^.GetData(S);
            S := UpperCase(S);
            X := (S <> '');
            if X then MakeTime(S, T.Hour, T.Min, T.Sec, False);
            ClockOff;
            A := GetAttrib(I1);
            B := (Archive + Hidden + ReadOnly + SysFile);
            if Act^.SelNum > 0 then B := GetAttrib(I2);
            Act^.CopyPath := '';
          end;
          cfAutomatic:
          begin
            A := 0;
            B := 0;
            FindBatchAttrib('r', ReadOnly, A, B, 2);
            FindBatchAttrib('a', Archive, A, B, 2);
            FindBatchAttrib('h', Hidden, A, B, 2);
            FindBatchAttrib('s', SysFile, A, B, 2);
            FindBatchTime('d', T.Year, T.Month, T.Day, True, W, 2);
            FindBatchTime('t', T.Hour, T.Min, T.Sec, False, X, 2);
          end;
        end;
        ProcessAttrib;
      end
      else
      begin
        if (Act^.SelNum = 0) and (CopyFileMode = cfSelected) then
        begin
          I1^.GetData(V);
          A := (Act^.Dir[Act^.Cur].Attr and not faFlagMask) or (V shl 6 and faFlagMask);
          I3^.GetData(V);
          if V > 0 then A := (A and not faTypeMask) or (V - 1);
          Act^.GetFileData(Act^.Cur);
          if Act^.CopyMode = pmExt then
          begin
            ClockOff;
            MouseOff;
            DisplayProgressWin(True);
            if SendDriveProg(deBase, True) and SendDriveProg(deAttrib, False) then
              ExecDriveProg(deAttrib, + #0 + Chr((A and faFlagMask) or 1) + '0:' + S + '=' +
                UpCase(ShortCBMExt[A and faTypeMask][1]));
            O := ReadCBMError(S, False, False, True);
            if not O then O := ErrorWin(stError, S, stEmpty, hcFileAttrib, sbNone);
            FileProcessed := True;
          end
          else
          begin
            ClockOff;
            if Act^.OpenImage(True, False, True, True, True) = 0 then
            begin
              DisplayProgressWin(True);
              if Act^.ImageReadOnly then
              begin
                ErrorWin(stEmpty, 'The following image file is marked read-only.', Act^.ImageName, hcFileAttrib, sbNone);
              end
              else
              begin
                F := Act^.SeekToNextFile(L);
                if F then
                begin
                  case Act^.CopyMode of
                    pmDisk:
                    begin
                      Act^.DirBuffer[Act^.EntryPos + 2] := A;
                      Act^.WriteDiskBlock(Act^.DirTrack, Act^.DirSector, @Act^.DirBuffer);
                    end;
                    pmTape:
                    begin
                      if A and faTypeMask in [faDeleted..faRelative] then
                      begin
                        Act^.DirBuffer[0] := faTapeNormal;
                        Act^.DirBuffer[1] := A;
                      end
                      else
                      begin
                        Act^.DirBuffer[0] := faTapeFrozen;
                        Act^.DirBuffer[1] := 0;
                      end;
                      Act^.WriteTapeBlock(Act^.DirPos, @Act^.DirBuffer);
                    end;
                  end;
                  FileProcessed := True;
                end;
              end;
              Act^.CloseImage(True);
            end;
          end;
        end
        else
        begin
          case CopyFileMode of
            cfSelected:
            begin
              I1^.GetData(V);
              A := V shl 6 and faFlagMask;
              I2^.GetData(V);
              B := V shl 6 and faFlagMask;
              I3^.GetData(V);
            end;
            cfAutomatic:
            begin
              A := 0;
              B := 0;
              FindBatchAttrib('w', faWriteProt, A, B, 2);
              FindBatchAttrib('c', faClosed, A, B, 2);
              FindBatchFileType('xspur', V, 2);
            end;
          end;
          P := V;
          ClockOff;
          O := True;
          G := Escape;
          Act^.FirstFile := True;
          while ContProcess do
          begin
            ContProcess := Act^.FindNextFile(False, False, False);
            if ContProcess then
            begin
              if Act^.CopyMode = pmExt then
              begin
                MouseOff;
                DisplayProgressWin(True);
                if SendDriveProg(deBase, True) and SendDriveProg(deAttrib, False) then
                  ExecDriveProg(deAttrib, Chr(not B or 1) + Chr(A or 1) + '0:' + S + '=' +
                  UpCase(ShortCBMExt[P and faTypeMask][1]));
                O := ReadCBMError(S, False, False, True);
                if not O then O := ErrorWin(stError, S, stEmpty, hcFileAttrib, sbNone);
              end
              else
              begin
                DisplayProgressWin(True);
                if Act^.OpenImage(True, False, True, True, True) = 0 then
                begin
                  if Act^.ImageReadOnly then
                  begin
                    ErrorWin(stEmpty, 'The following image file is marked read-only.', Act^.ImageName, hcFileAttrib, sbNone);
                    O := False;
                  end
                  else
                  begin
                    V := (Act^.CopyAttr and not B) or A;
                    if P > 0 then V := (V and not faTypeMask) or ((P - 1) and faTypeMask);
                    F := Act^.SeekToNextFile(L);
                    if F then
                    begin
                      case Act^.CopyMode of
                        pmDisk:
                        begin
                          Act^.DirBuffer[Act^.EntryPos + 2] := V;
                          Act^.WriteDiskBlock(Act^.DirTrack, Act^.DirSector, @Act^.DirBuffer);
                        end;
                        pmTape:
                        begin
                          Act^.DirBuffer[1] := V;
                          Act^.WriteTapeBlock(Act^.DirPos, @Act^.DirBuffer);
                        end;
                      end;
                    end;
                  end;
                  Act^.CloseImage(True);
                end;
              end;
              UnselectFile(Act, O);
              if O then FileProcessed := True;
              Act^.DrawPanel;
              ContProcess := not Escape;
            end;
          end;
        end;
      end;
      if E <> nil then Dispose(E, Done);
      if FileProcessed then
      begin
        if not (CopyFileMode in [cfWildcard, cfAutomatic]) then
        begin
          UnselectProcessed;
          Act^.Draw;
        end;
        RereadPanels;
      end
      else
      begin
        ClockOn;
      end;
    end;
    if D <> nil then Dispose(D, Done);
  end;
  RestoreHelpCtx;
  NextBatchCommand;
end;

end.
