
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                    BASE1.PAS                    }
{                                                 }
{         The Star Commander base unit #1         }
{*************************************************}

unit Base1;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Dialogs, Drivers, Menus, Objects, Validate, Views,
  Base2, Constant, ExtFiles, LowLevel;

type
{Empty menu bar}
  TFalseMenu    = object(TStaticText)
    constructor Init;
    function GetPalette: PPalette; virtual;
  end;
  PFalseMenu    = ^TFalseMenu;
{Title bar for the viewer, editor and disk editor}
  TTitle        = object(TFalseMenu)
    procedure Draw; virtual;
  end;
  PTitle        = ^TTitle;
{Screen saver star}
  TSaverStar    = object(TView)
    Count,
    Phase: Byte;
    procedure Draw; virtual;
  end;
  PSaverStar    = ^TSaverStar;
{Screen saver}
  TScreenSaver  = object(TWindow)
    OffFunc     : TProc;
    SaverStars  : array [0..SaverStarMax - 1] of PSaverStar;
    constructor Init(Bounds: TRect);
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Idle; virtual;
    function GetPalette: PPalette; virtual;
    procedure Draw; virtual;
  end;
  PScreenSaver  = ^TScreenSaver;
{History or menu}
  THistory      = object(TView)
    Items,
    CurItem     : PHistoryItem;
    HotWidth    : Integer;
    HotKey,
    CtrlEnter   : Boolean;
    constructor Init(var Bounds: TRect; AItems: PHistoryItem; ItemNum: Integer; AHotKey: Boolean);
    destructor Done; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Draw; virtual;
  end;
  PHistory      = ^THistory;
{Decimal numerical input line}
  TNumInput     = object(TInputLine)
    procedure HandleEvent(var Event: TEvent); virtual;
  end;
  PNumInput     = ^TNumInput;
{Hexadecimal numerical input line}
  THexInput     = object(TInputLine)
    procedure HandleEvent(var Event: TEvent); virtual;
  end;
  PHexInput     = ^THexInput;
{Drive letter input line}
  TDriveInput   = object(TInputLine)
    procedure HandleEvent(var Event: TEvent); virtual;
  end;
  PDriveInput   = ^TDriveInput;
{Menu selection input line}
  TMenuInput    = object(TInputLine)
    FirstVal,
    LastVal,
    FirstNum,
    Value       : Byte;
    MenuTitle   : string;
    ItemStrProc : TItemStrProc;
    constructor Init(var Bounds: TRect; ALen, AMaxLen: Integer; const ATitle: string; ATitleDir: Byte;
      const AMenuTitle: string; AFirstVal, ALastVal, AFirstNum: Byte; AItemStrProc: TItemStrProc);
    procedure GetData(var Rec); virtual;
    procedure SetData(var Rec); virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
  end;
  PMenuInput    = ^TMenuInput;
{Parallel port input line}
  TLPTPortInput = object(THexInput)
    CurPort     : Byte;
    procedure GetData(var Rec); virtual;
    procedure SetData(var Rec); virtual;
    procedure CheckCustomPort;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure SetState(AState:Word; Enable: Boolean); virtual;
  end;
  PLPTPortInput = ^TLPTPortInput;
{Value validity checker for decimal numerical input lines}
  TNumValid     = object(TValidator)
    Min,
    Max         : Integer;
    Title,
    ErrorStr    : string;
    Help        : Word;
    constructor Init(AMin, AMax: Integer; const ATitle, AError: string; AHelp: Word);
    function IsValid(const S: string): Boolean; virtual;
    procedure Error; virtual;
  end;
  PNumValid     = ^TNumValid;
{Date validity checker}
  TDateValid    = object(TValidator)
    function IsValid(const S: string): Boolean; virtual;
    procedure Error; virtual;
  end;
  PDateValid    = ^TDateValid;
{Time validity checker}
  TTimeValid    = object(TValidator)
    function IsValid(const S: string): Boolean; virtual;
    procedure Error; virtual;
  end;
  PTimeValid    = ^TTimeValid;

var
  ScreenSaver   : PScreenSaver;
  DelayValueInp : PNumInput;

procedure RedrawAllViews;
function DetectDiskType(Extended, Force: Boolean): Byte;
procedure CreateSectorHeader(T, S, FirstPadding: Byte);
function SendDriveProg(ProgNum: Byte; UploadTurbo: Boolean): Boolean;
function ExecDriveProg(ProgNum: Byte; const Params: string): Boolean;
function DriveValid(Drive: Char): Boolean;
function IsLeapYear(Year: Word): Boolean;
function IsDST(Year, Month, Day, Hour: Word): Boolean;
function DOSToUnix(Time: Longint): Longint;
function UnixToDOS(Time: Longint): Longint;
function LocalTime: Longint;
function MakeTime(const T: string; var A, B, C: Word; Date: Boolean): Boolean;
function MakeIDString(ID: PByte; GEOS: Boolean): string;
function MakePC64Name(const Name: string): string;
function ReadNum: Longint;
procedure WriteNum;
procedure MakeLHAEntry;
function ReadZIPEntry(var F: ExtFile; var E: TZIPEntry; var S: string): Boolean;
function ReadZIPCDirEntry(var F: ExtFile; var E: TZIPCDirEntry; var S: string): Boolean;
function ComputeTARCheck(Store: Boolean): Longint;
function PadSize(Size: Longint): Byte;
procedure AddPadding(var F: ExtFile; BlockSize: Word);
function DiskTypeSignature(DiskType, ExtBAMMode: Byte): string;
function CorrectBAMLabel(const Name: string; DiskType, ExtBAMMode: Byte): string;
function ReadErrorStr(Code, Track, Sector: Byte): string;
function ErrorCodeToStatus(Error: Byte): Byte;
function ErrorStatusToCode(Error: Byte): Byte;
function DriveOK(var Path: string): Boolean;
function InfoWin(const Title: string; Text1, Text2, Text3: string; Heigth: Integer): PDialog;
function DiskErrorWin(const Title: string; Text1, Text2: string; Help: Word; Skip, Track, SkipAuto: Boolean): Word;
function ScreenColorStr(ScreenColor: Byte): string;
function DOSTypeStr(DOSType: Byte): string;
function CharConvModeStr(CharConvMode: Byte): string;
function TransferModeStr(TransferMode: Byte): string;
function SerialCableStr(SerialCable: Byte): string;
function ParallelCableStr(ParallelCable: Byte): string;
function AsyncTransferStr(AsyncTransfer: Byte): string;
function DetectPortModeStr(DetectPortMode: Byte): string;
function CmdExecModeStr(CmdExecMode: Byte): string;
function IntoImageModeStr(IntoImageMode: Byte): string;
function ExtractImageModeStr(ExtractImageMode: Byte): string;
function ExtendedDiskModeStr(ExtendedDiskMode: Byte): string;
function DiskCopyModeStr(DiskCopyMode: Byte): string;
function InvalidGCRCodeModeStr(InvalidGCRCodeMode: Byte): string;
function InitLongNames: Boolean;
procedure InitCountry;
function ReadUserFile(const Name: string; Menu, Error: Boolean; Help: Word): Integer;
function EOLMark(Ch: Char): Boolean;
function AllTrim(Str: string): string;
function ParseMenu(var Line: string; Image: Boolean): Boolean;
function ParseExt(var Line: string; Image: Boolean): Boolean;
function FindPattern(const Pattern: string; Image: Boolean; var AllFiles: Boolean): Boolean;
function NonEmptyLine(var L: string): Boolean;
function ConstructMenu(var Len: Integer; var Items: PHistoryItem; Image, Menu: Boolean): Boolean;
procedure ForceUserTitle(var Title: string);
function DisplayUserMenu(const Title: string; Height, Width, Start: Integer; MenuType: Byte; Items: PHistoryItem;
  Value: PString; Force, Hotkeys: Boolean): Word;
procedure InitSaver;
procedure SaverOn;
procedure SaverOff;
procedure CollectLPTPorts(Force: Boolean);
procedure Recalibrate;
function SelectMenuInputItem(const Title: string; First, Last, FirstNum, Value: Byte; ItemStrProc: TItemStrProc): Word;

implementation

uses
  App, DOS,
  Config;

{Redraw all views}
procedure RedrawAllViews;
begin
  RedrawAll := True;
  Application^.Redraw;
  RedrawAll := False;
  Application^.TopView^.DrawView;
end;

{Detect the presence of the extra tracks on a 1541 disk and the number of
  sides on a 1571 disk
  Input : Extended: the default value for the presence of the extra tracks,
                    if no autodetection is needed
          Force: when False, the actual detection is skipped
  Output: the drive type}
function DetectDiskType(Extended, Force: Boolean): Byte;
var
  F,
  O             : Boolean;
  B             : Byte;
  S             : string;
begin
  B := ExtDiskType;
  O := (ExtDriveType = dt1541);
  F := True;
  if (ExternalDrive = xd1571) and Force then
  begin
    ReadCBMError(S, False, False, True);
    OpenCBMChannel(saCommand, 'I0', True);
    Status := 0;
    OpenCBMChannel(saCommand, 'M-R' + #$AC + #$02 + #$01, True);
    ReadCBMError(S, False, False, True);
    Status := 0;
    F := False;
    O := (S <> #71);
  end;
  if O then
  begin
    B := dt1541;
    O := Extended;
    if DetectExtTracks and Force then
    begin
      if F then OpenCBMChannel(saCommand, 'I0', True);
      if SendDriveProg(deTurboDiskDetect, True) and ExecDriveProg(deTurboDiskDetect, Chr(Max1541Tracks) + #0) then
      begin
        asm
          push word ptr CopyPriorityMode;
          call InterruptOff;
          call ParallelInput;
          call TReceive;
          cmp Status, 0;
          jne @1;
          xor ah, ah;
          cmp al, dsOK;
          je @2;
          cmp al, ds21READ;
          jbe @3;
          cmp al, ds74NOTREADY;
          jae @3;
      @2: inc ah;
      @3: mov O, ah;
      @1: call InterruptOn;
        end;
      end;
      Status := 0;
    end;
    if O then B := dt1541Ext;
  end;
  CopyExtDiskType := B;
  DetectDiskType := B;
end;

{Create a sector header
  Input: T, S: track and sector number}
procedure CreateSectorHeader(T, S, FirstPadding: Byte);
begin
  UndoBuffer[0] := HeaderSign;
  UndoBuffer[2] := S;
  UndoBuffer[3] := T;
  UndoBuffer[4] := Lo(CopyHeaderID);
  UndoBuffer[5] := Hi(CopyHeaderID);
  UndoBuffer[6] := FirstPadding;
  UndoBuffer[7] := HeaderPadding;
  UndoBuffer[1] := UndoBuffer[2] xor UndoBuffer[3] xor UndoBuffer[4] xor UndoBuffer[5];
end;

{Send a drive program to the external CBM drive, if possible, using turbo
  data transfer
  Input : ProgNum: the number of the program to be sent
          UploadTurbo: when True, first the turbo uploader is uploaded to the
                       drive
  Output: when True, no error occured during the transmission}
function SendDriveProg(ProgNum: Byte; UploadTurbo: Boolean): Boolean;
var
  T,
  O             : Boolean;
  C,
  D,
  N             : Byte;
  A,
  E,
  F,
  L,
  M,
  X,
  Y,
  Z             : Word;
  B             : PPatchBuffer;
  P             : PBuffer;
  S             : string[40];
begin
  N := ProgNum;
  if ExternalDrive = xd1581 then Inc(N, deEntryNum);
  P := @DriveProgs;
  GetClock(False);
  GetMouse(False);
  C := N shl 1;
  L := BytesToLongint(P^[C], P^[C + 1], 0, 0);
  M := BytesToLongint(P^[C + 2], P^[C + 3], 0, 0);
  Z := BytesToLongint(P^[L], P^[L + 1], 0, 0);
  SendDriveProg := False;
  Inc(L, 2);
  Dec(M, L);
  if M = (MaxWord - 1) then Exit;
  T := (ProgNum <> deTransfer) and (CopyTransferMode <> tmNormal);
  O := True;
  if T then
  begin
    TurboOff;
    O := not UploadTurbo or SendDriveProg(deTransfer, False);
  end;
  if O then
  begin
    B := New(PPatchBuffer);
    FillChar(B^, TPatchBufSize, 0);
    Move(P^[L], B^, M);
    for D := 0 to 2 do
    begin
      A := TransferOfs[D, N] shl 4;
      if A > 0 then
      begin
        C := TransferPrgs[D, CopyCableMode] shl 1;
        if ExternalDrive = xd1581 then Inc(C, deEntryNum shl 1);
        E := BytesToLongint(P^[C], P^[C + 1], 0, 0);
        F := BytesToLongint(P^[C + 2], P^[C + 3], 0, 0);
        Inc(E, 2);
        Dec(F, E);
        Move(P^[E], B^[A], F);
        Inc(A, F);
        if A > M then M := A;
      end;
    end;
    if CopyCableMode in [cmHybrid, cmParallel] then
    begin
      O := (ExternalDrive in [xd1571, xd1570, xd157xEmu]);
      asm
        push ds;
        mov cx, M;
        mov dl, O;
        lds si, B;
        cld;
    @1: lodsb;
        cmp cx, 2;
        jb @4;
        cmp al, $2C;
        jne @2;
        cmp word ptr [si], $1803;
        jne @2;
        mov byte ptr [si][-1], $8D;
        or dl, dl;
        je @2;
        mov byte ptr [si][1], $40;
    @2: cmp al, $8D;
        je @3;
        cmp al, $AD;
        jne @4;
    @3: cmp word ptr [si], $1801;
        jne @4;
        or dl, dl;
        je @4;
        mov byte ptr [si][1], $40;
    @4: loop @1;
        pop ds;
        call ParallelInput;
      end;
    end;
    if CopyTransferMode <> tmNormal then
    begin
      case ExtDriveType of
        xd1571:
        begin
          asm
              mov cx, M;
              mov dl, CopyExtDiskType;
              push ds;
              lds si, B;
              cld;
          @2: lodsb;
              mov bx, word ptr [si];
              cmp cx, 2;
              jb @3;
              cmp al, $2C;
              jne @4;
              cmp bx, $9600;
              je @9;
              cmp bx, $05E0;
              je @15;
              cmp bx, $05F0;
              jne @4;
          @15:cmp dl, dt1571;
              jne @4;
          @9: mov byte ptr [si][-1], $20;
          @4: cmp al, $20;
              jne @16;
              cmp bx, $F556;
              jne @16;
{              mov word ptr [si], $9754;}
          @16:cmp al, $4C;
              jne @5;
              cmp bx, $F48D;
              jne @11;
              mov word ptr [si], $9525;
          @11:cmp bx, $F4CA;
              jne @12;
              mov word ptr [si], $9606;
          @12:cmp bx, $F969;
              jne @5;
              mov word ptr [si], $99B5;
          @5: cmp al, $8D;
              jne @10;
              cmp bx, $0734;
              jne @14;
              mov byte ptr [si], $FA;
              mov byte ptr [si][7], al;
              mov byte ptr [si][12], al;
              mov byte ptr [si][17], al;
              mov byte ptr [si][20], al;
          @14:cmp bx, $07A5;
              jne @7;
              mov byte ptr [si], $B5;
          @7: cmp bx, $0464;
              jne @10;
              mov byte ptr [si], $74;
          @10:cmp al, $A9;
              jne @6;
              cmp bl, $02;
              jne @6;
              cmp word ptr [si][1], $7385;
              jne @6;
              shl byte ptr [si], 1;
          @6: cmp al, $B9;
              jne @1;
              cmp bx, $F4D0;
              jne @8;
              mov byte ptr [si][-2], $FF;
              mov word ptr [si], $960F;
          @8: cmp bx, $F574;
              jne @13;
              mov byte ptr [si][-2], $74;
              mov word ptr [si], $9774;
          @13:cmp bx, $F57A;
              jne @3;
              mov byte ptr [si][-2], $6E;
              mov word ptr [si], $977A;
          @1: cmp al, $CD;
              jne @3;
              cmp bx, $FED7;
              jne @3;
              cmp dl, dt1571;
              jne @3;
              mov byte ptr [si][-1], $18;
              mov word ptr [si], $EAEA;
          @3: dec cx;
              jne @2;
              pop ds;
          end;
        end;
      end;
    end;
    Status := 0;
    if T then
    begin
      if ExecDriveProg(deTransfer, Chr(Lo(Z)) + Chr(Hi(Z)) + Chr(Lo(M)) + Chr(Hi(M))) then
      begin
        asm
          les si, B;
          mov di, M;
          push word ptr CopyPriorityMode;
          call InterruptOff;
          call ParallelOutput;
      @1: mov al, es:[si];
          call TSend;
          cmp Status, 0;
          jne @2;
          inc si;
          dec di;
          jne @1;
      @2: mov ax, 50;
          call Delay;
          call ParallelInput;
          call InterruptOn;
        end;
        TurboOff;
      end;
    end
    else
    begin
      S := 'M-W';
      X := 0;
      Y := M;
      while (Y > 0) and (Status = 0) do
      begin
        S[4] := Chr(Lo(Z));
        S[5] := Chr(Hi(Z));
        S[6] := #32;
        if Y < 32 then S[6] := Chr(Y);
        S[0] := Chr(Ord(S[6]) + 6);
        Move(B^[X], S[7], Ord(S[6]));
        OpenCBMChannel(saCommand, S, True);
        Inc(X, 32);
        Inc(Z, 32);
        Dec(Y, Ord(S[6]));
      end;
    end;
    Dispose(B);
    SetMouse;
    SetClock;
    SendDriveProg := (Status = 0);
  end;
end;

{Execute a drive program in the external CBM drive
  Input : ProgNum: the number of the program to be executed
          Params: parameters to be added to the disk command
  Output: when True, no error occured during the transmission}
function ExecDriveProg(ProgNum: Byte; const Params: string): Boolean;
var
  N             : Byte;
  W             : Word;
begin
  N := ProgNum;
  if ExternalDrive = xd1581 then Inc(N, deEntryNum);
  TurboOffed := False;
  W := TransferExecs[N] shl 4;
  OpenCBMChannel(saCommand, 'M-E' + Chr(Lo(W)) + Chr(Hi(W)) + Params, True);
  asm
    mov ax, 1000;
    call Delay;
  end;
  ExecDriveProg := (Status = 0);
end;

{Check if the specified drive exists
  Input : Drive: the letter or device number of the drive
  Output: when True, the drive exists}
function DriveValid(Drive: Char): Boolean;
var
  O             : Boolean;
  S             : array [0..49] of Char;
begin
  O := True;
  if not (Drive in ['8', '9', '0', '1']) then
  begin
    if OperatingSystem and osWindowsNT = 0 then
    begin
      asm
        push ds;
        mov dl, Drive;
        sub dl, 'A';
        mov ah, $19;
        int $21;
        push ax;
        mov ah, $0E;
        int $21;
        mov ah, $19;
        int $21;
        cmp al, dl;
        pop dx;
        pushf;
        mov ah, $0E;
        int $21;
        popf;
        je @1;
        mov O, False;
    @1:
      end;
    end
    else
    begin
      asm
        mov al, Drive;
        mov byte ptr S[0], al;
        mov word ptr S[1], ':';
        push ds;
        push ss;
        pop ds;
        lea si, S;
        push ss;
        pop es;
        lea di, S[18];
        mov ax, $2900;
        int $21;
        pop ds;
        test al, al;
        je @1;
        mov O, False;
    @1:
      end;
    end;
    if O and (Drive in ['A', 'B']) then
    begin
      asm
        mov bl, Drive;
        sub bl, 'A' - 1;
        mov bh, 3;
        sub bh, bl;
        mov ax, $440E;
        int $21;
        jnc @1;
        mov al, 0;
    @1: cmp al, bh;
        jne @2;
        mov O, False;
    @2:
      end;
    end;
  end;
  DriveValid := O;
end;

{Determine if a year is a leap year
  Input : Year: the year
  Output: when True, that year is a leap year (wrong for the year 2100)}
function IsLeapYear(Year: Word): Boolean;
begin
  IsLeapYear := (Year and 3 = 0);
end;

{Determine if daylight savings is in effect for a given date
  Input : Year: year part of the date
          Month: month part of the date
          Day: day part of the date; if month part is zero then the day part
               contains the number of days passed since the beginning of the
               year
          Hour: hour part of the date
  Output: when True, daylight savings is in effect}
function IsDST(Year, Month, Day, Hour: Word): Boolean;
var
  B,
  L             : Boolean;
  W             : Word;
begin
  L := IsLeapYear(Year);
  if Month = moZero then
  begin
    W := Day;
    if (Day >= (MonthFirstDay[moJanuary] + MonthFirstDay[moFebruary])) and L then Dec(W);
    Month := moZero;
    while W >= MonthFirstDay[Month] do Inc(Month);
  end
  else
  begin
    Inc(Day, MonthFirstDay[Month - 1]);
    if (Month > moMarch) and L then Inc(Day);
  end;
(* ?ASM? *)
  asm
    cmp Month, moApril;
    jb @2;
    je @3;
    cmp Month, moOctober;
    ja @2;
    jne @4;
@3: mov bx, Month;
    dec bx;
    shl bx, 1;
    cmp Year, 1986;
    jle @5;
    cmp Month, moApril;
    jne @5;
    mov cx, word ptr MonthFirstDay[bx][-2];
    add cx, 7;
    jmp @6;
@5: mov cx, word ptr MonthFirstDay[bx];
@6: cmp L, False;
    jne @7;
    dec cx;
@7: mov bx, Year;
    inc bx;
    sar bx, 2;
    add bx, cx;
    mov ax, DayPerYear;
    mov dx, Year;
    sub dx, UnixYearEpoch;
    mul dx;
    add ax, bx;
    add ax, daThursday;
    xor dx, dx;
    mov bx, DayPerWeek;
    div bx;
    sub cx, dx;
    mov ax, Day;
    cmp Month, moApril;
    jne @8;
    cmp ax, cx;
    ja @4;
    jne @2;
    cmp Hour, 2;
    jb @2;
    jmp @4;
@8: cmp ax, cx;
    jb @4;
    jne @2;
    cmp Hour, 1;
    ja @2;
@4: mov al, True;
    jmp @1;
@2: mov al, False;
@1: mov B, al;
  end;
  IsDST := B;
end;

{Convert the DOS time stamp to Unix style
  Input : Time: the DOS time stamp
  Output: the Unix time stamp}
function DOSToUnix(Time: Longint): Longint;
var
  W             : Word;
  L,
  X,
  Y             : Longint;
  T             : DateTime;
begin
  UnpackTime(Time, T);
  with T do
  begin
    L := ((EpochDiffDays * HourPerDay * MinPerHour * SecPerMin) + (TimeZone * (MinPerHour * SecPerMin)));
    Dec(Year, DOSYearEpoch);
    Inc(L, (Year shr 2) * (DayPerFourYear * HourPerDay * MinPerHour * SecPerMin));
    Inc(L, (Year and 3) * (DayPerYear * HourPerDay * MinPerHour * SecPerMin));
    if IsLeapYear(Year) then Inc(L, HourPerDay * MinPerHour * SecPerMin);
    X := 0;
    W := Month;
    while W > moJanuary do
    begin
      Dec(W);
      Inc(X, DayPerMonth[W]);
    end;
    Inc(X, Day - 1);
    if (Month > moFebruary) and IsLeapYear(Year) then Inc(X);
    Y := X * HourPerDay + Hour;
    if DayLight and IsDST(Year, moZero, X, Hour) then Dec(Y);
    Inc(L, Y * (MinPerHour * SecPerMin) + Min * MinPerHour + Sec);
  end;
  DOSToUnix := L;
end;

{Convert the Unix time stamp to DOS style
  Input : Time: the Unix time stamp
  Output: the DOS time stamp}
function UnixToDOS(Time: Longint): Longint;
var
  O             : Boolean;
  L             : Longint;
  T             : DateTime;
begin
  O := True;
  Dec(Time, ((EpochDiffDays * HourPerDay * MinPerHour * SecPerMin) + (TimeZone * (MinPerHour * SecPerMin))));
  with T do
  begin
    Sec := Time mod SecPerMin;
    Time := Time div SecPerMin;
    Min := Time mod MinPerHour;
    Time := Time div MinPerHour;
    Year := DOSYearEpoch + ((Time div (DayPerFourYear * HourPerDay)) shl 2);
    Time := Time mod (DayPerFourYear * HourPerDay);
    if Time >= (DayPerLeapYear * HourPerDay) then
    begin
      Dec(Time, DayPerLeapYear * HourPerDay);
      Inc(Year);
      Inc(Year, Time div (DayPerYear * HourPerDay));
      Time := Time mod (DayPerYear * HourPerDay);
    end;
    if DayLight and IsDST(Year, moZero, Time div HourPerDay, Time mod HourPerDay) then Inc(Time);
    Hour := Time mod HourPerDay;
    Time := Time div HourPerDay;
    Inc(Time);
    if IsLeapYear(Year) then
    begin
      if Time > (MonthFirstDay[moJanuary] + MonthFirstDay[moFebruary]) then
      begin
        Dec(Time);
      end
      else
      begin
        if Time = (MonthFirstDay[moJanuary] + MonthFirstDay[moFebruary]) then
        begin
          Month := moFebruary;
          Day := (MonthFirstDay[moFebruary] + 1);
          O := False;
        end;
      end;
    end;
    if O then
    begin
      Month := moJanuary;
      while DayPerMonth[Month] < Time do
      begin
        Dec(Time, DayPerMonth[Month]);
        Inc(Month);
      end;
      Day := Time;
    end;
  end;
  PackTime(T, L);
  UnixToDOS := L;
end;

{Get the current time in the form of a DOS time stamp}
function LocalTime: Longint;
var
  W             : Word;
  L             : Longint;
  T             : DateTime;
begin
  with T do
  begin
    GetDate(Year, Month, Day, W);
    GetTime(Hour, Min, Sec, W);
    PackTime(T, L);
  end;
  LocalTime := L;
end;

{Extract the date or time from a string
  Input : T: the date or time
          A: the word to contain the year or hour
          B: the word to contain the month or minute
          C: the word to contain the day or second
          Date: when True, a date is being processed; otherwise a time
  Output: when False, an error occured}
function MakeTime(const T: string; var A, B, C: Word; Date: Boolean): Boolean;
var
  F,
  O             : Boolean;
  P,
  Q,
  R             : Byte;
  S,
  X             : Char;
  D,
  E             : Word;
  N             : string;
  W             : array [0..2] of Word;

{Process the date or time with the current regional settings}
procedure ProcessTime;
begin
  O := True;
  N := S + T;
  P := 0;
  if Date then P := MaxByte;
  FillChar(W, 3 * SizeOf(Word), P);
  P := 0;
  Q := 2;
  F := True;
  if not Date then
  begin
    X := LoCase(N[Length(N)]);
    if X in ['a', 'p'] then Dec(N[0]) else X := 'a';
  end;
  while (Q <= Length(N)) and O do
  begin
    if N[Q] = S then
    begin
      if (N[Q - 1] = S) or (P = 2) then
      begin
        O := False;
      end
      else
      begin
        Inc(P);
        F := True;
      end;
    end
    else
    begin
      if N[Q] in ['0'..'9'] then
      begin
        if F then W[P] := 0;
        W[P] := W[P] * 10 + (Ord(N[Q]) - Ord('0'));
        if W[P] >= 10000 then O := False;
        F := False;
      end
      else
      begin
        O := False;
      end;
    end;
    Inc(Q);
  end;
  if O then
  begin
    case D of
      dfDDMMYY:
      begin
        E := W[2];
        B := W[1];
        C := W[0];
      end;
      dfYYMMDD:
      begin
        E := W[0];
        B := W[1];
        C := W[2];
      end;
    else
      E := W[2];
      B := W[0];
      C := W[1];
    end;
  end;
  if Date then
  begin
    O := (E < (NewCentury - OldCentury)) or (E >= DOSYearEpoch);
    if O then
    begin
      if E < OldYearLimit then Inc(E, (NewCentury - OldCentury));
      if E < DOSYearEpoch then Inc(E, OldCentury);
    end;
  end
  else
  begin
    if E = (HourPerDay shr 1) then E := 0;
    if X = 'p' then Inc(E, (HourPerDay shr 1));
    if E = HourPerDay then E := 0;
  end;
  A := E;
  if O then
  begin
    if Date then
    begin
      O := (A >= DOSYearEpoch) and (A <= DOSYearEnd) and (B >= moJanuary) and (B <= moDecember);
      if O then
      begin
        D := DayPerMonth[B];
        if (B = moFebruary) and IsLeapYear(A) then Inc(D);
        O := (C <= D);
      end;
    end
    else
    begin
      O := (A <= HourPerDay) and (B < MinPerHour) and (C < SecPerMin);
    end;
  end;
end;

begin
  if Date then
  begin
    S := DateSep;
    D := DateFormat;
  end
  else
  begin
    S := TimeSep;
    D := dfYYMMDD;
  end;
  ProcessTime;
  if not O then
  begin
    if Date then S := ISODateSep else S := ISOTimeSep;
    D := dfYYMMDD;
    ProcessTime;
  end;
  MakeTime := O;
end;

{Convert a disk ID code into a PETSCII string
  Input : ID: pointer to the ID code
          GEOS: when True, the ID code is from a GEOS disk
  Output: the ID code in string form}
function MakeIDString(ID: PByte; GEOS: Boolean): string;
var
  W             : Word;
  S             : string[CBMHeaderIDLen];
begin
  S[0] := Chr(CBMHeaderIDLen);
  for W := 1 to CBMHeaderIDLen do
  begin
    S[W] := Chr(ID^);
    Inc(ID);
  end;
  MakeIDString := MakeCBMName(S, GEOS);
end;

(* ?ASM? *)
{Create a PC64-style file name out of the original CBM file name
  Input : Name: original file name
  Output: PC64-style file name}
function MakePC64Name(const Name: string): string;
var
  S             : string;
begin
  S := Name;
  asm
    push ds;
    push bp;
    push ss;
    pop ds;
    push ss;
    pop es;
    lea si, S;
    mov di, si;
    cld;
    lodsb;
    stosb;
    mov cl, al;
    xor ch, ch;
    mov bx, cx;
    mov dx, cx;
    or cx, cx;
    jne @6;
    jmp @7;
@6: lodsb;
    cmp al, ' ';
    je @1;
    cmp al, '-';
    jne @2;
@1: mov al, '_';
    jmp @4;
@2: cmp al, 'a';
    jb @3;
    cmp al, 'z';
    ja @3;
    sub al, 'a' - 'A';
    jmp @4;
@3: cmp al, '0';
    jb @5;
    cmp al, '9';
    jbe @4;
    cmp al, 'A';
    jb @5;
    cmp al, 'Z';
    jbe @4;
@5: xor al, al;
    dec bl;
@4: stosb;
    loop @6;
    cmp bl, 8;
    jbe @7;
    dec si;
    mov bp, si;
    mov di, bp;
    mov cx, dx;
    std;
@9: lodsb;
    cmp al, '_';
    jne @8;
    xor al, al;
    dec bl;
@8: stosb;
    cmp bl, 8;
    jbe @7;
    loop @9;
    pop ax;
    push ax;
    mov si, ax;
    add si, Offset(S[1]);
    mov cx, dx;
    cld;
@14:lodsb;
    call @11;
    jne @13;
    loop @14;
    jmp @15;
@13:mov si, bp;
    mov di, bp;
    std;
@17:lodsb;
    call @11;
    jne @16;
    xor al, al;
    dec bl;
@16:stosb;
    cmp bl, 8;
    jbe @7;
    loop @17;
@15:mov si, bp;
    mov di, bp;
    mov cx, dx;
    std;
@18:lodsb;
    cmp al, 'A';
    jb @19;
    cmp al, 'Z';
    ja @19;
    xor al, al;
    dec bl;
@19:stosb;
    cmp bl, 8;
    jbe @7;
    loop @18;
    pop bp;
    push bp;
    lea si, S[1];
    mov di, si;
    mov cx, dx;
    cld;
@20:lodsb;
    cmp al, '0';
    jb @21;
    cmp al, '9';
    ja @21;
    xor al, al;
    dec bl;
@21:stosb;
    cmp bl, 8;
    jbe @7;
    loop @20;
@7: pop bp;
    lea si, S;
    mov di, si;
    inc si;
    mov cx, dx;
    cld;
    or bl, bl;
    jne @24;
    mov al, 1;
    stosb;
    mov al, '_';
    stosb;
    jmp @25;
@24:mov al, bl;
    stosb;
@23:lodsb;
    or al, al;
    je @22;
    stosb;
@22:loop @23;
@25:pop ds;
    jmp @10;
@11:cmp al, 'A';
    je @12;
    cmp al, 'E';
    je @12;
    cmp al, 'I';
    je @12;
    cmp al, 'O';
    je @12;
    cmp al, 'U';
@12:retn;
@10:
  end;
  MakePC64Name := S;
end;

(* ?ASM? *)
{Read a number from an archive file
  Input : SI: offset of current character in the buffer
          CX: base number
  Output: AX:DX: longint read from the buffer
          BL: the character following the number
          CF: if 1 then an invalid character was found}
function ReadNum: Longint; assembler;
asm
@6: cmp byte ptr TempBuffer[si], ' ';
    jne @5;
    inc si;
    jmp @6;
@5: xor ax, ax;
    xor bx, bx;
@2: mov dl, byte ptr TempBuffer[si];
    test dl, dl;
    je @1;
    cmp dl, ' ';
    je @1;
    cmp dl, chReturn;
    je @1;
    cmp dl, 'a';
    jb @8;
    cmp dl, 'z';
    ja @8;
    sub dl, 'a' - 'A';
@8: sub dl, '0';
    cmp dl, 9;
    jbe @9;
    sub dl, 'A' - '0' - 10;
@9: cmp dl, cl;
    ja @3;
    xor dh, dh;
    mov di, dx;
    xor dx, dx;
    xchg ax, bx;
    mul cx;
    or dx, dx;
    jne @3;
    xchg ax, bx;
    mul cx;
    add bx, dx;
    jc @3;
    add ax, di;
    adc bx, 0;
    jc @3;
    inc si;
    jmp @2;
@1: cmp byte ptr TempBuffer[si], ' ';
    jne @7;
    inc si;
    jmp @1;
@7: mov dx, bx;
    mov bl, byte ptr TempBuffer[si];
    clc;
    jmp @4;
@3: stc;
@4:
end;

(* ?ASM? *)
{Write a number into an archive file
  Input : AX:DX: longint to be written into the file
          CX: base number
          DI: minimum number of characters; if number is shorter then
              spaces are prepended
          SI: offset of current character in the buffer}
procedure WriteNum; assembler;
asm
    push bp;
    and di, $000F;
    sub di, 2;
    jnc @6;
    xor di, di;
@6: mov bp, di;
    mov byte ptr TempBuffer[si], ' ';
    inc si;
    mov bx, dx;
    mov di, Offset(NumStr);
@2: xor dx, dx;
    xchg ax, bx;
    div cx;
    xchg ax, bx;
    div cx;
    add dl, '0';
    cmp dl, '9';
    jbe @5;
    add dl, 'A' - '0' - 10;
@5: mov [di], dl;
    inc di;
    or bp, bp;
    je @7;
    dec bp;
@7: mov dx, ax;
    or dx, bx;
    jne @2;
    mov al, ' ';
    or bp, bp;
    je @8;
@3: mov [di], al;
    inc di;
    dec bp;
    jne @3;
@8: mov bx, di;
    dec bx;
@4: mov al, [bx];
    mov byte ptr TempBuffer[si], al;
    dec bx;
    inc si;
    cmp bx, Offset(NumStr);
    jae @4;
@1: mov byte ptr TempBuffer[si], ' ';
    inc si;
    pop bp;
end;

{Create an LHA archive header}
procedure MakeLHAEntry;
begin
  Move(LHAEntry, TempBuffer[1], 20);
  Move(LHAEntry.Name, TempBuffer[21], Length(LHAEntry.Name) + 1);
(* ?ASM? *)
  asm
    mov di, Offset(TempBuffer[1]);
    mov cl, byte ptr LHAEntry.Name[0];
    add cl, 21;
    xor ch, ch;
    add di, cx;
    mov ax, LHAEntry.CRCCheck;
    mov [di], ax;
    xor ah, ah;
    inc cx;
    push cx;
    mov si, Offset(TempBuffer[2]);
    cld;
@1: lodsb;
    add ah, al;
    loop @1;
    mov byte ptr TempBuffer[1], ah;
    pop cx;
    mov byte ptr TempBuffer[0], cl;
  end;
end;

{Read an entry from a ZIP archive
  Input : F: the archive
          E: the ZIP entry
          S: the string to contain the file name
  Output: when False, an error occurred}
function ReadZIPEntry(var F: ExtFile; var E: TZIPEntry; var S: string): Boolean;
var
  O             : Boolean;
begin
  O := False;
  ExtBlockRead(F, E, SizeOf(TZIPEntry));
  if (E.Signature = ZIPDirSign) and (E.NameLen < MaxStrLen) then
  begin
    S[0] := Chr(E.NameLen);
    ExtBlockRead(F, S[1], E.NameLen);
    O := True;
  end;
  ReadZIPEntry := O;
end;

{Read a central directory entry from a ZIP archive
  Input : F: the archive
          E: the ZIP entry
          S: the string to contain the file name
  Output: when False, an error occurred}
function ReadZIPCDirEntry(var F: ExtFile; var E: TZIPCDirEntry; var S: string): Boolean;
var
  O             : Boolean;
begin
  O := False;
  ExtBlockRead(F, E, SizeOf(TZIPCDirEntry));
  if (E.Signature = ZIPCDirSign) and (E.NameLen < MaxStrLen) then
  begin
    S[0] := Chr(E.NameLen);
    ExtBlockRead(F, S[1], E.NameLen);
    O := True;
  end;
  ReadZIPCDirEntry := O;
end;

(* ?ASM? *)
{Compute the checksum of a TAR archive header and optionally store it
  Input : Store: when True, the checksum is stored into the header
  Output: the header checksum}
function ComputeTARCheck(Store: Boolean): Longint; assembler;
asm
    mov bx, $0100;
    xor dx, dx;
    xor ah, ah;
    mov si, Offset(TempBuffer);
    mov cx, $0094;
    cld;
@1: lodsb;
    add bx, ax;
    adc dx, 0;
    loop @1;
    add si, 8;
    mov cx, $0164;
@2: lodsb;
    add bx, ax;
    adc dx, 0;
    loop @2;
    mov ax, bx;
    cmp Store, False;
    je @3;
    push ax;
    push dx;
    mov si, $0094;
    mov cx, 8;
    mov di, 7;
    call WriteNum;
    mov byte ptr TempBuffer[$009A], 0;
    pop dx;
    pop ax;
@3:
end;

{Get the number of bytes padding the current file to a size of a multiple
  of 254
  Input : Size: current size of file
  Output: number of bytes to pad}
function PadSize(Size: Longint): Byte;
var
  B             : Byte;
begin
  B := Size mod 254;
  if B > 0 then B := 254 - B;
  PadSize := B;
end;

{Add the padding zeros to the end of the current archive to make its size
  a multiple of the block size
  Input : F: the archive file
          BlockSize: the block size}
procedure AddPadding(var F: ExtFile; BlockSize: Word);
var
  W             : Word;
begin
  W := ExtFilePos(F) mod BlockSize;
  if W > 0 then
  begin
    W := BlockSize - W;
    FillChar(TempBuffer, W, 0);
    ExtBlockWrite(F, TempBuffer, W);
  end;
end;

{Build the two-character disk type signature string of the BAM
  Input : DiskType: disk type
          ExtBAMMode: extended BAM mode
  Output: the disk type signature string}
function DiskTypeSignature(DiskType, ExtBAMMode: Byte): string;
begin
  DiskTypeSignature := '2A';
  case DiskType and dtTypeMask of
    dt1541Ext: if ExtBAMMode = xbPrologicDOS then DiskTypeSignature := '2P';
    dt1581: DiskTypeSignature := '3D';
  end;
end;

{Fill in the missing parts of a label
  Input : Name: the original label
          DiskType: disk type
          ExtBAMMode: extended BAM mode
  Output: the corrected label}
function CorrectBAMLabel(const Name: string; DiskType, ExtBAMMode: Byte): string;
var
  P             : Byte;
  S             : string[2];
  I,
  J             : string[CBMBAMIDLen];
  L             : string[CBMNameLen];
  N             : string;

{Fill a string up with shift-spaces to the maximum length
  Input : Str: the string to process
          Len: the maximum length of the string}
procedure TrailShiftSpaces(var Str: string; Len: Byte);
begin
  while Length(Str) < Len do Str := Str + chShiftSpace;
end;

begin
  N := Name;
  P := RightPos(',', N);
  if P = 0 then P := Length(N) + 1;
  L := Copy(N, 1, P - 1);
  TrailShiftSpaces(L, CBMNameLen);
  J := Copy(N, P + 1, MaxStrLen);
  S := DiskTypeSignature(DiskType, ExtBAMMode);
  I := '00' + chShiftSpace + S;
  Move(J[1], I[1], Length(J));
  TrailShiftSpaces(I, CBMBAMIDLen);
  CorrectBAMLabel := L + ',' + I;
end;

{Create a string containing a 1541-style read error message
  Input : Code: the read error code
          Track, Sector: the position where the error occured}
function ReadErrorStr(Code, Track, Sector: Byte): string;
var
  S             : string[20];
begin
  case Code of
    72: S := 'DISK FULL';
  else
    S := 'READ ERROR';
  end;
  ReadErrorStr := LeadingZero(Code, 2) + ',' + S + ',' + LeadingZero(Track, 2) + ',' + LeadingZero(Sector, 2);
end;

{Convert drive error code into job status code
  Input : Error: drive error code
  Output: job status code}
function ErrorCodeToStatus(Error: Byte): Byte;
begin
  ErrorCodeToStatus := ds20READ;
  case Error of
    0: ErrorCodeToStatus := dsOK;
    74: ErrorCodeToStatus := ds74NOTREADY;
    20..29: ErrorCodeToStatus := Error - (20 - ds20READ);
  end;
end;

{Convert job status code into drive error code
  Input : Error: job status code
  Output: drive error code}
function ErrorStatusToCode(Error: Byte): Byte;
begin
  ErrorStatusToCode := 0;
  case Error of
    dsOK: ErrorStatusToCode := 0;
    ds74NOTREADY: ErrorStatusToCode := 74;
    ds20READ..ds29DISKID: ErrorStatusToCode := Error + (20 - ds20READ);
  end;
end;

{Check if there is a disk in the specified drive; if not, allow the user to
  retry
  Input : Path: the current path of the current drive
  Output: when False, there is no disk in the drive}
function DriveOK(var Path: string): Boolean;
var
  O             : Boolean;
  C             : Char;
  X,
  Z             : Integer;
  D             : PDialog;
  I             : PDriveInput;
  S             : string;
  R             : TRect;
  E             : Registers;
begin
  repeat
    C := Path[1];
    if (C >= '0') and (C <= '9') then
    begin
      O := True;
      FailSysErrors := fsNone;
    end
    else
    begin
      GetClock(False);
      FailSysErrors := fsDiskChange;
      S := LongGetDir(Ord(C) - Ord('@'));
      X := IOResult;
      FailSysErrors := fsAll;
      if X = 0 then
      begin
        LongChDir(S);
        X := IOResult;
      end;
      O := (X = 0);
      if O then
      begin
        FailSysErrors := fsNone;
      end
      else
      begin
        SysErrorOccurred := False;
        ClockOn;
        ChangeHelpCtx(hcOnlyQuit);
        GoSound := True;
        X := 41;
        MakeWinBounds(R, X + 2, 3);
        Z := X shr 1;
        Inc(R.A.Y, ErrorDown);
        D := New(PDialog, Init(R, stError, fxNormal, fyNormal, False));
        R.Assign(10, 2, 31, 1);
        D^.Insert(New(PStaticText, Init(R, 'Can''t read the disk in drive ' + C + ':')));
        R.Assign(6, 3, 39, 1);
        D^.Insert(New(PStaticText, Init(R, 'Press ENTER to try again, ESC to abort,')));
        R.Assign(5, 4, 41, 1);
        D^.Insert(New(PStaticText, Init(R, 'or enter a different drive letter here  :')));
        R.Assign(44, 4, 1, 1);
        I := New(PDriveInput, Init(R, 1, 1, stEmpty, drNone));
        I^.CursorStill := True;
        I^.SetState(sfCursorIns, False);
        S := C;
        I^.SetData(S);
        D^.Insert(I);
        D^.HelpCtx := hcOnlyQuit;
        D^.Palette := wpError;
        if Application^.ExecView(D, True, True) = cmOK then
        begin
          I^.GetData(S);
          Path[1] := S[1];
        end
        else
        begin
          FailSysErrors := fsNone;
        end;
        Dispose(D, Done);
        SetClock;
        SysError := False;
        RestoreHelpCtx;
      end;
    end;
  until FailSysErrors = fsNone;
  DriveOK := O;
end;

{Display an information window on the screen
  Input : Title: the title of the dialog box
          Text1: first line of information
          Text2: second line of information (not displayed if empty)
          Text3: third line of information (not displayed if empty)
          Heigth: minimal vertical size of the dialog box
  Output: the dialog box}
function InfoWin(const Title: string; Text1, Text2, Text3: string; Heigth: Integer): PDialog;
var
  X,
  Y             : Integer;
  D             : PDialog;
  T             : string;
  R             : TRect;
begin
  ErrorDown := 5;
  T := Title;
  if T = '' then T := BoxTitle;
  Text1 := LimitNameLen(Text1, MaxNameLen);
  Text2 := LimitNameLen(Text2, MaxNameLen);
  Text3 := LimitNameLen(Text3, MaxNameLen);
  X := Length(T) + 4;
  if X < CBMStrLen(Text1) then X := CBMStrLen(Text1);
  if X < CBMStrLen(Text2) then X := CBMStrLen(Text2);
  if X < CBMStrLen(Text3) then X := CBMStrLen(Text3);
  MakeWinBounds(R, X + 2, Heigth);
  D := New(PDialog, Init(R, T, fxNormal, fyNormal, False));
  R.Assign((X - CBMStrLen(Text1) + Justify) shr 1 + 5, 2, CBMStrLen(Text1), 1);
  D^.Insert(New(PCBMText, Init(R, Text1)));
  if Text2 <> '' then
  begin
    R.Assign((X - CBMStrLen(Text2) + Justify) shr 1 + 5, 3, CBMStrLen(Text2), 1);
    D^.Insert(New(PCBMText, Init(R, Text2)));
    if Text3 <> '' then
    begin
      R.Assign((X - CBMStrLen(Text3) + Justify) shr 1 + 5, 4, CBMStrLen(Text3), 1);
      D^.Insert(New(PCBMText, Init(R, Text3)));
    end;
  end;
  Application^.Insert(D);
  InfoWin := D;
end;

{Display a disk error message box on the screen
  Input : Title: the title of the dialog box
          Text1: first line of error message
          Text2: second line of error message (not displayed if empty)
          Help: help context for the dialog box
          Skip: when True, the user is allowed to skip a block
          Track: when True, the user is allowed to skip a track
          SkipAuto: when True, the user is allowed to have all bad blocks
                    and tracks automatically skipped
  Output: when cmOK, the user pressed OK, otherwise all further
          operations are cancelled}
function DiskErrorWin(const Title: string; Text1, Text2: string; Help: Word; Skip, Track, SkipAuto: Boolean): Word;
var
  O             : Boolean;
  B             : Byte;
  C,
  H             : Word;
  X,
  Y,
  Z             : Integer;
  D             : PDialog;
  T             : string;
  R             : TRect;
begin
  H := CurHelpCtx;
  O := HelpCtxSet;
  HelpCtxSet := True;
  CurHelpCtx := Help;
  AppHelpCtx := Help;
  LastShiftState := MaxByte;
  T := Title;
  if T = '' then T := BoxTitle;
  Text1 := LimitNameLen(Text1, MaxNameLen);
  Text2 := LimitNameLen(Text2, MaxNameLen);
  X := CBMStrLen(Text1);
  if X < CBMStrLen(Text2) then X := CBMStrLen(Text2);
  Y := 0;
  if Skip then Inc(Y, 7);
  if Track then Inc(Y, 13);
  if SkipAuto then Inc(Y, 12);
  if X < Y + 16 then X := Y + 16;
  MakeWinBounds(R, X + 2, 3);
  Z := (X - 15 - Y) shr 1 + 5;
  Inc(R.A.Y, ErrorDown);
  GetClock(True);
  GetMouse(True);
  D := New(PDialog, Init(R, T, fxNormal, fyNormal, False));
  R.Assign((X - CBMStrLen(Text1) + Justify) shr 1 + 5, 2, CBMStrLen(Text1), 1);
  D^.Insert(New(PCBMText, Init(R, Text1)));
  R.Assign((X - CBMStrLen(Text2) + Justify) shr 1 + 5, 3, CBMStrLen(Text2), 1);
  D^.Insert(New(PCBMText, Init(R, Text2)));
  X := 0;
  if Skip then
  begin
    X := 7;
    R.Assign(Z + 8, 4, 6, 1);
    D^.Insert(New(PButton, Init(R, stSkip, cmNo)));
  end;
  if Track then
  begin
    R.Assign(Z + X + 8, 4, 12, 1);
    D^.Insert(New(PButton, Init(R, ' skip '+ColorChar+'T'+ColorChar+'rack ', cmYes)));
    Inc(X, 13);
  end;
  if SkipAuto then
  begin
    R.Assign(Z + X + 8, 4, 11, 1);
    D^.Insert(New(PButton, Init(R, ' skip '+ColorChar+'A'+ColorChar+'uto ', cmExtra)));
    Inc(X, 12);
  end;
  R.Assign(Z + Y + 8, 4, 8, 1);
  D^.Insert(New(PButton, Init(R, stCancel, cmCancel)));
  R.Assign(Z, 4, 7, 1);
  D^.Insert(New(PButton, Init(R, stRetry, cmOK)));
  D^.Palette := wpError;
  if MakeSound then GoSound := True;
  MakeSound := True;
  C := Application^.ExecView(D, True, True);
  Dispose(D, Done);
  DiskErrorWin := C;
  SetMouse;
  SetClock;
  CurHelpCtx := H;
  AppHelpCtx := H;
  HelpCtxSet := O;
  LastShiftState := MaxByte;
end;

{Return the name of screen color modes
  Input : ScreenColor: the screen color mode
  Output: the name of the screen color mode}
function ScreenColorStr(ScreenColor: Byte): string;
begin
  ScreenColorStr := '';
  case ScreenColor of
    apBlackWhite: ScreenColorStr := 'Black & White';
    apColor: ScreenColorStr := 'Color';
    apLaptop: ScreenColorStr := 'Laptop';
  end;
end;

{Return the name of DOS types
  Input : DOSType: the DOS type code
  Output: the name of the DOS type}
function DOSTypeStr(DOSType: Byte): string;
begin
  DOSTypeStr := '';
  case DOSType of
    xbSpeedDOS: DOSTypeStr := 'Speed DOS';
    xbDolphinDOS: DOSTypeStr := 'Dolphin DOS';
    xbPrologicDOS: DOSTypeStr := 'Prologic DOS';
  end;
end;

{Return the name of character conversion modes
  Input : CharConvMode: the character conversion mode
  Output: the name of the character conversion mode}
function CharConvModeStr(CharConvMode: Byte): string;
begin
  CharConvModeStr := '';
  case CharConvMode of
    ccNone: CharConvModeStr := 'None';
    ccInvalid: CharConvModeStr := 'Invalid';
    ccInvalidAndSpace: CharConvModeStr := 'Inv+Spc';
  end;
end;

{Return the name of transfer modes
  Input : TransferMode: the number of the transfer mode
  Output: the name of the transfer mode}
function TransferModeStr(TransferMode: Byte): string;
begin
  TransferModeStr := '';
  case TransferMode of
    tmNormal: TransferModeStr := 'Normal';
    tmTurbo: TransferModeStr := 'Turbo';
    tmWarp: TransferModeStr := 'Warp';
  end;
end;

{Return the name of serial cables
  Input : SerialCable: the number of the serial cable
  Output: the name of the serial cable}
function SerialCableStr(SerialCable: Byte): string;
begin
  SerialCableStr := '';
  case SerialCable of
    scNone: SerialCableStr := 'None';
    scNormal: SerialCableStr := 'X1541';
    scExtended: SerialCableStr := 'XE1541';
    scMultitask: SerialCableStr := 'XM1541';
    scActive: SerialCableStr := 'XA1541';
    scOpenCBM: SerialCableStr := 'OpenCBM';
  end;
end;

{Return the name of parallel cables
  Input : ParallelCable: the number of the parallel cable
  Output: the name of the parallel cable}
function ParallelCableStr(ParallelCable: Byte): string;
begin
  ParallelCableStr := '';
  case ParallelCable of
    pcNone: ParallelCableStr := 'None';
    pcHybrid: ParallelCableStr := 'XH15x1';
    pcParallel: ParallelCableStr := 'XP15x1';
  end;
end;

{Return the name of async transfer
  Input : ParallelCable: the number of the async transfer
  Output: the name of the async transfer}
function AsyncTransferStr(AsyncTransfer: Byte): string;
begin
  AsyncTransferStr := '';
  case AsyncTransfer of
    atNever: AsyncTransferStr := 'Never';
    atAlways: AsyncTransferStr := 'Always';
    atAuto: AsyncTransferStr := 'Auto';
  end;
end;

{Return the name of port mode detection mode
  Input : ParallelCable: the number of the port mode detection mode
  Output: the name of the port mode detection mode}
function DetectPortModeStr(DetectPortMode: Byte): string;
begin
  DetectPortModeStr := '';
  case DetectPortMode of
    dpNone: DetectPortModeStr := 'None';
    dpAll: DetectPortModeStr := 'All';
    dpUsed: DetectPortModeStr := 'Used';
    dpSafeAll: DetectPortModeStr := 'SafeAll';
    dpSafeUsed: DetectPortModeStr := 'SafeUsed';
  end;
end;

{Return the name of command execution modes
  Input : CmdExecMode: the number of the command execution mode
  Output: the name of the command execution mode}
function CmdExecModeStr(CmdExecMode: Byte): string;
begin
  CmdExecModeStr := '';
  case CmdExecMode of
    cxNormal: CmdExecModeStr := 'Normal';
    cxTurbo: CmdExecModeStr := 'Turbo';
    cxWarp: CmdExecModeStr := 'Warp';
  end;
end;

{Return the name of into file image modes
  Input : IntoImageMode: the into file image mode code
  Output: the name of the into file image mode}
function IntoImageModeStr(IntoImageMode: Byte): string;
begin
  IntoImageModeStr := '';
  case IntoImageMode of
    ifNever: IntoImageModeStr := 'Never';
    ifAlways: IntoImageModeStr := 'Always';
    ifCBMSrc: IntoImageModeStr := 'CBM src';
  end;
end;

{Return the name of extract file image modes
  Input : ExtractImageMode: the extract file image mode code
  Output: the name of the extract file image mode}
function ExtractImageModeStr(ExtractImageMode: Byte): string;
begin
  ExtractImageModeStr := '';
  case ExtractImageMode of
    xfNever: ExtractImageModeStr := 'Never';
    xfAlways: ExtractImageModeStr := 'Always';
    xfCBMDest: ExtractImageModeStr := 'CBM dest';
  end;
end;

{Return the name of extended disk modes
  Input : IntoImageMode: the into file image mode code
  Output: the name of the into file image mode}
function ExtendedDiskModeStr(ExtendedDiskMode: Byte): string;
begin
  ExtendedDiskModeStr := '';
  case ExtendedDiskMode of
    xtNever: ExtendedDiskModeStr := 'Never';
    xtAlways: ExtendedDiskModeStr := 'Always';
    xtDetect: ExtendedDiskModeStr := 'Detect';
  end;
end;

{Return the name of disk copy modes
  Input : DiskCopyMode: the disk copy mode code
  Output: the name of the disk copy mode}
function DiskCopyModeStr(DiskCopyMode: Byte): string;
begin
  DiskCopyModeStr := '';
  case DiskCopyMode of
    dcFull: DiskCopyModeStr := 'Full';
    dcBAM: DiskCopyModeStr := 'BAM';
    dcSafeBAM: DiskCopyModeStr := 'Safe BAM';
    dcManualSelect: DiskCopyModeStr := 'Manual';
  end;
end;

{Return the name of invalid GCR code error mode
  Input : DiskCopyMode: the invalid GCR code error code
  Output: the name of the invalid GCR code error mode}
function InvalidGCRCodeModeStr(InvalidGCRCodeMode: Byte): string;
begin
  InvalidGCRCodeModeStr := '';
  case InvalidGCRCodeMode of
    igNone: InvalidGCRCodeModeStr := 'None';
    ig23READ: InvalidGCRCodeModeStr := '23,READ ERROR';
    ig24READ: InvalidGCRCodeModeStr := '24,READ ERROR';
  end;
end;

{Determine if long file name support is installed
  Output: when True, long file names are supported}
function InitLongNames: Boolean; assembler;
var
  S,
  T             : string;
asm
    cmp LongNames, False;
    je @2;
    push ds;
    push ss;
    pop ds;
    push ss;
    pop es;
    lea si, S;
    mov byte ptr [si], 0;
    lea di, T;
    xor cl, cl;
    mov ch, $80;
    mov al, $60;
    call ExecLFN;
    pop ds;
    mov bl, True;
    mov bh, MaxStrLen;
    jnc @1;
    cmp ax, deNoLongNames;
    jne @1;
@2: mov bl, False;
    mov bh, MaxNameLen;
@1: mov LongFileNames, bl;
    mov MaxFileNameLen, bh;
end;

{Initialize country-dependent information and fetch currently displayed code
  page}
procedure InitCountry; assembler;
asm
    mov dx, Offset(GCRBuffer);
    mov ax, Seg(GCRBuffer);
    mov ds, ax;
    mov ax, $3800;
    int $21;
    mov ax, word ptr GCRBuffer[0];
    mov DateFormat, ax;
    mov al, byte ptr GCRBuffer[7];
    mov ThousandSep, al;
    mov al, byte ptr GCRBuffer[11];
    mov DateSep, al;
    mov al, byte ptr GCRBuffer[13];
    mov TimeSep, al;
    mov al, byte ptr GCRBuffer[17];
    mov MilitaryTime, al;
    push ds;
    pop es;
    mov cx, $80;
    mov ah, $80;
    mov si, Offset(LoCaseTable);
    mov di, Offset(UpCaseTable);
    push di;
    push cx;
    cld;
@1: mov al, ah;
    mov byte ptr [si], al;
    inc si;
    call dword ptr GCRBuffer[18];
    stosb;
    inc ah;
    loop @1;
    pop cx;
    pop si;
    xor bh, bh;
    mov ah, $80;
@3: lodsb;
    cmp al, ah;
    je @2;
    cmp al, $80;
    jb @2;
    mov bl, al;
    mov byte ptr LoCaseTable[bx - $80], ah;
@2: inc ah;
    loop @3;
    mov ax, $AD02;
    mov bx, MaxWord;
    stc;
    int $2F;
    jc @4;
    cmp bx, MaxWord;
    jne @5;
@4: mov bx, CodePageUS;
@5: mov CodePage, bx;
end;

{Read the contents of a user-defined menu or an extension file into the
  memory
  Input : Name: name of the files
          Menu: when True, a user menu file is read, otherwise an
                extension file
          Error: when True, on an error the user is warned
          Help: help context for the error message box
  Output: when not 0, an error occured}
function ReadUserFile(const Name: string; Menu, Error: Boolean; Help: Word): Integer;
var
  I             : Integer;
  S             : string;
begin
  ClockOff;
  I := LongOpenFile(AddToPath(HomePath, Name, chDirSep), ReadFile, fmReadOnly);
  if I = 0 then
  begin
    CopySize := ExtFileSize(ReadFile);
    if CopySize > TempBufferSize then CopySize := TempBufferSize;
    ExtBlockRead(ReadFile, GCRBuffer, CopySize);
    ExtClose(ReadFile);
  end
  else
  begin
    ClockOn;
    if Error then
    begin
      if Menu then S := 'menu' else S := 'extension';
      ErrorWin(stEmpty, 'Could not find the ' + S + ' file', AddToPath(HomePath, Name, chDirSep), Help, sbNone);
    end;
  end;
  CopiedSize := 0;
  FirstMenuLine := True;
  UserTitle := '';
  ReadUserFile := I;
end;

{Determine whether a character is an end-of-line mark or not
  Input : Ch: the character
  Output: when True, the character is an end-of-line mark}
function EOLMark(Ch: Char): Boolean;
begin
  EOLMark := (Ch in [chCR, chLF]);
end;

{Trim all leading and trailing white spaces from a string
  Input : Str: the original string
  Output: the trimmed string}
function AllTrim(Str: string): string;
begin
  while (Str <> '') and (Str[Length(Str)] in WhiteSpace) do Dec(Str[0]);
  while (Str <> '') and (Str[1] in WhiteSpace) do Str := Copy(Str, 2, MaxStrLen);
  AllTrim := Str;
end;

{Check if a comment line in the menu or extension file contains the title and,
  if so, extract it
  Input : Str: the comment line}
procedure CheckUserTitle(const Str: string);
begin
  if FirstMenuLine and (UpperCase(Copy(Str, 2, 5)) = 'TITLE') then
    UserTitle := AllTrim(Copy(Str, 8, MaxStrLen));
end;

{Parse a line of the user menu file
  Input : Line: string to contain the line
          Image: when True, the first line beginning with an exclamation
                 mark is considered to be the end of entries for the current
                 file format
  Output: when True, a title was read, otherwise a command}
function ParseMenu(var Line: string; Image: Boolean): Boolean;
var
  B,
  Q             : Boolean;
  I             : Byte;
  C             : Char;
  F             : TFileExtStr;
  S             : string;
begin
  Line := '';
  Q := False;
  while not Q and (CopiedSize < CopySize) do
  begin
    S := '';
    while (CopiedSize < CopySize) and not EOLMark(Chr(GCRBuffer[CopiedSize])) do
    begin
      S := S + Chr(GCRBuffer[CopiedSize]);
      Inc(CopiedSize);
    end;
    while (CopiedSize < CopySize) and EOLMark(Chr(GCRBuffer[CopiedSize])) do Inc(CopiedSize);
    B := False;
    I := 1;
    while not B and (I <= Length(S)) do
    begin
      B := not (S[I] in WhiteSpace);
      Inc(I);
    end;
    if B then
    begin
      C := S[1];
      if C = MenuComment then
      begin
        CheckUserTitle(S);
        B := False;
        Line := '';
      end
      else
      begin
        B := not (C in WhiteSpace);
        if Image and (C = '!') then
        begin
          B := False;
          CopiedSize := CopySize;
        end;
        if B then
        begin
          F := '';
          I := LeftPos(':', S);
          if I > 0 then F := Copy(S, 1, I - 1);
          if F = ':' then if S[2] <> ':' then F := '';
          if I = 0 then
          begin
            I := 1;
          end
          else
          begin
            while (I <= Length(S)) and (S[I - 1] <> ':') do Inc(I);
            while (I <= Length(S)) and (S[I] = ':') do Inc(I);
            while (I <= Length(S)) and (S[I] in WhiteSpace) do Inc(I);
          end;
          S := Copy(UpperCase(F) + '    ', 1, 4) + Copy(S, I, MaxNameLen);
        end
        else
        begin
          I := 1;
          while S[I] in WhiteSpace do Inc(I);
          S := Copy(S, I, MaxStrLen);
          if S[1] = SuppressOutputPrefix then
          begin
            I := 2;
            while S[I] in WhiteSpace do Inc(I);
            S := SuppressOutputPrefix + Copy(S, I, MaxStrLen);
          end;
        end;
        I := Length(S);
        while (I > 0) and (S[I] in WhiteSpace) do Dec(I);
        Line := Copy(S, 1, I);
        Q := True;
      end;
    end
    else
    begin
      S := '';
    end;
    FirstMenuLine := False;
  end;
  ParseMenu := B;
end;

{Parse a line of the extension file
  Input : Line: string to contain the line
          Image: when True, only lines beginning with an exclamation mark
                 are considered to be titles
  Output: when True, a title was read, otherwise a command}
function ParseExt(var Line: string; Image: Boolean): Boolean;
var
  B,
  F,
  Q             : Boolean;
  I,
  J             : Byte;
  C             : Char;
  W,
  X             : Word;
  E,
  S             : string;
begin
  Line := '';
  Q := False;
  while not Q and (CopiedSize < CopySize) do
  begin
    S := '';
    X := CopiedSize;
    W := MaxWord;
    while (CopiedSize < CopySize) and not EOLMark(Chr(GCRBuffer[CopiedSize])) do
    begin
      if (GCRBuffer[CopiedSize] = Ord(':')) and (W = MaxWord) then W := CopiedSize;
      S := S + Chr(GCRBuffer[CopiedSize]);
      Inc(CopiedSize);
    end;
    if W = MaxWord then W := CopiedSize;
    while (CopiedSize < CopySize) and EOLMark(Chr(GCRBuffer[CopiedSize])) do Inc(CopiedSize);
    B := False;
    I := 1;
    while not B and (I <= Length(S)) do
    begin
      B := not (S[I] in WhiteSpace);
      Inc(I);
    end;
    if B then
    begin
      C := S[1];
      B := False;
      if C = MenuComment then
      begin
        CheckUserTitle(S);
      end
      else
      begin
        B := not (C in WhiteSpace);
        if B and Image then B := (C = '!');
        if B then
        begin
          if Image then
          begin
            Inc(X);
            S := Copy(S, 2, MaxStrLen);
          end;
          I := LeftPos(':', S);
          J := LeftPos(';', S);
          if J = 0 then J := LeftPos(',', S);
          if (J = 0) or ((I > 0) and (J > I)) then
          begin
            CopiedSize := W + 1;
          end
          else
          begin
            I := J;
            CopiedSize := X + J;
            repeat
              C := Chr(GCRBuffer[CopiedSize]);
              F := ((C in WhiteSpace) or EOLMark(C));
              if F then Inc(CopiedSize);
            until not F or (CopiedSize >= CopySize);
          end;
          E := LowerCase(Copy(S, 1, I - 1));
          S := Copy(S, J + 1, CmdLineLen);
        end
        else
        begin
          E := '';
        end;
        Q := True;
        if B then
        begin
          Line := E;
        end
        else
        begin
          I := 1;
          while S[I] in WhiteSpace do Inc(I);
          S := Copy(S, I, MaxStrLen);
          if S[1] = SuppressOutputPrefix then
          begin
            I := 2;
            while S[I] in WhiteSpace do Inc(I);
            S := SuppressOutputPrefix + Copy(S, I, MaxStrLen);
          end;
          I := Length(S);
          while (I > 0) and (S[I] in WhiteSpace) do Dec(I);
          Line := Copy(S, 1, I);
        end;
      end;
    end
    else
    begin
      S := '';
    end;
    FirstMenuLine := False;
  end;
  ParseExt := B;
end;

{Find the specified file name pattern in the extension file
  Input : Pattern: the pattern to search for
          Image: when True, an image launch menu is being processed, items
                 with a leading exclamation mark are considered to be name
                 patterns
          AllFiles: set to True, if the matching pattern actually matches
                    all DOS files
  Output: when True, the pattern was found}
function FindPattern(const Pattern: string; Image: Boolean; var AllFiles: Boolean): Boolean;
var
  B,
  O             : Boolean;
  X             : Longint;
  E,
  L,
  S             : string;
begin
  O := False;
  S := LowerCase(Pattern);
  while (CopiedSize < CopySize) and not O do
  begin
    B := ParseExt(L, Image);
    if B then
    begin
      E := L;
      if RightPos('.', E) = 0 then E := '*.' + E;
      AllFiles := (E = stAllFilesDOS);
      O := CompareDOSEntry(E, S, True, False);
    end;
  end;
  X := CopiedSize;
  while (CopiedSize < CopySize) and B do
  begin
    X := CopiedSize;
    B := ParseExt(L, Image);
  end;
  CopiedSize := X;
  FindPattern := O;
end;

{Determine if a line in the user menu is empty or not
  Input : L: the string containing the line
  Output: when True, the line is not empty}
function NonEmptyLine(var L: string): Boolean;
var
  B             : Boolean;
  I             : Integer;
begin
  B := ((Length(L) > 2) and (L[1] = '"') and (L[Length(L)] = '"'));
  if B then
  begin
    L := Copy(L, 2, Length(L) - 2);
  end
  else
  begin
    I := 1;
    while (I <= Length(L)) and not (L[I] in WhiteSpace) do Inc(I);
    B := (I > Length(L));
  end;
  NonEmptyLine := B;
end;

{Read through the menu file and construct the user menu itself
  Input : Len: the variable to contain the length of the menu
          Items: the variable to contain the list of menu items
          Image: when True, the first line beginning with an exclamation
                 mark is considered to be the end of entries for the current
                 file format
          Menu: when True, the menu is read from a menu file, otherwise
                from an extension file
  Output: when True, at least one valid item was found}
function ConstructMenu(var Len: Integer; var Items: PHistoryItem; Image, Menu: Boolean): Boolean;
var
  B,
  F,
  G,
  H,
  O             : Boolean;
  W             : Word;
  Y             : Integer;
  C             : Longint;
  P             : PHistoryItem;
  E             : string[4];
  N,
  L             : string;

{Cut a string at a given number of characters
  Input : X: the number of characters to cut the string at}
procedure LimitStr(X: Byte);
begin
  if Length(L) > X then L[0] := Chr(X);
end;

begin
  O := True;
  Y := 0;
  W := CopiedSize;
  C := CopiedSize;
  G := False;
  H := True;
  while (Y < MaxMenuItems) and (CopiedSize < CopySize) do
  begin
    if Menu then
    begin
      B := ParseMenu(L, Image);
    end
    else
    begin
      B := FindPattern(SourceName, Image, F);
      G := G or F;
      if not F and H then G := False;
      H := H and F;
    end;
    if B and (not G or H) then Inc(Y);
  end;
  if Y = 0 then
  begin
    O := False;
  end
  else
  begin
    Len := 0;
    CopiedSize := C;
    P := nil;
    G := False;
    H := True;
    while Len < Y do
    begin
      if Menu then B := ParseMenu(L, Image) else B := FindPattern(SourceName, Image, F);
      G := G or F;
      if not F and H then G := False;
      H := H and F;
      if not Menu and B then
      begin
        B := not ParseExt(L, Image);
        if B then B := (not G or H);
      end;
      if B then
      begin
        Inc(Len);
        if Menu then
        begin
          E := Copy(L, 1, 4);
          L := Copy(L, 5, MaxStrLen);
          LimitStr(55);
        end
        else
        begin
          E := '';
          C := CopiedSize;
          if ParseExt(N, Image) or (CopiedSize >= CopySize) then
          begin
            LimitStr(60);
          end
          else
          begin
            LimitStr(56);
            L := L + ' ...';
          end;
          CopiedSize := C;
        end;
        P := NewHistoryItem(E, L, Len, Menu, P);
        if Len = 1 then Items := P;
      end;
    end;
  end;
  CopiedSize := W;
  ConstructMenu := O;
end;

{If a user title is present in the menu or extension file then force the
  title of the displayed menu to be the same
  Input : Title: the original title of the menu to be displayed}
procedure ForceUserTitle(var Title: string);
begin
  if UserTitle <> '' then Title := UserTitle;
end;

{Display the user menu, accept the choice of the user and optionally search
  for the first line belonging to the chosen item in the menu or extension
  file
  Input : Title: the title of the user menu
          Height: number of rows in the user menu
          Width: the minimum width of the user menu
          Start: the default item to select
          MenuType: type of the list attached to the menu: none, menu or
                    extension file
          Items: list of items
          Value: when not nil, the title of the selected item is placed into
                 this string
          Force: when True, the user menu is displayed even if it contains
                 only one item
          Hotkeys: when True, a user menu with hotkeys is displayed
  Output: when cmOK, the user confirms to execute the operation; when
          cmCancel, the user cancelled the operation}
function DisplayUserMenu(const Title: string; Height, Width, Start: Integer; MenuType: Byte; Items: PHistoryItem;
  Value: PString; Force, Hotkeys: Boolean): Word;
var
  B,
  F,
  G,
  H             : Boolean;
  C             : Word;
  I             : Integer;
  A             : PHistoryItem;
  D             : PHistory;
  L             : string;
  R             : TRect;
begin
  PriorityMenu := nil;
  if not Force and (Height = 1) then
  begin
    C := cmOK;
    HistoryItem := Items^.Code;
  end
  else
  begin
    if Height > MaxMenuItems then Height := MaxMenuItems;
    I := Length(Title) + 8;
    if I < Width then I := Width;
    R.Assign(4, 2, I + 2, Height + 2);
    D := New(PHistory, Init(R, Items, 0, Hotkeys));
    MakeWinBounds(R, D^.Size.X, Height);
    PriorityMenu := New(PDialog, Init(R, Title, fxNormal, fyNormal, False));
    PriorityMenu^.Insert(D);
    PriorityMenu^.Palette := wpHistory;
    while Start > 0 do
    begin
      if D^.CurItem = nil then Start := 1 else D^.CurItem := D^.CurItem^.Next;
      Dec(Start);
    end;
    if D^.CurItem = nil then D^.CurItem := D^.Items;
    C := Application^.ExecView(PriorityMenu, True, True);
  end;
  if (C = cmOK) and (HistoryItem >= 0) then
  begin
    G := False;
    H := True;
    I := -1;
    A := Items;
    repeat
      case MenuType of
        mtMenu: B := ParseMenu(L, False);
        mtExtension:
        begin
          B := FindPattern(SourceName, False, F);
          G := G or F;
          if not F and H then G := False;
          H := H and F;
        end;
      end;
      if (MenuType = mtNone) or (B and (not G or H)) then
      begin
        I := A^.Code;
        if I <> HistoryItem then A := A^.Next;
      end;
    until I = HistoryItem;
    if Value <> nil then Value^ := A^.Title;
  end;
  if PriorityMenu = nil then
  begin
    FreeHistoryItem(Items);
  end
  else
  begin
    Dispose(PriorityMenu, Done);
    PriorityMenu := nil;
  end;
  DisplayUserMenu := C;
end;

{Initialize the timer of the screen saver}
procedure InitSaver;
begin
  SaverTicks := SaverDelay * MinuteTicks;
  SaverCount := GetTicks;
end;

{Turn the screen saver on}
procedure SaverOn;
var
  R             : TRect;
begin
  MouseOff;
  R.Assign(0, 0, ScreenWidth, ScreenHeight);
  ScreenSaver := New(PScreenSaver, Init(R));
  Application^.Insert(ScreenSaver);
  SaverStarVis := 0;
  LastWhere := MouseWhere;
  SaverInUse := True;
end;

{Turn the screen saver off}
procedure SaverOff;
var
  B             : Byte;
begin
  SaverInUse := False;
  LastHalfSec := MaxByte;
  Dispose(ScreenSaver, Done);
  LastWhere := MouseWhere;
  MouseOn;
  RedrawAllViews;
end;

{Collect the address and mode of all parallel ports
  Input : Force: when true, the mode of all parallel ports is determined;
                 otherwise only those whose current mode is unknown}
procedure CollectLPTPorts(Force: Boolean);
var
  B             : Byte;
begin
  EnableLPTPorts;
  InitLPTBits;
  for B := 0 to MaxLPTPorts - 1 do
  begin
    if B < MaxRealPorts then LPTAddr := MemW[Seg0040:B shl 1 + 8] else LPTAddr := LPTAddresses[B];
    if not ValidLPTAddr(LPTAddr) then LPTAddr := 0;
    LPTAddresses[B] := LPTAddr;
    if ((not DetectPortModes in [dpSafeAll, dpSafeUsed]) or (OperatingSystem and osWindowsNT = 0)) and
      (DetectPortModes in [dpAll, dpSafeAll]) or ((DetectPortModes in [dpUsed, dpSafeUsed])
      and ((B = LPTNum) or (B = ParLPTNum))) then
    begin
      if Force or (LPTModes[B] = pmUnknown) then LPTModes[B] := GetLPTMode(LPTAddr);
    end
    else
    begin
      if LPTModes[B] = pmNone then LPTModes[B] := pmUnknown;
    end;
  end;
end;

{Recompute the delay value}
procedure Recalibrate;
var
  S             : string[3];
begin
  ComputeDelay;
  S := LeadingSpace(CopyDelayValue, 0);
  DelayValueInp^.SetData(S);
  DelayValueInp^.DrawView;
end;

{Select the item from a menu
  Input : Title: title of the menu
          First, Last: first and last value of items, inclusive
          FirstNum: number hotkey for first item
          Value: the number of the default item
          ItemStrProc: function to return names of items
  Output: when cmOK, the user confirms to execute the operation; when
          cmCancel, the user cancelled the operation}
function SelectMenuInputItem(const Title: string; First, Last, FirstNum, Value: Byte; ItemStrProc: TItemStrProc): Word;
var
  B,
  C             : Byte;
  A,
  P             : PHistoryItem;
begin
  P := nil;
  C := 0;
  for B := First to Last do
  begin
    P := NewHistoryItem(HexaStr(C + FirstNum, 1), ItemStrProc(B), B, True, P);
    if C = 0 then A := P;
    Inc(C);
  end;
  SelectMenuInputItem := DisplayUserMenu(Title, C, 0, Value, mtNone, A, nil, True, True);
end;

{Initialize the empty menu bar}
constructor TFalseMenu.Init;
var
  S             : string;
  R             : TRect;
begin
  R.Assign(0, 0, ScreenWidth, 1);
  S[0] := Chr(ScreenWidth);
  FillChar(S[1], Length(S), ' ');
  TStaticText.Init(R, S);
  GrowMode := gfGrowHiX;
end;

{Get the palette of the empty menu bar}
function TFalseMenu.GetPalette: PPalette;
const
  P: String[Length(CFalseMenu)] = CFalseMenu;
begin
  GetPalette := @P;
end;

{Draw the title bar}
procedure TTitle.Draw;
var
  A             : Byte;
  B             : TDrawBuffer;
begin
  A := GetColor(1);
  MoveChar(B, ' ', A, Size.X);
  MoveCBMStr(@B, Text^, A, False);
  WriteBuf(0, 0, Size.X, 1, B);
end;

{Initialize the history or menu
  Input : Bounds: bounds of the history or menu
          AItems: list of the items
          ItemNum: number of item to be activated first
          AHotKey: when True, pressing the hotkey will execute the item,
                   otherwise only places the cursor bar onto it}
constructor THistory.Init(var Bounds: TRect; AItems: PHistoryItem; ItemNum: Integer; AHotKey: Boolean);
var
  I,
  X             : Integer;
  P             : PHistoryItem;
begin
  P := AItems;
  X := 0;
  I := 0;
  while (P <> nil) do
  begin
    if X < Length(P^.Title) then X := Length(P^.Title);
    if I < Length(P^.HotStr) then I := Length(P^.HotStr);
    P := P^.Next;
  end;
  Inc(X, I);
  if not AHotKey or (X = 0) then Inc(X, 6) else Inc(X, 9);
  if Bounds.B.X < X then Bounds.B.X := X;
  TView.Init(Bounds);
  Options := Options or ofSelectable;
  EventMask := EventMask or evBroadcast;
  HotWidth := I;
  Items := AItems;
  CurItem := Items;
  if ItemNum > 0 then for I := 1 to ItemNum do CurItem := CurItem^.Next;
  HotKey := AHotKey;
  HistoryItem := -1;
  ViewType := vtHistory;
end;

{Deallocate the memory used by the history or menu and its items}
destructor THistory.Done;
begin
  TView.Done;
  FreeHistoryItem(Items);
end;

{Handle history or menu events
  Input : Event: event record to be handled}
procedure THistory.HandleEvent(var Event: TEvent);
var
  F,
  O             : Boolean;
  B             : Byte;
  W             : Word;
  P             : PHistoryItem;
  T             : TPoint;
begin
  F := False;
  O := False;
  if Event.What and evKeyboard > 0 then
  begin
    P := nil;
    W := Event.KeyCode;
    B := 0;
    case W of
      kbEnter, kbCtrlEnter:
      begin
        CtrlEnter := (W = kbCtrlEnter);
        if not Hotkey or not CtrlEnter then
        begin
          P := Items;
          B := 1;
          while (P <> nil) and (P <> CurItem) do
          begin
            Inc(B);
            P := P^.Next;
          end;
          O := (P <> nil);
          if O then HistoryItem := P^.Code;
          F := True;
        end;
      end;
      kbUp:
      begin
        if CurItem = Items then P := nil else P := CurItem;
        CurItem := Items;
        while (CurItem <> nil) and (CurItem^.Next <> P) do CurItem := CurItem^.Next;
        F := True;
        DrawView;
      end;
      kbDown:
      begin
        CurItem := CurItem^.Next;
        if CurItem = nil then CurItem := Items;
        F := True;
        DrawView;
      end;
      kbPgUp, kbHome:
      begin
        CurItem := Items;
        F := True;
        DrawView;
      end;
      kbPgDn, kbEnd:
      begin
        CurItem := Items;
        while CurItem^.Next <> nil do CurItem := CurItem^.Next;
        F := True;
        DrawView;
      end;
    else
      P := CurItem;
      if Event.CharCode >= ' ' then W := Ord(UpCase(Event.CharCode));
      if not HotKey or (P^.HotCode <> W) then
      begin
        repeat
          P := P^.Next;
          if P = nil then P := Items;
        until (P = CurItem) or (P^.HotCode = W);
      end;
      if P^.HotCode = W then
      begin
        if HotKey then
        begin
          HistoryItem := P^.Code;
          O := True;
        end
        else
        begin
          CurItem := P;
        end;
        F := True;
        DrawView;
      end;
    end;
    if F then ClearEvent(Event);
  end;
  if Event.What and evMouse > 0 then
  begin
    repeat
      if MouseInView(Event.Where) then
      begin
        O := Event.Double;
        MakeLocal(Event.Where, T);
        B := 1;
        P := Items;
        while (P <> nil) and (B <= T.Y) do
        begin
          Inc(B);
          P := P^.Next;
        end;
        if P <> nil then CurItem := P;
        DrawView;
      end;
    until not MouseEvent(Event, evMouseMove);
    if O and MouseInView(Event.Where) then HistoryItem := P^.Code;
    ClearEvent(Event);
  end;
  if O then
  begin
    Event.What := evCommand;
    Event.Command := cmOK;
  end;
end;

{Draw the history or menu}
procedure THistory.Draw;
var
  A,
  C,
  Z             : Byte;
  Y             : Integer;
  P             : PHistoryItem;
  B             : TDrawBuffer;
begin
  A := GetColor(1);
  C := GetColor(2);
  P := Items;
  for Y := 0 to Size.Y - 1 do
  begin
    MoveChar(B, ' ', A, Size.X);
    if P <> nil then
    begin
      if P = CurItem then Z := C else Z := A;
      if HotKey then
      begin
        MoveChar(B, ' ', A, HotWidth + 2);
        MoveChar(B[Size.X - 1], ' ', A, 1);
        if HotWidth = 0 then
        begin
          MoveChar(B[1], ' ', Z, Size.X - 2);
          MoveCBMStr(@B[2], P^.Title, Z, False);
        end
        else
        begin
          MoveChar(B[HotWidth + 2], ' ', Z, Size.X - HotWidth - 3);
          MoveStr(B[1], P^.HotStr, A);
          MoveCBMStr(@B[HotWidth + 3], P^.Title, Z, False);
        end;
      end
      else
      begin
        MoveChar(B, ' ', Z, Size.X);
        MoveCBMStr(@B[1], P^.Title, Z, False);
      end;
      P := P^.Next;
    end;
    WriteBuf(0, Y, Size.X, 1, B);
  end;
end;

{Initialize the screen saver
  Input : Bounds: bounds of the screen saver}
constructor TScreenSaver.Init(Bounds: TRect);
var
  B             : Byte;
  P             : PSaverStar;
  R             : TRect;
begin
  TWindow.Init(Bounds, stEmpty, fxNone, fyNone);
  SetState(sfShadow, False);
  Options := ofSelectable;
  R.Assign(0, 0, 1, 1);
  for B := 0 to SaverStarMax - 1 do
  begin
    P := New(PSaverStar, Init(R));
    Insert(P);
    P^.Phase := 6;
    P^.Count := 0;
    SaverStars[B] := P;
  end;
end;

{Handle screen saver events
  Input : Event: event record to be handled}
procedure TScreenSaver.HandleEvent(var Event: TEvent);
begin
  if (Event.What and (evKeyboard + evMouseUp + evMouseDown + evCommand) > 0) or
    ((Event.What and (evMouseMove + evMouseAuto) > 0) and ((Event.Where.X < ScreenWidth - 4) or (Event.Where.Y > 1))) then
  begin
    SaverOff;
    ClearEvent(Event);
  end;
end;

{Perform screen saving}
procedure TScreenSaver.Idle;
var
  B             : Byte;
  L             : Longint;
  P             : PSaverStar;
begin
  L := GetTicks;
  if (L <> SaverCount) then
  begin
    for B := 0 to SaverStarVis do
    begin
      P := SaverStars[B];
      if P^.Count = 0 then
      begin
        Inc(P^.Phase);
        if P^.Phase = 7 then P^.Phase := 1;
        if ((P^.Phase = 3) and (Random(10) < 8)) then P^.Phase := 6;
        if P^.Phase = 1 then
        begin
          P^.MoveTo(Random(ScreenWidth), Random(ScreenHeight));
          P^.Count := Random(182) + 1;
        end
        else
        begin
          P^.Count := 3;
        end;
        P^.DrawView;
      end;
      if SaverStarVis = SaverStarMax - 1 then Dec(P^.Count);
    end;
    if SaverStarVis < SaverStarMax - 1 then Inc(SaverStarVis);
    SaverCount := L;
  end;
end;

{Get the palette of the screen saver
  Output: string containing the palette}
function TScreenSaver.GetPalette: PPalette;
const
  P: String[Length(CScreenSaver)] = CScreenSaver;
begin
  GetPalette := @P;
end;

{Draw the screen saver}
procedure TScreenSaver.Draw;
var
  B             : TDrawBuffer;
begin
  MoveChar(B, ' ', GetColor(1), Size.X);
  WriteLine(0, 0, Size.X, Size.Y, B);
end;

{Draw the screen saver star}
procedure TSaverStar.Draw;
var
  B             : TDrawBuffer;
begin
  if Phase > 1 then MoveChar(B, StarChars[Phase], GetColor(2), 1) else
    MoveChar(B, StarChars[Phase], GetColor(1), 1);
  WriteBuf(0, 0, 1, 1, B);
end;

{Handle decimal numerical input line events
  Input : event record to be handled}
procedure TNumInput.HandleEvent(var Event: TEvent);
begin
  Quote := False;
  if Event.What and evKeyboard > 0 then
  begin
    case Event.CharCode of
      #0..' ', '0'..'9':
    else
      Event.What := evNothing;
    end;
  end;
  TInputLine.HandleEvent(Event);
end;

{Handle hexadecimal numerical input line events
  Input : event record to be handled}
procedure THexInput.HandleEvent(var Event: TEvent);
begin
  Quote := False;
  if Event.What and evKeyboard > 0 then
  begin
    Event.CharCode := UpCase(Event.CharCode);
    case Event.CharCode of
      #0..' ', '0'..'9', 'A'..'F':
    else
      Event.What := evNothing;
    end;
  end;
  TInputLine.HandleEvent(Event);
end;

{Handle drive letter input line events
  Input : event record to be handled}
procedure TDriveInput.HandleEvent(var Event: TEvent);
begin
  Quote := False;
  if Event.What and evKeyboard > 0 then
  begin
    Event.CharCode := UpCase(Event.CharCode);
    if (Event.CharCode in ['8', '9', '0', '1', 'A'..'Z']) then
    begin
      if not DriveValid(Event.CharCode) then Event.What := evNothing;
    end
    else
    begin
      if (Event.CharCode >= ' ') then Event.What := evNothing;
    end;
  end;
  TInputLine.HandleEvent(Event);
end;

{Initialize the menu selection input line}
constructor TMenuInput.Init(var Bounds: TRect; ALen, AMaxLen: Integer; const ATitle: string; ATitleDir: Byte;
  const AMenuTitle: string; AFirstVal, ALastVal, AFirstNum: Byte; AItemStrProc: TItemStrProc);
begin
  TInputLine.Init(Bounds, ALen, AMaxLen, ATitle, ATitleDir);
  MenuTitle := AMenuTitle;
  FirstVal := AFirstVal;
  LastVal := ALastVal;
  FirstNum := AFirstNum;
  ItemStrProc := AItemStrProc;
end;

{Get the current value from menu selection input line
  Input : the untyped record to contain the value}
procedure TMenuInput.GetData(var Rec);
begin
  Byte(Rec) := Value;
end;

{Set the current value of menu selection input line
  Input : the untyped record containing the value}
procedure TMenuInput.SetData(var Rec);
begin
  Value := Byte(Rec);
  Data^ := ItemStrProc(Value);
  DrawView;
end;

{Handle menu selection input line events
  Input : event record to be handled}
procedure TMenuInput.HandleEvent(var Event: TEvent);
var
  F,
  O             : Boolean;
begin
  F := False;
  if Event.What and evKeyboard > 0 then
  begin
    O := True;
    case Event.KeyCode of
      kbSpace: F := True;
    else
      O := False;
    end;
    if O then ClearEvent(Event);
  end;
  if Event.What and evMouse > 0 then
  begin
    TView.HandleEvent(Event);
    repeat
      F := MouseInView(Event.Where);
    until not MouseEvent(Event, evMouseAuto);
    F := F and (Event.What and evMouseUp > 0);
  end;
  if F and (SelectMenuInputItem(MenuTitle, FirstVal, LastVal, FirstNum, Value, ItemStrProc) = cmOK) then
  begin
    Value := HistoryItem;
    Data^ := ItemStrProc(Value);
    DrawView;
    ShowCursor;
  end;
end;

function LPTPortStr(Port: Byte): string;
begin
  LPTPortStr := '';
  case Port of
    0..MaxRealPorts - 1: LPTPortStr := 'LPT' + Chr(Ord('1') + Port);
    MaxRealPorts..MaxLPTPorts - 1: LPTPortStr := HexaStr(LPTAddresses[Port], 4);
  end;
end;

{Select the parallel port from a menu
  Input : Title: the title of the dialog box
          DefPort: the number of the default port
  Output: when cmOK, the user confirms to execute the operation; when
          cmCancel, the user cancelled the operation}
function SelectLPTPort(DefPort: Byte): Word;
var
  B,
  C             : Byte;
  A,
  P             : PHistoryItem;
  S             : string[4];
  T             : string[20];
begin
  P := nil;
  C := 0;
  for B := 0 to MaxLPTPorts - 1 do
  begin
    T := '';
    if ValidLPTAddr(LPTAddresses[B]) and (LPTModes[B] <> pmNone) then
    begin
      T := HexaPrefix + HexaStr(LPTAddresses[B], 4);
      S := '';
      case LPTModes[B] of
        pmSPP: S := 'SPP';
        pmPS2: S := 'PS/2';
        pmEPP: S := 'EPP';
        pmECP: S := 'ECP';
        pmUnknown: S := '???';
      end;
      if S <> '' then T := T + ', ' + S;
    end;
    if T <> '' then T := ' (' + T + ')';
    P := NewHistoryItem(Chr(Ord('1') + B), LPTPortStr(B) + T, B, True, P);
    if B = 0 then A := P;
    Inc(C);
  end;
  SelectLPTPort := DisplayUserMenu('Select parallel port', C, 0, DefPort, mtNone, A, nil, True, True);
end;

{Get the current value from parallel port input line
  Input : the untyped record to contain the value}
procedure TLPTPortInput.GetData(var Rec);
begin
  Word(Rec) := CurPort;
end;

{Set the current value of parallel port input line
  Input : the untyped record containing the value}
procedure TLPTPortInput.SetData(var Rec);
begin
  CurPort := Word(Rec);
  Data^ := LPTPortStr(CurPort);
  SelectAll;
  DrawView;
end;

procedure TLPTPortInput.CheckCustomPort;
var
  O             : Boolean;
  W             : Word;
  I             : Integer;
begin
  if CurPort >= MaxRealPorts then
  begin
    W := HexaEval(Data^, I);
    if I = 0 then
    begin
      O := (LPTAddresses[CurPort] <> W);
      if O then
      begin
        LPTAddresses[CurPort] := W;
        LPTModes[CurPort] := pmUnknown;
        CollectLPTPorts(False);
      end;
    end;
  end;
end;

{Handle parallel port input line events
  Input : event record to be handled}
procedure TLPTPortInput.HandleEvent(var Event: TEvent);
var
  B,
  F,
  O             : Boolean;
begin
  B := (CurPort >= MaxRealPorts);
  F := False;
  if Event.What and evKeyboard > 0 then
  begin
    O := True;
    case Event.KeyCode of
      kbSpace: F := True;
    else
      O := False;
    end;
    if O and not B then ClearEvent(Event);
  end;
  if Event.What and evMouse > 0 then
  begin
    TView.HandleEvent(Event);
    repeat
      F := MouseInView(Event.Where);
    until not MouseEvent(Event, evMouseAuto);
    F := F and (Event.What and evMouseUp > 0);
  end;
  if F then
  begin
    if B then CheckCustomPort;
    if SelectLPTPort(CurPort) = cmOK then
    begin
      CurPort := HistoryItem;
      Data^ := LPTPortStr(CurPort);
      CurPos := 0;
      SelectAll;
      DrawView;
      ShowCursor;
    end;
    ClearEvent(Event);
  end;
  if B then THexInput.HandleEvent(Event);
end;

procedure TLPTPortInput.SetState(AState:Word; Enable: Boolean);
var
  O             : Boolean;
  S             : string[4];
begin
  O := False;
  if AState and sfSelected > 0 then
  begin
    if not Enable then CheckCustomPort;
    if CurPort >= MaxRealPorts then
    begin
      S := HexaStr(LPTAddresses[CurPort], 4);
      O := (Data^ <> S);
      if O then
      begin
        Data^ := S;
        CurPos := 0;
        SelectAll;
      end;
    end;
  end;
  THexInput.SetState(AState, Enable);
  if O then DrawView;
end;

{Initialize the decimal value validity checker
  Input : AMin, AMax: the valid interval for the decimal value
          ATitle: the title of the error message box
          AError: text to be displayed in the error message box
          AHelp: help context for the box}
constructor TNumValid.Init(AMin, AMax: Integer; const ATitle, AError: string; AHelp: Word);
begin
  TValidator.Init;
  Min := AMin;
  Max := AMax;
  if ATitle = '' then Title := BoxTitle else Title := ATitle;
  ErrorStr := 'Invalid ' + AError + stDot;
  Help := AHelp;
end;

{Check if the decimal value is valid
  Input : S: decimal value in the input line
  Output: when True, the decimal value is valid}
function TNumValid.IsValid(const S: string): Boolean;
var
  A,
  B             : Integer;
  X             : Boolean;
begin
  if S = '' then
  begin
    IsValid := True;
  end
  else
  begin
    Val(S, A, B);
    IsValid := (B = 0) and (A >= Min) and (A <= Max);
    X := (B = 0) and (A >= Min) and (A <= Max);
  end;
end;

{Display an error on an invalid decimal value}
procedure TNumValid.Error;
begin
  MakeSound := False;
  ErrorWin(Title, ErrorStr, 'Enter a value between ' + LeadingSpace(Min, 0) + ' and ' + LeadingSpace(Max, 0) + stDot,
    Help, sbNone);
end;

{Check if the date string is valid
  Input : S: date string in the input line
  Output: when True, the date string is valid}
function TDateValid.IsValid(const S: string): Boolean;
var
  O             : Boolean;
  A,
  B,
  C,
  D             : Word;
begin
  O := True;
  if S <> '' then O := MakeTime(S, A, B, C, True);
  IsValid := O;
end;

{Display an error on an invalid date string}
procedure TDateValid.Error;
begin
  MakeSound := False;
  ErrorWin(stEmpty, 'Can''t set the attributes.', 'Invalid date.', hcFileAttrib, sbNone);
end;

{Check if the time string is valid
  Input : S: time string in the input line
  Output: when True, the time string is valid}
function TTimeValid.IsValid(const S: string): Boolean;
var
  O             : Boolean;
  A,
  B,
  C             : Word;
begin
  O := True;
  if S <> '' then O := MakeTime(S, A, B, C, False);
  IsValid := O;
end;

{Display an error on an invalid time string}
procedure TTimeValid.Error;
begin
  MakeSound := False;
  ErrorWin(stEmpty, 'Can''t set the attributes.', 'Invalid time.', hcFileAttrib, sbNone);
end;

end.
