
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                    BASE2.PAS                    }
{                                                 }
{         The Star Commander base unit #2         }
{*************************************************}

unit Base2;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  DOS, Dialogs, Menus, Objects, Views,
  Constant, ExtFiles, LowLevel, OpenCBM;

type
{Pointer to byte}
  PByte         = ^Byte;
{Pointer to word}
  PWord         = ^Word;
{Get clock status procedure}
  TGetClock     = procedure(B: Boolean);
{String case procedure}
  TCaseProc     = function(const S: string): string;
{CBM-style block}
  TBlock        = array [0..MaxByte] of Byte;
  PBlock        = ^TBlock;
{File copy and help buffer (31.75 KBytes)}
  TSmallBuf     = array [0..TSmallBufSize - 1] of Byte;
  PSmallBuf     = ^TSmallBuf;
{Copy buffer (63.5 KBytes)}
  TBuffer       = array [0..TBufferSize - 1] of Byte;
  PBuffer       = ^TBuffer;
{Buffer for patching custom drive routines}
  TPatchBuffer  = array [0..TPatchBufSize - 1] of Byte;
  PPatchBuffer  = ^TPatchBuffer;
{Indent table for the edit field of the disk editor}
  TIndent       = array [0..15] of Byte;
  PIndent       = ^TIndent;
{Location containing the track and sector number of a block}
  TLocation     = record
    Track,
    Sector      : Byte;
  end;
{Location buffer containing the location of blocks}
  TLocBuffer    = array [0..MaxLocations - 1] of TLocation;
  PLocBuffer    = ^TLocBuffer;
{File name buffer}
  TNameBuffer   = array [0..MaxFiles * 17 - 1] of Byte;
  PNameBuffer   = ^TNameBuffer;
{Directory entry}
  TDirEntry     = record
    Name        : string;
    Attr,
    ExtAttr,
    Status      : Byte;
    Size        : Longint;
    DirPos      : Word;
    case Union: Integer of
      pmDOS:    (Time: Longint);
      pmExt,
      pmDisk:   (Track: Byte;
                 Sector: Byte;
                 SideTrack: Byte;
                 SideSector: Byte;
                 RecordLen: Byte);
      pmTape,
      pmFile,
      pmLynx,
      pmArkive,
      pmTAR:     (Start: Word);
  end;
  PDirEntry     = ^TDirEntry;
{Directory entry with an offset to the file name}
  TPanelEntry   = record
    Name        : Word;
    Attr,
    ExtAttr,
    Status      : Byte;
    Size        : Longlongint;
    DirPos      : Word;
    case Union: Integer of
      pmDOS:    (Time: Longint);
      pmExt,
      pmDisk:   (Track: Byte;
                 Sector: Byte;
                 SideTrack: Byte;
                 SideSector: Byte;
                 RecordLen: Byte);
      pmTape,
      pmFile,
      pmLynx,
      pmArkive,
      pmTAR:     (Start: Word);
  end;
  PPanelEntry   = ^TPanelEntry;
{LHA archive directory entry}
  TLHAEntry     = record
    Checksum    : Byte;
    Method      : array [0..4] of Char;
    PackSize    : Longint;
    OrigSize    : Longint;
    Time        : Longint;
    Attr        : Word;
    Name        : string;
    CRCCheck    : Word;
  end;
{ZIP archive directory entry}
  TZIPEntry     = record
    Signature   : Longint;
    VerExtract  : Word;
    HeaderFlag  : Word;
    Method      : Word;
    Time        : Longint;
    CRCCheck    : Longint;
    PackSize    : Longint;
    OrigSize    : Longint;
    NameLen     : Word;
    ExtHeadSize : Word;
  end;
{ZIP archive directory entry in central directory}
  TZIPCDirEntry = record
    Signature   : Longint;
    VerCreated  : Word;
    VerExtract  : Word;
    HeaderFlag  : Word;
    Method      : Word;
    Time        : Longint;
    CRCCheck    : Longint;
    PackSize    : Longint;
    OrigSize    : Longint;
    NameLen     : Word;
    ExtHeadSize : Word;
    CommentSize : Word;
    StartVol    : Word;
    IntAttr     : Word;
    Attr        : Longint;
    HeaderOffs  : Longint;
  end;
{ZIP archive end of central directory entry}
  TZIPCDirEnd   = record
    Signature   : Longint;
    VolumeNum   : Word;
    LastVolNum  : Word;
    LocalFileNum: Word;
    FileNum     : Word;
    DirSize     : Longint;
    DirOffs     : Longint;
    ArchCmtSize : Word;
  end;
{ZIP archive signature entry}
  TZIPCDirSign  = record
    Signature   : Longint;
    SigSize     : Word;
  end;
{Menu items for the sort modes of a panel}
  TSortMenu     = array [0..5] of PMenuItem;
{Menu items for the Brief/Full/Wide/Info/Quick View modes of a panel}
  TModeMenu     = array [0..4] of PMenuItem;
{History or menu item}
  PHistoryItem  = ^THistoryItem;
  THistoryItem  = object
    Title       : string;
    HotStr      : string[3];
    HotCode     : Word;
    Code        : Byte;
    Next        : PHistoryItem;
  end;
{Clock}
  TClock        = object(TView)
    constructor Init(Bounds: TRect);
    procedure Draw; virtual;
    procedure Hide; virtual;
    procedure Show; virtual;
    function GetPalette: PPalette; virtual;
  end;
  PClock        = ^TClock;
{PETSCII string}
  TCBMText      = object(TStaticText)
    procedure Draw; virtual;
  end;
  PCBMText      = ^TCBMText;
{PETSCII string list}
  TCBMTextList  = object(TCBMText)
    Strings     : TStringCollection;
    constructor Init(Bounds: TRect; AStrings: PSItem);
    destructor Done; virtual;
    procedure Draw; virtual;
  end;
  PCBMTextList  = ^TCBMTextList;
{Configuration menu reminder}
  TConfigText   = object(TStaticText)
    constructor Init(Bounds: TRect);
    procedure Draw; virtual;
    function GetPalette: PPalette; virtual;
  end;
  PConfigText   = ^TConfigText;
{Configuration menu item frame}
  TItemFrame    = object(TStaticText)
    constructor Init(var Bounds: TRect; const AText: string);
    procedure Draw; virtual;
  end;
  PItemFrame    = ^TItemFrame;
{Separator between the items and the buttons in a dialog box}
  TSeparator    = object(TStaticText)
    constructor Init(var Bounds: TRect);
    procedure Draw; virtual;
  end;
  PSeparator    = ^TSeparator;
{Directory buffer}
  TDirBuffer    = array [0..MaxFiles - 1] of TPanelEntry;
  PDirBuffer    = ^TDirBuffer;
{Drive feature table}
  TDriveFeature = array [dt1541..dt1581] of Byte;
  PDriveFeature = ^TDriveFeature;
{Menu item string selector}
  TItemStrProc  = function(Value: Byte): string;
{Decoded sector header}
  TSecDecHeader = record
    Signature,
    Checksum,
    SectorNum,
    TrackNum,
    ID2,
    ID1,
    Padding1,
    Padding2    : Byte;
  end;
  PSecDecHeader = ^TSecDecHeader;
const
{Decoded sector header size on 1541/1570/1571 disks}
  HeaderSize    = SizeOf(TSecDecHeader);
{Sector header size on 1541/1570/1571 disks}
  HeaderGCRSize = (HeaderSize * 5 div 4);
type
{Sector header}
  TSectorHeader = array [0..HeaderGCRSize - 1] of Byte;
  PSectorHeader = ^TSectorHeader;

const
  DriveTransferModes : TDriveFeature = (tmWarp, tmWarp, tmTurbo);
  DriveParallelCables : TDriveFeature = (pcParallel, pcParallel, pcNone);
  DriveCmdExecModes : TDriveFeature = (cxWarp, cxNormal, cxNormal);
  DriveExtDiskModes : TDriveFeature = (xtDetect, xtNever, xtNever);

var
  Resident,
  Internal,
  DisableLPTPorts,
  CopyDisableLPTPorts,
  DisableXMSUsage,
  DisableEMSUsage,
  DisableWinClipboard,
  DefVESASupport,
  MilitaryTime,
  SearchInHex,
  More,
  EOI,
  Timeout,
  InterruptsOff,
  SingleCommand,
  ClearCommand,
  AttachInfo,
  Archiving,
  Compressing,
  RunningShell,
  PopupMenu,
  DayLight,
  LeftOrigVis,
  RightOrigVis,
  LeftHiddenFiles,
  RightHiddenFiles,
  EscPressed,
  LoadingDirs,
  ExtDrive,
  SingleFile,
  OnlyRename,
  MoveFiles,
  DirNameGiven,
  LongFileNames,
  ImageExists,
  FileProcessed,
  FileSizeWarned,
  ArcBackwards,
  ArcEnd,
  HelpCtxSet,
  BufferOK,
  DiskChanged,
  BufferChanged,
  InsertMode,
  TextMode,
  ShutImage,
  DiskFull,
  SysError,
  WentToCorner,
  FirstMenuLine,
  ShiftPressed,
  ShiftHeld,
  MouseRightHeld,
  ShiftSel,
  MouseSel,
  ShowClock,
  HelpOK,
  SearchInUse,
  TransferInited,
  ClockLast,
  SafeClean,
  EditMarking,
  EditMarked,
  HexaMode,
  ConvertConfirm,
  DeleteConfirm,
  TransferConfirm,
  DiskEditConfirm,
  TransferWarning,
  FileSizeWarning,
  QuitConfirm,
  AutoMenus,
  FullScreen,
  AlternativeHotkeys,
  InsMovesDown,
  EscTogglesPanels,
  AltPopsMenu,
  ClockVis,
  CursorFollowsFilename,
  ErrorSound,
  AutoSaveSetup,
  PathPrompt,
  PreferLongNames,
  KeepLowerCase,
  DOSSizeBlocks,
  StartInfo,
  ShowReadErrors,
  AutoUnselect,
  DetectDiskChange,
  CopyToDirTrack,
  MakeBackup,
  KeepTime,
  GEOSSupport,
  WipeFiles,
  OrigPattern,
  KeepNonStandardExt,
  KeepUpperCase,
  FormatBumpsHead,
  RetryHalftracks,
  RetryBumpsHead,
  EndlessRetry,
  VerifyWrite,
  ManualTimeouts,
  ExtendedDisk,
  CopyExtDisk,
  DetectExtTracks,
  EightColFont,
  MakeSound,
  FetchDiskID,
  TurboOffed,
  AllConvert    : Boolean;
  DefScreenCol,
  DummyByte,
  DetectPortModes,
  LPTNum,
  ParLPTNum,
  ErrorDown,
  MaxFileNameLen,
  CopyFileMode,
  ExecMode,
  DestArchType,
  FileSelectMode,
  LHAHeaderLen,
  EditChar,
  RetryCount,
  DiskDirSize,
  LeftFileFilter,
  RightFileFilter,
  CurHistory,
  GCRSign,
  GCRChecksum,
  GCRError,
  ExternalDrive,
  ExtDriveType,
  ExtDiskType,
  CopyExtDiskType,
  ExtendedDiskMode,
  DriveStatus,
  CopyStep,
  SectorStep,
  CBMDevNum,
  Serial,
  AtnBit,
  ClkBit,
  DataBit,
  ResetBit,
  ClkDataBits,
  InData,
  OutData,
  Status,
  SaverStarVis,
  TransferMode,
  AsyncTransfer,
  CopyTransferMode,
  CopyPriorityMode,
  SerialCable,
  ParallelCable,
  CableMode,
  CopyCableMode,
  CopyDiskCopyMode,
  DiskExtBAMMode,
  ImageExtBAMMode,
  DiskCopyMode,
  InvalidGCRCodeMode,
  CmdExecMode,
  CopyCmdExecMode,
  ConvInvalidChars,
  RetryNum,
  SmartRetryNum,
  HeadSpeed,
  SaverDelay,
  ConfigXORSum,
  ConfigSUBSum,
  HelpNum,
  HelpMax,
  HelpCur,
  HelpAttr,
  DriveIntIndex,
  MouseVal,
  MouseLast,
  IntoFileImages,
  CopyIntoFileImages,
  ExtractFileImages,
  CopyExtractFileImages,
  AllDelete,
  AllDeleteReadonly,
  AllDeleteDir,
  AllOverwrite,
  AllOverwriteReadonly,
  AllUseFCOPY,
  AllErrorSkip  : Byte;
  ThousandSep,
  DateSep,
  TimeSep,
  DriveLetter   : Char;
  CurLoc,
  LastLoc,
  DateFormat,
  Code,
  TapeDirSize,
  LPTAddr,
  ParLPTAddr,
  LPTMode,
  ParLPTMode,
  WarningStatus,
  ImageAttr,
  FileAttr,
  GetCheckData,
  GetRadioData,
  HelpLength,
  LynxCountPos,
  HelpPos,
  ArcBufPos,
  ArcBufSize,
  CopyBufSize,
  CurHelpCtx,
  LastHelpCtx,
  ConfigCount,
  LastHalfSec,
  DelayValue,
  CopyDelayValue,
  CopyHeaderID,
  CopyBAMID,
  CodePage,
  ECPAddrOffs   : Word;
  IndicatorLen,
  CopyFileNum,
  TimeZone,
  NumOK,
  DiskChangeCmd,
  PanWinSize,
  Justify,
  WinSize,
  WinCenter     : Integer;
  BatchOffset,
  MemSize,
  MemFree,
  ArcPos,
  ArcSize,
  DestSize,
  CopySize,
  CopiedSize,
  AppendOrigSize,
  AppendOrigTime,
  CopiedBlock,
  ReadTime,
  SaverCount,
  SaverTicks,
  TurboOffCount : Longint;
  CheckTimeout,
  ReadLine,
  AtnLo,
  AtnHi,
  ClkLo,
  ClkHi,
  DataLo,
  DataHi,
  TReceive,
  TSend,
  TWait,
  TReadParallel,
  TWriteParallel,
  ClockOn,
  ClockOff,
  SetClock      : TProc;
  GetClock      : TGetClock;
  Clock         : PClock;
  ShellBuffer   : PShellBuffer;
  CopyInd       : PStaticText;
  SetupDialog,
  TempDialog    : PDialog;
  MAutoMenus,
  MPathPrompt,
  MKeyBar,
  MFullScreen,
  MClock        : PMenuItem;
  TimeStr       : string[8];
  CopyTitle     : string[14];
  PrgExt        : string[MaxPrgExtLen];
  DiskTitle     : string[22];
  TapeTitle     : string[24];
  BoxTitle,
  UserTitle     : string[40];
  DOSPattern,
  CBMPattern    : string[64];
  HomePath,
  CurPath,
  ListPath,
  SourceName,
  DestName,
  LastName,
  ExtFileName,
  FatalError    : string;
  BackupFile,
  TempFile,
  WriteFile,
  HelpFile,
  ReadFile,
  GiveIODrv,
  UserPortDrv   : ExtFile;
  LastWhere     : TPoint;
  LeftSortMenu,
  RightSortMenu : TSortMenu;
  LeftModeMenu,
  RightModeMenu : TModeMenu;
  Entry         : TDirEntry;
  LHAEntry      : TLHAEntry;
  ZIPEntry      : TZIPCDirEntry;
  ZIPDirEnd     : TZIPCDirEnd;
  HelpBuffer    : TDrawBuffer;
  DataBuffer,
  WorkBuffer,
  UndoBuffer,
  ClipBuffer    : TBlock;
  LPTAddresses  : TLPTAddresses;
  HelpColors    : array [0..3] of Byte;
  LPTModes      : array [0..MaxLPTPorts - 1] of Byte;
  ImageInts     : array [0..(DiskTypeNum * 2) - 1] of Byte;
  DriveInts     : array [0..DriveIntNum - 1] of Byte;
  NumStr        : array [0..15] of Char;
  TrackMap,
  TrackMap2,
  GCRMap        : array [0..TrackMapSize] of Byte;
  UpCaseTable,
  LoCaseTable   : array [$80..$FF] of Byte;
  HeaderBuffer  : array [0..TrackMapSize - 1] of TSectorHeader;
  TempBuffer,
  GCRBuffer     : array [0..TempBufferSize - 1] of Byte;

procedure DriveProgs;
procedure ComputeDelay;
procedure Delay;
procedure SetTimeout(On: Boolean);
function ValidLPTAddr(Addr: Word): Boolean;
procedure InterruptOff(Level: Byte);
procedure InterruptOn;
procedure ResetLPTPort;
procedure ResetDrives;
procedure TurboOff;
procedure TurboOffDecouple;
procedure ShutDownAsync;
procedure InitLPTPorts;
procedure ParallelInput;
procedure ParallelOutput;
procedure Receive;
procedure Send;
function CheckDevice: Boolean;
function CheckDiskChange: Boolean;
procedure Talk;
procedure Listen;
procedure Untalk;
procedure Unlisten;
procedure OpenCBMChannel(SecAddr: Byte; const Command: string; Timeout: Boolean);
procedure CloseCBMChannel(SecAddr: Byte);
function ReadCBMError(var Error: string; Check, Off, Timeout: Boolean): Boolean;
function StrLonglongint(const Num: Longlongint; DigitNum: Word): string;
function LeadingZero(Num: Longint; DigitNum: Word): string;
function LeadingSpace(Num: Longint; DigitNum: Word): string;
function LeadingSpaceLonglongint(const Num: Longlongint; DigitNum: Word): string;
function SepStr(Num: Longint): string;
function SepStrLonglongint(const Num: Longlongint): string;
function HexaStr(D: Longint; L: Byte): string;
function HexaEval(const S: string; var Code: Integer): Longint;
function EvalAny(const S: string; var Code: Integer): Longint;
function Replace(const Str: string; OrigChar, NewChar: Char): string;
function CBMStrLen(const Text: string): Integer;
function UpCase(Ch: Char): Char;
function LoCase(Ch: Char): Char;
function InvertCase(Ch: Char): Char;
function CBMUpCase(Ch: Char): Char;
function CBMLoCase(Ch: Char): Char;
function CBMInvertCase(Ch: Char): Char;
function SCRUpCase(Ch: Char): Char;
function SCRLoCase(Ch: Char): Char;
function SCRInvertCase(Ch: Char): Char;
function UpperCase(const S: string): string;
function LowerCase(const S: string): string;
function CBMUpperCase(const S: string): string;
function CBMLowerCase(const S: string): string;
procedure FreeHistoryItem(P: PHistoryItem);
function GetTicks: Longint;
procedure MakeAMPM(var Hour: Word; var AMPM: string; Force: Boolean);
procedure MoveCBMStr(Dest: Pointer; const Str: String; Attr: Word; Color: Boolean);
procedure MakeWinBounds(var R: TRect; X, Y: Integer);
function LimitNameLen(const Name: string; Max: Integer): string;
function FileName(const Name: string): string;
function FileExt(const Name: string): string;
function MakeFileExt(const Name, Ext: string): string;
procedure TextScreen(Prompt: TProc);
procedure CheckResident;
function GetTempPath: string;
procedure SetHomePath;
procedure Beep;
function CutChar(const Name: string; C: Char): string;
function DOSVersion: Word;
procedure InitSelectMode;
procedure InitLPTBits;
procedure InitTransfer(Warnings: Boolean);
procedure GCRDecodeSector;
procedure GCREncodeSector;
procedure GCRDecodeHeader;
procedure GCREncodeHeader;
function GetLPTMode(Address: Word): Byte;
procedure EnableLPTPorts;
procedure EnableWinNTPortAccess;
procedure DisableWinNTPortAccess;
function CheckLPTPorts(CheckSerial: Boolean): Boolean;
procedure EmergencyExit;
procedure MouseOn;
procedure MouseOff;
procedure GetMouse(B: Boolean);
procedure SetMouse;
procedure ChangeHelpCtx(Help: Word);
procedure RestoreHelpCtx;
procedure SwapMem(var Source, Dest; Count: Word);
function CompMem(var Source, Dest; Count: Word): Boolean;
function ReadArcByte(var ArcFile: ExtFile; var Data: Byte): Boolean;
function SearchArchive(var ArcFile: ExtFile; const Str: string; Backwards: Boolean): Boolean;
function MakeErrorStr(Error, Track, Sector: Byte; var Str: string): Boolean;
function GetPanelModeAttrib(Mode: Byte; Attr: Word): Boolean;
function MakeTypeStr(Mode: Byte): string;
function MakeFullTypeStr(Mode: Byte): string;
function DriveTypeStr(DriveType: Byte): string;
function CompareString(const P, Q: string): Integer;
function ConvertCBMName(const Name: string; GEOS, FileCopy: Boolean; Conv: Char): string;
function ReconvertCBMName(const Name: string; GEOS, FileCopy: Boolean; Conv: Char): string;
function ConvertCBMPath(Path: string; GEOS, FileCopy: Boolean; Conv: Char; DirSep: Char): string;
function ReconvertCBMPath(Path: string; GEOS, FileCopy: Boolean; Conv: Char; DirSep: Char): string;
function MakeCBMName(const Name: string; GEOS: Boolean): string;
function CloneName(const Name, Pattern: string; ConvName, ConvPattern: Boolean): string;
procedure SplitName(const Entry: string; var Name, Ext: string);
function CloneDOSName(const Name1, Name2: string): string;
function CompareCBMEntry(const Pattern, Name: string; Attr: Byte; Partial: Boolean): Boolean;
function CompareDOSEntry(const Pattern: string; Name: string; Long, Partial: Boolean): Boolean;
function ListCompareCBMEntry(const Pattern, Name: string; Attr: Byte; Partial: Boolean): Boolean;
function ListCompareDOSEntry(const Pattern: string; Name: string; Long, Partial: Boolean): Boolean;
function GetDiskType(L: Longint): Byte;
function GetDiskExt(Disk: Byte): string;
function IsDiskExt(const Ext: string): Boolean;
procedure FillFormatPattern(Buffer: PBlock);
function FileExists(const Name: string; Path: Boolean): Boolean;
function IsDiskFile(const F: ExtFile): Boolean;
function IsDeviceName(const Name: string): Boolean;
function ShiftCode: Byte;
function IsShiftPressed: Boolean;
function Escape: Boolean;
function AllDOSFiles(const Name: string): Boolean;
function FirstDirSec(DiskType: Byte): Byte;
function NameOffset(DiskType, ExtBAMMode: Byte): Byte;
function FirstHeaderPadding(DiskType, ExtBAMMode: Byte): Byte;
function CBMDiskSize(Disk: Byte): Longint;
function DiskMaxFree(Disk: Byte): Longint;
function DetermineTypePrefix(const Name: string): Byte;
function DetermineTypeName(const Name: string): Byte;
function CancelTransfer(Confirm: Boolean): Boolean;
function ReadZipCodeBlock(var ArcFile: ExtFile; Buffer: PBlock; FileZip: Boolean; Mode: Byte; var T, S: Byte;
  var Len: Word): Boolean;
procedure WriteZipCodeBlock(var ArcFile: ExtFile; Buffer: PBlock; FileZip: Boolean; T, S: Byte);
function SeekToFileZipBlock(var ArcFile: ExtFile; Pos: Word): Integer;
procedure SendConfigData;
function CreateDate(Year, Month, Day: Word; Len: Byte; Century: Boolean): string;
function ErrorWin(const Title: string; Text1, Text2: string; Help: Word; Skip: Byte): Boolean;
function SysErrorWin(ErrorCode: Integer; Drive: Byte; Device: Pointer; IgnoreOK: Boolean): Byte;
function Confirm(const Title: string; Text1, Text2, Button, Skip, All: string; Options: PView; Help: Word; Disp: Boolean;
  var AllYes: Byte): Word;
function SureConfirm(const Title: string; Text1, Text2, Text3, Text4, Button, Extra, Extra2, Skip, Cancel: string;
  Options: PView; Help: Word; All: Byte; UpName: Boolean; var AllYes: Byte): Word;
function BytesToLongint(B1, B2, B3, B4: Byte): Longint;
function ByteToBlock(B: Longint): Longint;
procedure ByteToBlockLonglongint(var B: Longlongint; const C: Longlongint);
procedure ReadExtBlock(Track, Sector: Byte; Buffer: PBlock);
procedure WriteExtBlock(Track, Sector: Byte; Buffer: PBlock);
procedure ReadDirBlock(Buffer: PBlock);
procedure ReadSpecDirBlock(Track, Sector: Byte; Buffer: PBlock; First, Last: Boolean);
procedure CopyPart(var FromFile, ToFile: ExtFile; Len: Longint; BlockSize: Word);
function NewHistoryItem(const AHotStr, ATitle: string; ACode: Byte; Menu: Boolean; PrevItem: PHistoryItem): PHistoryItem;
function NewEmptyKey(Next: PStatusItem): PStatusItem;
procedure ResetAutoReplies;
procedure SaveAutoReplies;
procedure LynxHeader;
procedure ZipDirLister;
procedure CharBuffer;
procedure AltCharBuffer;
procedure InitShell;
procedure DoneShell;
procedure Screen1;
procedure Screen2;
procedure Screen3;
procedure Screen4;

implementation

uses
  App, Drivers,
  Config;

{Programs to be run inside the external CBM drive}
procedure DriveProgs; external;
{$L DRIVEPRG.OBJ}

{The Lynx archive header}
procedure LynxHeader; external;
{$L LYNXHDR.OBJ}

{The directory lister of filepacked ZipCode archives}
procedure ZipDirLister; external;
{$L ZIPLIST.OBJ}

{C64 character set}
procedure CharBuffer; external;
{$L CHARSET.OBJ}

{Alternative C64 character set}
procedure AltCharBuffer; external;
{$L CHARSET2.OBJ}

{External routines for a DOS shell}
procedure InitShell; external;
procedure DoneShell; external;
{$L SHLINT.OBJ}

procedure Screen1; external;
{$L SCREEN1.OBJ}

procedure Screen2; external;
{$L SCREEN2.OBJ}

procedure Screen3; external;
{$L SCREEN3.OBJ}

procedure Screen4; external;
{$L SCREEN4.OBJ}

{Compute the number of ticks needed for the execution of the timer setup
  routine; this value is subtracted from the number of ticks put into the
  timer by the real delay routine simulated here}
procedure ComputeDelay; assembler;
asm
    push plHigh;
    call InterruptOff;
    mov cx, 100;
    mov dx, MaxWord;
    mov CopyDelayValue, 0;
@4: mov al, $B0;
    out $43, al;
    in al, $61;
    and al, $FD;
    or al, 1;
    out $61, al;
    mov al, $FF;
    out $42, al;
    out $42, al;
    mov ax, 10;
    call far ptr @1;
    mov al, $80;
    out $43, al;
    call @2;
    in al, $42;
    mov ah, al;
    call @2;
    in al, $42;
    xchg al, ah;
    not ax;
    or ax, ax;
    je @3;
    cmp dx, ax;
    jbe @3;
    mov dx, ax;
@3: loop @4;
    mov CopyDelayValue, dx;
    call InterruptOn;
    jmp @5;
@1: sub ax, CopyDelayValue;
    jae @6;
@6: push ax;
    pop ax;
    in al, $61;
    and al, $FD;
    or al, 1;
    out $61, al;
    mov ah, al;
    out $61, al;
    out $61, al;
    in al, $61;
    and al, $20;
    je @7;
@7: retf;
@2: nop;
    retn;
@5:
end;

{Synchronize data transfer between the PC and the external CBM drive, by
  waiting for a given amount of time
  Input : AX: number of PIT cycles to wait for}
procedure Delay; assembler;
asm
(* DEBUG
    push cx;
    push dx;
    xor dx, dx;
    mov cx, 10;
    div cx;
    mov cx, ax;
    inc cx;
    call OpenCBMuSleep;
    pop dx;
    pop cx;
    ret;
   DEBUG *)
    sub ax, CopyDelayValue;
    ja @1;
    mov ax, 1;
@1: push ax;
    mov al, $B0;
    out $43, al;
    pop ax;
    out $42, al;
    mov al, ah;
    out $42, al;
    in al, $61;
    and al, $FD;
    or al, 1;
    out $61, al;
@2: in al, $61;
    and al, $20;
    je @2;
end;

{Turn interrupts and task switching off
  Input : Level: priority level; switch off occurs only if high priority level}
procedure InterruptOff(Level: Byte); assembler;
asm
    cmp InterruptsOff, False;
    jne @1;
    mov al, Level;
    cmp al, plLow;
    je @1;
    mov InterruptsOff, True;
    cli;
@1:
end;

{Turn interrupts and task switching on}
procedure InterruptOn; assembler;
asm
    cmp InterruptsOff, False;
    je @1;
    mov InterruptsOff, False;
    sti;
@1:
end;

{Set the ATN line of the LPT port to low on a normal/extended cable}
procedure AtnLoNormal; far; assembler;
asm
    mov dx, LPTAddr;
    add dx, 2;
    mov al, sbAtnNormal;
    or al, Serial;
    out dx, al;
    mov Serial, al;
end;

{Set the ATN line of the LPT port to high on a normal/extended cable}
procedure AtnHiNormal; far; assembler;
asm
    mov dx, LPTAddr;
    add dx, 2;
    mov al, not sbAtnNormal;
    and al, Serial;
    out dx, al;
    mov Serial, al;
end;

{Set the CLK line of the LPT port to low on a normal/extended cable}
procedure ClkLoNormal; far; assembler;
asm
    mov dx, LPTAddr;
    add dx, 2;
    mov al, sbClkNormal;
    or al, Serial;
    out dx, al;
    mov Serial, al;
end;

{Set the CLK line of the LPT port to high on a normal/extended cable}
procedure ClkHiNormal; far; assembler;
asm
    mov dx, LPTAddr;
    add dx, 2;
    mov al, not sbClkNormal;
    and al, Serial;
    out dx, al;
    mov Serial, al;
end;

{Set the DATA line of the LPT port to low on a normal/extended/active cable}
procedure DataLoNormal; far; assembler;
asm
    mov dx, LPTAddr;
    add dx, 2;
    mov al, DataBit;
    or al, Serial;
    out dx, al;
    mov Serial, al;
end;

{Set the DATA line of the LPT port to high on a normal/extended/active cable}
procedure DataHiNormal; far; assembler;
asm
    mov dx, LPTAddr;
    add dx, 2;
    mov al, DataBit;
    not al;
    and al, Serial;
    out dx, al;
    mov Serial, al;
end;

{Set the ATN line of the LPT port to low via the OpenCBM driver}
procedure AtnLoOpenCBM; far; assembler;
asm
    push cx;
    mov cl, sbAtnOpenCBM;
    call OpenCBMIECSet;
    pop cx;
end;

{Set the ATN line of the LPT port to high via the OpenCBM driver}
procedure AtnHiOpenCBM; far; assembler;
asm
    push cx;
    mov cl, sbAtnOpenCBM;
    call OpenCBMIECRelease;
    pop cx;
end;

{Set the CLK line of the LPT port to low via the OpenCBM driver}
procedure ClkLoOpenCBM; far; assembler;
asm
    push cx;
    mov cl, sbClkOpenCBM;
    call OpenCBMIECSet;
    pop cx;
end;

{Set the CLK line of the LPT port to high via the OpenCBM driver}
procedure ClkHiOpenCBM; far; assembler;
asm
    push cx;
    mov cl, sbClkOpenCBM;
    call OpenCBMIECRelease;
    pop cx;
end;

{Set the DATA line of the LPT port to low via the OpenCBM driver}
procedure DataLoOpenCBM; far; assembler;
asm
    push cx;
    mov cl, sbDataOpenCBM;
    call OpenCBMIECSet;
    pop cx;
end;

{Set the DATA line of the LPT port to high via the OpenCBM driver}
procedure DataHiOpenCBM; far; assembler;
asm
    push cx;
    mov cl, sbDataOpenCBM;
    call OpenCBMIECRelease;
    pop cx;
end;

{Check if the user pressed Escape or F10 and report a timeout in that case
  Output: CF: when not zero, a timeout has occured}
procedure TCheckTimeoutReal; far; assembler;
asm
    cmp Timeout, 0;
    jne @1;
    mov al, $0A;
    out $20, al;
    in al, $20;
    and al, $02;
    clc;
    je @2;
    int 9;
    in al, $60;
    cmp al, $01;
    je @3;
    cmp al, $44;
    clc;
    jne @2;
@3: inc Timeout;
    or Status, ssTimeOut;
@1: stc;
@2:
end;

{Empty timeout check routine
  Output: CF: zero, no timeout has occured}
procedure TCheckTimeoutEmpty; far; assembler;
asm
    clc;
end;

{Empty serial bus reader for no cable attached}
procedure ReadLineNone; far; assembler;
asm
    or Status, ssNoDevice;
    xor al, al;
    stc;
end;

{Read the status of the DATA and CLK lines of the normal cable
  Output: AL: the status of the lines
          CF: when not zero, a timeout has occured, the user pressed
              Escape or F10}
procedure ReadLineNormal; far; assembler;
asm
    call CheckTimeout;
    jc @2;
    mov dx, LPTAddr;
    add dx, 2;
    in al, dx;
@1: mov ah, al;
    in al, dx;
    cmp ah, al;
    jne @1;
    and al, (sbClkNormal + sbDataNormal);
    clc;
@2:
end;

{Read the status of the DATA and CLK lines of the extended cable
  Output: AL: the status of the lines
          CF: when not zero, a timeout has occured, the user pressed
              Escape or F10}
procedure ReadLineExtended; far; assembler;
asm
    call CheckTimeout;
    jc @2;
    mov dx, LPTAddr;
    inc dx;
    in al, dx;
@1: mov ah, al;
    in al, dx;
    cmp ah, al;
    jne @1;
    xor al, ((sbAtnNormal + sbClkNormal) shl 4);
    shr al, 4;
    mov ah, al;
    and al, (sbClkNormal + sbDataNormal);
    clc;
@2:
end;

{Read the status of the DATA and CLK lines of the multitask cable
  Output: AL: the status of the lines
          CF: when not zero, a timeout has occured, the user pressed
              Escape or F10}
procedure ReadLineMultitask; far; assembler;
asm
    call CheckTimeout;
    jc @2;
    mov dx, LPTAddr;
    inc dx;
    in al, dx;
@1: mov ah, al;
    in al, dx;
    cmp ah, al;
    jne @1;
    xor al, ((sbAtnNormal + sbClkNormal + sbDataSwapped) shl 4);
    shr al, 4;
    mov ah, al;
    and al, (sbClkNormal + sbDataSwapped);
    clc;
@2:
end;

{Read the status of the DATA and CLK lines of the active cable
  Output: AL: the status of the lines
          CF: when not zero, a timeout has occured, the user pressed
              Escape or F10}
procedure ReadLineActive; far; assembler;
asm
    call CheckTimeout;
    jc @2;
    mov dx, LPTAddr;
    inc dx;
    in al, dx;
@1: mov ah, al;
    in al, dx;
    cmp ah, al;
    jne @1;
    xor al, ((sbAtnNormal + sbClkNormal + sbDataSwapped) shl 4);
    shr al, 4;
    mov ah, al;
    and al, (sbClkNormal + sbDataSwapped);
    clc;
@2:
end;

procedure ReadLineOpenCBM; far; assembler;
asm
    call OpenCBMIECPoll;
    and al, (sbClkOpenCBM + sbDataOpenCBM);
    clc;
end;

{Set the error status
  Input : AL: error code to set error status to
  Output: AL: empty data byte
          CF: set to indicate error}
procedure Error; far; assembler;
asm
    or Status, al;
    call InterruptOn;
    call AtnHi;
    call ClkHi;
    call DataHi;
    xor al, al;
    stc;
end;

{Determine the default parallel port control byte for a serial cable}
procedure InitSerial;
begin
  case SerialCable of
    scMultitask: Serial := sbDataSwapped;
    scActive: Serial := (sbAtnNormal + sbClkNormal + sbResetSwapped);
  else
    Serial := sbResetNormal;
  end;
end;

{Reset the parallel port of a serial cable}
procedure ResetLPTPort; assembler;
asm
    push LPTAddr;
    call ValidLPTAddr;
    or al, al;
    je @1;
    mov dx, LPTAddr;
    add dx, 2;
    call InitSerial;
    mov al, Serial;
    out dx, al;
@1:
end;

{Reset all external Commodore drives on a serial cable}
procedure ResetDrives; assembler;
asm
    cmp SerialCable, scOpenCBM;
    jne @5;
    call OpenCBMVDDInit;
    test ax, ax;
    jne @2;
    call OpenCBMDriverOpen;
    test ax, ax;
    jne @2;
    call OpenCBMReset;
    jmp @2;
@5: push LPTAddr;
    call ValidLPTAddr;
    or al, al;
    je @2;
    call InitSerial;
    mov dx, LPTAddr;
    add dx, 2;
    mov al, ResetBit;
    cmp SerialCable, scMultitask;
    jne @3;
    or al, Serial;
    jmp @4;
@3: not al;
    and al, Serial;
@4: out dx, al;
    mov cx, 100;
@1: mov ax, 1000;
    call Delay;
    loop @1;
    mov al, Serial;
    out dx, al;
@2:
end;

{Set timeout detection on or off
  Input : On: when True, timeout detection is switched on, otherwise off}
procedure SetTimeout(On: Boolean);
begin
  if On and ManualTimeouts then CheckTimeout := TCheckTimeoutReal else
    CheckTimeout := TCheckTimeoutEmpty;
  Timeout := False;
end;

{Determine if the parallel port is in the interval of valid addresses
  Input : Addr: the port address
  Output: when True, the port address is valid}
function ValidLPTAddr(Addr: Word): Boolean; assembler;
asm
    mov al, False;
    cmp DisableLPTPorts, False;
    jne @1;
    mov dx, Addr;
    cmp dx, $0200;
    jb @1;
    cmp dx, $F800;
    ja @1;
    test dx, 3;
    jne @1;
    inc al;
@1:
end;

{Shut down the turbo program running in the external CBM drive}
procedure TurboOff; assembler;
asm
    call AtnHi;
    call ClkLo;
    call DataHi;
    mov cx, 150;
@1: mov ax, 1000;
    call Delay;
    loop @1;
    mov TurboOffed, True;
    call GetTicks;
    add ax, TurboOffTicks;
    adc dx, 0;
    mov word ptr TurboOffCount[0], ax;
    mov word ptr TurboOffCount[2], dx;
end;

{Some time after shutting down the turbo program, set CLK back to high, to
  decouple the PC from the serial bus}
procedure TurboOffDecouple;
begin
  asm
    mov TurboOffed, False;
    call ClkHi;
  end;
  DisableWinNTPortAccess;
end;

{Turn ATN back to high after having transferred data with the serial async
  routines}
procedure ShutDownAsync;
begin
  if CopyCableMode = cmAsync then
  begin
    asm
      mov ax, 10;
      call Delay;
      call AtnHi;
      mov ax, 5000;
      call Delay;
    end;
  end;
end;

{Initialize both parallel ports if they - and the corresponding cable - are
  not defined as 'None'; ECP ports must be set to Byte mode, and all kinds
  of ports must be set to input mode}
procedure InitLPTPorts; assembler;
asm
    cmp SerialCable, scNone;
    je @1;
    mov dx, LPTAddr;
    call @2;
    jc @1;
    cmp ParallelCable, pcNone;
    je @1;
    mov dx, ParLPTAddr;
    cmp dx, LPTAddr;
    je @1;
    call @2;
    jmp @1;
@2: push dx;
    push dx;
    call ValidLPTAddr;
    pop dx;
    or al, al;
    stc;
    je @3;
    add dx, 2;
    in al, dx;
    and al, not sbBidir;
    out dx, al;
    sub dx, 2;
    mov al, $FF;
    out dx, al;
    add dx, ECPAddrOffs;
    add dx, 2;
    mov al, $34;
    out dx, al;
    sub dx, ECPAddrOffs;
    in al, dx;
    or al, sbBidir;
    out dx, al;
@3: clc;
    retn;
@1:
end;

{Switch the parallel port of the hybrid/parallel cable to input}
procedure ParallelInput; assembler;
asm
    mov al, CopyCableMode;
    cmp al, cmHybrid;
    je @1;
    cmp al, cmParallel;
    jne @2;
@1: cmp SerialCable, scOpenCBM;
    je @2;
    mov dx, ParLPTAddr;
    mov al, $FF;
    out dx, al;
    add dx, 2;
    mov al, Serial;
    or al, sbBidir;
    mov Serial, al;
    out dx, al;
@2:
end;

{Switch the parallel port of the hybrid/parallel cable to output}
procedure ParallelOutput; assembler;
asm
    mov al, CopyCableMode;
    cmp al, cmHybrid;
    je @1;
    cmp al, cmParallel;
    jne @2;
@1: cmp SerialCable, scOpenCBM;
    je @2;
    mov dx, ParLPTAddr;
    add dx, 2;
    mov al, Serial;
    and al, not sbBidir;
    mov Serial, al;
    out dx, al;
@2:
end;

{Receive a byte from the external CBM drive
  Output: the byte received}
procedure Receive; assembler;
asm
    cmp SerialCable, scOpenCBM;
    jne @12;
    push si;
    push es;
    push ds;
    pop es;
    mov cx, Type Byte;
    mov si, Offset(InData);
    call OpenCBMRawRead;
    pop es;
    pop si;
    test ax, ax;
    je @13;
    jns @14;
    or Status, ssTimeout;
@14:call OpenCBMGetEOI;
    test ax, ax;
    je @15;
@13:or Status, ssEOF;
@15:mov al, InData;
    jmp @16;
@12:push plHigh;
    call InterruptOff;
    xor cl, cl;
    mov InData, cl;
    call ClkHi;
@1: call ReadLine;
    jc @11;
    test al, sbClkNormal;
    jne @1;
@6: mov bx, 20;
    call DataHi;
@3: dec bx;
    je @2;
    mov ax, 20;
    call Delay;
    call ReadLine;
    jc @11;
    test al, sbClkNormal;
    je @3;
    jmp @4;
@2: or cl, cl;
    je @5;
@11:mov al, ssTimeout;
    jmp Error;
@5: call DataLo;
    call ClkHi;
    or Status, ssEOF;
    mov ax, 60;
    call Delay;
    inc cl;
    jmp @6;
@4: mov bx, 8;
@7: call ReadLine;
    jc @11;
    test al, sbClkNormal;
    jne @7;
    test al, DataBit;
    stc;
    je @8;
    clc;
@8: rcr InData, 1;
@9: call ReadLine;
    jc @11;
    test al, sbClkNormal;
    je @9;
    dec bx;
    jne @7;
    call DataLo;
    test Status, ssEOF;
    je @10;
    mov ax, 150;
    call Delay;
    call ClkHi;
    call DataHi;
@10:mov al, InData;
    call InterruptOn;
@16:
end;

{Send a byte to the external CBM drive}
procedure SendReal; far; assembler;
asm
    push plHigh;
    call InterruptOff;
    call DataHi;
    mov ax, 25;
    call Delay;
    call ReadLine;
    jc @5;
    test al, DataBit;
    je @1;
    call ClkHi;
    cmp EOI, False;
    je @2;
@3: call ReadLine;
    jc @5;
    test al, DataBit;
    jne @3;
@4: call ReadLine;
    jc @5;
    test al, DataBit;
    je @4;
@2: call ReadLine;
    jc @5;
    test al, DataBit;
    jne @2;
    call ClkLo;
    mov bx, 8;
@8: mov ax, 25;
    call Delay;
    call ReadLine;
    jc @5;
    test al, DataBit;
    jne @5;
    mov ax, 100;
    call Delay;
    shr OutData, 1;
    jc @6;
    call DataLo;
    jne @7;
@6: call DataHi;
@7: call ClkHi;
    mov ax, 25;
    call Delay;
    call DataHi;
    call ClkLo;
    dec bx;
    jne @8;
    mov cx, 10;
@10:mov ax, 20;
    call Delay;
    call ReadLine;
    jc @5;
    test al, DataBit;
    jne @9;
    loop @10;
@5: mov al, ssInputTimeout;
    jmp Error;
@1: mov al, ssNoDevice;
    jmp Error;
@9: call InterruptOn;
end;

{Buffer a byte to be sent to the external CBM drive and send the previous
  byte
  Input : AL: the byte to send}
procedure Send; assembler;
asm
    cmp SerialCable, scOpenCBM;
    jne @3;
    mov OutData, al;
    push si;
    push es;
    push ds;
    pop es;
    mov cx, Type Byte;
    mov si, Offset(OutData);
    call OpenCBMRawWrite;
    pop es;
    pop si;
    test ax, ax;
    jns @4;
    or Status, ssInputTimeout;
    jmp @4;
@3: cmp More, False;
    jne @1;
    mov More, True;
    jmp @2;
@1: push ax;
    call SendReal;
    pop ax;
@2: mov OutData, al;
@4:
end;

{Wait for the external CBM 1541/1570/1571 drive to be ready for turbo data
  transfer via the normal cable}
procedure TWaitNormal; far; assembler;
asm
    call AtnLo;
    mov cx, 20;
@1: in al, dx;
    test al, sbDataNormal;
    jne @1;
    in al, dx;
    test al, sbClkNormal;
    jne @2;
    loop @1;
    mov al, ssInputTimeout;
    jmp Error;
@2: clc;
end;

{Wait for the external CBM 1541/1570/1571 drive to be ready for turbo data
  transfer via the extended cable}
procedure TWaitExtended; far; assembler;
asm
    call AtnLo;
    mov cx, 20;
    dec dx;
@1: in al, dx;
    test al, (sbDataNormal shl 4);
    jne @1;
    in al, dx;
    test al, (sbClkNormal shl 4);
    je @2;
    loop @1;
    mov al, ssInputTimeout;
    jmp Error;
@2: clc;
end;

{Wait for the external CBM 1541/1570/1571 drive to be ready for turbo data
  transfer via the multitask cable}
procedure TWaitMultitask; far; assembler;
asm
    call AtnLo;
    mov cx, 20;
    dec dx;
@1: in al, dx;
    test al, (sbDataSwapped shl 4);
    je @1;
    in al, dx;
    test al, (sbClkNormal shl 4);
    je @2;
    loop @1;
    mov al, ssInputTimeout;
    jmp Error;
@2: clc;
end;

{Wait for the external CBM 1541/1570/1571 drive to be ready for turbo data
  transfer via the active cable}
procedure TWaitActive; far; assembler;
asm
    call AtnLo;
    mov cx, 20;
    dec dx;
@1: in al, dx;
    test al, (sbDataSwapped shl 4);
    je @1;
    in al, dx;
    test al, (sbClkNormal shl 4);
    je @2;
    loop @1;
    mov al, ssInputTimeout;
    jmp Error;
@2: clc;
end;

{Wait for the external CBM 1541/1570/1571 drive to be ready for turbo data
  transfer via the OpenCBM driver}
procedure TWaitOpenCBM; far; assembler;
asm
    mov cl, sbAtnOpenCBM;
    call OpenCBMIECSet;
    mov cx, 20;
@1: call OpenCBMIECPoll;
    test al, sbDataOpenCBM;
    jne @1;
    call OpenCBMIECPoll;
    test al, sbClkOpenCBM;
    clc;
    jne @2;
    loop @1;
    mov al, ssInputTimeout;
    jmp Error;
@2: clc;
end;

{Turbo-receive a byte from the external CBM 1541 drive via the normal cable,
  at 1 MegaHertz
  Output: AL: the byte received}
procedure TReceiveNormal1MHz; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 15 + RelaxDelay;
    call Delay;
    in al, dx;
    rcr al, 2;
    rcl InData, 1;
    rcr al, 2;
    rcl InData, 1;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1570/1571 drive via the normal
  cable, at 2 MegaHertz
  Output: AL: the byte received}
procedure TReceiveNormal2MHz; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 7 + RelaxDelay;
    call Delay;
    in al, dx;
    rcr al, 2;
    rcl InData, 1;
    rcr al, 2;
    rcl InData, 1;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1541 drive via the normal cable,
  in asynchronous mode, at 1 MegaHertz
  Output: AL: the byte received}
procedure TReceiveNormalAsync1MHz; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 15 + RelaxDelay;
    call Delay;
    in al, dx;
    push ax;
    call AtnLo;
    pop ax;
    rcr al, 2;
    rcl InData, 1;
    rcr al, 2;
    rcl InData, 1;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1570/1571 drive via the normal
  cable, in asynchronous mode, at 2 MegaHertz
  Output: AL: the byte received}
procedure TReceiveNormalAsync2MHz; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 7 + RelaxDelay;
    call Delay;
    in al, dx;
    push ax;
    call AtnLo;
    pop ax;
    rcr al, 2;
    rcl InData, 1;
    rcr al, 2;
    rcl InData, 1;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1541 drive via the extended cable,
  at 1 MegaHertz
  Output: AL: the byte received}
procedure TReceiveExtended1MHz; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 15 + RelaxDelay;
    call Delay;
    dec dx;
    in al, dx;
    xor al, ((sbAtnNormal + sbClkNormal) shl 4);
    rcr al, 6;
    rcl InData, 1;
    rcr al, 2;
    rcl InData, 1;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1570/1571 drive via the extended
  cable, at 2 MegaHertz
  Output: AL: the byte received}
procedure TReceiveExtended2MHz; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 7 + RelaxDelay;
    call Delay;
    dec dx;
    in al, dx;
    xor al, ((sbAtnNormal + sbClkNormal) shl 4);
    rcr al, 6;
    rcl InData, 1;
    rcr al, 2;
    rcl InData, 1;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1541 drive via the extended cable,
  in asynchronous mode, at 1 MegaHertz
  Output: AL: the byte received}
procedure TReceiveExtendedAsync1MHz; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 15 + RelaxDelay;
    call Delay;
    dec dx;
    in al, dx;
    push ax;
    call AtnLo;
    pop ax;
    xor al, ((sbAtnNormal + sbClkNormal) shl 4);
    rcr al, 6;
    rcl InData, 1;
    rcr al, 2;
    rcl InData, 1;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1570/1571 drive via the extended
  cable, in asynchronous mode, at 2 MegaHertz
  Output: AL: the byte received}
procedure TReceiveExtendedAsync2MHz; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 7 + RelaxDelay;
    call Delay;
    dec dx;
    in al, dx;
    push ax;
    call AtnLo;
    pop ax;
    xor al, ((sbAtnNormal + sbClkNormal) shl 4);
    rcr al, 6;
    rcl InData, 1;
    rcr al, 2;
    rcl InData, 1;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1541 drive via the multitask
  cable, at 1 MegaHertz
  Output: AL: the byte received}
procedure TReceiveMultitask1MHz; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 15 + RelaxDelay;
    call Delay;
    dec dx;
    in al, dx;
    xor al, ((sbAtnNormal + sbClkNormal + sbDataSwapped) shl 4);
    rcr al, 6;
    rcl InData, 1;
    rcr al, 1;
    rcl InData, 1;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1570/1571 drive via the multitask
  cable, at 2 MegaHertz
  Output: AL: the byte received}
procedure TReceiveMultitask2MHz; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 7 + RelaxDelay;
    call Delay;
    dec dx;
    in al, dx;
    xor al, ((sbAtnNormal + sbClkNormal + sbDataSwapped) shl 4);
    rcr al, 6;
    rcl InData, 1;
    rcr al, 1;
    rcl InData, 1;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1541 drive via the multitask
  cable, in asynchronous mode, at 1 MegaHertz
  Output: AL: the byte received}
procedure TReceiveMultitaskAsync1MHz; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 15 + RelaxDelay;
    call Delay;
    dec dx;
    in al, dx;
    push ax;
    call AtnLo;
    pop ax;
    xor al, ((sbAtnNormal + sbClkNormal + sbDataSwapped) shl 4);
    rcr al, 6;
    rcl InData, 1;
    rcr al, 1;
    rcl InData, 1;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1570/1571 drive via the multitask
  cable, in asynchronous mode, at 2 MegaHertz
  Output: AL: the byte received}
procedure TReceiveMultitaskAsync2MHz; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 7 + RelaxDelay;
    call Delay;
    dec dx;
    in al, dx;
    push ax;
    call AtnLo;
    pop ax;
    xor al, ((sbAtnNormal + sbClkNormal + sbDataSwapped) shl 4);
    rcr al, 6;
    rcl InData, 1;
    rcr al, 1;
    rcl InData, 1;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1541 drive via the active cable,
  at 1 MegaHertz
  Output: AL: the byte received}
procedure TReceiveActive1MHz; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 15 + RelaxDelay;
    call Delay;
    dec dx;
    in al, dx;
    xor al, ((sbAtnNormal + sbClkNormal + sbDataSwapped) shl 4);
    rcr al, 6;
    rcl InData, 1;
    rcr al, 1;
    rcl InData, 1;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1570/1571 drive via the active
  cable, at 2 MegaHertz
  Output: AL: the byte received}
procedure TReceiveActive2MHz; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 7 + RelaxDelay;
    call Delay;
    dec dx;
    in al, dx;
    xor al, ((sbAtnNormal + sbClkNormal + sbDataSwapped) shl 4);
    rcr al, 6;
    rcl InData, 1;
    rcr al, 1;
    rcl InData, 1;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1541 drive via the active cable,
  in asynchronous mode, at 1 MegaHertz
  Output: AL: the byte received}
procedure TReceiveActiveAsync1MHz; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 15 + RelaxDelay;
    call Delay;
    dec dx;
    in al, dx;
    push ax;
    call AtnLo;
    pop ax;
    xor al, ((sbAtnNormal + sbClkNormal + sbDataSwapped) shl 4);
    rcr al, 6;
    rcl InData, 1;
    rcr al, 1;
    rcl InData, 1;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1570/1571 drive via the active
  cable, in asynchronous mode, at 2 MegaHertz
  Output: AL: the byte received}
procedure TReceiveActiveAsync2MHz; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 7 + RelaxDelay;
    call Delay;
    dec dx;
    in al, dx;
    push ax;
    call AtnLo;
    pop ax;
    xor al, ((sbAtnNormal + sbClkNormal + sbDataSwapped) shl 4);
    rcr al, 6;
    rcl InData, 1;
    rcr al, 1;
    rcl InData, 1;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1541/1570/1571 drive via the
  hybrid cable, at 1 or 2 MegaHertz
  Output: AL: the byte received}
procedure TReceiveHybrid; far; assembler;
asm
    mov bx, 2;
@2: call TWait;
    jc @1;
    mov dx, ParLPTAddr;
    inc dx;
    in al, dx;
    push ax;
    call AtnHi;
    pop ax;
    xor al, $80;
    and al, $F0;
    shr InData, 4;
    or InData, al;
@3: call ReadLine;
    test al, DataBit;
    jne @3;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Read in data byte from the parallel cable data port}
procedure TReadParallelReal; far; assembler;
asm
    mov dx, ParLPTAddr;
    in al, dx;
end;

{Read in data byte from the parallel cable data port via the OpenCBM driver}
procedure TReadParallelOpenCBM; far; assembler;
asm
    call OpenCBMPPRead;
end;

{Turbo-receive a byte from the external CBM 1541/1570/1571 drive via the
  parallel cable, at 1 or 2 MegaHertz
  Output: AL: the byte received}
procedure TReceiveParallel; far; assembler;
asm
    call TWait;
    jc @1;
    call TReadParallel;
    push ax;
    call AtnHi;
@2: call ReadLine;
    test al, DataBit;
    jne @2;
    pop ax;
@1:
end;

{Turbo-receive a byte from the external CBM 1541 drive via the OpenCBM
  driver, in asynchronous mode, at 1 MegaHertz
  Output: AL: the byte received}
procedure TReceiveOpenCBM1MHz; far; assembler;
asm
    mov InData, 0;
    mov bx, 4;
    call OpenCBMIECPoll;
@2: call TWait;
    jc @1;
    mov cl, sbAtnOpenCBM;
    call OpenCBMIECRelease;
    call OpenCBMIECPoll;
    mov ax, 15 + RelaxDelay;
    call Delay;
    call OpenCBMIECPoll;
    push ax;
    mov cl, sbAtnOpenCBM;
    call OpenCBMIECSet;
    call OpenCBMIECPoll;
    pop ax;
    and al, (sbDataOpenCBM + sbClkOpenCBM);
    rcl InData, 2;
    or InData, al;
    dec bx;
    jne @2;
    clc;
@1: call OpenCBMIECPoll;
    mov al, InData;
end;

{Turbo-receive a byte from the external CBM 1570/1571 drive via the OpenCBM
  driver, in asynchronous mode, at 2 MegaHertz
  Output: AL: the byte received}
procedure TReceiveOpenCBM2MHz; far; assembler;
asm
    mov InData, 0;
    mov bx, 4;
    call OpenCBMIECPoll;
@2: call TWait;
    jc @1;
    mov cl, sbAtnOpenCBM;
    call OpenCBMIECRelease;
    call OpenCBMIECPoll;
    mov ax, 7 + RelaxDelay;
    call Delay;
    call OpenCBMIECPoll;
    push ax;
    mov cl, sbAtnOpenCBM;
    call OpenCBMIECSet;
    call OpenCBMIECPoll;
    pop ax;
    and al, (sbDataOpenCBM + sbClkOpenCBM);
    rcl InData, 2;
    or InData, al;
    dec bx;
    jne @2;
    clc;
@1: call OpenCBMIECPoll;
    mov al, InData;
end;

{Turbo-send a byte to the external CBM 1541 drive via the normal or extended
  cable, at 1 MegaHertz
  Input : AL: the byte to send}
procedure TSendNormalExtended1MHz; far; assembler;
asm
    mov OutData, al;
    mov bx, 4;
@2: call TWait;
    jc @1;
    xor al, al;
    rcr OutData, 1;
    rcl al, 2;
    rcr OutData, 1;
    rcl al, 2;
    and Serial, not (sbAtnNormal + sbClkNormal + sbDataNormal);
    or al, Serial;
    mov dx, LPTAddr;
    add dx, 2;
    out dx, al;
    mov ax, 21 + RelaxDelay;
    call Delay;
    mov al, Serial;
    out dx, al;
    dec bx;
    jne @2;
@1:
end;

{Turbo-send a byte to the external CBM 1570/1571 drive via the normal or
  extended cable, at 2 MegaHertz
  Input : AL: the byte to send}
procedure TSendNormalExtended2MHz; far; assembler;
asm
    mov OutData, al;
    mov bx, 4;
@2: call TWait;
    jc @1;
    xor al, al;
    rcr OutData, 1;
    rcl al, 2;
    rcr OutData, 1;
    rcl al, 2;
    and Serial, not (sbAtnNormal + sbClkNormal + sbDataNormal);
    or al, Serial;
    mov dx, LPTAddr;
    add dx, 2;
    out dx, al;
    mov ax, 9 + RelaxDelay;
    call Delay;
    mov al, Serial;
    out dx, al;
    dec bx;
    jne @2;
@1:
end;

{Turbo-send a byte to the external CBM 1541 drive via the normal or extended
  cable, in asynchronous mode, at 1 MegaHertz
  Input : AL: the byte to send}
procedure TSendNormalExtendedAsync1MHz; far; assembler;
asm
    mov OutData, al;
    mov bx, 4;
@2: call TWait;
    jc @1;
    xor al, al;
    rcr OutData, 1;
    rcl al, 2;
    rcr OutData, 1;
    rcl al, 2;
    and Serial, not (sbAtnNormal + sbClkNormal + sbDataNormal);
    or al, Serial;
    mov dx, LPTAddr;
    add dx, 2;
    out dx, al;
    mov ax, 21 + RelaxDelay;
    call Delay;
    mov al, Serial;
    or al, sbAtnNormal;
    mov Serial, al;
    out dx, al;
    dec bx;
    jne @2;
@1:
end;

{Turbo-send a byte to the external CBM 1570/1571 drive via the normal or
  extended cable, in asynchronous mode, at 2 MegaHertz
  Input : AL: the byte to send}
procedure TSendNormalExtendedAsync2MHz; far; assembler;
asm
    mov OutData, al;
    mov bx, 4;
@2: call TWait;
    jc @1;
    xor al, al;
    rcr OutData, 1;
    rcl al, 2;
    rcr OutData, 1;
    rcl al, 2;
    and Serial, not (sbAtnNormal + sbClkNormal + sbDataNormal);
    or al, Serial;
    mov dx, LPTAddr;
    add dx, 2;
    out dx, al;
    mov ax, 9 + RelaxDelay;
    call Delay;
    mov al, Serial;
    or al, sbAtnNormal;
    mov Serial, al;
    out dx, al;
    dec bx;
    jne @2;
@1:
end;

{Turbo-send a byte to the external CBM 1541 drive via the multitask cable, at
  1 MegaHertz
  Input : AL: the byte to send}
procedure TSendMultitask1MHz; far; assembler;
asm
    mov OutData, al;
    mov bx, 4;
@2: call TWait;
    jc @1;
    xor ah, ah;
    rcr OutData, 1;
    cmc;
    rcl ah, 1;
    rcr OutData, 1;
    rcl ah, 2;
    and Serial, not (sbAtnNormal + sbClkNormal);
    or Serial, sbDataSwapped;
    mov al, Serial;
    and al, not sbDataSwapped;
    or al, ah;
    mov dx, LPTAddr;
    add dx, 2;
    out dx, al;
    mov ax, 21 + RelaxDelay;
    call Delay;
    mov al, Serial;
    out dx, al;
    dec bx;
    jne @2;
@1:
end;

{Turbo-send a byte to the external CBM 1570/1571 drive via the multitask
  cable, at 2 MegaHertz
  Input : AL: the byte to send}
procedure TSendMultitask2MHz; far; assembler;
asm
    mov OutData, al;
    mov bx, 4;
@2: call TWait;
    jc @1;
    xor ah, ah;
    rcr OutData, 1;
    cmc;
    rcl ah, 1;
    rcr OutData, 1;
    rcl ah, 2;
    and Serial, not (sbAtnNormal + sbClkNormal);
    or Serial, sbDataSwapped;
    mov al, Serial;
    and al, not sbDataSwapped;
    or al, ah;
    mov dx, LPTAddr;
    add dx, 2;
    out dx, al;
    mov ax, 9 + RelaxDelay;
    call Delay;
    mov al, Serial;
    out dx, al;
    dec bx;
    jne @2;
@1:
end;

{Turbo-send a byte to the external CBM 1541 drive via the multitask cable, in
  asynchronous mode, at 1 MegaHertz
  Input : AL: the byte to send}
procedure TSendMultitaskAsync1MHz; far; assembler;
asm
    mov OutData, al;
    mov bx, 4;
@2: call TWait;
    jc @1;
    xor ah, ah;
    rcr OutData, 1;
    cmc;
    rcl ah, 1;
    rcr OutData, 1;
    rcl ah, 2;
    and Serial, not (sbAtnNormal + sbClkNormal);
    or Serial, sbDataSwapped;
    mov al, Serial;
    and al, not sbDataSwapped;
    or al, ah;
    mov dx, LPTAddr;
    add dx, 2;
    out dx, al;
    mov ax, 21 + RelaxDelay;
    call Delay;
    mov al, Serial;
    or al, sbAtnNormal;
    mov Serial, al;
    out dx, al;
    dec bx;
    jne @2;
@1:
end;

{Turbo-send a byte to the external CBM 1570/1571 drive via the multitask
  cable, in asynchronous mode, at 2 MegaHertz
  Input : AL: the byte to send}
procedure TSendMultitaskAsync2MHz; far; assembler;
asm
    mov OutData, al;
    mov bx, 4;
@2: call TWait;
    jc @1;
    xor ah, ah;
    rcr OutData, 1;
    cmc;
    rcl ah, 1;
    rcr OutData, 1;
    rcl ah, 2;
    and Serial, not (sbAtnNormal + sbClkNormal);
    or Serial, sbDataSwapped;
    mov al, Serial;
    and al, not sbDataSwapped;
    or al, ah;
    mov dx, LPTAddr;
    add dx, 2;
    out dx, al;
    mov ax, 9 + RelaxDelay;
    call Delay;
    mov al, Serial;
    or al, sbAtnNormal;
    mov Serial, al;
    out dx, al;
    dec bx;
    jne @2;
@1:
end;

{Turbo-send a byte to the external CBM 1541 drive via the active cable, at 1
  MegaHertz
  Input : AL: the byte to send}
procedure TSendActive1MHz; far; assembler;
asm
    mov OutData, al;
    mov bx, 4;
@2: call TWait;
    jc @1;
    xor al, al;
    rcr OutData, 1;
    rcl al, 1;
    rcr OutData, 1;
    cmc;
    rcl al, 2;
    or Serial, (sbAtnNormal + sbClkNormal);
    and Serial, not sbDataSwapped;
    mov ah, al;
    mov al, Serial;
    and al, not sbClkNormal;
    or al, ah;
    mov dx, LPTAddr;
    add dx, 2;
    out dx, al;
    mov ax, 21 + RelaxDelay;
    call Delay;
    mov al, Serial;
    out dx, al;
    dec bx;
    jne @2;
@1:
end;

{Turbo-send a byte to the external CBM 1570/1571 drive via the active cable,
  at 2 MegaHertz
  Input : AL: the byte to send}
procedure TSendActive2MHz; far; assembler;
asm
    mov OutData, al;
    mov bx, 4;
@2: call TWait;
    jc @1;
    xor al, al;
    rcr OutData, 1;
    rcl al, 1;
    rcr OutData, 1;
    cmc;
    rcl al, 2;
    or Serial, (sbAtnNormal + sbClkNormal);
    and Serial, not sbDataSwapped;
    mov ah, al;
    mov al, Serial;
    and al, not sbClkNormal;
    or al, ah;
    mov dx, LPTAddr;
    add dx, 2;
    out dx, al;
    mov ax, 9 + RelaxDelay;
    call Delay;
    mov al, Serial;
    out dx, al;
    dec bx;
    jne @2;
@1:
end;

{Turbo-send a byte to the external CBM 1541 drive via the active cable, in
  asynchronous mode, at 1 MegaHertz
  Input : AL: the byte to send}
procedure TSendActiveAsync1MHz; far; assembler;
asm
    mov OutData, al;
    mov bx, 4;
@2: call TWait;
    jc @1;
    xor ah, ah;
    rcr OutData, 1;
    rcl ah, 1;
    rcr OutData, 1;
    cmc;
    rcl ah, 2;
    mov al, Serial;
    or al, sbAtnNormal;
    and al, not (sbClkNormal + sbDataSwapped);
    or al, ah;
    mov dx, LPTAddr;
    add dx, 2;
    out dx, al;
    mov ax, 21 + RelaxDelay;
    call Delay;
    mov al, Serial;
    and al, not sbAtnNormal;
    mov Serial, al;
    out dx, al;
    dec bx;
    jne @2;
@1:
end;

{Turbo-send a byte to the external CBM 1570/1571 drive via the active cable,
  in asynchronous mode, at 2 MegaHertz
  Input : AL: the byte to send}
procedure TSendActiveAsync2MHz; far; assembler;
asm
    mov OutData, al;
    mov bx, 4;
@2: call TWait;
    jc @1;
    xor ah, ah;
    rcr OutData, 1;
    rcl ah, 1;
    rcr OutData, 1;
    cmc;
    rcl ah, 2;
    or Serial, sbAtnNormal;
    mov al, Serial;
    or al, sbAtnNormal;
    and al, not (sbClkNormal + sbDataSwapped);
    or al, ah;
    mov dx, LPTAddr;
    add dx, 2;
    out dx, al;
    mov ax, 9 + RelaxDelay;
    call Delay;
    mov al, Serial;
    and al, not sbAtnNormal;
    mov Serial, al;
    out dx, al;
    dec bx;
    jne @2;
@1:
end;

{Write data byte to the parallel cable data port}
procedure TWriteParallelReal; far; assembler;
asm
    mov dx, ParLPTAddr;
    out dx, al;
end;

{Write data byte to the parallel cable data port via the OpenCBM driver}
procedure TWriteParallelOpenCBM; far; assembler;
asm
    call OpenCBMPPWrite;
end;

{Turbo-send a byte to the external CBM 1541/1570/1571 drive via the hybrid or
  parallel cable, at 1 or 2 MegaHertz
  Input : AL: the byte to send}
procedure TSendHybridParallel; far; assembler;
asm
    call TWriteParallel;
    mov dx, ParLPTAddr;
    out dx, al;
    call TWait;
    jc @1;
    call AtnHi;
@2: call ReadLine;
    test al, DataBit;
    jne @2;
@1:
end;

{Turbo-send a byte to the external CBM 1541 drive via the OpenCBM driver,
  in asynchronous mode, at 1 MegaHertz
  Input : AL: the byte to send}
procedure TSendOpenCBM1MHz; far; assembler;
asm
    mov OutData, al;
    mov bx, 4;
@2: call TWait;
    jc @1;
    mov cl, OutData;
    and cl, (sbDataOpenCBM + sbClkOpenCBM);
    shr OutData, 2;
    mov ch, cl;
    xor cl, (sbDataOpenCBM + sbClkOpenCBM);
    or cl, sbAtnOpenCBM;
    call OpenCBMIECSetRelease;
    mov ax, 21 + RelaxDelay;
    call Delay;
    mov ch, sbAtnOpenCBM;
    mov cl, (sbDataOpenCBM + sbClkOpenCBM);
    call OpenCBMIECSetRelease;
    dec bx;
    jne @2;
@1:
end;

{Turbo-send a byte to the external CBM 1570/1571 drive via the OpenCBM
  driver, in asynchronous mode, at 2 MegaHertz
  Input : AL: the byte to send}
procedure TSendOpenCBM2MHz; far; assembler;
asm
    mov OutData, al;
    mov bx, 4;
@2: call TWait;
    jc @1;
    mov cl, OutData;
    and cl, (sbDataOpenCBM + sbClkOpenCBM);
    shr OutData, 2;
    mov ch, cl;
    xor cl, (sbDataOpenCBM + sbClkOpenCBM);
    or cl, sbAtnOpenCBM;
    call OpenCBMIECSetRelease;
    mov ax, 9 + RelaxDelay;
    call Delay;
    mov ch, sbAtnOpenCBM;
    mov cl, (sbDataOpenCBM + sbClkOpenCBM);
    call OpenCBMIECSetRelease;
    dec bx;
    jne @2;
@1: 
end;

{Wait for the external CBM 1581 drive to be ready for turbo data transfer via
  the normal cable}
procedure TWaitNormal81; far; assembler;
asm
    call AtnLo;
    mov cx, 20;
@1: in al, dx;
    test al, sbDataNormal;
    je @1;
    in al, dx;
    test al, sbClkNormal;
    jne @2;
    loop @1;
    mov al, ssInputTimeout;
    jmp Error;
@2: clc;
end;

{Wait for the external CBM 1581 drive to be ready for turbo data transfer via
  the extended cable}
procedure TWaitExtended81; far; assembler;
asm
    call AtnLo;
    mov cx, 20;
    dec dx;
@1: in al, dx;
    test al, (sbDataNormal shl 4);
    je @1;
    in al, dx;
    test al, (sbClkNormal shl 4);
    je @2;
    loop @1;
    mov al, ssInputTimeout;
    jmp Error;
@2: clc;
end;

{Wait for the external CBM 1581 drive to be ready for turbo data transfer via
  the multitask cable}
procedure TWaitMultitask81; far; assembler;
asm
    call AtnLo;
    mov cx, 20;
    dec dx;
@1: in al, dx;
    test al, (sbDataSwapped shl 4);
    je @1;
    in al, dx;
    test al, (sbClkNormal shl 4);
    je @2;
    loop @1;
    mov al, ssInputTimeout;
    jmp Error;
@2: clc;
end;

{Wait for the external CBM 1581 drive to be ready for turbo data transfer via
  the active cable}
procedure TWaitActive81; far; assembler;
asm
    call AtnLo;
    mov cx, 20;
    dec dx;
@1: in al, dx;
    test al, (sbDataSwapped shl 4);
    jne @1;
    in al, dx;
    test al, (sbClkNormal shl 4);
    je @2;
    loop @1;
    mov al, ssInputTimeout;
    jmp Error;
@2: clc;
end;

{Wait for the external CBM 1581 drive to be ready for turbo data transfer
  via the OpenCBM driver}
procedure TWaitOpenCBM81; far; assembler;
asm
    mov cl, sbAtnOpenCBM;
    call OpenCBMIECSet;
    mov cx, 20;
@1: call OpenCBMIECPoll;
    test al, sbDataOpenCBM;
    je @1;
    call OpenCBMIECPoll;
    test al, sbClkOpenCBM;
    clc;
    jne @2;
    loop @1;
    mov al, ssInputTimeout;
    jmp Error;
@2: clc;
end;

{Turbo-receive a byte from the external CBM 1581 drive via the normal cable,
  in asynchronous mode
  Output: AL: the byte received}
procedure TReceiveNormalAsync81; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 7 + RelaxDelay;
    call Delay;
    in al, dx;
    push ax;
    call AtnLo;
    pop ax;
    rcr al, 2;
    rcl InData, 1;
    rcr al, 2;
    rcl InData, 1;
    mov ax, 7 + RelaxDelay;
    call Delay;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1581 drive via the extended
  cable, in asynchronous mode
  Output: AL: the byte received}
procedure TReceiveExtendedAsync81; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 7 + RelaxDelay;
    call Delay;
    dec dx;
    in al, dx;
    push ax;
    call AtnLo;
    pop ax;
    xor al, ((sbAtnNormal + sbClkNormal) shl 4);
    rcr al, 6;
    rcl InData, 1;
    rcr al, 2;
    rcl InData, 1;
    mov ax, 7 + RelaxDelay;
    call Delay;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1581 drive via the multitask
  cable, in asynchronous mode
  Output: AL: the byte received}
procedure TReceiveMultitaskAsync81; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 7 + RelaxDelay;
    call Delay;
    dec dx;
    in al, dx;
    push ax;
    call AtnLo;
    pop ax;
    xor al, ((sbAtnNormal + sbClkNormal + sbDataSwapped) shl 4);
    rcr al, 6;
    rcl InData, 1;
    rcr al, 1;
    rcl InData, 1;
@3: in al, dx;
    test al, (sbDataSwapped shl 4);
    jne @3;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1581 drive via the active cable
  Output: AL: the byte received}
procedure TReceiveActiveAsync81; far; assembler;
asm
    mov bx, 4;
@2: call TWait;
    jc @1;
    call AtnHi;
    mov ax, 7 + RelaxDelay;
    call Delay;
    dec dx;
    in al, dx;
    push ax;
    call AtnLo;
    pop ax;
    xor al, ((sbAtnNormal + sbClkNormal + sbDataSwapped) shl 4);
    rcr al, 6;
    rcl InData, 1;
    rcr al, 1;
    rcl InData, 1;
    mov ax, 7 + RelaxDelay;
    call Delay;
    dec bx;
    jne @2;
    mov al, InData;
@1:
end;

{Turbo-receive a byte from the external CBM 1581 drive via the OpenCBM driver
  in asynchronous mode, at 2 MegaHertz
  Output: AL: the byte received}
procedure TReceiveOpenCBM81; far; assembler;
asm
    mov InData, 0;
    mov bx, 4;
    call OpenCBMIECPoll;
@2: call TWait;
    jc @1;
    mov cl, sbAtnOpenCBM;
    call OpenCBMIECRelease;
    call OpenCBMIECPoll;
    mov ax, 7 + RelaxDelay;
    call Delay;
    call OpenCBMIECPoll;
    push ax;
    mov cl, sbAtnOpenCBM;
    call OpenCBMIECSet;
    call OpenCBMIECPoll;
    pop ax;
    and al, (sbDataOpenCBM + sbClkOpenCBM);
    rcl InData, 2;
    or InData, al;
    mov ax, 7 + RelaxDelay;
    call Delay;
    dec bx;
    jne @2;
    clc;
@1: call OpenCBMIECPoll;
    mov al, InData;
end;

{Turbo-send a byte to the external CBM 1581 drive via the normal or extended
  cable, in asynchronous mode
  Input : AL: the byte to send}
procedure TSendNormalExtendedAsync81; far; assembler;
asm
    mov OutData, al;
    mov bx, 4;
@2: call TWait;
    jc @1;
    xor al, al;
    rcr OutData, 1;
    rcl al, 2;
    rcr OutData, 1;
    rcl al, 2;
    and Serial, not (sbAtnNormal + sbClkNormal + sbDataNormal);
    or al, Serial;
    mov dx, LPTAddr;
    add dx, 2;
    out dx, al;
    mov ax, 9 + RelaxDelay;
    call Delay;
    mov al, Serial;
    or al, sbAtnNormal;
    mov Serial, al;
    out dx, al;
    dec bx;
    jne @2;
@1:
end;

{Turbo-send a byte to the external CBM 1581 drive via the multitask cable, in
  asynchronous mode
  Input : AL: the byte to send}
procedure TSendMultitaskAsync81; far; assembler;
asm
    mov OutData, al;
    mov bx, 4;
@2: call TWait;
    jc @1;
    xor ah, ah;
    rcr OutData, 1;
    cmc;
    rcl ah, 1;
    rcr OutData, 1;
    rcl ah, 2;
    and Serial, not (sbAtnNormal + sbClkNormal);
    or Serial, sbDataSwapped;
    mov al, Serial;
    and al, not sbDataSwapped;
    or al, ah;
    mov dx, LPTAddr;
    add dx, 2;
    out dx, al;
    mov ax, 9 + RelaxDelay;
    call Delay;
    mov al, Serial;
    or al, sbAtnNormal;
    mov Serial, al;
    out dx, al;
    dec bx;
    jne @2;
@1:
end;

{Turbo-send a byte to the external CBM 1581 drive via the active cable, in
  asynchronous mode
  Input : AL: the byte to send}
procedure TSendActiveAsync81; far; assembler;
asm
    mov OutData, al;
    mov bx, 4;
@2: call TWait;
    jc @1;
    xor ah, ah;
    rcr OutData, 1;
    rcl ah, 1;
    rcr OutData, 1;
    cmc;
    rcl ah, 2;
    or Serial, sbAtnNormal;
    mov al, Serial;
    and al, not (sbClkNormal + sbDataSwapped);
    or al, ah;
    mov dx, LPTAddr;
    add dx, 2;
    out dx, al;
    mov ax, 9 + RelaxDelay;
    call Delay;
    mov al, Serial;
    or al, sbAtnNormal;
    mov Serial, al;
    out dx, al;
    dec bx;
    jne @2;
@1:
end;

{Turbo-send a byte to the external CBM 1581 drive via the OpenCBM driver,
  in asynchronous mode, at 2 MegaHertz
  Input : AL: the byte to send}
procedure TSendOpenCBM81; far; assembler;
asm
    mov OutData, al;
    mov bx, 4;
@2: call TWait;
    jc @1;
    mov cl, OutData;
    and cl, (sbDataOpenCBM + sbClkOpenCBM);
    shr OutData, 2;
    mov ch, cl;
    xor cl, (sbDataOpenCBM + sbClkOpenCBM);
    or cl, sbAtnOpenCBM;
    call OpenCBMIECSetRelease;
    mov ax, 9 + RelaxDelay;
    call Delay;
    xor ch, ch;
    mov cl, (sbAtnOpenCBM + sbDataOpenCBM + sbClkOpenCBM);
    call OpenCBMIECSetRelease;
    dec bx;
    jne @2;
@1:
end;

{Determine if a device is present on the serial bus
  Output: when True, there is a device on the bus}
function CheckDevice: Boolean; assembler;
asm
    mov Status, 0;
    cmp SerialCable, scNone;
    jne @1;
    mov Status, ssNoDevice;
    jmp @6;
@1: push plHigh;
    call InterruptOff;
    push ax;
    push si;
    mov cx, 20000;
    call ResetLPTPort;
@5: call AtnLo;
    mov ax, 100;
    call Delay;
    call ReadLine;
    push ax;
    call AtnHi;
    pop ax;
    test al, DataBit;
    je @3;
    mov ax, 100;
    call Delay;
    call ReadLine;
    test al, DataBit;
    je @4;
@3: loop @5;
    mov al, ssNoDevice;
    call Error;
@4: call AtnHi;
    call ClkHi;
    call DataHi;
    pop si;
    pop ax;
    call InterruptOn;
@6: mov al, False;
    test Status, ssNoDevice;
    jne @2;
    inc al;
@2:
end;

{Determine if the disk has been changed in the external drive; assuming that
  the drive routine helping with this is already running
  Output: when True, the disk has been changed}
function CheckDiskChange: Boolean; assembler;
asm
    call ReadLine;
    xor cl, cl;
    cmp al, ClkDataBits;
    jne @1;
    push word ptr CopyPriorityMode;
    call InterruptOff;
    call ParallelInput;
    call TReceive;
    push ax;
    call TReceive;
    call ParallelOutput;
    pop ax;
    cmp al, 'O';
    mov al, False;
    jne @2;
    mov cl, True;
@2: call InterruptOn;
@1: mov al, cl;
end;

{Send a command (single byte with ATN low) to the external CBM drive
  Input : AL: command byte to be sent}
procedure Command; assembler;
asm
    push ax;
    push True;
    call SetTimeout;
    pop ax;
    push ax;
    cmp More, False;
    je @1;
    mov EOI, True;
    call SendReal;
    mov More, False;
    mov EOI, False;
@1: pop ax;
    mov OutData, al;
    call DataHi;
    call AtnLo;
    push plHigh;
    call InterruptOff;
    call ClkLo;
    call DataHi;
    mov ax, 500;
    call Delay;
    call SendReal;
end;

{Send a TALK command to the external CBM drive}
procedure Talk; assembler;
asm
    cmp SerialCable, scOpenCBM;
    jne @4;
    mov cl, al;
    mov ch, CBMDevNum;
    call OpenCBMTalk;
    jmp @3;
@4: push ax;
    mov al, CBMDevNum;
    or al, $40;
    call Command;
    pop ax;
    or al, $60;
    mov OutData, al;
    test Status, ssNoDevice;
    jne @3;
    push plHigh;
    call InterruptOff;
    call ClkLo;
    call DataHi;
    mov ax, 500;
    call Delay;
    call SendReal;
    push plHigh;
    call InterruptOff;
    call DataLo;
    call AtnHi;
    call ClkHi;
    xor cx, cx;
@1: call ReadLine;
    test al, sbClkNormal;
    je @2;
    loop @1;
@2: mov ax, 500;
    call Delay;
    call InterruptOn;
@3:
end;

{Send a LISTEN command to the external CBM drive}
procedure Listen; assembler;
asm
    cmp SerialCable, scOpenCBM;
    jne @2;
    mov cl, al;
    mov ch, CBMDevNum;
    call OpenCBMListen;
    jmp @1;
@2: push ax;
    mov al, CBMDevNum;
    or al, $20;
    call Command;
    pop ax;
    or al, $60;
    mov OutData, al;
    test Status, ssNoDevice;
    jne @1;
    push plHigh;
    call InterruptOff;
    call ClkLo;
    call DataHi;
    mov ax, 500;
    call Delay;
    call SendReal;
    call AtnHi;
@1:
end;

{Send an UNTALK command to the external CBM drive}
procedure Untalk; assembler;
asm
    cmp SerialCable, scOpenCBM;
    jne @1;
    call OpenCBMUntalk;
    mov ax, 200;
    call Delay;
    call ClkHi;
    call DataHi;
    jmp @2;
@1: push plHigh;
    call InterruptOff;
    call ClkLo;
    call AtnLo;
    mov al, $5F;
    call Command;
    push plHigh;
    call InterruptOff;
    call AtnHi;
    mov ax, 200;
    call Delay;
    call ClkHi;
    call DataHi;
    call InterruptOn;
@2:
end;

{Send an UNLISTEN command to the external CBM drive}
procedure Unlisten; assembler;
asm
    cmp SerialCable, scOpenCBM;
    jne @1;
    call OpenCBMUntalk;
    call AtnHi;
    mov ax, 200;
    call Delay;
    call ClkHi;
    call DataHi;
    jmp @2;
@1: push plHigh;
    call InterruptOff;
    mov al, $3F;
    call Command;
    push plHigh;
    call InterruptOff;
    call AtnHi;
    mov ax, 200;
    call Delay;
    call ClkHi;
    call DataHi;
    call InterruptOn;
@2:
end;

{Open a file on a disk or send a disk command to the external CBM drive
  Input : SecAddr: secondary address of the file or $6F if disk command
          Command: the file name or disk command to be sent
          Timeout: when True, timeouts are handled}
procedure OpenCBMChannel(SecAddr: Byte; const Command: string; Timeout: Boolean);
begin
  if SerialCable = scOpenCBM then
  begin
    asm
      mov Status, 0;
      call OpenCBMClearEOI;
      mov ch, CBMDevNum;
      mov cl, SecAddr;
      les si, Command;
      call OpenCBMOpen;
      call AtnHi;
      mov ax, 200;
      call Delay;
      call ClkHi;
      call DataHi;
    end;
  end
  else
  begin
    SetTimeout(Timeout);
    asm
      test Status, ssNoDevice;
      jne @1;
      les di, Command;
      cmp byte ptr es:[di], 0;
      je @1;
      mov Status, 0;
      mov More, False;
      mov EOI, False;
      mov al, SecAddr;
      or al, $60;
      cmp al, saCommand;
      je @3;
      or al, $F0;
  @3: call Listen;
      test Status, ssNoDevice;
      jne @1;
      xor bx, bx;
      les di, Command;
      mov cl, es:[di];
      xor ch, ch;
  @2: inc bx;
      push bx;
      push cx;
      mov al, es:[di][bx];
      call Send;
      pop cx;
      pop bx;
      loop @2;
      call Unlisten;
  @1:
    end;
    SetTimeout(False);
  end;
end;

{Close a file on the disk in the external CBM drive
  Input : SecAddr: secondary address of the file}
procedure CloseCBMChannel(SecAddr: Byte);
begin
  if SerialCable = scOpenCBM then
  begin
    asm
      mov ch, CBMDevNum;
      mov cl, SecAddr;
      call OpenCBMClose;
    end;
  end
  else
  begin
    SetTimeout(True);
    asm
      mov al, SecAddr;
      and al, $0F;
      or al, $E0;
      call Listen;
      call Unlisten;
    end;
    SetTimeout(False);
  end;
end;

{Receive the disk error from the external CBM drive
  Input : Error: the string to contain the error message
          Check: when True, the serial bus status is checked and the
                 process of reading the error message is skipped if the
                 drive is off or a timeout occured
          Off: when True, the turbo program running in the external CBM
               drive is shut down before reading the status
          Timeout: when True, timeouts are handled
  Output: when False, an error occured}
function ReadCBMError(var Error: string; Check, Off, Timeout: Boolean): Boolean;
var
  C             : Char;
begin
  asm
    mov ax, 10000;
    call Delay;
  end;
  if Off and (CopyTransferMode <> tmNormal) then TurboOff;
  Error := '';
  if not Check or (Status and ssNoDevice = 0) then
  begin
    SetTimeout(Timeout);
    Status := 0;
    if SerialCable = scOpenCBM then
    begin
      asm
        call OpenCBMClearEOI;
        mov cx, MaxStrLen;
        les si, Error;
        mov dh, CBMDevNum;
        call OpenCBMDeviceStatus;
      end;
    end
    else
    begin
      More := False;
      EOI := False;
      asm
        mov al, saCommand;
        call Talk;
        test Status, ssNoDevice;
        jne @1;
        les di, Error;
        xor bx, bx;
        cld;
    @2: push bx;
        push cx;
        call Receive;
        pop cx;
        pop bx;
        cmp Status, 0;
        jne @3;
        inc bl;
        mov es:[di][bx], al;
        cmp bl, MaxStrLen;
        je @3;
        loop @2;
    @3: mov es:[di], bl;
        call Untalk;
    @1:
      end;
      SetTimeout(False);
    end;
  end;
  if Status and ssTimeout > 0 then
  begin
    Error := 'Timeout detected';
  end
  else
  begin
    if Status and ssNoDevice > 0 then Error := 'Drive ' + LeadingSpace(CBMDevNum, 0) + ': not present';
  end;
  if (Error <> '') and (Error[Length(Error)] = chReturn) then Dec(Error[0]);
  ReadCBMError := ((Error = '') or ((Length(Error) > 2) and (Error[1] = '0')));
end;

{Convert a long long integer into a decimal string
  Input : Num: the long long integer to be converted
          DigitNum: number of digits to put into the string
  Output: the decimal string}
function StrLonglongint(const Num: Longlongint; DigitNum: Word): string;
var
  Q             : Boolean;
  I,
  W             : Word;
  L             : Longlongint;
  S             : string;
begin
  L := Num;
  S := ' ';
  I := 1;
  if DigitNum > 0 then
  begin
    S[0] := Chr(DigitNum);
    FillChar(S[1], Length(S), ' ');
    I := Length(S);
  end;
  if (LonglongintToLongint(L) = 0) then
  begin
    S[I] := '0';
  end
  else
  begin
    repeat
      W := DivLonglongintByWord(L, L, 10);
      Q := (LonglongintToLongint(L) = 0);
      S[I] := Chr(W + Ord('0'));
      if not Q and (I = 1) then
      begin
        Move(S[1], S[2], Length(S));
        Inc(S[0]);
      end
      else
      begin
        Dec(I);
      end;
    until Q;
  end;
  StrLonglongint := S;
end;

{Convert a long integer into a decimal string with leading zeros
  Input : Num: the long integer to be converted
          DigitNum: number of digits to put into the string
  Output: the decimal string}
function LeadingZero(Num: Longint; DigitNum: Word): string;
var
  I             : Word;
  S             : string;
begin
  Str(Num:DigitNum, S);
  I := 1;
  while (I <= Length(S)) and (S[I] = ' ') do
  begin
    S[I] := '0';
    Inc(I);
  end;
  LeadingZero := S;
end;

{Convert a long integer into a decimal string with leading blanks
  Input : Num: the long integer to be converted
          DigitNum: number of digits to put into the string
  Output: the decimal string}
function LeadingSpace(Num: Longint; DigitNum: Word): string;
var
  S             : string;
begin
  Str(Num:DigitNum, S);
  LeadingSpace := S;
end;

{Convert a long long integer into a decimal string with leading blanks
  Input : Num: the long long integer to be converted
          DigitNum: number of digits to put into the string
  Output: the decimal string}
function LeadingSpaceLonglongint(const Num: Longlongint; DigitNum: Word): string;
var
  S             : string;
begin
  S := StrLonglongint(Num, DigitNum);
  LeadingSpaceLonglongint := S;
end;

{Convert a long integer into a decimal string with thousands separator
  Input : Num: the long integer to be converted
  Output: the decimal string}
function SepStr(Num: Longint): string;
var
  P             : Integer;
  S             : string;
begin
  Str(Num, S);
  if ThousandSep <> #0 then
  begin
    P := Length(S);
    while P > 3 do
    begin
      Insert(ThousandSep, S, P - 2);
      P := P - 3;
    end;
  end;
  SepStr := S;
end;

{Convert a long integer into a decimal string with thousands separator
  Input : Num: the long integer to be converted
  Output: the decimal string}
function SepStrLonglongint(const Num: Longlongint): string;
var
  P             : Integer;
  S             : string;
begin
  S := StrLonglongint(Num, 0);
  if ThousandSep <> #0 then
  begin
    P := Length(S);
    while P > 3 do
    begin
      Insert(ThousandSep, S, P - 2);
      P := P - 3;
    end;
  end;
  SepStrLonglongint := S;
end;

{Convert a long integer into a hexadecimal string
  Input : D: the long integer
          L: number of digits to put into the string
  Output: the hexadecimal string}
function HexaStr(D: Longint; L: Byte): string;
var
  I             : Byte;
  S             : string;
begin
  S := '';
  for I := L - 1 downto 0 do S := S + HexaNum[(D shr (I * 4) and $0F) + 1];
  HexaStr := S;
end;

{Convert a hexadecimal string into a long integer
  Input : S: the hexadecimal string
          Code: when not 0, an error occured
  Output: the converted long integer}
function HexaEval(const S: string; var Code: Integer): Longint;
var
  I,
  X             : Byte;
  V             : Longint;
begin
  V := 0;
  I := 1;
  Code := 0;
  while (Code = 0) and (I <= Length(S)) do
  begin
    X := LeftPos(UpCase(S[I]), HexaNum);
    if X = 0 then Code := I else V := V shl 4 + X - 1;
    Inc(I);
  end;
  HexaEval := V;
end;

{Convert a decimal or hexadecimal string into a long integer
  Input : S: the decimal or hexadecimal string
          Code: when not 0, an error occured
  Output: the converted long integer}
function EvalAny(const S: string; var Code: Integer): Longint;
var
  L             : Longint;
begin
  if (S <> '') and (S[1] = HexaPrefix) then L := HexaEval(S, Code) else Val(S, L, Code);
  if Code <> 0 then L := 0;
  EvalAny := L;
end;

{Replace a character to another in a string
  Input : Str: the original string
          OrigChar: the character to replace
          NewChar: the character to replace with
  Output: the replaced string}
function Replace(const Str: string; OrigChar, NewChar: Char): string; assembler;
asm
    push ds;
    mov bl, OrigChar;
    mov bh, NewChar;
    lds si, Str;
    les di, @Result;
    cld;
    lodsb;
    stosb;
    mov cl, al;
    xor ch, ch;
    jcxz @1;
@3: lodsb;
    cmp al, bl;
    jne @2;
    mov al, bh;
@2: stosb;
    loop @3;
@1: pop ds;
end;

{Compute the length of an ASCII or PETSCII string
  Input : Text: the string whose length to compute
  Output: the computed string length}
function CBMStrLen(const Text: string): Integer;
var
  I,
  J             : Integer;
begin
  I := Length(Text);
  J := 1;
  while J <= Length(Text) do
  begin
    case Text[J] of
      PETSCIIStart:
      begin
        Dec(I, 2);
        Inc(J, Ord(Text[J + 1]) + 2);
      end;
      ColorChar:
      begin
        Dec(I);
        Inc(J);
      end;
    else
      Inc(J);
    end;
  end;
  CBMStrLen := I;
end;

{Convert a character to uppercase
  Input : Ch: the original character
  Output: the character in uppercase}
function UpCase(Ch: Char): Char; assembler;
asm
    mov al, &Ch;
    cmp al, $80;
    jb @1;
    sub al, $80;
    push bx;
    mov bx, Offset(UpCaseTable);
    xlat;
    pop bx;
    jmp @2;
@1: cmp al, 'a';
    jb @2;
    cmp al, 'z';
    ja @2;
    sub al, 'a' - 'A';
@2:
end;

{Convert a character to lowercase
  Input : Ch: the original character
  Output: the character in lowercase}
function LoCase(Ch: Char): Char; assembler;
asm
    mov al, &Ch;
    cmp al, $80;
    jb @1;
    sub al, $80;
    push bx;
    mov bx, Offset(LoCaseTable);
    xlat;
    pop bx;
    jmp @2;
@1: cmp al, 'A';
    jb @2;
    cmp al, 'Z';
    ja @2;
    add al, 'a' - 'A';
@2:
end;

{Invert the case of a character
  Input : Ch: the original character
  Output: the character in inverted case}
function InvertCase(Ch: Char): Char; assembler;
asm
    mov al, &Ch;
    cmp al, 'A';
    jb @1;
    cmp al, 'Z';
    jbe @2;
    cmp al, 'a';
    jb @1;
    cmp al, 'z';
    ja @1;
@2: xor al, 'a' - 'A';
@1:
end;

{Convert a PETSCII character to uppercase
  Input : Ch: the original character
  Output: the character in lowercase}
function CBMUpCase(Ch: Char): Char; assembler;
asm
    mov al, &Ch;
    cmp al, $41;
    jb @1;
    cmp al, $5A;
    ja @2;
    add al, $80;
    jmp @1;
@2: cmp al, $61;
    jb @1;
    cmp al, $7A;
    ja @1;
    add al, $60;
@1:
end;

{Convert a PETSCII character to lowercase
  Input : Ch: the original character
  Output: the character in lowercase}
function CBMLoCase(Ch: Char): Char; assembler;
asm
    mov al, &Ch;
    cmp al, $61;
    jb @1;
    cmp al, $7A;
    ja @2;
    sub al, $20;
    jmp @1;
@2: cmp al, $C1;
    jb @1;
    cmp al, $DA;
    ja @1;
    sub al, $80;
@1:
end;

{Invert the case of a PETSCII character
  Input : Ch: the original character
  Output: the character in inverted case}
function CBMInvertCase(Ch: Char): Char; assembler;
asm
    mov al, &Ch;
    cmp al, $41;
    jb @1;
    cmp al, $5A;
    jbe @2;
    cmp al, $61;
    jb @1;
    cmp al, $7A;
    jbe @3;
    cmp al, $C1;
    jb @1;
    cmp al, $DA;
    ja @1;
@2: xor al, $80;
    jmp @1;
@3: sub al, $20;
@1:
end;

{Convert a screen code character to uppercase
  Input : Ch: the original character
  Output: the character in uppercase}
function SCRUpCase(Ch: Char): Char; assembler;
asm
    mov al, &Ch;
    mov ah, al;
    and al, $7F;
    and ah, $80;
    cmp al, $01;
    jb @1;
    cmp al, $1A;
    ja @1;
    add al, $40;
@1: or al, ah;
end;

{Convert a screen code character to lowercase
  Input : Ch: the original character
  Output: the character in lowercase}
function SCRLoCase(Ch: Char): Char; assembler;
asm
    mov al, &Ch;
    mov ah, al;
    and al, $7F;
    and ah, $80;
    cmp al, $41;
    jb @1;
    cmp al, $5A;
    ja @1;
    sub al, $40;
@1: or al, ah;
end;
{Invert the case of a screen code character
  Input : Ch: the original character
  Output: the character in inverted case}
function SCRInvertCase(Ch: Char): Char; assembler;
asm
    mov al, &Ch;
    mov ah, al;
    and al, $3F;
    and ah, $C0;
    cmp al, $01;
    jb @1;
    cmp al, $1A;
    ja @1;
    xor ah, $40;
@1: or al, ah;
end;

{Convert a string to uppercase
  Input : S: the original string
  Output: the string in uppercase}
function UpperCase(const S: string): string;
var
  I             : Integer;
  T             : string;
begin
  T[0] := Chr(Length(S));
  for I := 1 to Length(S) do T[I] := UpCase(S[I]);
  UpperCase := T;
end;

{Convert a string to lowercase
  Input : S: the original string
  Output: the string in lowercase}
function LowerCase(const S: string): string;
var
  I             : Integer;
  T             : string;
begin
  T[0] := Chr(Length(S));
  for I := 1 to Length(S) do T[I] := LoCase(S[I]);
  LowerCase := T;
end;

{Convert a PETSCII string to uppercase
  Input : S: the original string
  Output: the string in uppercase}
function CBMUpperCase(const S: string): string;
var
  I             : Integer;
  T             : string;
begin
  T[0] := Chr(Length(S));
  for I := 1 to Length(S) do T[I] := CBMUpCase(S[I]);
  CBMUpperCase := T;
end;

{Convert a PETSCII string to lowercase
  Input : S: the original string
  Output: the string in lowercase}
function CBMLowerCase(const S: string): string;
var
  I             : Integer;
  T             : string;
begin
  T[0] := Chr(Length(S));
  for I := 1 to Length(S) do T[I] := CBMLoCase(S[I]);
  CBMLowerCase := T;
end;

{Deallocate the memory used by the history or menu items
  Input : P: list of history or menu items}
procedure FreeHistoryItem(P: PHistoryItem);
var
  Q             : PHistoryItem;
begin
  while P <> nil do
  begin
    Q := P;
    P := P^.Next;
    Dispose(Q);
  end;
end;

{Read the current value of the INT 08h timer
  Output: the current INT 08h timer value}
function GetTicks: Longint; assembler;
asm
    mov ax, $0040;
    mov es, ax;
    mov ax, es:[$006C];
    mov dx, es:[$006E];
end;

{Convert military time to AM/PM format
  Input : Hour: military time, hour part
          AMPM: string to contain 'a' or 'p'
          Force: when True, the AM/PM format is used, even the regional
                 settings tell otherwise}
procedure MakeAMPM(var Hour: Word; var AMPM: string; Force: Boolean);
begin
  AMPM := '';
  if not MilitaryTime or Force then
  begin
    AMPM[0] := #1;
    if Hour < 12 then
    begin
      AMPM[1] := 'a';
    end
    else
    begin
      Dec(Hour, 12);
      AMPM[1] := 'p';
    end;
    if Hour = 0 then Hour := 12;
  end;
end;

{Display the special form of a CBM file name in a dialog box
  Input : Dest: draw buffer
          Str: the special form string
          Attr: color attribute
          Color: when True, the string has two colors and ColorChar
                 switches between them}
procedure MoveCBMStr(Dest: Pointer; const Str: string; Attr: Word; Color: Boolean);
var
  O             : Boolean;
  A,
  B,
  C,
  D,
  X,
  W,
  Z             : Byte;
begin
  X := 0;
  O := False;
  W := Lo(Attr);
  Z := (W and $0F) shl 4 + W shr 4;
  A := 1;
  while A <= Length(Str) do
  begin
    C := Ord(Str[A]);
    if C = Ord(PETSCIIStart) then
    begin
      B := A + Ord(Str[A + 1]) + 1;
      Inc(A, 2);
      while A <= B do
      begin
        C := Ord(Str[A]);
        case CharSetMode of
          csIBMLower: PDrawBuffer(Dest)^[X] := PETtoASCLower[C] + W shl 8;
          csIBMUpper: PDrawBuffer(Dest)^[X] := PETtoASCUpper[C] + W shl 8;
          csCBMLower:
          begin
            D := PETtoExtLower[C];
            if C and $7F < $20 then PDrawBuffer(Dest)^[X] := D + Z shl 8 else
              PDrawBuffer(Dest)^[X] := D + W shl 8;
          end;
          csCBMUpper:
          begin
            D := PETtoExtUpper[C];
            if C and $7F < $20 then PDrawBuffer(Dest)^[X] := D + Z shl 8 else
              PDrawBuffer(Dest)^[X] := D + W shl 8;
          end;
        end;
        Inc(X);
        Inc(A);
      end;
    end
    else
    begin
      if (C = Ord(ColorChar)) and Color then
      begin
        O := not O;
        if O then W := Hi(Attr) else W := Lo(Attr);
        Z := (W and $0F) shl 4 + W shr 4;
        Inc(A);
      end
      else
      begin
        PDrawBuffer(Dest)^[X] := C + W shl 8;
        Inc(X);
        Inc(A);
      end;
    end;
  end;
end;

{Create bounds for a dialog box of the specified size
  Input : R: rectangle to contain the computed bounds
          X: horizontal size of the dialog box
          Y: vertical size of the dialog box}
procedure MakeWinBounds(var R: TRect; X, Y: Integer);
var
  I,
  J             : Integer;
begin
  Inc(X, 8);
  Inc(Y, 4);
  Justify := (X and 1);
  I := (ScreenWidth shr 1) - ((X + 1) shr 1);
  if Y < 14 then
  begin
    J := WinCenter - 3;
  end
  else
  begin
    J := WinCenter + 4 - ((Y + 1) shr 1);
    if (J <= 1) and (Y <= WinSize - 2) then Inc(J);
  end;
  R.Assign(I, J, X, Y);
end;

{Shorten a too long file name by cutting its middle out and replacing it with
  three dots
  Input : Name: original file name
          Max: the maximum length
  Output: shortened file name}
function LimitNameLen(const Name: string; Max: Integer): string;
var
  B             : Byte;
  I,
  J,
  K,
  L             : Integer;
  S             : string;
begin
  I := LeftPos(chDirSep, Name);
  if (I = 0) or (I > 3) then I := LeftPos(':', Name);
  if Max < I + 3 then
  begin
    S := Copy(Name, 1, Max);
    if Max > I then FillChar(S[I + 1], Max - I, '.');
    LimitNameLen := S;
  end
  else
  begin
    if (I >= Max) then I := 0;
    J := Max;
    K := 1;
    while K <= Length(Name) do
    begin
      if Name[K] = PETSCIIStart then Inc(J, 2);
      Inc(K);
    end;
    if J >= Length(Name) then
    begin
      LimitNameLen := Name;
    end
    else
    begin
      K := Length(Name) - J + 3;
      L := RightPos(PETSCIIStart, Copy(Name, I + 1, K));
      if L > 0 then Dec(J, 2);
      S := Copy(Name, 1, I) + '...' + Copy(Name, Length(Name) - J + I + 4, J - I - 3);
      if L > 0 then
      begin
        B := Ord(Name[I + L + 1]);
        if L + B + 1 > K then Insert(PETSCIIStart + Chr(L + B - 1 - K), S, I + 4);
      end;
      LimitNameLen := S;
    end;
  end;
end;

{Get the name part of the file name
  Input : Name: the file name
  Output: the file name}
function FileName(const Name: string): string;
var
  P             : Byte;
begin
  P := RightPos('.', Name);
  if P = 0 then FileName := '' else FileName := Copy(Name, 1, P - 1);
end;

{Get the extension part of the file name
  Input : Name: the file name
  Output: the file extension}
function FileExt(const Name: string): string;
var
  P             : Byte;
begin
  P := RightPos('.', Name);
  if P = 0 then FileExt := '' else FileExt := Copy(Name, P + 1, MaxStrLen);
end;

{Force the specified extension into the file name
  Input : Name: the original file name
          Ext: the extension to be forced
  Output: the corrected file name}
function MakeFileExt(const Name, Ext: string): string;
var
  P             : Byte;
  S             : string;
begin
  S := Name;
  P := RightPos('.', S);
  if P > 0 then S[0] := Chr(P - 1);
  if Ext <> '' then S := S + stDot;
  MakeFileExt := S + Ext;
end;

{Initialize the screen to 80/132 column text mode
  Input : Prompt: when not nil, a prompt is displayed before switching back}
procedure TextScreen(Prompt: TProc);
var
  V             : Word;
begin
  V := GetVideoMode;
  if not IsTextVideoMode(V) then
  begin
    if Assigned(Prompt) then Prompt;
    if V < smBW80 then Inc(V, (smBW80 - smBW40)) else V := smCO80;
    SetVideoMode(V);
    PrintStr(chCR + chLF);
  end;
end;

{Check if the loader or the Commander is present}
procedure CheckResident;
begin
  asm
    mov Resident, False;
    mov cx, 'SC';
    mov dx, 'OM';
    mov ah, $2B;
    int $21;
    or al, al;
    jne @1;
    cmp dx, VersionNum;
    jne @1;
    inc Resident;
    cmp MainProgram, False;
    je @2;
    mov Resident, cl;
@2: mov word ptr ShellBuffer[0], bx;
    mov word ptr ShellBuffer[2], es;
@1:
  end;
  MemoryCfgOK := False;
  if Resident then MemoryCfgOK := ShellBuffer^.ConfigOK;
end;

{Determine the path in which temporary files may be created
  Output: the path}
function GetTempPath: string;
var
  S             : string;
begin
  S := GetEnv('TEMP');
  if S = '' then S := HomePath;
  GetTempPath := S;
end;

{Set the path of the Commander home directory}
procedure SetHomePath;
begin
  if MemoryCfgOK then
  begin
    HomePath := ShellBuffer^.ComPath;
  end
  else
  begin
    HomePath := GetEnv(HomePathEnvVar);
    if HomePath = '' then LongFSplit(LongFExpand(ParamStr(0)), HomePath, CurPath, CurPath);
  end;
end;

{Sound an error beep}
procedure Beep; assembler;
asm
    mov ax, $0E07;
    call VideoInt;
end;

{Cut the specified character off of the end of the file name
  Input : Name: the original file name
          C: the character to be cut off
  Output: the corrected file name}
function CutChar(const Name: string; C: Char): string;
var
  S             : string;
begin
  S := Name;
  while (Length(S) > 0) and (S[Length(S)] = C) do Dec(S[0]);
  CutChar := S;
end;

{Get the DOS version number
  Output: DOS version number}
function DOSVersion: Word; assembler;
asm
    mov ah, $30;
    int $21;
    xchg ah, al;
end;

{Initialize file autoselection during group file operation}
procedure InitSelectMode;
begin
  FileSelectMode := fsProcessed;
  if AutoUnselect then FileSelectMode := fsSelected;
end;

{Initialize LPT port bit variables}
procedure InitLPTBits;
begin
  if SerialCable = scOpenCBM then
  begin
    AtnBit := sbAtnOpenCBM;
    ClkBit := sbClkOpenCBM;
    DataBit := sbDataOpenCBM;
    ResetBit := sbResetOpenCBM;
  end
  else
  begin
    AtnBit := sbAtnNormal;
    ClkBit := sbClkNormal;
    DataBit := sbDataNormal;
    ResetBit := sbResetNormal;
    case SerialCable of
      scMultitask:
      begin
        DataBit := sbDataSwapped;
        ResetBit := sbResetSwapped;
      end;
      scActive:
      begin
        DataBit := sbDataSwapped;
        ResetBit := sbResetSwapped;
      end;
    end;
  end;
  ClkDataBits := (DataBit or ClkBit);
end;

function ExtDiskModeStr(ExtDiskMode: Byte): string; far;
begin
  case ExtDiskMode of
    xtNever: ExtDiskModeStr := ' no';
    xtDetect, xtAlways: ExtDiskModeStr := '';
  end;
end;

function TransferModeStr(TransferMode: Byte): string; far;
begin
  case TransferMode of
    tmNormal: TransferModeStr := ' normal';
    tmTurbo: TransferModeStr := ' turbo';
    tmWarp: TransferModeStr := ' warp';
  end;
end;

function ParallelCableModeStr(ParallelCableMode: Byte): string; far;
begin
  case ParallelCableMode of
    pcNone: ParallelCableModeStr := ' serial';
    pcHybrid: ParallelCableModeStr := ' hybrid';
    pcParallel: ParallelCableModeStr := ' parallel';
  end;
end;

function CmdExecModeStr(CmdExecMode: Byte): string; far;
begin
  case CmdExecMode of
    cxNormal: CmdExecModeStr := ' normal';
    cxTurbo: CmdExecModeStr := ' turbo';
    cxWarp: CmdExecModeStr := ' warp';
  end;
end;

{Check whether a drive feature is beyond the valid values and, if so, make
  it fall back to the highest valid value
  Input : Value: drive feature value
          Table: drive feature table
          Warning: when True, a warning is displayed
          Name: name of feature
          ValueProc: function returning feature value
  Output: when True, the drive feature was forced to fall back}
function FeatureFallback(var Value: Byte; Table: PDriveFeature; Warning: Boolean; Name: string;
  ValueProc: TItemStrProc): Boolean;
var
  O             : Boolean;
  B             : Byte;
begin
  B := Table^[ExtDriveType];
  O := (Value > B);
  if O then
  begin
    if Warning and (WarningStatus and wmBadFeature = 0) then
      ErrorWin(stError, 'The' + ValueProc(Value) + Name + ' is not available for ' +
        DriveTypeStr(ExternalDrive) + ' drives.', 'Falling back to' + ValueProc(B) + Name + '.', hcOnlyQuit, sbNone);
    Value := B;
  end;
  FeatureFallBack := O;
end;

{Initialize the variables related to data transfer from or to the external
  Commodore drive}
procedure InitTransfer(Warnings: Boolean);
const
  ReadLines: array [scNone..scOpenCBM] of TProc = (ReadLineNone, ReadLineNormal, ReadLineExtended, ReadLineMultitask,
    ReadLineActive, ReadLineOpenCBM);
  TWaits: array [scNormal..scOpenCBM] of TProc = (TWaitNormal, TWaitExtended, TWaitMultitask, TWaitActive, TWaitOpenCBM);
  TSerialReceives: array [scNormal..scOpenCBM, False..True, False..True] of TProc =
    (((TReceiveNormal1MHz, TReceiveNormal2MHz), (TReceiveNormalAsync1MHz, TReceiveNormalAsync2MHz)),
     ((TReceiveExtended1MHz, TReceiveExtended2MHz), (TReceiveExtendedAsync1MHz, TReceiveExtendedAsync2MHz)),
     ((TReceiveMultitask1MHz, TReceiveMultitask2MHz), (TReceiveMultitaskAsync1MHz, TReceiveMultitaskAsync2MHz)),
     ((TReceiveActive1MHz, TReceiveActive2MHz), (TReceiveActiveAsync1MHz, TReceiveActiveAsync2MHz)),
     ((TReceiveOpenCBM1MHz, TReceiveOpenCBM2MHz), (TReceiveOpenCBM1MHz, TReceiveOpenCBM2MHz)));
  TSerialSends: array [scNormal..scOpenCBM, False..True, False..True] of TProc =
    (((TSendNormalExtended1MHz, TSendNormalExtended2MHz), (TSendNormalExtendedAsync1MHz, TSendNormalExtendedAsync2MHz)),
     ((TSendNormalExtended1MHz, TSendNormalExtended2MHz), (TSendNormalExtendedAsync1MHz, TSendNormalExtendedAsync2MHz)),
     ((TSendMultitask1MHz, TSendMultitask2MHz), (TSendMultitaskAsync1MHz, TSendMultitaskAsync2MHz)),
     ((TSendActive1MHz, TSendActive2MHz), (TSendActiveAsync1MHz, TSendActiveAsync2MHz)),
     ((TSendOpenCBM1MHz, TSendOpenCBM2MHz), (TSendOpenCBM1MHz, TSendOpenCBM2MHz)));
  TWaits81: array [scNormal..scOpenCBM] of TProc = (TWaitNormal81, TWaitExtended81, TWaitMultitask81, TWaitActive81,
    TWaitOpenCBM81);
  TSerialReceives81: array [scNormal..scOpenCBM] of TProc =
    (TReceiveNormalAsync81, TReceiveExtendedAsync81, TReceiveMultitaskAsync81, TReceiveActiveAsync81, TReceiveOpenCBM81);
  TSerialSends81: array [scNormal..scOpenCBM] of TProc =
    (TSendNormalExtendedAsync81, TSendNormalExtendedAsync81, TSendMultitaskAsync81, TSendActiveAsync81, TSendOpenCBM81);
var
  A,
  F,
  O             : Boolean;
  B             : Byte;
begin
  TransferInited := True;
  if DelayValue = 0 then ComputeDelay else CopyDelayValue := DelayValue;
  LPTAddr := LPTAddresses[LPTNum];
  ParLPTAddr := LPTAddresses[ParLPTNum];
  LPTMode := LPTModes[LPTNum];
  ParLPTMode := LPTModes[ParLPTNum];
  ExtDriveType := ExtDriveTypes[ExternalDrive];
  ExtDiskType := ExtDiskTypes[ExternalDrive];
  B := ExtendedDiskMode;
  O := FeatureFallback(B, @DriveExtDiskModes, Warnings, ' extended disk mode', ExtDiskModeStr);
  ExtendedDisk := (B = xtAlways);
  DetectExtTracks := (B = xtDetect);
  CopyTransferMode := TransferMode;
  if FeatureFallback(CopyTransferMode, @DriveTransferModes, Warnings, ' transfer mode', TransferModeStr) then O := True;
  B := ParallelCable;
  if FeatureFallback(B, @DriveParallelCables, Warnings, ' cable', ParallelCableModeStr) then O := True;
  case B of
    pcNone:
    begin
      CableMode := cmSerial;
      if (CopyTransferMode <> tmNormal) and ((AsyncTransfer = atAlways) or
        ((AsyncTransfer = atAuto) and (OperatingSystem and (osWindows + osDESQview) > 0))) or
        (SerialCable = scOpenCBM) then
        CableMode := cmAsync;
    end;
    pcHybrid: CableMode := cmHybrid;
    pcParallel: CableMode := cmParallel;
  end;
  CopyCableMode := CableMode;
  CopyCmdExecMode := CmdExecMode;
  if FeatureFallback(CopyCmdExecMode, @DriveCmdExecModes, Warnings, ' command exec mode', CmdExecModeStr) then O := True;
  CopyExtDiskType := ExtDiskType;
  InitLPTBits;
  if SerialCable = scOpenCBM then
  begin
    AtnLo := AtnLoOpenCBM;
    AtnHi := AtnHiOpenCBM;
    ClkLo := ClkLoOpenCBM;
    ClkHi := ClkHiOpenCBM;
    DataLo := DataLoOpenCBM;
    DataHi := DataHiOpenCBM;
  end
  else
  begin
    AtnLo := AtnLoNormal;
    AtnHi := AtnHiNormal;
    ClkLo := ClkLoNormal;
    ClkHi := ClkHiNormal;
    DataLo := DataLoNormal;
    DataHi := DataHiNormal;
    case SerialCable of
      scMultitask:
      begin
        DataLo := DataHiNormal;
        DataHi := DataLoNormal;
      end;
      scActive:
      begin
        AtnLo := AtnHiNormal;
        AtnHi := AtnLoNormal;
        ClkLo := ClkHiNormal;
        ClkHi := ClkLoNormal;
      end;
    end;
  end;
  case CopyTransferMode of
    tmNormal:
    begin
      DriveIntIndex := diSerialNormalRead;
      CopyCableMode := cmSerial;
    end;
    tmTurbo: DriveIntIndex := CopyCableMode shl 1 + diSerialTurboRead;
    tmWarp: DriveIntIndex := CopyCableMode shl 1 + diSerialWarpRead;
  end;
  ReadLine := ReadLines[SerialCable];
  CopyPriorityMode := plLow;
  if ExtDriveType = dt1581 then
  begin
    A := True;
    if SerialCable = scOpenCBM then
    begin
      TWait := TWaits81[SerialCable];
      TReceive := TSerialReceives81[SerialCable];
      TSend := TSerialSends81[SerialCable];
    end
    else
    begin
      TWait := TWaits81[SerialCable];
      TReceive := TSerialReceives81[SerialCable];
      TSend := TSerialSends81[SerialCable];
    end;
   end
  else
  begin
    A := (SerialCable = scOpenCBM);
    TWait := TWaits[SerialCable];
    case CopyCableMode of
      cmHybrid:
      begin
        TReceive := TReceiveHybrid;
        TSend := TSendHybridParallel;
      end;
      cmParallel:
      begin
        TReceive := TReceiveParallel;
        TSend := TSendHybridParallel;
        TReadParallel := TReadParallelReal;
        TWriteParallel := TWriteParallelReal;
        if A then
        begin
          TReadParallel := TReadParallelOpenCBM;
          TWriteParallel := TWriteParallelOpenCBM;
        end;
      end;
    else
      A := (CopyCableMode = cmAsync);
      F := (ExtDriveType >= dt1571);
      TReceive := TSerialReceives[SerialCable, A, F];
      TSend := TSerialSends[SerialCable, A, F];
    end;
  end;
  if not A then CopyPriorityMode := plHigh;
  SetTimeout(False);
  if O then WarningStatus := WarningStatus or wmBadFeature;
end;

(* ?ASM? *)
{Convert five GCR bytes to four data bytes
  Input : AX,BX,CL: the five GCR bytes
          CH: when not 0, an invalid GCR code in the last byte is not
              considered to be an error
  Output: AX,BX: the four data bytes}
procedure GCRDecode; assembler;
var
  D             : array [0..3] of Byte;
  G             : array [0..4] of Byte;
asm
    push si;
    push di;
    lea si, G;
    lea di, D;
    push di;
    push cx;
    mov ss:[si][0], ax;
    mov ss:[si][2], bx;
    mov ss:[si][4], cl;
    mov cx, ss:[si];
    inc si;
    mov al, cl;
    and al, $F8;
    shr al, 3;
    mov bl, cl;
    and bl, $07;
    shl bl, 2;
    mov ah, ch;
    and ah, $C0;
    shr ah, 6;
    or bl, ah;
    xor bh, bh;
    mov ah, byte ptr GCRDecodeTableLo[bx];
    xor bl, bl;
    call @2;
    mov bl, al;
    mov al, ah;
    mov ah, byte ptr GCRDecodeTableHi[bx];
    xor bl, bl;
    call @2;
    or al, ah;
    mov ss:[di], al;
    inc di;
    mov cx, ss:[si];
    inc si;
    mov al, cl;
    and al, $3E;
    shr al, 1;
    mov bl, cl;
    and bl, $01;
    shl bl, 4;
    mov ah, ch;
    and ah, $F0;
    shr ah, 4;
    or bl, ah;
    xor bh, bh;
    mov ah, byte ptr GCRDecodeTableLo[bx];
    xor bl, bl;
    call @2;
    mov bl, al;
    mov al, ah;
    mov ah, byte ptr GCRDecodeTableHi[bx];
    xor bl, bl;
    call @2;
    or al, ah;
    mov ss:[di], al;
    inc di;
    mov cx, ss:[si];
    inc si;
    mov al, cl;
    and al, $0F;
    shl al, 1;
    mov ah, ch;
    and ah, $80;
    shr ah, 7;
    or al, ah;
    mov bl, ch;
    and bl, $7C;
    shr bl, 2;
    xor bh, bh;
    mov ah, byte ptr GCRDecodeTableLo[bx];
    xor bl, bl;
    call @2;
    mov bl, al;
    mov al, ah;
    mov ah, byte ptr GCRDecodeTableHi[bx];
    xor bl, bl;
    call @2;
    or al, ah;
    mov ss:[di], al;
    inc di;
    mov cx, ss:[si];
    mov al, cl;
    and al, $03;
    shl al, 3;
    mov ah, ch;
    and ah, $E0;
    shr ah, 5;
    or al, ah;
    mov bl, ch;
    and bl, $1F;
    xor bh, bh;
    pop cx;
    mov ah, byte ptr GCRDecodeTableLo[bx];
    mov bl, ch;
    call @2;
    mov bl, al;
    mov al, ah;
    mov ah, byte ptr GCRDecodeTableHi[bx];
    mov bl, ch;
    call @2;
    or al, ah;
    mov ss:[di], al;
    pop di;
    mov ax, ss:[di][0];
    mov bx, ss:[di][2];
    pop di;
    pop si;
    jmp @1;
@2: cmp ah, $FF;
    jne @3;
    or bl, bl;
    jne @3;
    cmp GCRError, 0;
    jne @3;
    push ax;
    mov ah, InvalidGCRCodeMode;
    or ah, ah;
    je @4;
    mov al, 23;
    dec ah;
    je @5;
    mov al, 24;
@5: mov GCRError, al;
@4: pop ax;
@3: retn;
@1:
end;

(* ?ASM? *)
{Convert four data bytes to five GCR bytes
  Input : AX,BX: the four data bytes
  Output: AX,BX,CL: the five GCR bytes}
procedure GCREncode; assembler;
var
  D             : array [0..3] of Byte;
  G             : array [0..4] of Byte;
asm
    push si;
    push di;
    lea si, D;
    lea di, G;
    push di;
    mov ss:[si][0], ax;
    mov ss:[si][2], bx;
    mov al, ss:[si];
    inc si;
    mov bl, al;
    shr bl, 4;
    xor bh, bh;
    mov ah, byte ptr GCREncodeTable[bx];
    mov bl, al;
    and bl, $0F;
    mov al, byte ptr GCREncodeTable[bx];
    mov cl, al;
    shl ah, 3;
    shr al, 2;
    or ah, al;
    shl cl, 6;
    mov ss:[di], ah;
    inc di;
    mov al, ss:[si];
    inc si;
    mov bl, al;
    shr bl, 4;
    xor bh, bh;
    mov ah, byte ptr GCREncodeTable[bx];
    mov bl, al;
    and bl, $0F;
    mov al, byte ptr GCREncodeTable[bx];
    shl ah, 1;
    or ah, cl;
    mov cl, al;
    shr al, 4;
    or ah, al;
    shl cl, 4;
    mov ss:[di], ah;
    inc di;
    mov al, ss:[si];
    inc si;
    mov bl, al;
    shr bl, 4;
    xor bh, bh;
    mov ah, byte ptr GCREncodeTable[bx];
    mov bl, al;
    and bl, $0F;
    mov al, byte ptr GCREncodeTable[bx];
    mov ch, ah;
    shr ah, 1;
    or ah, cl;
    shl ch, 7;
    shl al, 2;
    or ch, al;
    mov ss:[di], ah;
    inc di;
    mov al, ss:[si];
    mov bl, al;
    shr bl, 4;
    xor bh, bh;
    mov ah, byte ptr GCREncodeTable[bx];
    mov bl, al;
    and bl, $0F;
    mov al, byte ptr GCREncodeTable[bx];
    mov cl, ah;
    shr ah, 3;
    or ah, ch;
    shl cl, 5;
    or cl, al;
    mov ss:[di], ah;
    inc di;
    mov ss:[di], cl;
    pop di;
    mov ax, ss:[di][0];
    mov bx, ss:[di][2];
    mov cl, ss:[di][4];
    pop di;
    pop si;
end;

(* ?ASM? *)
{GCR-decode a sector
  Input : DS:SI: buffer containing the GCR-encoded sector data
          DS:DI: buffer to contain the decoded sector data
  Output: DS:SI: end of source buffer
          DS:DI: end of destination buffer}
procedure GCRDecodeSector; assembler;
asm
    push dx;
    xor dx, dx;
@1: mov ax, [si][0];
    mov bx, [si][2];
    mov cl, [si][4];
    xor ch, ch;
    cmp dx, 320;
    jne @10;
    inc ch;
@10:add si, 5;
    call GCRDecode;
    test dx, dx;
    jne @2;
    mov GCRSign, al;
    jmp @3;
@2: mov [di], al;
    inc di;
@3: inc dx;
    cmp dx, 321;
    jb @4;
    mov GCRChecksum, ah;
    jmp @5;
@4: mov [di], ah;
    inc di;
    mov [di], bx;
    add dx, 4;
    add di, 2;
    jmp @1;
@5: inc si;
    cmp GCRSign, SectorSign;
    je @6;
    mov al, 22;
    jmp @7;
@6: sub di, 256;
    mov cx, 256;
    xor al, al;
@8: xor al, [di];
    inc di;
    loop @8;
    cmp al, GCRChecksum;
    je @9;
    mov al, 23;
@7: cmp GCRError, 0;
    jne @9;
    mov GCRError, al;
@9: pop dx;
end;

(* ?ASM? *)
{GCR-encode a sector
  Input : AL: when 0, header information must be precomputed; otherwise it
              is generated here
          DS:SI: buffer containing the sector data
          DS:DI: buffer to contain the GCR-encoded sector data
  Output: AX: 16-bit sum of GCR-encoded data
          DS:SI: end of source buffer
          DS:DI: end of destination buffer}
procedure GCREncodeSector; assembler;
asm
    push dx;
    push di;
    or al, al;
    je @10;
    mov al, SectorSign;
    cmp GCRError, ds22READ;
    jne @7;
    xor al, 1;
@7: mov GCRSign, al;
    mov cx, 256;
    xor al, al;
@1: xor al, [si];
    inc si;
    loop @1;
    sub si, 256;
    cmp GCRError, ds23READ;
    jne @8;
    xor al, 1;
@8: mov GCRChecksum, al;
@10:xor dx, dx;
    mov al, GCRSign;
    jmp @3;
@2: mov al, [si];
    inc si;
    inc dx;
@3: or dh, dh;
    je @4;
    mov ah, GCRChecksum;
    mov bl, HeaderPadding;
    mov bh, bl;
    jmp @5;
@4: mov ah, [si];
    inc si;
    mov bx, [si];
    add si, 2;
@5: call GCREncode;
    mov [di][0], ax;
    mov [di][2], bx;
    mov [di][4], cl;
    add di, 5;
    add dx, 3;
    cmp dx, 256;
    jb @2;
    mov al, SectorGap;
    mov [di], al;
    pop di;
    cmp GCRError, ds24READ;
    jne @9;
    and byte ptr [di][321], $F8;
@9: xor ax, ax;
    mov cx, 322;
@6: add al, [di];
    adc ah, 0;
    inc di;
    loop @6;
    add di, 4;
    pop dx;
end;

(* ?ASM? *)
{GCR-decode a sector header
  Input : DS:SI: buffer containing the GCR-encoded sector header data
          DS:DI: buffer to contain the decoded sector header data
  Output: DS:SI: end of source buffer
          DS:DI: end of destination buffer}
procedure GCRDecodeHeader; assembler;
asm
    push dx;
    xor dx, dx;
    push di;
@1: mov ax, [si][0];
    mov bx, [si][2];
    mov cl, [si][4];
    xor ch, ch;
    add si, 5;
    call GCRDecode;
    mov [di][0], ax;
    mov [di][2], bx;
    add di, 4;
    add dx, 4;
    cmp dx, HeaderSize;
    jb @1;
    pop di;
    cmp byte ptr [di][0], HeaderSign;
    je @2;
    mov al, 20;
    jmp @3;
@2: mov ax, [di][2];
    mov bx, [di][4];
    mov cl, [di][1];
    xor cl, al;
    xor cl, ah;
    xor cl, bl;
    xor cl, bh;
    je @4;
    mov al, 27;
    jmp @3;
@4: cmp FetchDiskID, False;
    jne @5;
    cmp bx, CopyHeaderID;
    je @6;
    mov al, 29;
    jmp @3;
@5: mov CopyHeaderID, bx;
    jmp @6;
@3: cmp GCRError, 0;
    jne @6;
    mov GCRError, al;
@6: add di, HeaderSize;
    pop dx;
end;

(* ?ASM? *)
{GCR-encode a sector header
  Input : DS:SI: buffer containing the sector header data
          DS:DI: buffer to contain the GCR-encoded sector header data
  Output: DS:SI: end of source buffer
          DS:DI: end of destination buffer}
procedure GCREncodeHeader; assembler;
asm
    push dx;
    mov ax, [si];
    add si, 2;
    mov bx, [si];
    add si, 2;
    cmp GCRError, ds27READ;
    je @4;
    cmp GCRError, ds29DISKID;
    jne @1;
@4: xor ah, 1;
@1: call GCREncode;
    cmp GCRError, ds20READ;
    jne @2;
    xor ah, $80;
@2: mov [di][0], ax;
    mov [di][2], bx;
    mov [di][4], cl;
    add di, 5;
    mov ax, [si];
    add si, 2;
    mov bx, [si];
    add si, 2;
    cmp GCRError, ds29DISKID;
    jne @3;
    xor al, 1;
@3: call GCREncode;
    mov [di][0], ax;
    mov [di][2], bx;
    mov [di][4], cl;
    add di, 5;
    pop dx;
end;

{Determine the mode of an LPT port
  Input : Address: the address of the LPT port
  Output: LPT port mode}
function GetLPTMode(Address: Word): Byte; assembler;
asm
    push Address;
    call ValidLPTAddr;
    xor cl, cl;
    or al, al;
    je @20;
    mov dx, Address;
    add dx, 2;
    mov bx, dx;
    mov cl, pmECP;
    add dx, ECPAddrOffs;
    in al, dx;
    and al, $F8;
    mov ch, al;
    mov al, $34;
    out dx, al;
    mov dx, bx;
    mov al, $C6;
    cmp SerialCable, scExtended;
    jbe @17;
    mov al, $CA;
@17:out dx, al;
    add dx, ECPAddrOffs;
    in al, dx;
    cmp al, $35;
    jne @2;
    mov al, $D4;
    out dx, al;
    sub dx, 2;
    in al, dx;
    mov al, $AA;
    out dx, al;
    jmp @11;
@11:in al, dx;
    cmp al, $AA;
    jne @2;
    mov al, $55;
    out dx, al;
    jmp @12;
@12:in al, dx;
    cmp al, $55;
    jne @2;
    add dx, 2;
    mov al, $35;
    out dx, al;
    mov al, ch;
    out dx, al;
    jmp @1;
@2: mov dx, bx;
    add dx, ECPAddrOffs;
    mov al, ResetBit;
    cmp SerialCable, scExtended;
    jbe @18;
    or al, ch;
    jmp @19;
@18:not al;
    and al, ch;
@19:out dx, al;
    mov cl, pmEPP;
    mov al, $EF;
    call @5;
    jnc @1;
    xor al, al;
@15:push ax;
    test al, ResetBit;
    je @16;
    call @5;
    pop ax;
    jnc @1;
@16:inc al;
    jne @15;
    mov cl, pmSPP;
    mov dx, bx;
    in al, dx;
    or al, sbBidir;
    out dx, al;
    sub dx, 2;
    mov al, $AA;
    out dx, al;
    jmp @9;
@9: in al, dx;
    cmp al, $AA;
    jne @3;
    mov al, $55;
    out dx, al;
    jmp @10;
@10:in al, dx;
    cmp al, $55;
    je @13;
@3: mov cl, pmPS2;
@13:mov dx, bx;
    in al, dx;
    and al, not sbBidir;
    out dx, al;
    sub dx, 2;
    mov al, $AA;
    out dx, al;
    jmp @14;
@14:in al, dx;
    cmp al, $AA;
    jne @4;
    mov al, $55;
    out dx, al;
    jmp @8;
@8: in al, dx;
    cmp al, $55;
    je @1;
@4: xor cl, cl;
    jmp @1;
@5: mov dx, bx;
    out dx, al;
    inc dx;
    call @7;
    mov al, $AA;
    out dx, al;
    call @7;
    in al, dx;
    cmp al, $AA;
    stc;
    jne @6;
    call @7;
    mov al, $55;
    out dx, al;
    call @7;
    in al, dx;
    cmp al, $55;
    stc;
    jne @6;
    clc;
@6: retn;
@7: push ax;
    push dx;
    mov dx, bx;
    dec dx;
    in al, dx;
    or al, $01;
    out dx, al;
    and al, $FE;
    out dx, al;
    pop dx;
    pop ax;
    retn;
@1: mov dx, bx;
    mov al, ResetBit;
    out dx, al;
@20:mov al, cl;
end;

{Check the LPT port mode and display a message if the mode is invalid for
  the transfer mode
  Input : Port: the logical number of the LPT port
          Message: code of the message to display
  Output: when True, it is OK to access the external drive via the port}
function CheckLPTPort(Port: Byte; Message: Byte): Boolean;
var
  O             : Boolean;
  B             : Byte;
  T,
  S             : string[20];
begin
  O := True;
  if SerialCable <> scOpenCBM then
  begin
    B := LPTModes[Port];
    if ValidLPTAddr(LPTAddresses[Port]) and (B <> pmNone) then
    begin
      if (DetectPortModes <> dpNone) and TransferWarning and (Message <> wmHybridLPT) then
      begin
        WarningStatus := WarningStatus or Message;
        case Message of
          wmSerialLPT:
          begin
            O := ((SerialCable <> scNormal) or (B in [pmSPP, pmPS2]));
            T := 'X1541';
            case B of
              pmEPP: S := 'EPP';
              pmECP: S := 'ECP';
            end;
          end;
          wmParallelLPT:
          begin
            O := (B in [pmPS2..pmECP]);
            T := 'XP1541/XP1571';
            S := 'SPP';
          end;
        end;
        if not O and (OperatingSystem and osWindowsNT = 0) then
        begin
          GoSound := True;
          O := (SureConfirm('Warning', 'The ' + T + ' connection with an external drive',
          'is not possible via an ' + S + ' parallel port.', 'Do you still wish to continue?', stEmpty, stYes,
          stEmpty, stEmpty, stEmpty, stNo, nil, hcOnlyQuit, ayNone, False, DummyByte) = cmOK);
        end;
      end;
    end
    else
    begin
      GoSound := True;
      ErrorWin(stError, 'The parallel port you wish to use', 'has an invalid address or is not a parallel port.',
        hcOnlyQuit, sbNone);
      O := False;
    end;
  end;
  CheckLPTPort := O;
end;

{Disable the access of parallel ports, if configured so on the command line
  or when using the OpenCBM driver}
procedure EnableLPTPorts;
begin
  DisableLPTPorts := CopyDisableLPTPorts;
  if SerialCable = scOpenCBM then DisableLPTPorts := True;
end;

{Enable access of the hardware ports under Windows NT/2000/XP, opening the
  "giveio" or the "userport" driver}
procedure EnableWinNTPortAccess;
var
  B             : Byte;
  I             : Integer;
begin
  EnableLPTPorts;
  if ((not DisableLPTPorts and (SerialCable in [scNormal..scActive])) or
    (SerialCable = scOpenCBM)) and
    (OperatingSystem and osWindowsNT <> 0) then
  begin
    B := FileMode;
    I := InOutRes;
    if ExtIsClosed(GiveIODrv) then LongOpenFile('\\.\giveio', GiveIODrv, fmReadOnly);
    if ExtIsClosed(UserPortDrv) then LongOpenFile('\\.\userport', UserPortDrv, fmReadOnly);
    InOutRes := I;
    FileMode := B;
  end;
end;

{Disble access of the hardware ports under Windows NT/2000/XP, closing the
  "giveio" or the "userport" driver}
procedure DisableWinNTPortAccess;
var
  I             : Integer;
begin
  if not DisableLPTPorts and (OperatingSystem and osWindowsNT <> 0) then
  begin
    I := InOutRes;
    if not ExtIsClosed(GiveIODrv) then ExtClose(GiveIODrv);
    if not ExtIsClosed(UserPortDrv) then ExtClose(UserPortDrv);
    InOutRes := I;
  end;
end;

{Check the LPT port modes and whether a multi-tasking system is running in
  the background
  Input : CheckSerial: when True, for no serial cable configured, an error
          message is displayed and the appropriate configuration screen
          popped up
  Output: when True, it is OK to access the external drive}
function CheckLPTPorts(CheckSerial: Boolean): Boolean;
var
  C,
  O             : Boolean;
  B             : Byte;
  I             : Integer;
  E             : TEvent;
begin
  O := True;
  if SerialCable = scNone then
  begin
    if CheckSerial then
    begin
      C := ClockVis;
      ClockOn;
      ErrorWin(stError, 'You cannot access a Commodore drive yet.',
        'Configure your serial cable first.', hcOnlyQuit, sbNone);
      E.What := evCommand;
      E.Command := cmCfgTransfer;
      Application^.PutEvent(E);
      MainConfig;
      if C then ClockOn else ClockOff;
    end;
    O := (SerialCable <> scNone);
  end;
  if O and (SerialCable = scOpenCBM) then
  begin
    if OperatingSystem and osWindowsNT = 0 then
    begin
      ErrorWin(stError, 'The OpenCBM driver is not available', 'outside Windows NT4/2000/XP/2003.', hcOnlyQuit, sbNone);
      O := False;
    end
    else
    begin
      I := OpenCBMVDDInit;
      O := (I = 0);
      if O then
      begin
        I := OpenCBMDriverOpen;
        O := (I = 0);
        if not O then
        begin
          ErrorWin(stError, 'The OpenCBM driver could not be opened.',
            'Check your CBM4Win/OpenCBM installation.', hcOnlyQuit, sbNone);
        end;
      end
      else
      begin
        ErrorWin(stError, 'The OpenCBM VDD could not be loaded.',
          'Check your CBM4Win/OpenCBM installation.', hcOnlyQuit, sbNone);
      end;
    end;
  end;
  EnableWinNTPortAccess;
  if (WarningStatus and wmMultiTasking = 0) and (OperatingSystem and (osWindows + osDESQview) <> 0)
    and (CopyCableMode = cmSerial) and (SerialCable <> scOpenCBM) and O then
  begin
    WarningStatus := WarningStatus or wmMultiTasking;
    if TransferWarning then
    begin
      GoSound := True;
      O := (SureConfirm('Warning', 'The serial connection with an external drive',
        'is unreliable under a multi-tasking system.', 'You should enable async transfer.',
        'Do you still wish to continue?', stYes, stEmpty, stEmpty, stEmpty, stNo, nil, hcOnlyQuit, ayNone, False,
        DummyByte) = cmOK);
    end;
  end;
  if O and (WarningStatus and wmExtendedLPT = 0) and (CopyCableMode = cmHybrid) and not (SerialCable <> scNormal) and
    (LPTAddr = ParLPTAddr) then
  begin
    WarningStatus := WarningStatus or wmExtendedLPT;
    GoSound := True;
    O := (SureConfirm('Warning', 'You can''t use the XE1541, XM1541 or XA1541 cable and',
      'the XH1541/XH1571 cable on the same parallel port.', 'Do you still wish to continue?',
      stEmpty, stYes, stEmpty, stEmpty, stEmpty, stNo, nil, hcOnlyQuit, ayNone, False, DummyByte) = cmOK);
  end;
  if O and (WarningStatus and wmSerialLPT = 0) then O := CheckLPTPort(LPTNum, wmSerialLPT);
  if O and (CopyCableMode in [cmHybrid, cmParallel]) then
  begin
    B := wmParallelLPT;
    if CopyCableMode = cmHybrid then B := wmHybridLPT;
    if WarningStatus and wmParallelLPT = 0 then O := CheckLPTPort(ParLPTNum, B);
    if O then InitLPTPorts;
  end;
  CheckLPTPorts := O;
end;

{Emergency exit routine}
procedure EmergencyExit;
var
  O             : Boolean;
begin
  if MainProgram then ShellBuffer^.QuitProgram := True;
  O := (Application <> nil);
  if O then Application^.Done;
  asm
    in al, $61;
    mov ah, al;
    or al, $80;
    out $61, al;
    mov al, ah;
    out $61, al;
    mov al, $20;
    out $20, al;
    in al, $61;
    and al, $FE;
    out $61, al;
    mov al, $36;
    out $43, al;
    xor al, al;
    out $40, al;
    out $40, al;
    mov al, $F4;
    out $60, al;
    in al, $60;
  end;
  if FatalError <> '' then
  begin
    if O then PrintStr(chCR + chLF);
    PrintStr(FatalError);
  end;
  Halt(0);
end;

{Turn the mouse cursor on}
procedure MouseOn;
begin
  while MouseVal > 0 do
  begin
    ShowMouse;
    Dec(MouseVal);
  end;
end;

{Turn the mouse cursor off}
procedure MouseOff;
begin
  if MouseVal = 0 then
  begin
    HideMouse;
    Inc(MouseVal);
  end;
end;

{Save the current status of the mouse cursor and turn it on/off
  Input : B: when True, the mouse is turned on, otherwise off}
procedure GetMouse(B: Boolean);
begin
  MouseLast := MouseVal;
  if B then MouseOn else MouseOff;
end;

{Re-load the status of the mouse cursor}
procedure SetMouse;
begin
  if MouseLast = 0 then MouseOn else MouseOff;
end;

{Change the help context
  Input : Help: help context to change to}
procedure ChangeHelpCtx(Help: Word);
begin
  LastHelpCtx := CurHelpCtx;
  HelpCtxSet := True;
  CurHelpCtx := Help;
  AppHelpCtx := Help;
  LastShiftState := MaxByte;
end;

{Restore the help context}
procedure RestoreHelpCtx;
begin
  HelpCtxSet := False;
  CurHelpCtx := LastHelpCtx;
  AppHelpCtx := LastHelpCtx;
  LastShiftState := MaxByte;
end;

{Swap a block of memory with another
  Input : Source, Dest: the two memory blocks
          Count: the number of bytes to swap}
procedure SwapMem(var Source, Dest; Count: Word); assembler;
asm
    push ds;
    mov cx, Count;
    lds si, Source;
    les di, Dest;
    cld;
@1: mov ah, es:[di];
    movsb;
    mov [si][-1], ah;
    loop @1;
    pop ds;
end;

{Compare a block of memory with another
  Input : Source, Dest: the two memory blocks
          Count: the number of bytes to compare
  Output: when True, the memory blocks are the same}
function CompMem(var Source, Dest; Count: Word): Boolean; assembler;
asm
    push ds;
    xor al, al;
    mov cx, Count;
    lds si, Source;
    les di, Dest;
    cld;
    repe cmpsb;
    jne @1;
    inc al;
@1: pop ds;
end;

{Read a block of data from the archive
  Input : ArcFile: the archive file to read from}
procedure ReadArcBlock(var ArcFile: ExtFile);
begin
  if ArcSize > TempBufferSize then ArcBufSize := TempBufferSize else ArcBufSize := ArcSize;
  Dec(ArcSize, ArcBufSize);
  if ArcBackwards then ExtSeek(ArcFile, ArcPos - ArcBufSize);
  ExtBlockRead(ArcFile, GCRBuffer, ArcBufSize);
end;

{Read a byte from the archive
  Input : ArcFile: the archive file to read from
          Data: the variable to contain the byte
  Output: when False, the archive has ended or there was an error}
function ReadArcByte(var ArcFile: ExtFile; var Data: Byte): Boolean;
var
  F,
  O             : Boolean;
begin
  Data := 0;
  O := False;
  if ArcBackwards then F := (ArcBufPos = 0) else F := (ArcBufPos >= ArcBufSize);
  if F then
  begin
    ArcEnd := (ArcSize = 0);
    if not ArcEnd then ReadArcBlock(ArcFile);
    if ArcBackwards then ArcBufPos := ArcBufSize else ArcBufPos := 0;
  end;
  if not ArcEnd then
  begin
    O := True;
    if ArcBackwards then
    begin
      Dec(ArcBufPos);
      Dec(ArcPos);
    end;
    Data := GCRBuffer[ArcBufPos];
    if not ArcBackwards then
    begin
      Inc(ArcBufPos);
      Inc(ArcPos);
    end;
  end;
  ReadArcByte := O;
end;

{Search for a string in the archive; the string must not contain multiple
  instances of its first character
  Input : ArcFile: the archive file to search in
          Str: the string to search for
          Backwards: when False, search advances from file beginning to end;
                     when True, from end to beginning
  Output: when True, the string was found}
function SearchArchive(var ArcFile: ExtFile; const Str: string; Backwards: Boolean): Boolean;
var
  F,
  O             : Boolean;
  C,
  D,
  I,
  L             : Byte;
begin
  ArcBackwards := Backwards;
  L := Length(Str);
  F := False;
  if Backwards then I := L else I := 1;
  C := L;
  repeat
    O := ReadArcByte(ArcFile, D);
    if O then
    begin
      if D = Ord(Str[I]) then
      begin
        if Backwards then Dec(I) else Inc(I);
        Dec(C);
        F := (C = 0);
      end
      else
      begin
        if Backwards then I := L else I := 1;
        C := L;
      end;
    end;
  until F or not O;
  ArcBackwards := False;
  SearchArchive := F;
end;

{Create an error message on basis of the status returned by the external CBM
  drive
  Input : Error: status code
          Track, Sector: the track and sector where the error occured
          Str: string to contain the error message
  Output: when True, the status code tells that an error occured}
function MakeErrorStr(Error, Track, Sector: Byte; var Str: string): Boolean;
var
  O             : Boolean;
begin
  O := True;
  case Error of
    0: Error := 24;
    2..11: Inc(Error, 20 - ds20READ);
    15: Error := 74;
  else
    Error := 0;
  end;
  case Error of
    0:
    begin
      O := False;
      Str := 'OK';
    end;
    20..24, 27: Str := 'READ ERROR';
    25, 28: Str := 'WRITE ERROR';
    26: Str := 'WRITE PROTECT ON';
    29: Str := 'DISK ID MISMATCH';
    74:
    begin
      O := False;
      Str := 'DRIVE NOT READY';
    end;
    MaxByte:
    begin
      Error := 99;
      Str := 'UNKNOWN ERROR';
    end;
  end;
  Str := LeadingZero(Error, 2) + ',' + Str;
  if not O then
  begin
    Track := 0;
    Sector := 0;
  end;
  Str := Str + ',' + LeadingZero(Track, 2) + ',' + LeadingZero(Sector, 2);
  MakeErrorStr := (Error <> 0);
end;

{Determine whether a panel mode supports a given feature
  Input : Mode: panel mode
          Attr: feature bit
  Output: when True, the feature is supported}
function GetPanelModeAttrib(Mode: Byte; Attr: Word): Boolean;
begin
  GetPanelModeAttrib := (PanelModeAttribs[Mode] and Attr > 0);
end;

{Create a string representing the current file type
  Input : Mode: the current mode of the panel
  Output: the name of the file type}
function MakeTypeStr(Mode: Byte): string;
var
  S             : string;
begin
  S := '';
  case Mode of
    pmDisk: S := 'Disk';
    pmTape: S := 'Tape';
    pmFile: S := 'File';
    pmLynx: S := 'Lynx';
    pmArkive: S := 'Arkive';
    pmTAR: S := 'TAR';
    pmLHA: S := 'LHA';
    pmZIP: S := 'ZIP';
    pmFileZip: S := 'FileZip';
    pmGCRDisk: S := 'GCRDisk';
    pmDiskZip: S := 'DiskZip';
    pmSixZip: S := 'SixZip';
  end;
  MakeTypeStr := S;
end;

{Create a long string representing the current file type
  Input : Mode: the current mode of the panel
  Output: the name of the file type}
function MakeFullTypeStr(Mode: Byte): string;
var
  S             : string;
begin
  S := '';
  case Mode of
    pmDisk: S := 'disk';
    pmTape: S := 'tape';
    pmFile: S := 'file';
    pmLynx: S := 'Lynx';
    pmArkive: S := 'Arkive';
    pmTAR: S := 'TAR';
    pmLHA: S := 'LHA';
    pmZIP: S := 'ZIP';
    pmFileZip: S := 'filepacked ZipCode';
    pmGCRDisk: S := 'GCR-coded disk';
    pmDiskZip: S := 'diskpacked ZipCode';
    pmSixZip: S := 'sixpacked ZipCode';
  end;
  if GetPanelModeAttrib(Mode, paImage) then S := S + ' image';
  if GetPanelModeAttrib(Mode, paArchive) then S := S + ' archive';
  MakeFullTypeStr := S;
end;

{Return the name of drive types
  Input : DriveType: the drive type code
  Output: the name of the drive type}
function DriveTypeStr(DriveType: Byte): string;
begin
  case DriveType of
    xd1541: DriveTypeStr := '1541';
    xd1571: DriveTypeStr := '1571';
    xd1581: DriveTypeStr := '1581';
    xd1570: DriveTypeStr := '1570';
    xd157xEmu: DriveTypeStr := '157x->1541';
  end;
end;

(* ?ASM? *)
{Compare two file names for the sort routine - it sorts the characters
  '[', ']', '^' and '_' between '@' and 'A'
  Input : P, Q: strings to be compared
  Output: comparison result (-1: P < Q, 0: P = Q, 1: P > Q)}
function CompareString(const P, Q: string): Integer; assembler;
asm
    push ds;
    push es;
    push bp;
    xor dx, dx;
    lds bx, P;
    les bp, Q;
    mov al, byte ptr [bx];
    xor ah, ah;
    mov si, ax;
    mov byte ptr [bx][si][1], ah;
    mov al, byte ptr es:[bp];
    mov si, ax;
    mov byte ptr es:[bp][si][1], ah;
    mov si, 1;
@2: mov al, byte ptr [bx][si];
    mov ah, byte ptr es:[bp][si];
    inc si;
    or al, al;
    je @1;
    cmp al, 'a';
    jb @9;
    cmp al, 'z';
    ja @9;
    sub al, 'a' - 'A';
@9: cmp ah, 'a';
    jb @10;
    cmp ah, 'z';
    ja @10;
    sub ah, 'a' - 'A';
@10:cmp al, ah;
    je @2;
@1: cmp al, '@';
    jne @5;
    sub al, '@' - ':';
@5: cmp al, '[';
    jb @6;
    cmp al, '_';
    ja @6;
    sub al, '[' - ';';
@6: cmp ah, '@';
    jne @7;
    sub ah, '@' - ':';
@7: cmp ah, '[';
    jb @8;
    cmp ah, '_';
    ja @8;
    sub ah, '[' - ';';
@8: cmp al, ah;
    je @3;
    ja @4;
    dec dx;
    jmp @3;
@4: inc dx;
@3: mov ax, dx;
    pop bp;
    pop es;
    pop ds;
end;

{Convert the CBM file name into an ASCII string, converting invalid characters
  into hexadecimal codes, if needed
  Input : Name: the CBM file name
          GEOS: when True, the file name is a GEOS file name and so there is
                no need to convert from PETSCII to ASCII
          FileCopy: when True, the conversion is needed to get a matching DOS
                    file name
          Conv: when not #0, conversion of invalid characters into hexadecimal
                codes is allowed
  Output: the ASCII string}
function ConvertCBMName(const Name: string; GEOS, FileCopy: Boolean; Conv: Char): string;
var
  C,
  D             : Char;
  X,
  Y             : Word;
  T             : string[2];
  S             : string;
begin
  if (Conv <> #0) and (ConvInvalidChars <> ccNone) then
  begin
    Y := 1;
    for X := 1 to Length(Name) do
    begin
      D := Name[X];
      if GEOS then C := D else C := Chr(PETtoASCLower[Ord(D)]);
      if (C in [Conv, '*', '?']) or
        (not GEOS and not (Ord(D) in PETequivASC)) or
        (GEOS and (D in [#$00..#$1F, #$80..#$FF])) or
        (FileCopy and ((C in [#$00..#$1F, '"', '/', ':', '<', '>', '\', '|', #$7F])) or
          ((ConvInvalidChars = ccInvalidAndSpace) and (C = ' ')) or
          ((C in [' ', '.']) and (X = Length(Name)))) then
      begin
        S[Y] := Conv;
        T := HexaStr(Ord(D), 2);
        Move(T[1], S[Y + 1], 2);
        Inc(Y, 3);
      end
      else
      begin
        S[Y] := C;
        Inc(Y);
      end;
    end;
    S[0] := Chr(Y - 1);
  end
  else
  begin
    if GEOS then
    begin
      S[0] := Name[0];
      for Y := 1 to Length(Name) do
      begin
        C := Chr(Ord(Name[Y]) and $7F);
        if not (C in [#$20..#$7E]) then C := '*';
        S[Y] := C;
      end;
    end
    else
    begin
      S[0] := Name[0];
      for Y := 1 to Length(Name) do S[Y] := Chr(PETtoASCLower[Ord(Name[Y])]);
    end;
  end;
  ConvertCBMName := S;
end;

{Convert the ASCII string into a CBM file name, converting hexadecimal codes
  into characters, if needed
  Input : Name: the ASCII string
          GEOS: when True, the file name is a GEOS file name and so there is
                no need to convert from ASCII to PETSCII
          FileCopy: when True, the conversion is needed to get a matching CBM
                    file name; otherwise hexadecimal codes have to be kept
          Conv: when not #0, conversion of hexadecimal codes into characters is
                allowed
  Output: the CBM file name}
function ReconvertCBMName(const Name: string; GEOS, FileCopy: Boolean; Conv: Char): string;
var
  C,
  D             : Char;
  X,
  Y             : Word;
  I             : Integer;
  S             : string;
begin
  if (Conv <> #0) and (ConvInvalidChars <> ccNone) then
  begin
    Y := 1;
    X := 1;
    while X <= Length(Name) do
    begin
      C := Name[X];
      if (C = Conv) and (X <= Length(Name) - 2) then
      begin
        D := Chr(HexaEval(Copy(Name, X + 1, 2), I));
        if I = 0 then
        begin
          if FileCopy then
          begin
            C := D;
          end
          else
          begin
            S[Y] := Conv;
            S[Y + 1] := Name[X + 1];
            C := Name[X + 2];
            Inc(Y, 2);
          end;
          Inc(X, 2);
        end;
      end
      else
      begin
        if not GEOS then C := Chr(ASCtoPET[Ord(C)]);
      end;
      S[Y] := C;
      Inc(X);
      Inc(Y);
    end;
    S[0] := Chr(Y - 1);
  end
  else
  begin
    if GEOS then
    begin
      S[0] := Name[0];
      for Y := 1 to Length(Name) do
      begin
        C := Chr(Ord(Name[Y]) and $7F);
        if not (C in [#$20..#$7E]) then C := '*';
        S[Y] := C;
      end;
    end
    else
    begin
      S[0] := Name[0];
      for Y := 1 to Length(Name) do S[Y] := Chr(ASCtoPET[Ord(Name[Y])]);
    end;
  end;
  ReconvertCBMName := S;
end;

{Convert the CBM path name into an ASCII string, converting invalid characters
  into hexadecimal codes, if needed
  Input : Path: the CBM path name
          GEOS: when True, the file name is a GEOS file name and so there is
                no need to convert from PETSCII to ASCII
          FileCopy: when True, the conversion is needed to get a matching DOS
                    file name
          Conv: when not #0, conversion of invalid characters into hexadecimal
                codes is allowed
          DirSep: the directory separator character
  Output: the ASCII string}
function ConvertCBMPath(Path: string; GEOS, FileCopy: Boolean; Conv: Char; DirSep: Char): string;
var
  S,
  T             : string;
begin
  S := '';
  while Path <> '' do
  begin
    if S <> '' then S := chDirSep + S;
    T := ConvertCBMName(CutPath(Path, DirSep), GEOS, FileCopy, Conv);
    S := T + S;
    Path := GetPath(Path, DirSep);
  end;
  ConvertCBMPath := S;
end;

{Convert the ASCII string into a CBM path name, converting hexadecimal codes
  into characters, if needed
  Input : Path: the CBM path name
          GEOS: when True, the file name is a GEOS file name and so there is
                no need to convert from ASCII to PETSCII
          FileCopy: when True, the conversion is needed to get a matching CBM
                    file name; otherwise hexadecimal codes have to be kept
          Conv: when not #0, conversion of hexadecimal codes into characters is
                allowed
          DirSep: the directory separator character
  Output: the ASCII string}
function ReconvertCBMPath(Path: string; GEOS, FileCopy: Boolean; Conv: Char; DirSep: Char): string;
var
  S,
  T             : string;
begin
  S := '';
  while Path <> '' do
  begin
    if S <> '' then S := chDirSep + S;
    T := ReconvertCBMName(CutPath(Path, DirSep), GEOS, FileCopy, Conv);
    S := T + S;
    Path := GetPath(Path, DirSep);
  end;
  ReconvertCBMPath := S;
end;

{Convert the CBM file name into a special form for displaying it in a
  dialog box
  Input : Name: the CBM file name
          GEOS: when True, the file name is a GEOS file name, in which
                case only the eighth bits are stripped off and control
                characters eliminated
  Output: the special form string}
function MakeCBMName(const Name: string; GEOS: Boolean): string;
var
  C             : Char;
  X             : Word;
  S             : string;
begin
  if GEOS then
  begin
    S[0] := Name[0];
    for X := 1 to Length(Name) do
    begin
      C := Chr(Ord(Name[X]) and $7F);
      if not (C in [#$20..#$7E]) then C := '*';
      S[X] := C;
    end;
    MakeCBMName := S;
  end
  else
  begin
    MakeCBMName := PETSCIIStart + Chr(Length(Name)) + Name;
  end;
end;

{Clone a file name on basis of the original file name and a cloning pattern
  Input : Name: the original file name
          Pattern: the cloning pattern
          ConvName: when True, hexadecimal codes, starting with '%', have to
                    be converted in the name
          ConvPattern: when True, hexadecimal codes, starting with '%', have
                       to be converted in the pattern
  Output: the cloned file name}
function CloneName(const Name, Pattern: string; ConvName, ConvPattern: Boolean): string;
var
  C,
  D,
  E             : Char;
  X,
  Y,
  Z             : Word;
  I             : Integer;
  S             : string;
begin
  X := 1;
  Y := 1;
  Z := 0;
  while Y <= Length(Pattern) do
  begin
    C := Name[X];
    if (C = hxPercent) and ConvName and (ConvInvalidChars <> ccNone) and (X <= Length(Name) - 2) then
    begin
      E := Chr(HexaEval(Copy(Name, X + 1, 2), I));
      if I = 0 then
      begin
        C := E;
        Inc(X, 2);
      end;
    end;
    D := Pattern[Y];
    I := 1;
    if (D = hxPercent) and ConvPattern and (ConvInvalidChars <> ccNone) and (Y <= Length(Pattern) - 2) then
    begin
      E := Chr(HexaEval(Copy(Pattern, Y + 1, 2), I));
      if I = 0 then
      begin
        D := E;
        Inc(Y, 2);
      end;
    end;
    E := D;
    if I <> 0 then
    begin
      case D of
        '?':
        begin
          if X > Length(Name) then break;
          E := C;
        end;
        '*':
        begin
          if X > Length(Name) then break;
          Dec(Y);
          E := C;
        end;
      end;
    end;
    Inc(X);
    Inc(Y);
    Inc(Z);
    S[Z] := E;
  end;
  S[0] := Chr(Z);
  CloneName := S;
end;

{Split the DOS file name into name and extension
  Input : Entry: the DOS file name
          Name: the string to contain the name
          Ext: the string to contain the extension}
procedure SplitName(const Entry: string; var Name, Ext: string);
var
  P             : Byte;
begin
  P := RightPos('.', Entry);
  if P < 2 then
  begin
    Name := Entry;
    Ext := '';
  end
  else
  begin
    Name := Copy(Entry, 1, P - 1);
    Ext := Copy(Entry, P + 1, MaxStrLen);
  end;
end;

{Clone the two parts of the DOS file name separately
  Input : Name1: the original file name
          Name2: the cloning pattern
  Output: the cloned file name}
function CloneDOSName(const Name1, Name2: string): string;
var
  E1,
  E2,
  N1,
  N2            : string;
begin
  if LongFileNames and (LeftPos('.', Name2) = 0) then
  begin
    CloneDOSName := CloneName(Name1, Name2, False, False);
  end
  else
  begin
    SplitName(Name1, N1, E1);
    SplitName(Name2, N2, E2);
    N1 := CloneName(N1, N2, False, False);
    E1 := CloneName(E1, E2, False, False);
    if E1 <> '' then N1 := N1 + stDot + E1;
    CloneDOSName := N1;
  end;
end;

{Check if the specified Commodore file name matches the pattern
  Input : Pattern: the pattern to match with
          Name: the name of the file
          Attr: the type of the file
          Partial: when True, the file name is accepted even if there are
                   extra characters at the end after the part matching the
                   pattern
  Output: when True, the name and type matches the pattern}
function CompareCBMEntry(const Pattern, Name: string; Attr: Byte; Partial: Boolean): Boolean;
var
  B,
  E             : Boolean;
  I,
  J,
  N,
  P,
  Q,
  R             : Byte;
  C,
  D,
  G             : Char;
  M             : Integer;
begin
  E := True;
  N := 1;
  P := 1;
  Q := Length(Name) + 1;
  R := RightPos('=', Pattern);
  if R = 0 then R := Length(Pattern) + 1;
  while (P < R) and (Partial or (N < Q)) and E do
  begin
    C := Pattern[P];
    if C = '*' then
    begin
      B := (P = R - 1);
      if not B then
      begin
        B := True;
        I := N;
        J := P + 1;
        while B and ((I < Q) or (J < R)) do
        begin
          if (J < R) and (Pattern[J] = '*') then
          begin
            B := False;
            Inc(P);
          end
          else
          begin
            if (I < Q) and (J < R) and ((Pattern[J] = '?') or (Pattern[J] = Name[I])) then
            begin
              Inc(I);
              Inc(J);
            end
            else
            begin
              B := False;
              Inc(N);
              if N >= Q then E := False;
            end;
          end;
        end;
        B := ((Partial or (I >= Q)) and (J >= R));
      end;
      if B then
      begin
        N := Q;
        P := R;
      end;
    end
    else
    begin
      D := C;
      if (C = hxPercent) and (P + 2 <= R) then
      begin
        G := Chr(HexaEval(Copy(Pattern, P + 1, 2), M));
        if M = 0 then
        begin
          D := G;
          Inc(P, 2);
        end;
      end;
      if (N < Q) and ((C = '?') or (D = Name[N])) then
      begin
        Inc(N);
        Inc(P);
      end
      else
      begin
        E := False;
      end;
    end;
  end;
  E := (E and (Partial or (N >= Q)));
  if E then
  begin
    P := RightPos('=', Pattern);
    if (P > 0) then E := ((P < Length(Pattern)) and (LoCase(Pattern[P + 1]) = ShortCBMExt[Attr and faTypeMask][1]));
  end;
  CompareCBMEntry := E;
end;

{Check if the specified DOS directory entry matches the pattern
  Input : Pattern: the pattern to match with
          Name: the name of the file
          Long: when True, the file name is handled as a whole instead of
                being split into name and extension
          Partial: when True, the file name is accepted even if there are
                   extra characters at the end after the part matching the
                   pattern
  Output: when True, the name matches the pattern}
function CompareDOSEntry(const Pattern: string; Name: string; Long, Partial: Boolean): Boolean;
var
  E,
  F,
  M             : Boolean;
  N,
  P,
  Q,
  R             : Byte;

{Compare a part of the DOS file name}
procedure ComparePart;
var
  B             : Boolean;
  I,
  J             : Byte;
begin
  while E and ((N < Q) or (P < R)) do
  begin
    if (P < R) and (Pattern[P] = '*') then
    begin
      B := True;
      if Long then
      begin
        B := (P = R - 1);
        if not B then
        begin
          B := True;
          I := N;
          J := P + 1;
          while B and ((I < Q) or (J < R)) do
          begin
            if (J < R) and (Pattern[J] = '*') then
            begin
              B := False;
              Inc(P);
            end
            else
            begin
              if (I < Q) and (J < R) and ((Pattern[J] = '?') or (UpCase(Pattern[J]) = UpCase(Name[I]))) then
              begin
                Inc(I);
                Inc(J);
              end
              else
              begin
                B := False;
                Inc(N);
                if N >= Q then
                begin
                  E := False;
                  if not Partial then M := False;
                end;
              end;
            end;
          end;
          B := ((Partial or (I >= Q)) and (J >= R));
        end;
      end;
      if B then
      begin
        N := Q;
        P := R;
      end;
    end
    else
    begin
      if (N < Q) and (P < R) then
      begin
        if ((Pattern[P] = '?') or (UpCase(Pattern[P]) = UpCase(Name[N]))) then
        begin
          Inc(N);
          Inc(P);
        end
        else
        begin
          E := False;
          M := False;
        end;
      end
      else
      begin
        E := False;
      end;
    end;
  end;
  M := (M and (Partial or (N >= Q)) and (P >= R));
  E := M;
end;

begin
  E := True;
  M := True;
  N := 1;
  P := 1;
  Q := 0;
  R := 0;
  if ((Pattern[Length(Pattern)] = '.') or (Copy(Pattern, Length(Pattern) - 1, 2) = '.*')) and (LeftPos('.', Name) = 0) then
    Name := Name + stDot;
  if not Long then
  begin
    Q := RightPos('.', Name);
    R := RightPos('.', Pattern);
  end;
  if Q = 0 then Q := Length(Name) + 1;
  if R = 0 then R := Length(Pattern) + 1;
  ComparePart;
  if not Long and M then
  begin
    Inc(N);
    Inc(P);
    Q := Length(Name) + 1;
    R := Length(Pattern) + 1;
    ComparePart;
  end;
  CompareDOSEntry := M;
end;

{Fetch the next pattern from the pattern list
  Input : List: the list of patterns
          Pattern: the string to contain the next pattern
  Output: the position of the current pattern delimiter}
function NextPattern(var List, Pattern: string): Word;
var
  B             : Word;
begin
  B := LeftPos(';', List);
  if B = 0 then B := LeftPos(',', List);
  if B = 0 then
  begin
    Pattern := List;
    List := '';
  end
  else
  begin
    Pattern := Copy(List, 1, B - 1);
    List := Copy(List, B + 1, MaxStrLen);
  end;
  NextPattern := B;
end;

{Check if the specified Commodore file name matches any pattern in the
  pattern list
  Input : Pattern: the pattern list to match with
          Name: the name of the file
          Attr: the type of the file
          Partial: when True, the file name is accepted even if there are
                   extra characters at the end after the part matching the
                   pattern
  Output: when True, the name and type matches the pattern}
function ListCompareCBMEntry(const Pattern, Name: string; Attr: Byte; Partial: Boolean): Boolean;
var
  O             : Boolean;
  B             : Word;
  N,
  S             : string;
begin
  S := Pattern;
  repeat
    B := NextPattern(S, N);
    O := CompareCBMEntry(N, Name, Attr, Partial);
  until O or (B = 0);
  ListCompareCBMEntry := O;
end;

{Check if the specified DOS directory entry matches any pattern in the
  pattern list
  Input : Pattern: the pattern list to match with
          Name: the name of the file
          Long: when True, the file name is handled as a whole instead of
                being split into name and extension
          Partial: when True, the file name is accepted even if there are
                   extra characters at the end after the part matching the
                   pattern
  Output: when True, the name matches the pattern}
function ListCompareDOSEntry(const Pattern: string; Name: string; Long, Partial: Boolean): Boolean;
var
  O             : Boolean;
  B             : Word;
  N,
  S             : string;
begin
  S := Pattern;
  repeat
    B := NextPattern(S, N);
    O := CompareDOSEntry(N, Name, Long, Partial);
  until O or (B = 0);
  ListCompareDOSEntry := O;
end;

{Determine the type of disk image (drive type, number of tracks, with or
  without error info) on basis of the file size
  Input : L: the size of the disk image
  Output: the type of the disk image}
function GetDiskType(L: Longint): Byte;
var
  B,
  E             : Byte;
  W,
  X             : Word;
begin
  B := dtInvalid;
  if L < $100000 then
  begin
    E := 0;
    X := L mod 257;
    if X = 0 then
    begin
      E := dtErrorInfo;
      W := L div 257;
    end
    else
    begin
      X := L and $000000FF;
      W := L shr 8;
    end;
    if X = 0 then
    begin
      case W of
        683: B := dt1541;
        768: B := dt1541Ext;
        1366: B := dt1571;
        3200: B := dt1581;
      end;
    end;
    B := B or E;
  end;
  GetDiskType := B;
end;

{Get the extension for a disk image type
  Input : Disk: disk type
  Output: the extension}
function GetDiskExt(Disk: Byte): string;
var
  B             : Byte;
begin
  B := Disk and dtTypeMask;
  if B = dt1541Ext then B := dt1541;
  if B in [dt1541..dt1581] then GetDiskExt := DiskExt[B] else GetDiskExt := '';
end;

{Determine if an extension belongs to a disk image
  Input : Ext: the extension
  Output: when True, the extension is that of a disk image}
function IsDiskExt(const Ext: string): Boolean;
var
  B             : Byte;
  S             : string;
begin
  B := 0;
  S := LowerCase(Ext);
  while (B < DiskTypeNum) and (DiskExt[B] <> S) do Inc(B);
  IsDiskExt := (B < DiskTypeNum);
end;

{Fill up a 256 byte buffer with the format pattern
  Input : Buffer: the buffer to fill up}
procedure FillFormatPattern(Buffer: PBlock);
var
  B             : Byte;
begin
  B := 0;
  if OrigPattern then B := 1;
  FillChar(Buffer^, 256, B);
  if OrigPattern then PBuffer(Buffer)^[0] := $4B;
end;

{Check if a file or path exists or not
  Input : Name: the file to check
          Path: when True, the name specifies a directory
  Output: when True, the files exists}
function FileExists(const Name: string; Path: Boolean): Boolean;
var
  W             : Word;
begin
  W := IOResult;
  if Name = '' then LongGetFAttr(stCurrentDir, W) else LongGetFAttr(Name, W);
  FileExists := ((IOResult = 0) and (Path = (W and Directory > 0)));
end;

{Check if a file is a disk file or a device
  Input : the file record
  Output: when True, the file is a disk file}
function IsDiskFile(const F: ExtFile): Boolean; assembler;
asm
    les di, F;
    mov cl, False;
    mov bx, es:[di].ExtFile.Orig.FileRec.Handle;
    mov ax, $4400;
    int $21;
    test dl, $80;
    jne @1;
    inc cl;
@1: mov al, cl;
end;

{Check if a file name resembles a device
  Input : Name: the file name
  Output: when True, the name is that of a device}
function IsDeviceName(const Name: string): Boolean;
var
  O             : Boolean;
  S             : string;
begin
  if Length(Name) > 8 then
  begin
    O := False;
  end
  else
  begin
    S := UpperCase(Name);
    S[Length(S) + 1] := #0;
    asm
      xor dl, dl;
      push ds;
      mov ah, $52;
      int $21;
      les di, es:[bx][$0022];
      push ss;
      pop ds;
      lea si, S;
      mov cl, [si][0];
      xor ch, ch;
      inc si;
  @2: test byte ptr es:[di][$0005], $80;
      je @1;
      mov bx, di;
      add bx, $000A;
      mov cx, 8;
      cld;
      push si;
  @5: lodsb;
      mov ah, al;
      mov al, es:[bx];
      inc bx;
      cmp al, ' ';
      jne @3;
      xor al, al;
  @3: push ax;
      call UpCase;
      cmp al, ah;
      jne @4;
      or al, al;
      je @7;
      loop @5;
  @7: inc dl;
  @4: pop si;
  @1: les di, es:[di];
      cmp di, -1;
      jne @2;
  @6: pop ds;
      mov O, dl;
    end;
  end;
  IsDeviceName := O;
end;

{Read the current status of the shift keys (Shift, Control and Alt)
  Output: the current shift status}
function ShiftCode: Byte;
var
  B             : Byte;
begin
  B := GetShiftState;
  ShiftCode := 0;
  if B and (kbRightShift + kbLeftShift) > 0 then ShiftCode := skShift;
  if B and kbCtrlShift > 0 then ShiftCode := skControl;
  if B and kbAltShift > 0 then ShiftCode := skAlt;
end;

function IsShiftPressed: Boolean;
begin
  IsShiftPressed := (GetShiftState and (kbRightShift + kbLeftShift) > 0);
end;

{Check if the user wants to stop the current function by pressing Escape,
  F10, Control-Break or Control-C)
  Output: when True, the user pressed one of the keys}
function Escape: Boolean; assembler;
asm
    cmp CtrlAltInsHit, False;
    je @1;
    call EmergencyExit;
@1: mov ah, ReadKeyFunc;
    inc ah;
    int $16;
    mov bl, False;
    je @2;
    or ax, ax;
    je @3;
    cmp ax, kbEsc;
    je @3;
    cmp ax, kbF10;
    je @3;
    cmp ax, kbCtrlC;
    jne @2;
@3: mov ah, ReadKeyFunc;
    int $16;
    mov bl, True;
@2: mov EscPressed, bl;
    mov al, bl;
end;

{Determine if a file name pattern represents all DOS files
  Output: when True, all the files are represented}
function AllDOSFiles(const Name: string): Boolean;
var
  E             : string;
begin
  E := FileExt(Name);
  AllDOSFiles := (((LongFileNames and ((Name = '*') or (Name = stAllFilesDOS))) or
   (not LongFilenames and (Name[1] = '*') and (E[1] = '*'))));
end;

{Return the sector number of the first directory block
  Input : DiskType: disk type
  Output: sector number}
function FirstDirSec(DiskType: Byte): Byte;
begin
  if DiskType and dtTypeMask = dt1581 then FirstDirSec := 3 else FirstDirSec := 1;
end;

{Return the offset of the name in the BAM
  Input : DiskType: disk type
  Output: offset of the name}
function NameOffset(DiskType, ExtBAMMode: Byte): Byte;
begin
  case DiskType and dtTypeMask of
    dt1541, dt1571: NameOffset := DiskName1541Pos;
    dt1541Ext: if ExtBAMMode = xbPrologicDOS then NameOffset := DiskName1541ExtPrologicPos else
      NameOffset := DiskName1541Pos;
    dt1581: NameOffset := DiskName1581Pos;
  end
end;

{Return the first padding byte for sector headers
  Input : DiskType: disk type
  Output: offset of the name}
function FirstHeaderPadding(DiskType, ExtBAMMode: Byte): Byte;
begin
  FirstHeaderPadding := HeaderPadding;
  if (DiskType and dtTypeMask = dt1541Ext) and (ExtBAMMode = xbDolphinDOS) then
    FirstHeaderPadding := HeaderPaddingDolphinExt;
end;

{Return the Commodore disk size in blocks
  Input : Disk: disk type
  Output: disk size}
function CBMDiskSize(Disk: Byte): Longint;
begin
  case Disk and dtTypeMask of
    dt1541: CBMDiskSize := 683;
    dt1541Ext: CBMDiskSize := 768;
    dt1571: CBMDiskSize := 1366;
    dt1581: CBMDiskSize := 3200;
  end;
end;

{Return the maximum number of free blocks
  Input : Disk: disk type
  Output: maximum number of free blocks}
function DiskMaxFree(Disk: Byte): Longint;
begin
  case Disk and dtTypeMask of
    dt1541: DiskMaxFree := 664;
    dt1541Ext: DiskMaxFree := 749;
    dt1571: DiskMaxFree := 1328;
    dt1581: DiskMaxFree := 3160;
  end;
end;

{Determine if the name of a known archive format is the prefix of a string
  Input : Name: the string to search through
  Output: the panel mode}
function DetermineTypePrefix(const Name: string): Byte;
var
  S             : string;
begin
  DetermineTypePrefix := pmDOS;
  S := LowerCase(Copy(Name, 1, LeftPos(':', Name) - 1));
  if (Length(S) = 1) and (S[1] in ['8', '9', '0', '1']) then DetermineTypePrefix := pmExt else
    if S = 'disk' then DetermineTypePrefix := pmDisk else
    if S = 'tape' then DetermineTypePrefix := pmTape else
    if S = 'file' then DetermineTypePrefix := pmFile else
    if S = 'lynx' then DetermineTypePrefix := pmLynx else
    if S = 'arkive' then DetermineTypePrefix := pmArkive else
    if S = 'tar' then DetermineTypePrefix := pmTAR else
    if S = 'lha' then DetermineTypePrefix := pmLHA else
    if S = 'zip' then DetermineTypePrefix := pmZIP else
    if S = 'filezip' then DetermineTypePrefix := pmFileZip else
    if S = 'gcrdisk' then DetermineTypePrefix := pmGCRDisk else
    if S = 'diskzip' then DetermineTypePrefix := pmDiskZip else
    if S = 'sixzip' then DetermineTypePrefix := pmSixZip;
end;

{Determine if a file name belongs to a known archive format
  Input : Name: the file name, without path
  Output: the panel mode}
function DetermineTypeName(const Name: string): Byte;
var
  S             : string;
begin
  DetermineTypeName := pmDOS;
  S := LowerCase(FileExt(Name));
  if (Length(Name) > 2) and (LoCase(Name[1]) in ['a'..'x']) and (Name[2] = '!') then DetermineTypeName := pmFileZip else
    if (Length(Name) > 3) and (LoCase(Name[1]) in ['1'..'6']) and (Name[2] = '!') and (Name[3] = '!') then
      DetermineTypeName := pmSixZip else
    if (Length(Name) > 2) and (LoCase(Name[1]) in ['1'..'5']) and (Name[2] = '!') then DetermineTypeName := pmDiskZip else
    if IsDiskExt(S) then DetermineTypeName := pmDisk else
    if S = DOSExt[pmTape] then DetermineTypeName := pmTape else
    if S = DOSExt[pmLynx] then DetermineTypeName := pmLynx else
    if S = DOSExt[pmArkive] then DetermineTypeName := pmArkive else
    if S = DOSExt[pmTAR] then DetermineTypeName := pmTAR else
    if (S = DOSExt[pmLHA]) or (S = 'lha') or (S = 'sfx') then DetermineTypeName := pmLHA else
    if S = DOSExt[pmZIP] then DetermineTypeName := pmZIP else
    if (S[1] in ['p', 'r', 's', 'u']) and (S[2] in ['0'..'9']) and (S[3] in ['0'..'9']) then DetermineTypeName := pmFile else
    if S = DOSExt[pmGCRDisk] then DetermineTypeName := pmGCRDisk;
end;

{Check whether the user wanted to cancel the data transfer
  Input : Confirm: when True, the user is asked to confirm the cancel
  Output: when True, the user cancelled the data transfer}
function CancelTransfer(Confirm: Boolean): Boolean;
var
  O             : Boolean;
begin
  O := Escape;
  if O and Confirm and TransferConfirm then O := (SureConfirm(stEmpty, 'Do you wish to cancel', 'the data transfer?',
    stEmpty, stEmpty, ' '+ColorChar+'R'+ColorChar+'esume ', stEmpty, stEmpty, stEmpty, stEmpty,
    nil, hcOnlyQuit, ayNone, True, DummyByte) = cmCancel);
  CancelTransfer := O;
end;

{Read a block from a filepacked or diskpacked ZipCode archive
  Input : ArcFile: the archive file to read from
          Buffer: the buffer to fill
          FileZip: when True, the ZipCode archive is filepacked; otherwise
                   diskpacked
          Mode: when 0, no data is put into the buffer; when 1, data is
                uncompressed into the buffer; when 2, data is copied in its
                original, unmodified form into the buffer
          T, S: for diskpacked ZipCode archives, the variables to put the
                track and sector number into; for filepacked ZipCode archives,
                the variables to put the track and sector link into
          Len: the variable to put the number of bytes read into
  Output: when False, the archive ended or an error occured}
function ReadZipCodeBlock(var ArcFile: ExtFile; Buffer: PBlock; FileZip: Boolean; Mode: Byte; var T, S: Byte;
  var Len: Word): Boolean;
var
  O             : Boolean;
  B,
  C,
  D,
  R             : Byte;
  I,
  J             : Word;

procedure PutByte(X: Byte);
begin
  if Mode <> zrNone then
  begin
    Buffer^[I] := X;
    Inc(I);
  end;
end;

begin
  O := False;
  I := 0;
  J := 256;
  if FileZip then J := 254;
  if ReadArcByte(ArcFile, B) then
  begin
    if Mode = zrOriginal then PutByte(B);
    D := B and zcFlagMask;
    B := B and zcTrackMask;
    if ReadArcByte(ArcFile, C) then
    begin
      if Mode = zrOriginal then PutByte(C);
      T := B;
      S := C;
      case D of
        zcStored:
        begin
          O := True;
          while O and (J > 0) do
          begin
            O := ReadArcByte(ArcFile, D);
            PutByte(D);
            Dec(J);
          end;
        end;
        zcHomogeneous:
        begin
          O := ReadArcByte(ArcFile, D);
          if O then
          begin
            if Mode = zrUncompress then
            begin
              while J > 0 do
              begin
                PutByte(D);
                Dec(J);
              end;
            end
            else
            begin
              PutByte(D);
            end;
          end;
        end;
        zcPacked:
        begin
          O := ReadArcByte(ArcFile, C) and ReadArcByte(ArcFile, R);
          if O then
          begin
            if Mode = zrUncompress then
            begin
              while O and (C > 0) and (J > 0) do
              begin
                O := ReadArcByte(ArcFile, D);
                if O then
                begin
                  Dec(C);
                  if D = R then
                  begin
                    O := ReadArcByte(ArcFile, B) and ReadArcByte(ArcFile, D);
                    while O and (B > 0) and (J > 0) do
                    begin
                      PutByte(D);
                      Dec(B);
                      Dec(J);
                    end;
                    Dec(C, 2);
                  end
                  else
                  begin
                    PutByte(D);
                  end;
                end;
              end;
            end
            else
            begin
              PutByte(C);
              PutByte(B);
              while O and (C > 0) do
              begin
                O := ReadArcByte(ArcFile, D);
                PutByte(D);
                Dec(C);
              end;
            end;
          end;
        end;
      end;
    end;
  end;
  if FileZip and (T = 0) and (Mode <> zrOriginal) then Len := S - 1 else Len := I;
  O := O and (J >= 0);
  ReadZipCodeBlock := O;
end;

{Write a block into a filepacked or diskpacked ZipCode archive
  Input : ArcFile: the archive file to write into
          Buffer: the buffer to write
          FileZip: when True, the ZipCode archive is filepacked; otherwise
                   diskpacked
          T, S: for diskpacked ZipCode archives, the track and sector number;
                for filepacked ZipCode archives, the track and sector link}
procedure WriteZipCodeBlock(var ArcFile: ExtFile; Buffer: PBlock; FileZip: Boolean; T, S: Byte);
var
  D,
  E,
  R,
  X             : Byte;
  I,
  J,
  K,
  L,
  M             : Word;
  C             : array [$00..$FF] of Word;
  B             : TBuffer absolute C;

function GetByte: Byte;
begin
  GetByte := Buffer^[K];
  Inc(K);
end;

procedure PutByte(X: Byte);
begin
  B[I] := X;
  Inc(I);
end;

begin
  I := 2;
  J := 256;
  if FileZip then J := 254;
  L := J + 2;
  FillWord(C, 256, 0);
  for K := 0 to J - 1 do
  begin
    R := Buffer^[K];
    Inc(C[R]);
  end;
  if C[R] = J then
  begin
    X := zcHomogeneous;
    PutByte(R);
  end
  else
  begin
    X := zcPacked;
    M := MaxWord;
    for D := 0 to J - 1 do
    begin
      if C[D] < M then
      begin
        R := D;
        M := C[D];
      end;
    end;
    Inc(I);
    PutByte(R);
    K := 0;
    while (K < J) and (I < L) do
    begin
      D := GetByte;
      M := 1;
      E := D;
      while (K < J) and (E = D) do
      begin
        E := GetByte;
        if E = D then Inc(M) else Dec(K);
      end;
      if (M > 3) or (D = R) then
      begin
        PutByte(R);
        PutByte(M);
        PutByte(D);
      end
      else
      begin
        while M > 0 do
        begin
          PutByte(D);
          Dec(M);
        end;
      end;
    end;
    if I >= L then
    begin
      X := zcStored;
      I := 2;
      for D := 0 to J - 1 do PutByte(Buffer^[D]);
    end
    else
    begin
      J := I;
      I := 2;
      PutByte(J - 4);
      I := J;
    end;
  end;
  J := I;
  I := 0;
  PutByte(T or X);
  PutByte(S);
  ExtBlockWrite(ArcFile, B, J);
end;

{Seek to a given block in a filepacked ZipCode archive
  Input : ArcFile: the archive file to seek in
          Pos: position into archive in blocks
  Output: when not 0, an error occured}
function SeekToFileZipBlock(var ArcFile: ExtFile; Pos: Word): Integer;
var
  O             : Boolean;
  I             : Integer;
  W             : Word;
begin
  I := 255;
  O := True;
  while O and (Pos > 0) do
  begin
    O := ReadZipCodeBlock(ArcFile, nil, True, zrNone, DummyByte, DummyByte, W);
    Dec(Pos);
  end;
  if O then I := 0;
  SeekToFileZipBlock := I;
end;

{Switch the 1570/1571 drive into native 1570/1571 mode or 1541 emulation mode
  Input : Native: when True, the drive is switched in native mode}
procedure ChangeDriveMode(Native: Boolean);
begin
  OpenCBMChannel(saCommand, 'U0' + Chr(Ord('>') or $80) + 'M' + Chr(Ord('0') or Byte(Native)), True);
end;

{Send the soft interleave and number of retries to the Commodore drive}
procedure SendConfigData;
var
  B             : Byte;
  S             : string[2];
begin
  B := RetryNum;
  if not RetryHalftracks then B := B or $40;
  if not RetryBumpsHead then B := B or $80;
  S := Chr(DriveInts[0]);
  if ExtDriveType = dt1541 then
  begin
    if (RetryNum > 0) then S := S + Chr(B);
    OpenCBMChannel(saCommand, 'M-W' + #$69 + #$00 + Chr(Length(S)) + S, True);
  end
  else
  begin
    if (RetryNum > 0) then OpenCBMChannel(saCommand, 'U0>R' + Chr(B), True);
    OpenCBMChannel(saCommand, 'U0>S' + S, True);
  end;
  if ExternalDrive = xd157xEmu then
  begin
    if TransferInited then
    begin
      ChangeDriveMode(False);
      TransferInited := False;
    end;
  end
  else
  begin
    if ExtDriveType = dt1571 then ChangeDriveMode(True);
  end;
  if ExtDriveType = dt1581 then OpenCBMChannel(saCommand, 'U0>V' + Chr(Ord('1') - Byte(VerifyWrite)), True);
  if (ExtDriveType <> dt1581) and (HeadSpeed > 0) then
    OpenCBMChannel(saCommand, 'M-W' + #$07 + #$1C + #1 + Chr(HeadSpeed), True);
end;

{Create country-dependently formatted date string
  Input : Year, Month, Day: year, month and day
          FirstLen: length of first item of date string
          Century: when True, the year is included with four digits; otherwise
                   two digits only
  Output: formatted date string}
function CreateDate(Year, Month, Day: Word; Len: Byte; Century: Boolean): string;
var
  S:            string[4];
begin
  S := LeadingZero(Year, 4);
  if not Century then S := Copy(S, 3, 2);
  case DateFormat of
    1: CreateDate := LeadingSpace(Day, Len) + DateSep + LeadingZero(Month, 2) + DateSep + S;
    2: CreateDate := S + DateSep + LeadingZero(Month, 2) + DateSep + LeadingZero(Day, 2);
  else
    CreateDate := LeadingSpace(Month, Len) + DateSep + LeadingZero(Day, 2) + DateSep + S;
  end;
end;

{Display an error message box on the screen
  Input : Title: the title of the dialog box
          Text1: first line of error message
          Text2: second line of error message (not displayed if empty)
          Help: help context for the dialog box
          Skip: whether to display "Skip" and "Skip all" buttons
  Output: when True, the user pressed OK, otherwise all further
          operations are cancelled}
function ErrorWin(const Title: string; Text1, Text2: string; Help: Word; Skip: Byte): Boolean;
var
  O             : Boolean;
  C,
  H             : Word;
  X,
  Y,
  Z             : Integer;
  D             : PDialog;
  T             : string;
  R             : TRect;
begin
  if (Skip <> sbNone) and (AllErrorSkip in [ayAllYes, ayAllAllYes]) then
  begin
    C := cmOK;
  end
  else
  begin
    H := CurHelpCtx;
    O := HelpCtxSet;
    HelpCtxSet := True;
    CurHelpCtx := Help;
    AppHelpCtx := Help;
    LastShiftState := MaxByte;
    T := Title;
    if T = '' then T := BoxTitle;
    if Text1 = '' then Text1 := 'Unknown error.';
    Text1 := LimitNameLen(Text1, MaxNameLen);
    Text2 := LimitNameLen(Text2, MaxNameLen);
    X := Length(T) + 4;
    if X < CBMStrLen(Text1) then X := CBMStrLen(Text1);
    if X < CBMStrLen(Text2) then X := CBMStrLen(Text2);
    Z := 4;
    if (Skip and sbSkip > 0) then Inc(Z, CStrLen(stSkip) + 1);
    if (Skip and sbSkipAll > 0) then Inc(Z, CStrLen(stSkipAll) + 1);
    if X < Z then X := Z;
    MakeWinBounds(R, X + 2, 3);
    Z := (X - Z + 1) shr 1 + 5;
    Inc(R.A.Y, ErrorDown);
    GetClock(True);
    GetMouse(True);
    D := New(PDialog, Init(R, T, fxNormal, fyNormal, False));
    R.Assign((X - CBMStrLen(Text1) + Justify) shr 1 + 5, 2, CBMStrLen(Text1), 1);
    D^.Insert(New(PCBMText, Init(R, Text1)));
    R.Assign((X - CBMStrLen(Text2) + Justify) shr 1 + 5, 3, CBMStrLen(Text2), 1);
    D^.Insert(New(PCBMText, Init(R, Text2)));
    Y := Z + 5;
    if (Skip and sbSkip <> 0) then
    begin
      R.Assign(Y, 4, 6, 1);
      D^.Insert(New(PButton, Init(R, stSkip, cmNo)));
      Inc(Y, CStrLen(stSkip));
    end;
    if (Skip and sbSkipAll <> 0) then
    begin
      R.Assign(Y, 4, 10, 1);
      D^.Insert(New(PButton, Init(R, stSkipAll, cmYes)));
    end;
    R.Assign(Z, 4, 4, 1);
    D^.Insert(New(PButton, Init(R, stOK, cmOK)));
    D^.Palette := wpError;
    if MakeSound then GoSound := True;
    MakeSound := True;
    C := Application^.ExecView(D, True, True);
    Dispose(D, Done);
    case C of
      cmNo:
      begin
        AllErrorSkip := ayAllYes;
        C := cmOK;
      end;
      cmYes:
      begin
        AllErrorSkip := ayAllAllYes;
        C := cmOK;
      end;
    end;
    SetMouse;
    SetClock;
    CurHelpCtx := H;
    AppHelpCtx := H;
    HelpCtxSet := O;
    LastShiftState := MaxByte;
  end;
  ErrorWin := (C = cmOK);
end;

{Display a critical error message box on the screen
  Input : ErrorCode: critical error code
          Drive: the drive that caused the error
          Device: pointer to the header of the device having caused the error
          IgnoreOK: when True, the user may also ignore the critical error
  Output: tells DOS what to do: 0 for ignore, 1 for retry and 3 for fail}
function SysErrorWin(ErrorCode: Integer; Drive: Byte; Device: Pointer; IgnoreOK: Boolean): Byte;
var
  B             : Byte;
  X,
  Y,
  Z             : Integer;
  D             : PDialog;
  S             : string[30];
  T             : string[50];
  R             : TRect;
begin
  if SysErrorOccurred or (FailSysErrors = fsAll) or
    ((FailSysErrors = fsDiskChange) and (ErrorCode <> 23)) then
  begin
    B := seFail;
  end
  else
  begin
    ChangeHelpCtx(hcOnlyQuit);
    SysError := True;
    GetMouse(True);
    GoSound := True;
    if ErrorCode = 23 then
    begin
      MakeWinBounds(R, 30, 2);
      Inc(R.A.Y, ErrorDown);
      D := New(PDialog, Init(R, 'Change drive', fxNormal, fyNormal, False));
      R.Assign(5, 2, 28, 1);
      D^.Insert(New(PStaticText, Init(R, 'Insert diskette for drive ' + Chr(Drive + 65) + ':')));
      R.Assign(18, 3, 8, 1);
      D^.Insert(New(PButton, Init(R, stCancel, cmCancel)));
      R.Assign(13, 3, 4, 1);
      D^.Insert(New(PButton, Init(R, stOK, cmOK)));
    end
    else
    begin
      if ErrorCode > 23 then ErrorCode := 21;
      if Drive = MaxByte then
      begin
        S[0] := #8;
        Move(PBlock(Device)^[10], S[1], Length(S));
        S := CutChar(S, ' ');
        S := 'device ' + S + ':';
      end
      else
      begin
        S := 'drive ' + Chr(Drive + Ord('A'));
      end;
      S := 'Error on ' + S;
      T := PString(Ptr(DSeg, ErrorString[ErrorCode]))^ + '.';
      Y := CBMStrLen(S);
      if Y < CBMStrLen(T) then Y := CBMStrLen(T);
      X := Y;
      if X < 16 then X := 16;
      if IgnoreOK then if X < 24 then X := 24;
      MakeWinBounds(R, X + 2, 3);
      Inc(R.A.Y, ErrorDown);
      D := New(PDialog, Init(R, stError, fxNormal, fyNormal, False));
      R.Assign((X - Length(S) + Justify) shr 1 + 5, 2, Length(S), 1);
      D^.Insert(New(PStaticText, Init(R, S)));
      R.Assign((X - Length(T) + Justify) shr 1 + 5, 3, Length(T), 1);
      D^.Insert(New(PStaticText, Init(R, T)));
      Z := 0;
      if IgnoreOK then
      begin
        Dec(X, 9);
        R.Assign((X + 12) shr 1, 4, 8, 1);
        D^.Insert(New(PButton, Init(R, ' '+ColorChar+'I'+ColorChar+'gnore ', cmNo)));
        Z := 18;
      end;
      R.Assign((X + Z + 12) shr 1, 4, 7, 1);
      D^.Insert(New(PButton, Init(R, stAbort, cmCancel)));
      R.Assign((X - 4) shr 1, 4, 7, 1);
      D^.Insert(New(PButton, Init(R, stRetry, cmOK)));
    end;
    D^.HelpCtx := hcOnlyQuit;
    D^.Palette := wpError;
    case Application^.ExecView(D, True, True) of
      cmOK: B := crRetry;
      cmCancel: B := crAbort;
      cmNo: B := crIgnore;
    end;
    Dispose(D, Done);
    SetMouse;
    SysError := False;
    RestoreHelpCtx;
  end;
  if (B <> seRetry) then SysErrorOccurred := True;
  SysErrorWin := B;
end;

{Display a confirmation dialog box on the screen
  Input : Title: the title of the dialog box
          Text1: first line of information
          Text2: second line of information (not displayed if empty)
          Button: the title of the OK button
          Skip: the title of the skip button (not displayed if empty)
          All: when not empty, the user is allowed to execute all further
               operations without confirmation
          Options: additional options or texts to display
          Help: help context for the dialog box
          Disp: when True, the dialog box is disposed of after its
                execution
          AllYes: the byte to hold 'all yes' and 'all no' answers
  Output: when cmOK, the user confirms to execute the operation; when
          cmCancel, the user cancelled the operation}
function Confirm(const Title: string; Text1, Text2, Button, Skip, All: string; Options: PView; Help: Word; Disp: Boolean;
  var AllYes: Byte): Word;
var
  B,
  O             : Boolean;
  C,
  H             : Word;
  V,
  W,
  X,
  Y,
  Z             : Integer;
  T             : string;
  R             : TRect;
begin
  H := AppHelpCtx;
  O := HelpCtxSet;
  HelpCtxSet := True;
  CurHelpCtx := Help;
  AppHelpCtx := Help;
  LastShiftState := MaxByte;
  T := Title;
  if T = '' then T := BoxTitle;
  if (All <> '') and (AllYes <> ayNone) then
  begin
    Confirm := cmCancel;
    if not Escape and (AllYes = ayAllYes) then Confirm := cmOK;
  end
  else
  begin
    B := True;
    Text1 := LimitNameLen(Text1, MaxNameLen);
    Text2 := LimitNameLen(Text2, MaxNameLen);
    X := Length(T) + 4;
    if X < CStrLen(Text1) then X := CStrLen(Text1);
    if X < CBMStrLen(Text2) then X := CBMStrLen(Text2);
    if (Options <> nil) and (X < Options^.Size.X) then X := Options^.Size.X;
    W := CStrLen(Button);
    Z := 9;
    if Skip <> '' then Inc(Z, CStrLen(Skip));
    if All <> '' then Inc(Z, CStrLen(All));
    Z := Z + W;
    if X < Z then X := Z;
    if Text2 = '' then Y := 2 else Y := 3;
    if Options <> nil then Inc(Y, Options^.Size.Y + 2);
    MakeWinBounds(R, X + 2, Y);
    V := Y + 1;
    Z := X - W - 8;
    Y := 0;
    if Skip <> '' then Y := CStrLen(Skip) + 1;
    if All <> '' then Inc(Y, CStrLen(All) + 1);
    Dec(Z, Y);
    Z := Z shr 1 + 5;
    Inc(R.A.Y, ErrorDown);
    GetClock(True);
    GetMouse(True);
    TempDialog := New(PDialog, Init(R, T, fxNormal, fyNormal, False));
    R.Assign((X - CBMStrLen(Text1) + Justify) shr 1 + 5, 2, CBMStrLen(Text1), 1);
    TempDialog^.Insert(New(PCBMText, Init(R, Text1)));
    if Text2 <> '' then
    begin
      R.Assign((X - CBMStrLen(Text2) + Justify) shr 1 + 5, 3, CBMStrLen(Text2), 1);
      TempDialog^.Insert(New(PCBMText, Init(R, Text2)));
    end;
    if Options <> nil then
    begin
      R.Assign(3, V - Options^.Size.Y - 2, X + 4, 1);
      TempDialog^.Insert(New(PSeparator, Init(R)));
      Options^.Origin.Y := R.A.Y + 1;
      if Options^.ViewType = vtNone then
      begin
        Options^.Origin.X := 5 + (X - Options^.Size.X) shr 1;
      end
      else
      begin
        Options^.Origin.X := 5;
        Options^.Size.X := X;
      end;
      case Options^.ViewType of
        vtCluster: Options^.SetData(GetCheckData);
        vtInputLine: Options^.SetData(UserTitle);
      end;
      TempDialog^.Insert(Options);
      R.Assign(3, V - 1, X + 4, 1);
      TempDialog^.Insert(New(PSeparator, Init(R)));
    end;
    Y := Z + W + 1;
    if Skip <> '' then
    begin
      R.Assign(Y, V, CStrLen(Skip), 1);
      TempDialog^.Insert(New(PButton, Init(R, Skip, cmSkip)));
      Inc(Y, CStrLen(Skip) + 1);
    end;
    if All <> '' then
    begin
      R.Assign(Y, V, CStrLen(All), 1);
      TempDialog^.Insert(New(PButton, Init(R, All, cmYes)));
      Inc(Y, CStrLen(All) + 1);
    end;
    R.Assign(Y, V, 8, 1);
    TempDialog^.Insert(New(PButton, Init(R, stCancel, cmCancel)));
    R.Assign(Z, V, W, 1);
    TempDialog^.Insert(New(PButton, Init(R, Button, cmOK)));
    if (Options <> nil) and (Options^.ViewType <> vtNone) then Options^.Select;
    Application^.Insert(TempDialog);
    C := Application^.ExecView(TempDialog, True, True);
    if (Options <> nil) and (C = cmOK) then
    begin
      case Options^.ViewType of
        vtCluster: Options^.GetData(GetCheckData);
        vtInputLine: Options^.GetData(UserTitle);
      end;
    end;
    if Disp then
    begin
      Dispose(TempDialog, Done);
      TempDialog := nil;
    end;
    if (All <> '') and (C = cmYes) then
    begin
      AllYes := ayAllYes;
      C := cmOK;
    end;
    Confirm := C;
    SetMouse;
    SetClock;
  end;
  CurHelpCtx := H;
  AppHelpCtx := H;
  HelpCtxSet := O;
  LastShiftState := MaxByte;
end;

{Display a secondary confirmation dialog box on the screen
  Input : Title: the title of the dialog box
          Text1: first line of information
          Text2: second line of information (not displayed if empty)
          Text3: third line of information (not displayed if empty)
          Text4: fourth line of information (not displayed if empty)
          Button: the title of the OK button
          Extra: the title of the extra button (not displayed if empty)
          Skip: the title of the skip button (not displayed if empty)
          Cancel: the title of the cancel button; if empty then defaults
                  to 'Cancel'
          Options: additional options or texts to display
          Help: help context for the dialog box
          All: when not 0, the user is allowed to execute all further
               operations without confirmation
          UpName: when True, the first line may contain a CBM file name,
                  otherwise the second line
          AllYes: the byte to hold 'all yes' and 'all no' answers
  Output: when cmOK, the user confirms to execute the operation; when
          cmCancel, the user cancelled the operation; when cmSkip, the
          user cancelled the operation for this instance only}
function SureConfirm(const Title: string; Text1, Text2, Text3, Text4, Button, Extra, Extra2, Skip, Cancel: string;
  Options: PView; Help: Word; All: Byte; UpName: Boolean; var AllYes: Byte): Word;
var
  B,
  O             : Boolean;
  C,
  H             : Word;
  I,
  J,
  K,
  V,
  W,
  X,
  Y,
  Z             : Integer;
  D             : PDialog;
  S,
  T             : string;
  R             : TRect;
begin
  H := AppHelpCtx;
  O := HelpCtxSet;
  HelpCtxSet := True;
  CurHelpCtx := Help;
  AppHelpCtx := Help;
  LastShiftState := MaxByte;
  T := Title;
  S := Cancel;
  if T = '' then T := BoxTitle;
  if S = '' then S := stCancel;
  if (All <> ayNone) and (AllYes <> ayNone) then
  begin
    if Escape then SureConfirm := cmCancel else
      if AllYes = ayAllNo then SureConfirm := cmSkip else SureConfirm := cmOK;
  end
  else
  begin
    B := True;
    Text1 := LimitNameLen(Text1, MaxNameLen);
    Text2 := LimitNameLen(Text2, MaxNameLen);
    Text3 := LimitNameLen(Text3, MaxNameLen);
    Text4 := LimitNameLen(Text4, MaxNameLen);
    X := Length(Title) + 4;
    if UpName then
    begin
      I := CBMStrLen(Text1);
      J := CStrLen(Text2);
    end
    else
    begin
      I := CStrLen(Text1);
      J := CBMStrLen(Text2);
    end;
    If X < I then X := I;
    If X < J then X := J;
    if X < CStrLen(Text3) then X := CStrLen(Text3);
    if X < CStrLen(Text4) then X := CStrLen(Text4);
    if (Options <> nil) and (X < Options^.Size.X) then X := Options^.Size.X;
    W := CStrLen(Button);
    K := CStrLen(S);
    Z := K;
    if All <> ayNone then Inc(Z, CStrLen(stAll) + 1);
    if Extra <> '' then Inc(Z, CStrLen(Extra) + 1);
    if Extra2 <> '' then Inc(Z, CStrLen(Extra2) + 1);
    if Skip <> '' then Inc(Z, CStrLen(Skip) + 1);
    if All = ayAllNo then Inc(Z, CStrLen(stSkipAll) + 1);
    Inc(Z, W + 1);
    if X < Z then X := Z;
    if Text2 = '' then Y := 2 else Y := 3;
    if Text3 <> '' then Inc(Y);
    if Text4 <> '' then Inc(Y);
    if Options <> nil then Inc(Y, Options^.Size.Y + 2);
    MakeWinBounds(R, X + 2, Y);
    V := Y + 1;
    Z := X - W - K;
    Y := 0;
    if All <> ayNone then Y := CStrLen(stAll) + 1;
    if Extra <> '' then Inc(Y, CStrLen(Extra) + 1);
    if Extra2 <> '' then Inc(Y, CStrLen(Extra2) + 1);
    if Skip <> '' then Inc(Y, CStrLen(Skip) + 1);
    if All = ayAllNo then Inc(Y, CStrLen(stSkipAll) + 1);
    Dec(Z, Y);
    Z := Z shr 1 + 5;
    Inc(R.A.Y, ErrorDown);
    GetClock(True);
    GetMouse(True);
    D := New(PDialog, Init(R, T, fxNormal, fyNormal, False));
    R.Assign((X - I + Justify) shr 1 + 5, 2, I, 1);
    if UpName then D^.Insert(New(PCBMText, Init(R, Text1))) else D^.Insert(New(PColorText, Init(R, Text1)));
    R.Assign((X - J + Justify) shr 1 + 5, 3, J, 1);
    if UpName then D^.Insert(New(PStaticText, Init(R, Text2))) else D^.Insert(New(PCBMText, Init(R, Text2)));
    if Text3 <> '' then
    begin
      R.Assign((X - CStrLen(Text3) + Justify) shr 1 + 5, 4, CStrLen(Text3), 1);
      D^.Insert(New(PStaticText, Init(R, Text3)));
      if Text4 <> '' then
      begin
        R.Assign((X - CStrLen(Text4) + Justify) shr 1 + 5, 5, CStrLen(Text4), 1);
        D^.Insert(New(PStaticText, Init(R, Text4)));
      end;
    end;
    if Options <> nil then
    begin
      R.Assign(3, V - Options^.Size.Y - 2, X + 4, 1);
      D^.Insert(New(PSeparator, Init(R)));
      Options^.Origin.Y := R.A.Y + 1;
      if Options^.ViewType = vtNone then
      begin
        Options^.Origin.X := 5 + (X - Options^.Size.X) shr 1;
      end
      else
      begin
        Options^.Origin.X := 5;
        Options^.Size.X := X;
      end;
      case Options^.ViewType of
        vtCluster: Options^.SetData(GetCheckData);
        vtInputLine: Options^.SetData(UserTitle);
      end;
      D^.Insert(Options);
      R.Assign(3, V - 1, X + 4, 1);
      D^.Insert(New(PSeparator, Init(R)));
    end;
    I := 1;
    if All <> ayNone then
    begin
      R.Assign(Z + W + I, V, CStrLen(stAll), 1);
      D^.Insert(New(PButton, Init(R, stAll, cmYes)));
      Inc(I, CStrLen(stAll) + 1);
    end;
    if Extra <> '' then
    begin
      R.Assign(Z + W + I, V, CStrLen(Extra), 1);
      D^.Insert(New(PButton, Init(R, Extra, cmExtra)));
      Inc(I, CStrLen(Extra) + 1);
    end;
    if Extra2 <> '' then
    begin
      R.Assign(Z + W + I, V, CStrLen(Extra2), 1);
      D^.Insert(New(PButton, Init(R, Extra2, cmExtra2)));
      Inc(I, CStrLen(Extra2) + 1);
    end;
    if Skip <> '' then
    begin
      R.Assign(Z + W + I, V, CStrLen(Skip), 1);
      D^.Insert(New(PButton, Init(R, Skip, cmSkip)));
      Inc(I, CStrLen(Skip) + 1);
    end;
    if All = ayAllNo then
    begin
      R.Assign(Z + W + I, V, CStrLen(stSkipAll), 1);
      D^.Insert(New(PButton, Init(R, stSkipAll, cmNo)));
      Inc(I, CStrLen(stSkipAll) + 1);
    end;
    R.Assign(Z + W + I, V, K, 1);
    D^.Insert(New(PButton, Init(R, S, cmCancel)));
    R.Assign(Z, V, W, 1);
    D^.Insert(New(PButton, Init(R, Button, cmOK)));
    D^.Palette := wpError;
    if (Options <> nil) and (Options^.ViewType <> vtNone) then Options^.Select;
    C := Application^.ExecView(D, True, True);
    if All <> ayNone then
    begin
      case C of
        cmYes:
        begin
          AllYes := ayAllYes;
          C := cmOK;
        end;
        cmNo:
        begin
          AllYes := ayAllNo;
          C := cmSkip;
        end;
      end;
    end;
    if (Options <> nil) and (C = cmOK) then
    begin
      case Options^.ViewType of
        vtCluster: Options^.GetData(GetCheckData);
        vtInputLine: Options^.GetData(UserTitle);
      end;
    end;
    Dispose(D, Done);
    SureConfirm := C;
    SetMouse;
    SetClock;
  end;
  CurHelpCtx := H;
  AppHelpCtx := H;
  HelpCtxSet := O;
  LastShiftState := MaxByte;
end;

{Convert four bytes into a long integer
  Input : B1, B2, B3, B4: the four bytes of the long integer
  Output: the long integer}
function BytesToLongint(B1, B2, B3, B4: Byte): Longint; assembler;
asm
    mov al, B1;
    mov ah, B2;
    mov dl, B3;
    mov dh, B4;
end;

{Convert a file size in bytes to a file size in blocks
  Input : B: file size in bytes
  Output: file size in blocks}
function ByteToBlock(B: Longint): Longint;
var
  L             : Longint;
begin
  L := B div 254;
  if B mod 254 > 0 then Inc(L);
  ByteToBlock := L;
end;

{Convert a 64-bit file size in bytes to a file size in blocks
  Input : B: variable to contain file size in blocks
          C: file size in bytes}
procedure ByteToBlockLonglongint(var B: Longlongint; const C: Longlongint);
var
  W             : Word;
begin
  W := DivLonglongintByWord(B, C, 254);
  if W > 0 then IncLonglongint(B, 1);
end;

{Read a block from the external CBM drive
  Input : Track, Sector: position of the block to be read
          Buffer: the buffer to contain the block}
procedure ReadExtBlock(Track, Sector: Byte; Buffer: PBlock);
begin
  OpenCBMChannel(saData, '#', True);
  OpenCBMChannel(saCommand, 'U1: ' + LeadingSpace(saData, 0) + ' 0 ' +
    LeadingSpace(Track, 2) + ' ' + LeadingSpace(Sector, 2), True);
  asm
    mov al, saData;
    call Talk;
    les di, Buffer;
    mov si, 256;
@1: call Receive;
    mov es:[di], al;
    inc di;
    dec si;
    jne @1;
    call Untalk;
  end;
  CloseCBMChannel(saData);
end;

{Write a block to the external CBM drive
  Input : Track, Sector: position of the block to be written
          Buffer: the buffer containing the block}
procedure WriteExtBlock(Track, Sector: Byte; Buffer: PBlock);
begin
  OpenCBMChannel(saData, '#', True);
  OpenCBMChannel(saCommand, 'B-P: ' + LeadingSpace(saData, 0) + ' 0', True);
  asm
    mov al, saData;
    call Listen;
    les si, Buffer;
    mov di, 256;
@1: mov al, es:[si];
    call Send;
    inc si;
    dec di;
    jne @1;
    call Unlisten;
  end;
  OpenCBMChannel(saCommand, 'U2: ' + LeadingSpace(saData, 0) + ' 0 ' +
    LeadingSpace(Track, 2) + ' ' + LeadingSpace(Sector, 2), True);
  CloseCBMChannel(saData);
end;

{Read a directory block from the external CBM drive
  Input : Buffer: the buffer to contain the directory block}
procedure ReadDirBlock(Buffer: PBlock); assembler;
asm
    mov al, CopyTransferMode;
    cmp al, tmNormal;
    jne @1;
    les di, Buffer;
    add di, 2;
    mov si, 254;
@2: call Receive;
    mov es:[di], al;
    cmp Status, 0;
    jne @8;
    inc di;
    dec si;
    jne @2;
    jmp @3;
@1: push ax;
    push word ptr CopyPriorityMode;
    call InterruptOff;
    call ParallelInput;
    pop ax;
    cmp al, tmTurbo;
    jne @5;
    les di, Buffer;
    mov si, 256;
@4: call TReceive;
    mov es:[di], al;
    cmp Status, 0;
    jne @8;
    inc di;
    dec si;
    jne @4;
    jmp @8;
@5: cmp al, tmWarp;
    jne @3;
    mov di, Offset(GCRBuffer);
    mov si, 326;
@6: call TReceive;
    mov [di], al;
    cmp Status, 0;
    jne @7;
    inc di;
    dec si;
    jne @6;
    mov si, Offset(GCRBuffer);
    mov di, Offset(TempBuffer[TempBufferSize - 256]);
    push di;
    call GCRDecodeSector;
    pop si;
    cmp GCRError, 0;
    je @7;
    mov Status, 3;
@7: les di, Buffer;
    mov cx, 256;
    cld;
    rep movsb;
@8: call InterruptOn;
@3:
end;

{Read a directory block, using the block read function, from the external
  CBM drive
  Input : Track, Sector: the location of the block
          Buffer: the buffer to contain the directory block
          First: when True, a channel is opened for data transmisssion
          Last: when True, the transmission channel is closed}
procedure ReadSpecDirBlock(Track, Sector: Byte; Buffer: PBlock; First, Last: Boolean);
begin
  if First then OpenCBMChannel(saData, '#', False);
  OpenCBMChannel(saCommand, 'U1: ' + LeadingSpace(saData, 0) + ' 0 ' +
    LeadingSpace(Track, 0) + ' ' + LeadingSpace(Sector, 0), False);
  asm
    mov al, saData;
    call Talk;
    les di, Buffer;
    mov si, 254;
@1: call Receive;
    mov es:[di], al;
    inc di;
    dec si;
    jne @1;
    call Untalk;
  end;
  if Last then CloseCBMChannel(saData);
end;

{Copy a buffer of data from an input file into an output file
  Input : FromFile: the file to copy the data from
          ToFile: the file to copy the data to
          Len: the length of data to copy
          BlockSize: block size}
procedure CopyPart(var FromFile, ToFile: ExtFile; Len: Longint; BlockSize: Word);
var
  N             : Longint;
  P             : PBuffer;
begin
  if Len > 0 then
  begin
    GetMem(P, BlockSize);
    while Len > 0 do
    begin
      if Len > BlockSize then N := BlockSize else N := Len;
      Dec(Len, N);
      ExtBlockRead(FromFile, P^, N);
      ExtBlockWrite(ToFile, P^, N);
    end;
    FreeMem(P, BlockSIze);
  end;
end;

{Allocate memory for a history or menu item
  Input : AHotStr: hotkey for the item
          ATitle: title for the item
          ACode: return code for the item
          Menu: when True, a menu item is to be created; otherwise a history
                item
  Output: the new history or menu item}
function NewHistoryItem(const AHotStr, ATitle: string; ACode: Byte; Menu: Boolean; PrevItem: PHistoryItem): PHistoryItem;
var
  O             : Boolean;
  B             : Byte;
  I             : Integer;
  P             : PHistoryItem;
  S             : string[4];
begin
  P := New(PHistoryItem);
  P^.HotCode := kbNoKey;
  O := True;
  S := '';
  if Menu then
  begin
    S := AHotStr;
    while S[Length(S)] in WhiteSpace do Dec(S[0]);
    if Length(S) <= 1 then
    begin
      if Length(S) > 0 then P^.HotCode := Ord(UpCase(S[1]));
    end
    else
    begin
      O := False;
      if S[1] = 'F' then
      begin
        Val(Copy(S, 2, MaxStrLen), B, I);
        O := (B in [1..10]);
        P^.HotCode := kbF1 + (B - 1) shl 8;
      end;
    end;
  end
  else
  begin
    if Length(ATitle) > 0 then P^.HotCode := Ord(UpCase(ATitle[1]));
  end;
  if O then
  begin
    P^.HotStr := S;
    P^.Title := ATitle;
  end
  else
  begin
    P^.HotStr := '';
    P^.Title := S + ':' + ATitle;
  end;
  P^.Code := ACode;
  P^.Next := nil;
  if PrevItem <> nil then PrevItem^.Next := P;
  NewHistoryItem := P;
end;

{Create an empty item in the function key bar
  Input : Next: the next item
  Output: the new item}
function NewEmptyKey(Next: PStatusItem): PStatusItem;
begin
  NewEmptyKey := NewStatusKey(stEmpty, kbNoKey, cmNone, Next);
end;

{Reset automatic replies so that the user is always asked for confirmation}
procedure ResetAutoReplies;
begin
  AllDelete := ayNone;
  AllDeleteReadonly := ayNone;
  AllDeleteDir := ayNone;
  AllOverwrite := ayNone;
  AllOverwriteReadonly := ayNone;
end;

{Save automatic replie settings into the shell buffer}
procedure SaveAutoReplies;
begin
  ShellBuffer^.AllDelete := AllDelete;
  ShellBuffer^.AllDeleteReadonly := AllDeleteReadonly;
  ShellBuffer^.AllDeleteDir := AllDeleteDir;
  ShellBuffer^.AllOverwrite := AllOverwrite;
  ShellBuffer^.AllOverwriteReadOnly := AllOverwriteReadOnly;
end;

{Initialize the clock
  Input : Bounds: bounds of the clock}
constructor TClock.Init(Bounds: TRect);
begin
  TView.Init(Bounds);
  Hide;
end;

{Draw the clock}
procedure TClock.Draw;
var
  H,
  M,
  S,
  S100th        : Word;
  T             : string[10];
  B             : TDrawBuffer;
begin
  GetTime(H, M, S, S100th);
  S100th := S100th div 50;
  if S100th <> LastHalfSec then
  begin
    MakeAMPM(H, TimeStr, False);
    if S100th = 0 then T := ' ' else T := TimeSep;
    TimeStr := LeadingSpace(H, 2) + T + LeadingZero(M, 2) + TimeStr;
    MoveStr(B, TimeStr, GetColor(1));
    WriteBuf(0, 0, Size.X, 1, B);
    LastHalfSec := S100th;
  end;
end;

{Hide the clock}
procedure TClock.Hide;
begin
  ClockVis := False;
  LastHalfSec := 2;
  SetState(sfVisible, False);
end;

{Show the clock}
procedure TClock.Show;
begin
  ClockVis := True;
  LastHalfSec := 2;
  if ShowClock then SetState(sfVisible, True);
  DrawView;
end;

{Get the palette of the clock
  Output: string containing the palette}
function TClock.GetPalette: PPalette;
const
  P: string[Length(CClock)] = CClock;
begin
  GetPalette := @P;
end;

{Draw the CBM file name}
procedure TCBMText.Draw;
var
  B: TDrawBuffer;
begin
  MoveChar(B, ' ', GetColor(1), Size.X);
  if Text <> nil then MoveCBMStr(@B, Text^, GetColor($0201), False);
  WriteBuf(0, 0, Size.X, 1, B);
end;

constructor TCBMTextList.Init(Bounds: TRect; AStrings: PSItem);
var
  I             : Integer;
  P             : PSItem;
begin
  TCBMText.Init(Bounds, stEmpty);
  P := AStrings;
  while P <> nil do
  begin
    Inc(I);
    P := P^.Next;
  end;
  Strings.Init(I);
  while AStrings <> nil do
  begin
    P := AStrings;
    Strings.Insert(AStrings^.Value);
    AStrings := AStrings^.Next;
    Dispose(P);
  end;
end;

destructor TCBMTextList.Done;
begin
  Strings.Done;
  inherited Done;
end;

procedure TCBMTextList.Draw;
var
  I             : Integer;
  B             : TDrawBuffer;
begin
  for I := 0 to Size.Y - 1 do
  begin
    MoveChar(B, ' ', GetColor(1), Size.X);
    MoveCBMStr(@B, PString(Strings.At(I))^, GetColor($0201), False);
    WriteBuf(0, I, Size.X, 1, B);
  end;
end;

{Initialize the configuration menu reminder
  Input : Bounds: bounds of the configuration menu reminder}
constructor TConfigText.Init(Bounds: TRect);
begin
  TStaticText.Init(Bounds, stEmpty);
end;

{Draw the configuration menu reminder}
procedure TConfigText.Draw;
var
  B: TDrawBuffer;
begin
  MoveChar(B, ' ', GetColor(1), Size.X);
  MoveCStr(B[(Size.X - 46) shr 1], 'Press '+ColorChar+' Space '+ColorChar+' to change an option, '+
    ColorChar+' ' + ArrowChars[4] + ' '+ColorChar+' and '+ColorChar+' ' + ArrowChars[3] + ' '+ColorChar,
    GetColor($0201));
  WriteBuf(0, 0, Size.X, 1, B);
  MoveChar(B, ' ', GetColor(1), Size.X);
  MoveCStr(B[(Size.X - 21) shr 1], 'to move between options', GetColor($0201));
  WriteBuf(0, 1, Size.X, 1, B);
end;

{Get the palette of the configuration menu reminder
  Output: string containing the palette}
function TConfigText.GetPalette: PPalette;
const
  P: string[Length(CConfigText)] = CConfigText;
begin
  GetPalette := @P;
end;

{Initialize the configuration menu item frame}
constructor TItemFrame.Init(var Bounds: TRect; const AText: string);
begin
  inherited Init(Bounds, AText);
  ViewType := vtItemFrame;
end;

{Draw the configuration menu item frame}
procedure TItemFrame.Draw;
var
  A             : Byte;
  X,
  Y             : Integer;
  B             : TDrawBuffer;
begin
  X := Size.X;
  Y := Size.Y;
  A := GetColor(1);
  MoveChar(B, FrameChars[2], A, X);
  B[0] := Ord(FrameChars[1]) + A shl 8;
  B[X - 1] := Ord(FrameChars[4]) + A shl 8;
  if Text <> nil then MoveStr(B[1], ' ' + Text^ + ' ', GetColor(2));
  WriteBuf(0, 0, X, 1, B);
  MoveChar(B, ' ', A, X);
  B[0] := Ord(FrameChars[5]) + A shl 8;
  B[X - 1] := Ord(FrameChars[5]) + A shl 8;
  WriteLine(0, 1, X, Y - 2, B);
  MoveChar(B, FrameChars[2], A, X);
  B[0] := Ord(FrameChars[13]) + A shl 8;
  B[X - 1] := Ord(FrameChars[16]) + A shl 8;
  WriteBuf(0, Y - 1, X, 1, B);
end;

{Initialize the item separator
  Input : Bounds: bounds of the item separator}
constructor TSeparator.Init(var Bounds: TRect);
begin
  TStaticText.Init(Bounds, stEmpty);
end;

{Draw the item separator}
procedure TSeparator.Draw;
var
  A             : Byte;
  X             : Integer;
  B             : TDrawBuffer;
begin
  X := Size.X;
  A := GetColor(1);
  MoveChar(B, FrameChars[2], A, X);
  B[0] := Ord(DoubleFrameChars[9]) + A shl 8;
  B[X - 1] := Ord(DoubleFrameChars[12]) + A shl 8;
  WriteBuf(0, 0, X, 1, B);
end;

end.
