
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                    CONFIG.PAS                   }
{                                                 }
{          The Star Commander Config unit         }
{*************************************************}

unit CfgMenus;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Views;

const
{Arrows for the country-specific uppercase/lowercase chart}
  CharTableArrows : array [0..15, 0..2] of Char =
                    ('   ', '   ',
                     '', '   ',
                     '  ', 'Ŀ',
                     '  ', '  ',
                     '  ', '  ',
                     '', '  ',
                     '  ', 'Ĵ',
                     '', '');

type
  PSetupItem    = ^TSetupItem;
  TSetupItem    = object
    Title       : string;
    HotCode,
    HelpCtx,
    Command     : Word;
    Next        : PSetupItem;
  end;
  TMenuProc     = function: Word;
  PMenuProc     = ^TMenuProc;

procedure SetSetupItem(C: Byte);
function CfgConfig: Word;
function CfgOther: Word;
function CfgImage: Word;
function CfgTransfer: Word;
function CfgDrive: Word;
function CfgPalette: Word;
function CfgReset: Word;
function CfgCountry: Word;

implementation

uses
  App, Drivers, Dialogs, Menus, Objects,
{$IFNDEF ExternalSetup}
  MiscFunc,
{$ENDIF}
  Base1, Base2, Colors, Config, Constant, ExtFiles, LowLevel;

{Move the cursor bar of the setup menu to a given item
  Input: the command code of the item to position to}
procedure SetSetupItem(C: Byte);
var
  P             : PSetupItem;
begin
  P := SetupMenu^.Items;
  while (P^.Command <> C) and (P <> nil) do P := P^.Next;
  if P^.Command = C then
  begin
    SetupMenu^.CurItem := P;
    SetupMenu^.DrawView;
  end;
end;

function DisplayDialog(Dialog: PDialog): Word;
begin
  if TempDialog = nil then
  begin
    Application^.Insert(Dialog);
  end
  else
  begin
    Dialog^.Hide;
    Application^.InsertView(Dialog, TempDialog);
    Application^.RemoveView(TempDialog);
    Dialog^.Show;
    Dispose(TempDialog, Done);
  end;
  TempDialog := Dialog;
  DisplayDialog := Application^.ExecView(Dialog, True, False);
end;

{'Configuration' item: set the configuration parameters
  Output: when True, the user accepted the changes}
function CfgConfig: Word;
var
  B             : Byte;
  C,
  W             : Word;
  I             : Integer;
  D             : PDialog;
  I1            : PMenuInput;
  I2,
  I4,
  I5,
  I6            : PCheckBoxes;
  I3            : PNumInput;
  S             : string[3];
  R             : TRect;
begin
  ChangeHelpCtx(hcCfgConfig);
  BoxTitle := 'Configuration';
  MakeWinBounds(R, 62, 17);
  D := New(PDialog, Init(R, BoxTitle, fxNormal, fyNormal, True));
  R.Assign(6, 2, 31, 7);
  D^.Insert(New(PItemFrame, Init(R, 'General options')));
  R.Assign(6, 9, 31, 6);
  D^.Insert(New(PItemFrame, Init(R, 'Hotkeys')));
  R.Assign(39, 2, 25, 6);
  D^.Insert(New(PItemFrame, Init(R, 'Screen and mouse')));
  R.Assign(39, 8, 25, 7);
  D^.Insert(New(PItemFrame, Init(R, 'Control options')));
  R.Assign(8, 3, 27, 1);
  I1 := New(PMenuInput, Init(R, 13, 13, 'Screen colors', drRight, 'Select screen colors',
    apBlackWhite, apLaptop, 1, ScreenColorStr));
  W := ScreenCol;
  I1^.SetData(W);
  D^.Insert(I1);
  R.Assign(8, 4, 27, 3);
  I2 := New(PCheckBoxes, Init(R,
    NewSItem('Menu bar visible',
    NewSItem('Error sound',
    NewSItem('Auto save setup',
  nil)))));
  W := Byte(ShowMenu) or Byte(ErrorSound) shl 1 or
    Byte(AutoSaveSetup) shl 2;
  I2^.SetData(W);
  D^.Insert(I2);
  R.Assign(8, 7, 21, 1);
  I3 := New(PNumInput, Init(R, 3, 2, 'Screen blank', drRight));
  I3^.SetValidator(New(PNumValid, Init(0, MinPerHour, stEmpty, 'screen blank delay', CurHelpCtx)));
  S := LeadingSpace(SaverDelay, 0);
  I3^.SetData(S);
  D^.Insert(I3);
  R.Assign(8, 10, 25, 4);
  I4 := New(PCheckBoxes, Init(R,
    NewSItem('Alternative hotkeys',
    NewSItem('Ins moves down',
    NewSItem('Escape toggles panels',
    NewSItem('Alt tap selects menu',
  nil))))));
  W := Byte(AlternativeHotkeys) or Byte(InsMovesDown) shl 1 or
    Byte(EscTogglesPanels) shl 2 or Byte(AltPopsMenu) shl 3;
  I4^.SetData(W);
  D^.Insert(I4);
  R.Assign(41, 3, 21, 4);
  I5 := New(PCheckBoxes, Init(R,
    NewSItem('Check CGA snow',
    NewSItem('VESA support',
    NewSItem('Left-handed mouse',
    NewSItem('Fast mouse reset',
  nil))))));
  W := Byte(SnowCheck) or Byte(VESASupport) shl 1 or
    Byte(MouseReverse) shl 2 or Byte(FastMouse) shl 3;
  I5^.SetData(W);
  D^.Insert(I5);
  R.Assign(41, 9, 21, 5);
  I6 := New(PCheckBoxes, Init(R,
    NewSItem('Auto menus',
    NewSItem('Path prompt',
    NewSItem('Key bar',
    NewSItem('Full screen',
    NewSItem('Clock',
  nil)))))));
  W := Byte(AutoMenus) or Byte(PathPrompt) shl 1 or
    Byte(ShowKeyBar) shl 2 or Byte(FullScreen) shl 3 or
    Byte(ShowClock) shl 4;
  I6^.SetData(W);
  D^.Insert(I6);
  R.Assign(6, 15, 58, 2);
  D^.Insert(New(PConfigText, Init(R)));
  R.Assign(3, 17, 64, 1);
  D^.Insert(New(PSeparator, Init(R)));
  R.Assign(14, 18, 6, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'O'+ColorChar+'K ]', cmOK)));
  R.Assign(22, 18, 10, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'C'+ColorChar+'ancel ]', cmCancel)));
  R.Assign(34, 18, 8, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'N'+ColorChar+'ext ]', cmYes)));
  R.Assign(44, 18, 12, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'P'+ColorChar+'revious ]', cmNo)));
  I1^.Select;
  D^.Palette := wpConfig;
  C := DisplayDialog(D);
  if C <> cmCancel then
  begin
    B := ScreenCol;
    I1^.GetData(W);
    ScreenCol := W;
    I2^.GetData(W);
    ShowMenu := (W and 1 > 0);
    ErrorSound := (W and 2 > 0);
    AutoSaveSetup := (W and 4 > 0);
    I3^.GetData(S);
    if S <> '' then Val(S, SaverDelay, I);
    I4^.GetData(W);
    AlternativeHotkeys := (W and 1 > 0);
    InsMovesDown := (W and 2 > 0);
    EscTogglesPanels := (W and 4 > 0);
    AltPopsMenu := (W and 8 > 0);
    I5^.GetData(W);
    SnowCheck := (W and 1 > 0);
    VESASupport := (W and 2 > 0);
    MouseReverse := (W and 4 > 0);
    FastMouse := (W and 8 > 0);
    I6^.GetData(W);
    AutoMenus := (W and 1 > 0);
    PathPrompt := (W and 2 > 0);
    ShowKeyBar := (W and 4 > 0);
    FullScreen := (W and 8 > 0);
    ShowClock := (W and 16 > 0);
    CheckSnow := OrigCheckSnow and SnowCheck;
  end;
  SetSetupItem(cmCfgConfig);
  RestoreHelpCtx;
  if FullScreen then OrigPanWinSize := OrigScreenHeight - 2 else
    OrigPanWinSize := OrigHalfPanWinSize;
{$IFNDEF ExternalSetup}
  ChangePanels;
{$ENDIF}
  Application^.InitScreen;
  SetupDialog^.Redraw;
  InitSaver;
  if ShowClock then Clock^.Show else Clock^.Hide;
  if ShowKeyBar then KeyBar^.Show else KeyBar^.Hide;
  CfgConfig := C;
end;

{'Other options': set additional configuration parameters
  Output: when True, the user accepted the changes}
function CfgOther: Word;
var
  C,
  W             : Word;
  D             : PDialog;
  I1,
  I2,
  I3,
  I7            : PCheckBoxes;
  I4            : PInputLine;
  I5,
  I6            : PMenuInput;
  S             : string[16];
  R             : TRect;
begin
  ChangeHelpCtx(hcCfgOther);
  BoxTitle := 'Other options';
  MakeWinBounds(R, 66, 17);
  D := New(PDialog, Init(R, BoxTitle, fxNormal, fyNormal, True));
  R.Assign(6, 2, 28, 6);
  D^.Insert(New(PItemFrame, Init(R, 'File names')));
  R.Assign(6, 8, 28, 7);
  D^.Insert(New(PItemFrame, Init(R, 'Confirmations')));
  R.Assign(36, 2, 32, 8);
  D^.Insert(New(PItemFrame, Init(R, 'File copy')));
  R.Assign(36, 10, 32, 4);
  D^.Insert(New(PItemFrame, Init(R, 'Warnings')));
  R.Assign(8, 3, 24, 4);
  I1 := New(PCheckBoxes, Init(R,
    NewSItem('Long file names',
    NewSItem('Prefer long names',
    NewSItem('Keep lowercase chars',
    NewSItem('DOS sizes in blocks',
  nil))))));
  W := Byte(LongNames) or Byte(PreferLongNames) shl 1 or
     Byte(KeepLowerCase) shl 2 or Byte(DOSSizeBlocks) shl 3;
  I1^.SetData(W);
  D^.Insert(I1);
  R.Assign(8, 9, 24, 5);
  I2 := New(PCheckBoxes, Init(R,
    NewSItem('Convert file name',
    NewSItem('Delete file',
    NewSItem('Quit program',
    NewSItem('Abort data transfer',
    NewSItem('Disk editor',
  nil)))))));
  W := Byte(ConvertConfirm) or Byte(DeleteConfirm) shl 1 or
    Byte(QuitConfirm) shl 2 or Byte(TransferConfirm) shl 3 or
    Byte(DiskEditConfirm) shl 4;
  I2^.SetData(W);
  D^.Insert(I2);
  R.Assign(38, 3, 28, 3);
  I3 := New(PCheckBoxes, Init(R,
    NewSItem('Auto unselect files',
    NewSItem('Keep non-standard ext',
    NewSItem('Cursor follows file name',
  nil)))));
  W := Byte(AutoUnselect) or Byte(KeepNonStandardExt) shl 1 or
    Byte(CursorFollowsFilename) shl 2;
  I3^.SetData(W);
  D^.Insert(I3);
  R.Assign(38, 6, 28, 1);
  I4 := New(PInputLine, Init(R, 8, MaxPrgExtLen, 'Program extension', drRight));
  I4^.SetData(PrgExt);
  D^.Insert(I4);
  R.Assign(38, 7, 28, 1);
  I5 := New(PMenuInput, Init(R, 8, 8, 'Into file images', drRight, 'Select into file image mode',
    ifNever, ifCBMSrc, 1, IntoImageModeStr));
  W := IntoFileImages;
  I5^.SetData(W);
  D^.Insert(I5);
  R.Assign(38, 8, 28, 1);
  I6 := New(PMenuInput, Init(R, 8, 8, 'Extract file images', drRight, 'Select extract file image mode',
    xfNever, xfCBMDest, 1, ExtractImageModeStr));
  W := ExtractFileImages;
  I6^.SetData(W);
  D^.Insert(I6);
  R.Assign(38, 11, 28, 2);
  I7 := New(PCheckBoxes, Init(R,
    NewSItem('Data transfer',
    NewSItem('File sizes',
  nil))));
  W := Byte(TransferWarning) or Byte(FileSizeWarning) shl 1;
  I7^.SetData(W);
  D^.Insert(I7);
  R.Assign(5, 15, 64, 2);
  D^.Insert(New(PConfigText, Init(R)));
  R.Assign(3, 17, 68, 1);
  D^.Insert(New(PSeparator, Init(R)));
  R.Assign(16, 18, 6, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'O'+ColorChar+'K ]', cmOK)));
  R.Assign(24, 18, 10, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'C'+ColorChar+'ancel ]', cmCancel)));
  R.Assign(36, 18, 8, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'N'+ColorChar+'ext ]', cmYes)));
  R.Assign(46, 18, 12, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'P'+ColorChar+'revious ]', cmNo)));
  I1^.Select;
  D^.Palette := wpConfig;
  C := DisplayDialog(D);
  if C <> cmCancel then
  begin
    I1^.GetData(W);
    LongNames := (W and 1 > 0);
    PreferLongNames := (W and 2 > 0);
    KeepLowerCase := (W and 4 > 0);
    DOSSizeBlocks := (W and 8 > 0);
    I2^.GetData(W);
    ConvertConfirm := (W and 1 > 0);
    DeleteConfirm := (W and 2 > 0);
    QuitConfirm := (W and 4 > 0);
    TransferConfirm := (W and 8 > 0);
    DiskEditConfirm := (W and 16 > 0);
    I3^.GetData(W);
    AutoUnselect := (W and 1 > 0);
    KeepNonStandardExt := (W and 2 > 0);
    CursorFollowsFilename := (W and 4 > 0);
    I4^.GetData(PrgExt);
    PrgExt := CutChar(PrgExt, ' ');
    I5^.GetData(W);
    IntoFileImages := W;
    I6^.GetData(W);
    ExtractFileImages := W;
    I7^.GetData(W);
    TransferWarning := (W and 1 > 0);
    FileSizeWarning := (W and 2 > 0);
  end;
  SetSetupItem(cmCfgOther);
  RestoreHelpCtx;
  CfgOther := C;
end;

{'Image options': set image-related configuration parameters
  Output: when True, the user accepted the changes}
function CfgImage: Word;
var
  B             : Byte;
  C,
  W             : Word;
  X,
  Y             : Integer;
  D             : PDialog;
  I1,
  I3,
  I5            : PCheckBoxes;
  I2,
  I4            : PMenuInput;
  S             : string[20];
  R             : TRect;
  I             : array [0..(DiskTypeNum * 2) - 1] of PNumInput;
begin
  ChangeHelpCtx(hcCfgImage);
  BoxTitle := 'Image options';
  MakeWinBounds(R, 62, 17);
  D := New(PDialog, Init(R, BoxTitle, fxNormal, fyNormal, True));
  R.Assign(6, 2, 27, 8);
  D^.Insert(New(PItemFrame, Init(R, 'General options')));
  R.Assign(35, 2, 29, 8);
  D^.Insert(New(PItemFrame, Init(R, 'Copy and delete')));
  R.Assign(6, 10, 58, 5);
  D^.Insert(New(PItemFrame, Init(R, 'Disk image soft interleaves')));
  R.Assign(8, 3, 23, 5);
  I1 := New(PCheckBoxes, Init(R,
    NewSItem('Quality C64 charset',
    NewSItem('Backup image files',
    NewSItem('GEOS support',
    NewSItem('Display start info',
    NewSItem('Show read errors',
  nil)))))));
  W := Byte(EightColFont) or Byte(MakeBackup) shl 1 or
    Byte(GEOSSupport) shl 2 or Byte(StartInfo) shl 3 or
    Byte(ShowReadErrors) shl 4;
  I1^.SetData(W);
  D^.Insert(I1);
  R.Assign(8, 8, 21, 1);
  I2 := New(PMenuInput, Init(R, 12, 12, 'DOS type', drRight, 'Select DOS type',
    xbSpeedDOS, xbPrologicDOS, 1, DOSTypeStr));
  W := ImageExtBAMMode;
  I2^.SetData(W);
  D^.Insert(I2);
  R.Assign(37, 3, 25, 2);
  I3 := New(PCheckBoxes, Init(R,
    NewSItem('Keep date stamps',
    NewSItem('Copy onto dir track',
  nil))));
  W := Byte(KeepTime) or Byte(CopyToDirTrack) shl 1;
  I3^.SetData(W);
  D^.Insert(I3);
  R.Assign(37, 5, 21, 1);
  I4 := New(PMenuInput, Init(R, 7, 7, 'Convert chars', drRight, 'Select char conversion mode',
    ccNone, ccInvalidAndSpace, 1, CharConvModeStr));
  W := ConvInvalidChars;
  I4^.SetData(W);
  D^.Insert(I4);
  R.Assign(37, 6, 25, 3);
  I5 := New(PCheckBoxes, Init(R,
    NewSItem('Keep uppercase chars',
    NewSItem('Wipe deleted files',
    NewSItem('Orig format pattern',
  nil)))));
  W := Byte(KeepUppercase) or Byte(WipeFiles) shl 1 or
    Byte(OrigPattern) shl 2;
  I5^.SetData(W);
  D^.Insert(I5);
  for B := 0 to (DiskTypeNum * 2) - 1 do
  begin
    X := 8 + (B mod 2) * 29;
    Y := 11 + (B div 2);
    case B mod 2 of
      0: S := 'normal';
      1: S := 'GEOS';
    end;
    S := DriveTypeStr(B div 2) + ', ' + S + ' files';
    R.Assign(X, Y, 4 + Length(S), 1);
    I[B] := New(PNumInput, Init(R, 3, 2, S, drRight));
    I[B]^.SetValidator(New(PNumValid, Init(1, MaxImageInt, stEmpty, 'interleave', CurHelpCtx)));
    S := LeadingSpace(ImageInts[B], 0);
    I[B]^.SetData(S);
    D^.Insert(I[B]);
  end;
  R.Assign(5, 15, 60, 2);
  D^.Insert(New(PConfigText, Init(R)));
  R.Assign(3, 17, 64, 1);
  D^.Insert(New(PSeparator, Init(R)));
  R.Assign(14, 18, 6, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'O'+ColorChar+'K ]', cmOK)));
  R.Assign(22, 18, 10, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'C'+ColorChar+'ancel ]', cmCancel)));
  R.Assign(34, 18, 8, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'N'+ColorChar+'ext ]', cmYes)));
  R.Assign(44, 18, 12, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'P'+ColorChar+'revious ]', cmNo)));
  I1^.Select;
  D^.Palette := wpConfig;
  C := DisplayDialog(D);
  if C <> cmCancel then
  begin
    I1^.GetData(W);
    EightColFont := (W and 1 > 0);
    MakeBackup := (W and 2 > 0);
    GEOSSupport := (W and 4 > 0);
    StartInfo := (W and 8 > 0);
    ShowReadErrors := (W and 16 > 0);
    I2^.GetData(W);
    ImageExtBAMMode := W;
    I3^.GetData(W);
    KeepTime := (W and 1 > 0);
    CopyToDirTrack := (W and 2 > 0);
    I4^.GetData(W);
    ConvInvalidChars := W;
    I5^.GetData(W);
    KeepUpperCase := (W and 1 > 0);
    WipeFiles := (W and 2 > 0);
    OrigPattern := (W and 4 > 0);
    for B := 0 to (DiskTypeNum * 2) - 1 do
    begin
      I[B]^.GetData(S);
      if S <> '' then Val(S, ImageInts[B], X);
    end;
  end;
  SetSetupItem(cmCfgImage);
  RestoreHelpCtx;
  CfgImage := C;
end;

{'Transfer options': set transfer-related configuration parameters
  Output: when True, the user accepted the changes}
function CfgTransfer: Word;
var
  F             : Boolean;
  B             : Byte;
  C,
  W             : Word;
  D             : PDialog;
  I5,
  I15           : PCheckBoxes;
  I1,
  I2,
  I3,
  I4,
  I8,
  I9,
  I10,
  I11,
  I12,
  I13           : PMenuInput;
  I6,
  I7            : PLPTPortInput;
  I14           : PNumInput;
  P             : PSItem;
  S             : string[4];
  T             : string[10];
  R             : TRect;
  A             : TLPTAddresses;
begin
  ChangeHelpCtx(hcCfgTransfer);
  F := (DetectPortModes = dpNone) or (SerialCable = scOpenCBM);
  A := LPTAddresses;
  BoxTitle := 'Transfer options';
  MakeWinBounds(R, 66, 17);
  D := New(PDialog, Init(R, BoxTitle, fxNormal, fyNormal, True));
  R.Assign(6, 2, 30, 8);
  D^.Insert(New(PItemFrame, Init(R, 'Transfer')));
  R.Assign(6, 10, 30, 5);
  D^.Insert(New(PItemFrame, Init(R, 'Parallel ports')));
  R.Assign(38, 2, 30, 5);
  D^.Insert(New(PItemFrame, Init(R, 'Disk type')));
  R.Assign(38, 7, 30, 8);
  D^.Insert(New(PItemFrame, Init(R, 'Disk copy')));
  R.Assign(8, 3, 23, 1);
  I1 := New(PMenuInput, Init(R, 7, 7, 'Transfer mode', drRight, 'Select transfer mode',
    tmNormal, tmWarp, 1, TransferModeStr));
  W := TransferMode;
  I1^.SetData(W);
  D^.Insert(I1);
  R.Assign(8, 4, 23, 1);
  I2 := New(PMenuInput, Init(R, 7, 7, 'Serial cable', drRight, 'Select serial cable',
    scNone, scOpenCBM, 0, SerialCableStr));
  W := SerialCable;
  I2^.SetData(W);
  D^.Insert(I2);
  R.Assign(8, 5, 23, 1);
  I3 := New(PMenuInput, Init(R, 7, 7, 'Parallel cable', drRight, 'Select parallel cable',
    pcNone, pcParallel, 0, ParallelCableStr));
  W := ParallelCable;
  I3^.SetData(W);
  D^.Insert(I3);
  R.Assign(8, 6, 23, 1);
  I4 := New(PMenuInput, Init(R, 7, 7, 'Async transfer', drRight, 'Select async transfer',
    atNever, atAuto, 0, AsyncTransferStr));
  W := AsyncTransfer;
  I4^.SetData(W);
  D^.Insert(I4);
  R.Assign(8, 7, 25, 1);
  I5 := New(PCheckBoxes, Init(R,
    NewSItem('Manual timeouts',
  nil)));
  W := Byte(ManualTimeouts);
  I5^.SetData(W);
  D^.Insert(I5);
  R.Assign(8, 8, 23, 1);
  DelayValueInp := New(PNumInput, Init(R, 3, 3, 'Delay value', drRight));
  DelayValueInp^.SetValidator(New(PNumValid, Init(0, MaxByte, stEmpty, 'delay value', CurHelpCtx)));
  S := LeadingSpace(DelayValue, 0);
  DelayValueInp^.SetData(S);
  D^.Insert(DelayValueInp);
  R.Assign(8, 11, 24, 1);
  I6 := New(PLPTPortInput, Init(R, 4, 4, 'Serial interface', drRight));
  I6^.SetData(LPTNum);
  D^.Insert(I6);
  R.Assign(8, 12, 24, 1);
  I7 := New(PLPTPortInput, Init(R, 4, 4, 'Parallel interface', drRight));
  I7^.SetData(ParLPTNum);
  D^.Insert(I7);
  R.Assign(8, 13, 26, 1);
  I8 := New(PMenuInput, Init(R, 8, 8, 'Detect port modes', drRight, 'Select port mode detection mode',
    dpNone, dpSafeUsed, 0, DetectPortModeStr));
  W := Byte(DetectPortModes);
  I8^.SetData(W);
  D^.Insert(I8);
  R.Assign(40, 3, 25, 1);
  I9 := New(PMenuInput, Init(R, 10, 10, 'Drive type', drRight, 'Select drive type',
    xd1541, xd157xEmu, 1, DriveTypeStr));
  W := ExternalDrive;
  I9^.SetData(W);
  D^.Insert(I9);
  R.Assign(40, 4, 26, 1);
  I10 := New(PMenuInput, Init(R, 6, 6, 'Extended 1541 disks', drRight, 'Select extended disk mode',
    xtNever, xtDetect, 1, ExtendedDiskModeStr));
  W := ExtendedDiskMode;
  I10^.SetData(W);
  D^.Insert(I10);
  R.Assign(40, 5, 21, 1);
  I11 := New(PMenuInput, Init(R, 12, 12, 'DOS type', drRight, 'Select DOS type',
    xbSpeedDOS, xbPrologicDOS, 1, DOSTypeStr));
  W := DiskExtBAMMode;
  I11^.SetData(W);
  D^.Insert(I11);
  R.Assign(40, 8, 26, 3);
  I12 := New(PMenuInput, Init(R, 8, 8, 'Disk copy mode', drRight, 'Select disk copy mode',
    dcFull, dcManualSelect, 1, DiskCopyModeStr));
  I12^.SetData(DiskCopyMode);
  D^.Insert(I12);
  R.Assign(40, 9, 26, 3);
  I13 := New(PMenuInput, Init(R, 8, 8, 'Invalid GCR error', drRight, 'Select invalid GCR code error',
    igNone, ig24READ, 1, InvalidGCRCodeModeStr));
  I13^.SetData(InvalidGCRCodeMode);
  D^.Insert(I13);
  R.Assign(40, 10, 26, 3);
  I14 := New(PNumInput, Init(R, 3, 3, 'Num of smart retries', drRight));
  I14^.SetValidator(New(PNumValid, Init(0, MaxByte, stEmpty, 'number of smart retries', CurHelpCtx)));
  S := LeadingSpace(SmartRetryNum, 0);
  I14^.SetData(S);
  D^.Insert(I14);
  R.Assign(40, 11, 26, 3);
  I15 := New(PCheckBoxes, Init(R,
    NewSItem('Detect disk changes',
    NewSItem('Endless retry',
    NewSItem('Verify write',
  nil)))));
  W := Byte(DetectDiskChange) or Byte(EndlessRetry) shl 1 or
    Byte(VerifyWrite) shl 2;
  I15^.SetData(W);
  D^.Insert(I15);
  R.Assign(5, 15, 64, 2);
  D^.Insert(New(PConfigText, Init(R)));
  R.Assign(3, 17, 68, 1);
  D^.Insert(New(PSeparator, Init(R)));
  R.Assign(7, 18, 6, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'O'+ColorChar+'K ]', cmOK)));
  R.Assign(15, 18, 10, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'C'+ColorChar+'ancel ]', cmCancel)));
  R.Assign(27, 18, 8, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'N'+ColorChar+'ext ]', cmYes)));
  R.Assign(37, 18, 12, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'P'+ColorChar+'revious ]', cmNo)));
  R.Assign(51, 18, 15, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'R'+ColorChar+'ecalibrate ]', cmRecalibrate)));
  I1^.Select;
  D^.Palette := wpConfig;
  C := DisplayDialog(D);
  if C <> cmCancel then
  begin
    I1^.GetData(W);
    TransferMode := W;
    I2^.GetData(W);
    SerialCable := W;
    I3^.GetData(W);
    ParallelCable := W;
    I4^.GetData(W);
    AsyncTransfer := W;
    I5^.GetData(W);
    ManualTimeouts := (W and 1 > 0);
    DelayValueInp^.GetData(S);
    if S <> '' then Val(S, DelayValue, NumOk);
    I6^.CheckCustomPort;
    I6^.GetData(W);
    LPTNum := W;
    I7^.CheckCustomPort;
    I7^.GetData(W);
    ParLPTNum := W;
    I8^.GetData(W);
    DetectPortModes := W;
    I9^.GetData(W);
    ExternalDrive := W;
    I10^.GetData(W);
    ExtendedDiskMode := W;
    I11^.GetData(W);
    DiskExtBAMMode := W;
    I12^.GetData(W);
    DiskCopyMode := W;
    I13^.GetData(W);
    InvalidGCRCodeMode := W;
    I14^.GetData(S);
    if S <> '' then Val(S, SmartRetryNum, NumOk);
    I15^.GetData(W);
    DetectDiskChange := (W and 1 > 0);
    EndlessRetry := (W and 2 > 0);
    VerifyWrite := (W and 4 > 0);
    WarningStatus := WarningStatus and not wmBadFeature;
    InitTransfer(True);
    if (DetectPortModes <> dpNone) and F then CollectLPTPorts(True);
    CheckLPTPorts(False);
  end
  else
  begin
    LPTAddresses := A;
  end;
  SetSetupItem(cmCfgTransfer);
  RestoreHelpCtx;
  CfgTransfer := C;
end;

{'Drive options': set drive-related configuration parameters
  Output: when True, the user accepted the changes}
function CfgDrive: Word;
var
  F             : Boolean;
  B             : Byte;
  C,
  W             : Word;
  X,
  Y,
  Z             : Integer;
  D             : PDialog;
  I1            : PMenuInput;
  I3,
  I5            : PCheckBoxes;
  I2,
  I4            : PNumInput;
  P             : PSItem;
  S             : string[20];
  R             : TRect;
  I             : array [0..DriveIntNum - 1] of PNumInput;
begin
  ChangeHelpCtx(hcCfgDrive);
  BoxTitle := 'Drive options';
  MakeWinBounds(R, 62, 17);
  D := New(PDialog, Init(R, BoxTitle, fxNormal, fyNormal, True));
  R.Assign(6, 2, 29, 5);
  D^.Insert(New(PItemFrame, Init(R, 'Command execution')));
  R.Assign(37, 2, 27, 5);
  D^.Insert(New(PItemFrame, Init(R, 'Retry options')));
  R.Assign(6, 7, 58, 7);
  D^.Insert(New(PItemFrame, Init(R, 'Drive interleaves')));
  R.Assign(8, 3, 24, 1);
  I1 := New(PMenuInput, Init(R, 6, 6, 'Command exec mode', drRight, 'Select command exec mode',
    cxNormal, cxWarp, 1, CmdExecModeStr));
  W := CmdExecMode;
  I1^.SetData(W);
  D^.Insert(I1);
  R.Assign(8, 4, 24, 1);
  I2 := New(PNumInput, Init(R, 3, 3, 'Head movement speed', drRight));
  I2^.SetValidator(New(PNumValid, Init(0, MaxByte, stEmpty, 'head movement speed', CurHelpCtx)));
  S := LeadingSpace(HeadSpeed, 0);
  I2^.SetData(S);
  D^.Insert(I2);
  R.Assign(8, 5, 24, 1);
  I3 := New(PCheckBoxes, Init(R,
    NewSItem('Format bumps head',
  nil)));
  W := Byte(FormatBumpsHead);
  I3^.SetData(W);
  D^.Insert(I3);
  R.Assign(39, 3, 23, 1);
  I4 := New(PNumInput, Init(R, 3, 2, 'Number of retries', drRight));
  I4^.SetValidator(New(PNumValid, Init(0, MaxRetryNum, stEmpty, 'number of retries', CurHelpCtx)));
  S := LeadingSpace(RetryNum, 0);
  I4^.SetData(S);
  D^.Insert(I4);
  R.Assign(39, 4, 23, 2);
  I5 := New(PCheckBoxes, Init(R,
    NewSItem('Retry on halftracks',
    NewSItem('Retry bumps head',
  nil))));
  W := Byte(RetryHalftracks) or Byte(RetryBumpsHead) shl 1;
  I5^.SetData(W);
  D^.Insert(I5);
  for B := 0 to DriveIntNum - 1 do
  begin
    X := 8;
    if B in [2..3, 12..19] then X := 39;
    if B and 1 > 0 then Inc(X, 4);
    Y := 8;
    if B >= 4 then Y := (((B - 4) shr 1) and 3) + 9;
    S := '';
    F := False;
    if B and 1 > 0 then
    begin
      case B of
        1: S := 'Normal/GEOS files';
        3:
        begin
          S := 'normal';
          F := (CopyTransferMode = tmNormal);
        end;
        5..11:
        begin
          S := 'turbo';
          F := (CopyTransferMode = tmTurbo);
        end;
        13..19:
        begin
          S := 'warp';
          F := (CopyTransferMode = tmWarp);
        end;
      end;
      case B of
        3, 5, 13:
        begin
          S := 'Serial ' + S;
          F := F and (CopyCableMode = cmSerial);
        end;
        7, 15:
        begin
          S := 'Async ' + S;
          F := F and (CopyCableMode = cmAsync);
        end;
        9, 17:
        begin
          S := 'Hybrid ' + S;
          F := F and (CopyCableMode = cmHybrid);
        end;
        11, 19:
        begin
          S := 'Parallel ' + S;
          F := F and (CopyCableMode = cmParallel);
        end;
      end;
    end;
    if F then S := ColorChar + S + ColorChar;
    R.Assign(X, Y, Length(S) + 4, 1);
    I[B] := New(PNumInput, Init(R, 3, 2, S, drRight));
    I[B]^.SetValidator(New(PNumValid, Init(0, MaxDriveInt, stEmpty, 'interleave', CurHelpCtx)));
    S := LeadingSpace(DriveInts[B], 0);
    I[B]^.SetData(S);
    D^.Insert(I[B]);
  end;
  R.Assign(5, 15, 60, 2);
  D^.Insert(New(PConfigText, Init(R)));
  R.Assign(3, 17, 64, 1);
  D^.Insert(New(PSeparator, Init(R)));
  R.Assign(14, 18, 6, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'O'+ColorChar+'K ]', cmOK)));
  R.Assign(22, 18, 10, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'C'+ColorChar+'ancel ]', cmCancel)));
  R.Assign(34, 18, 8, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'N'+ColorChar+'ext ]', cmYes)));
  R.Assign(44, 18, 12, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'P'+ColorChar+'revious ]', cmNo)));
  I1^.Select;
  D^.Palette := wpConfig;
  C := DisplayDialog(D);
  if C <> cmCancel then
  begin
    I1^.GetData(W);
    CmdExecMode := W;
    I2^.GetData(S);
    if S <> '' then Val(S, HeadSpeed, NumOk);
    I3^.GetData(W);
    FormatBumpsHead := (W and 1 > 0);
    I4^.GetData(S);
    if S <> '' then Val(S, RetryNum, NumOk);
    I5^.GetData(W);
    RetryHalftracks := (W and 1 > 0);
    RetryBumpsHead := (W and 2 > 0);
    for B := 0 to DriveIntNum - 1 do
    begin
      I[B]^.GetData(S);
      if S <> '' then Val(S, DriveInts[B], X);
    end;
    WarningStatus := WarningStatus and not wmBadFeature;
    InitTransfer(True);
  end;
  SetSetupItem(cmCfgDrive);
  RestoreHelpCtx;
  CfgDrive := C;
end;

{'Set palettes' items in the main setup menu: change color palettes}
function CfgPalette: Word;
var
  B             : Byte;
  C             : Char;
  P             : PChar;
  R             : TRect;
begin
  if Monochrome then
  begin
    EditPalNum := apMonochrome;
    MenuBar^.DisableCommands([cmBlackWhite, cmColor, cmLaptop]);
  end
  else
  begin
    EditPalNum := ScreenCol;
    MenuBar^.EnableCommands([cmBlackWhite, cmColor, cmLaptop]);
  end;
  EditPal := CApplication[EditPalNum];
  ChangeHelpCtx(hcCfgPalette2);
  SetSetupItem(cmCfgPalette);
  B := ScreenWidth - 22;
  R.Assign(0, 0, B, ScreenHeight);
  SampleScreen := New(PSampleScreen, Init(R));
  SampleScreen^.Hide;
  Application^.Insert(SampleScreen);
  R.Assign(0, 0, 22, ScreenHeight - 1);
  PalSetup := New(PPalSetup, Init(R));
  R.Assign(B, 0, 22, ScreenHeight - 1);
  PalDialog := New(PDialog, Init(R, stEmpty, fxSmall, fySmall, False));
  PalDialog^.Insert(PalSetup);
  PalDialog^.Palette := wpHistory;
  PalDialog^.SetState(sfShadow, False);
  R.Assign(4, 2, 38, ScreenHeight - 6);
  ColPanel := New(PColPanel, Init(R, PaletteLen));
  B := (B - 50) shr 1;
  R.Assign(B, 2, 50, ScreenHeight - 4);
  ColDialog := New(PDialog, Init(R, 'Color setup', fxNormal, fyNormal, False));
  ColDialog^.Insert(ColPanel);
  ColDialog^.Select;
  ColDialog^.Palette := wpHistory;
  Application^.Insert(ColDialog);
  Application^.Insert(PalDialog);
  P := @Application^.GetPalette^[PaletteLen - 1];
  C := P^;
  P^ := EditPal[PaletteLen - 1];
  LastHalfSec := MaxByte;
  CanChangeChars := False;
  Application^.SetCharSet(csIBMLower, True, False);
  RedrawAllViews;
  ColDialog^.SetState(sfSelected, True);
  Application^.ExecView(ColDialog, False, True);
  Dispose(PalDialog, Done);
  Dispose(ColDialog, Done);
  Dispose(SampleScreen, Done);
  P^ := C;
  CApplication[EditPalNum] := EditPal;
  LastHalfSec := MaxByte;
  Application^.InitScreen;
  Application^.SetCharSet(CharSetMode, True, True);
  RedrawAllViews;
  CanChangeChars := True;
  RestoreHelpCtx;
  CfgPalette := cmOK;
end;

{'Set default configuration': reset the complete configuration to the defaults}
function CfgReset: Word;
var
  B             : Boolean;
  C             : Word;
begin
  ChangeHelpCtx(hcCfgReset);
  SetSetupItem(cmCfgReset);
  B := (CharSetMode and csIBMCBM > 0);
  C := Confirm('Setup', 'Do you wish to reset all options', 'to their default values?', stReset,
    stEmpty, stEmpty, nil, CurHelpCtx, True, DummyByte);
  RestoreHelpCtx;
  if C <> cmCancel then
  begin
    ResetConfig;
    if B then SetVideoMode(ScreenMode);
    Application^.InitScreen;
  end;
  CfgReset := C;
end;

function CfgCountry: Word;
var
  B,
  I,
  J,
  K,
  L             : Byte;
  C             : Word;
  D             : PDialog;
  S             : string[60];
  R             : TRect;
begin
  ChangeHelpCtx(hcCfgCountry);
  BoxTitle := 'Country info';
  MakeWinBounds(R, 58, 17);
  D := New(PDialog, Init(R, BoxTitle, fxNormal, fyNormal, False));
  R.Assign(6, 2, 16, 3);
  D^.Insert(New(PItemFrame, Init(R, 'Time format')));
  R.Assign(11, 3, 5, 1);
  if MilitaryTime then S := '21' + TimeSep + '00' else S := '9' + TimeSep + '00p';
  D^.Insert(New(PStaticText, Init(R, S)));
  R.Assign(23, 2, 17, 3);
  D^.Insert(New(PItemFrame, Init(R, 'Date format')));
  case DateFormat of
    1: S := 'DD' + DateSep + 'MM' + DateSep + 'YY';
    2: S := 'YY' + DateSep + 'MM' + DateSep + 'DD';
  else
    S := 'MM' + DateSep + 'DD' + DateSep + 'YY';
  end;
  R.Assign(27, 3, 8, 1);
  D^.Insert(New(PStaticText, Init(R, S)));
  R.Assign(41, 2, 19, 3);
  D^.Insert(New(PItemFrame, Init(R, 'Number format')));
  R.Assign(44, 3, 13, 1);
  D^.Insert(New(PStaticText, Init(R, SepStr(1000000000))));
  R.Assign(6, 5, 54, 10);
  D^.Insert(New(PItemFrame, Init(R, 'Character table')));
  I := $80;
  for B := 0 to 7 do
  begin
    R.Assign(10, B + 6, 46, 1);
    S[0] := #46;
    FillChar(S[1], 46, ' ');
    Move(CharTableArrows[B shl 1], S[1], 3);
    Move(CharTableArrows[B shl 1 + 1], S[44], 3);
    if B mod 4 = 3 then
    begin
      if B = 7 then
      begin
        Delete(S, 4, 26);
        Insert(' '+ColorChar+'Upper case'+ColorChar, S, 4);
        Insert(ColorChar+'Lower case'+ColorChar+' ', S, 33);
      end;
      D^.Insert(New(PColorText, Init(R, S)));
    end
    else
    begin
      J := I;
      for L := 0 to 39 do
      begin
        case B mod 4 of
          0: K := J;
          1: K := UpCaseTable[J];
          2: K := LoCaseTable[J];
        end;
        S[L + 4] := Chr(K);
        Inc(J);
        if J = $B0 then J := $E0;
      end;
      D^.Insert(New(PStaticText, Init(R, S)));
      if B mod 4 = 2 then I := J;
    end;
  end;
  R.Assign(13, 15, 40, 1);
  D^.Insert(New(PColorText, Init(R, 'The country information is determined by')));
  R.Assign(10, 16, 46, 1);
  D^.Insert(New(PColorText, Init(R, 'the '+ColorChar+'country='+ColorChar+' statement in the '+
    ColorChar+'config.sys'+ColorChar+' file.')));
  R.Assign(3, 17, 60, 1);
  D^.Insert(New(PSeparator, Init(R)));
  R.Assign(30, 18, 6, 1);
  D^.Insert(New(PButton, Init(R, '[ '+ColorChar+'O'+ColorChar+'K ]', cmOK)));
  D^.Palette := wpConfig;
  LastHalfSec := MaxByte;
  CanChangeChars := False;
  Application^.SetCharSet(csIBMLower, True, False);
  RedrawAllViews;
  C := Application^.ExecView(D, True, False);
  SetSetupItem(cmCfgCountry);
  Dispose(D, Done);
  LastHalfSec := MaxByte;
  Application^.InitScreen;
  Application^.SetCharSet(CharSetMode, True, True);
  RedrawAllViews;
  CanChangeChars := True;
  RestoreHelpCtx;
  CfgCountry := cmOK;
end;

end.
