
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                    COLORS.PAS                   }
{                                                 }
{   The Star Commander Colors configuration unit  }
{*************************************************}

unit Colors;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  App, Dialogs, Drivers, Objects, Views,
  LowLevel;

const
{Palette color codes in Commander sample screens}
  ccColorMask   = $3F;
  ccShadow      = $40;
  ccBlinking    = $80;
{Length of palette from previous release}
  OldPaletteLen = 40;
{Blinking/bright screen modes}
  BlinkBrightStr: array [False..True] of string[8] = ('Blinking', 'Bright');
{Shadow modes}
  NoShadowStr   : string[9] = 'No shadow';
  LowBrightStr  : string[14] = 'Low brightness';
{Screen color modes}
  ModeStr       : array [False..True] of string[10] = ('Color', 'Monochrome');
{Palette modes}
  PaletteStr    : array [apBlackWhite..apMonochrome] of string[11] = ('Black&White', 'Color', 'Laptop', 'Monochrome');
{Colors}
  CName00       : string[5] = 'Black';
  CName01       : string[4] = 'Blue';
  CName02       : string[5] = 'Green';
  CName03       : string[4] = 'Cyan';
  CName04       : string[3] = 'Red';
  CName05       : string[7] = 'Magenta';
  CName06       : string[5] = 'Brown';
  CName07       : string[10] = 'Light gray';
  CName08       : string[9] = 'Dark gray';
  CName09       : string[10] = 'Light blue';
  CName10       : string[11] = 'Light green';
  CName11       : string[10] = 'Light cyan';
  CName12       : string[9] = 'Light red';
  CName13       : string[4] = 'Pink';
  CName14       : string[6] = 'Yellow';
  CName15       : string[5] = 'White';
{Objects whose color can be changed}
  PName01       : string[6] = 'Panels';
  PName02       : string[15] = 'Current pointer';
  PName03       : string[14] = 'Selected files';
  PName04       : string[16] = 'Selected pointer';
  PName05       : string[13] = 'Column titles';
  PName06       : string[15] = 'Key bar numbers';
  PName07       : string[12] = 'Key bar text';
  PName08       : string[18] = 'Pull-down menu bar';
  PName09       : string[22] = 'Pull-down menu pointer';
  PName10       : string[21] = 'Pull-down menu border';
  PName11       : string[19] = 'Pull-down menu text';
  PName12       : string[21] = 'Pull-down menu bright';
  PName13       : string[26] = 'Pull-down menu current bar';
  PName14       : string[29] = 'Pull-down menu current bright';
  PName15       : string[33] = 'Pull-down menu unaccessible lines';
  PName16       : string[20] = 'Pull-down menu minus';
  PName17       : string[15] = 'Dialog box text';
  PName18       : string[22] = 'Dialog box bright text';
  PName19       : string[23] = 'Dialog box reverse text';
  PName20       : string[24] = 'Dialog box selected text';
  PName21       : string[22] = 'Configuration box text';
  PName22       : string[29] = 'Configuration box bright text';
  PName23       : string[30] = 'Configuration box reverse text';
  PName24       : string[31] = 'Configuration box selected text';
  PName25       : string[16] = 'History box text';
  PName26       : string[19] = 'History box pointer';
  PName27       : string[13] = 'Help box text';
  PName28       : string[20] = 'Help box bright text';
  PName29       : string[21] = 'Help box reverse text';
  PName30       : string[23] = 'Help box underline text';
  PName31       : string[14] = 'Error box text';
  PName32       : string[21] = 'Error box bright text';
  PName33       : string[22] = 'Error box reverse text';
  PName34       : string[23] = 'Error box selected text';
  PName35       : string[5] = 'Clock';
  PName36       : string[23] = 'Arrows in viewer/editor';
  PName37       : string[5] = 'Stars';
  PName38       : string[15] = 'Exploding stars';
  PName39       : string[26] = 'Blinking/bright characters';
  PName40       : string[6] = 'Shadow';
{Sample screen for each object}
  Screen        : array [0..PaletteLen] of Byte =
                  (0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   0, 0, 0, 0, 2, 2, 2, 2, 0, 0, 3, 3, 3, 3, 2, 2,
                   2, 2, 0, 2, 1, 1, 0, 0, 0);
{Colors}
  ColorNames    : array [0..15] of Word =
                  (Ofs(CName00), Ofs(CName01), Ofs(CName02), Ofs(CName03),
                  Ofs(CName04), Ofs(CName05), Ofs(CName06), Ofs(CName07),
                  Ofs(CName08), Ofs(CName09), Ofs(CName10), Ofs(CName11),
                  Ofs(CName12), Ofs(CName13), Ofs(CName14), Ofs(CName15));
{Objects}
  PaletteNames  : array [0..PaletteLen - 1] of Word =
                  (Ofs(PName01), Ofs(PName02), Ofs(PName03), Ofs(PName04),
                  Ofs(PName05), Ofs(PName06), Ofs(PName07), Ofs(PName08),
                  Ofs(PName09), Ofs(PName10), Ofs(PName11), Ofs(PName12),
                  Ofs(PName13), Ofs(PName14), Ofs(PName15), Ofs(PName16),
                  Ofs(PName17), Ofs(PName18), Ofs(PName19), Ofs(PName20),
                  Ofs(PName21), Ofs(PName22), Ofs(PName23), Ofs(PName24),
                  Ofs(PName25), Ofs(PName26), Ofs(PName27), Ofs(PName28),
                  Ofs(PName29), Ofs(PName30), Ofs(PName31), Ofs(PName32),
                  Ofs(PName33), Ofs(PName34), Ofs(PName35), Ofs(PName36),
                  Ofs(PName37), Ofs(PName38), Ofs(PName39), Ofs(PName40));

type
{Sample Commander screen}
  TSampleScreen = object(TView)
    ScreenNum,
    CurScreen   : Byte;
    procedure Draw; virtual;
  end;
  PSampleScreen = ^TSampleScreen;
{Color setup menu}
  TPalSetup     = object(TView)
    Pos,
    Color       : Byte;
    constructor Init(var Bounds: TRect);
    procedure SetPos(APos: Byte);
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Draw; virtual;
  end;
  PPalSetup     = ^TPalSetup;
{Color setup main menu}
  TColPanel     = object(TView)
    Cur,
    Max,
    MenuLen,
    DeltaY      : Integer;
    constructor Init(var Bounds: TRect; AMax: Integer);
    procedure Draw; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
  end;
  PColPanel     = ^TColPanel;

var
  EditPalNum    : Byte;
  ColDialog,
  PalDialog     : PDialog;
  PalSetup      : PPalSetup;
  ColPanel      : PColPanel;
  SampleScreen  : PSampleScreen;
  EditPal       : TPalette;

procedure FixPalette(Palette: PPalette; PalNum: Byte);
procedure LoadPalettes(Prev: Boolean);

implementation

uses
  Base1, Base2, Config, Constant, ExtFiles;

{Fix palette when data came from the previous release}
procedure FixPalette(Palette: PPalette; PalNum: Byte);
begin
end;

{Load palettes from the configuration into memory
  Input : Prev: when True, the configuration file is from the previous
                release}
procedure LoadPalettes(Prev: Boolean);
var
  B,
  C             : Byte;
  S             : PPalette;
begin
  C := PaletteLen;
  if Prev then C := OldPaletteLen;
  for B := apBlackWhite to apMonochrome do
  begin
    S := @CApplication[B];
    S^ := ReadConfigStr(C, True);
    if Prev then FixPalette(S, B);
  end;
end;

constructor TColPanel.Init(var Bounds: TRect; AMax: Integer);
var
  I             : Integer;
begin
  I := Bounds.B.Y - 2;
  Inc(Bounds.B.X, 8);
  TView.Init(Bounds);
  Options := Options or ofSelectable;
  EventMask := EventMask or evBroadcast;
  MenuLen := I;
  Max := AMax;
  Cur := 0;
end;

procedure SetBlinkBright;
begin
  Drivers.SetBlinkBright((Ord(EditPal[PaletteLen - 1]) > 0));
end;

procedure ForcePalExt;
begin
  if FileExt(SourceName) = '' then SourceName := SourceName + PaletteFileExt;
end;

procedure TColPanel.HandleEvent(var Event: TEvent);

procedure MEnter;
var
  C             : Byte;
begin
  SampleScreen^.CurScreen := MaxByte;
  SampleScreen^.ScreenNum := Screen[Cur];
  ClockOff;
  ColDialog^.Hide;
  SampleScreen^.Show;
  KeyBar^.Hide;
  C := Ord(EditPal[Cur + 1]);
  if Application^.ExecView(PalDialog, True, True) <> cmOK then EditPal[Cur + 1] := Chr(C);
  KeyBar^.Show;
  SampleScreen^.Hide;
  SetBlinkBright;
  ColDialog^.Show;
  PalDialog^.MakeFirst;
  ColDialog^.SetState(sfSelected, True);
  ClockOn;
  ClearEvent(Event);
end;

procedure MUp;
begin
  if not (Cur = 0) then
  begin
    if Cur = DeltaY then Dec(DeltaY);
    Dec(Cur);
  end;
  DrawView;
end;

procedure MDown;
begin
  if not (Cur = Max - 1) then
  begin
    if Cur = DeltaY + MenuLen - 1 then Inc(DeltaY);
    Inc(Cur);
  end;
  DrawView;
end;

procedure MPgUp;
begin
  if DeltaY = 0 then
  begin
    Cur := 0;
  end
  else
  begin
    if Cur < MenuLen then
    begin
      DeltaY := 0;
    end
    else
    begin
      if DeltaY > MenuLen - 1 then Dec(DeltaY, MenuLen - 1) else DeltaY := 0;
    end;
  end;
  DrawView;
end;

procedure MPgDn;
begin
  if DeltaY > Max - MenuLen - 1 then
  begin
    Cur := Max - 1;
  end
  else
  begin
    if Cur > Max - MenuLen then
    begin
      if Max > MenuLen then DeltaY := Max - MenuLen else DeltaY := 0;
    end
    else
    begin
      if DeltaY < Max - (MenuLen shl 1) + 1 then Inc(DeltaY, MenuLen - 1) else
        DeltaY := Max - MenuLen;
    end;
  end;
  DrawView;
end;

procedure MHome;
begin
  DeltaY := 0;
  Cur := 0;
  DrawView;
end;

procedure MEnd;
begin
  if Max > MenuLen then DeltaY := Max - MenuLen else DeltaY := 0;
  Cur := Max - 1;
  DrawView;
end;

var
  O             : Boolean;
  C,
  H             : Word;
  L             : Longint;
  T             : TPoint;
begin
  if Event.What and evKeyboard > 0 then
  begin
    case Event.KeyCode of
      kbEnter: MEnter;
      kbUp: MUp;
      kbDown: MDown;
      kbPgUp: MPgUp;
      kbPgDn: MPgDn;
      kbHome: MHome;
      kbEnd: MEnd;
    end;
  end;
  if Event.What and evMouse > 0 then
  begin
    repeat
      if MouseInView(Event.Where) then
      begin
        C := evMouseMove;
        O := Event.Double;
        MakeLocal(Event.Where, T);
        Cur := DeltaY + T.Y;
        if Cur >= Max then Cur := Max - 1;
        DrawView;
      end
      else
      begin
        C := evMouseAuto;
        MakeLocal(Event.Where, T);
        if T.Y <= -1 then MUp else
          if T.Y > MenuLen then MDown;
      end;
    until not MouseEvent(Event, C);
    if O and MouseInView(Event.Where) then MEnter;
    ClearEvent(Event);
  end;
  if Event.What and evCommand > 0 then
  begin
    if Event.Command in [cmSavePal..cmResetPal] then
    begin
      H := CurHelpCtx;
      O := HelpCtxSet;
      HelpCtxSet := True;
      CurHelpCtx := hcCfgPalette;
      AppHelpCtx := hcCfgPalette;
      LastShiftState := MaxByte;
      PalSetup^.HideCursor;
      case Event.Command of
        cmSavePal:
        begin
          BoxTitle := 'Save palette';
          SourceName := '';
          if GetName(stEmpty, 'Save to the file', MaxFileNameLen) then
          begin
            ForcePalExt;
            if LongOpenFile(SourceName, WriteFile, fmWriteOnly) = 0 then
            begin
              ExtBlockWrite(WriteFile, EditPal[1], PaletteLen);
              if IOResult <> 0 then ErrorWin(stEmpty, 'Error while writing to the file', SourceName, CurHelpCtx, sbNone);
              ExtClose(WriteFile);
              PalSetup^.SetPos(PalSetup^.Pos);
            end
            else
            begin
              ErrorWin(stEmpty, 'Can''t open the palette file', SourceName, CurHelpCtx, sbNone);
            end;
          end;
        end;
        cmLoadPal:
        begin
          BoxTitle := 'Load palette';
          SourceName := '';
          if GetName(stEmpty, 'Load from the file', MaxFileNameLen) then
          begin
            ForcePalExt;
            if LongOpenFile(SourceName, ReadFile, fmReadOnly) = 0 then
            begin
              L := ExtFileSize(ReadFile);
              if L > PaletteLen then L := PaletteLen;
              FillChar(EditPal[1], PaletteLen, ErrorAttr);
              ExtBlockRead(ReadFile, EditPal[1], L);
              if L < PaletteLen then FixPalette(@EditPal, EditPalNum);
              if IOResult <> 0 then ErrorWin(stEmpty, 'Error while reading from the file', SourceName, CurHelpCtx, sbNone);
              ExtClose(ReadFile);
            end
            else
            begin
              ErrorWin(stEmpty, 'Can''t open the palette file', SourceName, CurHelpCtx, sbNone);
            end;
          end;
        end;
        cmBlackWhite..cmLaptop:
        begin
          CApplication[EditPalNum] := EditPal;
          EditPalNum := Event.Command - cmBlackWhite;
          EditPal := CApplication[EditPalNum];
          Application^.GetPalette^[PaletteLen - 1] := EditPal[PaletteLen - 1];
          DrawView;
          PalSetup^.DrawView;
        end;
        cmResetPal:
        begin
          if Confirm('Setup', 'Do you wish to reset the colors', 'to their default values?', stReset,
            stEmpty, stEmpty, nil, CurHelpCtx, True, DummyByte) = cmOK then EditPal := CDefApplication[EditPalNum];
        end;
      end;
      PalSetup^.SetPos(PalSetup^.Pos);
      PalSetup^.ShowCursor;
      SetBlinkBright;
      HelpCtxSet := O;
      CurHelpCtx := H;
      AppHelpCtx := H;
      LastShiftState := MaxByte;
    end;
  end;
end;

procedure TColPanel.Draw;
var
  A,
  C,
  D             : Word;
  X,
  Y             : Integer;
  B             : TDrawBuffer;
begin
  if Cur < DeltaY then Cur := DeltaY;
  if Cur > DeltaY + MenuLen - 1 then Cur := DeltaY + MenuLen - 1;
  A := GetColor($0101);
  C := GetColor($0202);
  for Y := 0 to Size.Y - 1 do
  begin
    if DeltaY + Y < Max then
    begin
      if DeltaY + Y = Cur then D := C else D := A;
      MoveChar(B, ' ', A, 1);
      MoveChar(B[1], ' ', D, Size.X - 2);
      MoveStr(B[1], ' ' + PString(Ptr(DSeg, PaletteNames[DeltaY + Y]))^, D);
      MoveChar(B[Size.X - 1], ' ', A, 1);
    end
    else
    begin
      MoveChar(B, ' ', A, Size.X);
    end;
    WriteBuf(0, Y, Size.X, 1, B);
  end;
  PalSetup^.SetPos(Cur + 1);
end;

procedure TSampleScreen.Draw;
var
  F             : Boolean;
  A,
  C,
  D,
  E,
  R,
  S,
  T             : Byte;
  V,
  W             : Word;
  X,
  Y             : Integer;
  P             : PBuffer;
  B             : TDrawBuffer;
begin
  if ScreenNum <> CurScreen then
  begin
    CurScreen := ScreenNum;
    case CurScreen of
      0: P := @Screen1;
      1: P := @Screen2;
      2: P := @Screen3;
      3: P := @Screen4;
    end;
    V := 0;
    W := 0;
    R := 0;
    repeat
      if R = 0 then
      begin
        D := P^[V];
        Inc(V);
        if D = 1 then
        begin
          A := P^[V];
          D := P^[V + 1];
          Inc(V, 2);
        end;
        if D = 2 then
        begin
          R := P^[V];
          D := P^[V + 1];
          Inc(V, 2);
        end;
      end;
      if R > 0 then Dec(R);
      GCRBuffer[W] := D;
      GCRBuffer[W + 1] := A;
      Inc(W, 2);
    until D = 0;
  end;
  W := 0;
  case Ord(EditPal[PaletteLen]) of
    shNone:
    begin
      F := False;
      S := MaxByte;
      T := 0;
    end;
    shLowBrightness:
    begin
      F := True;
      S := DefShadowANDAttr;
      T := DefShadowORAttr;
    end;
    shGrayOnBlack:
    begin
      F := True;
      S := 0;
      T := DefShadowAttr;
    end;
  end;
  E := Ord(EditPal[PaletteLen - 1]);
  for Y := 0 to Size.Y - 1 do
  begin
    MoveChar(B, ' ', ErrorAttr, Size.X);
    if Y < 25 then
    begin
      for X := 0 to 56 do
      begin
        C := GCRBuffer[W + 1];
        if C = 0 then
        begin
          A := ErrorAttr;
        end
        else
        begin
          A := Ord(EditPal[C and ccColorMask]);
          if C and ccShadow > 0 then
          begin
            if F then
            begin
              if A and $80 = 0 then A := A and $0F;
              if A and $08 = 0 then A := A and $F0;
            end;
            A := (A and S) or T;
          end;
          if (C and ccBlinking > 0) and ((E = 0) or not HiResScreen) then A := A or $80;
        end;
        B[X] := GCRBuffer[W] + (A shl 8);
        Inc(W, 2);
      end;
    end;
    WriteBuf(0, Y, Size.X, 1, B);
  end;
end;

constructor TPalSetup.Init(var Bounds: TRect);
begin
  TView.Init(Bounds);
  Options := Options or ofSelectable;
  EventMask := EventMask or evBroadcast;
  Color := 0;
end;

procedure TPalSetup.SetPos(APos: Byte);
var
  C             : Byte;
begin
  Pos := APos;
  Color := Ord(EditPal[Pos]);
  C := Color;
  SetCursor((C and $0F) + 3, (C shr 4) + 4);
  ShowCursor;
  DrawView;
  LastHalfSec := MaxByte;
end;

procedure TPalSetup.HandleEvent(var Event: TEvent);
var
  O             : Boolean;
  T             : TPoint;

procedure SetColor(AColor: Byte; Spec: Boolean);
var
  O             : Boolean;
  B             : Byte;
begin
  O := False;
  case Pos of
    (PaletteLen - 1): B := 1;
    PaletteLen: B := shGrayOnBlack;
  else
    O := True;
  end;
  if not O and not Spec then
  begin
    if AColor = B + 1 then AColor := 0;
    if AColor > B then AColor := B;
    O := True;
  end;
  if O then
  begin
    Color := AColor;
    EditPal[Pos] := Chr(Color);
    SetPos(Pos);
    if Pos = PaletteLen - 1 then SetBlinkBright;
    SampleScreen^.DrawView;
  end;
end;

begin
  if Event.What and evKeyboard > 0 then
  begin
    case Event.KeyCode of
      kbUp: SetColor(Color - $10, True);
      kbDown: SetColor(Color + $10, True);
      kbLeft: SetColor((Color and $F0) or (((Color and $0F) - 1) and $0F), False);
      kbRight: SetColor((Color and $F0) or (((Color and $0F) + 1) and $0F), False);
      kbPgUp: SetColor(Color and $0F, True);
      kbPgDn: SetColor(Color and $0F or $F0, True);
      kbHome: SetColor(Color and $F0, False);
      kbEnd: SetColor(Color and $F0 or $0F, False);
    end;
  end;
  if Event.What and evMouse > 0 then
  begin
    repeat
      if MouseInView(Event.Where) then
      begin
        O := Event.Double or (Event.Buttons and mbRightButton > 0);
        MakeLocal(Event.Where, T);
        if (T.X in [3..18]) and (T.Y in [4..19]) then
        begin
          Dec(T.X, 3);
          Dec(T.Y, 4);
          SetColor(T.X + (T.Y shl 4), True);
        end;
        DrawView;
      end;
    until not MouseEvent(Event, evMouseMove);
    if O and MouseInView(Event.Where) then
    begin
      Event.What := evCommand;
      Event.Command := cmOK;
    end;
  end;
end;

procedure TPalSetup.Draw;
var
  O             : Boolean;
  A,
  C,
  D             : Byte;
  X,
  Y             : Integer;
  S             : PString;
  B             : TDrawBuffer;
begin
  A := Ord(Application^.GetPalette^[1]);
  C := Color;
  D := C;
  for Y := 0 to Size.Y - 1 do
  begin
    MoveChar(B, ' ', A, Size.X);
    case Y of
      1: MoveStr(B[4], 'Mode: ' + ModeStr[ScreenMode = smMono], A);
      2: MoveStr(B[1], 'Palette: ' + PaletteStr[EditPalNum], A);
      4..19: for X := 0 to 15 do MoveChar(B[X + 3], 'x', X or ((Y - 4) shl 4), 1);
      21:
      begin
        O := False;
        case Pos of
          PaletteLen - 1: S := PString(@BlinkBrightStr[C > 0]);
          PaletteLen:
          begin
            case C of
              shNone: S := @NoShadowStr;
              shLowBrightness: S := @LowBrightStr;
              shGrayOnBlack:
              begin
                D := ShadowAttr;
                O := True;
              end;
            end;
          end;
        else
          O := True;
        end;
        if O then S := PString(Ptr(DSeg, ColorNames[D and $0F]));
        MoveStr(B[(23 - Length(S^)) shr 1], S^, A);
      end;
      22:
      begin
        if Pos = PaletteLen - 1 then
        begin
          MoveStr(B[6], 'characters', A);
        end
        else
        begin
          if (Pos <> PaletteLen) or (C <> shNone) then
          begin
            if (Pos = PaletteLen) and (C = shLowBrightness) then S := @LowBrightStr else
              S := PString(Ptr(DSeg, ColorNames[D shr 4]));
            MoveStr(B[(20 - Length(S^)) shr 1], 'on ' + S^, A);
          end;
        end;
      end;
    end;
    WriteBuf(0, Y, Size.X, 1, B);
  end;
end;

end.
