
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                   COMPHLP.PAS                   }
{                                                 }
{      The Star Commander help file compiler      }
{*************************************************}

program The_Star_Commander_Help_File_Compiler;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384, 0, 655360}

uses
  LowLevel;

const
{Length of online help buffer}
  BufferMax     = 30720;
{Signature for the online help header}
  HelpSign      : string[36] = 'The Star Commander 0.83 help file' + chCR + chLF + chEOF;
{EOL characters}
  EOLChars      : set of Char = [chCR, chLF];

var
  FileEnd       : Boolean;
  PrevData,
  RLECount,
  HelpXORSum,
  HelpSUBSum,
  Number,
  WriteData     : Byte;
  ReadData,
  PrevEOL       : Char;
  ReadSize,
  ReadCount,
  WriteCount,
  BufferSize    : Longint;
  ReadFile,
  WriteFile     : file;
  HeaderBuffer  : array [0..HelpHeaderLen - 1] of Byte;
  ReadBuffer,
  WriteBuffer   : array [0..BufferMax - 1] of Byte;

{Read a character from the input file}
procedure ReadChar;
begin
  if ReadCount = BufferSize then
  begin
    ReadCount := 0;
    if EOF(ReadFile) then
    begin
      FileEnd := True;
      ReadBuffer[ReadCount] := hfEOL;
    end
    else
    begin
      if ReadSize > BufferMax then BufferSize := BufferMax else BufferSize := ReadSize;
      ReadSize := ReadSize - BufferSize;
      BlockRead(ReadFile, ReadBuffer, BufferSize);
    end;
  end;
  WriteData := ReadBuffer[ReadCount];
  ReadData := Chr(WriteData);
  Inc(ReadCount);
end;

{Write a byte into the output file
  Input : B: byte to be output
          Checksum: when True, this is a checksum byte}
procedure RealWriteByte(B: Byte; Checksum: Boolean);
begin
  WriteBuffer[WriteCount] := B;
  Inc(WriteCount);
  if not Checksum then
  begin
    HelpXORSum := HelpXORSum xor B;
    HelpSUBSum := HelpSUBSum - B;
  end;
  if (WriteCount = BufferMax) or FileEnd then
  begin
    BlockWrite(WriteFile, WriteBuffer, WriteCount);
    WriteCount := 0;
  end;
end;

{Flush the previous run to the output file}
procedure FlushPrevRun;
begin
  if RLECount > 0 then
  begin
    if ((PrevData = Ord(' ')) and (RLECount <= 2)) or ((PrevData <> Ord(' ')) and (RLECount <= 3)) then
    begin
      while RLECount > 0 do
      begin
        RealWriteByte(PrevData, False);
        Dec(RLECount);
      end;
    end
    else
    begin
      if PrevData = Ord(' ') then
      begin
        RealWriteByte(hfSpaces, False);
        RealWriteByte(RLECount, False);
      end
      else
      begin
        RealWriteByte(hfMultiply, False);
        RealWriteByte(RLECount, False);
        RealWriteByte(PrevData, False);
      end;
    end;
  end;
  RLECount := 0;
end;

{Write a byte into the output file, with on-the-fly RLE compression
  Input : B: byte to be output
          Checksum: when True, this is a checksum byte}
procedure WriteByte(B: Byte; Checksum: Boolean);
begin
  if (PrevData = B) and (RLECount > 0) and not FileEnd and not Checksum then
  begin
    Inc(RLECount);
  end
  else
  begin
    FlushPrevRun;
    if Checksum then
    begin
      RealWriteByte(B, True);
    end
    else
    begin
      Inc(RLECount);
      PrevData := B;
    end;
  end;
end;

var
  I             : Word;
  P             : Longint;
begin
  Assign(ReadFile, 'HELP.TXT');
  Reset(ReadFile, 1);
  if IOResult = 0 then
  begin
    Assign(WriteFile, 'SC.HLP');
    Rewrite(WriteFile, 1);
    ReadSize := FileSize(ReadFile);
    BufferSize := 0;
    ReadCount := 0;
    WriteCount := 0;
    HelpXORSum := 0;
    HelpSUBSum := 0;
    RLECount := 0;
    FileEnd := False;
    for I := 0 to HelpHeaderLen - 1 do HeaderBuffer[I] := 0;
    BlockWrite(WriteFile, HeaderBuffer, HelpHeaderLen);
    for I := 1 to Length(HelpSign) do HeaderBuffer[I - 1] := Ord(HelpSign[I]);
    I := HelpTableStart;
    P := FilePos(WriteFile) + WriteCount;
    HeaderBuffer[I] := P;
    HeaderBuffer[I + 1] := P shr 8;
    HeaderBuffer[I + 2] := P shr 16;
    I := I + 3;
    while not FileEnd do
    begin
      ReadChar;
      while (ReadData in EOLChars) and not FileEnd do
      begin
        PrevEOL := ReadData;
        ReadChar;
        while (ReadData in EOLChars) and (ReadData <> PrevEOL) and not FileEnd do ReadChar;
        WriteByte(hfEOL, False);
      end;
      if ReadData = '~' then
      begin
        ReadChar;
        ReadData := UpCase(ReadData);
        case ReadData of
          'P': WriteData := hfEOL;
          'N': WriteData := hfNormal;
          'B': WriteData := hfBright;
          'R': WriteData := hfReverse;
          'U': WriteData := hfUnderline;
          'A': WriteData := hfAnchor;
        end;
      end;
      if WriteData = hfEOL then
      begin
        FlushPrevRun;
        WriteByte(HelpXORSum, True);
        WriteByte(HelpSUBSum, True);
        P := FilePos(WriteFile) + WriteCount;
        HeaderBuffer[I] := P;
        HeaderBuffer[I + 1] := P shr 8;
        HeaderBuffer[I + 2] := P shr 16;
        I := I + 3;
        HelpXORSum := 0;
        HelpSUBSum := 0;
        RLECount := 0;
      end
      else
      begin
        WriteByte(WriteData, False);
      end;
    end;
    HelpXORSum := 0;
    HelpSUBSum := 0;
    for P := 0 to HelpHeaderLen - 3 do
    begin
      HelpXORSum := HelpXORSum xor HeaderBuffer[P];
      HelpSUBSum := HelpSUBSum - HeaderBuffer[P];
    end;
    HeaderBuffer[HelpHeaderLen - 2] := HelpXORSum;
    HeaderBuffer[HelpHeaderLen - 1] := HelpSUBSum;
    for P := HelpTableStart to HelpHeaderLen - 1 do HeaderBuffer[P] := HeaderBuffer[P];
    Seek(WriteFile, 0);
    BlockWrite(WriteFile, HeaderBuffer, HelpHeaderLen);
    Close(WriteFile);
    Close(ReadFile);
  end;
end.
