
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                  CONSTANT.PAS                   }
{                                                 }
{        The Star Commander constants unit        }
{*************************************************}

unit Constant;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  LowLevel;

type
{Extension part of file name}
  TFileExtStr   = string[3];

const
{Help contexts}
  hcMainIndex   = 0;
  hcAbout       = 1;
  hcKeyMain     = 2;
  hcKeyView1    = 3;
  hcKeyView2    = 4;
  hcKeyEdit1    = 5;
  hcKeyEdit2    = 6;
  hcKeyDiskEdit = 7;
  hcLeftRight   = 8;
  hcBriefFull   = 9;
  hcInfo        = 10;
  hcQuickView   = 11;
  hcOnOff       = 12;
  hcSortOrder   = 13;
  hcReread      = 14;
  hcColumn      = 15;
  hcSort        = 16;
  hcFilter      = 17;
  hcStatus      = 18;
  hcChangeDrive = 19;
  hcFiles       = 20;
  hcUserMenu    = 21;
  hcViewFile    = 22;
  hcEditFile    = 23;
  hcCopyFile    = 24;
  hcRenMovFile  = 25;
  hcMakeDir     = 26;
  hcDeleteFile  = 27;
  hcFileAttrib  = 28;
  hcFileInfo    = 29;
  hcLaunchEmu   = 30;
  hcSelectFile  = 31;
  hcQuitProgram = 32;
  hcCommands    = 33;
  hcMakeImage   = 34;
  hcDiskEdit    = 35;
  hcVolumeLabel = 36;
  hcCopyDisk    = 37;
  hcCompress    = 38;
  hcHistory     = 39;
  hcEGALines    = 40;
  hcVideoMode   = 41;
  hcSwapPanels  = 42;
  hcPanelsOnOff = 43;
  hcMenuEdit    = 44;
  hcOptions     = 45;
  hcMainConfig  = 46;
  hcCfgConfig   = 47;
  hcCfgOther    = 48;
  hcCfgImage    = 49;
  hcCfgTransfer = 50;
  hcCfgDrive    = 51;
  hcCfgPalette  = 52;
  hcCfgReset    = 53;
  hcCfgCountry  = 54;
  hcCfgQuit     = 55;
  hcDriveConfig = 56;
  hcExtEdit     = 57;
  hcViewerEdit  = 58;
  hcEditorEdit  = 59;
  hcAutoMenus   = 60;
  hcPathPrompt  = 61;
  hcKeyBar      = 62;
  hcFullScreen  = 63;
  hcMiniStatus  = 64;
  hcClock       = 65;
  hcSaveSetup   = 66;
  hcMainConfig2 = 101;
  hcDriveConfig2= 102;
  hcBlockEdit   = 103;
  hcMakeImage2  = 104;
  hcCopyDisk2   = 105;
  hcDiskEdit2   = 106;
  hcDiskedShift = 107;
  hcDiskedAlt   = 108;
  hcDiskEdit3   = 109;
  hcMapEdit     = 110;
  hcCompress2   = 111;
  hcCfgPalette2 = 112;
{Commands}
  cmHelp        = 21;
  cmUserMenu    = 22;
  cmViewFile    = 23;
  cmEditFile    = 24;
  cmCopyFile    = 25;
  cmRenMovFile  = 26;
  cmMakeDir     = 27;
  cmDeleteFile  = 28;
  cmPanelMenu   = 29;
  cmQuitProgram = 30;
  cmMakeDisk    = 31;
  cmMakeTape    = 32;
  cmSViewFile   = 33;
  cmSEditFile   = 34;
  cmSCopyFile   = 35;
  cmSRenMovFile = 36;
  cmSDeleteFile = 38;
  cmSaveSetup   = 39;
  cmLastMenu    = 40;
  cmDiskEdit    = 43;
  cmVolumeLabel = 44;
  cmCCopyFile   = 45;
  cmCRenMovFile = 46;
  cmFileAttrib  = 47;
  cmCDeleteFile = 48;
  cmMainConfig  = 49;
  cmLeftChange  = 51;
  cmRightChange = 52;
  cmIntViewFile = 53;
  cmIntEditFile = 54;
  cmCopyDisk    = 55;
  cmCompress    = 56;
  cmHistory     = 58;
  cmEGALines    = 59;
  cmVideoMode   = 60;
  cmCfgConfig   = 62;
  cmCfgOther    = 63;
  cmCfgImage    = 64;
  cmCfgTransfer = 65;
  cmCfgDrive    = 66;
  cmCfgPalette  = 67;
  cmCfgReset    = 68;
  cmCfgCountry  = 69;
  cmSavePal     = 72;
  cmLoadPal     = 73;
  cmBlackWhite  = 74;
  cmColor       = 75;
  cmLaptop      = 76;
  cmResetPal    = 78;
  cmDrvCfgNew   = 82;
  cmDrvCfgTransfer= 83;
  cmDrvCfgDrive = 84;
  cmDrvCfgDupe  = 85;
  cmDrvCfgRename= 86;
  cmDrvCfgSwap  = 87;
  cmDrvCfgDelete= 88;
  cmDrvCfgReset = 89;
  cmSelectFile  = 91;
  cmUnselectFile= 92;
  cmInvertSel   = 93;
  cmRestoreSel  = 94;
  cmLeftBrief   = 95;
  cmLeftFull    = 96;
  cmLeftInfo    = 97;
  cmLeftLong    = 98;
  cmLeftQView   = 99;
  cmLeftOnOff   = 100;
  cmLeftName    = 101;
  cmLeftExt     = 102;
  cmLeftTime    = 103;
  cmLeftSize    = 104;
  cmLeftUnsort  = 105;
  cmLeftReverse = 106;
  cmLeftReread  = 107;
  cmLeftColumn  = 108;
  cmLeftSort    = 109;
  cmLeftFilter  = 110;
  cmLeftStatus  = 111;
  cmKViewFile   = 112;
  cmKEditFile   = 113;
  cmKCopyFile   = 114;
  cmKRenMovFile = 115;
  cmKDeleteFile = 116;
  cmFileInfo    = 117;
  cmLaunchEmu   = 118;
  cmRightBrief  = 119;
  cmRightFull   = 120;
  cmRightLong   = 121;
  cmRightInfo   = 122;
  cmRightQView  = 123;
  cmRightOnOff  = 124;
  cmRightName   = 125;
  cmRightExt    = 126;
  cmRightTime   = 127;
  cmRightSize   = 128;
  cmRightUnsort = 129;
  cmRightReverse= 130;
  cmRightReread = 131;
  cmRightColumn = 132;
  cmRightSort   = 133;
  cmRightFilter = 134;
  cmRightStatus = 135;
  cmSwapPanels  = 136;
  cmPanelsOnOff = 137;
  cmMenuEdit    = 138;
  cmDriveConfig = 139;
  cmExtEdit     = 140;
  cmViewerEdit  = 141;
  cmEditorEdit  = 142;
  cmMiniStatus  = 143;
  cmAutoMenus   = 144;
  cmPathPrompt  = 145;
  cmKeyBar      = 146;
  cmFullScreen  = 147;
  cmClock       = 148;
  cmDCopyFile   = 149;
  cmDCompress   = 150;
  cmNoFileComp  = 151;
  cmLynx        = 152;
  cmFileZip     = 153;
  cmLHA         = 154;
  cmArkive      = 155;
  cmTAR         = 156;
  cmZIP         = 157;
  cmDisk1541    = 158;
  cmDisk1571    = 159;
  cmDisk1581    = 160;
  cmDisk1541Ext = 161;
  cmNoDiskConv  = 162;
  cmCBMDisk     = 163;
  cmDiskImage   = 164;
  cmGCRDiskImage= 165;
  cmDiskZip     = 166;
  cmSixZip      = 167;
  cmDiskCopyMode= 168;
  cmRecalibrate = 169;
  cmAListFile   = 170;
  cmAViewFile   = 171;
  cmAEditFile   = 172;
  cmACopyFile   = 173;
  cmAMoveFile   = 174;
  cmAMakeDir    = 175;
  cmADeleteFile = 176;
  cmAMakeDisk   = 177;
  cmAMakeTape   = 178;
  cmADiskEdit   = 179;
  cmAFileAttrib = 180;
  cmACopyDisk   = 181;
  cmAFormat     = 182;
  cmAValidate   = 183;
  cmAClean      = 184;
  cmASafeClean  = 185;
  cmAProtect    = 186;
  cmAUnprotect  = 187;
  cmAMinimize   = 188;
  cmAUserCommand= 189;
  cmASet        = 190;
  cmANoInit     = 191;
  cmAInit       = 192;
  cmASetDrive   = 193;
  cmAExit       = 194;
{Commands of the disk editor}
  cmDWrite      = 202;
  cmDRead       = 203;
  cmDEdit       = 204;
  cmDGotoBAM    = 205;
  cmDGotoDir    = 206;
  cmDGotoFirst  = 207;
  cmDGotoLast   = 208;
  cmDMenu       = 209;
  cmDFile1      = 211;
  cmDFile2      = 212;
  cmDFile3      = 213;
  cmDFile4      = 214;
  cmDFile5      = 215;
  cmDFile6      = 216;
  cmDFile7      = 217;
  cmDFile8      = 218;
  cmDInfo1      = 221;
  cmDInfo2      = 222;
  cmDInfo3      = 223;
  cmDInfo4      = 224;
  cmDInfo5      = 225;
  cmDInfo6      = 226;
  cmDInfo7      = 227;
  cmDInfo8      = 228;
  cmDMark       = 233;
  cmDUnmark     = 234;
  cmDCopy       = 235;
  cmDPaste      = 236;
  cmDSwap       = 237;
  cmDDelete     = 238;
  cmDFollow     = 239;
  cmDSaveMap    = 242;
  cmDViewMap    = 243;
  cmDEditMap    = 244;
  cmDAllocMap   = 247;
  cmDDeleteMap  = 248;
{Data entries of CBM programs to be run inside the external CBM drive}
  deBase        = 0;
  deTurboDiskDetect= 1;
  deTurboDiskChange= 2;
  deTurboDirLoad= 3;
  deWarpDirLoad = 4;
  deTurboDiskValidate= 5;
  deWarpDiskValidate= 6;
  deTurboDiskFormat = 7;
  deTurboDiskFormatVerify = 8;
  deAttrib      = 9;
  deTurboFileLoad= 10;
  deWarpFileLoad= 11;
  deTurboFileSave= 12;
  deWarpFileSave= 13;
  deTurboFileDelete= 14;
  deTurboDiskEdit= 15;
  deLabel       = 16;
  deTurboDiskLoad= 17;
  deWarpDiskLoad= 18;
  deTurboDiskSave= 19;
  deWarpDiskSave= 20;
  deWarpDiskVerify= 21;
  deTransfer    = 22;
  deTurboSend   = 23;
  deAsyncSend   = 24;
  deHybridSend  = 25;
  deParallelSend= 26;
  deTurboReceive= 27;
  deAsyncReceive= 28;
  deParallelReceive= 29;
  deTurboReceiveBlk= 30;
  deAsyncReceiveBlk= 31;
  deParallelReceiveBlk= 32;
  deEntryNum    = 33;
{Panel modes}
  pmDOS         = 0;
  pmExt         = 1;
  pmDisk        = 2;
  pmTape        = 3;
  pmFile        = 4;
  pmInfo        = 5;
  pmLynx        = 6;
  pmArkive      = 7;
  pmTAR         = 8;
  pmLHA         = 9;
  pmZIP         = 10;
  pmFileZip     = 11;
  pmGCRDisk     = 12;
  pmDiskZip     = 13;
  pmSixZip      = 14;
{File open modes}
  fmReadOnly    = 0;
  fmWriteOnly   = 1;
  fmReadWrite   = 2;
  fmModeMask    = $0F;
  fmExclusive   = $20;
  fmShared      = $40;
{Commodore file attributes}
  faDeleted     = 0;
  faSequential  = 1;
  faProgram     = 2;
  faUser        = 3;
  faRelative    = 4;
  faPartition   = 5;
  faFrozen      = 5;
  faTypeMask    = $07;
  faWriteProt   = $40;
  faClosed      = $80;
  faFlagMask    = $C0;
  faTapeNormal  = $01;
  faTapeFrozen  = $03;
{Extended GEOS file attributes}
  xaTypeMask    = $7F;
  xaGEOSVLIR    = $80;
  xaDirectory   = $80;
{Serial bus lines, converted to pin assignments on the LPT printer port; note
  the different DATA and RESET bits for the normal, extended and active
  cables}
  sbAtnNormal   = $01;
  sbClkNormal   = $02;
  sbDataNormal  = $08;
  sbDataSwapped = $04;
  sbResetNormal = $04;
  sbResetSwapped= $08;
  sbBidir       = $20;
{Serial bus status codes}
  ssTimeout     = $02;
  ssInputTimeout= $03;
  ssErrorMask   = $3F;
  ssEOF         = $40;
  ssNoDevice    = $80;
{Disk drive secondary addresses}
  saLoad        = 0;
  saSave        = 1;
  saData        = 2;
  saCommand     = (15 or $60);
{DOS critial error return codes}
  crIgnore      = 0;
  crRetry       = 1;
  crAbort       = 3;
{View modes}
  vmASCII       = 0;
  vmPETSCII     = 1;
  vmScreen      = 2;
  vmPETANSI     = 3;
  vmNext        = $80;
{Dialog box frame sizes}
  fxNormal      = 3;
  fyNormal      = 1;
  fxSmall       = 0;
  fySmall       = 0;
  fxNone        = -1;
  fyNone        = -1;
{Character sets}
  csIBMLower    = 0;
  csIBMUpper    = 1;
  csCBMLower    = 2;
  csCBMUpper    = 3;
  csLowerUpper  = 1;
  csIBMCBM      = 2;
{Transfer modes}
  tmNormal      = 0;
  tmTurbo       = 1;
  tmWarp        = 2;
{Serial cables}
  scNone        = 0;
  scNormal      = 1;
  scExtended    = 2;
  scMultitask   = 3;
  scActive      = 4;
  scOpenCBM     = 5;
{Parallel cables}
  pcNone        = 0;
  pcHybrid      = 1;
  pcParallel    = 2;
  pcCableMask   = $3F;
  pcAsyncMask   = $C0;
{Cable modes}
  cmSerial      = 0;
  cmAsync       = 1;
  cmHybrid      = 2;
  cmParallel    = 3;
{Disk copy modes}
  dcFull        = 0;
  dcBAM         = 1;
  dcSafeBAM     = 2;
  dcManualSelect= 3;
{Command execution modes}
  cxNormal      = 0;
  cxTurbo       = 1;
  cxWarp        = 2;
{File copy modes}
  cfSelected    = 0;
  cfWildcard    = 1;
  cfSingle      = 2;
  cfSingleWild  = 3;
  cfAutomatic   = 4;
  cfReadKey     = $7F;
  cfRetryView   = $80;
{Panel filter modes}
  pfAll         = 0;
  pfPCProgs     = 1;
  pfPCArchives  = 2;
  pfCBMImages   = 4;
  pfCBMArchives = 8;
{File statuses}
  fsNormal      = 0;
  fsWasSelected = 1;
  fsDeleted     = 2;
  fsStatusMask  = $3F;
  fsProcessed   = $40;
  fsSelected    = $80;
  fsProcessMask = $C0;
{User menu types}
  mtNone        = 0;
  mtMenu        = 1;
  mtExtension   = 2;
{External drive types}
  xd1541        = 0;
  xd1571        = 1;
  xd1581        = 2;
  xd1570        = 3;
  xd157xEmu     = 4;
{Disk types}
  dt1541        = $00;
  dt1571        = $01;
  dt1581        = $02;
  dt1541Ext     = $03;
  dtTypeMask    = $7F;
  dtErrorInfo   = $80;
  dtInvalid     = MaxByte;
{Extended BAM modes}
  xbSpeedDOS    = 0;
  xbDolphinDOS  = 1;
  xbPrologicDOS = 2;
{Extended disk modes}
  xtNever       = 0;
  xtAlways      = 1;
  xtDetect      = 2;
{Commodore disk drive job status codes}
  dsOK          = 1;
  ds20READ      = 2;
  ds21READ      = 3;
  ds22READ      = 4;
  ds23READ      = 5;
  ds24READ      = 6;
  ds25WRITE     = 7;
  ds26PROTECT   = 8;
  ds27READ      = 9;
  ds29DISKID    = 11;
  ds74NOTREADY  = 15;
  dsEmpty       = MaxByte;
{Warning messages}
  wmNone        = 0;
  wmMultiTasking= $0001;
  wmSerialLPT   = $0002;
  wmParallelLPT = $0004;
  wmExtendedLPT = $0008;
  wmHybridLPT   = $0010;
  wmBadFeature  = $0020;
{LPT port modes}
  pmNone        = 0;
  pmSPP         = 1;
  pmPS2         = 2;
  pmEPP         = 3;
  pmECP         = 4;
  pmUnknown     = $80;
{Into file image modes}
  ifNever       = 0;
  ifAlways      = 1;
  ifCBMSrc      = 2;
{Extract file image modes}
  xfNever       = 0;
  xfAlways      = 1;
  xfCBMDest     = 2;
{Shift key codes}
  skNone        = 0;
  skShift       = 1;
  skControl     = 2;
  skAlt         = 3;
  skUnknown     = MaxByte;
{Execution priority levels}
  plLow         = 0;
  plHigh        = 1;
{ZipCode archive sector types}
  zcTrackMask   = $3F;
  zcStored      = $00;
  zcHomogeneous = $40;
  zcPacked      = $80;
  zcFlagMask    = $C0;
{ZipCode archive read modes}
  zrNone        = 0;
  zrUncompress  = 1;
  zrOriginal    = 2;
{Drive interleave offsets}
  diNormalFiles = 0;
  diGEOSFiles   = 1;
  diSerialNormalRead = 2;
  diSerialNormalWrite = 3;
  diSerialTurboRead = 4;
  diSerialTurboWrite = 5;
  diAsyncTurboRead = 6;
  diAsyncTurboWrite = 7;
  diHybridTurboRead = 8;
  diHybridTurboWrite = 9;
  diParallelTurboRead = 10;
  diParallelTurboWrite = 11;
  diSerialWarpRead = 12;
  diSerialWarpWrite = 13;
  diAsyncWarpRead = 14;
  diAsyncWarpWrite = 15;
  diHybridWarpRead = 16;
  diHybridWarpWrite = 17;
  diParallelWarpRead = 18;
  diParallelWarpWrite = 19;
{All yes-style answers to confirmations}
  ayNone        = 0;
  ayAllYes      = 1;
  ayAllAllYes   = 2;
  ayAllNo       = 3;
{Skip buttons}
  sbNone        = 0;
  sbSkip        = 1;
  sbSkipAll     = 2;
{Setup file statuses}
  ssNone        = $00;
  ssMainOK      = $01;
  ssMainPrev    = $02;
  ssDriveOK     = $04;
  ssDrivePrev   = $08;
{Destinations for saving the setup}
  sdNone        = 0;
  sdFile        = 1;
  sdShellBuffer = 2;
{Character conversion modes}
  ccNone        = 0;
  ccInvalid     = 1;
  ccInvalidAndSpace = 2;
{Panel mode attribute bits}
  paNone        = $0000;
  paASCII       = $0001;
  paDirectories = $0002;
  paBackslash   = $0004;
  paCompressed  = $0008;
  paExternalArch= $0010;
  paDupeFiles   = $0020;
  paFileAttribs = $0040;
  paImage       = $0080;
  paArchive     = $0100;
  paReadOnly    = $0200;
{Track types}
  ttNormal      = 0;
  ttNormalF64   = 1;
  ttGCR         = 2;
  ttRaw         = 3;
{Invalid GCR code error}
  igNone        = 0;
  ig23READ      = 1;
  ig24READ      = 2;
{GCR map status}
  gmEmpty       = 0;
  gmCountMask   = $7F;
  gmSkipped     = $80;
{Async transfer modes}
  atNever       = 0;
  atAlways      = 1;
  atAuto        = 2;
{Panel sort modes}
  psName        = 0;
  psExt         = 1;
  psTime        = 2;
  psSize        = 3;
  psUnsorted    = 4;
  psModeMask    = $07;
  psReverse     = $40;
{Panel column modes}
  cmBrief       = 0;
  cmFull        = 1;
  cmWide        = 2;
  cmModeMask    = $03;
  cmDOSBrief    = 0;
  cmDOSFull     = 1;
  cmDOSWide     = 2;
  cmCBMBrief    = 0;
  cmCBMFull     = 4;
  cmCBMWide     = 4;
{Mini status modes}
  msOff         = 0;
  msBrief       = 1;
  msFull        = 2;
  msModeMask    = $03;
  msDOSOff      = 0;
  msDOSBrief    = 1;
  msDOSFull     = 2;
  msCBMOff      = 0;
  msCBMBrief    = 4;
  msCBMFull     = 8;
{Quick view modes}
  qvNone        = 0;
  qvNormal      = 1;
  qvDirCount    = 2;
  qvEmpty       = 3;
{Port mode detection modes}
  dpNone        = 0;
  dpAll         = 1;
  dpUsed        = 2;
  dpSafeAll     = 3;
  dpSafeUsed    = 4;
{Number of disk types}
  DiskTypeNum   = 3;
{Maximum number of really existing parallel ports}
  MaxRealPorts  = 3;
{Relaxation value for wired-in delays}
  RelaxDelay    = 4;
{Number of files in a diskpacked ZipCode archive}
  DiskZipFileNum= 5;
{Number of files in a sixpacked ZipCode archive}
  SixZipFileNum = 6;
{Soft interleave in sector data of sixpacked ZipCode archives}
  SixZipInterleave= 8;
{Sector header signature byte on 1541/1570/1571 disks}
  HeaderSign    = $08;
{Data block header signature byte on 1541/1570/1571 disks}
  SectorSign    = $07;
{Sector header padding byte on 1541/1570/1571 disks}
  HeaderPadding = $0F;
{First sector header padding byte on Dolphin DOS extended 1541 disks}
  HeaderPaddingDolphinExt= $0D;
{Data block padding byte on 1541/1570/1571 disks}
  SectorPadding = $00;
{Sector gap byte on 1541/1570/1571 disks}
  SectorGap     = $55;
{Minimum width for panels}
  MinPanelWidth = 10;
{Maximum number of items in a menu}
  MaxMenuItems  = 16;
{Maximum number of drives in the drive menu}
  MaxDrives     = 15;
{Default width of Name columns in DOS panels}
  DefDOSNameColWidth= 12;
{Minimum width of Name columns in DOS panels}
  MinDOSNameColWidth= 2;
{Default width of Name columns in CBM panels}
  DefCBMNameColWidth= CBMNameLen + 2;
{Minimum width of Name columns in CBM panels}
  MinCBMNameColWidth= 4;
{Maximum length of Commodore sector header ID's}
  CBMHeaderIDLen= 2;
{Maximum length of Commodore BAM ID's}
  CBMBAMIDLen   = 5;
{Maximum length of file names displayed in dialog boxes}
  MaxNameLen    = 64;
{Maximum length of program extension}
  MaxPrgExtLen  = 16;
{Number of GEOS file types}
  GEOSTypeNum   = 14;
{Minimal length of directory partition on 1581 disks, in tracks}
  MinDiskDirSize= 3;
{Default number of entries in tape image directory}
  DefTapeDirSize= 30;
{Maximum number of entries in tape image directory}
  MaxTapeDirSize= 500;
{Position of first side sector link in side sectors}
  SideListStart = $04;
{Position of first side sector group link in super side sectors}
  SuperSideListStart= $03;
{Position of first data sector link in side sectors}
  SideSecStart  = $10;
{Maximum number of data sector links per side sectors}
  SideSecSize   = (256 - SideSecStart) div 2;
{Maximum number of side sectors per group}
  SideSecPerGroup= 6;
{Offset of the entry offset table in the online help file}
  HelpTableStart= 36;
{Number of colors in Commodore and PC (EGA) palette}
  ColorNum      = 16;
{Character indicating the start of a PETSCII substring in an ASCII string}
  PETSCIIStart  = #1;
{Number of hard interleaves}
  DriveIntNum   = 20;
{Maximum soft interleave}
  MaxImageInt   = 20;
{Maximum hard interleave}
  MaxDriveInt   = 20;
{Maximum number for retrying bad sectors}
  MaxRetryNum   = $3F;
{Length of online help file header}
  HelpHeaderLen = 320;
{Number of entries in the help file}
  HelpEntryNum  = 73;
{Number of INT 08 ticks to pass after switching off the turbo loader when
  CLK is set back to low}
  TurboOffTicks = 18;
{Number of INT 08 ticks in a quarter of a second}
  QuarterTicks  = 4;
{Number of INT 08 ticks in a minute}
  MinuteTicks   = 1091;
{Maximum number of stars in the screen saver}
  SaverStarMax  = 32;
{Maximum number of entries in tape images that can be handled by C64S}
  MaxC64STapeEntries= 64;
{Position of disk name in the BAM}
  DiskName1541Pos= $90;
  DiskName1541ExtPrologicPos= $A4;
  DiskName1581Pos= $04;
{Relative position of disk ID, after disk name, in the BAM}
  DiskIDRelPos  = $12;
{Position of GEOS border sector pointer in the BAM}
  GEOSBorderPos = $AB;
{Position of GEOS format signature in the BAM}
  GEOSSignPos   = $AD;
{Maximum number of blocks stored in a filepacked ZipCode archive file}
  FileZipBlocks = 166;
{Maximum number of files in a panel}
  MaxFiles      = 512;
{Maximum number of tracks plus 1 on a normal 1541 disk}
  Max1541Tracks = 36;
{Maximum number of sectors per track}
  TrackMapSize  = 40;
{Maximum number of locations in the location buffer}
  MaxLocations  = 3200;
{Size of the LHA self-extractor program}
  LHAExtractLen = 3721;
{Offset of directory block count in the Lynx archive header}
  LynxBlockPos  = 95;
{Length of the Lynx archive header}
  LynxHeaderLen = 124;
{Length of the filepacked ZipCode archive directory lister}
  ZipHeaderLen  = 410;
{Size of the directory buffer of the disk editor}
  DirBufferLen  = 512;
{Size of temporary buffers}
  TempBufferSize= 10240;
{Size of the small copy buffer; must be a multiple of both 254 and 256}
  TSmallBufSize = $7F00;
{Size of the copy buffer; must be a multiple of both 254 and 256}
  TBufferSize   = $FE00;
{Size of the custom drive routine patch buffer}
  TPatchBufSize = 1024;
{Default attributes for files in TAR archives}
  DefTARAttr    = $01B6;
{Signature for ZIP archives, central directory entry}
  ZIPCDirSign   = $02014B50;
{Signature for ZIP archives, directory entry}
  ZIPDirSign    = $04034B50;
{Signature for ZIP archives, end of central directory entry}
  ZIPCDirEndSign= $06054B50;
{Default offset of ECP extended port address from base port address}
  DefECPAddrOffs= $0400;
{Default timezone}
  DefTimeZone   = 5;
{Default code page for US English}
  CodePageUS    = 437;
{Starting year of valid dates under DOS}
  DOSYearEpoch  = 1980;
{Ending year of valid dates under DOS}
  DOSYearEnd    = 2107;
{Starting year of valid dates under Unix}
  UnixYearEpoch = 1970;
{Default centuries for dates}
  OldCentury    = 1900;
  NewCentury    = 2000;
{Lower limit for years, specified without century, in the old century}
  OldYearLimit  = (DOSYearEpoch - OldCentury);
{Days between Unix and DOS epoch}
  EpochDiffDays = 3652;
{Seconds per a minute}
  SecPerMin     = 60;
{Minutes per an hour}
  MinPerHour    = 60;
{Hours per a day}
  HourPerDay    = 24;
{Days per week}
  DayPerWeek    = 7;
{Days per a (non-leap) year}
  DayPerYear    = 365;
{Days per a leap year}
  DayPerLeapYear= 366;
{Days per four years, the period of leap years}
  DayPerFourYear= 1461;
{Months of the year}
  moZero        = 0;
  moJanuary     = 1;
  moFebruary    = 2;
  moMarch       = 3;
  moApril       = 4;
  moMay         = 5;
  moJune        = 6;
  moJuly        = 7;
  moAugust      = 8;
  moSeptember   = 9;
  moOctober     = 10;
  moNovember    = 11;
  moDecember    = 12;
{Days of the week}
  daSunday      = 0;
  daMonday      = 1;
  daTuesday     = 2;
  daWednesday   = 3;
  daThursday    = 4;
  daFriday      = 5;
  daSaturday    = 6;
{Days per a month}
  DayPerMonth   : array [moJanuary..moDecember] of Word = (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
{Number of first days of months}
  MonthFirstDay : array [moZero..moDecember] of Word = (0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365);
{Months per a year}
  MonthPerYear  = 12;
{Date formats}
  dfMMDDYY      = 0;
  dfDDMMYY      = 1;
  dfYYMMDD      = 2;
{ISO date separator}
  ISODateSep    = '-';
{ISO time separator}
  ISOTimeSep    = ':';
{Prefix for hexadecimal numbers}
  HexaPrefix    = '$';
{Command line prefix for script files}
  ScriptPrefix  = '@';
{Batch prefix for environment variables}
  ScriptEnvVarPrefix= '%';
{Prefix character for comments in script files}
  BatchComment  = '#';
{Prefix character for comments in menu and extension files}
  MenuComment   = '''';
{Hexadecimal code prefixes}
  hxNone        = #0;
  hxPercent     = '%';
  hxDollar      = '$';
{Palette of the empty menu bar}
  CFalseMenu    = #8;
{Palette of the screen saver}
  CScreenSaver  = #37#38;
{Palette of the clock}
  CClock        = #35;
{Palette of the configuration menu reminder}
  CConfigText   = #1#3;
{Environment variable to force the path of the Commander home directory}
  HomePathEnvVar= 'SC';
{File name of setup file}
  ConfigFileName= 'sc.ini';
{File name of drive setup file}
  DriveCfgFileName= 'scdrive.ini';
{File name of help file}
  HelpFileName  = 'sc.hlp';
{File name of main user menu file}
  UserMenuFileName= 'sc.mnu';
{File name of image menu file}
  ImageMenuFileName= 'scimage.mnu';
{File name of list file containing the names of selected files in the active
  panel}
  ActSelListFileName= 'sc.lst';
{File name of list file containing the names of selected files in the
  inactive panel}
  InactSelListFileName= 'sc2.lst';
{Extension of main files}
  MenuFileExt   = 'mnu';
{Extension of palette files}
  PaletteFileExt= '.pal';
{File name of main extension file}
  ExtensionFileName= 'sc.ext';
{File name of viewer extension file}
  ViewerExtFileName= 'scview.ext';
{File name of editor extension file}
  EditorExtFileName= 'scedit.ext';
{File name of internal viewer}
  ViewerPrgFileName= 'scview.exe';
{File name of internal editor}
  EditorPrgFileName= 'scedit.exe';
{Default label for tape images}
  DefTapeTitle  = 'imported files';
{Characters representing the different phases of the screen saver stars}
  StarChars     : string[6] = #250#249#7#4#15#32;
{Signature of GEOS-formatted disks}
  GEOSSign      : string[16] = 'GEOS format V1.0';
{Signature for file image header}
  PC64Sign      : string[8] = 'C64File' + #0;
{Signature for LHA archives}
  LHASign       : string[3] = '-lh';
{Signature for ZIP archives}
  ZIPSign       : string[4] = 'PK'#5#6;
{Hexadecimal digits}
  HexaNum       : string[16] = '0123456789ABCDEF';
{Setup file signature}
  ConfigSign    : string[37] = TitleStr + ' 0.83 setup file' + chCR + chLF + chEOF;
{Setup file signature of the previous release}
  PrevConfigSign: string[37] = TitleStr + ' 0.82 setup file' + chCR + chLF + chEOF;
{Drive setup file signature}
  DriveCfgSign  : string[43] = TitleStr + ' 0.83 drive setup file' + chCR + chLF + chEOF;
{Drive setup file signature ofg the previous release}
  PrevDriveCfgSign: string[43] = TitleStr + ' 0.82 drive setup file' + chCR + chLF + chEOF;
{Help file signature}
  HelpSign      : string[36] = TitleStr + ' 0.83 help file' + chCR + chLF + chEOF;
{Signature for Norton Commander-style parameter block}
  SochaSign     : array [0..8] of Char = #0'Socha'#0#$1F#1;
{Characters that are invalid in DOS file names, causing the file name to be
  enclosed into quotation marks}
  InvFileNameChars= ' ,;=+[]|';
{String constants}
  stEmpty       : string[1]  = '';
  stAllFilesDOS : string[3]  = '*.*';
  stAllFilesUnix: string[1]  = '*';
  stCurrentDir  : string[1]  = '.';
  stParentDir   : string[2]  = '..';
  stWinRootDir  : string[2]  = '...';
  stSpace       : string[1]  = ' ';
  stAsterisk    : string[1]  = '*';
  stDot         : string[1]  = '.';
  stFile        : string[4]  = 'file';
  stDirectory   : string[9]  = 'directory';
  stCancel      : string[10] = ' '+ColorChar+'C'+ColorChar+'ancel ';
  stOK          : string[6]  = ' '+ColorChar+'O'+ColorChar+'k ';
  stYes         : string[7]  = ' '+ColorChar+'Y'+ColorChar+'es ';
  stNo          : string[6]  = ' '+ColorChar+'N'+ColorChar+'o ';
  stAll         : string[7]  = ' '+ColorChar+'A'+ColorChar+'ll ';
  stSkip        : string[8]  = ' '+ColorChar+'S'+ColorChar+'kip ';
  stSkipAll     : string[12] = ' s'+ColorChar+'K'+ColorChar+'ip all ';
  stAbort       : string[9]  = ' '+ColorChar+'A'+ColorChar+'bort ';
  stDelete      : string[10] = ' '+ColorChar+'D'+ColorChar+'elete ';
  stOverwrite   : string[13] = ' '+ColorChar+'O'+ColorChar+'verwrite ';
  stReset       : string[9]  = ' '+ColorChar+'R'+ColorChar+'eset ';
  stRetry       : string[9]  = ' '+ColorChar+'R'+ColorChar+'etry ';
  stSave        : string[8]  = ' '+ColorChar+'S'+ColorChar+'ave ';
  stWrite       : string[9]  = ' '+ColorChar+'W'+ColorChar+'rite ';
  stError       : string[5]  = 'Error';
  stDoYouStillWishToContinue: string[30] = 'Do you still wish to continue?';
  stTheFollowing: string[14] = 'The following ';
  stIsInvalid   : string[11] = ' is invalid';
{Linear number of first sector in each diskpacked ZipCode archive file}
  DiskZipBlocks : array [0..DiskZipFileNum - 1] of Word = (0, 168, 336, 508, 683);
{Linear number of first sector in each sixpacked ZipCode archive file}
  SixZipBlocks  : array [0..SixZipFileNum - 1] of Word = (0, 126, 252, 376, 508, 632);
{Number of first track in each sixpacked ZipCode archive file}
  SixZipTracks  : array [0..SixZipFileNum - 1] of Byte = (1, 7, 13, 19, 26, 33);
{Conversion table for actual drive types}
  ExtDriveTypes : array [xd1541..xd157xEmu] of Byte = (dt1541, dt1571, dt1581, dt1571, dt1541);
{Conversion table for actual disk types}
  ExtDiskTypes : array [xd1541..xd157xEmu] of Byte = (dt1541, dt1571, dt1581, dt1541, dt1541);
{Default soft interleaves for disk images}
  DefImageInts  : array [0..(DiskTypeNum * 2) - 1] of Byte =
                  (10, 8, 6, 6, 1, 1);
{Default soft and hard interleaves for external drives}
  DefDriveInts  : array [0..DiskTypeNum - 1, 0..DriveIntNum - 1] of Byte =
                  ((10, 8, 8, 8, 12, 11, 14, 12, 8, 6, 6, 6, 0, 10, 0, 11, 0, 3, 0, 3),
                   (6, 6, 1, 1, 6, 7, 7, 7, 4, 4, 2, 4, 0, 5, 0, 6, 0, 3, 0, 3),
                   (1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
{Indents for the hexadecimal mode of the viewer, the editor and the disk
  editor}
  HexIndent     : array [0..16] of Byte = (0, 3, 6, 9, 13, 16, 19, 22, 26, 29, 32, 35, 39, 42, 45, 48, 53);
{CBM extensions}
  ShortCBMExt   : array [0..faTypeMask] of TFileExtStr = ('del', 'seq', 'prg', 'usr', 'rel', '???', '???', '???');
{GEOS extensions}
  ShortGEOSExt  : array [1..GEOSTypeNum] of TFileExtStr = ('bas', 'asm', 'dat', 'sys', 'acc', 'app', 'doc', 'fnt', 'prn',
                  'inp', 'dsk', 'bot', 'tmp', 'aut');
{Image file extensions}
  DOSExt        : array [pmDOS..pmSixZip] of TFileExtStr =
    ('', '', '', 't64', '', '', 'lnx', 'ark', 'tar', 'lzh', 'zip', '', 'g64', '', '');
{Disk image extensions}
  DiskExt       : array [0..DiskTypeNum - 1] of TFileExtStr = ('d64', 'd71', 'd81');
{Extension of FCOPY data files}
  FCOPYExt      : string[3] = 'f64';
{Critical error strings}
  ceWriteProtected: string[40] = 'Attempt to write on write-protected disk';
  ceCriticalError:  string[18] = 'Unknown disk drive';
  ceDiskNotReady:  string[25] = 'Drive or device not ready';
  ceUnknownCommand: string[15] = 'Unknown command';
  ceDataIntegrity:  string[10] = 'Data error';
  ceBadRequest  :  string[11] = 'Bad request';
  ceSeekError   :  string[10] = 'Seek error';
  ceUnknownMedia:  string[12] = 'Non-DOS disk';
  ceSectorNotFound: string[16] = 'Sector not found';
  ceOutOfPaper  :  string[20] = 'Printer out of paper';
  ceWriteFault  :  string[11] = 'Write fault';
  ceReadFault   :  string[10] = 'Read fault';
  ceGeneralFailure: string[15] = 'General failure';
  ceShareViolation: string[17] = 'Sharing violation';
  ceLockViolation:  string[14] = 'Lock violation';
  ceInvDiskChange:  string[19] = 'Invalid disk change';
  ceFCBUnavailable: string[15] = 'FCB unavailable';
  ceShareBufOver:  string[23] = 'Sharing buffer overflow';
  ceCPMismatch  :  string[18] = 'Code page mismatch';
  ceOutOfInput  :  string[12] = 'Out of input';
  ceInsufDiskSpace: string[23] = 'Insufficient disk space';
  ceUnknownError:  string[13] = 'Unknown error';
  ceFATBad      :  string[25] = 'File allocation table bad';
  ErrorString:     array [0..22] of Word = (
    Ofs(ceWriteProtected),
    Ofs(ceCriticalError),
    Ofs(ceDiskNotReady),
    Ofs(ceUnknownCommand),
    Ofs(ceDataIntegrity),
    Ofs(ceBadRequest),
    Ofs(ceSeekError),
    Ofs(ceUnknownMedia),
    Ofs(ceSectorNotFound),
    Ofs(ceOutOfPaper),
    Ofs(ceWriteFault),
    Ofs(ceReadFault),
    Ofs(ceGeneralFailure),
    Ofs(ceShareViolation),
    Ofs(ceLockViolation),
    Ofs(ceInvDiskChange),
    Ofs(ceFCBUnavailable),
    Ofs(ceShareBufOver),
    Ofs(ceCPMismatch),
    Ofs(ceOutOfInput),
    Ofs(ceInsufDiskSpace),
    Ofs(ceUnknownError),
    Ofs(ceFATBad));
{Panel mode attributes}
  PanelModeAttribs: array [pmDOS..pmSixZip] of Word =
    (paASCII + paFileAttribs,
     paFileAttribs,
     paDupeFiles + paFileAttribs + paImage,
     paFileAttribs + paImage,
     paImage,
     paASCII,
     paDupeFiles + paArchive,
     paDupeFiles + paArchive,
     paASCII + paDirectories + paArchive,
     paASCII + paDirectories + paBackslash + paCompressed + paExternalArch + paArchive,
     paASCII + paDirectories + paCompressed + paExternalArch + paArchive,
     paCompressed + paDupeFiles + paArchive,
     paDupeFiles + paImage + paReadOnly,
     paCompressed + paDupeFiles + paArchive + paReadOnly,
     paCompressed + paDupeFiles + paArchive + paReadOnly);
{Transfer routines (send byte, receive byte, receive block) in the external
  drive programs for each cable}
  TransferPrgs : array [0..2, cmSerial..cmParallel] of Byte =
    ((deTurboSend, deAsyncSend, deHybridSend, deParallelSend),
     (deTurboReceive, deAsyncReceive, deParallelReceive, deParallelReceive),
     (deTurboReceiveBlk, deAsyncReceiveBlk, deParallelReceiveBlk, deParallelReceiveBlk));
const
{Relative offsets of transfer routines (send, receive and block receive) in
  each external drive program, divided by $10; 0, if transfer routine not
  needed}
  TransferOfs   : array [0..2, 0..2 * deEntryNum - 1] of Byte =
    (($00, $05, $10, $10, $11, $00, $15, $19,
      $23, $00, $0F, $27, $00, $11, $00, $1B,
      $00, $14, $1F, $00, $00, $00,
      $00, $00, $00, $00, $00, $00, $00, $00,
      $00, $00, $00,
      $00, $00, $00, $08, $00, $00, $00, $00,
      $00, $00, $00, $00, $00, $00, $00, $16,
      $00, $07, $00, $00, $00, $00,
      $00, $00, $00, $00, $00, $00, $00, $00,
      $00, $00, $00),
     ($00, $00, $00, $00, $00, $00, $11, $00,
      $00, $00, $00, $00, $15, $00, $00, $1F,
      $00, $10, $1B, $0F, $11, $00,
      $03, $00, $00, $00, $00, $00, $00, $00,
      $00, $00, $00,
      $00, $00, $00, $00, $00, $00, $00, $00,
      $00, $00, $00, $00, $00, $00, $00, $12,
      $00, $0B, $00, $00, $00, $00,
      $03, $00, $00, $00, $00, $00, $00, $00,
      $00, $00, $00),
     ($00, $00, $00, $00, $00, $00, $00, $00,
      $00, $00, $00, $00, $00, $00, $00, $00,
      $00, $00, $00, $13, $15, $00,
      $00, $00, $00, $00, $00, $00, $00, $00,
      $00, $00, $00,
      $00, $00, $00, $00, $00, $00, $00, $00,
      $00, $00, $00, $00, $00, $00, $00, $00,
      $00, $00, $00, $00, $00, $00,
      $00, $00, $00, $00, $00, $00, $00, $00,
      $00, $00, $00));
{Offsets of the entry point in each external drive program, divided by $10}
  TransferExecs : array [0..2 * deEntryNum - 1] of Byte =
    ($00, $52, $50, $55, $57, $40, $5E, $64,
     $62, $40, $56, $5F, $5A, $56, $40, $53,
     $40, $56, $61, $56, $58, $00,
     $16, $00, $00, $00, $00, $00, $00, $00,
     $00, $00, $00,
     $00, $00, $00, $50, $00, $00, $00, $00,
     $00, $00, $00, $00, $00, $00, $00, $57,
     $00, $50, $00, $00, $00, $00,
     $30, $00, $00, $00, $00, $00, $00, $00,
     $00, $00, $00);
{Decode table for high GCR nybbles}
  GCRDecodeTableHi: array [$00..$1F] of Byte = (
    $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
    $FF, $80, $00, $10, $FF, $C0, $40, $50,
    $FF, $FF, $20, $30, $FF, $F0, $60, $70,
    $FF, $90, $A0, $B0, $FF, $D0, $E0, $FF);
{Decode table for low GCR nybbles}
  GCRDecodeTableLo: array [$00..$1F] of Byte = (
    $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
    $FF, $08, $00, $01, $FF, $0C, $04, $05,
    $FF, $FF, $02, $03, $FF, $0F, $06, $07,
    $FF, $09, $0A, $0B, $FF, $0D, $0E, $FF);
{GCR-encode table}
  GCREncodeTable: array [$00..$0F] of Byte = (
    $0A, $0B, $12, $13, $0E, $0F, $16, $17,
    $09, $19, $1A, $1B, $0D, $1D, $1E, $15);
{Template conversion table}
{  ConvTable     : array [0..255] of Byte = (
    $00, $01, $02, $03, $04, $05, $06, $07, $08, $09, $0A, $0B, $0C, $0D, $0E, $0F,
    $10, $11, $12, $13, $14, $15, $16, $17, $18, $19, $1A, $1B, $1C, $1D, $1E, $1F,
    $20, $21, $22, $23, $24, $25, $26, $27, $28, $29, $2A, $2B, $2C, $2D, $2E, $2F,
    $30, $31, $32, $33, $34, $35, $36, $37, $38, $39, $3A, $3B, $3C, $3D, $3E, $3F,
    $40, $41, $42, $43, $44, $45, $46, $47, $48, $49, $4A, $4B, $4C, $4D, $4E, $4F,
    $50, $51, $52, $53, $54, $55, $56, $57, $58, $59, $5A, $5B, $5C, $5D, $5E, $5F,
    $60, $61, $62, $63, $64, $65, $66, $67, $68, $69, $6A, $6B, $6C, $6D, $6E, $6F,
    $70, $71, $72, $73, $74, $75, $76, $77, $78, $79, $7A, $7B, $7C, $7D, $7E, $7F,
    $80, $81, $82, $83, $84, $85, $86, $87, $88, $89, $8A, $8B, $8C, $8D, $8E, $8F,
    $90, $91, $92, $93, $94, $95, $96, $97, $98, $99, $9A, $9B, $9C, $9D, $9E, $9F,
    $A0, $A1, $A2, $A3, $A4, $A5, $A6, $A7, $A8, $A9, $AA, $AB, $AC, $AD, $AE, $AF,
    $B0, $B1, $B2, $B3, $B4, $B5, $B6, $B7, $B8, $B9, $BA, $BB, $BC, $BD, $BE, $BF,
    $C0, $C1, $C2, $C3, $C4, $C5, $C6, $C7, $C8, $C9, $CA, $CB, $CC, $CD, $CE, $CF,
    $D0, $D1, $D2, $D3, $D4, $D5, $D6, $D7, $D8, $D9, $DA, $DB, $DC, $DD, $DE, $DF,
    $E0, $E1, $E2, $E3, $E4, $E5, $E6, $E7, $E8, $E9, $EA, $EB, $EC, $ED, $EE, $EF,
    $F0, $F1, $F2, $F3, $F4, $F5, $F6, $F7, $F8, $F9, $FA, $FB, $FC, $FD, $FE, $FF);}
{PETSCII lowercase/uppercase to ASCII converter table}
  PETtoASCLower : array [0..255] of Byte = (
    $40, $61, $62, $63, $64, $65, $66, $67, $68, $69, $6A, $6B, $6C, $6D, $6E, $6F,
    $70, $71, $72, $73, $74, $75, $76, $77, $78, $79, $7A, $5B, $9C, $5D, $18, $1B,
    $20, $21, $22, $23, $24, $25, $26, $27, $28, $29, $2A, $2B, $2C, $2D, $2E, $2F,
    $30, $31, $32, $33, $34, $35, $36, $37, $38, $39, $3A, $3B, $3C, $3D, $3E, $3F,
    $40, $61, $62, $63, $64, $65, $66, $67, $68, $69, $6A, $6B, $6C, $6D, $6E, $6F,
    $70, $71, $72, $73, $74, $75, $76, $77, $78, $79, $7A, $5B, $9C, $5D, $18, $1B,
    $C4, $41, $42, $43, $44, $45, $46, $47, $48, $49, $4A, $4B, $4C, $4D, $4E, $4F,
    $50, $51, $52, $53, $54, $55, $56, $57, $58, $59, $5A, $C5, $B0, $B3, $B0, $B1,
    $C4, $41, $42, $43, $44, $45, $46, $47, $48, $49, $4A, $4B, $4C, $4D, $4E, $4F,
    $50, $51, $52, $53, $54, $55, $56, $57, $58, $59, $5A, $C5, $B0, $B3, $B0, $B1,
    $5F, $DD, $DC, $C4, $C4, $B3, $B0, $B3, $B0, $B0, $B3, $C3, $DA, $C0, $BF, $C4,
    $DA, $C1, $C2, $B4, $B3, $DD, $DE, $C4, $DF, $DC, $FB, $BF, $C0, $D9, $D9, $C5,
    $C4, $41, $42, $43, $44, $45, $46, $47, $48, $49, $4A, $4B, $4C, $4D, $4E, $4F,
    $50, $51, $52, $53, $54, $55, $56, $57, $58, $59, $5A, $C5, $B0, $B3, $B0, $B1,
    $5F, $DD, $DC, $C4, $C4, $B3, $B0, $B3, $B0, $B0, $B3, $C3, $DA, $C0, $BF, $C4,
    $DA, $C1, $C2, $B4, $B3, $DD, $DE, $C4, $DF, $DC, $FB, $BF, $C0, $D9, $D9, $B0);
{PETSCII uppercase/graphics to ASCII converter table}
  PETtoASCUpper : array [0..255] of Byte = (
    $40, $41, $42, $43, $44, $45, $46, $47, $48, $49, $4A, $4B, $4C, $4D, $4E, $4F,
    $50, $51, $52, $53, $54, $55, $56, $57, $58, $59, $5A, $5B, $9C, $5D, $18, $1B,
    $20, $21, $22, $23, $24, $25, $26, $27, $28, $29, $2A, $2B, $2C, $2D, $2E, $2F,
    $30, $31, $32, $33, $34, $35, $36, $37, $38, $39, $3A, $3B, $3C, $3D, $3E, $3F,
    $40, $41, $42, $43, $44, $45, $46, $47, $48, $49, $4A, $4B, $4C, $4D, $4E, $4F,
    $50, $51, $52, $53, $54, $55, $56, $57, $58, $59, $5A, $5B, $9C, $5D, $18, $1B,
    $C4, $06, $B3, $C4, $C4, $C4, $C4, $B3, $B3, $BF, $C0, $D9, $C0, $5C, $2F, $DA,
    $BF, $07, $C4, $03, $B3, $DA, $58, $6F, $05, $B3, $04, $C5, $B0, $B3, $E3, $5C,
    $C4, $06, $B3, $C4, $C4, $C4, $C4, $B3, $B3, $BF, $C0, $D9, $C0, $5C, $2F, $DA,
    $BF, $07, $C4, $03, $B3, $DA, $58, $6F, $05, $B3, $04, $C5, $B0, $B3, $E3, $5C,
    $5F, $DD, $DC, $C4, $C4, $B3, $B0, $B3, $B0, $2F, $B3, $C3, $DA, $C0, $BF, $C4,
    $DA, $C1, $C2, $B4, $B3, $DD, $DE, $C4, $DF, $DC, $D9, $BF, $C0, $D9, $D9, $C5,
    $C4, $06, $B3, $C4, $C4, $C4, $C4, $B3, $B3, $BF, $C0, $D9, $C0, $5C, $2F, $DA,
    $BF, $07, $C4, $03, $B3, $DA, $58, $6F, $05, $B3, $04, $C5, $B0, $B3, $E3, $5C,
    $5F, $DD, $DC, $C4, $C4, $B3, $B0, $B3, $B0, $2F, $B3, $C3, $DA, $C0, $BF, $C4,
    $DA, $C1, $C2, $B4, $B3, $DD, $DE, $C4, $DF, $DC, $D9, $BF, $C0, $D9, $D9, $E3);
{PETSCII lowercase/uppercase to extended ASCII converter table (used when the
  C64 character set is on)}
  PETtoExtLower : array [0..255] of Byte = (
    $40, $61, $62, $63, $64, $65, $66, $67, $68, $69, $6A, $6B, $6C, $6D, $6E, $6F,
    $70, $71, $72, $73, $74, $75, $76, $77, $78, $79, $7A, $5B, $A9, $5D, $18, $1B,
    $20, $21, $22, $23, $24, $25, $26, $27, $28, $29, $2A, $2B, $2C, $2D, $2E, $2F,
    $30, $31, $32, $33, $34, $35, $36, $37, $38, $39, $3A, $3B, $3C, $3D, $3E, $3F,
    $40, $61, $62, $63, $64, $65, $66, $67, $68, $69, $6A, $6B, $6C, $6D, $6E, $6F,
    $70, $71, $72, $73, $74, $75, $76, $77, $78, $79, $7A, $5B, $A9, $5D, $18, $1B,
    $80, $41, $42, $43, $44, $45, $46, $47, $48, $49, $4A, $4B, $4C, $4D, $4E, $4F,
    $50, $51, $52, $53, $54, $55, $56, $57, $58, $59, $5A, $9B, $9C, $9D, $AA, $AB,
    $80, $41, $42, $43, $44, $45, $46, $47, $48, $49, $4A, $4B, $4C, $4D, $4E, $4F,
    $50, $51, $52, $53, $54, $55, $56, $57, $58, $59, $5A, $9B, $9C, $9D, $AA, $AB,
    $E0, $E1, $E2, $E3, $E4, $E5, $E6, $E7, $E8, $AC, $EA, $EB, $EC, $ED, $EE, $EF,
    $F0, $F1, $F2, $F3, $F4, $F5, $F6, $F7, $A0, $A1, $FB, $A3, $A4, $A5, $A6, $A7,
    $80, $41, $42, $43, $44, $45, $46, $47, $48, $49, $4A, $4B, $4C, $4D, $4E, $4F,
    $50, $51, $52, $53, $54, $55, $56, $57, $58, $59, $5A, $9B, $9C, $9D, $AA, $AB,
    $E0, $E1, $E2, $E3, $E4, $E5, $E6, $E7, $E8, $AC, $EA, $EB, $EC, $ED, $EE, $EF,
    $F0, $F1, $F2, $F3, $F4, $F5, $F6, $F7, $A0, $A1, $FB, $A3, $A4, $A5, $A6, $AA);
{PETSCII uppercase/graphics to extended ASCII converter table (used when the
  C64 character set is on)}
  PETtoExtUpper : array [0..255] of Byte = (
    $40, $41, $42, $43, $44, $45, $46, $47, $48, $49, $4A, $4B, $4C, $4D, $4E, $4F,
    $50, $51, $52, $53, $54, $55, $56, $57, $58, $59, $5A, $5B, $A9, $5D, $18, $1B,
    $20, $21, $22, $23, $24, $25, $26, $27, $28, $29, $2A, $2B, $2C, $2D, $2E, $2F,
    $30, $31, $32, $33, $34, $35, $36, $37, $38, $39, $3A, $3B, $3C, $3D, $3E, $3F,
    $40, $41, $42, $43, $44, $45, $46, $47, $48, $49, $4A, $4B, $4C, $4D, $4E, $4F,
    $50, $51, $52, $53, $54, $55, $56, $57, $58, $59, $5A, $5B, $A9, $5D, $18, $1B,
    $80, $81, $82, $83, $84, $85, $86, $87, $88, $89, $8A, $8B, $8C, $8D, $8E, $8F,
    $90, $91, $92, $93, $94, $95, $96, $97, $98, $99, $9A, $9B, $9C, $9D, $9E, $9F,
    $80, $81, $82, $83, $84, $85, $86, $87, $88, $89, $8A, $8B, $8C, $8D, $8E, $8F,
    $90, $91, $92, $93, $94, $95, $96, $97, $98, $99, $9A, $9B, $9C, $9D, $9E, $9F,
    $E0, $E1, $E2, $E3, $E4, $E5, $E6, $E7, $E8, $E9, $EA, $EB, $EC, $ED, $EE, $EF,
    $F0, $F1, $F2, $F3, $F4, $F5, $F6, $F7, $A0, $A1, $A2, $A3, $A4, $A5, $A6, $A7,
    $80, $81, $82, $83, $84, $85, $86, $87, $88, $89, $8A, $8B, $8C, $8D, $8E, $8F,
    $90, $91, $92, $93, $94, $95, $96, $97, $98, $99, $9A, $9B, $9C, $9D, $9E, $9F,
    $E0, $E1, $E2, $E3, $E4, $E5, $E6, $E7, $E8, $E9, $EA, $EB, $EC, $ED, $EE, $EF,
    $F0, $F1, $F2, $F3, $F4, $F5, $F6, $F7, $A0, $A1, $A2, $A3, $A4, $A5, $A6, $9E);
{ASCII to PETSCII converter table}
  ASCtoPET      : array [0..255] of Byte = (
    $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20,
    $20, $20, $20, $20, $20, $20, $20, $20, $5E, $20, $20, $5F, $20, $20, $20, $20,
    $20, $21, $22, $23, $24, $25, $26, $27, $28, $29, $2A, $2B, $2C, $2D, $2E, $2F,
    $30, $31, $32, $33, $34, $35, $36, $37, $38, $39, $3A, $3B, $3C, $3D, $3E, $3F,
    $40, $C1, $C2, $C3, $C4, $C5, $C6, $C7, $C8, $C9, $CA, $CB, $CC, $CD, $CE, $CF,
    $D0, $D1, $D2, $D3, $D4, $D5, $D6, $D7, $D8, $D9, $DA, $5B, $CD, $5D, $5E, $A0,
    $20, $41, $42, $43, $44, $45, $46, $47, $48, $49, $4A, $4B, $4C, $4D, $4E, $4F,
    $50, $51, $52, $53, $54, $55, $56, $57, $58, $59, $5A, $5B, $DD, $5D, $2D, $20,
    $C3, $55, $45, $41, $41, $41, $41, $43, $45, $45, $45, $49, $49, $49, $C1, $C1,
    $C5, $41, $C1, $4F, $4F, $4F, $55, $55, $59, $CF, $D5, $43, $5C, $D9, $20, $20,
    $41, $45, $4F, $55, $4E, $CE, $20, $20, $3F, $20, $20, $20, $20, $21, $20, $20,
    $A6, $A6, $A6, $DD, $B3, $B3, $B3, $AE, $AE, $B3, $A6, $AE, $BD, $BD, $BD, $AE,
    $AD, $B1, $B2, $AB, $C0, $DB, $AB, $AB, $AD, $B0, $B1, $B2, $AB, $C0, $DB, $B1,
    $B1, $B2, $B2, $AD, $AD, $B0, $B0, $DB, $DB, $BD, $B0, $20, $A2, $A1, $B6, $B8,
    $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20,
    $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $BA, $20, $20, $20, $20);
{Table of PETSCII characters that have an exact ASCII equivalent}
  PETequivASC   : set of Byte = [
    $20, $21, $22, $23, $24, $25, $26, $27, $28, $29, $2A, $2B, $2C, $2D, $2E, $2F,
    $30, $31, $32, $33, $34, $35, $36, $37, $38, $39, $3A, $3B, $3C, $3D, $3E, $3F,
    $40, $41, $42, $43, $44, $45, $46, $47, $48, $49, $4A, $4B, $4C, $4D, $4E, $4F,
    $50, $51, $52, $53, $54, $55, $56, $57, $58, $59, $5A, $5B, $5C, $5D, $5E, $5F,
         $A1, $A2,                                         $AB,      $AD, $AE,
    $B0, $B1, $B2, $B3,                     $B8,      $BA,           $BD,
    $C0, $C1, $C2, $C3, $C4, $C5, $C6, $C7, $C8, $C9, $CA, $CB, $CC, $CD, $CE, $CF,
    $D0, $D1, $D2, $D3, $D4, $D5, $D6, $D7, $D8, $D9, $DA, $DB,      $DD          ];

implementation
end.
