
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                   DOSSHELL.PAS                  }
{                                                 }
{        The Star Commander DOS shell unit        }
{*************************************************}

unit DOSShell;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

procedure EnterDOSShell;

implementation

uses
  App, DOS, Drivers, Memory, Views,
  Base1, Base2, Config, Constant, ExtFiles, LowLevel, MiscFunc, OpenCBM, Panel1, Panel2, Reinit, Script;

{Display a prompt before switching back to 80 column text mode}
procedure SwitchPrompt; far;
begin
  PrintStr('Press ENTER to return' + chCR + chLF + 'to ' + TitleStr + chCR + chLF);
  asm
    push bp;
    mov ax, $1130;
    xor bh, bh;
    call VideoInt;
    mov ah, 2;
    xor bh, bh;
    mov dh, dl;
    inc dh;
    xor dl, dl;
    call VideoInt;
    pop bp;
@1: mov ax, $0700;
    int $21;
    cmp al, chCR;
    jne @1;
  end;
end;

procedure EnterDOSShell;
var
  F,
  O             : Boolean;
  B             : Byte;
  I,
  J             : Word;
  P,
  S,
  T             : string;
  E             : TEvent;
begin
  ShellBuffer^.QuitProgram := False;
  ShellBuffer^.Single := SingleCommand;
  ShellBuffer^.CommandOutput := CommandOutput;
  ShellBuffer^.VESASupport := VESASupport;
  ShellBuffer^.PathPrompt := PathPrompt;
  ShellBuffer^.PopupMenu := PopupMenu;
  ShellBuffer^.TempUncompOpen := TempUncompOpen;
  ShellBuffer^.TempInputOpen := TempInputOpen;
  ShellBuffer^.TempOutputOpen := TempOutputOpen;
  ShellBuffer^.TempFileOpen := TempFileOpen;
  ShellBuffer^.TransferInited := TransferInited;
  ShellBuffer^.DestArchType := DestArchType;
  ShellBuffer^.Archiving := Archiving;
  ShellBuffer^.Compressing := Compressing;
  ShellBuffer^.MoveFiles := MoveFiles;
  SaveAutoReplies;
  ShellBuffer^.AllConvert := AllConvert;
  ShellBuffer^.WarningStatus := WarningStatus;
  ShellBuffer^.OrigBackCursorY := OrigBackCursorY;
  ShellBuffer^.BackCursorY := BackCursorY;
  ShellBuffer^.BackAttr := BackAttr;
  ShellBuffer^.CopyFileMode := CopyFileMode;
  ShellBuffer^.MemFree := MemFree;
  ShellBuffer^.CBMPattern := CBMPattern;
  ShellBuffer^.DOSPattern := DOSPattern;
  Move(LPTAddresses, ShellBuffer^.LPTAddresses, SizeOf(LPTAddresses));
  Move(LPTModes, ShellBuffer^.LPTModes, SizeOf(LPTModes));
  ShellBuffer^.LeftCBMDev := Left^.CBMDev;
  ShellBuffer^.LeftOrigPath := Left^.OrigPath;
  ShellBuffer^.LeftImagePath := Left^.RealImagePath;
  ShellBuffer^.LeftOrigImagePath := Left^.OrigImagePath;
  ShellBuffer^.LeftImageName := Left^.ImageName;
  ShellBuffer^.LeftOrigImage := Left^.OrigImageName;
  ShellBuffer^.LeftNewCur := Left^.NewCur;
  ShellBuffer^.LeftTop := Left^.Top;
  ShellBuffer^.LeftUnder := Left^.Under;
  if Left^.SelNum <= MaxSelNum then ShellBuffer^.LeftSelNum := Left^.SelNum else ShellBuffer^.LeftSelNum := MaxSelNum;
  if Left^.ListNum <= MaxSelNum then ShellBuffer^.LeftListNum := Left^.ListNum else ShellBuffer^.LeftListNum := MaxSelNum;
  ShellBuffer^.LeftListEnd := Left^.ListEnd;
  Move(Left^.List, ShellBuffer^.LeftList, Left^.ListNum * SizeOf(TSelFile));
  Move(Left^.ListNames, ShellBuffer^.LeftListNames, Left^.ListEnd);
  ShellBuffer^.RightCBMDev := Right^.CBMDev;
  ShellBuffer^.RightOrigPath := Right^.OrigPath;
  ShellBuffer^.RightImagePath := Right^.RealImagePath;
  ShellBuffer^.RightOrigImagePath := Right^.OrigImagePath;
  ShellBuffer^.RightImageName := Right^.ImageName;
  ShellBuffer^.RightOrigImage := Right^.OrigImageName;
  ShellBuffer^.RightNewCur := Right^.NewCur;
  ShellBuffer^.RightTop := Right^.Top;
  ShellBuffer^.RightUnder := Right^.Under;
  if Right^.SelNum <= MaxSelNum then ShellBuffer^.RightSelNum := Right^.SelNum else ShellBuffer^.RightSelNum := MaxSelNum;
  if Right^.ListNum <= MaxSelNum then ShellBuffer^.RightListNum := Right^.ListNum else ShellBuffer^.RightListNum := MaxSelNum;
  ShellBuffer^.RightListEnd := Right^.ListEnd;
  Move(Right^.List, ShellBuffer^.RightList, Right^.ListNum * SizeOf(TSelFile));
  Move(Right^.ListNames, ShellBuffer^.RightListNames, Right^.ListEnd);
  if Act^.Mode = pmExt then ShellBuffer^.CurPath := Inact^.Path else ShellBuffer^.CurPath := Act^.Path;
  if MouseEvents then
  begin
    ShellBuffer^.MouseX := MouseWhere.X shl 3;
    ShellBuffer^.MouseY := MouseWhere.Y shl 3;
    ShellBuffer^.MouseMaxX := MouseInitMax.X;
    ShellBuffer^.MouseMaxY := MouseInitMax.Y;
    SetDefMouseCursorChar(EmptyMouseCursorChar);
  end
  else
  begin
    ShellBuffer^.MouseX := -1;
  end;
  ShellBuffer^.CmdPos := CommandLine^.CurPos;
  ShellBuffer^.CmdFirstPos := CommandLine^.FirstPos;
  CommandLine^.GetData(ShellBuffer^.CmdLineText);
  if ClearCommand then ShellBuffer^.CmdLineText := '';
  ShellBuffer^.LastName := LastName;
  ShellBuffer^.DestName := DestName;
  ShellBuffer^.TapeDirSize := TapeDirSize;
  ShellBuffer^.DiskDirSize := DiskDirSize;
  ShellBuffer^.DiskTitle := DiskTitle;
  ShellBuffer^.TapeTitle := TapeTitle;
  ShellBuffer^.FirstFile := Act^.FirstFile;
  ShellBuffer^.CopyDirPos := Act^.CopyDirPos;
  ShellBuffer^.CopyFileNum := CopyFileNum;
  ShellBuffer^.BatchMode := BatchMode;
  ShellBuffer^.BatchName := BatchName;
  ShellBuffer^.BatchCommand := BatchCommand;
  ShellBuffer^.CharSetMode := CharSetMode;
  ClockOff;
  MouseOff;
  MiscFunc.SaveConfig(sdShellBuffer);
  if (CharSetMode > csIBMUpper) and not Internal then
  begin
    B := CharSetMode;
    Application^.SetCharSet(CharStartMode and csLowerUpper, True, False);
    ShellBuffer^.CharSetMode := CharSetMode;
    RedrawAllViews;
    CharSetMode := B;
  end;
  if ShellBuffer^.CommandOutput <> coNormal then
  begin
    BackCursorY := ScreenHeight;
    Dec(ShellBuffer^.CmdLen, 2);
    Move(BackBuffer, ShellBuffer^.ScreenBuffer^, ScreenHeight * ScreenWidth shl 1);
    MoveScreen(ScreenBuffer^, BackBuffer);
    if AttachInfo then
    begin
      Move(SochaSign, ShellBuffer^.CmdBuffer^[ShellBuffer^.CmdLen], 9);
      Inc(ShellBuffer^.CmdLen, 9);
      FillChar(ShellBuffer^.CmdBuffer^[ShellBuffer^.CmdLen], 36, 0);
      ShellBuffer^.CmdBuffer^[ShellBuffer^.CmdLen] := Chr(ScreenCol);
      if ButtonCount > 0 then
      begin
        ShellBuffer^.CmdBuffer^[ShellBuffer^.CmdLen + 2] := #$FF;
        ShellBuffer^.CmdBuffer^[ShellBuffer^.CmdLen + 3] := Chr(Byte(MouseReverse));
        ShellBuffer^.CmdBuffer^[ShellBuffer^.CmdLen + 4] := #1;
      end;
      Inc(ShellBuffer^.CmdLen, 36);
    end;
  end;
  if Resident and (ShellBuffer^.CmdLen > 0) then
  begin
    if ShellBuffer^.CommandOutput <> coNormal then MouseOn;
    E.What := evCommand;
    E.Command := cmQuit;
    Application^.PutEvent(E);
  end
  else
  begin
    MouseInit.X := ShellBuffer^.MouseX;
    MouseInit.Y := ShellBuffer^.MouseY;
    MouseInitMax.X := ShellBuffer^.MouseMaxX;
    MouseInitMax.Y := ShellBuffer^.MouseMaxY;
    P := ShellBuffer^.CurPath;
    if not ShellBuffer^.PathPrompt then P := P[1];
    Act := nil;
    Dispose(Right, Done);
    Dispose(Left, Done);
    Dispose(CommandLine, Done);
    Dispose(Clock, Done);
    if TempDialog <> nil then Dispose(TempDialog, Done);
    DoneEvents;
    if ShellBuffer^.CommandOutput <> coNormal then MouseOn else
      Application^.SetCharSet(CharStartMode and csLowerUpper, False, False);
    DoneVideo;
    DoneDOSMem;
    DoneSysError;
    if ShellBuffer^.CmdLen = 0 then
    begin
      if ShellBuffer^.Single then PrintStr(P + '>');
    end
    else
    begin
      F := True;
      I := 0;
      DOSError := 0;
      while (DOSError = 0) and (I < ShellBuffer^.CmdLen) do
      begin
        S := '';
        while (I < ShellBuffer^.CmdLen) and (ShellBuffer^.CmdBuffer^[I] <> chCR) do
        begin
          Inc(S[0]);
          S[Length(S)] := ShellBuffer^.CmdBuffer^[I];
          Inc(I);
        end;
        Inc(I, 2);
        if S <> '' then
        begin
          O := ((ShellBuffer^.CommandOutput = coNormal) and (ShellBuffer^.Single or (S[1] <> SuppressOutputPrefix)));
          if not ShellBuffer^.Single and (S[1] = SuppressOutputPrefix) then S := Copy(S, 2, MaxStrLen);
          if O then
          begin
            if P = '' then P := LongGetDir(0);
            if not ShellBuffer^.PathPrompt then P := P[1];
            if F then F := False else PrintStr(chCR + chLF);
            if ShellBuffer^.Single then B := ShellBuffer^.CmdFirstPos + 1 else B := 1;
            PrintStr(P + '>' + Copy(S, B, ScreenWidth - 2 - Length(P)) + chCR + chLF);
          end;
          DoneCtrlBreak;
          SwapVectors;
          InitShell;
          if ShellBuffer^.CommandOutput = coStandardCmd then
          begin
            J := 1;
            F := False;
            T := '';
            while (J <= Length(S)) and (F or (S[J] <> ' ')) do
            begin
              F := (S[J] = '"');
              Inc(J);
            end;
            if J <= Length(S) then
            begin
              T := Copy(S, J + 1, MaxStrLen);
              S[0] := Chr(J - 1);
            end;
            Exec(S, T);
          end
          else
          begin
            Exec(GetEnv('COMSPEC'), '/c ' + S);
          end;
          DoneShell;
          SwapVectors;
          InitCtrlBreak;
          P := '';
        end;
      end;
      ShellBuffer^.ExecError := DOSError;
    end;
    InitSysError;
    InitDOSMem;
    if (ShellBuffer^.CommandOutput = coNormal) and (ShellBuffer^.Single or (ShellBuffer^.CmdLen > 0)) then
      PrintStr(chCR + chLF);
    TextScreen(SwitchPrompt);
    if ShellBuffer^.CommandOutput <> coNormal then
    begin
      BackCursorY := ShellBuffer^.BackCursorY;
      BackAttr := ShellBuffer^.BackAttr;
      asm
        push bp;
        mov ax, $1130;
        xor bh, bh;
        call VideoInt;
        mov ah, 2;
        xor bh, bh;
        mov dh, dl;
        inc dh;
        xor dl, dl;
        call VideoInt;
        pop bp;
      end;
    end;
    InitMouse;
    InitVideo;
    if CommandOutput = coNormal then
    begin
      MouseInit.X := ShellBuffer^.MouseX;
      MouseInit.Y := ShellBuffer^.MouseY;
      MouseInitMax.X := ShellBuffer^.MouseMaxX;
      MouseInitMax.Y := ShellBuffer^.MouseMaxY;
    end;
    InitMousePosition;
    if ShellBuffer^.CommandOutput <> coNormal then
      Move(ShellBuffer^.ScreenBuffer^, BackBuffer, ScreenHeight * ScreenWidth shl 1);
    InitEvents;
    LoadConfig;
    Reinitialize(False);
  end;
end;

end.
