
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Turbo Vision Unit                               }
{                                                       }
{       Copyright (c) 1992 Borland International        }
{                                                       }
{*******************************************************}

unit Drivers;

{$A+,B-,D+,E-,F+,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$C FIXED PRELOAD PERMANENT}

interface

uses
  Objects;

const
{Maximum value for a word}
  MaxWord       = $FFFF;
{Maximum value for a byte}
  MaxByte       = $FF;
{Maximum size of the screen}
  MaxScrWidth   = 132;
  MaxScrHeight  = 60;
{System error automatic failures}
  fsNone        = 0;
  fsAll         = 1;
  fsDiskChange  = 2;
{Command output modes}
  coNormal      = 0;
  coSilent      = 1;
  coStandardCmd = 2;
{Screen modes}
  smBW40        = $0000;
  smCO40        = $0001;
  smBW80        = $0002;
  smCO80        = $0003;
  smMono        = $0007;
  smLastNonVESA = $0013;
  smModeMask    = $01FF;
  smEGALines    = $8000;
{PC character constants}
  chBackspace   = #$08;
  chTab         = #$09;
  chLF          = #$0A;
  chPageFeed    = #$0C;
  chCR          = #$0D;
  chEOF         = #$1A;
  chEsc         = #$1B;
{Character to switch between colors in double-colored strings}
  ColorChar     = #2;

type
{Screen buffer}
  TScreenBuffer = array [0..(MaxScrWidth * MaxScrHeight * 2) - 1] of Byte;
  PScreenBuffer = ^TScreenBuffer;
{VESA information buffer}
  TVESAInfo     = array [$0000..$01FF] of Byte;
  PVESAInfo     = ^TVESAInfo;

{ ******** EVENT MANAGER ******** }

const

{ Event codes }

  evMouseDown = $0001;
  evMouseUp   = $0002;
  evMouseMove = $0004;
  evMouseAuto = $0008;
  evKeyDown   = $0010;
  evCommand   = $0100;
  evBroadcast = $0200;

{ Event masks }

  evNothing   = $0000;
  evMouse     = $000F;
  evKeyboard  = $0010;
  evMessage   = $FF00;

{ System error return values }

  seIgnore    = 0;
  seRetry     = 1;
  seAbort     = 2;
  seFail      = 3;

{ Extended key codes }

  kbNoKey     = $0000;

  kbA         = $1E61;
  kbB         = $3062;
  kbC         = $2E63;
  kbD         = $2064;
  kbE         = $1265;
  kbF         = $2166;
  kbG         = $2267;
  kbH         = $2368;
  kbI         = $1769;
  kbJ         = $246A;
  kbK         = $256B;
  kbL         = $266C;
  kbM         = $326D;
  kbN         = $316E;
  kbO         = $186F;
  kbP         = $1970;
  kbQ         = $1071;
  kbR         = $1372;
  kbS         = $1F73;
  kbT         = $1474;
  kbU         = $1675;
  kbV         = $2F76;
  kbW         = $1177;
  kbX         = $2D78;
  kbY         = $1579;
  kbZ         = $2C7A;

  kbMinus     = $0C2D;
  kbEqual     = $0D3D;

  kbF1        = $3B00;
  kbF2        = $3C00;
  kbF3        = $3D00;
  kbF4        = $3E00;
  kbF5        = $3F00;
  kbF6        = $4000;
  kbF7        = $4100;
  kbF8        = $4200;
  kbF9        = $4300;
  kbF10       = $4400;

  kbBack      = $0E08;
  kbDel       = $5300;
  kbDown      = $5000;
  kbEnd       = $4F00;
  kbEnter     = $1C0D;
  kbEsc       = $011B;
  kbGrayPlus  = $4E2B;
  kbGrayMinus = $4A2D;
  kbGrayMul   = $372A;
  kbHome      = $4700;
  kbIns       = $5200;
  kbLeft      = $4B00;
  kbPgDn      = $5100;
  kbPgUp      = $4900;
  kbRight     = $4D00;
  kbSpace     = $3920;
  kbTab       = $0F09;
  kbUp        = $4800;

  kbUnderStrk = $0C5F;
  kbPlus      = $0D2B;

  kbShiftF1   = $5400;
  kbShiftF2   = $5500;
  kbShiftF3   = $5600;
  kbShiftF4   = $5700;
  kbShiftF5   = $5800;
  kbShiftF6   = $5900;
  kbShiftF7   = $5A00;
  kbShiftF8   = $5B00;
  kbShiftF9   = $5C00;
  kbShiftF10  = $5D00;

  kbShiftDel  = $0700;
  kbShiftIns  = $0500;
  kbShiftTab  = $0F00;

  kbCtrlA     = $1E01;
  kbCtrlB     = $3002;
  kbCtrlC     = $2E03;
  kbCtrlD     = $2004;
  kbCtrlE     = $1205;
  kbCtrlF     = $2106;
  kbCtrlG     = $2207;
  kbCtrlH     = $2308;
  kbCtrlI     = $1709;
  kbCtrlJ     = $240A;
  kbCtrlK     = $250B;
  kbCtrlL     = $260C;
  kbCtrlM     = $320D;
  kbCtrlN     = $310E;
  kbCtrlO     = $180F;
  kbCtrlP     = $1910;
  kbCtrlQ     = $1011;
  kbCtrlR     = $1312;
  kbCtrlS     = $1F13;
  kbCtrlT     = $1414;
  kbCtrlU     = $1615;
  kbCtrlV     = $2F16;
  kbCtrlW     = $1117;
  kbCtrlX     = $2D18;
  kbCtrlY     = $1519;
  kbCtrlZ     = $1C1A;

  kbCtrl2     = $0300;
  kbCtrl6     = $071E;

  kbCtrlMinus = $0C1F;
  kbCtrlBra   = $1A1B;
  kbCtrlKet   = $1B1D;
  kbCtrlBkSlash = $2B1C;

  kbCtrlGMinus= $8E00;
  kbCtrlGMul  = $9600;
  kbCtrlGPlus = $9000;
  kbCtrlTab   = $9400;

  kbCtrlF1    = $5E00;
  kbCtrlF2    = $5F00;
  kbCtrlF3    = $6000;
  kbCtrlF4    = $6100;
  kbCtrlF5    = $6200;
  kbCtrlF6    = $6300;
  kbCtrlF7    = $6400;
  kbCtrlF8    = $6500;
  kbCtrlF9    = $6600;
  kbCtrlF10   = $6700;

  kbCtrlBack  = $0E7F;
  kbCtrlDel   = $0600;
  kbCtrlDown  = $9100;
  kbCtrlEnd   = $7500;
  kbCtrlEnter = $1C0A;
  kbCtrlHome  = $7700;
  kbCtrlIns   = $0400;
  kbCtrlLeft  = $7300;
  kbCtrlPgDn  = $7600;
  kbCtrlPgUp  = $8400;
  kbCtrlPrtSc = $7200;
  kbCtrlRight = $7400;
  kbCtrlUp    = $8D00;

  kbAltA      = $1E00;
  kbAltB      = $3000;
  kbAltC      = $2E00;
  kbAltD      = $2000;
  kbAltE      = $1200;
  kbAltF      = $2100;
  kbAltG      = $2200;
  kbAltH      = $2300;
  kbAltI      = $1700;
  kbAltJ      = $2400;
  kbAltK      = $2500;
  kbAltL      = $2600;
  kbAltM      = $3200;
  kbAltN      = $3100;
  kbAltO      = $1800;
  kbAltP      = $1900;
  kbAltQ      = $1000;
  kbAltR      = $1300;
  kbAltS      = $1F00;
  kbAltT      = $1400;
  kbAltU      = $1600;
  kbAltV      = $2F00;
  kbAltW      = $1100;
  kbAltX      = $2D00;
  kbAltY      = $1500;
  kbAltZ      = $2C00;

  kbAlt1      = $7800;
  kbAlt2      = $7900;
  kbAlt3      = $7A00;
  kbAlt4      = $7B00;
  kbAlt5      = $7C00;
  kbAlt6      = $7D00;
  kbAlt7      = $7E00;
  kbAlt8      = $7F00;
  kbAlt9      = $8000;
  kbAlt0      = $8100;

  kbAltMinus  = $8300;
  kbAltEqual  = $8200;

  kbAltGMinus = $4E00;
  kbAltGPlus  = $4A00;

  kbAltF1     = $6800;
  kbAltF2     = $6900;
  kbAltF3     = $6A00;
  kbAltF4     = $6B00;
  kbAltF5     = $6C00;
  kbAltF6     = $6D00;
  kbAltF7     = $6E00;
  kbAltF8     = $6F00;
  kbAltF9     = $7000;
  kbAltF10    = $7100;

  kbAltBack   = $0800;
  kbAltDown   = $A000;
  kbAltLeft   = $9B00;
  kbAltRight  = $9D00;
  kbAltSpace  = $0200;
  kbAltUp     = $9800;

{ Keyboard state and shift masks }

  kbRightShift  = $0001;
  kbLeftShift   = $0002;
  kbCtrlShift   = $0004;
  kbAltShift    = $0008;
  kbScrollState = $0010;
  kbNumState    = $0020;
  kbCapsState   = $0040;
  kbInsState    = $0080;

{ Mouse button state masks }

  mbLeftButton  = $01;
  mbRightButton = $02;
  mbMiddleButton= $04;

{ Operating systems }

  osDOS         = $00;
  osWindows     = $01;
  osWindowsNT   = $02;
  os4DOS        = $04;
  osDESQview    = $08;

{ Batch modes }

  bmNone        = 0;
  bmSingle      = 1;
  bmScript      = 2;
  bmModeMask    = $3F;
  bmNoInit      = $40;

type

{ Event record }

  PEvent = ^TEvent;
  TEvent = record
    What: Word;
    case Word of
      evNothing: ();
      evMouse: (
        Buttons: Byte;
        Double: Boolean;
        Where: TPoint);
      evKeyDown: (
        case Integer of
          0: (KeyCode: Word);
          1: (CharCode: Char;
              ScanCode: Byte));
      evMessage: (
        Command: Word;
        case Word of
          0: (InfoPtr: Pointer);
          1: (InfoLong: Longint);
          2: (InfoWord: Word);
          3: (InfoInt: Integer);
          4: (InfoByte: Byte);
          5: (InfoChar: Char));
  end;

var

{ Time slice support variables }

  OperatingSystem: Byte;

procedure CursorOff;
procedure InitOperatingSystem;
procedure GiveUpTimeSlice;

const

{ Initialized variables }

  ButtonCount: Byte = 0;
  MouseEvents: Boolean = False;
  MouseReverse: Boolean = False;
  DoubleDelay: Word = 8;
  RepeatDelay: Word = 4;
  ReadKeyFunc: Byte = 0;

var

{ Uninitialized variables }

  MouseWheel: Boolean;
  MouseIntFlag: Byte;
  MouseButtons: Byte;
  CommandOutput: Byte;
  MouseWhere: TPoint;
  MouseInit: TPoint;
  MouseInitMax: TPoint;
  MouseWheelCount: Integer;

{ Event manager routines }

procedure InitEvents;
procedure DoneEvents;
procedure ShowMouse;
procedure HideMouse;
procedure SetMouseCursorChar(Ch: Char);
procedure SetDefMouseCursorChar(Ch: Char);
procedure InitMousePosition;
procedure GetMouseEvent(var Event: TEvent);
procedure GetKeyEvent(var Event: TEvent);
function GetShiftState: Byte;

{ ******** SCREEN MANAGER ******** }

const

  EmptyMouseCursorChar = #0;
  DefMouseScreenMask = $FFFF;
  DefMouseCursorMask = $7700;

{ Initialized variables }

  ShowKeyBar: Boolean = True;
  SnowCheck: Boolean = False;
  VESASupport: Boolean = True;
  FastMouse: Boolean = False;
  BrightBackground: Boolean = False;
  BatchMode: Byte = bmNone;
  MouseScreenMask: Word = DefMouseScreenMask;
  MouseCursorMask: Word = DefMouseCursorMask;
  DefMouseCursorChar: Char = EmptyMouseCursorChar;

var

{ Uninitialized variables }

  BackBuffer: TScreenBuffer;
  OrigBackCursorY: Byte;
  BackCursorY: Byte;
  BackAttr: Byte;
  ScreenMode: Word;
  ScreenWidth: Byte;
  ScreenHeight: Byte;
  HiResScreen: Boolean;
  OrigCheckSnow: Boolean;
  CheckSnow: Boolean;
  ScreenBuffer: Pointer;
  CursorLines: Word;

{ Screen manager routines }

procedure VideoInt;
procedure InitVideo;
procedure DoneVideo;
function GetVideoMode: Word;
procedure SetVideoMode(Mode: Word);
function IsTextVideoMode(Mode: Word): Boolean;
procedure FillWord(var X; Count, Value: Word);
procedure MoveScreen(var Source, Dest);
procedure LoadBack;
procedure SaveBack;
procedure SetBlinkBright(Bright: Boolean);
procedure ClearScreen;

{ ******** SYSTEM ERROR HANDLER ******** }

type

{ System error handler function type }

  TSysErrorFunc = function(ErrorCode: Integer; Drive: Byte; Device: Pointer; IgnoreOK: Boolean): Byte;

{ Emergency exit function type }

  TEmergencyExitFunc = procedure;

{ Default system error handler routine }

function SystemError(ErrorCode: Integer; Drive: Byte; Device: Pointer; IgnoreOK: Boolean): Byte;

{ Default emergency exit routine }

procedure SystemExit; far;

const

{ Initialized variables }

  SysErrorFunc: TSysErrorFunc = SystemError;
  EmergencyExitFunc: TEmergencyExitFunc = SystemExit;
  CtrlAltInsActive: Boolean = False;
  CtrlAltInsHit: Boolean = False;
  CtrlBreakHit: Boolean = False;
  SaveCtrlBreak: Boolean = False;
  CtrlBreakActive: Boolean = False;
  SysErrActive: Boolean = False;
  MainProgram: Boolean = False;
  FailSysErrors: Byte = fsNone;
  SysErrorOccurred: Boolean = False;

{ System error handler routines }

procedure InitCtrlBreak;
procedure DoneCtrlBreak;
procedure InitSysError;
procedure DoneSysError;
procedure InitMouse;

{ ******** UTILITY ROUTINES ******** }

{ Keyboard support routines }

function GetChar(KeyCode: Word): Char;
function GetAltChar(KeyCode: Word): Char;
function GetCtrlChar(KeyCode: Word): Char;

{ String routines }

procedure PrintStr(const S: string);
function LeftPos(C: Char; const S: string): Byte;
function RightPos(C: Char; const S: string): Byte;

{ Buffer move routines }

procedure MoveBuf(var Dest; var Source; Attr: Byte; Count: Word);
procedure MoveChar(var Dest; C: Char; Attr: Byte; Count: Word);
procedure MoveColor(var Dest; Attr: Byte; Count: Word);
procedure MoveCStr(var Dest; const Str: string; Attrs: Word);
procedure MoveStr(var Dest; const Str: string; Attr: Byte);
function CStrLen(const S: string): Integer;

implementation

uses
  DOS;

{ ******** EVENT MANAGER ******** }

const

{ Event manager constants }

  EventQSize = 16;

var

{ Event manager variables }

  LastButtons: Byte;
  DownButtons: Byte;
  LastDouble: Boolean;
  LastWhere: TPoint;
  DownWhere: TPoint;
  DownTicks: Word;
  AutoTicks: Word;
  AutoDelay: Word;
  EventCount: Word;
  EventQHead: Word;
  EventQTail: Word;
  EventQueue: array[0..EventQSize - 1] of TEvent;
  EventQLast: record end;

var
  ShiftState: Byte absolute $40:$17;
  Ticks: Word absolute $40:$6C;

{ Detect the operating system: DOS, Windows 95/98/ME, Windows NT/2000/XP,
  DESQview, 4DOS/NDOS }

procedure InitOperatingSystem;
begin
  OperatingSystem := osDOS;
  asm
    mov OperatingSystem, osDOS;
    mov ax, $2B01;
    mov cx, 'DE';
    mov dx, 'SQ';
    int $21;
    cmp al, $FF;
    je @@1;
    or OperatingSystem, osDESQview;
@@1:mov ax, $1680;
    int $2F;
    cmp al, $80;
    je @@2;
    or OperatingSystem, osWindows;
@@2:mov ax, $D44D;
    xor bh, bh;
    int $2F;
    cmp ax, $44DD;
    je @@3;
    mov ax, $E44D;
    xor bh, bh;
    int $2F;
    cmp ax, $44EE;
    jne @@4;
@@3:or OperatingSystem, os4DOS;
@@4:
  end;
  if (OperatingSystem and osWindows <> 0) and (GetEnv('OS') = 'Windows_NT')
    and (GetEnv('PROCESSOR_ARCHITECTURE') = 'x86') then OperatingSystem := OperatingSystem or osWindowsNT;
end;

{ Give up time slice under a multi-tasking system }

procedure GiveUpTimeSlice; assembler;
asm
    int $28;
    test OperatingSystem, osWindows;
    je @@1;
    mov ax, $1680;
    int $2F;
@@1:test OperatingSystem, osDESQview;
    je @@2;
    mov ax, $101A;
    int $15;
    mov ax, $1000;
    int $15;
    mov ax, $1025;
    int $15;
@@2:
end;

{ Detect mouse driver }

procedure InitMouse; assembler;
asm
        MOV     AX,3533H
        INT     21H
        MOV     AX,ES
        OR      AX,BX
        JE      @@2
        MOV     AX,3
        INT     33H
        MOV     MouseInit.TPoint.X,CX
        MOV     MouseInit.TPoint.Y,DX
        MOV     AL,FastMouse
        OR      AL,AL
        JE      @@1
        MOV     AX,21H
        INT     33H
        CMP     AX,21H
        JNE     @@3
@@1:    XOR     AX,AX
        INT     33H
@@3:    CMP     AX,0FFFFh
        JE      @@4
        XOR     AL,AL
        JMP     @@2
@@4:    PUSH    BX
        MOV     AX,4
        XOR     CX,CX
        XOR     DX,DX
        INT     33H
        POP     AX
@@2:    MOV     ButtonCount,AL
        MOV     AX,11H
        INT     33H
        XOR     DL,DL
        CMP     AX,'WM'
        JNE     @@5
        TEST    CX,00000001B
        XOR     AX,AX
        MOV     MouseWheelCount,AX
        INC     DL
@@5:
        MOV     MouseWheel,DL
end;

{ Store event in GetMouseEvent and GetKeyEvent }

procedure StoreEvent; near; assembler;
asm
        MOV     DI,SP
        LES     DI,SS:[DI+8]
        CLD
        STOSW
        XCHG    AX,BX
        STOSW
        XCHG    AX,CX
        STOSW
        XCHG    AX,DX
        STOSW
end;

{ Get mouse state }
{ Out   BL = Button mask }
{       CX = X coordinate }
{       DX = Y coordinate }
{       DI = Timer ticks }

procedure GetMouseState; near; assembler;
asm
        CLI
        CMP     EventCount,False
        JNE     @@1
        MOV     BL,MouseButtons
        MOV     CX,MouseWhere.TPoint.X
        MOV     DX,MouseWhere.TPoint.Y
        MOV     ES,Seg0040
        MOV     DI,ES:Ticks
        JMP     @@3
@@1:    MOV     SI,EventQHead
        CLD
        LODSW
        XCHG    AX,DI
        LODSW
        XCHG    AX,BX
        LODSW
        XCHG    AX,CX
        LODSW
        XCHG    AX,DX
        CMP     SI,OFFSET EventQLast
        JNE     @@2
        MOV     SI,OFFSET EventQueue
@@2:    MOV     EventQHead,SI
        DEC     EventCount
@@3:    STI
end;

procedure MouseInt; far; assembler;
asm
        MOV     SI,SEG @DATA
        MOV     DS,SI
        MOV     SI,CX
        MOV     CL,3
        SHR     SI,CL
        SHR     DX,CL
        CMP     MouseReverse,False
        JE      @@1
        MOV     BH,BL
        AND     BH,3
        JE      @@1
        CMP     BH,3
        JE      @@1
        XOR     BL,3
@@1:    CMP     MouseWheel,False
        JE      @@4
        PUSH    AX
        MOV     AL,BH
        CBW
        ADD     MouseWheelCount,AX
        POP     AX
@@4:    MOV     MouseButtons,BL
        MOV     MouseWhere.X,SI
        MOV     MouseWhere.Y,DX
        TEST    AX,1111110B
        JE      @@3
        CMP     EventCount,EventQSize
        JE      @@3
        MOV     ES,Seg0040
        MOV     AX,ES:Ticks
        MOV     DI,EventQTail
        PUSH    DS
        POP     ES
        CLD
        STOSW
        XCHG    AX,BX
        STOSW
        XCHG    AX,SI
        STOSW
        XCHG    AX,DX
        STOSW
        CMP     DI,OFFSET EventQLast
        JNE     @@2
        MOV     DI,OFFSET EventQueue
@@2:    MOV     EventQTail,DI
        INC     EventCount
@@3:    MOV     MouseIntFlag,True
end;

procedure InitEvents; assembler;
asm
        XOR     AX,AX
        CMP     AL,ButtonCount
        JE      @@1
        MOV     DownButtons,AL
        MOV     LastDouble,AL
        MOV     EventCount,AX
        MOV     AX,OFFSET DS:EventQueue
        MOV     EventQHead,AX
        MOV     EventQTail,AX
        MOV     AX,4
        MOV     CX,MouseInit.TPoint.X
        MOV     DX,MouseInit.TPoint.Y
        INT     33H
        MOV     AX,3
        INT     33H
        XCHG    AX,CX
        MOV     CL,3
        SHR     AX,CL
        SHR     DX,CL
        MOV     MouseButtons,BL
        MOV     MouseWhere.X,AX
        MOV     MouseWhere.Y,DX
        MOV     LastButtons,BL
        MOV     LastWhere.X,AX
        MOV     LastWhere.Y,DX
        MOV     AX,12
        MOV     CX,0FFFFH
        MOV     DX,OFFSET CS:MouseInt
        PUSH    CS
        POP     ES
        INT     33H
        MOV     AX,1
        INT     33H
        MOV     MouseEvents,True
@@1:    MOV     AX,11FFH
        INT     16H
        XOR     BL,BL
        CMP     AX,11FFH
        JE      @@2
        MOV     BL,10H
@@2:    MOV     ReadKeyFunc,BL
end;

procedure DoneEvents; assembler;
asm
        CMP     ButtonCount,0
        JE      @@1
        CMP     MouseEvents,False
        JE      @@1
        MOV     MouseEvents,False
        CMP     CommandOutput,coStandardCmd
        JE      @@2
        MOV     AX,2
        INT     33H
@@2:    MOV     AX,12
        XOR     CX,CX
        MOV     DX,CX
        MOV     ES,CX
        INT     33H
@@1:
end;

procedure ShowMouse; assembler;
asm
        CMP     ButtonCount,0
        JE      @@1
        PUSH    AX
        MOV     AX,1
        INT     33H
        POP     AX
@@1:
end;

procedure HideMouse; assembler;
asm
        CMP     ButtonCount,0
        JE      @@1
        PUSH    AX
        MOV     AX,2
        INT     33H
        POP     AX
@@1:
end;

procedure SetMouseCursorChar(Ch: Char); assembler;
asm
    mov dl, &Ch;
    mov cl, (DefMouseScreenMask and $FF);
    or dl, dl;
    je @3;
    xor cl, cl;
@3: mov dh, (DefMouseCursorMask shr 8);
    mov ch, (DefMouseScreenMask shr 8);
    cmp cx, MouseScreenMask;
    jne @1;
    cmp dx, MouseCursorMask;
    je @2;
@1: mov MouseScreenMask, cx;
    mov MouseCursorMask, dx;
    xor bx, bx;
    mov ax, 10;
    int $33;
@2:
end;

procedure MoveMouse(X, Y: Word); assembler;
asm
    mov cx, X;
    mov dx, Y;
    mov ax, 4;
    int $33;
end;

procedure InitMousePosition;
var
  X,
  Y             : Word;
begin
  if ButtonCount <> 0 then
  begin
    X := ScreenWidth shl 3;
    Y := ScreenHeight shl 3;
    if MouseInit.X = -1 then
    begin
      MouseInitMax.X := X;
      MouseInitMax.Y := Y;
      MouseInit.X := MouseInitMax.X shr 1;
      MouseInit.Y := MouseInitMax.Y shr 1;
    end
    else
    begin
      MouseInit.X := (Longint(MouseInit.X) * X) div MouseInitMax.X;
      MouseInit.Y := (Longint(MouseInit.Y) * Y) div MouseInitMax.Y;
      MouseInitMax.X := X;
      MouseInitMax.Y := Y;
    end;
    if MouseInit.X >= X then MouseInit.X := X - 1;
    if MouseInit.Y >= Y then MouseInit.Y := Y - 1;
    MoveMouse(MouseInit.X, MouseInit.Y);
    MouseWhere.X := MouseInit.X shr 3;
    MouseWhere.Y := MouseInit.Y shr 3;
  end;
end;

procedure SetDefMouseCursorChar(Ch: Char);
begin
  DefMouseCursorChar := Ch;
  SetMouseCursorChar(DefMouseCursorChar);
end;

procedure GetMouseEvent(var Event: TEvent); assembler;
asm
        CMP     MouseEvents,False
        JE      @@2
        CALL    GetMouseState
        MOV     BH,LastDouble
        MOV     AL,LastButtons
        CMP     AL,BL
        JE      @@1
        OR      AL,AL
        JE      @@3
        OR      BL,BL
        JE      @@5
        MOV     BL,AL
@@1:    CMP     CX,LastWhere.X
        JNE     @@6
        CMP     DX,LastWhere.Y
        JNE     @@6
        OR      BL,BL
        JE      @@2
        MOV     AX,DI
        SUB     AX,AutoTicks
        CMP     AX,AutoDelay
        JAE     @@7
@@2:    XOR     AX,AX
        MOV     BX,AX
        MOV     CX,AX
        MOV     DX,AX
        JMP     @@9
@@3:    XOR     BH,BH
        CMP     BL,DownButtons
        JNE     @@4
        CMP     CX,DownWhere.X
        JNE     @@4
        CMP     DX,DownWhere.Y
        JNE     @@4
        MOV     AX,DI
        SUB     AX,DownTicks
        CMP     AX,DoubleDelay
        JAE     @@4
        MOV     BH,1
        MOV     DI,-1
@@4:    MOV     DownButtons,BL
        MOV     DownWhere.X,CX
        MOV     DownWhere.Y,DX
        MOV     DownTicks,DI
        MOV     AutoTicks,DI
        MOV     AX,RepeatDelay
        MOV     AutoDelay,AX
        MOV     AX,evMouseDown
        JMP     @@8
@@5:    MOV     AX,evMouseUp
        JMP     @@8
@@6:    MOV     AX,evMouseMove
        JMP     @@8
@@7:    MOV     AutoTicks,DI
        MOV     AutoDelay,1
        MOV     AX,evMouseAuto
@@8:    MOV     LastButtons,BL
        MOV     LastDouble,False
        MOV     LastWhere.X,CX
        MOV     LastWhere.Y,DX
@@9:    CALL    StoreEvent
end;

procedure GetKeyEvent(var Event: TEvent); assembler;
asm
        MOV     AH,ReadKeyFunc
        INC     AH
        INT     16H
        MOV     AX,0
        MOV     BX,AX
        JE      @@1
        MOV     AH,ReadKeyFunc
        INT     16H
        CMP     AL,0E0H
        JNE     @@2
        OR      AH,AH
        JE      @@2
        XOR     AL,AL
@@2:    CMP     AX,0E00DH
        JE      @@3
        CMP     AX,0E00AH
        JNE     @@4
@@3:    MOV     AH,1CH
@@4:    MOV     BX,evKeyDown
@@1:    XCHG    AX,BX
        XOR     CX,CX
        MOV     DX,CX
        CALL    StoreEvent
end;

function GetShiftState: Byte; assembler;
asm
        MOV     ES,Seg0040
        MOV     AL,ES:ShiftState
        AND     AL,0Fh
end;

{ ******** SCREEN MANAGER ******** }

var
  Equipment: Word absolute $40:$10;
  CrtRows: Byte absolute $40:$84;
  CrtInfo: Byte absolute $40:$87;

{ Save registers and call video interrupt }

procedure VideoInt; assembler;
asm
        PUSH    BP
        PUSH    ES
        INT     10H
        POP     ES
        POP     BP
end;

{ Return CRT mode in AX and dimensions in DX }

procedure GetCrtMode; assembler;
asm
        MOV     AH,0FH
        CALL    VideoInt
        MOV     DH,AH
        XOR     AH,AH
        PUSH    AX
        CMP     VESASupport,False
        JE      @@2
        CMP     AX,smLastNonVESA
        JBE     @@2
        MOV     AX,4F03H
        CALL    VideoInt
        CMP     AX,004FH
        JNE     @@2
        AND     BX,smModeMask
        POP     AX
        PUSH    BX
@@2:    MOV     AX,1130H
        XOR     BH,BH
        XOR     DL,DL
        MOV     CL,DH
        PUSH    CX
        CALL    VideoInt
        POP     CX
        MOV     DH,CL
        POP     AX
        CMP     DL,25
        JBE     @@1
        OR      AX,smEGALines
@@1:
end;

{ Switch the hardware text cursor off }

procedure CursorOff; assembler;
asm
        MOV     DL,ScreenWidth
        MOV     DH,ScreenHeight
        XOR     BH,BH
        MOV     AH,2
        CALL    VideoInt
        MOV     CX,2000H
        MOV     AH,1
        CALL    VideoInt
end;

{ Set CRT mode to value in AX }

procedure SetCrtMode; assembler;
asm
        MOV     ES,Seg0040
        MOV     BL,20H
        CMP     AX,smMono
        JNE     @@1
        MOV     BL,30H
@@1:    AND     ES:Equipment.Byte,0CFH
        OR      ES:Equipment.Byte,BL
        AND     ES:CrtInfo,0FEH
        PUSH    AX
        CMP     VESASupport,False
        JE      @@3
        OR      AH,AH
        JE      @@3
        MOV     BX,AX
        AND     BX,smModeMask
        MOV     AX,4F02H
        CALL    VideoInt
        JMP     @@4
@@3:    XOR     AH,AH
        CALL    VideoInt
@@4:    POP     AX
        TEST    AX,smEGALines
        JE      @@2
        MOV     AX,1112H
        XOR     BL,BL
        CALL    VideoInt
        MOV     AX,1130H
        XOR     BH,BH
        XOR     DL,DL
        CALL    VideoInt
        CMP     DL,42
        JNE     @@2
        OR      ES:CrtInfo,1
        MOV     AH,1
        MOV     CX,600H
        CALL    VideoInt
        MOV     AH,12H
        MOV     BL,20H
        CALL    VideoInt
@@2:
end;

{ Set CRT data areas and mouse range }

procedure SetCrtData; near; assembler;
asm
        CALL    GetCrtMode
        MOV     CL,1
        OR      DL,DL
        JNE     @@1
        XOR     CL,CL
        MOV     DL,24
@@1:    INC     DL
        MOV     ScreenMode,AX
        CMP     DH,MaxScrWidth
        JBE     @@9
        MOV     DH,MaxScrWidth
@@9:    MOV     ScreenWidth,DH
        CMP     DL,MaxScrHeight
        JBE     @@5
        MOV     DL,MaxScrHeight
@@5:    MOV     ScreenHeight,DL
        MOV     HiResScreen,CL
        XOR     CL,1
        MOV     BX,SegB800
        CMP     AL,smMono
        JNE     @@2
        XOR     CL,CL
        MOV     BX,SegB000
@@2:    MOV     OrigCheckSnow,CL
        MOV     AL,CL
        AND     AL,SnowCheck
        MOV     CheckSnow,AL
        XOR     AX,AX
        MOV     ScreenBuffer.Word[0],AX
        MOV     ScreenBuffer.Word[2],BX
        MOV     AH,3
        XOR     BH,BH
        CALL    VideoInt
        MOV     AX,Seg0040
        MOV     ES,AX
        MOV     AL,ES:[0085H]
        OR      AL,AL
        JE      @@8
        CMP     AL,10H
        JA      @@8
        CMP     CL,AL
        JAE     @@6
        CMP     CH,AL
        JAE     @@6
        CMP     CL,CH
        JA      @@8
@@6:    DEC     AL
        MOV     AH,AL
        DEC     AH
        CMP     AL,10
        JBE     @@7
        DEC     AL
        DEC     AH
@@7:    MOV     CX,AX
@@8:    MOV     CursorLines,CX
        MOV     AH,1
        MOV     CX,2000H
        CALL    VideoInt
        CMP     ButtonCount,0
        JE      @@4
        MOV     AX,7
        MOV     DL,ScreenWidth
        CALL    @@3
        MOV     AX,8
        MOV     DL,ScreenHeight
@@3:    XOR     DH,DH
        MOV     CL,3
        SHL     DX,CL
        DEC     DX
        XOR     CX,CX
        INT     33H
@@4:
end;

{ Detect video modes }

procedure InitVideo; assembler;
asm
        CALL    GetCrtMode
        MOV     ScreenMode,AX
        CALL    SetCrtData
        CALL    LoadBack
end;

procedure DoneVideo; assembler;
asm
        CALL    SaveBack
        MOV     AH,1
        MOV     CX,CursorLines
        CALL    VideoInt
end;

function GetVideoMode: Word; assembler;
asm
        CALL    GetCrtMode
end;

procedure SetVideoMode(Mode: Word); assembler;
asm
        MOV     AX,Mode
        CALL    SetCrtMode
        CALL    SetCrtData
end;

function IsTextVideoMode(Mode: Word): Boolean;
var
  O             : Boolean;
  P             : PVESAInfo;
begin
  O := False;
  Mode := Mode and smModeMask;
  case Mode of
    smBW80, smCO80, smMono: O := True;
  else
    if VESASupport and (Mode >= smLastNonVESA) then
    begin
      P := New(PVESAInfo);
      asm
        mov ax, $4F01;
        mov cx, Mode;
        les di, P;
        call VideoInt;
        cmp ax, $004F;
        jne @1;
        mov al, byte ptr es:[di];
        and al, $13;
        cmp al, $03;
        jne @1;
        inc O;
    @1:
      end;
      Dispose(P);
    end;
  end;
  IsTextVideoMode := O;
end;

procedure FillWord(var X; Count, Value: Word); assembler;
asm
    les di, X;
    mov ax, Value;
    mov cx, Count;
    cld;
    rep stosw;
end;

procedure MoveScreen(var Source, Dest); assembler;
asm
    mov al, ScreenHeight;
    mov ah, ScreenWidth;
    mul ah;
    mov cx, ax;
    push ds;
    cmp CheckSnow, False;
    lds si, Source;
    les di, Dest;
    cld;
    jne @1;
    rep movsw;
    jmp @2;
@1: mov dx, $03DA;
@3: in al, dx;
    test al, 1;
    jne @3;
    cli;
@4: in al, dx;
    test al, 1;
    je @4;
    movsw;
    sti;
    loop @3;
@2: pop ds;
end;

procedure LoadBack;
begin
  if (CommandOutput <> coNormal) then
  begin
    MoveScreen(ScreenBuffer^, BackBuffer);
  end
  else
  begin
    HideMouse;
    asm
      mov ah, 3;
      xor bh, bh;
      call VideoInt;
      mov BackCursorY, dh;
      mov ah, 8;
      xor bh, bh;
      call VideoInt;
      mov BackAttr, ah;
    end;
    CursorOff;
    OrigBackCursorY := BackCursorY;
    if MainProgram then
    begin
      while BackCursorY > ScreenHeight - 1 - Byte(ShowKeyBar) do
      begin
        if BatchMode = bmNone then PrintStr(chCR + chLF);
        Dec(BackCursorY);
      end;
    end;
    MoveScreen(ScreenBuffer^, BackBuffer);
    ShowMouse;
  end;
end;

procedure SaveBack;
begin
  MoveScreen(BackBuffer, ScreenBuffer^);
  asm
    mov ah, 2;
    xor bh, bh;
    xor dl, dl;
    mov dh, BackCursorY;
    call VideoInt;
    mov ah, 8;
    xor bh, bh;
    mov bl, BackAttr;
    xor al, al;
    xor cx, cx;
    call VideoInt;
  end;
end;

procedure SetBlinkBright(Bright: Boolean);
begin
  BrightBackground := Bright;
  Bright := not Bright;
  if HiResScreen then
  begin
    asm
      mov ax, $1003;
      mov bl, Bright;
      call VideoInt;
    end;
  end;
end;

procedure ClearScreen; assembler;
asm
        MOV     AX,600H
        MOV     BH,07H
        XOR     CX,CX
        MOV     DL,ScreenWidth
        DEC     DL
        MOV     DH,ScreenHeight
        DEC     DH
        CALL    VideoInt
        MOV     AH,2
        XOR     BH,BH
        XOR     DX,DX
        CALL    VideoInt
end;

procedure SystemExit;
begin
end;

{ ******** SYSTEM ERROR HANDLER ******** }

{$L SYSINT.OBJ}

{ System error handler routines }

procedure InitCtrlBreak; external;
procedure DoneCtrlBreak; external;
procedure InitSysError; external;
procedure DoneSysError; external;

function SystemError(ErrorCode: Integer; Drive: Byte; Device: Pointer; IgnoreOK: Boolean): Byte;
begin
  SystemError := seFail;
end;

{ ******** UTILITY ROUTINES ******** }

{ Keyboard support routines }

const

  KeyCodes1: array [0..37] of Char =
    'QWERTYUIOP[]'#0#0'ASDFGHJKL;''`'#0'\ZXCVBNM,./';

  KeyCodes2: array [0..11] of Char =
    '1234567890-=';

function GetChar(KeyCode: Word): Char;
begin
  GetChar := #0;
  case Hi(KeyCode) of
    $10..$35: GetChar := KeyCodes1[Hi(KeyCode) - $10];
    $02..$0D: GetChar := KeyCodes2[Hi(KeyCode) - $02];
  end;
end;

function GetAltChar(KeyCode: Word): Char;
begin
  GetAltChar := #0;
  if Lo(KeyCode) = 0 then
    case Hi(KeyCode) of
      $10..$35: GetAltChar := KeyCodes1[Hi(KeyCode) - $10];
      $78..$83: GetAltChar := KeyCodes2[Hi(KeyCode) - $78];
      $4A: GetAltChar := '+';
      $4E: GetAltChar := '-';
    end;
end;

function GetCtrlChar(KeyCode: Word): Char;
begin
  GetCtrlChar := #0;
  if Lo(KeyCode) in [$00..$20] then
    case Hi(KeyCode) of
      $03: GetCtrlChar := '2';
      $07: GetCtrlChar := '6';
      $0C: GetCtrlChar := '-';
      $1C: ;
      $10..$32: GetCtrlChar := Chr(Lo(KeyCode) + (Ord('A') - 1));
    end;
end;

{ String formatting routines }

procedure PrintStr(const S: string); assembler;
asm
        PUSH    DS
        LDS     SI,S
        CLD
        LODSB
        XOR     AH,AH
        XCHG    AX,CX
        MOV     AH,40H
        MOV     BX,1
        MOV     DX,SI
        INT     21H
        POP     DS
end;

{Searches for the first instance from the left of a character in a string
  Input : C: the character to search for
          S: the string to search in
  Output: zero, if not found; otherwise, the position of the character}
function LeftPos(C: Char; const S: string): Byte; assembler;
asm
    les di, S;
    mov al, es:[di];
    xor ah, ah;
    mov cx, ax;
    jcxz @1;
    inc di;
    push cx;
    mov al, C;
    cld;
    repne scasb;
    pop ax;
    jne @1;
    sub ax, cx;
    jmp @2;
@1: mov ax, cx;
@2:
end;

{Searches for the first instance from the right of a character in a string
  Input : C: the character to search for
          S: the string to search in
  Output: zero, if not found; otherwise, the position of the character}
function RightPos(C: Char; const S: string): Byte; assembler;
asm
    les di, S;
    mov al, es:[di];
    xor ah, ah;
    mov cx, ax;
    jcxz @1;
    add di, cx;
    mov al, C;
    std;
    repne scasb;
    jne @1;
    inc cx;
@1: mov ax, cx;
end;

{ Buffer move routines }

procedure MoveBuf(var Dest; var Source; Attr: Byte; Count: Word); assembler;
asm
        MOV     CX,Count
        JCXZ    @@5
        MOV     DX,DS
        LES     DI,Dest
        LDS     SI,Source
        MOV     AH,Attr
        CLD
        OR      AH,AH
        JE      @@3
@@1:    LODSB
        STOSW
        LOOP    @@1
        JMP     @@4
@@2:    INC     DI
@@3:    MOVSB
        LOOP    @@2
@@4:    MOV     DS,DX
@@5:
end;

procedure MoveChar(var Dest; C: Char; Attr: Byte; Count: Word); assembler;
asm
        MOV     CX,Count
        JCXZ    @@1
        LES     DI,Dest
        MOV     AL,C
        MOV     AH,Attr
        CLD
        REP     STOSW
@@1:
end;

procedure MoveColor(var Dest; Attr: Byte; Count: Word); assembler;
asm
        MOV     CX,Count
        JCXZ    @@1
        LES     DI,Dest
        MOV     AL,Attr
        CLD
@@2:    INC     DI
        STOSB
        LOOP    @@2
@@1:
end;

procedure MoveCStr(var Dest; const Str: string; Attrs: Word); assembler;
asm
        MOV     DX,DS
        LDS     SI,Str
        CLD
        LODSB
        MOV     CL,AL
        XOR     CH,CH
        JCXZ    @@3
        LES     DI,Dest
        MOV     BX,Attrs
        MOV     AH,BL
@@1:    LODSB
        CMP     AL,ColorChar
        JE      @@2
        STOSW
        LOOP    @@1
        JMP     @@3
@@2:    XCHG    AH,BH
        LOOP    @@1
@@3:    MOV     DS,DX
end;

procedure MoveStr(var Dest; const Str: string; Attr: Byte); assembler;
asm
        MOV     DX,DS
        LDS     SI,Str
        CLD
        LODSB
        MOV     CL,AL
        XOR     CH,CH
        JCXZ    @@4
        LES     DI,Dest
        MOV     AH,Attr
        OR      AH,AH
        JE      @@3
@@1:    LODSB
        STOSW
        LOOP    @@1
        JMP     @@4
@@2:    INC     DI
@@3:    MOVSB
        LOOP    @@2
@@4:    MOV     DS,DX
end;

function CStrLen(const S: string): Integer; assembler;
asm
        LES     DI,S
        MOV     CL,ES:[DI]
        INC     DI
        XOR     CH,CH
        MOV     BX,CX
        JCXZ    @@2
        MOV     AL,ColorChar
        CLD
@@1:    REPNE   SCASB
        JNE     @@2
        DEC     BX
        JMP     @@1
@@2:    MOV     AX,BX
end;

{ Drivers unit initialization and shutdown }

var
  SaveExit: Pointer;

procedure ExitDrivers; far;
begin
  DoneSysError;
  DoneEvents;
  ExitProc := SaveExit;
end;

begin
  SaveExit := ExitProc;
  ExitProc := @ExitDrivers;
end.
