
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                   EDITSCR.PAS                   }
{                                                 }
{        The Star Commander screen editor         }
{*************************************************}

program The_Star_Commander_Screen_Editor;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384, 0, 655360}

uses
  LowLevel;

const
{Maximum coordinates}
  MaxX          = 80;
  MaxY          = 25;
{Shadow attribute}
  ShadowAttr    = $07;
{Length of screen buffer}
  BufferMax     = MaxX * MaxY;
{Segment of the screen}
  ScreenSeg     = $B800;
{Hexadecimal digits}
  HexNums       : array [0..15] of Char = '0123456789ABCDEF';
{Scan codes of hexadecimal digits}
  HexScanCode   : string[16] = #$81#$78#$79#$7A#$7B#$7C#$7D#$7E#$7F#$80#$1E#$30#$2E#$20#$12#$21;
{Default palette}
  CAppColor =
        #$1B#$30#$1E#$3E#$1E#$07#$30#$30#$0F#$30#$3F#$3E#$0F#$0E#$30 +
    #$33#$70#$7E#$30#$EE#$3F#$3E#$0F#$EE#$3F#$0F#$30#$3F#$0F#$3E#$4F +
    #$4E#$70#$EE#$30#$1E#$0B#$0F#$00#$01;
  EditPal       : string = CAppColor;

var
  Changed,
  Draw,
  Quit          : Boolean;
  CursorX,
  CursorY,
  CountX,
  CountY,
  HexDigit,
  Data,
  Color,
  PrevCol,
  CurCol,
  RunLen,
  ShadowANDAttr : Byte;
  ShadowORAttr  : Byte;
  Temp,
  Count,
  DrawWord,
  KeyCode       : Word;
  ScreenFile    : file of Byte;
  Buffer        : array [0..BufferMax - 1] of Word;

{Print a number onto the screen
  Input : DI: offset to print number to
          AL: number to print}
procedure PrintNum; assembler;
asm
    mov ah, al;
    mov bx, Offset(EditPal);
    and al, $3F;
    or al, al;
    je @1;
    cmp al, PaletteLen;
    ja @1;
    xlat;
    jmp @2;
@1: mov al, ErrorAttr;
@2: xchg al, ah;
    mov bx, Offset(HexNums);
    push ax;
    mov cl, 4;
    shr al, cl;
    xlat;
    stosw;
    pop ax;
    and al, $0F;
    xlat;
    stosw;
end;

procedure SetBlinkBright; assembler;
asm
    xor bl, bl;
    cmp byte ptr EditPal[PaletteLen - 1], 0;
    jne @1;
    inc bl;
@1: mov ax, $1003;
    int $10;
end;

procedure SetShadow; assembler;
asm
    mov bl, byte ptr EditPal[PaletteLen];
    mov ax, $00FF;
    or bl, bl;
    je @1;
    mov ax, $0007;
    dec bl;
    je @1;
    mov ax, ShadowAttr shl 8;
@1: mov ShadowANDAttr, al;
    mov ShadowORAttr, ah;
end;

{Draw the whole buffer onto the screen}
procedure DrawScreen; assembler;
asm
    cld;
    pushf;
    mov bx, Offset(EditPal);
    mov ax, ScreenSeg;
    mov es, ax;
    xor di, di;
    mov si, Offset(Buffer);
    mov cx, BufferMax;
@1: lodsw;
    xchg al, ah;
    mov dl, al;
    mov dh, al;
    and dl, $40;
    and dh, $80;
    cmp byte ptr EditPal[PaletteLen - 1], 0;
    je @7;
    xor dh, dh;
@7: and al, $3F;
    or al, al;
    je @2;
    cmp al, PaletteLen;
    ja @2;
    xlat;
    jmp @6;
@2: mov al, ErrorAttr;
@6: test dl, $40;
    je @3;
    and al, ShadowANDAttr;
    or al, ShadowORAttr;
@3: or al, dh;
    xchg al, ah;
    stosw;
    loop @1;
    popf;
    jnc @4;
    sub di, (MaxX * 2 + 6) * 2;
    mov al, ' ';
    mov ah, ErrorAttr;
    cmp Changed, False;
    je @5;
    mov al, '*';
@5: stosw;
    add di, (MaxX - 1) * 2;
    mov al, CursorY;
    mov ah, MaxX;
    mul ah;
    mov si, ax;
    mov al, CursorX;
    xor ah, ah;
    add si, ax;
    shl si, 1;
    mov al, byte ptr Buffer[si][1];
    call PrintNum;
    add di, (MaxX - 2) * 2;
    mov al, Color;
    call PrintNum;
@4:
end;

{Move the cursor on the screen}
procedure MoveCursor; assembler;
asm
    mov ah, 2;
    xor bh, bh;
    mov dl, CursorX;
    mov dh, CursorY;
    int $10;
end;

{Wait for a keypress and read it in}
procedure GetKey; assembler;
asm
@1: int $28;
    xor ah, ah;
    int $16;
    or ax, ax;
    je @1;
    mov KeyCode, ax;
end;

{Print a string onto the screen
  Input : Y: Y coordinate of the string
          S: string to print}
procedure PrintStr(Y: Word; const S: string); assembler;
asm
    push ds;
    push ds;
    pop es;
    lds si, S;
    cld;
    lodsb;
    mov cl, al;
    xor ch, ch;
    jcxz @1;
    mov ax, Y;
    mov di, MaxX;
    mul di;
    add ax, 59;
    shl ax, 1;
    mov di, ax;
    add di, Offset(Buffer);
    xor ah, ah;
@2: lodsb;
    stosw;
    loop @2;
@1: pop ds;
end;

begin
  if ParamCount < 1 then
  begin
    WriteLn('The Star Commander screen editor by Joe Forster/STA');
    WriteLn;
    WriteLn('Usage: EDITSCR <screen-file>');
  end
  else
  begin
    Assign(ScreenFile, ParamStr(1));
    Reset(ScreenFile);
    if IOResult = 0 then
    begin
      FillChar(Buffer, BufferMax, 0);
      RunLen := 0;
      Color := 0;
      for CountY := 0 to SampleScreenMaxY - 1 do
      begin
        for CountX := 0 to SampleScreenMaxX - 1 do
        begin
          if RunLen = 0 then
          begin
            Read(ScreenFile, Data);
            if Data = 1 then
            begin
              Read(ScreenFile, Color);
              Read(ScreenFile, Data);
            end;
            if Data = 2 then
            begin
              Read(ScreenFile, RunLen);
              Read(ScreenFile, Data);
            end;
          end;
          if RunLen > 0 then Dec(RunLen);
          Buffer[CountX + CountY * MaxX] := Data or (Color shl 8);
        end;
      end;
      Close(ScreenFile);
      SetBlinkBright;
      SetShadow;
      CursorX := 0;
      CursorY := 0;
      Color := 0;
      DrawWord := Ord(' ') + Ord(EditPal[0]) shl 8;
      Changed := False;
      Draw := True;
      Quit := False;
      PrintStr(0, 'Cursor keys, Home,');
      PrintStr(1, 'End, PgUp, PgDn,');
      PrintStr(2, 'alphanumeric keys');
      PrintStr(4, 'Del, BS: Delete char');
      PrintStr(5, 'Ins: Insert char');
      PrintStr(6, 'ESC: Exit editor');
      PrintStr(7, 'F10: Forced exit');
      PrintStr(9, 'F2:  Save screen');
      PrintStr(10, 'F3:  Pick char & attr');
      PrintStr(11, 'F4:  Pick paint attr');
      PrintStr(12, 'F5:  Put char & attr');
      PrintStr(13, 'F6:  F5, crsr advance');
      PrintStr(14, 'F7:  Put paint attr');
      PrintStr(15, 'F8:  F7, crsr advance');
      PrintStr(16, 'F1:  Set blink/bright');
      PrintStr(17, 'F9:  Cycle shadow');
      PrintStr(19, 'Alt+hexa digits:');
      PrintStr(20, '     enter paint attr');
      PrintStr(22, 'File changed:   ');
      PrintStr(23, 'Current attr:');
      PrintStr(24, 'Paint attr  :');
      while not Quit do
      begin
        if Draw then
        begin
          asm
            stc;
            call DrawScreen;
          end;
        end;
        MoveCursor;
        repeat
          GetKey;
          case KeyCode of
            $011B: if not Changed then Quit := True;
            $4400: Quit := True;
            $4B00: if CursorX > 0 then Dec(CursorX);
            $4D00: if CursorX < SampleScreenMaxX - 1 then Inc(CursorX);
            $4800: if CursorY > 0 then Dec(CursorY);
            $5000: if CursorY < SampleScreenMaxY - 1 then Inc(CursorY);
            $4700: CursorX := 0;
            $4F00: CursorX := SampleScreenMaxX - 1;
            $4900: CursorY := 0;
            $5100: CursorY := SampleScreenMaxY - 1;
            $0E08, $5300:
            begin
              asm
                cmp KeyCode, $0E08;
                jne @1;
                cmp CursorX, 0;
                je @2;
                dec CursorX;
            @1: mov al, CursorY;
                mov ah, MaxX;
                mul ah;
                mov di, ax;
                mov al, CursorX;
                xor ah, ah;
                add di, ax;
                shl di, 1;
                mov si, di;
                add si, 2;
                add si, Offset(Buffer);
                add di, Offset(Buffer);
                push ds;
                pop es;
                mov cl, SampleScreenMaxX;
                sub cl, CursorX;
                xor ch, ch;
                cld;
                rep movsw;
                mov ax, ' ';
                sub di, 2;
                stosw;
                mov Draw, True;
                mov Changed, True;
            @2:
              end;
            end;
            $5200:
            begin
              asm
                mov al, CursorY;
                mov ah, MaxX;
                mul ah;
                mov di, ax;
                dec di;
                shl di, 1;
                add di, SampleScreenMaxX * 2;
                mov si, di;
                sub si, 2;
                add si, Offset(Buffer);
                add di, Offset(Buffer);
                push ds;
                pop es;
                mov cl, SampleScreenMaxX;
                sub cl, CursorX;
                dec cl;
                xor ch, ch;
                std;
                rep movsw;
                mov ax, ' ';
                stosw;
                mov ax, $0040;
                mov es, ax;
                and byte ptr es:[$0018], $7F;
                mov Draw, True;
                mov Changed, True;
              end;
            end;
            $3C00:
            begin
              Rewrite(ScreenFile);
              PrevCol := Hi(Buffer[0]) xor $FF;
              if IOResult = 0 then
              begin
                CountX := 0;
                CountY := 0;
                while CountY < SampleScreenMaxY do
                begin
                  Temp := Buffer[CountX + CountY * MaxX];
                  Data := Lo(Temp);
                  CurCol := Hi(Temp);
                  if PrevCol <> CurCol then
                  begin
                    PrevCol := 1;
                    Write(ScreenFile, PrevCol);
                    Write(ScreenFile, CurCol);
                    PrevCol := CurCol;
                  end;
                  RunLen := 0;
                  repeat
                    Inc(CountX);
                    if CountX >= SampleScreenMaxX then
                    begin
                      CountX := 0;
                      Inc(CountY);
                    end;
                    Inc(RunLen);
                  until (CountY >= SampleScreenMaxY) or (Temp <> Buffer[CountX + CountY * MaxX]);
                  if RunLen > 3 then
                  begin
                    CurCol := 2;
                    Write(ScreenFile, CurCol);
                    Write(ScreenFile, RunLen);
                    Write(ScreenFile, Data);
                  end
                  else
                  begin
                    while RunLen > 0 do
                    begin
                      Write(ScreenFile, Data);
                      Dec(RunLen);
                    end;
                  end;
                end;
                Data := 0;
                Write(ScreenFile, Data);
                Close(ScreenFile);
              end;
              Changed := False;
            end;
            $3D00: DrawWord := Buffer[CursorX + CursorY * MaxX];
            $3E00: Color := Hi(Buffer[CursorX + CursorY * MaxX]);
            $3F00, $4000:
            begin
              Buffer[CursorX + CursorY * MaxX] := DrawWord;
              if (KeyCode = $4000) and (CursorX < SampleScreenMaxX - 1) then Inc(CursorX);
              Draw := True;
              Changed := True;
            end;
            $4100, $4200:
            begin
              Buffer[CursorX + CursorY * MaxX] := (Buffer[CursorX + CursorY * MaxX] and $FF) or (Color shl 8);
              if (KeyCode = $4200) and (CursorX < SampleScreenMaxX - 1) then Inc(CursorX);
              Draw := True;
              Changed := True;
            end;
            $3B00:
            begin
              EditPal[PaletteLen - 1] := Chr(Ord(EditPal[PaletteLen - 1]) xor $01);
              SetBlinkBright;
            end;
            $4300:
            begin
              EditPal[PaletteLen] := Chr((Ord(EditPal[PaletteLen]) + 1) mod 3);
              SetShadow;
            end;
          else
            if (Lo(KeyCode) >= Ord(' ')) or (Hi(KeyCode) = 0) then
            begin
              Buffer[CursorX + CursorY * MaxX] := Lo(KeyCode) + Color shl 8;
              if CursorX < SampleScreenMaxX - 1 then Inc(CursorX);
              Draw := True;
              Changed := True;
            end
            else
            begin
              HexDigit := Pos(Chr(Hi(KeyCode)), HexScanCode);
              if HexDigit > 0 then
              begin
                Color := Color shl 4 or (HexDigit - 1);
                Draw := True;
              end
              else
              begin
                KeyCode := 0;
              end;
            end;
          end;
        until KeyCode <> 0;
      end;
      asm
        xor al, al;
        mov CursorX, al;
        mov CursorY, al;
        call MoveCursor;
        push ds;
        pop es;
        mov di, Offset(Buffer);
        mov cx, BufferMax;
        mov ax, ' ';
        cld;
        rep stosw;
        clc;
        call DrawScreen;
      end;
    end;
  end;
end.
