
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                  EXTFILES.PAS                   }
{                                                 }
{      The Star Commander extended file unit      }
{*************************************************}

unit ExtFiles;

{$A+,B-,D+,E-,F+,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  DOS;

const
{Directory separator character}
  chDirSep      = '\';
{Path component separator character}
  chPathSep     = ';';

type
{64-bit signed long long integer}
  Longlongint   = record
    LoLongint,
    HiLongint   : Longint;
  end;
{Extended file record}
  ExtFile       = record
    Orig        : file;
    LongName    : string;
    LongSize    : Longlongint;
  end;
  PExtFile      = ^ExtFile;
{Extended search record}
  ExtSearchRec  = record
    Orig        : SearchRec;
    HandleUsed  : Boolean;
    LongHandle  : Word;
    LongName    : string;
    LongSize    : Longlongint;
  end;
{Extended free space structure}
  ExtFreeSpaceRec= record
    StrucSize   : Word;
    StrucVer    : Word;
    SecPerClus  : Longint;
    BytePerSec  : Longint;
    FreeClus    : Longint;
    TotalClus   : Longint;
    PhysFreeSec : Longint;
    PhysTotalSec: Longint;
    PhysFreeClus: Longint;
    PhysTotalClus: Longint;
    Reserved    : array [0..7] of Byte;
  end;
{Windows-style search record}
  LongSearchRec = record
    Attr        : Longint;
    CreTimeLo   : Longint;
    CreTimeHi   : Longint;
    AccTimeLo   : Longint;
    AccTimeHi   : Longint;
    Time        : Longint;
    TimeHi      : Longint;
    SizeHi      : Longint;
    Size        : Longint;
    Reserved    : array [0..7] of Byte;
    LongName    : array [0..259] of Byte;
    ShortName   : array [0..13] of Byte;
  end;

var
  LongNames     : Boolean;

procedure LongintToLonglongint(var Dest: Longlongint; Src: Longint);
function LonglongintToLongint(const Src: Longlongint): Longint;
procedure IncLonglongint(var Dest: Longlongint; Src: Longint);
procedure AddLonglongint(var Dest: Longlongint; const Src1, Src2: Longlongint);
procedure MulLonglongintByLongint(var Dest: Longlongint; const Src1: Longlongint; Src2: Longint);
function DivLonglongintByWord(var Dest: Longlongint; const Src1: Longlongint; Src2: Word): Word;
function CompLonglongint(const Num1, Num2: Longlongint): Integer;
function RemoveQuotes(Str: string): string;
function AddToPath(const P, S: string; C: Char): string;
function GetPath(const S: string; C: Char): string;
function CutPath(const S: string; C: Char): string;
procedure SplitPath(var P, N: string);
function CorrectDOSName(Name: string; UpCase: Boolean): string;
procedure ExecLFN;
function LongParamStr(Index: Byte): string;
procedure LongFSplit(const Path: string; var Dir, Name, Ext: string);
function TrueName(Name: string): string;
function ShortName(const Name: string; Path: Boolean): string;
function LongName(const Name: string; Path: Boolean): string;
procedure DropLongName(var Name: string);
procedure LongMkDir(Name: string);
procedure LongRmDir(Name: string);
procedure ChDrive(Drive: Char);
procedure LongChDir(S: string);
procedure LongErase(Name: string);
procedure LongGetFAttr(const Name: string; var Attr: Word);
procedure LongSetFAttr(const Name: string; Attr: Word);
function LongGetDir(D: Byte): string;
procedure LongFindFirst(Path: string; Attr: Byte; var F: ExtSearchRec);
procedure LongFindNext(var F: ExtSearchRec);
procedure LongRename(OrigName, NewName: string);
function LongOpenFile(Name: string; var F: ExtFile; Mode: Byte): Integer;
procedure LongFindClose(var F: ExtSearchRec);
function LongFExpand(Path: string): string;
procedure LongDiskSpace(var Dest: ExtFreeSpaceRec; Drive: Char);
procedure LongDiskFree(var Dest: Longlongint; Drive: Char);
procedure ExtBlockRead(var F: ExtFile; var Buf; Count: Word);
procedure ExtBlockRead2(var F: ExtFile; var Buf; Count: Word; var Result: Word);
procedure ExtBlockWrite(var F: ExtFile; var Buf; Count: Word);
procedure ExtBlockWrite2(var F: ExtFile; var Buf; Count: Word; var Result: Word);
procedure ExtClose(var F: ExtFile);
function ExtIsClosed(var F: ExtFile): Boolean;
function ExtEOF(var F: ExtFile): Boolean;
procedure ExtSeek(var F: ExtFile; Pos: Longint);
function ExtFileSize(var F: ExtFile): Longint;
function ExtFilePos(var F: ExtFile): Longint;
procedure ExtTruncate(var F: ExtFile);
procedure ExtGetFTime(var F: ExtFile; var Time: Longint);
procedure ExtSetFTime(var F: ExtFile; Time: Longint);

implementation

uses
  Menus,
  Base2, Constant, Drivers, LowLevel;

{Extended DOS functions}
function ExtFExpand(Path: string): string; external;
procedure ExtGetDir(D: Byte; var S: string); external;
{$L EXTDOS.OBJ}

{Convert a 32-bit signed long integer to a 64-bit signed long long integer
  Input : Dest: the long long integer
          Src: the long integer}
procedure LongintToLonglongint(var Dest: Longlongint; Src: Longint); assembler;
asm
    les di, Dest;
    mov ax, word ptr Src[0];
    mov dx, word ptr Src[2];
    xor cx, cx;
    or dx, dx;
    jns @1;
    not cx;
@1: mov word ptr es:[di].Longlongint.LoLongint[0], ax;
    mov word ptr es:[di].Longlongint.LoLongint[2], dx;
    mov word ptr es:[di].Longlongint.HiLongint[0], cx;
    mov word ptr es:[di].Longlongint.HiLongint[2], cx;
end;

{Convert a 64-bit signed long long integer to a 32-bit signed long integer
  Input : Src: the long long integer
  Output: the long integer}
function LonglongintToLongint(const Src: Longlongint): Longint; assembler;
asm
    les di, Src;
    mov ax, word ptr es:[di].Longlongint.LoLongint[0];
    mov dx, word ptr es:[di].Longlongint.LoLongint[2];
    mov cx, word ptr es:[di].Longlongint.HiLongint[0];
    mov bx, word ptr es:[di].Longlongint.HiLongint[2];
    or dx, dx;
    js @1;
    or cx, bx;
    je @2;
@1: mov ax, 0FFFFh;
    mov dx, 7FFFh;
@2: or bx, bx;
    jns @3;
    not ax;
    not dx;
@3:
end;

{Add a 32-bit signed long integer to a 64-bit signed long long integer
  Input : Dest: the long long integer
          Src: the long integer}
procedure IncLonglongint(var Dest: Longlongint; Src: Longint); assembler;
asm
    les di, Dest;
    mov ax, word ptr Src[0];
    mov dx, word ptr Src[2];
    xor cx, cx;
    or dx, dx;
    jns @1;
    not cx;
@1: add word ptr es:[di].Longlongint.LoLongint[0], ax;
    adc word ptr es:[di].Longlongint.LoLongint[2], dx;
    adc word ptr es:[di].Longlongint.HiLongint[0], cx;
    adc word ptr es:[di].Longlongint.HiLongint[2], cx;
end;

{Add two 64-bit signed long long integers
  Input : Dest: the resulting long long integer
          Src1, Src2: the source long long integers}
procedure AddLonglongint(var Dest: Longlongint; const Src1, Src2: Longlongint); assembler;
asm
    les di, Src1;
    mov ax, word ptr es:[di].Longlongint.LoLongint[0];
    mov dx, word ptr es:[di].Longlongint.LoLongint[2];
    mov cx, word ptr es:[di].Longlongint.HiLongint[0];
    mov bx, word ptr es:[di].Longlongint.HiLongint[2];
    les di, Src2;
    add ax, word ptr es:[di].Longlongint.LoLongint[0];
    adc dx, word ptr es:[di].Longlongint.LoLongint[2];
    adc cx, word ptr es:[di].Longlongint.HiLongint[0];
    adc bx, word ptr es:[di].Longlongint.HiLongint[2];
    les di, Dest;
    mov word ptr es:[di].Longlongint.LoLongint[0], ax;
    mov word ptr es:[di].Longlongint.LoLongint[2], dx;
    mov word ptr es:[di].Longlongint.HiLongint[0], cx;
    mov word ptr es:[di].Longlongint.HiLongint[2], bx;
end;

{Multiply a 64-bit signed long long integer by a 32-bit signed long integer
  Input : Dest: the resulting long long integer
          Src1: the multiplicand long long integer
          Src2: the multiplier long integer}
procedure MulLonglongintByLongint(var Dest: Longlongint; const Src1: Longlongint; Src2: Longint); assembler;
asm
    les di, Src1;
    mov ax, word ptr es:[di].Longlongint.LoLongint[0];
    mov dx, word ptr es:[di].Longlongint.LoLongint[2];
    mov cx, word ptr Src2[0];
    mov bx, word ptr Src2[2];
    call @2;
    les di, Dest;
    mov word ptr es:[di].Longlongint.LoLongint[0], ax;
    mov word ptr es:[di].Longlongint.LoLongint[2], dx;
    les di, Src1;
    mov ax, word ptr es:[di].Longlongint.HiLongint[0];
    mov dx, word ptr es:[di].Longlongint.HiLongint[2];
    les di, Dest;
    mov word ptr es:[di].Longlongint.HiLongint[0], cx;
    mov word ptr es:[di].Longlongint.HiLongint[2], bx;
    mov cx, word ptr Src2[0];
    mov bx, word ptr Src2[2];
    call @2;
    les di, Dest;
    add word ptr es:[di].Longlongint.HiLongint[0], ax;
    adc word ptr es:[di].Longlongint.HiLongint[2], dx;
    jmp @1;
@2: cmp Test8086, 2;
    jmp @3;
    jb @3;
    db $66; shl ax, $10; {shl eax, $10}
    db $66, $0F, $AC, $D0, $10; {shrd eax, edx, $10}
    db $66; shl cx, $10; {shl ecx, $10}
    db $66, $0F, $AC, $D9, $10; {shrd ecx, ebx, $10}
    db $66; imul cx; {imul ecx}
    db $66; mov cx, dx; {mov ecx, edx}
    db $66, $0F, $A4, $C2, $10; {shld edx, eax, $10}
    db $66, $0F, $A4, $CB, $10; {shld ebx, ecx, $10}
    jmp @4;
@3: push bp;
    mov si, ax;
    mov di, dx;
    mul cx;
    push ax;
    push dx;
    mov ax, di;
    mul cx;
    pop bp;
    add ax, bp;
    adc dx, 0;
    push ax;
    push dx;
    mov ax, si;
    mul bx;
    push ax;
    push dx;
    mov ax, di;
    mul bx;
    pop bp;
    add ax, bp;
    adc dx, 0;
    mov bx, dx;
    mov cx, ax;
    pop dx;
    pop si;
    pop di;
    pop ax;
    add dx, di;
    adc cx, si;
    adc bx, 0;
    pop bp;
@4: retn;
@1:
end;

{Divide a 64-bit signed long long integer by a 16-bit unsigned integer
  Input : Dest: the resulting long long integer
          Src1: the dividend long long integer
          Src2: the divisor integer
  Output: the remainder}
function DivLonglongintByWord(var Dest: Longlongint; const Src1: Longlongint; Src2: Word): Word; assembler;
asm
    les di, Src1;
    mov ax, word ptr es:[di].Longlongint.HiLongint[2];
    xor dx, dx;
    mov cx, Src2;
    call @2;
    jc @X2;
    les di, Dest;
    mov word ptr es:[di].Longlongint.HiLongint[2], ax;
    les di, Src1;
    mov ax, word ptr es:[di].Longlongint.HiLongint[0];
    mov dx, cx;
    mov cx, Src2;
    call @2;
    les di, Dest;
    mov word ptr es:[di].Longlongint.HiLongint[0], ax;
    add word ptr es:[di].Longlongint.HiLongint[2], dx;
    les di, Src1;
    mov ax, word ptr es:[di].Longlongint.LoLongint[2];
    mov dx, cx;
    mov cx, Src2;
    call @2;
    les di, Dest;
    mov word ptr es:[di].Longlongint.LoLongint[2], ax;
    add word ptr es:[di].Longlongint.HiLongint[0], dx;
    les di, Src1;
    mov ax, word ptr es:[di].Longlongint.LoLongint[0];
    mov dx, cx;
    mov cx, Src2;
    call @2;
    les di, Dest;
    mov word ptr es:[di].Longlongint.LoLongint[0], ax;
    add word ptr es:[di].Longlongint.LoLongint[2], dx;
    mov ax, cx;
    jmp @1;
@2: xor bx, bx;
    cmp Test8086, 2;
    jb @3;
    db $66; shl ax, $10; {shl eax, $10}
    db $66, $0F, $AC, $D0, $10; {shrd eax, edx, $10}
    db $66; shl cx, $10; {shl ecx, $10}
    db $66, $0F, $AC, $D9, $10; {shrd ecx, ebx, $10}
    je @X1;
    db $66; cwd; {cdq}
    db $66; idiv cx; {idiv ecx}
    db $66; mov cx, dx; {mov ecx, edx}
    db $66, $0F, $A4, $C2, $10; {shld edx, eax, $10}
    db $66, $0F, $A4, $CB, $10; {shld ebx, ecx, $10}
    jmp @4;
@3: push bp;
    xor bp, bp;
    or dx, dx;
    jns @5;
    inc bp;
    neg ax;
    adc dx, 0;
    neg dx;
@5: or bx, bx;
    je @6;
    jns @7;
    inc bp;
    inc bp;
    neg cx;
    adc bx, 0;
    neg bx;
    je @8;
@7: push bp;
    mov si, cx;
    mov di, bx;
    xor bx, bx;
    mov cx, dx;
    mov dx, ax;
    xor ax, ax;
    mov bp, $10;
@10:shl ax, 1;
    rcl dx, 1;
    rcl cx, 1;
    rcl bx, 1;
    inc ax;
    sub cx, si;
    sbb dx, di;
    jae @9;
    dec ax;
    add cx, si;
    adc bx, di;
@9: dec bp;
    jne @10;
    pop bp;
    jmp @11;
@11:pop bp;
    jmp @X1;
@6: jcxz @11;
@8: xchg bx, ax;
    xchg dx, ax;
    div cx;
    xchg bx, ax;
    div cx;
    mov cx, dx;
    mov dx, bx;
    xor bx, bx;
    shr bp, 1;
    jae @12;
    neg cx;
    adc bx, 0;
    neg bx;
    inc bp;
@12:dec bp;
    jne @13;
    neg ax
    adc dx, 0;
    neg dx;
@13:pop bp;
@4: clc;
    retn;
@X1:stc;
    retn;
@1:
@X2:
end;

{Compare two 64-bit signed long long integers
  Input : Num1, Num2: the long long integers
  Output: -1, if the first number is higher than the second; 0, if equal;
          1; if lower}
function CompLonglongint(const Num1, Num2: Longlongint): Integer; assembler;
asm
    push ds;
    lds si, Num1;
    les di, Num2;
    mov ax, word ptr [si].Longlongint.HiLongint[2];
    cmp ax, word ptr es:[di].Longlongint.HiLongint[2];
    ja @2;
    jb @3;
    mov ax, word ptr [si].Longlongint.HiLongint[0];
    cmp ax, word ptr es:[di].Longlongint.HiLongint[0];
    ja @2;
    jb @3;
    mov ax, word ptr [si].Longlongint.LoLongint[2];
    cmp ax, word ptr es:[di].Longlongint.LoLongint[2];
    ja @2;
    jb @3;
    mov ax, word ptr [si].Longlongint.LoLongint[0];
    cmp ax, word ptr es:[di].Longlongint.LoLongint[0];
    ja @2;
    jb @3;
    xor ax, ax;
    jmp @1;
@2: mov ax, 1;
    jmp @1;
@3: mov ax, -1;
    jmp @1;
@1: pop ds;
end;

{Remove quotation marks from DOS paths and file names
  Input : Str: the original string
  Output: the string without quotation marks}
function RemoveQuotes(Str: string): string;
var
  W,
  X             : Word;
  S             : string;
begin
  X := 0;
  for W := 1 to Length(Str) do
  begin
    if Str[W] <> '"' then
    begin
      Inc(X);
      S[X] := Str[W];
    end;
  end;
  S[0] := Chr(X);
  RemoveQuotes := S;
end;

{Append a file name to a path
  Input : P: the path
          S: the file name
          C: the character dividing directories
  Output: the fully qualified file name}
function AddToPath(const P, S: string; C: Char): string;
var
  T             : string;
  W             : Word;
begin
  if P = '' then
  begin
    AddToPath := S;
  end
  else
  begin
    T := P;
    if Length(T) + Length(S) > 253 then T[0] := Chr(253 - Length(S));
    W := Length(T);
    if T[W] = '"' then Dec(W);
    if not (T[W] in [C, ':']) then T := T + C;
    AddToPath := T + S;
  end;
end;

{Get the path part of a file name
  Input : S: the fully qualified file name
          C: the character dividing directories
  Output: the path part of the file name}
function GetPath(const S: string; C: Char): string;
var
  B             : Word;
  T             : string;
begin
  B := RightPos(C, S);
  if (B = 0) and (Length(S) >= 2) and (S[2] = ':') then B := 2;
  if (B >= 2) and (S[B] = C) and (S[B - 1] <> ':') then Dec(B);
  T := Copy(S, 1, B);
  GetPath := T;
end;

{Cut the path off of a file name
  Input : S: the fully qualified file name
          C: the character dividing directories
  Output: the file name itself without the path}
function CutPath(const S: string; C: Char): string;
var
  B             : Word;
begin
  B := RightPos(C, S);
  if (B = 0) and (Length(S) >= 2) and (S[2] = ':') then B := 2;
  CutPath := Copy(S, B + 1, MaxStrLen);
end;

{Cut the last directory off of the path
  Input : P: the full path and the straing to contain the new path
          N: the string to contain the last directory}
procedure SplitPath(var P, N: string);
var
  B             : Word;
begin
  B := RightPos(chDirSep, P);
  if B = 0 then B := LeftPos(':', P);
  N := Copy(P, B + 1, MaxStrLen);
  P := Copy(P, 1, B);
  if (B > 1) and (P[B] = chDirSep) and (P[B - 1] <> ':') then Dec(P[0]);
end;

{Cut the parts of the DOS file name into the standard form of a 8 character
  name, a dot and a 3 character extension
  Input : Name: the original DOS file name
  Output: the corrected file name}
function CorrectDOSName(Name: string; UpCase: Boolean): string;
var
  P             : Byte;
  S             : string;
begin
  Name := CutChar(Name, ' ');
  if Name = stParentDir then
  begin
    S := Name;
  end
  else
  begin
    P := RightPos('.', Name);
    if P = 0 then
    begin
       S := CutChar(Copy(Name, 1, 8), ' ');
    end
    else
    begin
      if P > 8 then S := Copy(Name, 1, 8) else S := Copy(Name, 1, P - 1);
      S := CutChar(S, ' ');
      if P < Length(Name) then S := S + stDot + Copy(Name, P + 1, 3);
    end;
  end;
  if UpCase then CorrectDOSName := UpperCase(S) else CorrectDOSName := LowerCase(S);
end;

{Execute a Windows-style long file name function and return error if the
  function is not supported
  Input : AL: DOS function number
          Other registers: all parameters of the function
  Output: CF: when not zero, an error occured
          AX: error code}
procedure ExecLFN; assembler;
asm
    push ds;
    push ax;
    mov ax, Seg(InOutRes);
    mov ds, ax;
    cmp LongNames, False;
    pop ax;
    pop ds;
    jne @1;
    mov ax, deNoLongNames;
    stc;
    jmp @2;
@1: mov ah, $71;
    stc;
    int $21;
    jc @2;
    cmp ax, deNoLongNames;
    stc;
    je @2;
    clc;
@2:
end;

{Get a long file name from the command line
  Input : Index: the number of the command line parameter; 0 not supported;
          when 255, the complete command line is returned
  Output: the command line parameter}
function LongParamStr(Index: Byte): string; assembler;
asm
    push ds;
    mov dl, Index;
    or dl, dl;
    je @12;
    xor dh, dh;
    mov ax, PrefixSeg;
    mov ds, ax;
    mov di, $0080;
    mov cl, [di];
    xor ch, ch;
    inc di;
    xor bx, bx;
    xor ah, ah;
@1: jcxz @3;
@2: mov al, [di];
    or al, al;
    jne @13;
    xor cx, cx;
    jmp @3;
@13:cmp al, '"';
    jne @7;
    xor ah, 1;
    inc di;
    dec cx;
    jmp @3;
@7: cmp al, ' ';
    ja @3;
    inc di;
    loop @2;
@3: mov si, di;
    jcxz @5;
@4: mov al, [di];
    or al, al;
    jne @14;
    xor cx, cx;
    jmp @5;
@14:cmp al, '"';
    jne @8;
    xor ah, 1;
@8: cmp dl, MaxByte;
    je @9;
    cmp al, ' ';
    ja @9;
    or ah, ah;
    je @5;
@9: inc di;
    loop @4;
@5: mov ax, di;
    sub ax, si;
    je @6;
    cmp dl, MaxByte;
    je @6;
    dec dx;
    jnz @1;
@6: les di, @Result;
    mov bx, di;
    inc di;
    xor dl, dl;
    mov cx, ax;
    jcxz @12;
@11:lodsb;
    cmp al, '"';
    je @10;
    stosb;
    inc dl;
@10:loop @11;
@12:mov es:[bx], dl;
    pop ds;
end;

(* ?ASM? *)
{Split a long file name that contains the path, name and extension of the
  file
  Input : Path: the full file name
          Dir: the string to contain the path
          Name: the string to contain the file name
          Ext: the string to contain the extension}
procedure LongFSplit(const Path: string; var Dir, Name, Ext: string); assembler;
asm
    push ds;
    cld;
    lds si, Path;
    lodsb;
    mov dl, al;
    xor dh, dh;
    mov bx, dx;
    or bx, bx;
    je @2;
@1: cmp byte ptr [si][bx][-1], chDirSep;
    je @2;
    cmp byte ptr [si][bx][-1], ':';
    je @2;
    dec bx;
    jne @1;
@2: mov ax, MaxStrLen;
    les di, Dir;
    call @7;
    mov bx, dx;
    or bx, bx;
    je @4;
@3: dec bx;
    or bx, bx;
    jne @5;
    mov bx, dx;
    jmp @4;
@5: cmp byte ptr [si][bx], '.';
    jne @3;
@4: mov ax, MaxStrLen;
    les di, Name;
    call @7;
    mov bx, dx;
    mov ax, MaxStrLen;
    les di, Ext;
    call @7;
    pop ds;
    jmp @8;
@7: sub dx, bx;
    cmp ax, bx;
    jb @6;
    mov ax, bx;
@6: stosb;
    mov cx, ax;
    add bx, si;
    rep movsb;
    mov si, bx;
    retn;
@8:
end;

{Get the true name of a file, skipping ASSIGN, JOIN, SUBST and network
  redirections
  Input : Name: the original file name
  Output: the true file name}
function TrueName(Name: string): string;
var
  W             : Word;
  S             : string;
begin
  Name := RemoveQuotes(Name);
  asm
    push ds;
    push ss;
    pop ds;
    push ss;
    pop es;
    lea si, Name;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    lea di, S;
    inc di;
    xor cx, cx;
    mov al, $60;
    call ExecLFN;
    jnc @1;
    mov W, ax;
    xor bl, bl;
    cmp ax, deNoLongNames;
    jne @2;
    mov ah, $60;
    int $21;
    mov W, ax;
    mov bl, 0;
    jc @2;
@1: xor al, al;
    mov bx, di;
    mov cx, MaxStrLen + 1;
    cld;
    repne scasb;
    sub bx, di;
    neg bx;
    dec bx;
@2: mov byte ptr S[0], bl;
    pop ds;
  end;
  TrueName := S;
end;

{Execute a Windows-style file name conversion function with a file name as an
  argument and return the resulting file name
  Input : Name: the original file name
          Code: file name conversion code (1 to convert to short, 2 to
                convert to long file name)
          Path: when True, the path part of the result is also kept
  Output: the resulting file name}
function OtherName(Name: string; Code: Byte; Path: Boolean): string;
var
  W             : Word;
  S             : string;
begin
  asm
    push ds;
    push ss;
    pop ds;
    push ss;
    pop es;
    lea si, Name;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    lea di, S;
    inc di;
    mov cl, Code;
    xor ch, ch;
    mov al, $60;
    call ExecLFN;
    mov W, ax;
    mov bl, 0;
    jc @1;
    xor al, al;
    mov bx, di;
    mov cx, MaxStrLen + 1;
    cld;
    repne scasb;
    sub bx, di;
    neg bx;
    dec bx;
@1: mov byte ptr S[0], bl;
    pop ds;
  end;
  if S = '' then if W = deNoLongNames then S := AddToPath(GetPath(Name, chDirSep),
    CorrectDOSName(CutPath(Name, chDirSep), True), chDirSep) else S := Name;
  if not Path then S := CutPath(CutPath(S, chDirSep), '/');
  OtherName := S;
end;

{Process a file or path name component by component, converting it to full long
  or short form
  Input : Name: the file ort path name to process
          Code: file name conversion code (1 to convert to short, 2 to
                convert to long file name)
          Path: when True, the path part of the result is kept
  Output: the long file name}
function ProcessName(const Name: string; Code: Byte; Path: Boolean): string;
var
  B             : Byte;
  P,
  S,
  T             : string;
begin
  S := RemoveQuotes(Name);
  P := '';
  if (Length(S) >= 2) and (S[2] = ':') and (UpCase(S[1]) in ['A'..'Z']) then
  begin
    B := 2;
    if (Length(S) >= 3) and (S[3] = chDirSep) then Inc(B);
    P := UpperCase(Copy(S, 1, B));
    S := Copy(S, B + 1, MaxStrLen);
  end;
  while S <> '' do
  begin
    B := LeftPos(chDirSep, S);
    if B = 0 then
    begin
      T := S;
      S := '';
    end
    else
    begin
      T := Copy(S, 1, B - 1);
      if T = '' then T := chDirSep;
      S := Copy(S, B + 1, MaxStrLen);
    end;
    if (T <> chDirSep) and (T <> stCurrentDir) and (T <> stParentDir) then
      T := OtherName(AddToPath(P, T, chDirSep), Code, False);
    if (T <> '') and (not LongFileNames or (T = UpperCase(T)) or (T = LowerCase(T))) then
      if B = 0 then T := LowerCase(T) else if not KeepLowerCase then T := UpperCase(T);
    P := AddToPath(P, T, chDirSep);
  end;
  if not Path then P := CutPath(P, chDirSep);
  ProcessName := P;
end;

{Get the short file name for a Windows-style long file name; if Windows is not
  present, the original file name is returned
  Input : Name: the long file name
          Path: when True, the path part of the result is kept
  Output: the short file name}
function ShortName(const Name: string; Path: Boolean): string;
begin
  ShortName := ProcessName(Name, 1, Path);
end;

{Get the Windows-style long file name for a short file name; if Windows is not
  present, the original file name is returned
  Input : Name: the short file name
          Path: when True, the path part of the result is kept
  Output: the long file name}
function LongName(const Name: string; Path: Boolean): string;
var
  S             : string;
begin
  S := ProcessName(Name, 2, Path);
  if (S = '') or ((S = UpperCase(S)) and (S = UpperCase(Name))) then
    S := AddToPath(UpperCase(GetPath(Name, chDirSep)), LowerCase(CutPath(Name, chDirSep)), chDirSep);
  LongName := S;
end;

{Convert a full lowercase file name to full uppercase}
procedure DropLongName(var Name: string);
var
  S             : string;
begin
  Name := RemoveQuotes(Name);
  S := CutPath(Name, chDirSep);
  if not LongFileNames then S := CorrectDOSName(S, True);
  if not LongFileNames or (not KeepLowerCase and (S = LowerCase(S))) then
    Name := AddToPath(GetPath(Name, chDirSep), UpperCase(S), chDirSep);
end;

{Create a directory
  Input : Name: the name of the directory to create}
procedure LongMkDir(Name: string);
begin
  DropLongName(Name);
  asm
    push ds;
    push ss
    pop ds;
    lea si, Name;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    mov dx, si;
    mov al, $39;
    call ExecLFN;
    jc @1;
    xor ax, ax;
@1: pop ds;
    mov InOutRes, ax;
  end;
  if InOutRes = deNoLongNames then
  begin
    InOutRes := 0;
    MkDir(Name);
  end;
end;

{Remove a directory
  Input : Name: the name of the directory to remove}
procedure LongRmDir(Name: string);
begin
  Name := RemoveQuotes(Name);
  asm
    push ds;
    push ss
    pop ds;
    lea si, Name;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    mov dx, si;
    mov al, $3A;
    call ExecLFN;
    jc @1;
    xor ax, ax;
@1: pop ds;
    mov InOutRes, ax;
  end;
  if InOutRes = deNoLongNames then
  begin
    InOutRes := 0;
    RmDir(Name);
  end;
end;

{Change the current drive
  Input : Drive: the drive to change to}
procedure ChDrive(Drive: Char); assembler;
asm
    mov ah, $0E;
    mov dl, Drive;
    and dl, $1F;
    dec dl;
    int $21;
end;

{Change the current directory
  Input : S: the directory to change to}
procedure LongChDir(S: string);
var
  D             : Char;
begin
  S := RemoveQuotes(S);
  if (Length(S) >= 3) and (S[2] = ':') then
  begin
    D := UpCase(S[1]);
    if D in ['A'..'Z'] then
    begin
      S := Copy(S, 3, MaxStrLen);
      asm
        mov dl, D;
        sub dl, 'A';
        mov ah, $0E;
        int $21;
      end;
    end;
  end;
  asm
    push ds;
    push ss;
    pop ds;
    lea si, S;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    mov dx, si;
    mov al, $3B;
    call ExecLFN;
    jc @1;
    xor ax, ax;
@1: pop ds;
    mov InOutRes, ax;
  end;
  if InOutRes = deNoLongNames then
  begin
    InOutRes := 0;
    ChDir(S);
  end;
end;

{Erase a file
  Input : Name: the name of the file to erase}
procedure LongErase(Name: string);
var
  F             : file;
begin
  Name := RemoveQuotes(Name);
  asm
    push ds;
    push ss;
    pop ds;
    lea si, Name;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    mov dx, si;
    xor si, si;
    mov al, $41;
    call ExecLFN;
    jc @1;
    xor ax, ax;
@1: pop ds;
    mov InOutRes, ax;
  end;
  if InOutRes = deNoLongNames then
  begin
    InOutRes := 0;
    Assign(F, Name);
    Erase(F);
  end;
end;

{Get or set different attributes of a file
  Input : Name: the name of the file to process
          Code: when 0, attributes are read, otherwise written
          Attr: attribute to set or get}
procedure LongAttrib(Name: string; Code: Byte; var Attr: Longint);
var
  W             : Word;
  F             : file;
begin
  Name := RemoveQuotes(Name);
  if (Length(Name) = 2) and (Name[2] = ':') and (UpCase(Name[1]) in ['A'..'Z']) then Name := Name + stCurrentDir;
  asm
    push ds;
    push ss;
    pop ds;
    les si, Attr;
    mov cx, word ptr es:[si][0];
    mov di, word ptr es:[si][2];
    lea si, Name;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    mov dx, si;
    mov bl, Code;
    mov al, $43;
    call ExecLFN;
    jc @1;
    xor ax, ax;
    jmp @2;
@1: mov cl, Code;
    or cl, cl;
    jne @3;
    xor cx, cx;
    mov di, cx;
@2: les si, Attr;
    mov word ptr es:[si][0], cx;
    mov word ptr es:[si][2], di;
@3: pop ds;
    mov InOutRes, ax;
  end;
  if InOutRes = deNoLongNames then
  begin
    InOutRes := 0;
    Assign(F, Name);
    case Code of
      0:
      begin
        W := 0;
        GetFAttr(F, W);
        if DOSError = 0 then Attr := W;
      end;
      1:
      begin
        W := Attr;
        SetFAttr(F, W);
      end;
    else
      DOSError := 1;
    end;
    InOutRes := DOSError;
    DOSError := 0;
  end;
end;

{Get the attributes of a file
  Input : F: the file record
          Attr: the word to store the attributes into}
procedure LongGetFAttr(const Name: string; var Attr: Word);
var
  L             : Longint;
begin
  LongAttrib(Name, 0, L);
  Attr := L;
end;

{Set the attributes of a file
  Input : F: the file record
          Attr: the word containing the attributes}
procedure LongSetFAttr(const Name: string; Attr: Word);
var
  L             : Longint;
begin
  L := Attr;
  LongAttrib(Name, 1, L);
end;

{Fetch the current directory of a given drive
  Input : D: the drive to fetch the current directory of
  Output: the current directory of the drive}
function LongGetDir(D: Byte): string;
var
  S             : string;
begin
  asm
    push ds;
    mov dl, D;
    push ss;
    pop ds;
    lea si, S[1];
    push ds;
    pop es;
    mov di, si;
    or dl, dl;
    jne @2;
    mov ah, $19;
    int $21;
    inc al;
    mov dl, al;
@2: cld;
    mov al, dl;
    add al, '@';
    stosb;
    mov ax, '\:';
    stosw;
    xor al, al;
    mov es:[di], al;
    mov si, di;
    mov al, $47;
    call ExecLFN;
    jnc @4;
    cmp ax, deFileNotFound;
    jne @3;
    xor ax, ax;
    clc;
    jmp @4;
@3: stc;
@4: mov dx, ax;
    mov bl, 0;
    jc @1;
    xor al, al;
    mov bx, di;
    mov cx, 252;
    cld;
    repne scasb;
    sub bx, di;
    neg bx;
    dec bx;
    xor dx, dx;
@1: add bl, 3;
    mov byte ptr si[-4], bl;
    pop ds;
    mov InOutRes, dx;
  end;
  case InOutRes of
    0: LongGetDir := LongName(AddToPath(S, stEmpty, chDirSep), True);
    deNoLongNames:
    begin
      ExtGetDir(D, S);
      LongGetDir := S;
    end;
  else
    LongGetDir := '';
  end;
end;

{If the file name is a short one then convert it to full lowercase or
  full uppercase, depending on whether it is a file or a directory
  Input : F: the extended search record to contain the entry
          E: the long file name search record containing the entry
          B: length of the long file name
          C: error code returned by DOS}
procedure CorrectName(var F: ExtSearchRec; var E: LongSearchRec; B: Byte; C: Word);
begin
  if DOSError = 0 then
  begin
    case C of
      0:
      begin
        F.Orig.Attr := E.Attr;
        F.Orig.Time := E.Time;
        F.LongSize.LoLongint := E.Size;
        F.LongSize.HiLongint := E.SizeHi;
        F.Orig.Size := LonglongintToLongint(F.LongSize);
        F.LongName[0] := Chr(B);
        Move(E.LongName, F.LongName[1], B);
      end;
      deNoLongNames:
      begin
        F.LongName := F.Orig.Name;
        LongintToLonglongint(F.LongSize, F.Orig.Size);
      end;
    end;
    if (F.LongName = '') or (F.LongName = UpperCase(F.LongName)) then if F.Orig.Attr and Directory = 0 then
      F.LongName := LowerCase(F.LongName) else F.LongName := UpperCase(F.LongName);
  end;
end;

{Find first instance of a file in a directory
  Input : Path: full wildcarded name of files to find
          Attr: allowed attributes
          F: record to store result into}
procedure LongFindFirst(Path: string; Attr: Byte; var F: ExtSearchRec);
var
  B             : Byte;
  C,
  W             : Word;
  E             : LongSearchRec;
begin
  Path := RemoveQuotes(Path);
  asm
    xor ax, ax;
    mov DOSError, ax;
    mov W, ax;
    push ds;
    push ss;
    pop ds;
    push ss;
    pop es;
    lea si, Path;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    lea di, E;
    mov dx, si;
    mov cl, Attr;
    xor ch, ch;
    mov si, 1;
    mov al, $4E;
    call ExecLFN;
    pop ds;
    jc @1;
    mov W, ax;
    xor al, al;
    add di, LongSearchRec.LongName;
    mov bx, di;
    mov cx, MaxStrLen + 1;
    cld;
    repne scasb;
    sub bx, di;
    neg bx;
    dec bx;
    mov byte ptr B, bl;
    jmp @2;
@1: mov DOSError, ax;
@2:
  end;
  C := DOSError;
  case DOSError of
    0:
    begin
      F.HandleUsed := True;
      F.LongHandle := W;
    end;
    deNoLongNames: FindFirst(Path, Attr, F.Orig);
  end;
  CorrectName(F, E, B, C);
end;

{Find next instance of a file in a directory
  Input : F: record to read data from and store result into}
procedure LongFindNext(var F: ExtSearchRec);
var
  B             : Byte;
  C             : Word;
  E             : LongSearchRec;
begin
  asm
    mov DOSError, 0;
    les di, F;
    mov bx, es:[di].ExtSearchRec.LongHandle;
    push ss;
    pop es;
    lea di, E;
    mov si, 1;
    mov al, $4F;
    call ExecLFN;
    jc @1;
    xor al, al;
    add di, LongSearchRec.LongName;
    mov bx, di;
    mov cx, MaxStrLen + 1;
    cld;
    repne scasb;
    sub bx, di;
    neg bx;
    dec bx;
    mov byte ptr B, bl;
    jmp @2;
@1: mov DOSError, ax;
@2:
  end;
  C := DOSError;
  if DOSError = deNoLongNames then FindNext(F.Orig);
  CorrectName(F, E, B, C);
end;

{Close directory search
  Input : F: record to read data from}
procedure LongFindClose(var F: ExtSearchRec); assembler;
asm
    les di, F;
    mov byte ptr es:[di].ExtSearchRec.HandleUsed, 0;
    mov bx, es:[di].ExtSearchRec.LongHandle;
    mov al, $A1;
    call ExecLFN;
end;

{Rename a file to another name
  Input : OrigName: the original name of the file
          NewName: the name to rename the file to}
procedure LongRename(OrigName, NewName: string);
var
  F             : file;
begin
  OrigName := RemoveQuotes(OrigName);
  NewName := RemoveQuotes(NewName);
  DropLongName(NewName);
  asm
    push ds;
    push ss;
    pop ds;
    push ss;
    pop es;
    lea si, OrigName;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    lea di, NewName;
    mov bl, es:[di];
    xor bh, bh;
    inc di;
    mov byte ptr es:[di][bx], 0;
    mov dx, si;
    mov al, $56;
    call ExecLFN;
    jc @1;
    xor ax, ax;
@1: pop ds;
    mov InOutRes, ax;
  end;
  if InOutRes = deNoLongNames then
  begin
    InOutRes := 0;
    Assign(F, OrigName);
    Rename(F, NewName);
  end;
end;

{Open a file with long file name
  Input : Name: the name of the file
          F: the file record
          Mode: access mode to open the file with
  Output: when not 0, an error occured}
function LongOpenFile(Name: string; var F: ExtFile; Mode: Byte): Integer;
var
  B             : Byte;
  W             : Word;
  I             : Integer;
begin
  F.LongName := RemoveQuotes(Name);
  B := 0;
  case Mode of
    fmReadOnly: B := fmShared;
    fmReadWrite, fmWriteOnly: B := fmExclusive;
  end;
  FileMode := Mode or B;
  DropLongName(Name);
  asm
    mov InOutRes, 0;
    push ds;
    mov al, FileMode;
    xor ah, ah;
    push ax;
    push ss;
    pop ds;
    lea si, Name;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    xor di, di;
    mov dx, $01;
    mov bl, al;
    and bl, $0F;
    cmp bl, fmWriteOnly;
    jne @1;
    mov dx, $12;
@1: mov bl, al;
    mov al, $6C;
    xor cx, cx;
    call ExecLFN;
    pop bx;
    jnc @2;
    cmp ax, 5;
    jne @4;
    and bl, $0F;
    mov al, $6C;
    xor cx, cx;
    call ExecLFN;
    jnc @2;
@4: pop ds;
    mov InOutRes, ax;
    xor ax, ax;
    jmp @3;
@2: pop ds;
    les di, F;
    mov es:[di].ExtFile.Orig.FileRec.Mode, fmInOut;
    mov es:[di].ExtFile.Orig.FileRec.RecSize, 1;
@3: mov es:[di].ExtFile.Orig.FileRec.Handle, ax;
  end;
  if InOutRes = deNoLongNames then
  begin
    InOutRes := 0;
    case Mode of
      fmReadOnly, fmReadWrite:
      begin
        Assign(F.Orig, RemoveQuotes(Name));
        GetFAttr(F.Orig, W);
        I := DOSError;
        if I = 0 then
        begin
          Reset(F.Orig, 1);
          I := IOResult;
          if I = deAccessDenied then
          begin
            FileMode := FileMode and fmModeMask;
            Reset(F.Orig, 1);
            I := IOResult;
          end;
          GetFTime(F.Orig, ReadTime);
        end;
      end;
      fmWriteOnly:
      begin
        Assign(F.Orig, Name);
        Rewrite(F.Orig, 1);
        I := IOResult;
        if I = deAccessDenied then
        begin
          FileMode := FileMode and fmModeMask;
          Rewrite(F.Orig, 1);
          I := IOResult;
        end;
      end;
    end;
    F.LongName := Name;
  end
  else
  begin
    if (InOutRes = 0) and (FileMode and fmModeMask <> fmWriteOnly) then
    begin
      GetFTime(F.Orig, ReadTime);
      InOutRes := 0;
    end;
    I := IOResult;
  end;
  LongOpenFile := I;
end;

{Convert a relative file name to an absolute one
  Input : Path: the relative file name
  Output: the absolute file name}
function LongFExpand(Path: string): string;
begin
  LongFExpand := LongName(ExtFExpand(RemoveQuotes(Path)), True);
end;

{Retrieve free and total space details of disk drive
  Input : Dest: extended free space structure
          Drive: the disk drive letter}
procedure LongDiskSpace(var Dest: ExtFreeSpaceRec; Drive: Char);
var
  O             : Boolean;
  S             : string[4];
begin
  S := '?:\'#0;
  S[1] := UpCase(Drive);
  Dest.StrucVer := 0;
  O := False;
  asm
    push ds;
    push ss;
    pop ds;
    lea dx, S[1];
    les di, Dest;
    mov cx, type ExtFreeSpaceRec;
    mov ax, $7303;
    int $21;
    pop ds;
    jc @3;
    or al, al;
    jne @1;
@3: mov ah, $36;
    mov dl, byte ptr S[1];
    sub dl, '@';
    int $21;
    cmp ax, MaxWord;
    je @2;
    les di, Dest;
    xor si, si;
    mov word ptr es:[di].ExtFreeSpaceRec.SecPerClus[0], ax;
    mov word ptr es:[di].ExtFreeSpaceRec.SecPerClus[2], si;
    mov word ptr es:[di].ExtFreeSpaceRec.BytePerSec[0], cx;
    mov word ptr es:[di].ExtFreeSpaceRec.BytePerSec[2], si;
    mov word ptr es:[di].ExtFreeSpaceRec.FreeClus[0], bx;
    mov word ptr es:[di].ExtFreeSpaceRec.FreeClus[2], si;
    mov word ptr es:[di].ExtFreeSpaceRec.TotalClus[0], dx;
    mov word ptr es:[di].ExtFreeSpaceRec.TotalClus[2], si;
@1: inc O;
@2:
  end;
  if not O then Dest.SecPerClus := -1;
end;

{Retrieve free space of disk drive
  Input : Dest: free space
          Drive: the disk drive letter}
procedure LongDiskFree(var Dest: Longlongint; Drive: Char);
var
  X             : ExtFreeSpaceRec;
begin
  LongDiskSpace(X, Drive);
  LongintToLonglongint(Dest, X.BytePerSec);
  MulLonglongintByLongint(Dest, Dest, X.SecPerClus);
  MulLonglongintByLongint(Dest, Dest, X.FreeClus);
end;

{Read a block of data from a file
  Input : F: the file to read the data from
          Buf: the buffer to put the data into
          Count: the number of bytes to read}
procedure ExtBlockRead(var F: ExtFile; var Buf; Count: Word);
begin
  BlockRead(F.Orig, Buf, Count);
end;

{Read a block of data from a file
  Input : F: the file to read the data from
          Buf: the buffer to put the data into
          Count: the number of bytes to read
          Result: the integer to contain the number of bytes that have
                  actually been read}
procedure ExtBlockRead2(var F: ExtFile; var Buf; Count: Word; var Result: Word);
begin
  BlockRead(F.Orig, Buf, Count, Result);
end;

{Write a block of data into a file
  Input : F: the file to write the data into
          Buf: the buffer to get the data from
          Count: the number of bytes to write}
procedure ExtBlockWrite(var F: ExtFile; var Buf; Count: Word);
var
  W             : Word;
begin
  BlockWrite(F.Orig, Buf, Count, W);
  if W < Count then ErrorWin(stEmpty, 'The destination disk is full', F.LongName, hcOnlyQuit, sbNone);
end;

{Write a block of data into a file
  Input : F: the file to write the data into
          Buf: the buffer to get the data from
          Count: the number of bytes to write
          Result: the integer to contain the number of bytes that have
                  actually been written}
procedure ExtBlockWrite2(var F: ExtFile; var Buf; Count: Word; var Result: Word);
begin
  BlockWrite(F.Orig, Buf, Count, Result);
end;

{Truncate a file at the current position
  Input : F: the file to truncate}
procedure ExtTruncate(var F: ExtFile);
begin
  Truncate(F.Orig);
end;

{Close a file
  Input : F: the file to close}
procedure ExtClose(var F: ExtFile);
begin
  Close(F.Orig);
end;

{Determine if a file is open or closed
  Input : F: the file
  Output: when True, the file is closed; otherwise open}
function ExtIsClosed(var F: ExtFile): Boolean;
begin
  case FileRec(F.Orig).Mode of
    0, fmClosed: ExtIsClosed := True;
  else
    ExtIsClosed := False;
  end;
end;

{Determine if a file has reached its end
  Input : F: the file to check
  Output: when True, the end of the file has been reached; otherwise not}
function ExtEOF(var F: ExtFile): Boolean;
begin
  ExtEOF := EOF(F.Orig);
end;

{Seek in a file
  Input : F: the file to seek in
          Pos: the position to seek to}
procedure ExtSeek(var F: ExtFile; Pos: Longint);
begin
  Seek(F.Orig, Pos);
end;

{Determine the size of a file
  Input : F: the file to check
  Output: the size of the file in bytes}
function ExtFileSize(var F: ExtFile): Longint;
begin
  ExtFileSize := FileSize(F.Orig);
end;

{Determine the current position into a file
  Input : F: the file to check
  Output: the current position into the file}
function ExtFilePos(var F: ExtFile): Longint;
begin
  ExtFilePos := FilePos(F.Orig);
end;

{Get the date stamp of a file
  Input : F: the file to get the date stamp of
          Time: the longint to contain the date stamp of the file}
procedure ExtGetFTime(var F: ExtFile; var Time: Longint);
begin
  GetFTime(F.Orig, Time);
end;

{Set the date stamp of a file
  Input : F: the file to set the date stamp of
          Time: the new date stamp of the file}
procedure ExtSetFTime(var F: ExtFile; Time: Longint);
begin
  SetFTime(F.Orig, Time);
end;

end.
