
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                    FCOPY.PAS                    }
{                                                 }
{        The Star Commander file copy unit        }
{*************************************************}

unit FCopy;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Dialogs;

procedure CantCopyToItself(Dir: Boolean);
function CopyFile(var D: PDialog; First, Moving, KeepPC64Mode: Boolean): Boolean;
function CopyDir(var D: PDialog; First, Moving: Boolean): Boolean;

implementation

uses
  DOS, Drivers, Views,
  Base1, Base2, Constant, ExtFiles, FDelete, LowLevel, Panel1, Panel2, XferLo,
  FRenMov, FROpen, FRClose, FRead, FWPrep, FWOpen, FWClose, FWrite;

{Display an error message that a file or directory can't be copied to itself
  Input : Dir: when True, a directory is being copied}
procedure CantCopyToItself(Dir: Boolean);
var
  S             : string[9];
begin
  if Dir then S := stDirectory else S := stFile;
  GoSound := True;
  ContProcess := (SureConfirm(stEmpty, 'You can''t copy a ' + S + ' to itself', Act^.CopyFullName,
    stEmpty, stEmpty, stOK, stEmpty, stEmpty, stEmpty, stEmpty, nil, CurHelpCtx, ayNone, False, DummyByte) = cmOK);
end;

{Copy the specified file during file copy or move
  Input : D: the dialog box that informs the user about the process
          First: when True, this is the first file being copied
          Moving: when True, file copy is done during file move
          KeepPC64Mode: when False, the file copy is switched back to DOS mode
                        after having finished copying a file inside a PC64
                        file image
  Output: when False, an error occured}
function CopyFile(var D: PDialog; First, Moving, KeepPC64Mode: Boolean): Boolean;
var
  F,
  G,
  O,
  W             : Boolean;
  L             : Word;
  X             : Integer;
  Y             : Longint;
  Z             : Longlongint;
  P             : PBuffer;
  S             : string;
begin
  O := False;
  W := False;
  SysErrorOccurred := False;
  if ContProcess and (AppendFile or not ShellBuffer^.SourceOK or PrepareWrite(D, True)) then
  begin
    if Inact^.CopyMode = pmExt then DiskChanged := True;
    CopySize := 1;
    CopiedSize := 0;
    CopiedBlock := 0;
    if ShellBuffer^.SourceOK then TransferProgressWin(D, stEmpty, Act^.CopyFullName, Inact^.CopyFullName, drFile, True);
    if (Act^.CopyMode = Inact^.CopyMode) and (TrueName(Act^.CopyRealPath) = TrueName(Inact^.CopyRealPath)) and
      (((Act^.CopyMode = pmDOS) and (UpperCase(LongName(Act^.CopyName, False)) = UpperCase(LongName(Inact^.CopyName,
      False)))) or ((Act^.CopyImageName = Inact^.CopyImageName) and (Act^.CopyName = Inact^.CopyName))) then
    begin
      CantCopyToItself(False);
    end
    else
    begin
      if OpenRead = 0 then
      begin
        if FileSizeWarning and not (Act^.CopyMode in [pmExt, pmDisk, pmGCRDisk, pmDiskZip, pmSixZip]) and
          (Inact^.CopyMode in [pmDOS, pmExt, pmDisk]) then
        begin
          case Inact^.CopyMode of
            pmDOS:
            begin
              LongDiskFree(Z, Inact^.CopyRealPath[1]);
              Y := LonglongintToLongint(Z);
            end;
            pmExt:
            begin
              Inact^.CopyDiskType := DetectDiskType(ExtendedDisk, True);
              Inact^.CheckDiskType;
              Y := Inact^.CopyDiskSize * 254;
            end;
            pmDisk:
            begin
              if Inact^.OpenImage(False, False, True, True, True) = 0 then
              begin
                Inact^.CopyDiskType := GetDiskType(ExtFileSize(Inact^.Image));
                Inact^.CloseImage(False);
                Inact^.CheckDiskType;
                Y := LonglongintToLongint(Inact^.CopyFree) * 254;
              end;
            end;
          end;
          if CopySize shr 1 > Y then ContProcess := (SureConfirm(stEmpty,
            'The file doesn''t fit onto the destination.', Act^.CopyFullName, 'Do you still wish to copy it?',
            stEmpty, stYes, stEmpty, stEmpty, stEmpty, stNo, nil, CurHelpCtx, ayNone, False, DummyByte) = cmOK);
          Act^.Error := not ContProcess;
        end;
        if ContProcess then
        begin
          O := (Inact^.CopyBackupFile(True));
          W := False;
          if O then
          begin
            FileProcessed := True;
            F := True;
            G := False;
            Inact^.Error := False;
            L := 1;
            CopiedSize := 0;
            CopyBufSize := TSmallBufSize;
            GetMem(P, CopyBufSize);
            S := Inact^.CopyFullName;
            while O and ContProcess and (F or not Act^._End) and not Act^.Error and not Inact^.Error do
            begin
              if G then
              begin
                G := False;
                FreeMem(P, CopyBufSize);
                CopyBufSize := TBufferSize;
                GetMem(P, CopyBufSize);
              end;
              ReadPart(P, L);
              if F and ContProcess then
              begin
                G := True;
                X := OpenWrite(Inact, P, First, False, (L = 0), Inact^.DirTrack);
                if S <> Inact^.CopyFullName then TransferProgressWin(D, stEmpty, Act^.CopyFullName,
                  Inact^.CopyFullName, drFile, True);
                while (X = 254) and DeleteFile(Inact, D, True, True, (L = 0), False) do
                  X := OpenWrite(Inact, P, First, True, (L = 0), Inact^.DirTrack);
                O := (X = 0);
                W := O;
                F := False;
              end;
              if O and ContProcess then WritePart(P, L, Act^._End);
            end;
            FreeMem(P, CopyBufSize);
            if W then CloseWrite(Inact, True);
          end;
        end;
      end;
    end;
    CloseRead;
    if not KeepPC64Mode and (CopyExtractFileImages <> xfNever) and (Act^.CopyMode = pmFile) then Act^.CopyMode := pmDOS;
    if Inact^.Error and (Inact^.CopyMode = pmDOS) and DiskFull then
      ContProcess := (SureConfirm(stEmpty, 'There is not enough room to copy', Act^.CopyFullName + ' to',
      Inact^.CopyFullName, stEmpty, ' '+ColorChar+'C'+ColorChar+'ontinue ', stEmpty, stEmpty, stEmpty, stAbort, nil,
      CurHelpCtx, ayNone, False, DummyByte) = cmOK);
    O := O and (not Act^.Error and not EscPressed and not Inact^.Error);
  end;
  if (not O or not Moving) and not RunningShell then UnselectFile(Act, O);
  CopyFile := O;
end;

{Determine if the destination path is the source path itself or one of its
  subdirectories, in which case no copy or move is done
  Output: when True, no copy or move is done}
function SameCopyPath: Boolean;
var
  S,
  T             : string;
begin
  S := TrueName(Act^.CopyPath);
  T := TrueName(Inact^.CopyPath);
  SameCopyPath := ((S = Copy(T, 1, Length(S))) and ((Length(T) <= Length(S)) or (T[Length(S) + 1] = chDirSep)));
end;

{Sets the new path for the subdirectory being entered; has to be a procedure
  external to "CopyDir" so that stack usage is minimized upon each recursion}
procedure SetSubPath;
begin
  Inact^.CopyPath := LongName(AddToPath(Inact^.CopyPath, AddToPath(Inact^.CopyName, stEmpty, chDirSep), chDirSep), True);
end;

{Sets the new path for the parent directory being entered; has to be a
  procedure external to "CopyDir" so that stack usage is minimized upon each
  recursion}
procedure SetParentPath;
begin
  Inact^.CopyPath := GetPath(Inact^.CopyPath, chDirSep);
end;

{Copy the specified directory and all of its subdirectories during file copy
  or move
  Input : D: the dialog box that informs the user about the process
          First: when True, the first file in this directory will be the
                 first file being copied
          Moving: when True, file copy is done during file move
  Output: when False, an error occured}
function CopyDir(var D: PDialog; First, Moving: Boolean): Boolean;
var
  O             : Boolean;
  B             : Byte;
  W             : Word;
  E             : SearchRec;
begin
  O := False;
  W := Act^.CopyEntry.LongHandle;
  E := Act^.CopyEntry.Orig;
  B := CopyFileMode;
  EnterDir(Act);
  Inact^.CopyAttr := 0;
  SetSubPath;
  if SameCopyPath then
  begin
    TransferProgressWin(D, stEmpty, Act^.CopyFullName, Inact^.CopyPath, drDirectory, True);
    CantCopyToItself(True);
  end
  else
  begin
    InOutRes := 0;
    if not FileExists(Inact^.CopyPath, True) then
    begin
      TransferProgressWin(D, stEmpty, Act^.CopyFullName, Inact^.CopyPath, drDirectory, True);
      LongMkDir(Inact^.CopyPath);
    end;
    if IOResult = 0 then
    begin
      FileProcessed := True;
      O := True;
      while ContDirProcess and ContProcess and not Act^.Error do
      begin
        ContDirProcess := Act^.FindNextFile(False, True, False);
        Act^.CopyAttr := Act^.CopyEntry.Orig.Attr;
        if ContDirProcess then
        begin
          Act^.MakeFullName;
          if Act^.CopyAttr and Directory > 0 then
          begin
            Inact^.CopyName := Act^.CopyName;
            O := CopyDir(D, First, Moving);
            if O then
            begin
              AppendFile := False;
              if Moving and not RunningShell then O := DeleteDir(Act, D, True, False);
              UnselectFile(Act, O);
            end
            else
            begin
              Inc(CopyFileNum);
            end;
            CopyFileMode := cfWildcard;
            Act^.FirstFile := False;
          end
          else
          begin
            if Moving then O := RenMovFile(D, First) else O := CopyFile(D, First, False, False);
          end;
          First := False;
        end;
      end;
      O := O and not EscPressed;
    end
    else
    begin
      if not SysErrorOccurred then ErrorWin(stEmpty, 'Can''t create the directory', Inact^.CopyPath, CurHelpCtx, sbNone);
    end;
  end;
  Act^.CopyEntry.LongHandle := W;
  Act^.CopyEntry.Orig := E;
  CopyFileMode := B;
  LeaveDir(Act);
  SetParentPath;
  CopyDir := O;
end;

end.
