
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                   FDELETE.PAS                   }
{                                                 }
{       The Star Commander file delete unit       }
{*************************************************}

unit FDelete;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Dialogs, Panel1;

function ConfirmDelete(Panel: PPanel; const FileType: string): Boolean;
function ConfirmDeleteReadonly(Panel: PPanel; const FileType: string): Boolean;
function DeleteFile(Panel: PPanel; var D: PDialog; FileCopy, Over, Empty, Next: Boolean): Boolean;
function DeleteDir(Panel: PPanel; var D: PDialog; FileCopy, Next: Boolean): Boolean;

implementation

uses
  DOS, Drivers, Views,
  Base1, Base2, Constant, ExtFiles, FWPrep, LowLevel, MiscFunc, Panel2, XferLo;

{Check the answer for a confirmation question
  Input : Answer: the answer
  Output: when True, the answer was to continue}
function CheckAnswer(Answer: Word): Boolean;
begin
  ContProcess := (Answer <> cmCancel);
  CheckAnswer := (Answer = cmOK);
end;

{Confirm the deletion of the current file
  Input : Panel: the panel the file is being deleted in
          FileType: determines whether the file is a file or a directory
  Output: when True, the answer was to delete the file}
function ConfirmDelete(Panel: PPanel; const FileType: string): Boolean;
var
  B,
  C             : Byte;
  S             : string[20];
begin
  if DeleteConfirm and not SingleFile then
  begin
    C := ayNone;
    if not SingleFile then C := ayAllNo;
    B := ErrorDown;
    ErrorDown := 0;
    ConfirmDelete := CheckAnswer(SureConfirm(stEmpty, stTheFollowing + FileType +
      ' will be '+ColorChar+'DELETED'+ColorChar+':', Panel^.CopyFullName,
      stEmpty, stEmpty, stDelete, stEmpty, stEmpty, stSkip, stEmpty, nil, CurHelpCtx, C, False, AllDelete));
    ErrorDown := B;
  end
  else
  begin
    ContProcess := not Escape;
    ConfirmDelete := ContProcess;
  end;
end;

{Ask for an extra confirmation about the deletion of the current file if it
  is read-only or write-protected
  Input : Panel: the panel the file is being deleted in
          FileType: determines whether the file is a file or a directory
  Output: when True, the answer was to delete the file}
function ConfirmDeleteReadonly(Panel: PPanel; const FileType: string): Boolean;
var
  S             : string[20];
begin
  if Panel^.CopyMode = pmDOS then S := 'marked read-only' else S := 'write protected';
  ConfirmDeleteReadonly := CheckAnswer(SureConfirm(stEmpty, stTheFollowing + FileType + ' is ' + S + stDot,
    Panel^.CopyFullName, 'Do you still wish to delete it?', stEmpty, stDelete, stEmpty, stEmpty, stSkip, stEmpty, nil,
    CurHelpCtx, ayAllNo, False, AllDeleteReadonly));
end;

{Delete the specified file during file move or delete
  Input : Panel: the panel that holds the file to be deleted
          D: dialog box that informs the user about the process
          FileCopy: when True, deletion is done during file copy
          Over: when True, deletion is done during file overwrite
          Empty: when True, the source file is empty, it may be copied into
                 the destination archive or image file even if another file
                 with the same name already exists in it
          Next: when True, the current file is unselected
  Output: when False, an error occured}
function DeleteFile(Panel: PPanel; var D: PDialog; FileCopy, Over, Empty, Next: Boolean): Boolean;
var
  C,
  F,
  J,
  O,
  Q,
  R             : Boolean;
  G,
  X             : Byte;
  H             : Word;
  I             : Integer;
  U,
  V,
  W,
  L,
  M,
  S,
  E             : Longint;
  P             : PSmallBuf;
  A,
  K             : string[20];
  N,
  Y             : string;
  Z             : TZIPEntry;

function ShutAfterDelete: Boolean;
var
  O             : Boolean;
begin
  O := (not Over and (Panel^.CopyImageSize <= 1));
  if O then
  begin
    ShutImage := True;
    Panel^.CloseImage(False);
    LongErase(Panel^.Image.LongName);
    ContProcess := False;
    F := False;
  end;
  ShutAfterDelete := O;
end;

begin
  O := ((Panel^.CopyMode <> pmDOS) and (Panel^.CopyAttr and faTypeMask = faPartition) and
    (Panel^.CopyExtAttr and xaDirectory > 0));
  X := drFile;
  K := stFile;
  if O then
  begin
    X := drDirectory;
    K := stDirectory;
  end;
  O := True;
  J := False;
  R := False;
  Q := False;
  Y := AddToPath(Panel^.CopyPath, Panel^.CopyName, chDirSep);
  while not Q do
  begin
    if J then
    begin
      if FileCopy and Over then
      begin
        if Panel^.CopyMode = pmDOS then N := 'read-only' else N := 'write protected';
        if AppendFile then A := 'append' else A := 'overwrite';
        O := CheckAnswer(SureConfirm(stEmpty, Panel^.CopyFullName, 'is a ' + N + stSpace + K + stDot,
          'Do you still wish to ' + A + ' it?', stEmpty, stYes, stEmpty, stEmpty, stSkip, stEmpty, nil, CurHelpCtx,
          ayAllNo, True, AllOverwriteReadonly));
      end
      else
      begin
        O := ConfirmDeleteReadonly(Panel, K);
      end;
      if O then
      begin
        case Panel^.CopyMode of
          pmDOS:
          begin
            FailSysErrors := fsAll;
            LongSetFAttr(Y, Panel^.CopyAttr and not ReadOnly);
            FailSysErrors := fsNone;
          end;
          pmExt:
          begin
            if SendDriveProg(deBase, True) and SendDriveProg(deAttrib, False) then
              ExecDriveProg(deAttrib, #0 + #$80 + '0:' + Panel^.CopyName + '=' +
              UpCase(ShortCBMExt[Panel^.CopyAttr and faTypeMask][1]));
          end;
        else
          Panel^.CopyAttr := Panel^.CopyAttr and not faWriteProt;
        end;
      end
      else
      begin
        Q := True;
      end;
    end
    else
    begin
      if Panel^.CopyMode in [pmGCRDisk..pmSixZip] then
      begin
        if not ErrorWin(stEmpty, 'Can''t delete from a ' + MakeFullTypeStr(Panel^.CopyMode) + stDot,
          Panel^.CopyFullName, CurHelpCtx, sbNone) then ContProcess := False;
        O := False;
        Q := True;
      end;
      if O then
      begin
        if FileCopy then
        begin
          if Over then
          begin
            A := '';
            if Inact^.CopyMode = pmDOS then A := ' a'+ColorChar+'P'+ColorChar+'pend ' else
              if GetPanelModeAttrib(Inact^.CopyMode, paDupeFiles) then
                A := ' co'+ColorChar+'P'+ColorChar+'y anyway ';
            H := SureConfirm(stEmpty, stTheFollowing + K + ' already exists', Panel^.CopyFullName,
              'Do you wish to write over the old ' + K + '?', stEmpty, stOverwrite, A, ' '+ColorChar+'R'+ColorChar+'ename ',
              stSkip, stEmpty, nil, CurHelpCtx, ayAllNo, False, AllOverwrite);
            if H = cmExtra2 then
            begin
              H := ManualFilename(D, False);
              case H of
                cmOK:
                begin
                  Q := True;
                  H := cmExtra2;
                end;
                cmCancel: H := cmSkip;
              end;
              TransferProgressWin(D, stEmpty, Act^.CopyFullName, Inact^.CopyFullName, drFile, True);
            end;
            O := (H in [cmOK, cmExtra, cmExtra2]);
            AppendFile := (H = cmExtra);
            ContProcess := (H <> cmCancel);
          end;
        end
        else
        begin
          O := ConfirmDelete(Panel, K);
        end;
      end;
    end;
    R := R or J;
    J := False;
    if O and not Q then
    begin
      if Panel^.CopyMode = pmDOS then
      begin
        if Act^.Error then
        begin
          ContProcess := False;
          O := False;
          Q := True;
        end
        else
        begin
          if ContProcess then
          begin
            if AppendFile then
            begin
              LongGetFAttr(Y, H);
              if H and ReadOnly = 0 then Q := True else J := True;
            end
            else
            begin
              SysErrorOccurred := False;
              if not FileCopy then TransferProgressWin(D, stEmpty, Panel^.CopyFullName, stEmpty, X, False);
              LongErase(Y);
              I := IOResult;
              case I of
                0:
                begin
                  FileProcessed := True;
                  Q := True;
                end;
                5:
                begin
                  LongGetFAttr(Y, H);
                  if H and ReadOnly > 0 then
                  begin
                    I := 0;
                    if R then I := deAccessDenied;
                    J := True;
                  end
                  else
                  begin
                    O := False;
                    Q := True;
                  end;
                end;
              end;
              if I <> 0 then
              begin
                if SysErrorOccurred then ContProcess := False else
                  ContProcess := ErrorWin(stEmpty, 'Can''t delete the ' + K, Panel^.CopyFullName, CurHelpCtx, sbNone);
                O := False;
                Q := True;
              end;
            end;
          end;
        end;
      end
      else
      begin
        if not FileCopy then TransferProgressWin(D, stEmpty, Panel^.CopyFullName, stEmpty, X, False);
        FileProcessed := True;
        if Panel^.CopyMode = pmExt then
        begin
          O := False;
          if not Over and not CanDeleteFile(Panel) then
          begin
            Q := True;
          end
          else
          begin
            MouseOff;
            O := True;
            case CopyCmdExecMode of
              cxNormal: OpenCBMChannel(saCommand, 'S0:' + Panel^.CopyName, True);
              cxTurbo, cxWarp:
              begin
                O := (SendDriveProg(deBase, True) and SendDriveProg(deTurboFileDelete, False) and
                  ExecDriveProg(deTurboFileDelete, '0:' + Panel^.CopyName));
              end;
            end;
            DiskChanged := True;
            O := ReadCBMError(N, False, False, True);
            if (N <> '') and (not O or ((Copy(N, 1, 2) = '01') and (Copy(N, 21, 2) <> '01'))) then
            begin
              if O then
              begin
                J := True;
              end
              else
              begin
                ContProcess := ErrorWin(stError, N, stEmpty, CurHelpCtx, sbSkip);
                Q := True;
              end;
            end
            else
            begin
              Q := True;
            end;
          end;
        end
        else
        begin
          if AppendFile then
          begin
            Q := True;
          end
          else
          begin
            Panel^.CopyBackupFile(True);
            if Panel^.OpenImage(False, False, True, True, True) = 0 then
            begin
              if Panel^.ImageReadOnly then
              begin
                Panel^.CloseImage(False);
                ContProcess := ErrorWin(stEmpty, 'The following image file is marked read-only.',
                  Panel^.CopyImageName, CurHelpCtx, sbNone);
                Q := True;
                O := False;
              end
              else
              begin
                if (Panel^.CopyMode = pmDisk) and not Panel^.IsBAMValid then
                begin
                  Panel^.CloseImage(False);
                  ContProcess := ErrorWin(stEmpty, 'The following image file has an invalid BAM',
                    Panel^.CopyImageName, CurHelpCtx, sbNone);
                  Q := True;
                  O := False;
                end
                else
                begin
                  Panel^.CloseImage(False);
                  if not J and (Panel^.CopyAttr and faWriteProt > 0) then
                  begin
                    J := True;
                  end
                  else
                  begin
                    if Panel^.OpenImage(True, False, True, True, True) = 0 then
                    begin
                      S := Panel^.HeaderPos;
                      M := Panel^.ImagePos;
                      L := S;
                      F := Panel^.SeekToNextFile(S);
                      if F then
                      begin
                        E := Panel^.HeaderPos;
                        case Panel^.CopyMode of
                          pmDisk:
                          begin
                            G := FirstDirSec(Panel^.CopyDiskType);
                            if (Entry.Track <> Panel^.DirTrack) or (Entry.Sector > G) then
                            begin
                              if Entry.Attr and faClosed > 0 then Panel^.Validate(alFree,
                                ((Panel^.DiskType and dtTypeMask = dt1581) and (Entry.Attr and faTypeMask = faPartition)),
                                Entry.ExtAttr and xaGEOSVLIR > 0, False, Entry.Size);
                              Panel^.WriteBAM;
                            end;
                            Panel^.DirBuffer[Panel^.EntryPos + 2] := 0;
                            Panel^.WriteDiskBlock(Panel^.DirTrack, Panel^.DirSector, @Panel^.DirBuffer);
                            Panel^.CloseImage(True);
                            Q := True;
                          end;
                          pmFile:
                          begin
                            ShutAfterDelete;
                            ContProcess := True;
                            O := True;
                            Q := True;
                          end;
                          pmZIP:
                          begin
                            F := True;
                            if F then
                            begin
                              if Panel^.CopyMode = pmZIP then
                              begin
                                O := (LongOpenFile(AddToPath(Panel^.CopyPath, TempFileName, chDirSep),
                                  WriteFile, fmWriteOnly) = 0);
                                if O then
                                begin
                                  TempFileOpen := True;
                                  ExtSeek(Panel^.Image, 0);
                                  H := 0;
                                  L := 0;
                                  M := 0;
                                  while O and (H < Panel^.CopyImageSize) do
                                  begin
                                    O := ReadZIPEntry(Panel^.Image, Z, Y);
                                    if O then
                                    begin
                                      if H = Panel^.DirPos then
                                      begin
                                        M := SizeOf(TZIPEntry) + Z.NameLen + Z.ExtHeadSize + Z.PackSize;
                                        ExtSeek(Panel^.Image, ExtFilePos(Panel^.Image) + Z.ExtHeadSize + Z.PackSize);
                                      end
                                      else
                                      begin
                                        ExtBlockWrite(WriteFile, Z, SizeOf(TZIPEntry));
                                        ExtBlockWrite(WriteFile, Y[1], Z.NameLen);
                                        CopyPart(Panel^.Image, WriteFile, Z.ExtHeadSize + Z.PackSize, TSmallBufSize);
                                      end;
                                    end;
                                    Inc(H);
                                  end;
                                  if O then
                                  begin
                                    H := 0;
                                    while O and (H < Panel^.CopyImageSize) do
                                    begin
                                      O := ReadZIPCDirEntry(Panel^.Image, ZIPEntry, Y);
                                      if O then
                                      begin
                                        if H = Panel^.DirPos then
                                        begin
                                          L := SizeOf(TZIPCDirEntry) + ZIPEntry.NameLen;
                                          ExtSeek(Panel^.Image, ExtFilePos(Panel^.Image) + ZIPEntry.ExtHeadSize +
                                            ZIPEntry.CommentSize);
                                        end
                                        else
                                        begin
                                          if H > Panel^.DirPos then Dec(ZIPEntry.HeaderOffs, M);
                                          ExtBlockWrite(WriteFile, ZIPEntry, SizeOf(TZIPCDirEntry));
                                          ExtBlockWrite(WriteFile, Y[1], ZIPEntry.NameLen);
                                          CopyPart(Panel^.Image, WriteFile, ZIPEntry.ExtHeadSize + ZIPEntry.CommentSize,
                                            TSmallBufSize);
                                        end;
                                      end;
                                      Inc(H);
                                    end;
                                    if O then
                                    begin
                                      Dec(ZIPDirEnd.LocalFileNum);
                                      Dec(ZIPDirEnd.FileNum);
                                      Dec(ZIPDirEnd.DirSize, L);
                                      Dec(ZIPDirEnd.DirOffs, M);
                                      ExtBlockWrite(WriteFile, ZIPDirEnd, SizeOf(TZIPCDirEnd));
                                    end;
                                  end;
                                  if KeepTime then ExtSetFTime(WriteFile, Panel^.FileTime);
                                  ExtClose(WriteFile);
                                end;
                                Panel^.CloseImage(False);
                                if O then
                                begin
                                  LongErase(AddToPath(Panel^.CopyRealPath, Panel^.CopyImageName, chDirSep));
                                  LongRename(WriteFile.LongName, AddToPath(Panel^.CopyRealPath, Panel^.CopyImageName,
                                    chDirSep));
                                end;
                              end;
                            end;
                            Q := True;
                          end;
                          pmTape, pmTAR, pmLHA:
                          begin
                            P := New(PSmallBuf);
                            if Panel^.CopyMode = pmTape then
                            begin
                              H := Panel^.DirPos;
                              FillChar(P^, Panel^.CopyImageSize shl 5 + 64, 0);
                              V := 0;
                              ExtSeek(Panel^.Image, 0);
                              for I := 0 to Panel^.CopyImageSize + 1 do
                              begin
                                ExtBlockRead(Panel^.Image, DataBuffer, 32);
                                if I = 1 then Dec(DataBuffer[4]);
                                if I = H + 1 then
                                begin
                                  if DataBuffer[0] = 0 then E := ExtFileSize(Panel^.Image) else
                                    E := BytesToLongint(DataBuffer[8], DataBuffer[9], DataBuffer[10], DataBuffer[11]);
                                  M := E - S;
                                end;
                                if (I > H) and (DataBuffer[0] > 0) then
                                begin
                                  L := BytesToLongint(DataBuffer[8], DataBuffer[9], DataBuffer[10], DataBuffer[11]) - M;
                                  DataBuffer[8] := L;
                                  DataBuffer[9] := L shr 8;
                                  DataBuffer[10] := L shr 16;
                                  DataBuffer[11] := L shr 24;
                                end;
                                if I <> H then
                                begin
                                  Move(DataBuffer, P^[V], 32);
                                  Inc(V, 32);
                                end
                                else
                                begin
                                  S := BytesToLongint(DataBuffer[8], DataBuffer[9], DataBuffer[10], DataBuffer[11]);
                                end;
                              end;
                              ExtSeek(Panel^.Image, 0);
                              ExtBlockWrite(Panel^.Image, P^, Panel^.CopyImageSize shl 5 + 64);
                              if H = Panel^.CopyImageSize + 1 then E := ExtFileSize(Panel^.Image);
                              F := True;
                            end
                            else
                            begin
                              F := True;
                              Panel^.ReadCBMEntry(Entry);
                              ShutAfterDelete;
                            end;
                            if F then
                            begin
                              L := 0;
                              M := ExtFileSize(Panel^.Image) - E;
                              if M = 0 then
                              begin
                                ExtSeek(Panel^.Image, S);
                              end
                              else
                              begin
                                while L < M do
                                begin
                                  if M - L > TSmallBufSize then V := TSmallBufSize else V := M - L;
                                  ExtSeek(Panel^.Image, E + L);
                                  ExtBlockRead(Panel^.Image, P^, V);
                                  ExtSeek(Panel^.Image, S + L);
                                  ExtBlockWrite(Panel^.Image, P^, V);
                                  Inc(L, V);
                                end;
                              end;
                              ExtTruncate(Panel^.Image);
                              Panel^.CloseImage(True);
                            end;
                            Dispose(P);
                            Q := True;
                          end;
                          pmLynx, pmArkive, pmFileZip:
                          begin
                            if (Panel^.CopyMode = pmFileZip) or not ShutAfterDelete then
                            begin
                              if Panel^.CopyMode = pmLynx then V := Panel^.LastLynxEnd else V := Panel^.ImagePos;
                              Panel^.ReadCBMEntry(Entry);
                              W := Panel^.ImagePos;
                              while Panel^.ReadCBMEntry(Entry) do;
                              if Panel^.CopyMode = pmFileZip then
                              begin
                                U := Panel^.ImagePos;
                                while O and (W < U) do
                                begin
                                  if Panel^.OpenZipFile(WriteFile, V, 0, fmReadWrite) = 0 then
                                  begin
                                    SeekToFileZipBlock(WriteFile, V mod FileZipBlocks);
                                    ExtSeek(WriteFile, ArcPos);
                                    if Panel^.OpenZipFile(TempFile, W, 0, fmReadOnly) = 0 then
                                    begin
                                      ExtGetFTime(WriteFile, Panel^.FileTime);
                                      SeekToFileZipBlock(TempFile, W mod FileZipBlocks);
                                      C := True;
                                      while O and C and (W < U) do
                                      begin
                                        O := ReadZipCodeBlock(TempFile, @DataBuffer, True, zrOriginal,
                                          DummyByte, DummyByte, H);
                                        ExtBlockWrite(WriteFile, DataBuffer, H);
                                        Inc(V);
                                        Inc(W);
                                        C := ((V mod FileZipBlocks > 0) and (W mod FileZipBlocks > 0));
                                      end;
                                      ExtClose(TempFile);
                                    end;
                                    if KeepTime then ExtSetFTime(WriteFile, Panel^.FileTime);
                                    ExtClose(WriteFile);
                                  end;
                                end;
                                if O then
                                begin
                                  G := V mod FileZipBlocks;
                                  if (V > 0) and (Panel^.OpenZipFile(WriteFile, V, 0, fmReadWrite) = 0) then
                                  begin
                                    ExtGetFTime(WriteFile, Panel^.FileTime);
                                    ExtSeek(WriteFile, 2);
                                    ExtBlockWrite(WriteFile, G, 1);
                                    SeekToFileZipBlock(WriteFile, G);
                                    ExtSeek(WriteFile, ArcPos);
                                    ExtTruncate(WriteFile);
                                    if KeepTime then ExtSetFTime(WriteFile, Panel^.FileTime);
                                    ExtClose(WriteFile);
                                  end;
                                  G := V div FileZipBlocks;
                                  if V mod FileZipBlocks > 0 then Inc(G);
                                  Panel^.CopyImageName[1] := Chr(Ord('a') + (U div FileZipBlocks));
                                  while (Panel^.CopyImageName[1]) >= Chr(G + Ord('a')) do
                                  begin
                                    LongErase(AddToPath(Panel^.CopyPath, Panel^.CopyImageName, chDirSep));
                                    Dec(Panel^.CopyImageName[1]);
                                  end;
                                  if not ShutAfterDelete then
                                  begin
                                    ExtSeek(Panel^.Image, 511);
                                    ExtBlockWrite(Panel^.Image, G, 1);
                                    G := Panel^.CopyImageSize - 1;
                                    ExtBlockWrite(Panel^.Image, G, 1);
                                    M := Panel^.OrigSize - E;
                                    if M > 0 then
                                    begin
                                      ExtSeek(Panel^.Image, E);
                                      ExtBlockRead(Panel^.Image, TempBuffer, M);
                                    end;
                                    ExtSeek(Panel^.Image, S);
                                    if M > 0 then ExtBlockWrite(Panel^.Image, TempBuffer, M);
                                    ExtTruncate(Panel^.Image);
                                  end;
                                end;
                                Panel^.CloseImage(True);
                              end
                              else
                              begin
                                U := Panel^.HeaderPos;
                                if LongOpenFile(AddToPath(Panel^.CopyRealPath, ArcTempOutput, chDirSep),
                                  WriteFile, fmWriteOnly) = 0 then
                                begin
                                  TempOutputOpen := True;
                                  ExtSeek(Panel^.Image, 0);
                                  G := Panel^.CopyImageSize - 1;
                                  case Panel^.CopyMode of
                                    pmLynx:
                                    begin
                                      ExtBlockRead(Panel^.Image, TempBuffer, LynxCountPos);
                                      ExtSeek(Panel^.Image, L);
(* ?ASM? *)
                                      asm
                                        mov ax, word ptr U[0];
                                        add ax, word ptr S[0];
                                        sub ax, word ptr E[0];
                                        xor dx, dx;
                                        mov cx, 254;
                                        div cx;
                                        or dx, dx;
                                        je @1;
                                        inc ax;
                                    @1: xor dx, dx;
                                        mov si, LynxBlockPos;
                                        mov cx, 10;
                                        xor di, di;
                                        call WriteNum;
                                        mov byte ptr TempBuffer[si], ' ';
                                        mov al, G;
                                        xor ah, ah;
                                        xor dx, dx;
                                        mov si, LynxCountPos;
                                        mov cx, 10;
                                        xor di, di;
                                        call WriteNum;
                                        mov byte ptr TempBuffer[si], chReturn;
                                        inc si;
                                        mov H, si;
                                      end;
                                      ExtBlockRead(Panel^.Image, TempBuffer[H], S - L);
                                      S := H + (S - L);
                                    end;
                                    pmArkive:
                                    begin
                                      ExtBlockRead(Panel^.Image, TempBuffer, S);
                                      TempBuffer[0] := G;
                                    end;
                                  end;
                                  ExtBlockWrite(WriteFile, TempBuffer, S);
                                  ExtSeek(Panel^.Image, E);
                                  CopyPart(Panel^.Image, WriteFile, U - E, TSmallBufSize);
                                  AddPadding(WriteFile, 254);
                                  ExtSeek(Panel^.Image, M);
                                  CopyPart(Panel^.Image, WriteFile, V - M, TSmallBufSize);
                                  M := ExtFileSize(Panel^.Image);
                                  if W < M then
                                  begin
                                    if Panel^.CopyMode = pmLynx then AddPadding(WriteFile, 254);
                                    ExtSeek(Panel^.Image, W);
                                    CopyPart(Panel^.Image, WriteFile, M - W, TSmallBufSize);
                                  end;
                                  if KeepTime then ExtSetFTime(WriteFile, Panel^.FileTime);
                                  ExtClose(WriteFile);
                                end;
                                Panel^.CloseImage(False);
                                LongErase(AddToPath(Panel^.CopyRealPath, Panel^.CopyImageName, chDirSep));
                                LongRename(WriteFile.LongName, AddToPath(Panel^.CopyRealPath, Panel^.CopyImageName, chDirSep));
                              end;
                            end;
                            Q := True;
                          end;
                        end;
                      end
                      else
                      begin
                        Panel^.CloseImage(False);
                        ContProcess := ErrorWin(stEmpty, 'Can''t find the file', Panel^.CopyFullName, CurHelpCtx, sbNone);
                        O := False;
                        Q := True;
                      end;
                    end;
                  end;
                end;
              end;
            end;
          end;
        end;
      end;
    end
    else
    begin
      Q := True;
    end;
  end;
  if Next then
  begin
    if O then FindNextUndel(Panel);
    UnselectFile(Panel, O);
    if (CopyFileMode in [cfWildcard, cfAutomatic]) and (Panel = Act) then Dec(Panel^.CopyDirPos);
  end;
  DeleteFile := O;
end;

{Delete the specified directory and all of its subdirectories during file
  move or delete
  Input : Panel: the panel that holds the directory to be deleted
          D: dialog box that informs the user about the process
          FileCopy: when True, deletion is done during file copy
          Next: when True, the current file is unselected
  Output: when False, an error occured}
function DeleteDir(Panel: PPanel; var D: PDialog; FileCopy, Next: Boolean): Boolean;
var
  O             : Boolean;
  B             : Byte;
  W             : Word;
  E             : SearchRec;
begin
  W := Panel^.CopyEntry.LongHandle;
  E := Panel^.CopyEntry.Orig;
  B := CopyFileMode;
  EnterDir(Panel);
  O := DirEmpty(Panel);
  if not O and not FileCopy then
  begin
    if AllFiles(Panel^.NamePattern) then
    begin
      TransferProgressWin(D, stEmpty, Panel^.CopyPath, stEmpty, drSubdir, False);
      O := (SureConfirm(stEmpty, 'The following subdirectory is not empty.', Act^.CopyPath,
        'Do you still wish to delete it?', stEmpty, stDelete, stEmpty, stEmpty, stEmpty, stEmpty, nil,
        CurHelpCtx, ayAllNo, False, AllDeleteDir) = cmOK);
    end
    else
    begin
      O := True;
    end;
  end;
  if O then
  begin
    while ContDirProcess and ContProcess and not Panel^.Error do
    begin
      ContDirProcess := Panel^.FindNextFile(False, True, False);
      Panel^.CopyAttr := Panel^.CopyEntry.Orig.Attr;
      if ContDirProcess then
      begin
        Panel^.MakeFullName;
        if Panel^.CopyAttr and Directory > 0 then
        begin
          if not DeleteDir(Panel, D, FileCopy, False) then O := False;
          CopyFileMode := cfWildcard;
          Panel^.FirstFile := False;
        end
        else
        begin
          if not DeleteFile(Panel, D, FileCopy, False, False, False) then O := False;
        end;
      end;
    end;
    O := O and not EscPressed;
  end;
  CopyFileMode := B;
  if O and AllFiles(Panel^.NamePattern) then
  begin
    if DirEmpty(Panel) then
    begin
      TransferProgressWin(D, 'Delete', Panel^.CopyPath, stEmpty, drSubdir, False);
      LongRmDir(Panel^.CopyPath);
      O := (IOResult = 0);
    end;
    if O then
    begin
      FileProcessed := True;
      if O and Next then FindNextUndel(Panel);
    end
    else
    begin
      ErrorWin(stEmpty, 'Can''t delete the subdirectory', Panel^.CopyPath, CurHelpCtx, sbNone);
    end;
  end;
  Panel^.CopyEntry.LongHandle := W;
  Panel^.CopyEntry.Orig := E;
  LeaveDir(Panel);
  DeleteDir := O;
end;

end.
