
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                   FRCLOSE.PAS                   }
{                                                 }
{     The Star Commander close input file unit    }
{*************************************************}

unit FRClose;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

procedure CloseRead;

implementation

uses
  Views,
  Base1, Base2, Constant, ExtFiles, Panel1, Panel2, XferLo;

{Close the input file}
procedure CloseRead;
var
  I             : Integer;
  S             : string;
begin
  with Act^ do
  begin
    if FileOpen and (ExecMode = exNormal) then
    begin
      case CopyMode of
        pmDOS:
        begin
          ExtClose(ReadFile);
          I := IOResult;
        end;
        pmExt:
        begin
          if CopyTransferMode = tmNormal then
          begin
            Untalk;
          end
          else
          begin
            if TurboOn then TurboOff;
          end;
          CloseCBMChannel(saLoad);
          if not ReadCBMError(S, False, False, True) then
          begin
            ContProcess := ErrorWin(stError, S, stEmpty, CurHelpCtx, sbSkip);
            Error := True;
          end;
        end;
      else
        CloseImage(False);
        I := IOResult;
      end;
    end;
    FirstCopyFile := False;
  end;
end;

end.
