
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                    FREAD.PAS                    }
{                                                 }
{     The Star Commander read input file unit     }
{*************************************************}

unit FRead;

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  Base2;

procedure ReadPart(Buffer: PBuffer; var Len: Word);

implementation

uses
  DOS, Objects, Views,
  Base1, Constant, ExtFiles, LowLevel, Panel1, Panel2, XferLo;

{Read a buffer of data from the input file
  Input : Buffer: buffer to contain the data read
          Len: length of the data read}
procedure ReadPart(Buffer: PBuffer; var Len: Word);
var
  F,
  H,
  L,
  V             : Boolean;
  M,
  P,
  Q,
  B,
  T,
  S             : Byte;
  W             : Word;
  I             : Integer;
  X             : Longint;
  E             : PWord;
  N             : string;
  R             : TRect;
  D             : DateTime;

procedure GetNextLink;
begin
  with Act^ do
  begin
    InOutRes := 0;
    if H and (Track = 0) then
    begin
      if CopyExtAttr and xaGEOSVLIR = 0 then
      begin
        _End := True;
      end
      else
      begin
        while (SidePos > 0) and (SideBuffer[SidePos] = 0) do Inc(SidePos, 2);
        if SidePos = 0 then
        begin
          _End := True;
        end
        else
        begin
          Track := SideBuffer[SidePos];
          Sector := SideBuffer[SidePos + 1];
          Inc(SidePos, 2);
        end;
      end;
    end;
  end;
end;

begin
  with Act^ do
  begin
    Len := 0;
    I := 0;
    FillChar(Buffer^, CopyBufSize, 0);
    if ExecMode = exNormal then
    begin
      L := CancelTransfer(CopyMode = pmExt);
      if L then
      begin
        Error := True;
        ContProcess := False;
      end
      else
      begin
        case CopyMode of
          pmDOS:
          begin
            ExtBlockRead2(ReadFile, Buffer^, CopyBufSize, Len);
            Error := (IOResult <> 0);
            _End := Error or ExtEOF(ReadFile);
          end;
          pmExt:
          begin
            Len := 0;
            X := 0;
            T := 1;
            R.Assign(9, 4, 11, 1);
            case CopyTransferMode of
              tmNormal:
              begin
                L := CancelTransfer(True);
                while (Status = 0) and not L and (Len < CopyBufSize) do
                begin
                  DisplayProgress;
                  X := Len + 254;
                  asm
                    les di, Len;
                    mov bx, es:[di];
                    les di, Buffer;
                @2: cmp Status, 0;
                    jne @1;
                    cmp bx, word ptr X;
                    jae @1;
                    push bx;
                    call Receive;
                    pop bx;
                    mov es:[di][bx], al;
                    inc bx;
                    jmp @2;
                @1: les di, Len;
                    mov es:[di], bx;
                  end;
                  L := CancelTransfer(True);
                  Inc(CopiedBlock);
                end;
                Error := (L or (Status and not ssEOF > 0));
                _End := Error or (Status and ssEOF > 0);
              end;
              tmTurbo:
              begin
                if FirstBlock then
                begin
                  TurboOn := (SendDriveProg(deTurboFileLoad, True) and
                    ExecDriveProg(deTurboFileLoad, Chr(Track) + Chr(Sector)));
                  Error := not TurboOn;
                end
                else
                begin
                  Error := False;
                end;
                if not Error then
                begin
                  L := CancelTransfer(True);
                  while (T > 0) and (Status = 0) and not L and (Len < CopyBufSize) do
                  begin
                    DisplayProgress;
                    asm
                      push word ptr CopyPriorityMode;
                      call InterruptOff;
                      call ParallelInput;
                      call TReceive;
                      mov T, al;
                      call TReceive;
                      mov S, al;
                    end;
                    X := Len;
                    if T > 0 then Inc(X, 254) else if S > 1 then Inc(X, S - 1);
                    asm
                      les di, Len;
                      mov bx, es:[di];
                      les di, Buffer;
                  @2: cmp Status, 0;
                      jne @1;
                      cmp bx, word ptr X;
                      jae @1;
                      push bx;
                      call TReceive;
                      pop bx;
                      mov es:[di][bx], al;
                      inc bx;
                      jmp @2;
                  @1: les di, Len;
                      mov es:[di], bx;
                      call InterruptOn;
                    end;
                    L := CancelTransfer(True);
                    Inc(CopiedBlock);
                  end;
                end;
                Error := Error or (L or (Status and not ssEOF > 0));
                _End := Error or (T = 0);
              end;
              tmWarp:
              begin
                Len := 0;
                GCRError := 0;
                F := False;
                V := FirstBlock;
                W := CopyBufSize div 254;
                while not Error and not L and (W > 0) do
                begin
                  if V or F then
                  begin
                    V := False;
                    if SendDriveProg(deWarpFileLoad, True) then
                    begin
                      if F then
                      begin
                        I := SectorNum(T);
                        Move(TrackMap, N[5], I);
                        N[0] := Chr(I + 4);
                        N[1] := Chr(W);
                        N[2] := Chr(T);
                        N[3] := Chr(B);
                        N[4] := Chr(P);
                      end
                      else
                      begin
                        N[0] := #2;
                        N[1] := Chr(W);
                        N[2] := #0;
                      end;
                      ExecDriveProg(deWarpFileLoad, N);
                    end;
                    Error := (Status > 0);
                  end
                  else
                  begin
                    Error := False;
                  end;
                  if not Error then
                  begin
                    L := CancelTransfer(True);
                    asm
                      push word ptr CopyPriorityMode;
                      call InterruptOff;
                      call ParallelInput;
                      call TReceive;
                      cmp Status, 0;
                      jne @1;
                      mov T, al;
                      call TReceive;
                      mov B, al;
                      call TReceive;
                      mov P, al;
                      cmp F, False;
                      jne @1;
                      mov Q, al;
                  @1: call InterruptOn;
                    end;
                    F := False;
                    while (P > 0) and (Status = 0) and not L do
                    begin
                      asm
                        push word ptr CopyPriorityMode;
                        call InterruptOff;
                        mov si, 326;
                        call TReceive;
                        mov ah, Status;
                        or ah, ah;
                        jne @1;
                        mov S, al;
                        call TReceive;
                        mov M, al;
                        dec W;
                        xor ah, ah;
                        mov di, Offset(TrackMap);
                        mov bl, S;
                        xor bh, bh;
                        mov byte ptr [di][bx], $80;
                        mov di, Offset(GCRMap);
                        mov bl, al;
                        mov dl, S;
                        mov [di][bx], dl;
                        mul si;
                        mov di, ax;
                        add di, Offset(GCRBuffer);
                    @2: call TReceive;
                        mov [di], al;
                        inc di;
                        dec si;
                        jne @2;
                    @1: call InterruptOn;
                      end;
                      if Status = 0 then
                      begin
                        Inc(CopiedBlock);
                        DisplayProgress;
                        L := CancelTransfer(True);
                        Dec(P);
                      end;
                    end;
                    if Status <> 0 then
                    begin
                      TurboOff;
                      CloseCBMChannel(saLoad);
                      if not ReadCBMError(N, False, False, True) then
                      begin
                        if DiskErrorWin(stError, N, stEmpty, CurHelpCtx, False, False, False) = cmOK then
                        begin
                          F := True;
                        end
                        else
                        begin
                          Error := True;
                          ContProcess := False;
                        end;
                      end;
                    end;
                    if not F and not Error then
                    begin
                      if (Status = 0) and not L then
                      begin
                        X := 0;
                        GCRError := 0;
(* ?ASM? *)
                        asm
                          xor bx, bx;
                          mov P, 1;
                          mov si, Offset(GCRBuffer);
                      @4: push bx;
                          mov di, Offset(GCRMap);
                          mov al, [di][bx];
                          mov S, al;
                          mov di, Offset(TempBuffer);
                          add di, word ptr X;
                          push di;
                          call GCRDecodeSector;
                          pop di;
                          pop bx;
                          cmp GCRError, 0;
                          jne @1;
                          cmp byte ptr [di], 0;
                          jne @7;
                          mov P, 0;
                          jmp @8;
                      @7: add word ptr X, 256;
                          inc bx;
                          cmp bl, Q;
                          jb @4;
                      @8: xor bx, bx;
                          mov word ptr X, bx;
                      @6: mov cx, 254;
                          mov si, Offset(TempBuffer);
                          add si, word ptr X;
                          les di, Len;
                          mov di, es:[di];
                          add di, word ptr Buffer[0];
                          mov es, word ptr Buffer[2];
                          cmp byte ptr [si], 0;
                          jne @2;
                          mov cl, [si][1];
                          cmp cl, 2;
                          jb @5;
                          dec cl;
                      @2: push es;
                          push di;
                          les di, Len;
                          add es:[di], cx;
                          pop di;
                          pop es;
                          add si, 2;
                      @3: cld;
                          rep movsb;
                      @5: add word ptr X, 256;
                          inc bx;
                          cmp bl, Q;
                          jb @6;
                      @1:
                        end;
                      end;
                      if GCRError = 0 then
                      begin
                        RetryCount := RetryNum + 1;
                        F := False;
                        FillChar(TrackMap, TrackMapSize + 1, 0);
                        if P = 0 then W := 0;
                      end
                      else
                      begin
                        TurboOff;
                        CloseCBMChannel(saLoad);
                        Dec(CopiedBlock);
                        DisplayProgress;
                        Inc(W);
                        TrackMap[S] := 0;
                        Dec(RetryCount);
                        if RetryCount > 0 then
                        begin
                          F := True;
                        end
                        else
                        begin
                          case DiskErrorWin(stError, ReadErrorStr(GCRError, T, S), stEmpty, CurHelpCtx,
                            True, False, False) of
                            cmOK:
                            begin
                              if RetryCount = 0 then RetryCount := RetryNum + 1;
                              F := True;
                            end;
                            cmNo: Error := True;
                            cmCancel:
                            begin
                              Error := True;
                              ContProcess := False;
                            end;
                          end;
                        end;
                      end;
                    end;
                  end;
                end;
                Error := Error or (L or (Status and not ssEOF > 0));
                _End := Error or (P = 0);
              end;
            end;
            if L then ContProcess := False;
          end;
          pmDisk, pmDiskZip:
          begin
            Len := 0;
            if (Track = 0) or ((Track = DirTrack) and (Sector <= FirstDirSec(CopyDiskType))) then
            begin
              _End := True;
            end
            else
            begin
              if FirstBlock and (CopyExtAttr > 0) then
              begin
                Len := 2 * 254;
                Inc(CopySize, Len);
                CopiedSize := Len;
                FillChar(Buffer^, Len, 0);
                Move(DirBuffer[EntryPos + 2], Buffer^, 30);
                Buffer^[1] := 0;
                Buffer^[2] := 0;
                Buffer^[19] := 0;
                Buffer^[20] := 0;
                Move(ConvertSign[1], Buffer^[30], Length(ConvertSign));
                ReadDiskBlock(DirBuffer[EntryPos + 21], DirBuffer[EntryPos + 22], @DataBuffer, True);
                I := IOResult;
                if I = 0 then
                begin
                  E := @D;
                  for P := 0 to 4 do
                  begin
                    E^ := DirBuffer[EntryPos + 25 + P];
                    Inc(E);
                  end;
                  if D.Year < 80 then Inc(D.Year, 100);
                  Inc(D.Year, 1900);
                  D.Sec := 0;
                  PackTime(D, FileTime);
                  Move(DataBuffer[2], Buffer^[254], 254);
                  if CopyExtAttr and xaGEOSVLIR > 0 then
                  begin
                    Inc(Len, 254);
                    ReadDiskBlock(Track, Sector, @SideBuffer, True);
                    I := IOResult;
                    if I = 0 then
                    begin
                      SidePos := 2;
                      while SidePos > 0 do
                      begin
                        T := SideBuffer[SidePos];
                        S := SideBuffer[SidePos + 1];
                        B := 0;
                        while (T > 0) do
                        begin
                          Inc(B);
                          ReadDiskBlock(T, S, @DataBuffer, True);
                          T := DataBuffer[0];
                          S := DataBuffer[1];
                        end;
                        if B > 0 then
                        begin
                          SideBuffer[SidePos] := B;
                          SideBuffer[SidePos + 1] := S;
                        end;
                        Inc(SidePos, 2);
                      end;
                      Move(SideBuffer[2], Buffer^[254 * 2], 254);
                      ReadDiskBlock(Track, Sector, @SideBuffer, True);
                      I := IOResult;
                      if I = 0 then
                      begin
                        SidePos := 2;
                        Track := 0;
                        GetNextLink;
                      end;
                    end;
                  end;
                end;
              end;
              H := (CopyExtAttr and xaGEOSVLIR > 0);
              while (Len < CopyBufSize) and (Track > 0) and (I = 0) do
              begin
                ReadDiskBlock(Track, Sector, @DataBuffer, True);
                I := IOResult;
                if I = 0 then
                begin
                  Track := DataBuffer[0];
                  Sector := DataBuffer[1];
                  if Track > 0 then
                  begin
                    M := 254;
                  end
                  else
                  begin
                    M := Sector - 1;
                    if H then FillChar(Buffer^[Len], 254, 0);
                    _End := not H;
                  end;
                  Move(DataBuffer[2], Buffer^[Len], M);
                  if H then Inc(Len, 254) else Inc(Len, M);
                  Inc(CopiedSize, 254);
                  DisplayProgress;
                  if not ValidPos(Track, Sector) then
                  begin
                    ContProcess := ErrorWin(stEmpty, 'There is an invalid sector link in', CopyImageName,
                      CurHelpCtx, sbNone);
                    Track := 0;
                    Error := True;
                  end;
                end;
              end;
              GetNextLink;
              if H and _End then Dec(Len, 254 - M);
            end;
            Error := Error or (I <> 0);
            _End := Error or _End;
          end;
          pmTape:
          begin
            if ImagePos - ExtFilePos(Image) > CopyBufSize then Len := CopyBufSize else Len := ImagePos - ExtFilePos(Image);
            X := CopyBufSize;
            if FirstBlock then
            begin
              Buffer^[0] := StartLo;
              Buffer^[1] := StartHi;
              Buffer := @Buffer^[2];
              Dec(X, 2);
            end;
            if Len > X then Len := X;
            ExtBlockRead(Image, Buffer^, Len);
            if FirstBlock then Inc(Len, 2);
            Error := (IOResult <> 0);
            _End := Error or (ExtFilePos(Image) = ImagePos);
          end;
          pmFile, pmLynx..pmFileZip:
          begin
            case CopyMode of
              pmFileZip:
              begin
                X := ImagePos;
                while not Error and not _End and (Len < CopyBufSize) do
                begin
                  Error := (OpenZipFile(Image, ImagePos, ArcPos, fmReadOnly) <> 0);
                  if not Error then
                  begin
                    L := False;
                    V := True;
                    while not L and V and (Len < CopyBufSize) do
                    begin
                      V := ReadZipCodeBlock(Image, @Buffer^[Len], True, zrUncompress, T, S, W);
                      Inc(Len, W);
                      L := (T = 0);
                      Inc(X);
                      if X mod FileZipBlocks = 0 then break;
                    end;
                    ImagePos := X;
                    if ImagePos mod FileZipBlocks = 0 then ArcPos := 0;
                    Error := not V;
                    _End := L or not V;
                  end;
                end;
              end;
            else
              if ImagePos - ExtFilePos(Image) > CopyBufSize then Len := CopyBufSize else
                Len := ImagePos - ExtFilePos(Image);
              ExtBlockRead(Image, Buffer^, Len);
              Error := (IOResult <> 0);
              _End := Error or (ExtFilePos(Image) = ImagePos);
            end;
            if Error then ContProcess := ErrorWin(stEmpty, 'The following archive is corrupted.', CopyImageName,
              CurHelpCtx, sbNone);
          end;
        end;
      end;
    end
    else
    begin
      _End := True;
    end;
    if FirstBlock and GEOSSupport then
    begin
      CopyExtAttr := 0;
      if Len >= 2 * 254 then
      begin
        N[0] := #28;
        Move(Buffer^[30], N[1], 30);
        if ((Copy(N, 1, 3) = 'PRG') or (Copy(N, 1, 3) = 'SEQ')) and (Copy(N, 4, MaxStrLen) =
          Copy(ConvertSign, 4, MaxStrLen)) then
        begin
          CopyExtAttr := Buffer^[22];
          if Buffer^[21] > 0 then CopyExtAttr := CopyExtAttr or xaGEOSVLIR;
        end;
      end;
    end;
    FirstBlock := False;
    if CopyMode in [pmDOS, pmTape, pmFile, pmLynx..pmFileZip] then Inc(CopiedSize, Len);
    DisplayProgress;
  end;
end;

end.
